/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.nio.ByteOrder;
import loci.common.ByteArrayHandle;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.meta.MetadataStore;

public class InCell3000Reader
extends FormatReader {
    private long pixelsOffset;

    public InCell3000Reader() {
        super("InCell 3000", "frm");
        this.domains = new String[]{"Unknown"};
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        return false;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        this.in.seek(this.pixelsOffset);
        ByteArrayHandle pixels = new ByteArrayHandle();
        pixels.setOrder(ByteOrder.LITTLE_ENDIAN);
        int count = 0;
        int startValue = 0;
        int totalElements = this.getSizeX() * this.getSizeY() * 2;
        while (pixels.length() < (long)totalElements) {
            short pixel = this.in.readShort();
            if ((pixel & 0xFFFF) > 32768) {
                count = (pixel & 0xFFFF) - 32768;
                startValue = this.in.readShort() & 0xFFFF;
                long fp = this.in.getFilePointer();
                for (int i = 0; i < count; ++i) {
                    this.in.seek(fp + (long)(2 * (i / 3)));
                    int intOfs = this.in.readShort() & 0xFFFF;
                    if (i % 3 != 0) {
                        intOfs >>= 5;
                    }
                    int tempVal = startValue + (intOfs & 0x1F);
                    pixels.writeShort((short)tempVal);
                }
                this.in.seek(fp + (long)(2 * (int)Math.ceil((double)count / 3.0)));
                continue;
            }
            pixels.writeShort((short)(pixel & 0xFFFF));
        }
        pixels.seek(0L);
        RandomAccessInputStream pix = new RandomAccessInputStream(pixels);
        pix.order(this.isLittleEndian());
        this.readPlane(pix, x, y, w, h, buf);
        pix.close();
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.pixelsOffset = 0L;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.core[0].littleEndian = true;
        this.in.order(this.isLittleEndian());
        this.pixelsOffset = this.in.readShort();
        this.core[0].sizeX = this.in.readShort();
        short nLines = this.in.readShort();
        int numPlanes = nLines % 32;
        this.core[0].sizeY = (nLines - numPlanes) / numPlanes;
        int componentType = this.in.read();
        int reserved = this.in.read();
        int timestamp = this.in.readInt();
        int auxiliary = this.in.readInt();
        int relativeTimestamp = this.in.readInt();
        float zSection = this.in.readFloat();
        int componentBytes = this.in.readInt();
        int zero = this.in.read();
        this.core[0].sizeZ = 1;
        this.core[0].sizeC = 1;
        this.core[0].sizeT = 1;
        this.core[0].imageCount = 1;
        this.core[0].pixelType = 3;
        this.core[0].dimensionOrder = "XYCZT";
        this.core[0].rgb = false;
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
    }
}

