/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc.projection;

import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionPointImpl;
import ucar.unidata.util.Format;

public class Stereographic
extends ProjectionImpl {
    private double latt;
    private double lont;
    private double scale;
    private double sinlatt;
    private double coslatt;
    private LatLonPointImpl origin;

    public ProjectionImpl constructCopy() {
        return new Stereographic(this.getTangentLat(), this.getTangentLon(), this.getScale());
    }

    public Stereographic() {
        this(90.0, -105.0, 1.0);
    }

    public Stereographic(double latt, double lont, double scale) {
        this.latt = Math.toRadians(latt);
        this.lont = Math.toRadians(lont);
        this.scale = scale * EARTH_RADIUS;
        this.precalculate();
        this.origin = new LatLonPointImpl(latt, lont);
        this.addParameter("Projection_Name", "stereographic");
        this.addParameter("longitude_of_projection_origin", lont);
        this.addParameter("latitude_of_projection_origin", latt);
        this.addParameter("scale_factor_at_projection_origin", scale);
    }

    private void precalculate() {
        this.sinlatt = Math.sin(this.latt);
        this.coslatt = Math.cos(this.latt);
    }

    public double getScale() {
        return this.scale / EARTH_RADIUS;
    }

    public void setScale(double scale) {
        this.scale = EARTH_RADIUS * scale;
    }

    public double getTangentLon() {
        return this.origin.getLongitude();
    }

    public void setTangentLon(double lon) {
        this.origin.setLongitude(lon);
        this.lont = Math.toRadians(lon);
    }

    public double getTangentLat() {
        return this.origin.getLatitude();
    }

    public void setTangentLat(double lat) {
        this.origin.setLatitude(lat);
        this.latt = Math.toRadians(lat);
        this.precalculate();
    }

    public String paramsToString() {
        return " tangent " + this.origin.toString() + " scale: " + Format.d(this.getScale(), 6);
    }

    public boolean crossSeam(ProjectionPoint pt1, ProjectionPoint pt2) {
        return false;
    }

    public Object clone() {
        Stereographic cl = (Stereographic)super.clone();
        cl.origin = new LatLonPointImpl(this.getTangentLat(), this.getTangentLon());
        return cl;
    }

    public boolean equals(Object proj) {
        if (!(proj instanceof Stereographic)) {
            return false;
        }
        Stereographic oo = (Stereographic)proj;
        return this.getScale() == oo.getScale() && this.getTangentLat() == oo.getTangentLat() && this.getTangentLon() == oo.getTangentLon() && this.defaultMapArea.equals(oo.defaultMapArea);
    }

    public ProjectionPoint latLonToProj(LatLonPoint latLon, ProjectionPointImpl result) {
        double fromLat = latLon.getLatitude();
        double fromLon = latLon.getLongitude();
        double lat = Math.toRadians(fromLat);
        double lon = Math.toRadians(fromLon);
        if (Math.abs(lat + this.latt) <= 1.0E-6) {
            lat = -this.latt * 0.999999;
        }
        double sdlon = Math.sin(lon - this.lont);
        double cdlon = Math.cos(lon - this.lont);
        double sinlat = Math.sin(lat);
        double coslat = Math.cos(lat);
        double k = 2.0 * this.scale / (1.0 + this.sinlatt * sinlat + this.coslatt * coslat * cdlon);
        double toX = k * coslat * sdlon;
        double toY = k * (this.coslatt * sinlat - this.sinlatt * coslat * cdlon);
        result.setLocation(toX, toY);
        return result;
    }

    public LatLonPoint projToLatLon(ProjectionPoint world, LatLonPointImpl result) {
        double fromX = world.getX();
        double fromY = world.getY();
        double rho = Math.sqrt(fromX * fromX + fromY * fromY);
        double c = 2.0 * Math.atan2(rho, 2.0 * this.scale);
        double sinc = Math.sin(c);
        double cosc = Math.cos(c);
        double phi = Math.abs(rho) < 1.0E-6 ? this.latt : Math.asin(cosc * this.sinlatt + fromY * sinc * this.coslatt / rho);
        double toLat = Math.toDegrees(phi);
        double lam = Math.abs(fromX) < 1.0E-6 && Math.abs(fromY) < 1.0E-6 ? this.lont : (Math.abs(this.coslatt) < 1.0E-6 ? this.lont + Math.atan2(fromX, this.latt > 0.0 ? -fromY : fromY) : this.lont + Math.atan2(fromX * sinc, rho * this.coslatt * cosc - fromY * sinc * this.sinlatt));
        double toLon = Math.toDegrees(lam);
        result.setLatitude(toLat);
        result.setLongitude(toLon);
        return result;
    }

    public float[][] latLonToProj(float[][] from, float[][] to, int latIndex, int lonIndex) {
        int cnt = from[0].length;
        float[] fromLatA = from[latIndex];
        float[] fromLonA = from[lonIndex];
        float[] resultXA = to[0];
        float[] resultYA = to[1];
        for (int i = 0; i < cnt; ++i) {
            double fromLat = fromLatA[i];
            double fromLon = fromLonA[i];
            double lat = Math.toRadians(fromLat);
            double lon = Math.toRadians(fromLon);
            if (Math.abs(lat + this.latt) <= 1.0E-6) {
                lat = -this.latt * 0.999999;
            }
            double sdlon = Math.sin(lon - this.lont);
            double cdlon = Math.cos(lon - this.lont);
            double sinlat = Math.sin(lat);
            double coslat = Math.cos(lat);
            double k = 2.0 * this.scale / (1.0 + this.sinlatt * sinlat + this.coslatt * coslat * cdlon);
            double toX = k * coslat * sdlon;
            double toY = k * (this.coslatt * sinlat - this.sinlatt * coslat * cdlon);
            resultXA[i] = (float)toX;
            resultYA[i] = (float)toY;
        }
        return to;
    }

    public float[][] projToLatLon(float[][] from, float[][] to) {
        int cnt = from[0].length;
        float[] fromXA = from[0];
        float[] fromYA = from[1];
        float[] toLatA = to[0];
        float[] toLonA = to[1];
        for (int i = 0; i < cnt; ++i) {
            double fromX = fromXA[i];
            double fromY = fromYA[i];
            double rho = Math.sqrt(fromX * fromX + fromY * fromY);
            double c = 2.0 * Math.atan2(rho, 2.0 * this.scale);
            double sinc = Math.sin(c);
            double cosc = Math.cos(c);
            double phi = Math.abs(rho) < 1.0E-6 ? this.latt : Math.asin(cosc * this.sinlatt + fromY * sinc * this.coslatt / rho);
            double toLat = Math.toDegrees(phi);
            double lam = Math.abs(fromX) < 1.0E-6 && Math.abs(fromY) < 1.0E-6 ? this.lont : (Math.abs(this.coslatt) < 1.0E-6 ? this.lont + Math.atan2(fromX, this.latt > 0.0 ? -fromY : fromY) : this.lont + Math.atan2(fromX * sinc, rho * this.coslatt * cosc - fromY * sinc * this.sinlatt));
            double toLon = Math.toDegrees(lam);
            toLatA[i] = (float)toLat;
            toLonA[i] = (float)toLon;
        }
        return to;
    }

    public double[][] latLonToProj(double[][] from, double[][] to, int latIndex, int lonIndex) {
        int cnt = from[0].length;
        double[] fromLatA = from[latIndex];
        double[] fromLonA = from[lonIndex];
        double[] resultXA = to[0];
        double[] resultYA = to[1];
        for (int i = 0; i < cnt; ++i) {
            double fromLat = fromLatA[i];
            double fromLon = fromLonA[i];
            double lat = Math.toRadians(fromLat);
            double lon = Math.toRadians(fromLon);
            if (Math.abs(lat + this.latt) <= 1.0E-6) {
                lat = -this.latt * 0.999999;
            }
            double sdlon = Math.sin(lon - this.lont);
            double cdlon = Math.cos(lon - this.lont);
            double sinlat = Math.sin(lat);
            double coslat = Math.cos(lat);
            double k = 2.0 * this.scale / (1.0 + this.sinlatt * sinlat + this.coslatt * coslat * cdlon);
            double toX = k * coslat * sdlon;
            double toY = k * (this.coslatt * sinlat - this.sinlatt * coslat * cdlon);
            resultXA[i] = toX;
            resultYA[i] = toY;
        }
        return to;
    }

    public double[][] projToLatLon(double[][] from, double[][] to) {
        int cnt = from[0].length;
        double[] fromXA = from[0];
        double[] fromYA = from[1];
        double[] toLatA = to[0];
        double[] toLonA = to[1];
        for (int i = 0; i < cnt; ++i) {
            double fromX = fromXA[i];
            double fromY = fromYA[i];
            double rho = Math.sqrt(fromX * fromX + fromY * fromY);
            double c = 2.0 * Math.atan2(rho, 2.0 * this.scale);
            double sinc = Math.sin(c);
            double cosc = Math.cos(c);
            double phi = Math.abs(rho) < 1.0E-6 ? this.latt : Math.asin(cosc * this.sinlatt + fromY * sinc * this.coslatt / rho);
            double toLat = Math.toDegrees(phi);
            double lam = Math.abs(fromX) < 1.0E-6 && Math.abs(fromY) < 1.0E-6 ? this.lont : (Math.abs(this.coslatt) < 1.0E-6 ? this.lont + Math.atan2(fromX, this.latt > 0.0 ? -fromY : fromY) : this.lont + Math.atan2(fromX * sinc, rho * this.coslatt * cosc - fromY * sinc * this.sinlatt));
            double toLon = Math.toDegrees(lam);
            toLatA[i] = toLat;
            toLonA[i] = toLon;
        }
        return to;
    }
}

