#ifndef __PCM_H
#define __PCM_H

#include "Matrix.H"
#include "Vector.H"

#include <iostream>
#include <string>

template<int numDims,int numPCs,class T = double>
class PCM
{
protected:
  Matrix<numPCs,numDims,T> matrix;
  Vector<numDims,T> means;
  Vector<numPCs,T> variances;
  
public:
  PCM(void)
  {}

  PCM(const Matrix<numPCs,numDims,T>& _matrix,
      const Vector<numDims,T>& _means,
      const Vector<numPCs,T>& _variances)
    : matrix(_matrix) , means(_means) , variances(_variances)
  {}

  PCM(const PCM& pcm)
    : matrix(pcm.matrix) , means(pcm.means) , variances(pcm.variances)
  {}


  friend std::istream& operator>>(std::istream& in,PCM& pcm)
  {
    std::string tmp;
    int i,j;
    // First, we read in means
    while(in.peek() == '#')
      std::getline(in,tmp);
    for(i = 0 ; i < numDims ; i++)
      in >> pcm.means[i];
    std::getline(in,tmp);

    // Now, the matrix
    while(in.peek() == '#')
      std::getline(in,tmp);
    for(j = 0 ; j < numDims ; j++)
      for(i = 0 ; i < numPCs ; i++)
	in >> pcm.matrix(i,j);
    std::getline(in,tmp);

    // Finally, the variances
    while(in.peek() == '#')
      std::getline(in,tmp);
    for(i = 0 ; i < numPCs ; i++)
      in >> pcm.variances[i];

    return in;
  }

  Vector<numDims,T> doPCM(const Vector<numPCs,T>& stdvs) const
  {
    Vector<numDims,T> ans(means);
    Vector<numPCs,T> toMult(stdvs);
    /*
    for(int i = 0 ; i < numPCs ; i++)
      toMult[i] *= sqrt(variances[i]);
    */
    ans += matrix * toMult;
    return ans;
  }
};

#endif // __PCM_H
