#include <lpfgall.h>
#include <stdio.h>
#include <math.h>

template<typename type>
inline type Max(type x, type y)
{ return (x>y) ? x : y; }

template<typename type>
inline type Min(type x, type y)
{ return (x>y) ? y : x; }

#include "MTGParser.C"					// Include the definition of the MTGParser class
#include "PCM.H"					// Include the PCM class

using namespace std;
float sigmoid(float t, float* ap){			//boltzmann function
  	return (*ap - *(ap+1)) / (1 + exp ( (t - *(ap+2)) / *(ap+3) ) ) + *(ap+1) ;
}

// calculates internode, pedicel, filament and carpel width based on length 
float wregression(float length, float a, float b){
  	return pow(10.0f, (b*log10(length)+a));
}

float Rad2Deg(float r){
 	return r*180.0f/M_PI; 
}
float Deg2Rad(float r){
	 return r*M_PI/180.0f; 
}

//***** Global constants*****//
#define PLANT					//LEAF, LEAVES, PLANT, FLOWER, STAMENF, CARPEL 

float T;							// Global time (HFS)              
const int TT = 1200;       					// total time [HFS] 
const int T0 =  10;        					// start time [HFS] 
const float DT = 10;       					// time increment [hours] 

const float DS = 0.4f;     					// step size of consecutive segments [mm] 
const float SV = 1.0f;     					// global scale value (default unit [mm])

const float PR = 11.89f;    					// flower organ drop (CARPEL LENGTH) 

const int DN = 16;         					// Maximum number of axes 
const int MN = 20;     						// Maximum number of metamers on an axis 
const int GP =  4;         					// number of parameters to the Boltzmann fitting function 

const int LN =  5;         					// Maximum number of leaf shapes 
const int SN =  5;          					// Maximum number of sepal shapes 
const int PN =  5;         					// Maximum number of petal shape


const float RT = 790.0f;   					// reproductive initiation time - first flower 
const float BRT = 758.0f;   					// Bract initiation time - first bract 
const int PL = 17;         					// plastochron for successive flowers [hours] (calculated = 25 hours)

const int RN = 100;								// from images, 7 flowers opened in 5 days

//leaf visualisation
const int NUM_POINTS_LEAF = 14;					// Number of points on leaf shape contours
const int NUM_DIMS_LEAF = NUM_POINTS_LEAF * 2;			// Number of principal component dimensions for leaf shapes
const int NUM_PCS_LEAF = 9;					// Number of principal components for leaf shapes
const int LEAF_APEX_INDEX = 7;					// Index of the apical leaf point

// Position-independent values 
// internode length  
float xl[GP] = {0, 22 , 187 , 36 };				//internode boltzmann parameters (for internode supporting flowers)
const float XA = 137.5f;					//phylotactic angle for metamers supporting flowers.
float XL(float t) { 						//calculates internode length at time calling boltzmann function and parameters
  	return sigmoid (t, &xl[0]); 
}

//bract
float brw[GP] = {0, 5.8 , 126 , 80 };				//bract width brw[GP] boltzmann parameters
float BRW(float t){						//calculates bract width at time calling boltzmann function and parameters 
 	 return sigmoid (t, &brw[0]); 
}

//pedicel
float dl[GP] = {0, 13, 205, 38};				// pedicel length boltzmann parameters
#define DA(t) (((0-1)/(1+exp((t-dl[2]+300)/dl[3]))+1)*45+20)
float DL(float t){ 						//calculates pedicel length at time calling boltzmann and pedl parameters
  	return sigmoid (t, &dl[0]); 
}

// log pedicel width against log pedicel length parameters
//   dwrega = intercept   dwregb = gradient 
const float dwrega = -0.10924;
const float dwregb = 0.26489;

// sepal  
float sw[GP] = {0,  1.1181, 157.29675,  74.91717};		//sepal width boltzmann parameters
float SW(float t){						//calculates sepal width calling boltzmann function and sepw parameters
  	return sigmoid (t, &sw[0]); 
}

const float fs[GP] = {0,  25, 273, 44 };
const float fo[GP] = {0, 1, 150, 400 };

// flower opening and size 
#define FO(t) ((0-1)/(1+exp((t-fo[2])/(fo[3])))+1)		//function determining which flower shape to draw, ie open or not
#define FS(t) ((fs[0]-fs[1])/(1+exp((t-fs[2])/fs[3]))+fs[1])


//reference sepal shapes
const float ss[] = {0.2801, 0.4057, 0.6111, 0.8639, 1.10};
const int SepalIx = s0028;

V3f cv[64*16];
V3f pv[64*16];
V3f rl[RN];
V3f rw[RN];
V3f mc[3];

// internode width vs length linear regression parameters 
const double IWrega = -0.247;					//intercept
const double IWregb = 0.470; 					//gradient

// Position-dependent values: will be read in from MTG 
int RM[DN];							// reproductive reference metamer index (first flower) 
int BRM[DN];							// first bract metamer index (first flower) 
float RD[DN];							// reproductive reference delay [hours] (first flower) 
float BRD[DN];

float ia[DN][MN];						// phyllotactic angle  
float IA(int n,int i){						//returns phylotactic angle for metamer
  	return ia[n][i];
}

//internode length
float il[DN][MN][GP];								//array holding intl boltzmann parameters for each metamer						
float IL(int n, int i, float t){						//boltzmann function calculating internode length of specified metamers calling metamer specific parameters 
  	return sigmoid(t,&(il[n][i][0]));
}


//leaf width (to see leaf width through time as in whole plant model
float lw[DN][MN][GP];								//array holding leaf width boltzmann parameters for each metamer
float LW(int n, int i, float t){						//boltzmann function calculating leaf width using boltzmann parameters for  specific metamer
  	return sigmoid (t, &lw[n][i][0]); 		
}

#define LA(n,i,t) (((0-1)/(1+exp((t-lw[n][i][2])/lw[n][i][3]))+1)*60+30)	//branching angle of leaves

//leaf shape information

float lwr[DN][MN][LN];								// Reference leaf widths 
float ls[DN][MN][LN][NUM_PCS_LEAF];						// Principle components of leaves

// PCM leaf shape stuff
typedef Vector<NUM_POINTS_LEAF,V2f> LeafShapeVector;
typedef Vector<NUM_PCS_LEAF,float> LeafPCVector;

PCM<NUM_DIMS_LEAF,NUM_PCS_LEAF,float> leafPCM;

LeafShapeVector getLeafShape(const LeafPCVector& pcvec){
  	LeafShapeVector shapeVec;
  	Vector<NUM_DIMS_LEAF,float> coordVec = leafPCM.doPCM(pcvec);
  	for(int i = 0 , j = 0 ; i < NUM_POINTS_LEAF ; i++ , j += 2){  
    		shapeVec[i].x = coordVec[j];
    		shapeVec[i].y = coordVec[j+1];
  	}
  	return shapeVec;
}

/* Calculate flower age given time T, axis number n, and internode number i */ 
float FlowerAge(float T, int n, int i){
  	return T - (i- RM[n])*PL-RT-RD[n];
}

float BractAge(float T, int n, int i){
  	return T - (i- BRM[n])*PL-BRT-BRD[n];
}

derivation length: ((TT-T0)/DT);

string toString(const int val){
 	static char tmp[1025];
  	sprintf(tmp,"%d\000",val);
  	return string(tmp);
}

Start:{	
		int i,n;

	// Store the surface's control points in cv.
  	// These are later used to build dynamically 
  	// deformed surfaces (developing flower)

  		for (int p=0; p<32; ++p){
  
    			for ( i=0; i<16; ++i){
    
      	/* New function: 
           V3f GetSurfacePoint(int surface_id, int point_id);
           returns control points of the specified surface (.s file)
           if the surface is made of more than one patch
           to get control point id from patch number p_no 
           point_id = p_no*16 + id
      	*/

     				 V3f pt = GetSurfacePoint(flower, p*16 + i);

      	// This is probably related to the problem
      	// that cpfg is left-handed and lpfg is right-handed
      					pt.x = -pt.x;
      					pt.z = -pt.z;
      					cv[p*16+i].x = pt.x;
      					cv[p*16+i].y = pt.y;
      					cv[p*16+i].z = pt.z;
    			}
  		}

  
    		for ( i=0; i<RN; ++i){
      			rl[i] = curveXYZ(ventral, float(i)/(RN-1));
  		}
  
    		for (i=0; i<RN; ++i){
	  		rw[i] = curveXYZ(rotate_1, float(i)/(RN-1));
  		}

	//setting the start time of the model.
  		T=T0;						// set global time 'T' to 'T0' 
  		

	// read PCM data 
  		ifstream pcmFile("antirrhinum_leaf_pcm_data.txt");
  		pcmFile >> leafPCM;
  		pcmFile.close();

 	//read MTG 
  		ifstream mtgFile("antirrhinum.mtg");
  		MTGParser mtg(mtgFile);
  		mtgFile.close();

	// read metamer parameters (ia,il,lw,lc,ls) from mtg
	// Components are identified in the MTG as, for example:
	// /A0 is the primary axis
	// /A0/M0<M0<M0 is the third metamer of the primary axis (m2)
	// /A0/M0<M0<M0/I0+A1 is the axis (subtended by an internode) of that metamer
	// /A0/M0<M0<M0/I0+A1/M1<M1 is its second metamer (m2-1).

	// Here, we handle the main axis separately from the lateral axes.
	// (It was easier this way, because the MTG string prefixes are quite different.)

 		string lookStr("/A0/M0");
  		for(i = 0 ; i < MN ; i++) {
 	
    	// mtg.lookupValue takes two parameters: the string representing the topological
    	// position of the plant component, and the property name to look up. It returns
    	// a C++ string of the value in the MTG file, or an empty string if that property has
    	// no value for that component.

   	// Note that atof only handles C-style null-terminated strings,
    	// so we have to use the C++-string's data() method to extract
    	// the null-terminated representation from the C++ representation.
	
   			ia[0][i]    = atof(mtg.lookupValue(lookStr+"/I0","IA").data());

    			il[0][i][0] = atof(mtg.lookupValue(lookStr+"/I0","IL0").data());
   			il[0][i][1] = atof(mtg.lookupValue(lookStr+"/I0","IL1").data());
    			il[0][i][2] = atof(mtg.lookupValue(lookStr+"/I0","IL2").data());
    			il[0][i][3] = atof(mtg.lookupValue(lookStr+"/I0","IL3").data());

    			lw[0][i][0] = atof(mtg.lookupValue(lookStr+"/I0+L0","LW0").data());
    			lw[0][i][1] = atof(mtg.lookupValue(lookStr+"/I0+L0","LW1").data());
    			lw[0][i][2] = atof(mtg.lookupValue(lookStr+"/I0+L0","LW2").data());
    			lw[0][i][3] = atof(mtg.lookupValue(lookStr+"/I0+L0","LW3").data());

    			for(int tmp1 = 0 ; tmp1 < LN ; tmp1++){
    
      				string lsName = string("LS") + toString(tmp1);
      				lwr[0][i][tmp1] = atof(mtg.lookupValue(lookStr+"/I0+L0",lsName).data());
      				for(int tmp2 = 0 ; tmp2 < NUM_PCS_LEAF ; tmp2++)
        				ls[0][i][tmp1][tmp2] =
         				atof(mtg.lookupValue(lookStr+"/I0+L0",(lsName+'_')+toString(tmp2+1)).data());
    				}

    	// Here we add another metamer to the string representing the axis,
    	// thus iterating over metamers along the main axis.

    			lookStr += "<M0";
  			}

	// Here we read in the data for the lateral axes.
	// There are two loops; the outer loop (over n) progresses along the main axis,
	// and the inner loop (over i) progresses along the lateral axes.

  			lookStr.assign("/A0/M0");
  			for(n = 1 ; n < DN ; n++){  
    				string subStr(lookStr + "/I0+A1/M1");
    				for(i = 0 ; i < MN ; i++){    		
      					ia[n][i]    = atof(mtg.lookupValue(subStr+"/I1","IA").data());
      					il[n][i][0] = atof(mtg.lookupValue(subStr+"/I1","IL0").data());
      					il[n][i][1] = atof(mtg.lookupValue(subStr+"/I1","IL1").data());
      					il[n][i][2] = atof(mtg.lookupValue(subStr+"/I1","IL2").data());
      					il[n][i][3] = atof(mtg.lookupValue(subStr+"/I1","IL3").data());

      					lw[n][i][0] = atof(mtg.lookupValue(subStr+"/I1+L1","LW0").data());
      					lw[n][i][1] = atof(mtg.lookupValue(subStr+"/I1+L1","LW1").data());
      					lw[n][i][2] = atof(mtg.lookupValue(subStr+"/I1+L1","LW2").data());
      					lw[n][i][3] = atof(mtg.lookupValue(subStr+"/I1+L1","LW3").data());

      					for(int tmp1 = 0 ; tmp1 < LN ; tmp1++){     
        					string lsName = string("LS") + toString(tmp1);
        					lwr[n][i][tmp1] = atof(mtg.lookupValue(subStr+"/I1+L1",lsName).data());

        					for(int tmp2 = 0 ; tmp2 < NUM_PCS_LEAF ; tmp2++)
         					ls[n][i][tmp1][tmp2] =
           					atof(mtg.lookupValue(subStr+"/I1+L1",(lsName+'_')+toString(tmp2+1)).data());
      					}
      				subStr += "<M1";
    			}
    			lookStr += "<M0";
  		}

	// read axial parameters (RM and RD) from mtg
	// These are attributes of whole axes rather than individual metamers,
	// and are easier to read in separately.
 		RM[0] = atoi(mtg.lookupValue("/A0","RM").data());
  		BRM[0] = atoi(mtg.lookupValue("/A0","BRM").data());
  		RD[0] = atoi(mtg.lookupValue("/A0","RD").data());
		BRD[0] = atoi(mtg.lookupValue("/A0","BRD").data());
  		lookStr.assign("/A0/M0");

  		for(i = 1 ; i < DN ; i++){  
    			RD[i] = atof(mtg.lookupValue(lookStr+"/I0+A1","RD").data());
			BRD[i] = atof(mtg.lookupValue(lookStr+"/I0+A1","BRD").data());
   			RM[i] = atoi(mtg.lookupValue(lookStr+"/I0+A1","RM").data());
    			BRM[i] = atoi(mtg.lookupValue(lookStr+"/I0+A1","BRM").data());
    			lookStr += "<M0";
  		}  
}

StartEach:{
 		T += DT;					// increment global time 'T' by 'DT' after every step 
}

// Module declarations 
module LeafArray();						// module for visualizing the array of leaves
module A(int, int, int);					// apex :order index time??
module L3(int, int, float);					// order, index, time
module B2(int, int);						// flower : order index?
module I3(int, int, int);					// internode
module D3(float, float, float);					// pedicel
module Time();							// to write time on the screen
module B3(int, int, float);
module W(int, float, float, float, float, float);
module AP;
module Sepal(float);

// list of possible axioms  

#ifdef PLANT
int lfarray =0;
axiom: Time RollR(171) SetColor(59) Elasticity(0.12) A(0,0,2);
#endif

#ifdef LEAVES
int lfarray = 1;
axiom: SetColor(59) LeafArray();
#endif

#ifdef FLOWER
int lfarray =0;
axiom: SetColor(33)  B2(0,RM[0]);	//SB()  Left(90) Up(90) f(10) Down(90) F(10) EB()
#endif

interpretation:
maximum depth: 1000;

// Visualize leaves as a 2D array   
#ifdef LEAVES
LeafArray() :{

  		for (int row = 0; row < 3; row++)
    			for (int column = 0; column < 6; column++)
      			nproduce SB MoveTo(50*column, -120*row, 0) L3(0, row*6+column+2,T) EB ;
  		produce ;
}	
#endif


//Do plant
#ifdef PLANT
A(o, n, i):{
  		if ( o >= 2 || n >= DN )
    			produce ;			  

  		if (i < RM[n])  					// metamer that supports leaves and branches	
   			 produce RollL(IA(n,i))  Left(4) I3(0, n, i )
           			 SB Elasticity(0) L3(n,i,T) EB
            			 SB Left(55) A(o+1,i+1,0) EB
            			 A(o,n,i+1); 

  		float t = FlowerAge(T, n, i); 
  		if (
      			RM[n] > 0 &&            			// metamer that supports flowers
      			(IL(n,RM[n],t) > 0.05   			// internode length > threshold
       			|| DL(t) > 0.05)        			//  pedicel length > threshold
     		)
    			produce RollL(XA) Left(4) I3(1 ,n, i) 
				SB L3(n,i,T) EB 
				SB B2(n,i)  EB 
				A(o,n,i+1);      
}
#endif
Time() :{								// write global time on screen 
  	static char bf[32];
	static char ds[32];
	float das=T/24;
  	sprintf(bf, "HFS %.2f", T);
	sprintf(ds, "DAS %.2f", das);

  	produce SB SetColor(60) Left(180) f(10*SV) Label(bf) f(15*SV) Label(ds) EB;
}

I3(c,n,i):{								// visualize internode as a line 
 
 		float width, length;
 
  		if (c == 0 && il[n][i][3] != 0 ){  
    			length = IL(n,i,T);
  		}

  		else if (c == 1){  
    			float t = FlowerAge(T, n, i);
    			length = XL(t);
		// Printf("Flower-bearing internode (%d,%d) has age %f and length %f\n",n,i,t,length);
 		}
  		else 
    			produce ;

  		width = wregression(length, IWrega, IWregb);		//calculates the width from the length
		if (width > 6)
			width = 6;

  		float ns = Max(3.0f, length/DS); 
  		nproduce Elasticity(0.12/ns) SetWidth(width);

  		float l = length*SV/(ns-1);
  		for (float j=0; j<ns; j+=1)
    			nproduce F(l);
 		produce;
}


//******FUNCTIONS TO CALCULATE THE ORGAN SHAPES****************////
struct IndexPair 
{
  		int smaller;
  		int larger;
};

//Find two indices, ip.smaller and ip.larger, of the organs (leaves, petals, sepals...) 
//to be interpolated.  If no interpolation is to be performed, return ip.smaller equal
//to ip.larger

IndexPair FindIndexPair(float width, const float arr[], int Max_number){
  	// find the widest measured organ (leaf, petal, sepal...) less wide than "width".  
  	//  Ignore zeroes padding the array of measured widths "arr"

  		int l = -1;
  		for (int j=0; j<Max_number; ++j)
    			if ((arr[j] <= width) && (arr[j] > 0))
      			l=j;

  		IndexPair ip;
  	// Interpolate if arr[l] <= width < arr[l+1], don't interpolate otherwise. 
    
  		if(l == -1)
    			ip.smaller = ip.larger = 0;
  		else if ( (l < Max_number-1) && (width < arr[l+1]) )
  			{ ip.smaller = l; ip.larger = l+1; }
  		else
  			{ ip.smaller = ip.larger = l; }

  		return ip;
}

// Find coefficient r to determined where "current" point lies between "smaller"
// and "larger" points for the subsequent interpolation purposes 

float FindWeight(float current, float smaller, float larger){
  	return(current-smaller)/(larger-smaller);
}
// Interpolate points laying on two curves
V2f InterpolateCurves (int first_curve, IndexPair ip, int step, float r, float s){

	// first_curve: index of the first curve in the sequence, from which the two curves
	// to be interpolated are drawn (or one curve if no interpolation occurs) .
	// IndexPair: offsets indicating the two curves.
	// step: enters into the formula to find these two curves.  Equals to 1 if all curves
	// in the sequence pointed to by first_curve are of the same type (e.g., leaf 
	// contours), 2 if these curves are grouped in pairs (contour - bending),
	// which is the case for sepals and petals.
	// r:   weight with which the two curves (actually, their specitic points) will be
	// combined
	// s:   arc-length coordinate of the points on each curve, normalized to 0-1. 

  		if (ip.smaller != ip.larger)
    			return (1-r)*curveXY(first_curve+step*ip.smaller, s) +
             		 r *curveXY(first_curve+step*ip.larger,  s);
  		else
    			return curveXY(first_curve+step*ip.smaller, s);
}

V2f InterpolatePCMCurves (float shapes[LN][NUM_PCS_LEAF],
			  const LeafShapeVector& shapeVec, float s){

	// shapes: an array of the leaf shape data (ls[n][i])
	// ip: offsets indicating the two curves to be interpolated
	// r: interpolant between curves
	// s: length-based coordinate of the point requested, between 0 and 1

  	// We first linearly interpolate between the corresponding
  	// leaf-space vectors using r as the interpolant, and
  	// undo the PCM to find the shape vector.

  		static bool FIRST = true;

  	// We calculate the length and width of the shape.
  	// The length is just the relative X position of the last point:

  		float length = (shapeVec[LEAF_APEX_INDEX] - shapeVec[0]).x;

  	// The width is the maximum Y position of any point on this side:
  		float width = 0;

  		for(int i = 0 ; i < LEAF_APEX_INDEX ; i++){
    			if(fabs((shapeVec[i] - shapeVec[0]).y) > width)
      				width = fabs((shapeVec[i] - shapeVec[0]).y);
		}	
  	// We scale s by length to get the required X value.

  		double xVal = s * length;

  	// and find the index idx whose X coordinate is just less than xVal

  		int idx;
  		for(idx = 0 ; idx < LEAF_APEX_INDEX && (shapeVec[idx] - shapeVec[0]).x < xVal ; idx++);

  	// Finally, we linearly interpolate between the points at indices
 	// idx and idx+1, using xVal as an interpolant.

  		V2f posn;
  		if(idx >= LEAF_APEX_INDEX)
    			posn = shapeVec[LEAF_APEX_INDEX] - shapeVec[0];
 		else{  
    			idx--;
    			float interpolant = (xVal - (shapeVec[idx] - shapeVec[0]).x) /
                        				(shapeVec[idx+1] - shapeVec[idx]).x;
    			posn = (1-interpolant) * shapeVec[idx] +
           		interpolant * shapeVec[idx+1];
   			posn = posn - shapeVec[0];
  		}
 		posn = shapeVec[idx] - shapeVec[0];

  	// Normalize to leaf width (which is twice the half-width we have calculated)
  
		posn /= (width * 2);
  		FIRST = false;
  		return V2f(fabs(posn.y),posn.x);
}

//*****DOING THE ORGAN VISUALISATION CALLING ABOVE FUNCTIONS*****
L3(n, i, t) :{
									// visualize leaf on axis n, index i, at time t   		
		//if (lw[n][i][3] ==0)
		//	produce;					//some sort of check from Lars - taken out to see bracts
  		
 	// find the size of leaf on axis n, internode i, at time t 
  		float current_width = LW(n,i,t);			
  		if (i>=BRM[n]){
			t=BractAge(T,n,i);
			current_width=BRW(t);
			//Printf("width = %f\n",current_width);			
		}			

  		IndexPair ip = FindIndexPair(current_width, lwr[n][i], LN);

  		LeafShapeVector shapeVec;
  		if (ip.smaller != ip.larger){  
    			LeafPCVector smaller(ls[n][i][ip.smaller]),larger(ls[n][i][ip.larger]);
    			float r = FindWeight(current_width, lwr[n][i][ip.smaller], lwr[n][i][ip.larger]);
    			shapeVec = getLeafShape((1-r) * smaller + r * larger);
  		}
  		else
    			shapeVec = getLeafShape(LeafPCVector(ls[n][i][ip.smaller]));
		if (i>=BRM[n]){ 
			
			shapeVec = getLeafShape(LeafPCVector(ls[n][BRM[n]][ip.smaller]));}		//getLeafShape(LeafPCVector(ls[n][BRm[n]][ip.smaller]));}

	//yvette - Checking bractlength
			//float pcwidth = 0;
  			//for(int j = 0 ; j < LEAF_APEX_INDEX ; j++){
    			//	if(fabs((shapeVec[j] - shapeVec[0]).y) > pcwidth)
      			//		pcwidth = fabs((shapeVec[j] - shapeVec[0]).y);
			//}
			//float length = (shapeVec[LEAF_APEX_INDEX] - shapeVec[0]).x/(pcwidth*2)*current_width;
			//if (n==0 && i==BRM[0])Printf("length = %f width = %f \n", length, current_width);

 	// calculate step size along leaf silhouette as a function of leaf size (length) 
  		float y_length = InterpolatePCMCurves(ls[n][i], shapeVec, 1).y;
  		const float DrawStep = 0.01;
  		float ns = Max(3.0f, y_length / DrawStep);
  		float ds = 1/(ns-1);

  	// initialize generalized cylinder
		float d;
		float c;
		if (lfarray == 1){
			d = 0;
			//current_width = 6; 			//leaf width to view leaves
			c = 0;
		}
		if (lfarray ==0 ){
			d = -LA(n,i,t);			
			c = -2*0.25*ds/0.01;
		}
		if (i < BRM[n])		
  			nproduce Down(d) CurrentContour(leaf) StartGC;
		else
			nproduce Down(d) CurrentContour(bract) StartGC;

  	// traverse lef contour contour with step ds, and add consecutive segments 
     	//to the generalized cylinder 
  		float s=0;					// percentage of silhouette travelled
  		float old_y=0; 					// old_y position, used to calculate y increments 	

		while (s<1){   
    			s = Min(1.0f, s+ds);
    			V2f curve_point = InterpolatePCMCurves(ls[n][i], shapeVec, s);
    			float dy = curve_point.y-old_y;
			if (i< BRM[n])
    				nproduce Down(c);
			else
				nproduce Up(c);
 
    			if(fabs(dy) < 1e-6) 
				continue;

    			nproduce SetWidth(-2*current_width*curve_point.x*SV)
             			F(dy*current_width*SV);
    				old_y = curve_point.y;
  		}
  		// terMinate the generalized cylinder 
  		produce EndGC;
}

//******New stuff from Lars' flower model******//


B2(n, i) :{
  		if (i>=RM[n]){  
	//do flower module if metamer index is greater than first flower metamer				
    			float t = FlowerAge(T,n,i);
			
			produce B3(n,i,t); 
	  	}
}

B3(n, i, t) :
{

	float DW = wregression(DL(t), dwrega, dwregb);
  produce 
    SetColor(59) 
	D3(DA(t), DL(t), DW)
	SB
	  SetColor(59) 
	  RollR(-18)
	  SB
	    Sepal(SW(t))
	  EB
	  RollR(72)
	  SB
	    Sepal(SW(t))
	  EB
	  RollR(72)
	  SB
	    Sepal(SW(t))
	  EB
	  RollR(72)
	  SB
	    Sepal(SW(t))
	  EB
	  RollR(72)
	  SB
	    Sepal(SW(t))
	  EB
	EB
	RollL(90) Down(93)
	W(0,t, FS(t)/4, FS(t)/4, FS(t)/4, FO(t));
}

       
W(s, t, l, w, h, a) :
{
  // lips
  for (int cp = 0; cp<32; ++cp)
  {
    for (int ci=0; ci<16; ++ci)
    {
      V3f p=cv[cp*16+ci];
      float od = 0;
      for (int i=0; i<RN; ++i)
      {
        V3f d = p-rl[i];
        float dl=d.Length();
        if (i==0 || dl<od) 
        { s=i; od=dl; }
      }
      V3f c = rl[s];
      if ((c.y < p.y) && ( ((cp > 23) && (cp < 32)) || ((cp > 31) && (cp < 40)) ) )
      {
        int ip=s-1;
        if (ip<0) ip=0;
        int ir=s+1; 
        if (ir>RN-1) ir=RN-1;
        V3f r = rl[ir]-rl[ip];
        r.Normalize();
        V3f nR = r;
        V3f cP = p-c;
        float dd=cP.Length();
        float alpha=-40*(1-a)*dd/2;
        alpha = Deg2Rad(alpha);
        float sn=sin(alpha); 
        float cs=cos(alpha); 
        float tt=1-cs;
        mc[0].x=tt*nR.x*nR.x+cs;      mc[0].y=tt*nR.x*nR.y-sn*nR.z; mc[0].z=tt*nR.x*nR.z+sn*nR.y;
        mc[1].x=tt*nR.x*nR.y+sn*nR.z; mc[1].y=tt*nR.y*nR.y+cs;      mc[1].z=tt*nR.y*nR.z-sn*nR.x;
        mc[2].x=tt*nR.x*nR.z-sn*nR.y; mc[2].y=tt*nR.y*nR.z+sn*nR.x; mc[2].z=tt*nR.z*nR.z+cs;
        V3f nP;
        nP.x=mc[0].x*cP.x+mc[0].y*cP.y+mc[0].z*cP.z;
        nP.y=mc[1].x*cP.x+mc[1].y*cP.y+mc[1].z*cP.z;
        nP.z=mc[2].x*cP.x+mc[2].y*cP.y+mc[2].z*cP.z;
        p=c+nP;
      }
      pv[cp*16+ci]=p;
    }
  }

  // wings
  for (int cp=0; cp<32; ++cp)
  {
    for (int ci=0; ci<16; ++ci)
    {
      V3f p = pv[cp*16+ci];
      float od=0;
      for (int i=0; i<RN; ++i)
      {
        V3f r = rw[i];
        V3f d=p-r;
        float dl=d.Length();
        if (i==0 || dl<od)
        { s=i; od=dl; }
      }
      V3f c = rw[s];
      if (c.z<p.z && cp>8 && cp<20)
      {
        int ip=s-1; if (ip<0) ip=0;
        int ir=s+1; if (ir>RN-1) ir=RN-1;
        V3f r=rw[ir]-rw[ip];
        r.Normalize();
        V3f nR = r;
        V3f cP = p-c;
        float dd=cP.Length();
        float alpha=Deg2Rad(30.0f*(1-a)*dd/3.0f + 12.0f*(1.0f-a));
        float sn=sin(alpha); float cs=cos(alpha);
        float tt=1-cs;
        mc[0].x=tt*nR.x*nR.x+cs;      mc[0].y=tt*nR.x*nR.y-sn*nR.z; mc[0].z=tt*nR.x*nR.z+sn*nR.y;
        mc[1].x=tt*nR.x*nR.y+sn*nR.z; mc[1].y=tt*nR.y*nR.y+cs;      mc[1].z=tt*nR.y*nR.z-sn*nR.x;
        mc[2].x=tt*nR.x*nR.z-sn*nR.y; mc[2].y=tt*nR.y*nR.z+sn*nR.x; mc[2].z=tt*nR.z*nR.z+cs;
        V3f nP;
        nP.x=mc[0].x*cP.x+mc[0].y*cP.y+mc[0].z*cP.z;
        nP.y=mc[1].x*cP.x+mc[1].y*cP.y+mc[1].z*cP.z;
        nP.z=mc[2].x*cP.x+mc[2].y*cP.y+mc[2].z*cP.z;
        p=c+nP;
      }
      pv[cp*16+ci] = p;
    }
  }

  // all
  for (int cp=0; cp<32; ++cp)
  {
    for (int ci=0; ci<16; ++ci)
    {
      pv[(63-cp)*16+ci] = pv[cp*16+ci];
      pv[(63-cp)*16+ci].x = -pv[(63-cp)*16+ci].x;
    }
  }

  // LENGTH : WIDTH : HEIGHT SCALING
  for (int cp=0; cp<64; ++cp)
  {
    for (int ci=0; ci<16; ++ci)
    {
      pv[cp*16+ci].x*=w;			
      pv[cp*16+ci].y*=h;
      pv[cp*16+ci].z*=l;
    }
  }
  produce SetColor(120+a*13) AP;
}

AP():
{

  for (int p=0; p<64; ++p)
  {
    SurfaceObj srf;
    for (int row=0; row<4; ++row)
    {
      for (int col=0; col<4; ++col)
      {
        V3f v = -pv[p*16+row*4+col];
        srf.Set(col+row*4, v);
      }
    }
    nproduce DSurface(srf);
  }
  produce;
}

/*
const int NUMBER_FLOWER_SHAPES = 13;
B2(n, i) :{
  		if (i>=RM[n]){  
	//do flower module if metamer index is greater than first flower metamer				
    			float t = FlowerAge(T,n,i);
			float s;
			if (FS(t) < 10) { s = 5;}
			else s = 5 + 0.6*FS(t);
			if (s >NUMBER_FLOWER_SHAPES){s=NUMBER_FLOWER_SHAPES;}
    			//float s = (FO(t)) * NUMBER_FLOWER_SHAPES;			

			float fw;
			 
			fw = FS(t);
			if (t > 0 && fw < 4.3){ 
				fw = 0.0213*t+0.05;
			}

			float length =0.35* pow(float(fw), float(1.307));		

			float DW = wregression(DL(t), dwrega, dwregb);
			if (DL(t) > 13) 
				DW = 1.8;  			
			//Printf(" pedl = %f, fw = %f, scale = %f, t = %f\n", DL(t), fw, fw/1, T);
   		 	//produce RollR(90) SB D3(DA(t), DL(t), DW) SetColor(140) RollR(90) Down(90) Surface(int(s) + 1,fw/25) EB;
			produce   RollR(90) SB  D3(DA(t), DL(t), DW) SetColor(140) RollR(90) Down(90)  Surface3(int(s) + 1, fw/25, fw/25, fw/25) EB; // 
	  	}
}
*/

D3(DA, DL, DW) :{	//draw pedicel
  	float ns = Max(5.0f, DL/DS);

  	nproduce SetColor(59) Left(DA) SetWidth(DW*SV) Elasticity(0.62/ns);
 
  	for (float j=0; j<ns; j+=1)
    		nproduce F(DL*SV/(ns-1));
  	produce f(-DW*SV) Elasticity(0);
}

Sepal(SW) :
{
  /* find the two sepal shapes (ip.smaller, ip.larger) that are interpolated 
     to obtain current sepal shape */ 

  IndexPair ip = FindIndexPair(SW, &ss[0], SN);

  /* find the weight r for interpolating between two measured contours */
  float r = FindWeight(SW, ss[ip.smaller], ss[ip.larger]);
  
  /* calculate step size along sepal silhouette as a function of sepal size (length) */
  float y_length = InterpolateCurves(SepalIx, ip, 2, r, 1).y;
  float ns = max(10.0f, y_length * SW / DS);
  float ds = 1/(ns-1);

  /* initialize generalized cylinder */
  nproduce CurrentContour(sepal) RollR(90) StartGC RollR(-90); 

  /* traverse sepal contour with step ds, and add consecutive segments 
     to the generalized cylinder */

  float s = 0;		// percentage of silhouette travelled
  float old_y = 0;	// old_y position, used to calculate y increments
  V2f OldPoint(0.0, 0.0); // old point
  V2f OldHead(0.0, 1.0);  // old heading (orientation) for bending calculcations
 
  while (s<1) 
  {
    s = min(s+ds,1.0f);
    V2f curve_point = InterpolateCurves(SepalIx, ip, 2, r, s);
    
    /* calculate bending angle alpha */

    // relative position along the midrib, for curvature computation
    float q = min(curve_point.y/y_length, 1.0f); 
    V2f xypoint = InterpolateCurves(SepalIx+1, ip, 2, r, q);

    V2f tangent = xypoint - OldPoint;  
    if (tangent.Length()>0.0001f)
    {
    //Printf("tang = %f,%f\n", tangent.x, tangent.y);     	
    tangent.Normalize();
  
     
    float theta = OldHead*tangent;  // dot product
    //Printf("th = %f\n", theta);
    if (theta<-1)
      theta = -1;
    else if (theta>1)
      theta = 1;
    float alpha = Rad2Deg(acos(theta));
    if (tangent.x > OldHead.x)
      alpha = -alpha;
    /* end of the calculatation of the bending angle alpha */

    // step along they y axis (midrib) or the sepal    
    float dy = curve_point.y-old_y;
    nproduce Right(alpha) SetWidth(-2*SW*curve_point.x*SV) RollR(90) F(dy*SW*SV) RollR(-90) ;
    }
    old_y = curve_point.y;
    OldPoint = xypoint;
    OldHead = tangent;
  }
    
  produce EndGC;
}

