//
//	Copyright (c)2004 GE Medical Systems
//


//
// ConfigFile C'tor
//
function ConfigFile()
{
	this._xmlCfg = CreateXmlDoc4('config.xml');
	this.InsertDefaultViewportAnnotFormats();
}


//
//	InsertDefaultViewportAnnotFormats
//
function ConfigFile.prototype.InsertDefaultViewportAnnotFormats()
{ with(this) {

	// insert default viewport annotation formats in config file. (XML structure as used in CWeb)
	// 
	//	<annotationformats>
	//		<annotationformat modality=[modality]>
	//			<basic>[format string]</basic> <!-- not used for cd-viewwer -->
	//			<full>[format string]</full>
	//		</annotationformat>
	//	</annotationformats>

	var mpFormatsFull = new Array();
	mpFormatsFull["Default"]= "BottomLeft=C@00281050@\nW@00281051@ ## BottomMiddle=@00200020@ ## BottomRight=@00080070@ ## MiddleLeft=@00200020@ ## MiddleRight=@00200020@ ## TopLeft=@00100010@\nDOB: @00100030@\n@00200013%i@ ## TopMiddle=@00200020@ ## TopRight=@00081030@\n@00080020@\n@00080030@\n@00080050@ ## MiddlePercentageSize=20 ## ";
	mpFormatsFull["CT"]		= "DerivePatientOrientation=1 ## BottomLeft=SP:@00201041%5.1f@mm\nC@00281050@\nW@00281051@ ## BottomMiddle=@00200020@ ## BottomRight=@00080070@ ## MiddleLeft=@00200020@ ## MiddleRight=@00200020@ ## TopLeft=@00100010@\nDOB: @00100030@\n@00200013%i@ ## TopMiddle=@00200020@ ## TopRight=@00081030@\n@00080020@\n@00080030@\n@00080050@ ## MiddlePercentageSize=20 ## ";
	mpFormatsFull["PT"]		= "DerivePatientOrientation=1 ## BottomLeft=SP:@00201041%5.1f@mm\nU@00281050U@\nL@00281050L@ ## BottomMiddle=@00200020@ ## BottomRight=@00080070@ ## MiddleLeft=@00200020@ ## MiddleRight=@00200020@ ## TopLeft=@00100010@\nDOB: @00100030@\n@00200013%i@ ## TopMiddle=@00200020@ ## TopRight=@00081030@\n@00080020@\n@00080030@\n@00080050@ ## MiddlePercentageSize=20 ## ";	
	mpFormatsFull["SC"]		= "BottomLeft=C@00281050@\nW@00281051@ ## BottomMiddle=@00200020@ ## BottomRight=@00080070@ ## MiddleLeft=@00200020@ ## MiddleRight=@00200020@ ## TopLeft=@00100010@\nDOB: @00100030@\n@00200013%i@ ## TopMiddle=@00200020@ ## TopRight=@00081030@\n@00080020@\n@00080030@\n@00080050@ ## MiddlePercentageSize=20 ## ";
	mpFormatsFull["MR"]		= "DerivePatientOrientation=1 ## BottomLeft=SP:@00201041%5.1f@mm\nC@00281050@\nW@00281051@ ## BottomMiddle=@00200020@ ## BottomRight=@00080070@ ## MiddleLeft=@00200020@ ## MiddleRight=@00200020@ ## TopLeft=@00100010@\nDOB: @00100030@\n@00200013%i@ ## TopMiddle=@00200020@ ## TopRight=@00081030@\n@00080020@\n@00080030@\n@00080050@ ## MiddlePercentageSize=20 ## ";
	mpFormatsFull["RG"]		= "BottomLeft=C@00281050@\nW@00281051@ ## BottomMiddle=@00200020@ ## BottomRight=@00080070@ ## MiddleLeft=@00200020@ ## MiddleRight=@00200020@ ## TopLeft=@00100010@\nDOB: @00100030@\n@00200013%i@ ## TopMiddle=@00200020@ ## TopRight=@00081030@\n@00080020@\n@00080030@\n@00080050@ ## MiddlePercentageSize=20 ## ";
	mpFormatsFull["XA"]		= "BottomLeft=C@00281050@\nW@00281051@ ## BottomMiddle=@00200020@ ## BottomRight=@00080070@ ## MiddleLeft=@00200020@ ## MiddleRight=@00200020@ ## TopLeft=@00100010@\nDOB: @00100030@\n@00200013%i@ (F@frame@/@00280008@) ## TopMiddle=@00200020@ ## TopRight=@00081030@\n@00080020@\n@00080030@\n@00080050@ ## MiddlePercentageSize=20 ## ";
	mpFormatsFull["US"]		= "BottomLeft=C@00281050@\nW@00281051@ ## BottomMiddle=@00200020@ ## BottomRight=@00080070@ ## MiddleLeft=@00200020@ ## MiddleRight=@00200020@ ## TopLeft=@00100010@\nDOB: @00100030@\n@00200013%i@ ## TopMiddle=@00200020@ ## TopRight=@00081030@\n@00080020@\n@00080030@\n@00080050@ ## MiddlePercentageSize=20 ## ";
	mpFormatsFull["CR"]		= "BottomLeft=C@00281050@\nW@00281051@ ## BottomMiddle=@00200020@ ## BottomRight=@00080070@ ## MiddleLeft=@00200020@ ## MiddleRight=@00200020@ ## TopLeft=@00100010@\nDOB: @00100030@\n@00200013%i@ ## TopMiddle=@00200020@ ## TopRight=@00081030@\n@00080020@\n@00080030@\n@00080050@ ## MiddlePercentageSize=20 ## ";
	mpFormatsFull["NM"]		= "BottomLeft=C@00281050@\nW@00281051@ ## BottomMiddle=@00200020@ ## BottomRight=@00080070@ ## MiddleLeft=@00200020@ ## MiddleRight=@00200020@ ## TopLeft=@00100010@\nDOB: @00100030@\n@00200013%i@ (F@frame@/@00280008@) ## TopMiddle=@00200020@ ## TopRight=@00081030@\n@00080020@\n@00080030@\n@00080050@ ## MiddlePercentageSize=20 ## ";

	// used for testing purposes, shows some extra dicom tags in the viewport annotations
	if (GetCommandLineOptions()["debug"] == "1")
	{
		mpFormatsFull["CT"]		= "DerivePatientOrientation=1 ## BottomLeft=SP:@00201041%5.1f@mm\nST:@00180050%5.1f@mm\nIP:@00200032[0]%5.1f@,@00200032[1]%5.1f@,@00200032[2]%5.1f@\nIO:@00200037[0]%2.0f@,@00200037[1]%2.0f@,@00200037[2]%2.0f@,@00200037[3]%2.0f@,@00200037[4]%2.0f@,@00200037[5]%2.0f@\nPS:@00280030[0]%5.2f@,@00280030[1]%5.2f@\nRecDia:@00181100%i@\nC@00281050@\nW@00281051@ ## BottomMiddle=@00200020@ ## BottomRight=@00280004@\n@00081090@\n@00080070@ ## MiddleLeft=@00200020@ ## MiddleRight=@00200020@ ## TopLeft=@00100010@\nDOB: @00100030@\n@00200013%i@ ## TopMiddle=@00200020@ ## TopRight=@00081030@\n@00080020@\n@00080030@\n@00080050@ ## MiddlePercentageSize=20 ## ";	
		mpFormatsFull["PT"]		= "DerivePatientOrientation=1 ## BottomLeft=SP:@00201041%5.1f@mm\nST:@00180050%5.1f@mm\nIP:@00200032[0]%5.1f@,@00200032[1]%5.1f@,@00200032[2]%5.1f@\nIO:@00200037[0]%2.0f@,@00200037[1]%2.0f@,@00200037[2]%2.0f@,@00200037[3]%2.0f@,@00200037[4]%2.0f@,@00200037[5]%2.0f@\nPS:@00280030[0]%5.2f@,@00280030[1]%5.2f@\nRecDia:@00181100%i@\nU@00281050U@\nL@00281050L@ ## BottomMiddle=@00200020@ ## BottomRight=@00280004@\n@00081090@\n@00080070@ ## MiddleLeft=@00200020@ ## MiddleRight=@00200020@ ## TopLeft=@00100010@\nDOB: @00100030@\n@00200013%i@ ## TopMiddle=@00200020@ ## TopRight=@00081030@\n@00080020@\n@00080030@\n@00080050@ ## MiddlePercentageSize=20 ## ";	
	}

	var nodeConfig  = _xmlCfg.selectSingleNode('/dicomviewer/config');
	if (nodeConfig == null)	
		return;
		
	var nodeFormats =  _xmlCfg.createNode(1, 'annotationformats', '');
	nodeConfig.appendChild(nodeFormats);
	
	for (var strModality in mpFormatsFull)
	{
		var nodeFormat	= _xmlCfg.createNode(1, 'annotationformat', '');	
		var nodeFull	= _xmlCfg.createNode(1, 'full', '');	

		nodeFormat.setAttribute('modality', strModality);
		nodeFull.text = mpFormatsFull[strModality];
		
		nodeFormat.appendChild(nodeFull);
		nodeFormats.appendChild(nodeFormat);	
	}
}}


//
//	GetItem
//
function ConfigFile.prototype.GetItem(strXPath, strDefault)
{ with(this) {
	if (strDefault == null)
	{
		strDefault = '';
	}
	var node = _xmlCfg.selectSingleNode(strXPath);
	return node ? node.text : strDefault;
}}

//
// ProvidedByTitle
//
function ConfigFile.prototype.ProvidedByTitle()
{ with(this) {
	return GetItem('/dicomviewer/providedBy/title');
}}

//
// ProvidedByText
//
function ConfigFile.prototype.ProvidedByText()
{ with(this) {
	return GetItem('/dicomviewer/providedBy/text');
}}

//
// ProvidedByUrl
//
function ConfigFile.prototype.ProvidedByUrl()
{ with(this) {
	return GetItem('/dicomviewer/providedBy/url');
}}

//
// ProvidedByPicture
//
function ConfigFile.prototype.ProvidedByPicture()
{ with(this) {
	return GetItem('/dicomviewer/providedBy/picture');
}}

//
// LocaleId
//
function ConfigFile.prototype.LocaleId()
{ with(this) {
	return GetItem('/dicomviewer/config/locale', 'en');
}}


//
// GetConfigNode
//
function ConfigFile.prototype.GetConfigNode()
{ with(this) {
	return _xmlCfg.selectSingleNode('/dicomviewer/config');
}}


//
// GetWindowLevelPresetNode
//
function ConfigFile.prototype.GetWindowLevelPresetNode()
{ with(this) {
	return _xmlCfg.selectSingleNode('/dicomviewer/windowpresets');
}}


//
// GetPETThresholdParameters
//
function ConfigFile.prototype.GetPETThresholdParameters()
{ with(this) {

	var node = _xmlCfg.selectSingleNode('/dicomviewer/config/ctpetfusion/petthresholdparameters');
	if (node == null)
		return '0;0;100;100';
		
	var strParams = '';
	strParams += node.getAttribute('discardlowerpct') + ';';
	strParams += node.getAttribute('discardupperpct') + ';';
	strParams += node.getAttribute('meanupperpct') + ';';
	strParams += node.getAttribute('minupper');
	return strParams;
}}


//
// GetDefaultColorMapFile
//
function ConfigFile.prototype.GetDefaultColorMapFile()
{ with(this) {

	var node = _xmlCfg.selectSingleNode('/dicomviewer/config/ctpetfusion/defaultcolormap');
	return node != null ? node.getAttribute('value') : 'colormap/hotiron.col';
}}


//
// GetImagesPerPage
//
function ConfigFile.prototype.GetImagesPerPage()
{ with(this) {

	var node = _xmlCfg.selectSingleNode('/dicomviewer/config/ctpetfusion/imagesperpage');
	return node != null ? parseInt(node.getAttribute('value')) : 42;
}}


//
// GetCommandLineOptions()
//
function ConfigFile.prototype.GetCommandLineOptions()
{ with(this) {

	if (this._mpCmdLine != null)
		return this._mpCmdLine;

	this._mpCmdLine = new Object();

	if (location.search.indexOf('?') != 0)
		return _mpCmdLine
		
	var strCmdLine = unescape(location.search);
	strCmdLine = strCmdLine.substr(1, strCmdLine.length - 1);

	ParseNameValueString(_mpCmdLine, strCmdLine, '&', '=');
	
	return _mpCmdLine;
}}
