//
// (c)2004 GE Medical Systems
//
//
// Description: Debugging functions
//

//
// Logging functions
// Note that the format of these EVENT_LOG macros is different from the C++ format
//
function EVENT_LOG_INFO(id, strLog, strCaller)		{ _debug.Log("I", id, strLog, strCaller); }
function EVENT_LOG_WARNING(id, strLog, strCaller)	{ _debug.Log("W", id, strLog, strCaller); }
function EVENT_LOG_ERROR(id, strLog, strCaller)		{ _debug.Log("E", id, strLog, strCaller); }
function EVENT_LOG_ALWAYS(id, strLog, strCaller)	{ _debug.Log("A", id, strLog, strCaller); }
function EVENT_LOG_LINK(id, strLog, strCaller)		{ _debug.Log("L", id, strLog, strCaller); }
function EVENT_LOG_PERFORMANCE(id, strLog, strCaller){ _debug.Log("P", id, strLog, strCaller); }
function TRACE(strTrace, strCaller)				{ return _debug.Trace(strTrace, strCaller); }






//
// Debug c'tor
//
function Debug()
{ with(this) {
	this.p_wndLog = null;
	this._rdocLog = null;
	this._bTrace  = false;
}}

//
// IsNull
//
function Debug.prototype.IsNull()
{
	return false;
}


//
// CreateXmlDoc
//
function Debug.prototype.CreateXmlDoc(oSrc)
{
	var xmlResult = new ActiveXObject('MSXML.FreeThreadedDOMDocument');
	xmlResult.async = false;
	xmlResult.validateOnParse = false;
	xmlResult.resolveExternals = false;

	if (oSrc == null)
		return xmlResult;

	var bLoaded = false;

	if (typeof(oSrc) == 'string' && oSrc.match('\s*<') != null)	// oSrc is XML string
	{
		bLoaded = xmlResult.loadXML(oSrc);
	}
	else								// oSrc is path or stream or domdocument
	{
		bLoaded = xmlResult.load(oSrc);
	}
	if (xmlResult == null || !bLoaded)
	{
		alert("Error creating Xml document");
		return null;
	}

	return xmlResult;
}


//
// StartLog
//
function Debug.prototype.StartLog()
{
}	


//
// EndLog
//
function Debug.prototype.EndLog()
{ with (this) {
	if (p_wndLog)
	{
		p_wndLog.DetachSubject();
	}
}}


//
// SetLogWnd
//
function Debug.prototype.SetLogWnd(wnd)
{ with (this) {
	if (wnd == null)
	{
		_debug = new DebugNull();
	}
	else
	{
		this.p_wndLog = wnd;
	}
}}


//
// Log
//
function Debug.prototype.Log(strKind, id, strLog, strCaller)
{ with (this) {

	if (_rdocLog == null)
		return false;

	if (strCaller == null)
	{
		ASSERT(Log.caller != null);
		strCaller = GetFnName(Log.caller.caller);
	}

	var elem = _rdocLog.createElement('item');
	elem.setAttribute('date', Math.floor(_viewapp.GetQueryPerformanceCounter()));
	elem.setAttribute('caller', strCaller == null || strCaller == "" ? "?" : strCaller);
	elem.setAttribute('kind', strKind);
	elem.setAttribute('id', id);
	elem.text = strLog;
	_rdocLog.selectSingleNode('wvlog').appendChild(elem);
	return true;
}}


//
// Trace
//
function Debug.prototype.Trace(strTrace, strCaller)
{ with (this) {

	if (!_bTrace || _rdocLog == null)
		return false;

	if (strCaller == null)
	{
		ASSERT(Trace.caller != null);
		strCaller = GetFnName(Trace.caller.caller);	
	}

	var elem = _rdocLog.createElement('item');
	elem.setAttribute('date', new Date().toLocaleTimeString());
	elem.setAttribute('caller', strCaller == null || strCaller == "" ? "?" : strCaller);
	elem.setAttribute('kind', "T");
	elem.text = strTrace;
	_rdocLog.selectSingleNode('wvlog').appendChild(elem);
	return true;
}}


//
// SetTrace
//
function Debug.prototype.SetTrace(bEnable)
{ with (this) {
	_bTrace = bEnable;
}}


//
// DebugShowGlobals
//
function DebugShowGlobals()
{
	// This code helps you to find the variables declared on _global. 
	// You will find them on the "Local" debug window in Interdev.
	eval('debugger; //  (F5 to continue) ');
}


//-----------------	DebugNull -----------------------------

//
// DebugNull c'tor
//
function DebugNull()
{
}


//
// Trace
//
function DebugNull.prototype.Trace()
{
	return false;
}


//
// Log
//
function DebugNull.prototype.Log()
{
	return false;
}

//
// IsNull
//
function DebugNull.prototype.IsNull()
{
	return true;
}



//
//	ASSERT()
//
function ASSERT(bCond)
{
	if (bCond)
		return;

	var	strMsg = "error: ASSERT fired! (Callstack follows) \n" +  GetCallStack(ASSERT.caller, 20) +"\nDebug?";
	EVENT_LOG_ERROR(-1, strMsg);

	if (/* !_debug.IsNull() && */ confirm(strMsg))
		debugger;
}


//
// GetCallStack
//
function GetCallStack(fn, depth)
{
	if (fn == null || depth <= 0)
		return "";

	var str = "";

	for (var i= 0; i<fn.arguments.length; i++)
	{
		var arg = fn.arguments[i];
		str += ", " + ((arg + "" === arg) ? '"' + arg + '"' : arg);
	}
	return GetFnName(fn) + "(" + str.substr(2) + ") \n" + GetCallStack(fn.arguments.callee.caller, depth - 1);
}


//-----------------	CStopWatch ----------------------------

//
// CStopWatch ctor
//
function CStopWatch(strDescr, bAutoStart /*true*/) 
{ 
	this._strDescr = strDescr == null ? GetFnName(CStopWatch.caller) : strDescr;
	this._cLapTime   = 0;
	this._cTotalTime = 0;
	this._bRunning   = false;
	this._cStartTime = 0;

	if (bAutoStart == null || (bAutoStart != null && bAutoStart))
	{
		this.Start();
	}
}


//
// Stop
//
function CStopWatch.prototype.Stop(strCaller)
{ with (this) {
	RecordTime(false, true, null, strCaller == null ? GetFnName(Stop.caller) : strCaller);
}}


//
// Reset()
//
function CStopWatch.prototype.Reset()
{ with (this) {
	_cLapTime   = 0;
	_cTotalTime = 0;

	_bRunning   = false;
	_cStartTime = 0;
}}


//
// Lap
//
function CStopWatch.prototype.Lap(strLap, bLog, strCaller)
{ with (this) {
	RecordTime(true, bLog, strLap, strCaller == null ? GetFnName(Lap.caller) : strCaller);
}}


var g_swInitialImageDisplay = new CStopWatch("Initial Image Display", false);



function TestForScrollErrors(doc)
{
	if (_debug.IsNull())
		return;

	for (var i = 0; i < doc.all.length; ++i)
	{
		var elem = doc.all(i);
		elem.scrollTop = 1;
		elem.scrollLeft = 1;
		if (elem.scrollTop == 1 )
		{
			if (elem.scrollHeight == elem.offsetHeight)
			{
				elem.style.border = "3px solid white";
				elem.style.visibility = "visible;"
				EVENT_LOG_INFO(-1, doc.title + " " + elem.tagName + elem.id + " " + elem.offsetWidth + " "  + elem.offsetHeight, "TestForScrollErrors");
				continue;
			}
		}
		if (elem.scrollLeft == 1 )
		{
			if (elem.scrollWidth == elem.offsetWidth)
			{
				EVENT_LOG_INFO(-1, doc.title + " " + elem.tagName + elem.id + " " + elem.offsetWidth + " "  + elem.offsetHeight, "TestForScrollErrors");
				elem.style.border = "3px solid white";
				elem.style.visibility = "visible";
			}
		}
		elem.scrollTop = 0;
		elem.scrollLeft = 0;
	}
}
