//
//	Copyright (c)2004 GE Medical Systems
//

DeriveFrom(ViewportLayoutManager, TableLayoutManager);

//
// ViewportLayoutManager C'tor
//
function ViewportLayoutManager(elemContainer, nSeriesNr)
{
	this._nSeriesIndex		= nSeriesNr;
	this._activeviewport	= 0;		// index of the viewport with the red border in the layout
	this._dicomdirseriesnr	= 0;		// index of the series in the dicomdir
	this._dicomdirimagenr	= 0;		// index of the first image of the series in the DDTV control
	this._rgviewport		= null;
	
	this.CtorTableLayoutManager(this, elemContainer);
	this.SetViewportLayout(1, 1);
}


//
// CreateCellContent
//
function ViewportLayoutManager.prototype.CreateCellContent(iCell)
{ with(this) {
	var objViewport = new Viewport(iCell, _nSeriesIndex);
	_rgviewport[_rgviewport.length] = objViewport;
	return '<div class=\"classFocusEdge\"><div class="classNoFocus">' + objViewport.GetObjectElementString() + '</div></div>';
}}


//
// SetViewportLayout
//
function ViewportLayoutManager.prototype.SetViewportLayout(newRowCnt, newColCnt)
{ with(this) {
	if (newRowCnt == GetRowCount() && newColCnt == GetColCount())
		return false;
		
	DisposeViewports();

	_rgviewport = new Array();
	
	ChangeLayout(newRowCnt, newColCnt);
	
	InitViewports();
	return true;
}}


//
// GetViewportCount
//
function ViewportLayoutManager.prototype.GetViewportCount()
{ with(this) {
	return GetCellCount();
}}


//
// SetActiveViewport
//
function ViewportLayoutManager.prototype.SetActiveViewport(nViewportIndex)
{ with(this) {
	var viewportActive = GetActiveViewport();
	if (viewportActive != null)
	{
		viewportActive.MakeInactive();
	}

	_activeviewport = nViewportIndex;

	viewportActive = GetActiveViewport();
	viewportActive.MakeActive();
	return viewportActive;
}}


//
// GetActiveViewport
//
function ViewportLayoutManager.prototype.GetActiveViewport()
{ with(this) {
	return _rgviewport[_activeviewport];
}}


//
// GetViewport
//
function ViewportLayoutManager.prototype.GetViewport(iIdx)
{ with(this) {
	return _rgviewport[iIdx];
}}


//
// GetLayout
//
function ViewportLayoutManager.prototype.GetLayout()
{ with(this) {
	return GetRowCount().toString() + 'x' + GetColCount().toString();
}}


//
// InitViewports
//
function ViewportLayoutManager.prototype.InitViewports()
{ with(this) {
	var cviewport = GetViewportCount();
	for (var iviewport = 0; iviewport < cviewport; iviewport++)
	{
		_rgviewport[iviewport].Init(GetTableCell(iviewport).children[0].children[0].children[0]);
	}
}}


//
// DisposeViewports
//
function ViewportLayoutManager.prototype.DisposeViewports()
{ with(this) {
	var cviewport = GetViewportCount();
	for (var iviewport = 0; iviewport < cviewport; iviewport++)
	{
		_rgviewport[iviewport].Dispose();
	}
}}


//
// SetImageNr
//
function ViewportLayoutManager.prototype.SetImageNr(nImageIndex)
{ with(this) {
	_dicomdirimagenr = nImageIndex;
}}


//
// GetImageNr
//
function ViewportLayoutManager.prototype.GetImageNr()
{ with(this) {
	return _dicomdirimagenr;
}}


//
// GetSeriesNr
//
function ViewportLayoutManager.prototype.GetSeriesNr()
{ with(this) {
	return _dicomdirseriesnr;
}}


//
// SetSeriesNr
//
function ViewportLayoutManager.prototype.SetSeriesNr(nSeriesIndex)
{ with(this) {
	_dicomdirseriesnr = nSeriesIndex
}}

//
//	FindViewport()
//
function ViewportLayoutManager.prototype.FindViewport(oViewport)
{ with(this) {

	var cviewport = GetViewportCount();
	for (var iviewport = 0; iviewport < cviewport; iviewport++)
	{
		if (_rgviewport[iviewport].Match(oViewport))
			return _rgviewport[iviewport];
	}
	return null;
}}
