//
// (c)2004 GE Medical Systems
//

TableLayoutManager.prototype._nRows = 0;
TableLayoutManager.prototype._nColumns = 0;

//
// TableLayoutManager Ctor
//
function TableLayoutManager(oTableContentProvider, elemContainer, nRows, nColumns)
{
	this._oTableContentProvider		= oTableContentProvider;
	this._elemContainer				= elemContainer;
	this._elemContainer.innerHTML	= '<table id=\"idTable\">\n</table>\n';
	this._oTable					= this._elemContainer.childNodes[0];
	
	if (nRows != null && nColumns != null)
	{
		this.ChangeLayout(nRows, nColumns);
	}
}


//
// GetRowCount
//
function TableLayoutManager.prototype.GetRowCount()
{ with(this) {
	return _nRows;
}}


//
// GetColCount
//
function TableLayoutManager.prototype.GetColCount()
{ with(this) {
	return _nColumns;
}}


//
// GetCellCount
//
function TableLayoutManager.prototype.GetCellCount()
{ with(this) {
	return _nRows * _nColumns;
}}


//
// GetTableCell
//
function TableLayoutManager.prototype.GetTableCell(iIdx)
{ with(this) {
	return _oTable.cells[iIdx];
}}


//
// ChangeLayout
//
function TableLayoutManager.prototype.ChangeLayout(nNewRowCnt, nNewColumnCnt, bUseMargin)
{ with(this) {

	if (nNewRowCnt == 0 || nNewColumnCnt == 0 || (nNewRowCnt == _nRows && nNewColumnCnt == _nColumns))
		return;

	_nRows    = nNewRowCnt;
	_nColumns = nNewColumnCnt;
	
	var nCellSpacing	= bUseMargin ? 5 : 0;

	var strTable = '<table id=\"idTable\" width=\"100%\" height=\"100%\" cols=' + _nColumns + ' cellspacing=' + nCellSpacing + ' cellpadding=\"0px\">\n';
	for (var iRows = 0; iRows < _nRows; iRows++)
	{
		strTable += '<tr>';
		for (var iColumns = 0; iColumns < _nColumns; iColumns++)
		{
			var percentage = 100/_nColumns;
			var iCell = iRows * _nColumns + iColumns;
			strTable += '<td width="' + percentage.toString() + '%">' + _oTableContentProvider.CreateCellContent(iCell); + '</td>';
		}
		strTable += '</tr>';
	}
	strTable += '</table>\n';
	
	_elemContainer.innerHTML = strTable;
	_oTable = _elemContainer.childNodes[0];
}}
