//
//	Copyright (c)2004 GE Medical Systems
//
//	Helper comment to enable syntax coloring in InterDev: <script>

var _serieslayoutman = null;
var _bUpdateViewports = true;

//
// HasErrors
//
function HasErrors()
{
	if (_serieslayoutman == null)
		return true;
		
	var cseries = _serieslayoutman.GetSeriesCount();
	for (var iseries = 0; iseries < cseries; iseries++)
	{
		var series		= _serieslayoutman.GetSeries(iseries);
		var cviewport	= series.GetViewportCount();
		for (var iviewport = 0; iviewport < cviewport; iviewport++)
		{
			if (series.GetViewport(iviewport).HasErrors())
				return true;
		}
	}

	return false;
}


//
// GetErrorText
//
function GetErrorText()
{
	var cseries = _serieslayoutman.GetSeriesCount();
	for (var iseries = 0; iseries < cseries; iseries++)
	{
		var series		= _serieslayoutman.GetSeries(iseries);
		var cviewport	= series.GetViewportCount();
		for (var iviewport = 0; iviewport < cviewport; iviewport++)
		{
			if (series.GetViewport(iviewport).HasErrors())
				return series.GetViewport(iviewport).GetErrorText();
		}
	}

	return '';
}


//
// UpdateAllViewports
//
function UpdateAllViewports(bIsPetCtMode, dicomdirframe)
{
	if (!_bUpdateViewports)
		return;

	var series			= _serieslayoutman.GetActiveSeries();
	var cviewport		= series.GetViewportCount();
	
	for (var iviewport = 0; iviewport < cviewport; iviewport++)
	{
		series.GetViewport(iviewport).UpdateViewport(dicomdirframe, bIsPetCtMode);
	}
}


//
// OnShowAnnotationsChange
//
function OnShowAnnotationsChange(bIsPetCtMode)
{
	for (var iseries = 0; iseries < _serieslayoutman.GetSeriesCount(); iseries++)
	{
		var series = _serieslayoutman.GetSeries(iseries);
		for (var iviewport = 0; iviewport < series.GetViewportCount(); iviewport++)
		{
			series.GetViewport(iviewport).OnShowAnnotationsChange(bIsPetCtMode);
		}
	}
}


//
// OnPresentationStateChange
//
function OnPresentationStateChange(value)
{
	var seriesActive	= _serieslayoutman.GetActiveSeries();
	for (var iviewport = 0; iviewport < seriesActive.GetViewportCount(); iviewport++)
	{
		seriesActive.GetViewport(iviewport).OnPresentationStateChange(value);
	}
}


//
// GetViewportCount
//
function GetViewportCount()
{
	return GetActiveSeries().GetViewportCount();
}


//
// IsSelectedImageMultiFrame
//
function IsSelectedImageMultiFrame()
{
	return (GetActiveViewport().GetFrameCount() > 1);
}


//
// SetActiveViewport
//
function SetActiveViewport(nViewportIndex, nSeriesIndex)
{
	if (nSeriesIndex != null && _serieslayoutman.GetActiveSeriesIndex() != nSeriesIndex)
	{
		var seriesActive = _serieslayoutman.GetActiveSeries();
		seriesActive.SetSeriesNr(parent._dicomdirframe.GetActiveSeriesIndex());
		seriesActive.SetImageNr(parent._dicomdirframe.GetActiveImageIndex());

		_bUpdateViewports = false;	// ignore OnImageChanged event
		seriesActive = _serieslayoutman.SetActiveSeries(nSeriesIndex);
		parent.SetDicomDirActiveImages(seriesActive.GetSeriesNr(), seriesActive.GetImageNr());
		_bUpdateViewports = true;
	}
	
	var viewportActive = GetActiveSeries().SetActiveViewport(nViewportIndex);
	parent.viewcontrol.listPresentationStates.value = viewportActive.GetPresentationStateIndex();

	var bIsPetCtMode = parent.IsPetCtMode();
	if (bIsPetCtMode)
	{
		_bUpdateViewports = false;	// ignore OnImageChanged event	
		parent.SetDicomDirActiveImages(nViewportIndex, 0);
		_bUpdateViewports = true;
	}
	else
	{
		parent.viewcontrol.UpdateControls(parent._dicomdirframe, bIsPetCtMode);
	}
		
	return viewportActive;
}


//
// GetActiveSeries
//
function GetActiveSeries()
{
	return _serieslayoutman.GetActiveSeries();
}


//
// GetActiveSeriesIndex
//
function GetActiveSeriesIndex()
{
	return _serieslayoutman.GetActiveSeriesIndex();
}


//
// GetActiveViewport
//
function GetActiveViewport()
{
	return GetActiveSeries().GetActiveViewport();
}


//
// PropagateAttributes
//
function PropagateAttributes(bIsPetCtMode, attributes)
{
	var seriesActive	= _serieslayoutman.GetActiveSeries();	
	var viewportActive	= seriesActive.GetActiveViewport();
	
	if (bIsPetCtMode)
	{
		viewportActive.SetAttributes(attributes);	
		
		var nViewportIndex = viewportActive.GetViewportIndex();
		if (nViewportIndex == SERIESTYPE_CT || nViewportIndex == SERIESTYPE_PT)
		{
			seriesActive.GetViewport(SERIESTYPE_FUSED).ApplyFusionWindowLevels();
		}
		
		return;
	}
	
	var cviewport = seriesActive.GetViewportCount();
	for (var iviewport = 0; iviewport < cviewport; iviewport++)
	{
		var viewport = seriesActive.GetViewport(iviewport);
		if (viewport == viewportActive)
			continue;
			
		viewport.SetAttributes(attributes);
	}
}


//
// GetViewportLayout
//
function GetViewportLayout()
{
	return _serieslayoutman.GetActiveSeries().GetLayout();
}


//
// SetViewportLayout
//
function SetViewportLayout(nRows, nColumns)
{
	return _serieslayoutman.GetActiveSeries().SetViewportLayout(nRows, nColumns);	// change currently selected series area
}


//
// GetSeriesLayout
//
function GetSeriesLayout()
{
	return _serieslayoutman.GetSeriesLayout();
}


//
// SetSeriesLayout
//
function SetSeriesLayout(nRows, nColumns)
{
	return _serieslayoutman.SetSeriesLayout(nRows, nColumns);
}


//
// OnLoad
//
function OnLoad()
{
	_serieslayoutman = new SeriesLayoutManager(divViewportTable);
	_serieslayoutman.SetSeriesLayout(1, 1);
}


//
// UnlockViewports
//
function UnlockViewports(licensekey)
{
	for (var iseries = 0; iseries < _serieslayoutman.GetSeriesCount(); iseries++)
	{
		var series = _serieslayoutman.GetSeries(iseries);
		for (var iviewport = 0; iviewport < series.GetViewportCount(); iviewport++)
		{
			series.GetViewport(iviewport).Unlock(licensekey);
		}
	}
}
