function varargout = plotPointModel(varargin)

error(nargchk(0,inf,nargin));
pts = [];
axish = [];
edges = [];
linecol = [1 1 1];
edgecol = 'r';
facecol = 'y';

if mod(length(varargin),2) ~= 0
    % input args have not com in pairs, woe is me
    error(['Arguments to ', mfilename, ' must come param/value in pairs.'])
end
for i=1:2:length(varargin)
    switch lower(varargin{i})
        case 'pts'
            pts = varargin{i+1};
        case 'edges'
            edges = varargin{i+1};
        case 'parent'
            axish = varargin{i+1};
        otherwise
            error(['Unknown parameter name passed to ', mfilename, '.  Name was ' varargin{i}])
    end
end
if isempty(pts)
   error('PTS parameter must be supplied');
end
if isempty(axish)
    axish = gca;
end

if iscell(edges)
    if ~isempty(edges)
        edges = edges{1};
    else
        edges = [];
    end
end
hold(axish, 'on');
dimension = size(pts,2);

[segmentPoint, offsets] = isAugmentedProject;
if ~isempty(segmentPoint)
    pts = splitPoints(pts, segmentPoint, offsets);
end
ph = [];
switch dimension
    case 3
        ph = plot3(axish, pts(:,1), pts(:,2), pts(:,3), 'o', 'MarkerFaceColor', 'y', 'MarkerEdgeColor', 'r');
    case 2
        ph = plot(axish, pts(:,1), pts(:,2), 'o', 'MarkerFaceColor', 'y', 'MarkerEdgeColor', 'r');
end
eh = aamdisp_plotEdges('pts', pts, 'edges', edges, 'parent', axish);
shapehandle.pts_h = ph;
shapehandle.edge_h = eh;
varargout{1} = shapehandle;
return

function plotEdges(pts, edges, dim, axish)
ph = [];
switch dim
    case 3
        for i=1:size(edges,1)
            ph = cat(2, ph, plot3(axish, [pts(edges(i,1),1), pts(edges(i,2),1)], [pts(edges(i,1),2), pts(edges(i,2),2)], [pts(edges(i,1),3), pts(edges(i,2),3)]));
        end
    case 2
        for i=1:size(edges,1)
            ph = cat(2, ph, plot(axish, [pts(edges(i,1),1), pts(edges(i,2),1)], [pts(edges(i,1),2), pts(edges(i,2),2)]));
        end
end
