function VectorWalker(varargin)
%   Dr. A. I. Hanna (2005) CMP, UEA, 2006.
error(nargchk(0,inf,nargin));

if mod(length(varargin),2) ~= 0
    % input args have not com in pairs, woe is me
    error('Arguments to VectorWalker must come param/value in pairs.')
end
ad.data.pdm = [];
ad.data.xlim = [];
ad.data.edges = [];
ad.data.ylim = [];
ad.data.direction = 1;
ad.data.units = 'var';
ad.data.selectedShapePC =[];
for i=1:2:length(varargin)
    switch lower(varargin{i})
        case 'pdm'
            ad.data.pdm = varargin{i+1};
        case 'shapes'
            ad.data.B = varargin{i+1};
        case 'ploth'
            ad.data.ph = varargin{i+1};
        case 'pcs'
            ad.data.selectedShapePC = varargin{i+1};
        case 'edges'
            ad.data.edges = varargin{i+1};
        case 'units'
            ad.data.units = varargin{i+1};
        otherwise
            error(['Unknown parameter name passed to VectorWalker.  Name was ' varargin{i}])
    end
end

% Open, move, and get the handles from the figure file.
fig = openfig(mfilename, 'reuse');
% Move the gui and then show it, rather than have it jump all over the
% place.
movegui(fig, 'center');
set(fig, 'visible', 'on');

handles = guihandles(fig);
set(handles.shapeslider, 'Value', 1, 'Min', 1, 'Max', size(ad.data.B,2), 'SliderStep', [.01 .1]);
set(handles.shapeslider, 'callback', {@doMoveShape});
set(handles.startbtn, 'callback', {@doStartStop});
mb = ad.data.B(:, 1);
shape = ad.data.pdm.Xm + ad.data.pdm.pca.P*mb;
pts = reshape(shape, 2, length(shape)/2)';
ad.data.shapehandle = plotPointModel('pts', pts, 'parent', handles.mainAxes, 'edges', ad.data.edges);

%ad.data.shapehandle = plot(handles.mainAxes, shape(1:2:end),  shape(2:2:end), 'o', 'MarkerFaceColor', 'y', 'MarkerEdgeColor', 'r');
axis(handles.mainAxes, 'image', 'xy');
figcol = [0 0 0];
gridcol = [1 1 1];
set(fig, 'Color', figcol);
set(handles.mainAxes, 'Color', figcol, 'XColor', gridcol, 'YColor', gridcol,'ZColor', gridcol);


ad.handles = handles;
setappdata(0,'VectorWalkerData',ad);
try
    uiwait(fig);
catch
    if ishandle(fig)
        delete(fig)
    end
end
delete(ad.data.ph);
return;
%%%
%
%%%
function doMoveShape(sliderh, evd)
ad = getappdata(0,'VectorWalkerData');

P = ad.data.pdm.pca.P;

b = ad.data.pdm.pca.b;
if strcmpi(ad.data.units, 'std')
    bscale = sqrt(b);
else
    bscale = ones(size(b));
end
    
pcs = ad.data.selectedShapePC;
Xm = ad.data.pdm.Xm;
B = ad.data.B;
mb = B(:, round(get(sliderh, 'value')));

shape = Xm + P*(mb.*bscale);

shape = reshape(shape, 2, length(shape)/2);
[segmentPoint, offsets] = isAugmentedProject;
if ~isempty(segmentPoint)
    shape = splitPoints(shape', segmentPoint, offsets)';
end
edges = ad.data.edges{1};
set(ad.data.shapehandle.pts_h, 'XData', shape(1,:), 'YData', shape(2,:));
for i=1:length(ad.data.shapehandle.edge_h)
    set(ad.data.shapehandle.edge_h(i), 'XData', [shape(1, edges(i,1)), shape(1, edges(i,2))], 'YData', [shape(2, edges(i,1)), shape(2, edges(i,2))]);
end
%delete(ad.data.shapehandle.pts_h);
%delete(ad.data.shapehandle.edge_h);
%ad.data.shapehandle = plotPointModel('pts', shape', 'parent', ad.handles.mainAxes, 'edges', ad.data.edges);

switch length(pcs)
    case 2
        set(ad.data.ph, 'XData', mb(1), 'YData', mb(2));
    case 3
        set(ad.data.ph, 'XData', mb(1), 'YData', mb(2), 'ZData', mb(3));
end
axis(ad.handles.mainAxes, 'image', 'xy');
curr_xlim = get(ad.handles.mainAxes, 'XLim');
curr_ylim = get(ad.handles.mainAxes, 'YLim');
if isempty(ad.data.xlim)
    ad.data.xlim = curr_xlim;
    ad.data.ylim = curr_ylim;
else
    if curr_xlim(1)<ad.data.xlim(1); ad.data.xlim(1) = curr_xlim(1); end;
    if curr_xlim(2)>ad.data.xlim(2); ad.data.xlim(2) = curr_xlim(2); end;
    if curr_ylim(1)<ad.data.ylim(1); ad.data.ylim(1) = curr_ylim(1); end;
    if curr_ylim(2)>ad.data.ylim(2); ad.data.ylim(2) = curr_ylim(2); end;
end
set(ad.handles.mainAxes, 'XLim', ad.data.xlim, 'YLim', ad.data.ylim);
setappdata(0,'VectorWalkerData', ad);
%%%
%
%%%
function doStartStop(startbtn, evd)
ad = getappdata(0,'VectorWalkerData');
speed = get(ad.handles.speedpopup, 'string');
speed = str2num(speed{get(ad.handles.speedpopup, 'value')});
if get(startbtn, 'value')==1
    set(startbtn, 'String', 'Stop');
else
    set(startbtn, 'String', 'Start');
end
while get(startbtn, 'value')==1
    ad = getappdata(0,'VectorWalkerData');
    sliderh = ad.handles.shapeslider;
    currval = get(sliderh, 'value');
    slidermax = get(sliderh, 'Max');
    slidermin = get(sliderh, 'Min');
    if (currval+ad.data.direction)>slidermax
        ad.data.direction = ad.data.direction*-1;
    end
    if (currval+ad.data.direction)<slidermin
        ad.data.direction = ad.data.direction*-1;
    end
    set(sliderh, 'value', currval+ad.data.direction);
    setappdata(0,'VectorWalkerData', ad);
    pause(speed);
    doMoveShape(ad.handles.shapeslider);
end
