function pcalib_demo_001

figure(1); clf;
subplot(1,3,1);
title('Unaligned shapes');
template = [0 1 1 0; 0 0 1 1];
template = template(:);
X = repmat(template, 1, 100);
X = X + rand(size(X))/10;
D = pcalib_randDeformMatrix2D(X);
pcalib_plotshapematrix(D, 'g', gca);
opts.scaling = 0;
opts.rotation = 1;
opts.translation = 1;

[X, template] = pcalib_GPA('data',D, 'template', template, 'opts', opts);

[X, template] = pcalib_GPA('data',D, 'opts', opts);
pcalib_shapesizemetric(template, size(template,1))
axis image;
subplot(1,3,2);
title('Aligned shapes');
pcalib_plotshapematrix(X, 'r', gca);
axis image;
subplot(1,3,3);
v = 1;
[Xm, P, b, pcaDat] = pcalib_pca(X, v);
pcalib_walkpc('Xm', Xm, 'P', P, 'b_model', b, 'pcind', ...
    1, 'stdevlimits', [-2 2], 'dstep', .5, 'Parent', gca);
title('A Walk though the first PC');
return;