function showSampleVolumes()

%% Define paths to sample volume data

seedlingCombinedTimepoints384CubedDir = '..\testData\825gfp32_140806_1724AND1856AND2028_384Cubed';
seedlingCombinedTimepoints256CubedDir = '..\testData\825gfp32_140806_1724AND1856AND2028_256Cubed';
seedlingCombinedTimepoints128CubedDir = '..\testData\825gfp32_140806_1724AND1856AND2028_128Cubed';
drosophila512CubedDir = '..\testData\drosophila (291gfp1+txr+vis)_512Cubed';
drosophila384CubedDir = '..\testData\drosophila (291gfp1+txr+vis)_384Cubed';
drosophila256CubedDir = '..\testData\drosophila (291gfp1+txr+vis)_256Cubed';
drosophila128CubedDir = '..\testData\drosophila (291gfp1+txr+vis)_128Cubed';
gradientCubeDir = '..\testData\gradientCubeOneDirection';
ctSphere128CubedDir = '..\testData\ctSphere128Cubed';
leaf256CubedDir = '..\testData\672clippedA256Cubed';
leaf128CubedDir = '..\testData\672clippedA128Cubed';
leaf128x128x50Dir = '..\testData\672clippedA128x128x50Cubed';
flower256CubedDir = '..\originalData\294rgvcut256Cubed';
confocalLeaf1024x1024x72Dir = '..\testData\sam\ExpID-17\leaf1_pm_19-12-06\leaf1_pm_19-12-06_Series016_t00_z000_ch00_png_1024x1024x72';
confocalLeaf256x256x72Dir = '..\testData\sam\ExpID-17\leaf1_pm_19-12-06\leaf1_pm_19-12-06_Series016_t00_z000_ch00_png_256x256x72';
confocalLeafCroppedTo256x256x56Dir = '..\testData\sam\ExpID-17\leaf1_pm_19-12-06\leaf1_pm_19-12-06_Series014_t05_z000_ch00_png_croppedTo_256x256x56';
confocalLeafNewDir = '..\testData\sam\ExpID-17\leaf1_pm_19-12-06\CroppedCleanedImage';
optConfocalSeriesOpt256x256x256Dir = '..\testData\optAndConfocal\879gfp310_256x256x256';
optConfocalSeriesConfocal256x256x79Dir = '..\testData\optAndConfocal\OPT_1_256x256x79';

% volumeDirs = {};
% volumeDirs{1} = drosophila512CubedDir;
% volumeDirs{2} = drosophila384CubedDir;
% volumeDirs{3} = drosophila256CubedDir;
% volumeDirs{4} = drosophila128CubedDir;
% volumeDirs{5} = seedling256CubedDir;
% volumeDirs{6} = gradientCubeDir;
% volumeDirs{7} = seedlingCombinedTimepoints384CubedDir;
% volumeDirs{8} = seedlingCombinedTimepoints256CubedDir;
% volumeDirs{9} = seedlingCombinedTimepoints128CubedDir;
% volumeDirs{10} = ctSphere128CubedDir;
% volumeDirs{11} = leaf256CubedDir;
% volumeDirs{12} = leaf256CubedDir;
volumeDirs{12}= leaf128CubedDir;
% volumeDirs{13}= leaf128CubedDir;
% volumeDirs{13} = leaf128x128x50Dir;
% volumeDirs{14} = flower256CubedDir;
% volumeDirs{15} = confocalLeaf1024x1024x72Dir;
% volumeDirs{16} = confocalLeaf256x256x72Dir;
% volumeDirs{18} = confocalLeafCroppedTo256x256x56Dir;
% volumeDirs{19} = confocalLeafNewDir;
% volumeDirs{20} = optConfocalSeriesConfocal256x256x79Dir;
% volumeDirs{21} = optConfocalSeriesOpt256x256x256Dir;

%% Load volumes and construct transforms for them

volumes = getHTVolume();
transforms = getHTTransform();
volumeCounter = 1;
% voxelSize = [0.00096, 0.00096, 0.0015];
% voxelSize = voxelSize .* 0.8;
voxelSize = [0.001, 0.001, 0.001];
% voxelSize = [1, 1, 1];
noOfPlanes = 256;

for i = 1:length(volumeDirs)
    
    if ischar(volumeDirs{i})
        %files = dir([volumeDirs{i}, filesep, '*.png']);
        files = dir([volumeDirs{i}, filesep, '*.png']);
        files = {files.name};

        % Get image dimensions and number of images to determine required space
        im = imread([char(volumeDirs{i}), filesep, files{1}]);
        dims = size(im);
        noOfSlices = length(files);

        % Swap size of third and fourth dimension in order to have the rgb vector
        % along the fourth dimension. Hence we later allocate a m x n x p x 3
        % matrix
        dims = [dims(1:2), length(files), dims(3)];

        noOfElements = prod(dims);
        disp(['Volume dimensions: ', sprintf('%d x %d x %d x %d', dims)]);
        disp(['Volume (uint8) size in MB: ', sprintf('%d', noOfElements / 2^20)])

        %% Allocate memory
        volume = ones(dims, 'uint8');

        %% Load images
        for j=1:length(files)
            im = imread([volumeDirs{i}, filesep, files{j}]);
            volume(:, :, j, :) = im(:, :, :);
        end

        % Construct a transform for each volume, set its name and use
        % defaults for the remaining fields
        t = getHTTransform();
        t.name = sprintf('transform%i', volumeCounter);
        transforms(volumeCounter) = t;
             
        v = getHTVolume();
        v.name = sprintf('volume%i', volumeCounter);
        v.parentTransform = sprintf('transform%i', volumeCounter);
        v.volume = volume;
        v.planes = noOfPlanes;
        v.voxelSize = voxelSize;
        v.hapticChannel = 'green';
        volumes(volumeCounter) = v;
        
        volumeCounter = volumeCounter + 1;
    end
end

%% Add point set from template from disk
% 
% load('../../Templates/LE50template_04_05_06.temp_dat', '-mat', 'PMTemplate');
% points128 = PMTemplate.pts;
% points128(3, :) = 0;
% scaleMat = makehgtform('scale', voxelSize);
% points128 = scaleMat(1:3, 1:3) .* 0.25 * points128;
% colours128 = zeros(size(points128));
% colours128(1, :) = 1;
% interactionMode128 = 'move';
% pointSets(1) = getHVPointSet('pointSet128', 'transform1', ...
%     points128, colours128, interactionMode128);

% The interior points
% load('../../Templates/LE50template_04_05_06.interior', '-mat',
% 'PMTemplate');
% points128Interior = load('../../Templates/LE50template_04_05_06.interior', '-mat');

%% Add manipulated template point set from disk

load('points128.pts', '-mat', 'points')
points128 = points;
colours128 = zeros(size(points128));
colours128(1, :) = 1;
interactionMode128 = 'move';

p = getHTPointSet();
p.name = 'pointSet128';
p.parentTransform = 'transform1';
p.points = points128;
p.colours = colours128;
p.interactionMode = interactionMode128;
pointSets(1) = p;

% pointSets(1) = getHVPointSet('pointSet128', 'transform1', ...
%     points128, colours128, interactionMode128);


%% Arrange volumes side by side
xDims = [];
totalWidth = 0;
spacing = 0.02;

for k = 1:length(volumes)
    l = size(volumes(k).volume, 2);
    totalWidth = totalWidth + l * voxelSize(1);
    
    if k ~= length(volumes)
        totalWidth = totalWidth + spacing;
    end
    
    xDims = [xDims l]; 
end

offset = -totalWidth / 2;

for m = 1:length(transforms)
    offset = offset + xDims(m) * voxelSize(1) / 2;
    
    if m ~= 1
        offset = offset + spacing;
        offset = offset + xDims(m - 1) * voxelSize(1) / 2;
    end
    
    transforms(m).translation(1) = offset;
end

%% For confocal images assign the green channel to the red and blue channel
%% as well in order to get a grey-scale image

% for l = 1:length(volumes)
%    volTemp = volumes(l).volume; 
%    volTemp(:, :, :, 1) = volTemp(:, :, :, 2);
%    volTemp(:, :, :, 3) = volTemp(:, :, :, 2);
%    volumes(1).volume = volTemp;
% end


%% Run haptic viewer after having set all the necessary variables

% load -mat '../../Templates/LE50template_04_05_06.temp_dat';
[transformsOut, volumesOut, pointSetsOut] =...
    hapticTool(transforms, volumes, pointSets);

% [transformsOut, volumesOut, pointSetsOut] =...
% hapticTool(transforms, volumesOut, pointSets);

%% Save the returned point set to disk

% points = pointSetsOut(1).points;
% save('points128.pts', 'points');



