function [Xm, P, b, pcaDat] = pcalib_pca(X, v)
% function [Xm, P, b, pcaDat] = pcalib_pca(X, v)
% A function that performs PCA on a matrix of data, where each column is an
% experiment, and each row corresponds to points in that experiment.
%
% re-arranged Dr. A. I. Hanna (2005).
if isempty(X)
    Xm = [];
    P = [];
    b = [];
    pcaDat = [];
    return;
end
X = X';
[m, n] = size(X);
% Find mean shape and the covariance matrix
Xm = mean(X,1);
d = X - repmat(Xm, m, 1);
S = cov(d);
if any(isnan(S(:)))
    Xm = [];
    P = [];
    b = [];
    pcaDat = [];
    return;
end
% Eigen-decomposition of covariance matrix
[V D] = eig(S);
% Sort in ascending order
D = diag(D);
[evals idx] = sort(D, 'descend');
evecs = V(:,idx);
% Find surviving eigenvectors
if sum(evals)==0
    vr = zeros(size(evals));
else
    vr = cumsum(evals) / sum(evals);
end
t = min(find(vr >= v)); %#ok<MXFND>
if v==1
    t = length(D);
end
% Keep only modes 1:t
Xm = Xm(:);
P = evecs(:,1:t);
b = evals(1:t);
pcaDat.P = evecs;
pcaDat.b = evals;
pcaDat.v = vr;
