function [volume] = loadVolumeFromSlicesDirTyped(fullVolumePath, extension, scale)
% function [volume] = loadVolumeFromSlicesDir(fullVolumePath, extension)
% 
% Description:
% Function to load slices given the directory where the slices reside and
% the extension of the graphics file type.
% 
% Author: Johann Strasser
% Date: 070312

volume = [];
files = dir(fullfile(fullVolumePath, ['*', extension]));

% Sort the filenames in ASCII dictionary order, just in case the list
% returned by the operating system is ordered differently
fileNames = sort({files.name});
noOfSlices = length(fileNames);
   
if noOfSlices > 0
    
    % Get image dimensions and number of images to determine required space
    im = imread(fullfile(fullVolumePath, fileNames{1}));
    im = imresize(im, scale);
    if length(size(im))==2
        im = repmat(im, [1 1 3]);
    end
    dims = size(im);

    % Swap size of third and fourth dimension in order to have the rgb vector
    % along the fourth dimension. Hence we later allocate a m x n x p x 3
    % matrix
        dslice = (1/scale);
      % dslice = 1;
        sliceind =round(1:dslice:noOfSlices);
        
    dims = [dims(1:2), length(sliceind), dims(3)];

    noOfElements = prod(dims);
    disp(['Volume dimensions: ', sprintf('%d x %d x %d x %d', dims)]);
    disp(['Volume (uint8) size in MB: ', sprintf('%d', noOfElements / 2^20)])

    % Allocate memory
    volume = ones(dims, 'uint8');

    % Load images
    j= 1;

    for i = sliceind
        im = imread(fullfile(fullVolumePath, fileNames{i}));
        im = imresize(im, scale);
               if length(size(im))==2
        im = repmat(im, [1 1 3]);
    end
        volume(:, :, j, :) = im(:, :, :);
        j = j+1;
    end

end