function apppcvarsheet = constructAppPCVarSheet(model)

apppcvarsheet = {};
sfam = loadSFAM(model);
if isempty(sfam)
    return;
end
if ~isfield(sfam, 'pca')
    return;
end
sfam = sfam.pca;
if ~isfield(sfam, 'b')
    return;
end
b = sfam.b;
S = sum(b(:));
apppcvarsheet{1, 1} = 'Variance';
apppcvarsheet{1, 2} = 'Standard Dev.';
apppcvarsheet{1, 3} = 'Percentage Of Total';

for i=1:length(b)
    apppcvarsheet{i+1, 1} = b(i);
    apppcvarsheet{i+1, 2} = sqrt(b(i));
    apppcvarsheet{i+1, 3} = 100*(b(i)/S);
end
return;
%%
function sfam = loadSFAM(model)
sfam = [];
direc = get(model, 'modelDirec');
fname = [pwd, filesep, direc, filesep, 'mod_sfam.mat'];
if ~exist(fname, 'file')
    return;
end
sfam = load(fname);
if ~isfield(sfam, 'sfam')
    sfam = [];
    return;
end
sfam = sfam.sfam;
return