function sheet1 = constructSheet1(model)
sheet1 = {};
projectname = pwd;
[projectdir, projectname, ext, vers] = fileparts(projectname);
sheet1{end+1, 1} = 'Project Name';
sheet1{end, 2} = projectname;
sheet1{end+1, 1} = 'Project Directory';
sheet1{end, 2} = projectdir;
sheet1{end+1, 1} = '';
sheet1{end+1, 1} = 'Model Name';
sheet1{end, 2} = get(model, 'modelName');
sheet1{end+1, 1} = 'Model Directory';
sheet1{end, 2} = get(model, 'modelDirec');
sheet1{end+1, 1} = '';
pdm = get(model, 'pdm');
for i=1:length(pdm.b)
    sheet1{end+1, 1} = sprintf('PC %d Variance', i);
    sheet1{end, 2} = pdm.b(i);
end
sheet1{end+1, 1} = '';
template = get(model, 'PointModelTemplate');
sheet1{end+1, 1} = 'Template Name';
sheet1{end, 2} = get(template, 'name');
sheet1{end+1, 1} = 'Template Directory';
sheet1{end, 2} = get(template, 'direc');
sheet1{end+1, 1} = 'Number of points';
sz = size(get(template, 'pts'));
sheet1{end, 2} = sz(2);
sheet1{end+1, 1} = 'Template Image Name';
sheet1{end, 2} = get(template, 'imageName');
sheet1{end+1, 1} = 'Template Image Directory';
sheet1{end, 2} = get(template, 'imageDir');
sheet1{end+1, 1} = '';
sheet1{end+1, 1} = 'Procrustes';
details = getBuildSettings(get(model, 'modelDirec'));
sheet1{end+1, 1} = 'Normalised Scaling';
sheet1{end, 2} = details.scaling;
sheet1{end+1, 1} = 'Normalised Rotation';
sheet1{end, 2} = details.rotation;
sheet1{end+1, 1} = 'Normalised Translation';
sheet1{end, 2} = details.translation;
sheet1{end+1, 1} = 'Number of pixels in appearance';
sheet1{end, 2} = details.pixelnumber;
sheet1{end+1, 1} = 'Variance captured';
sheet1{end, 2} = details.FractionPCs;
sheet1{end+1, 1} = '';
sheet1{end+1, 1} = 'Images used in model';
names = get(model, 'am_imagenames')
for i=1:length(names)
    sheet1{end+1, 1} = i;
    sheet1{end, 2} = names{i};
end
sheet1{end+1, 1} = '';
sheet1{end+1, 1} = 'Appearance Model Name';
sheet1{end, 2} = get(model, 'sfamName');
sheet1{end+1, 1} = 'Appearance Model Direc';
sheet1{end, 2} = get(model, 'sfamDirec');
sheet1{end+1, 1} = '';
sheet1{end+1, 1} = 'Shape Model Name';
sheet1{end, 2} = get(model, 'pdmName');
sheet1{end+1, 1} = 'Shape Model Direc';
sheet1{end, 2} = get(model, 'pdmDirec');
return;