function D = pcalib_randDeformMatrix2D(X)
% Dr. A. I. Hanna (2006)
dim = 2;
D = X;
for i=1:size(X,2)
    x = X(:,i);
    [x, mu] = pcalib_centershape(x, dim);

    Sx = pcalib_shapesizemetric(x, size(x,1));
    [x] = pcalib_scaleshape(x, 1);
    theta = unirndrange(0, 2*pi, 1, 1);
    R = [cos(theta) -sin(theta); sin(theta) cos(theta)];
    x = R*x;
    x = x.*(Sx*rand(1,1));
    x = x + repmat(mu+randn(size(mu))/10, 1, size(x,2));
    D(:,i) = x(:);
end
    