function pcalib_walkpc(varargin)
% function pcalib_walkpc(varargin)
%
% A simple script to walk along a specific principle component.
%
% Inputs:
%  Xm - the mean shape as a column vector of the form x = [x_1, y_1, x_2, y_2, ..., x_N, y_N]';
%  P - a matrix whose columns represent the principle components
%  pcind - an scalar which denotes the princple axes to move along
%  stdevlimits - number of standard deviations to move [-1 1];
%  axis_h - the handle to the axis to show the walk
%
% Dr. A. I. Hanna (2008)

% Default params
Xm = [];
P = [];
b_model = [];
pcind = 1;
stdevlimits = [-1 1];
dstep = 0.1;
axish = [];
loopflag = 0;
if mod(length(varargin),2) ~= 0
    % input args have not com in pairs, woe is me
    error(['Arguments to ', mfilename,' must come param/value in pairs.'])
end
for i=1:2:length(varargin)
    switch lower(varargin{i})
        case 'xm'
            Xm = varargin{i+1};
        case 'p'
            P = varargin{i+1};
        case 'b_model'
            b_model = varargin{i+1};
        case 'pcind'
            pcind = varargin{i+1};
        case 'stdevlimits'
            stdevlimits = varargin{i+1};
        case 'dstep'
            dstep = varargin{i+1};
        case 'parent'
            axish = varargin{i+1};
        case 'loop'
            loopflag = varargin{i+1};
        otherwise
            error(['Unknown parameter name passed to ', mfilename, '.  Name was ' varargin{i}])
    end
end
if isempty(Xm)
    error('Parameter Xm must be supplied');
end
if isempty(P)
    error('Parameter P must be supplied');
end
if isempty(b_model)
    error('Parameter b_model must be supplied');
end
if isempty(axish)
    axish = [];
end
kind = [0:-dstep:stdevlimits(1), stdevlimits(1):dstep:stdevlimits(2), stdevlimits(2):-dstep:0];
run =1;
while run
    for PCIND = pcind
        for k=kind
            title(sprintf('PC: %d, Value: %2.2f', PCIND, k));
            b = zeros(size(P,2),1);
            b(PCIND) = k*sqrt(b_model(PCIND));
            x = Xm + P*b;
            cla;
            plot(x(1:2:end), x(2:2:end), '.');
            drawnow;
        end
    end
    run = loopflag;
end
