function [value] = isProject3D(projectDir)
% function [value] = isProject3D(projectDir)
% 
% Description:
% A function to determine whether a project is a 3D project 
% 
% Author: Johann Strasser
% Date: 070312

type = getProjectType(projectDir);

switch lower(type)
    case 'project3d'
        value = 1;
    otherwise
        value = 0;
end

function [type] = getProjectType(projectDir)
% [type] = getProjectType(projectDir)
% 
% Description:
% A function to determine the type of the project 
% 
% Author: Johann Strasser
% Date: 070312

type = '';
files = dir(fullfile(projectDir, '*.type'));
noOfTypeFiles = length(files);

if noOfTypeFiles > 1
    error(['Project must have zero or one .type file. ', ...
        'Number of .type files found: %i.'], noOfTypeFiles);
elseif noOfTypeFiles == 1
    [pathstr, name, ext, versn] = fileparts(files(1).name);
    type = name;
    
    % The following is reserved for future use. We may want to keep
    % additional information about the project in this file
%     typeStruct = load(fullfile(projectDir, files(1).name), '-mat');   
end
