function shapepcvarsheet = constructShapePCVarSheet(model)

shapepcvarsheet = {};
pdm = get(model, 'pdm');
if isempty(pdm)
    return;
end
if ~isfield(pdm, 'pca')
    return;
end
pdm = pdm.pca;
if ~isfield(pdm, 'b')
    return;
end
b = pdm.b;
S = sum(b(:));
shapepcvarsheet{1, 1} = 'Variance';
shapepcvarsheet{1, 2} = 'Standard Dev.';
shapepcvarsheet{1, 3} = 'Percentage Of Total';

for i=1:length(b)
    shapepcvarsheet{i+1, 1} = b(i);
    shapepcvarsheet{i+1, 2} = sqrt(b(i));
    shapepcvarsheet{i+1, 3} = 100*(b(i)/S);
end
return;