#include "Filter.h"

Filter::Filter()
{
	source_array = NULL;
	sobel_result_array = NULL;
	width=height=depth=0;
}

Filter::~Filter()
{
	source_array = NULL;
}
void Filter::progress(int i, int size)
{
	float prog = ( (float)(i+1)/(float)(size) )*100.0f;
	printf("\r\r Progress = %.2f", prog);
}
void Filter::allocate_source3D(void)
{
	if(source_array) delete[] source_array;
	source_array = new unsigned char [width*height*depth*3];
}
void Filter::allocate_result3D(void)
{
	if(result_array) delete[] result_array;
	result_array = new unsigned char [width*height*depth*3];
}

void Filter::allocate_sobel3D(void)
{
	if(sobel_result_array) delete[] sobel_result_array;
	sobel_result_array = new short [width*height*depth*1];
}

void Filter::result2source3D(void)
{
	if(result_array==0) return;
	if(source_array==0) return;

	int size = width*height*depth*4;
	
	for(int i=0; i<size; i++)
	{		
		source_array[i] = result_array[i];	
	}
}
void Filter::result2newarray3D(unsigned char* new_array)
{
	if(result_array==0)return;


	int size = width*height*depth*3;

	for(int i=0; i<size; i++)
	{
		new_array[i] = result_array[i];	
	}
}

void Filter::sobel_result2newarray3D(short* new_array)
{
	if(sobel_result_array==0)return;

	int size = width*height*depth*1;
	for(int i=0; i<size; i++)
	{
		new_array[i] = sobel_result_array[i];	
	}
}
void Filter::copy_source3D(void)
{
	Vector bbsize = volobj->boundingboxMax - volobj->boundingboxMin;
	int size = bbsize.x*bbsize.y*bbsize.z*3;
	
	width = bbsize.x;
	height = bbsize.y;
	depth = bbsize.z;

	//printf("bb: %d , %d , %d\n", width, height, depth);

	if(source_array) delete[] source_array;
	source_array = new unsigned char [size];

	int index;
	int index2;
//	for(int i=0; i<size; i++)
	for(int x=volobj->boundingboxMin.x; x<volobj->boundingboxMax.x; x++)
		for(int y=volobj->boundingboxMin.y; y<volobj->boundingboxMax.y; y++)
			for(int z=volobj->boundingboxMin.z; z<volobj->boundingboxMax.z; z++)
			{
				index = 3*(((((((int)z)-volobj->boundingboxMin.z)*height)+((int)y-volobj->boundingboxMin.y))*width)+((int)x-volobj->boundingboxMin.x));
				index2 = 3*((((((int)z)*volobj->texheight)+((int)y))*volobj->texwidth)+((int)x));
				
				source_array[index+0] = volobj->texture3d[index2+0];
				source_array[index+1] = volobj->texture3d[index2+1];
				source_array[index+2] = volobj->texture3d[index2+2];
			}
}

double Filter::invtan(double x, double y)
{
	double theta;

	// handle divide by zero
	if(x == 0)   
	{
	   if(y==0) theta = 0.0;
	   else if (y<0)   
	   {
			y = -y;
			theta = 90.0;
	   }
	   else theta = 90.0;
	}
	// handle invtan of angle in 2nd Quad
	else if(x<0 && y>0)   
	{
		x = -x;
		theta = 180 - ((atan((double)(y)/(double)(x))) * (180/PI));
	}
	// handle invtan of angle in 4th Quad
	else if(x>0 && y<0)   
	{
		y = -y;
		theta = 180 - ((atan((double)(y)/(double)(x))) * (180/PI));
	}
	// else angle is in 1st or 3rd Quad
	else theta = (atan((double)(y)/(double)(x))) * (180/PI);

	return theta;
}
/*
DESCRIPTION
   Performs Histogram equalization. It reassigns the brightness values of pixels based on the image
   histogram. Individual pixels retain their brightness order (that is, they remain brighter or darker
   than other pixels) but the values are shifted, so that an equal number of pixels have each possible
   brightness value. For each brightness level j in the original image (and its histogram, the new
   assigned value k is calculated as below.

   In many cases, this spreads out the values in regions where different regions meet, showing detail in
   areas with a high brightness gradient.


          j    Ni        Ni = number of pixels with brightness value i
   k = SUM    ---
          i=0  T         T = total number of pixels in the image
*/
void Filter::auto_levels(void)
{
	int histogram[256];
	int cumfreq[256];
	int lookup[256];
	float numb_voxels = volobj->texwidth*volobj->texheight*volobj->texdepth;
	float numb_nonblackvoxels = 0;
	
	//volume dimensions
	int size = volobj->texwidth*volobj->texheight*volobj->texdepth*3;	
	width  = volobj->texwidth;
	height = volobj->texheight;
	depth  = volobj->texdepth;

	//build histogram
	int i;
	for(i=0; i<256; i++)
	{
		histogram[i]=0;
	}
	for(i=0; i<numb_voxels; i++)
	{
		int voxel = (int)volobj->texture3d[3*i+0];

		if(voxel>0) numb_nonblackvoxels++;

		histogram[voxel]++;
	}
	histogram[0]=0;

	//build cummulative frequency table
	double sum=0;
	for(i=0; i<256; i++)
	{
		sum+=histogram[i];
		cumfreq[i] = sum;
	}
	
	//build equalisation table
	float alpha = 255.0f/numb_nonblackvoxels;
	for(i=0; i<256; i++)
	{
		lookup[i] = int( ((float)(cumfreq[i])*alpha)+0.5 );
	}

	//stretch histogram
	int voxel=0;
	for(i=0; i<numb_voxels; i++)
	{
		voxel = (int)volobj->texture3d[3*i+3];

		volobj->texture3d[3*i+0] = lookup[voxel];
		volobj->texture3d[3*i+1] = lookup[voxel];
		volobj->texture3d[3*i+2] = lookup[voxel];
	//	volobj->texture3d[3*i+3] = lookup[voxel];

	}
}

void Filter::apply_contrast_stretching(void)
{
	float numb_voxels = volobj->texwidth*volobj->texheight*volobj->texdepth;
	float min_out, max_out;
	float min_in,  max_in;

	min_out = 0.0;
	max_out = 255.0;

	//take bounds to be 5th and 95th percentile
	float lower_bound = numb_voxels*0.05;
	float upper_bound = numb_voxels*0.95;

	//build histogram
	int histogram[256];
	int i;
	for(i=0; i<256; i++)
	{
		histogram[i]=0;
	}
	for(i=0; i<numb_voxels; i++)
	{
		int voxel = (int)volobj->texture3d[3*i+0];
		histogram[voxel]++;
	}

	float counter=0;
	int help1=1;
	int help2=1;
	for(i=0; i<256; i++)
	{
		counter += histogram[i];

		if(counter>lower_bound && help1)
		{
			min_in = i;
			help1=0;
		}

		if(counter<upper_bound) max_in = i;

	}
	for(i=0; i<numb_voxels; i++)
	{
		float voxel = (float)volobj->texture3d[3*i+3];

		if(voxel)
		{
			float result = (voxel-min_in)*((max_out-min_out)/(max_in-min_in))+min_out;
		
			if(result>255)	  result = 255;
			if(result<0)	  result = 0;

			volobj->texture3d[3*i]=result;
			volobj->texture3d[3*i+1]=0;
			volobj->texture3d[3*i+2]=0;
		}
	}
}
vector< vector< vector<double> > > Filter::create_gaussianmask3D(int size, double sigma)
{
	Gaussian gauss;

	//evaluate our sigma value for a given 
	//kernel mask radius
	//gauss.eval_sigma(kernel_radius);
	gauss.sigma = sigma;
	gauss.size = size;
	int kernel_radius = (size-1)/2;

	//allocate some memory for our kernel mask
	vector< vector< vector<double> > > mask;
	mask.resize((int)gauss.size);
	for(int n=0; n<gauss.size; n++)
		mask[n].resize(gauss.size);

	for(int nn=0; nn<gauss.size; nn++)
		for(int nnn=0; nnn<gauss.size; nnn++)
		mask[nn][nnn].resize((int)gauss.size);

	//evaluate our guassian kernel mask
	mask = gauss.gaussianmask3D(gauss.sigma, gauss.size);
	
	return mask;
}

void Filter::apply_gaussian3D(int size, double sigma, int qual)
{
	//printf("Gaussian Smoothing: (sigma %f size %d)\n\n", sigma,size); 
	Gaussian gauss;

	//allocate_result3D();
	copy_source3D();

	//evaluate our sigma value for a given 
	//kernel mask radius
	//gauss.eval_sigma(kernel_radius);
	gauss.sigma = sigma;
	gauss.size = size;
	int kernel_radius = (size-1)/2;

	//allocate some memory for our kernel mask
	vector< vector< vector<double> > > mask;
	mask.resize((int)gauss.size);
	for(int n=0; n<gauss.size; n++)
		mask[n].resize(gauss.size);

	for(int nn=0; nn<gauss.size; nn++)
		for(int nnn=0; nnn<gauss.size; nnn++)
		mask[nn][nnn].resize((int)gauss.size);

	//evaluate our guassian kernel mask
	mask = gauss.gaussianmask3D(gauss.sigma, gauss.size);

	int index=0;
	int x_iter=0;
	int y_iter=0;
	int z_iter=0;
	
	double filtered_valueR=0.0;
	double filtered_valueG=0.0;
	double filtered_valueB=0.0;
	double filtered_valueA=0.0;

	float datasize= (float)volobj->maxres*((float)qual/100.0);
	float itersteps = (float)(volobj->maxres)/datasize;
	
	//progressbar = new QProgressDialog("Computing Gaussian Smooth...", "Cancel", 0, depth-2.0*kernel_radius, this, 0);		
	//progressbar->setCaption("Please Wait");
	
	float kernX, kernY, kernZ;

	//int 
	for(float z=kernel_radius; z<depth-kernel_radius; z+=itersteps)
	{
		//progress(z, depth-kernel_radius);
		//progressbar->setValue(z);
		//if (progressbar->wasCancelled())
		//	break;

		for(float x=kernel_radius; x<width-kernel_radius; x+=itersteps)
		{
			for(float y=kernel_radius; y<height-kernel_radius; y+=itersteps)
			{				
					x_iter=0;
					y_iter=0;
					z_iter=0;
					filtered_valueR=0.0;
					filtered_valueG=0.0;
					filtered_valueB=0.0;

					for(int i=-kernel_radius; i<=kernel_radius; i++)
					{
						for(int j=-kernel_radius; j<=kernel_radius; j++)
						{
							for(int k=-kernel_radius; k<=kernel_radius; k++)
							{
								kernX = x+k;
								kernY = y+j;
								kernZ = z+i;
								
								/*if(kernX<0) kernX=0;
								if(kernX>(width-1)) kernX=width-1;

								if(kernY<0) kernY=0;
								if(kernY>(height-1)) kernY=height-1;

								if(kernZ<0) kernZ=0;
								if(kernZ>(depth-1)) kernZ=depth-1;*/

								index = 3*(((((kernZ)*height)+(kernY))*width)+(kernX));
										
								filtered_valueR += (double)(source_array[index+0])*mask[x_iter][y_iter][z_iter];
								filtered_valueG += (double)(source_array[index+1])*mask[x_iter][y_iter][z_iter];
								filtered_valueB += (double)(source_array[index+2])*mask[x_iter][y_iter][z_iter];
								
								z_iter++;
							}
							
							y_iter++;
							z_iter=0;
						}

						x_iter++;
						y_iter=0;
					}
					
					index = 3*((((((int)z)*height)+((int)y))*width)+((int)x));
										
					volobj->texture3d[index+0] = (int)filtered_valueR+0.5;
					volobj->texture3d[index+1] = (int)filtered_valueG+0.5;
					volobj->texture3d[index+2] = (int)filtered_valueB+0.5;
			}
		}
	}

	//progressbar->setValue(depth-2.0*kernel_radius);
	//delete progressbar;
	//progressbar = NULL;

	delete[] source_array;
}

void Filter::apply_unsharpmask3D(int brightness, int contrast, float sigma, int gsize)
{
	//volume dimensions
	int size = volobj->texwidth*volobj->texheight*volobj->texdepth*3;	
	width  = volobj->texwidth;
	height = volobj->texheight;
	depth  = volobj->texdepth;

	//copy original
	copy_source3D();
	allocate_result3D();

	//=====================================
	//apply gaussian, low-pass image
	//=====================================
	printf("Applying Gaussian Smoothing: (sigma: %.2f, size: %d)\n", sigma,gsize); 
	Gaussian gauss;

	//evaluate our sigma value for a given 
	//kernel mask radius
	//gauss.eval_sigma(kernel_radius);
	gauss.sigma = sigma;
	gauss.size = gsize;
	int kernel_radius = (gsize-1)/2;

	//allocate some memory for our kernel mask
	vector< vector< vector<double> > > mask;
	mask.resize((int)gauss.size);
	for(int n=0; n<gauss.size; n++)
		mask[n].resize(gauss.size);

	for(int nn=0; nn<gauss.size; nn++)
		for(int nnn=0; nnn<gauss.size; nnn++)
		mask[nn][nnn].resize((int)gauss.size);

	//evaluate our guassian kernel mask
	mask = gauss.gaussianmask3D(gauss.sigma, gauss.size);

	int index=0;
	int x_iter=0;
	int y_iter=0;
	int z_iter=0;
	
	double filtered_valueR=0.0;
	double filtered_valueG=0.0;
	double filtered_valueB=0.0;
//	double filtered_valueA=0.0;
	int i;
	for(i=0; i<size; i++)
	{
		result_array[i] = volobj->texture3d[i];
	}

	//int 
	int dsize = depth-kernel_radius;
	for(int z=kernel_radius; z<depth-kernel_radius; z++)
	{
		//progress(z, dsize);

		for(int x=kernel_radius; x<width-kernel_radius; x++)
		{
			for(int y=kernel_radius; y<height-kernel_radius; y++)
			{				
					x_iter=0;
					y_iter=0;
					z_iter=0;
					filtered_valueR=0.0;
					filtered_valueG=0.0;
					filtered_valueB=0.0;
					//filtered_valueA=0.0;

					for(int i=-kernel_radius; i<=kernel_radius; i++)
					{
						for(int j=-kernel_radius; j<=kernel_radius; j++)
						{
							for(int k=-kernel_radius; k<=kernel_radius; k++)
							{
								index = 3*volobj->get_index1D(x+k, y+j, z+i);
								filtered_valueR += (double)(source_array[index+0])*mask[x_iter][y_iter][z_iter];
								filtered_valueG += (double)(source_array[index+1])*mask[x_iter][y_iter][z_iter];
								filtered_valueB += (double)(source_array[index+2])*mask[x_iter][y_iter][z_iter];
							//	filtered_valueA += (double)(source_array[index+3])*mask[x_iter][y_iter][z_iter];
								z_iter++;
							}
							
							y_iter++;
							z_iter=0;
						}

						x_iter++;
						y_iter=0;
					}

					index = volobj->get_index1D(x, y, z);

					result_array[3*index+0] = (int)filtered_valueR+0.5;
					result_array[3*index+1] = (int)filtered_valueG+0.5;
					result_array[3*index+2] = (int)filtered_valueB+0.5;
					//result_array[3*index+3] = (int)filtered_valueA+0.5;
			}
		}
	}

	{
	for(int nn=0; nn<gauss.size; nn++)
		for(int nnn=0; nnn<gauss.size; nnn++)
		{
			mask[nn][nnn].clear();
		}
	}
	{
		for(int nnn=0; nnn<gauss.size; nnn++)
		{
			mask[nnn].clear();
		}

		mask.clear();
	}

	//=====================================
	//substract low-pass from original
	//to get high-pass image
	//=====================================
	for(i=0; i<size; i++)
	{
		int voxel = volobj->texture3d[i] - result_array[i];

		if(voxel>255) voxel = 255;
		if(voxel<0)	  voxel = 0;

		//get voxel value
		result_array[i] = voxel;
	}

	//=====================================
	//add high-pass to original
	//to get edge enhanced
	//=====================================
	for(i=0; i<size; i++)
	{
		int voxel = volobj->texture3d[i] + result_array[i];

		if(voxel>255) voxel = 255;
		if(voxel<0)	  voxel = 0;

		//get voxel value
		volobj->texture3d[i] = voxel;
	}
}

void Filter::apply_mean(int scale)
{
	copy_source3D();

	vector<char> kernel_values;
			
	int current_index = 0;
	int filtered_value = 0;
	int x_iter=0;
	int y_iter=0;
	int z_iter=0;
	int kernel_radius = scale;
	int sizehelper=0;
	
	for(int z=kernel_radius; z<depth-kernel_radius; z++)
	{
//		progress(z, depth-kernel_radius);

		for(int x=kernel_radius; x<width-kernel_radius; x++)
		{
			for(int y=kernel_radius; y<height-kernel_radius; y++)
			{				
					x_iter=0;
					y_iter=0;
					z_iter=0;
			
					sizehelper = 0;
					
					for(int i=-kernel_radius; i<=kernel_radius; i++)
					{
						for(int j=-kernel_radius; j<=kernel_radius; j++)
						{
							for(int k=-kernel_radius; k<=kernel_radius; k++)
							{
								int index = 3*(((((z+i)*height)+(y+j))*width)+(x+k));
								
								//kernel_values.push_back(source_array[index+0]);							
								filtered_value += source_array[index+0];		
								sizehelper++;
								
								z_iter++;
							}
							
							y_iter++;
							z_iter=0;
						}

						x_iter++;
						y_iter=0;
					}
									
					filtered_value /= (float) sizehelper;
					
					current_index = 1*((((z*height)+y)*width)+x);

					volobj->texture3d[3*current_index+0]=filtered_value;
					volobj->texture3d[3*current_index+1]=0;
					volobj->texture3d[3*current_index+2]=0;
			}
		}
	}
	
	if(source_array) delete[] source_array;
	source_array=NULL;
}
void Filter::apply_median(int scale)
{
	copy_source3D();

	vector<int> kernel_values;
			
	int current_index = 0;
	int filtered_value = 0;
	int x_iter=0;
	int y_iter=0;
	int z_iter=0;
	int kernel_radius = scale;
	
	float interp = (float)depth/(float)width;
	int i = 0;
	int value;
	for(int z=kernel_radius; z<depth-kernel_radius; z++)
	{
		progress(z, depth-kernel_radius);

		for(int x=kernel_radius; x<width-kernel_radius; x++)
		{
			for(int y=kernel_radius; y<height-kernel_radius; y++)
			{				
					x_iter=0;
					y_iter=0;
					z_iter=0;
			
					//for(int i=-kernel_radius; i<=kernel_radius; i++)
					{
						for(int j=-kernel_radius; j<=kernel_radius; j++)
						{
							for(int k=-kernel_radius; k<=kernel_radius; k++)
							{
								int zval = z+i+1;
								if(zval>depth-1) zval = depth-1;
								
								int index = 3*(((((z+i)*height)+(y+j))*width)+(x+k));
								int index2 = 3*(((((zval)*height)+(y+j))*width)+(x+k));
								
								//value = (float)(1-interp)*(float)source_array[index+0] + (float)(interp)*(float)source_array[index2+0];
								value = source_array[index+0];
								
								kernel_values.push_back(value);							
								z_iter++;
							}
							
							y_iter++;
							z_iter=0;
						}

						x_iter++;
						y_iter=0;
					}
					
					sort(kernel_values.begin(), kernel_values.end());
					
					filtered_value = kernel_values[kernel_values.size()/2.0];				
					current_index = 3*((((z*height)+y)*width)+x);

					volobj->texture3d[current_index+0]=filtered_value;
					
					kernel_values.clear();
			}
		}
	}
	
	if(source_array) delete[] source_array;
	source_array=NULL;

}

void Filter::apply_harriscorner(void)
{
    Sobel sobel;
	Gaussian gauss;
  
	copy_source3D();

	//clear target image
	for(int i=0; i<width*depth*height*3; i++)
		volobj->texture3d[i+0]=0;
		
	//evaluate our sigma value for a given 
	//kernel mask radius
	//gauss.eval_sigma(kernel_radius);
	gauss.sigma = 0.5;
	int kernel_radius = 1;

	gauss.size = 2*kernel_radius+1;
    int window_size = 1;
    int grad_kernel_radius = 1;
    int imagesize = window_size+window_size+grad_kernel_radius;

	//allocate some memory for our kernel mask
	vector< vector< vector<double> > > mask;
	mask.resize((int)gauss.size);
	for(int n=0; n<gauss.size; n++)
		mask[n].resize(gauss.size);

	for(int nn=0; nn<gauss.size; nn++)
		for(int nnn=0; nnn<gauss.size; nnn++)
		mask[nn][nnn].resize((int)gauss.size);

	//evaluate our guassian kernel mask
	mask = gauss.gaussianmask3D(gauss.sigma, gauss.size);

    double results[4];
    int current_index=0;


    int point_indexX=0;
    int point_indexY=0;
    int point_indexZ=0;


    int window_index = 0;
    int window_indexX=0;
    int window_indexY=0;
    int window_indexZ=0;
    int window_x_iter=0;
    int window_y_iter=0;
    int window_z_iter=0;

    int grad_index=0;
    int grad_x_iter=0;
    int grad_y_iter=0;
    int grad_z_iter=0;

    double filtered_valueRx=0.0;
    double filtered_valueRy=0.0;
    double filtered_valueRz=0.0;

    double original_value=0.0;

	double harris_value = 0.0;
	
    PCA pca;
    float pca_eigenval0;
    float pca_eigenval1;
    float pca_eigenval2;

 //	progressbar = new Q3ProgressDialog("Computing Harris Corner Detector...", "Cancel", depth-imagesize, 0, "progress", TRUE);		
//	progressbar->setCaption("Please Wait");

	float maxvalue = 0.0;
	
	//traverse each point in our image.
    for(int z=imagesize; z<depth-imagesize; z++)
    {
           //progress(z, depth-imagesize);
	//		progressbar->setProgress(z);
	//		if (progressbar->wasCancelled())
	//			break;
            for(int x=imagesize; x<width-imagesize; x++)
            {
                    for(int y=imagesize; y<height-imagesize; y++)
                    {
                        pca.reset();
					
                        //for the current point look around our window
                        for(int iii=-window_size; iii<=window_size; iii++)
                        {
                                for(int jjj=-window_size; jjj<=window_size; jjj++)
                                {
                                        for(int kkk=-window_size; kkk<=window_size; kkk++)
                                        {
                                                point_indexX = x+kkk;
                                                point_indexY = y+jjj;
                                                point_indexZ = z+iii;
												
                                                //point_indexZ=z;

                                                window_x_iter=0;
                                                window_y_iter=0;
                                                window_z_iter=0;
						results[0]=results[1]=results[2]=results[3]=0;

                                                for(int i=-window_size; i<=window_size; i++)
                                                {
                                                        for(int j=-window_size; j<=window_size; j++)
                                                        {
                                                                for(int k=-window_size; k<=window_size; k++)
                                                                {
                                                                        window_indexX = point_indexX+k;
                                                                        window_indexY = point_indexY+j;
                                                                        window_indexZ = point_indexZ+i;

                                                                                                                        //window_indexZ=point_indexZ;

                                                                        window_index = 1*(((((window_indexZ)*height)+(window_indexY))*width)+(window_indexX));

                                                                        //compute the gradient(sobel) at window point position.
                                                                        grad_x_iter=0;
                                                                        grad_y_iter=0;
                                                                        grad_z_iter=0;
                                                                        filtered_valueRx = filtered_valueRy = filtered_valueRz = 0;

                                                                        for(int ii=-grad_kernel_radius; ii<=grad_kernel_radius; ii++)
                                                                        {
                                                                                for(int jj=-grad_kernel_radius; jj<=grad_kernel_radius; jj++)
                                                                                {
                                                                                        for(int kk=-grad_kernel_radius; kk<=grad_kernel_radius; kk++)
                                                                                        {
                                                                                                grad_index = 1*(((((window_indexZ+ii)*height)+(window_indexY+jj))*width)+(window_indexX+kk));

                                                                                                                                                                        filtered_valueRx += (double)(source_array[3*grad_index+0])*sobel.sobelX3d[grad_x_iter][grad_y_iter][grad_z_iter];
                                                                                                filtered_valueRy += (double)(source_array[3*grad_index+0])*sobel.sobelY3d[grad_x_iter][grad_y_iter][grad_z_iter];
                                                                                                filtered_valueRz += (double)(source_array[3*grad_index+0])*sobel.sobelZ3d[grad_x_iter][grad_y_iter][grad_z_iter];

                                                                                                grad_z_iter++;
                                                                                        }

                                                                                        grad_y_iter++;
                                                                                        grad_z_iter=0;
                                                                                }
                                                                                grad_x_iter++;
                                                                                grad_y_iter=0;
                                                                        }

                                                                        filtered_valueRx /= 52.0;
                                                                        filtered_valueRy /= 52.0;
                                                                        filtered_valueRz /= 52.0;

                                                                                                                        results[0] += (filtered_valueRx*filtered_valueRx)*mask[window_x_iter][window_y_iter][window_z_iter];
                                                                                                                        results[1] += (filtered_valueRy*filtered_valueRy)*mask[window_x_iter][window_y_iter][window_z_iter];
                                                                                                                        results[2] += (filtered_valueRx*filtered_valueRy)*mask[window_x_iter][window_y_iter][window_z_iter];


                                                                                                                        /*results[0] += (filtered_valueRx*filtered_valueRx*filtered_valueRx)*mask[window_x_iter][window_y_iter][window_z_iter];
                                                                                                                        results[1] += (filtered_valueRy*filtered_valueRy*filtered_valueRy)*mask[window_x_iter][window_y_iter][window_z_iter];
                                                                                                                        results[2] += (filtered_valueRz*filtered_valueRz*filtered_valueRz)*mask[window_x_iter][window_y_iter][window_z_iter];
                                                                                                                        results[3] += (filtered_valueRx*filtered_valueRy*filtered_valueRz)*mask[window_x_iter][window_y_iter][window_z_iter];*/



                                                                        //original_value = source_array[3*window_index+0];
                                                                        //pca.data.push_back(Vector(filtered_valueRx,filtered_valueRy,filtered_valueRz));

                                                                        /*result[0][0] += (filtered_valueRx*filtered_valueRx);
                                                                        result[1][0] += (filtered_valueRx*filtered_valueRy);
                                                                        result[1][0] += (filtered_valueRx*filtered_valueRy);
                                                                        result[1][1] += (filtered_valueRy*filtered_valueRy);*/

                                                                        window_z_iter++;
                                                                }

                                                                window_y_iter++;
                                                                window_z_iter=0;
                                                        }
                                                        window_x_iter++;
                                                        window_y_iter=0;
                                                }

						pca.data.push_back(Vector(results[0]/(float)(window_size*2+1), results[2]/(float)(window_size*2+1), 0.0));
						pca.data.push_back(Vector(results[2]/(float)(window_size*2+1), results[1]/(float)(window_size*2+1), 0.0));

						
						/*pca.data.push_back(Vector(results[0], results[3], results[3]));
						pca.data.push_back(Vector(results[3], results[1], results[3]));
						pca.data.push_back(Vector(results[3], results[3], results[2]));*/
						}
					}
				}
						
                        //eval eigenvectors.
                        pca.eval_PCA();
                        pca.eval_scaled_eigensvectors(1,1,1);

                        pca_eigenval0 = pca.eigenvectors[0].length();
                        pca_eigenval1 = pca.eigenvectors[1].length();
                        pca_eigenval2 = pca.eigenvectors[2].length();

                        pca_eigenval0 = pow((float)pca_eigenval0, 1.0f/3.0f);
                        pca_eigenval1 = pow((float)pca_eigenval1, 1.0f/3.0f);
                        pca_eigenval2 = pow((float)pca_eigenval2, 1.0f/3.0f);

                        if(maxvalue<pca_eigenval0) maxvalue = pca_eigenval0;
						
                        //harris_value = pca_eigenval0*pca_eigenval1*pca_eigenval2 - 0.06*((pca_eigenval0+pca_eigenval1*pca_eigenval2)*(pca_eigenval0+pca_eigenval1*pca_eigenval2));
                        //harris_value = pca_eigenval0*pca_eigenval1 - 0.04*((pca_eigenval0+pca_eigenval1)*(pca_eigenval0+pca_eigenval1));
                        //harris_value = pow(harris_value, 1.0/3.0);

                        //printf("harris_value: %f\n", harris_value);

                        //if(pca_eigenval0>0 && pca_eigenval1>0) printf("egienvalues: %f, %f, %f \n", pca_eigenval0, pca_eigenval1, pca_eigenval2);
                        current_index = 3*((((z*height)+y)*width)+x);

                        //if(pca_eigenval0>10000 && pca_eigenval1>10000 && pca_eigenval2>10000) //
                        //if(harris_value>150)
                        // if(pca_eigenval0>10 && pca_eigenval1>10) //
                        {
                            //volobj->texture3d[current_index+0]=0;
                            volobj->texture3d[current_index+1]=pca_eigenval0+pca_eigenval1;
							
                            //if(volobj->texture3d[current_index+1]>255) volobj->texture3d[current_index+1] = 255;
                            //if(volobj->texture3d[current_index+1]<0) volobj->texture3d[current_index+1] = 0;
							
                            //volobj->texture3d[current_index+2]=0;
                        }
                        /*else
                        {
                            //volobj->texture3d[current_index+0]=0;
                            volobj->texture3d[current_index+1]=0;
                            volobj->texture3d[current_index+2]=0;
                        }*/
                    }
                }
        }
	//progressbar->setProgress(depth-imagesize);

        printf("max: %f\n", pca_eigenval0);

/*	
	//traverse each point in our image.
    for(int z=window_size; z<depth-window_size; z++)
    {
           //progress(z, depth-imagesize);
			progressbar->setProgress(z);
			if (progressbar->wasCancelled())
				break;
				
            for(int x=window_size; x<width-window_size; x++)
            {
                    for(int y=window_size; y<height-window_size; y++)
                    {
                        //for the current point look around our window
						current_index = 1*(((((window_indexZ)*height)+(window_indexY))*width)+(window_indexX));

                        for(int iii=-window_size; iii<=window_size; iii++)
                        {
                                for(int jjj=-window_size; jjj<=window_size; jjj++)
                                {
                                        for(int kkk=-window_size; kkk<=window_size; kkk++)
                                        {
                                                window_indexX = x+kkk;
                                                window_indexY = y+jjj;
                                                window_indexZ = z+iii;

                                                window_index = 1*(((((window_indexZ)*height)+(window_indexY))*width)+(window_indexX));
										}
								}
						}
					}
			}
	}
	*/											
	//delete progressbar;
	//progressbar = NULL;

	delete[] source_array;
}
void Filter::apply_contrast_stretching_filter(int dimensionality, vector<bool> channels)
{
}
void Filter::apply_auto_levels_filter(int dimensionality, vector<bool> channels)
{
}

void Filter::apply_sobel3D_filter(int dimensionality, vector<bool> channels)
{
	Sobel sobel;

	copy_source3D();
	allocate_sobel3D();

	int kernel_radius = 1;
			
	int current_index = 0;
	int x_iter=0;
	int y_iter=0;
	int z_iter=0;
	

	double filtered_valuex=0.0;
	double filtered_valuey=0.0;
	double filtered_valuez=0.0;
	double filtered_value=0.0;

	int index=0;
	int xval=0;
	int yval=0;
	int zval=0;
	
	int offset=0;
	
	if(channels[1]==true) offset=1;
	else if(channels[2]==true) offset=2;

	progressbar = new Q3ProgressDialog("Computing Sobel Edge Detector...", "Cancel", depth, 0, "progress", TRUE);		
	progressbar->setCaption("Please Wait");
	
	int helper2=0;
	for(float z=volobj->boundingboxMin.z; z<volobj->boundingboxMax.z; z++)
	{
		//progress(z, depth-kernel_radius);
		progressbar->setProgress(helper2);
		if (progressbar->wasCancelled())
			break;

		helper2++;

		for(float x=volobj->boundingboxMin.x; x<volobj->boundingboxMax.x; x++)
		{
			for(float y=volobj->boundingboxMin.y; y<volobj->boundingboxMax.y; y++)
			{	
					x_iter=0;
					y_iter=0;
					z_iter=0;

					filtered_valuex=0.0;
					filtered_valuey=0.0;
					filtered_valuez=0.0;
				
					for(int i=-kernel_radius; i<=kernel_radius; i++)
					{
						for(int j=-kernel_radius; j<=kernel_radius; j++)
						{
							for(int k=-kernel_radius; k<=kernel_radius; k++)
							{
								zval = z+i;
								yval = y+j;
								xval = x+k;

								if(zval>volobj->boundingboxMax.z-1) zval = volobj->boundingboxMax.z-1;
								if(yval>volobj->boundingboxMax.y-1) yval = volobj->boundingboxMax.y-1;
								if(xval>volobj->boundingboxMax.x-1) xval = volobj->boundingboxMax.x-1;

								if(zval<volobj->boundingboxMin.z) zval = volobj->boundingboxMin.z;
								if(yval<volobj->boundingboxMin.y) yval = volobj->boundingboxMin.y;
								if(xval<volobj->boundingboxMin.x) xval = volobj->boundingboxMin.x;
								
								index = 3*(((((zval-volobj->boundingboxMin.z)*height)+(yval-volobj->boundingboxMin.y))*width)+(xval-volobj->boundingboxMin.x));
	
								filtered_valuex += (double)(source_array[index+offset])*sobel.sobelX3d[x_iter][y_iter][z_iter];
								filtered_valuey += (double)(source_array[index+offset])*sobel.sobelY3d[x_iter][y_iter][z_iter];
								filtered_valuez += (double)(source_array[index+offset])*sobel.sobelZ3d[x_iter][y_iter][z_iter];
	
								z_iter++;
							}
							
							y_iter++;
							z_iter=0;
						}

						x_iter++;
						y_iter=0;
					}

					filtered_valuex /= 52.0;
					filtered_valuey /= 52.0;
					filtered_valuez /= 52.0;

					//current_index = ((((z*height)+y)*width)+x);
					current_index = (((((zval-volobj->boundingboxMin.z)*height)+(yval-volobj->boundingboxMin.y))*width)+(xval-volobj->boundingboxMin.x));
					
					filtered_value =sqrt((filtered_valuex*filtered_valuex)+(filtered_valuey*filtered_valuey)+(filtered_valuez*filtered_valuez));
					sobel_result_array[current_index+offset] = filtered_value;
					
					//==========================================
					// SAVE IT INTO OUR RESULT ARRAY
					//==========================================
					filtered_value = sobel_result_array[current_index+offset];
					if(filtered_value>255) filtered_value = 255;
					if(filtered_value<0) filtered_value = 0;

					current_index = 3*((((((int)z)*volobj->texheight)+((int)y))*volobj->texwidth)+((int)x));
					volobj->texture3d[current_index+offset]=filtered_value;
			}
		}
	}
	
	delete source_array;
	delete sobel_result_array;
	source_array = NULL;
	sobel_result_array = NULL;

	progressbar->setProgress(depth);
	delete progressbar;
	progressbar = NULL;
}
void Filter::apply_sobel3D(int mode)
{
	Sobel sobel;

	copy_source3D();
	allocate_sobel3D();

	int kernel_radius = 1;
			
	int current_index = 0;
	int x_iter=0;
	int y_iter=0;
	int z_iter=0;
	

	double filtered_valueRx=0.0;
	double filtered_valueGx=0.0;
	double filtered_valueBx=0.0;

	double filtered_valueRy=0.0;
	double filtered_valueGy=0.0;
	double filtered_valueBy=0.0;
	
	double filtered_valueRz=0.0;
	double filtered_valueGz=0.0;
	double filtered_valueBz=0.0;
	
	double filtered_value=0.0;

	int highThreshold = 10;

	for(int z=kernel_radius; z<depth-kernel_radius; z++)
	{
//		progress(z, depth-kernel_radius);

		for(int x=kernel_radius; x<width-kernel_radius; x++)
		{
			for(int y=kernel_radius; y<height-kernel_radius; y++)
			{				
					x_iter=0;
					y_iter=0;
					z_iter=0;

					filtered_valueRx=0.0;
					filtered_valueRy=0.0;
					filtered_valueRz=0.0;
					
					filtered_valueGx=0.0;
					filtered_valueGy=0.0;
					filtered_valueGz=0.0;

					filtered_valueBx=0.0;
					filtered_valueBy=0.0;
					filtered_valueBz=0.0;
				
					for(int i=-kernel_radius; i<=kernel_radius; i++)
					{
						for(int j=-kernel_radius; j<=kernel_radius; j++)
						{
							for(int k=-kernel_radius; k<=kernel_radius; k++)
							{
								int index = 1*(((((z+i)*height)+(y+j))*width)+(x+k));
											
								filtered_valueRx += (double)(source_array[3*index+0])*sobel.sobelX3d[x_iter][y_iter][z_iter];
								filtered_valueRy += (double)(source_array[3*index+0])*sobel.sobelY3d[x_iter][y_iter][z_iter];
								filtered_valueRz += (double)(source_array[3*index+0])*sobel.sobelZ3d[x_iter][y_iter][z_iter];

								filtered_valueGx += (double)(source_array[index+1])*sobel.sobelX3d[x_iter][y_iter][z_iter];
								filtered_valueGy += (double)(source_array[index+1])*sobel.sobelY3d[x_iter][y_iter][z_iter];
								filtered_valueGz += (double)(source_array[index+1])*sobel.sobelZ3d[x_iter][y_iter][z_iter];
								
								filtered_valueBx += (double)(source_array[index+2])*sobel.sobelX3d[x_iter][y_iter][z_iter];
								filtered_valueBy += (double)(source_array[index+2])*sobel.sobelY3d[x_iter][y_iter][z_iter];
								filtered_valueBz += (double)(source_array[index+2])*sobel.sobelZ3d[x_iter][y_iter][z_iter];
							
								z_iter++;
							}
							
							y_iter++;
							z_iter=0;
						}

						x_iter++;
						y_iter=0;
					}

					filtered_valueRx /= 52.0;
					filtered_valueRy /= 52.0;
					filtered_valueRz /= 52.0;

					filtered_valueGx /= 52.0;
					filtered_valueGy /= 52.0;
					filtered_valueGz /= 52.0;

					filtered_valueBx /= 52.0;
					filtered_valueBy /= 52.0;
					filtered_valueBz /= 52.0;
					
					current_index = 1*((((z*height)+y)*width)+x);
					
					if(mode==SOBEL_HORIZ)
					{
						sobel_result_array[current_index+0] = filtered_valueRx;
						sobel_result_array[current_index+0] = filtered_valueGx;
						sobel_result_array[current_index+0] = filtered_valueBx;

					}
					else if(mode==SOBEL_VERTI)
					{
						sobel_result_array[current_index+0] = filtered_valueRy;
						sobel_result_array[current_index+0] = filtered_valueGy;
						sobel_result_array[current_index+0] = filtered_valueBy;

					}
					else if(mode==SOBEL_DEPTH)
					{
						sobel_result_array[current_index+0] = filtered_valueRz;
						sobel_result_array[current_index+0] = filtered_valueGz;
						sobel_result_array[current_index+0] = filtered_valueBz;

					}
					else if(mode==SOBEL_HVD)
					{
						//RED
						filtered_value =sqrt((filtered_valueRx*filtered_valueRx)+(filtered_valueRy*filtered_valueRy)+(filtered_valueRz*filtered_valueRz));
						sobel_result_array[current_index+0] = filtered_value;
						
						//GREEN
						filtered_value =sqrt((filtered_valueGx*filtered_valueGx)+(filtered_valueGy*filtered_valueGy)+(filtered_valueGz*filtered_valueGz));
						sobel_result_array[current_index+1] = filtered_value;
						
						//BLUE
						filtered_value =sqrt((filtered_valueBx*filtered_valueBx)+(filtered_valueBy*filtered_valueBy)+(filtered_valueBz*filtered_valueBz));
						sobel_result_array[current_index+2] = filtered_value;
					
						//ALPHA
						//sobel_result_array[current_index+3] = source_array[current_index+3];	
					}
					
					//==========================================
					// SAVE IT INTO OUR RESULT ARRAY
					//==========================================

					//RED
					filtered_value = sobel_result_array[current_index+0];
					if(filtered_value>255) filtered_value = 255;
					if(filtered_value<0) filtered_value = 0;
					volobj->texture3d[3*current_index+0]=filtered_value;
					
					//GREEN
					filtered_value = sobel_result_array[current_index+0];
					if(filtered_value>255) filtered_value = 255;
					if(filtered_value<0) filtered_value = 0;
					volobj->texture3d[3*current_index+1]=filtered_value;
					
					//BLUE
					filtered_value = sobel_result_array[current_index+0];
					if(filtered_value>255) filtered_value = 255;
					if(filtered_value<0) filtered_value = 0;
					volobj->texture3d[3*current_index+2]=filtered_value;
			}
		}
	}
}
void Filter::apply_gaussian_filter(int size, double sigma, int dimensionality, vector<bool> channels)
{
	//printf("Gaussian Smoothing: (sigma %f size %d)\n\n", sigma,size); 
	Gaussian gauss;

	//allocate_result3D();
	copy_source3D();

	//evaluate our sigma value for a given 
	//kernel mask radius
	//gauss.eval_sigma(kernel_radius);
	gauss.sigma = sigma;
	gauss.size = size;
	int kernel_radius = (size-1)/2;

	vector< vector< vector<double> > > mask3d;
	vector< vector< double > > mask2d;

	if(dimensionality==1)
	{
		//allocate some memory for our kernel mask
		mask3d.resize((int)gauss.size);
		for(int n=0; n<gauss.size; n++)
			mask3d[n].resize(gauss.size);

		for(int nn=0; nn<gauss.size; nn++)
			for(int nnn=0; nnn<gauss.size; nnn++)
			mask3d[nn][nnn].resize((int)gauss.size);

		//evaluate our guassian kernel mask
		mask3d = gauss.gaussianmask3D(gauss.sigma, gauss.size);
	}
	else
	{
		mask2d.resize((int)gauss.size);
		for(int n=0; n<gauss.size; n++)
			mask2d[n].resize(gauss.size);

		mask2d = gauss.gaussianmask2D(gauss.sigma, gauss.size);
	}
	
	int index=0;
	int x_iter=0;
	int y_iter=0;
	int z_iter=0;
	
	double filtered_value=0.0;

	progressbar = new Q3ProgressDialog("Computing Gaussian Smooth...", "Cancel", depth, 0, "progress", TRUE);		
	progressbar->setCaption("Please Wait");
	
	float kernX, kernY, kernZ;
	int xval, yval, zval;
	
	int offset=0;
	if(channels[1]==true) offset=1;
	else if(channels[2]==true) offset=2;

	//int 
	int helper=0;
	for(float z=volobj->boundingboxMin.z; z<volobj->boundingboxMax.z; z++)
	{
		//progress(z, depth-kernel_radius);
		progressbar->setProgress(helper);
		if (progressbar->wasCancelled())
			break;

		helper++;

		for(float x=volobj->boundingboxMin.x; x<volobj->boundingboxMax.x; x++)
		{
			for(float y=volobj->boundingboxMin.y; y<volobj->boundingboxMax.y; y++)
			{				
					x_iter=0;
					y_iter=0;
					z_iter=0;
					filtered_value=0.0;
				
					if(dimensionality==1)
					{
						for(int i=-kernel_radius; i<=kernel_radius; i++)
						{
							for(int j=-kernel_radius; j<=kernel_radius; j++)
							{
								for(int k=-kernel_radius; k<=kernel_radius; k++)
								{
									zval = z+i;
									yval = y+j;
									xval = x+k;


									if(zval>volobj->boundingboxMax.z-1) zval = volobj->boundingboxMax.z-1;
									if(yval>volobj->boundingboxMax.y-1) yval = volobj->boundingboxMax.y-1;
									if(xval>volobj->boundingboxMax.x-1) xval = volobj->boundingboxMax.x-1;

									if(zval<volobj->boundingboxMin.z) zval = volobj->boundingboxMin.z;
									if(yval<volobj->boundingboxMin.y) yval = volobj->boundingboxMin.y;
									if(xval<volobj->boundingboxMin.x) xval = volobj->boundingboxMin.x;
									
									index = 3*(((((zval-volobj->boundingboxMin.z)*height)+(yval-volobj->boundingboxMin.y))*width)+(xval-volobj->boundingboxMin.x));

									filtered_value += (double)(source_array[index+offset])*mask3d[x_iter][y_iter][z_iter];
																		
									z_iter++;
								}
								
								y_iter++;
								z_iter=0;
							}

							x_iter++;
							y_iter=0;
						}
					}
					else
					{
						for(int j=-kernel_radius; j<=kernel_radius; j++)
						{
							for(int k=-kernel_radius; k<=kernel_radius; k++)
							{
								xval = x+k;
								yval = y+j;

								if(yval>volobj->boundingboxMax.y-1) yval = volobj->boundingboxMax.y-1;
								if(xval>volobj->boundingboxMax.x-1) xval = volobj->boundingboxMax.x-1;
								if(yval<volobj->boundingboxMin.y) yval = volobj->boundingboxMin.y;
								if(xval<volobj->boundingboxMin.x) xval = volobj->boundingboxMin.x;
								
								index = 3*(((((z-volobj->boundingboxMin.z)*height)+(yval-volobj->boundingboxMin.y))*width)+(xval-volobj->boundingboxMin.x));
										
								filtered_value += (double)(source_array[index+offset])*mask2d[x_iter][y_iter];

								y_iter++;
							}
							
							x_iter++;
							y_iter=0;
						}
					}
					
					//index = 3*((((((int)z)*volobj->texheight)+((int)y))*volobj->texwidth)+((int)x));
					index = 3*((((((int)z)*volobj->texheight)+((int)y))*volobj->texwidth)+((int)x));
										
					volobj->texture3d[index+offset] = (int)filtered_value+0.5;
			}
		}
	}

	progressbar->setProgress(depth);
	delete progressbar;
	progressbar = NULL;
	
	if(dimensionality==1)
	{
		for(int nn=0; nn<gauss.size; nn++)
			for(int nnn=0; nnn<gauss.size; nnn++)
			{
				mask3d[nn][nnn].clear();
			}		
		
		for(int nnn=0; nnn<gauss.size; nnn++)
		{
			mask3d[nnn].clear();
		}

		mask3d.clear();
	}
	else
	{
		for(int nnn=0; nnn<gauss.size; nnn++)
		{
			mask2d[nnn].clear();
		}

		mask2d.clear();	
	}
	
	delete source_array;
	source_array = NULL;
	gauss.clear_all();
}
void Filter::apply_unsharpmask_filter(int gsize, double sigma, int dimensionality, vector<bool> channels)
{
	//volume dimensions
	//int size = volobj->texwidth*volobj->texheight*volobj->texdepth*3;	
	//width  = volobj->texwidth;
	//height = volobj->texheight;
	//depth  = volobj->texdepth;

	//copy original
	copy_source3D();
	//allocate_result3D();

	//=====================================
	//apply gaussian, low-pass image
	//=====================================
	printf("Applying Gaussian Smoothing: (sigma: %.2f, size: %d)\n", sigma,gsize); 
	Gaussian gauss;

	//evaluate our sigma value for a given 
	//kernel mask radius
	//gauss.eval_sigma(kernel_radius);
	gauss.sigma = sigma;
	gauss.size = gsize;
	int kernel_radius = (gsize-1)/2;

	vector< vector< vector<double> > > mask3d;
	vector< vector< double > > mask2d;

	if(dimensionality==1)
	{
		//allocate some memory for our kernel mask
		mask3d.resize((int)gauss.size);
		for(int n=0; n<gauss.size; n++)
			mask3d[n].resize(gauss.size);

		for(int nn=0; nn<gauss.size; nn++)
			for(int nnn=0; nnn<gauss.size; nnn++)
			mask3d[nn][nnn].resize((int)gauss.size);

		//evaluate our guassian kernel mask
		mask3d = gauss.gaussianmask3D(gauss.sigma, gauss.size);
	}
	else
	{
		mask2d.resize((int)gauss.size);
		for(int n=0; n<gauss.size; n++)
			mask2d[n].resize(gauss.size);

		mask2d = gauss.gaussianmask2D(gauss.sigma, gauss.size);
	}

	int index=0;
	int x_iter=0;
	int y_iter=0;
	int z_iter=0;
	int xval, yval, zval;
	
	double filtered_value=0.0;

	progressbar = new Q3ProgressDialog("Applying Unsharp Mask...", "Cancel", depth, 0, "progress", TRUE);		
	progressbar->setCaption("Please Wait");
	
	int offset=0;
	if(channels[1]==true) offset=1;
	else if(channels[2]==true) offset=2;
 
	//int 
	int dsize = depth-kernel_radius;
	int helper2=0;
	for(float z=volobj->boundingboxMin.z; z<volobj->boundingboxMax.z; z++)
	{
		//progress(z, depth-kernel_radius);(int)
		progressbar->setProgress(helper2);
		if (progressbar->wasCancelled())
			break;

		helper2++;

		for(float x=volobj->boundingboxMin.x; x<volobj->boundingboxMax.x; x++)
		{
			for(float y=volobj->boundingboxMin.y; y<volobj->boundingboxMax.y; y++)
			{				
					x_iter=0;
					y_iter=0;
					z_iter=0;
					filtered_value=0.0;
	
					if(dimensionality==1)
					{
						for(int i=-kernel_radius; i<=kernel_radius; i++)
						{
							for(int j=-kernel_radius; j<=kernel_radius; j++)
							{
								for(int k=-kernel_radius; k<=kernel_radius; k++)
								{
									zval = z+i;
									yval = y+j;
									xval = x+k;

									if(zval>volobj->boundingboxMax.z-1) zval = volobj->boundingboxMax.z-1;
									if(yval>volobj->boundingboxMax.y-1) yval = volobj->boundingboxMax.y-1;
									if(xval>volobj->boundingboxMax.x-1) xval = volobj->boundingboxMax.x-1;

									if(zval<volobj->boundingboxMin.z) zval = volobj->boundingboxMin.z;
									if(yval<volobj->boundingboxMin.y) yval = volobj->boundingboxMin.y;
									if(xval<volobj->boundingboxMin.x) xval = volobj->boundingboxMin.x;
									
									index = 3*(((((zval-volobj->boundingboxMin.z)*height)+(yval-volobj->boundingboxMin.y))*width)+(xval-volobj->boundingboxMin.x));

									filtered_value += (double)(source_array[index+offset])*mask3d[x_iter][y_iter][z_iter];
																				
									z_iter++;
								}
								
								y_iter++;
								z_iter=0;
							}

							x_iter++;
							y_iter=0;
						}
					}
					else
					{
						for(int j=-kernel_radius; j<=kernel_radius; j++)
						{
							for(int k=-kernel_radius; k<=kernel_radius; k++)
							{
								xval = x+k;
								yval = y+j;

								if(yval>volobj->boundingboxMax.y-1) yval = volobj->boundingboxMax.y-1;
								if(xval>volobj->boundingboxMax.x-1) xval = volobj->boundingboxMax.x-1;
								if(yval<volobj->boundingboxMin.y) yval = volobj->boundingboxMin.y;
								if(xval<volobj->boundingboxMin.x) xval = volobj->boundingboxMin.x;
								
								index = 3*(((((z-volobj->boundingboxMin.z)*height)+(yval-volobj->boundingboxMin.y))*width)+(xval-volobj->boundingboxMin.x));
										
										
								filtered_value += (double)(source_array[index+offset])*mask2d[x_iter][y_iter];
								
								y_iter++;
							}
							
							x_iter++;
							y_iter=0;
						}
					}

					index = 3*((((((int)z)*volobj->texheight)+((int)y))*volobj->texwidth)+((int)x));

					//substract low-pass from original
					//to get high-pass image
					volobj->texture3d[index+offset] = (int)filtered_value+0.5;
			}
		}
	}
	progressbar->setProgress(depth);
	delete progressbar;
	progressbar = NULL;

	if(dimensionality==1)
	{
		for(int nn=0; nn<gauss.size; nn++)
			for(int nnn=0; nnn<gauss.size; nnn++)
			{
				mask3d[nn][nnn].clear();
			}
		
		for(int nnn=0; nnn<gauss.size; nnn++)
		{
			mask3d[nnn].clear();
		}

		mask3d.clear();
	}
	else
	{
		for(int nnn=0; nnn<gauss.size; nnn++)
		{
			mask2d[nnn].clear();
		}

		mask2d.clear();	
	}

	//=====================================
	//compute high-pass of original
	//=====================================
	/*for(int i=0; i<size; i++)
	{
		int voxel = source_array[i] - volobj->texture3d[i];

		if(voxel>255) voxel = 255;
		if(voxel<0)	  voxel = 0;

		//get voxel value
		volobj->texture3d[i] = voxel;
	}*/
	int subindex, bigindex;
	for(float z=volobj->boundingboxMin.z; z<volobj->boundingboxMax.z; z++)
	{
		for(float x=volobj->boundingboxMin.x; x<volobj->boundingboxMax.x; x++)
		{
			for(float y=volobj->boundingboxMin.y; y<volobj->boundingboxMax.y; y++)
			{
				subindex = 3*((((((int)z-volobj->boundingboxMin.z)*height)+((int)y-volobj->boundingboxMin.y))*width)+((int)x-volobj->boundingboxMin.x));
				bigindex = 3*((((((int)z)*volobj->texheight)+((int)y))*volobj->texwidth)+((int)x));
				
				int voxel = source_array[subindex+offset] - volobj->texture3d[bigindex+offset];				

				if(voxel>255) voxel = 255;
				if(voxel<0)   voxel = 0;

				//get voxel value
				volobj->texture3d[bigindex+offset] = voxel;
			}
		}
	}

	//=====================================
	//add high-pass to original
	//to get edge enhanced
	//=====================================
	/*for(int i=0; i<size; i++)
	{
		int voxel = source_array[i] + volobj->texture3d[i];

		if(voxel>255) voxel = 255;
		if(voxel<0)	  voxel = 0;

		//get voxel value
		volobj->texture3d[i] = voxel;
	}*/
	for(float z=volobj->boundingboxMin.z; z<volobj->boundingboxMax.z; z++)
	{
		for(float x=volobj->boundingboxMin.x; x<volobj->boundingboxMax.x; x++)
		{
			for(float y=volobj->boundingboxMin.y; y<volobj->boundingboxMax.y; y++)
			{
				subindex = 3*((((((int)z-volobj->boundingboxMin.z)*height)+((int)y-volobj->boundingboxMin.y))*width)+((int)x-volobj->boundingboxMin.x));
				bigindex = 3*((((((int)z)*volobj->texheight)+((int)y))*volobj->texwidth)+((int)x));
				
				int voxel = source_array[subindex+offset] + volobj->texture3d[bigindex+offset];				

				if(voxel>255) voxel = 255;
				if(voxel<0)   voxel = 0;

				//get voxel value
				volobj->texture3d[bigindex+offset] = voxel;
			}
		}
	}
	
	//delete result_array;
	delete source_array;
	source_array = NULL;
	gauss.clear_all();
}
void Filter::apply_median_filter(int kernel_radius, int dimensionality, vector<bool> channels)
{
	copy_source3D();
	
	vector<unsigned char> kernel_values;
	
	if(dimensionality==1) kernel_values.resize( (kernel_radius*2+1)*(kernel_radius*2+1)*(kernel_radius*2+1) );
	else  kernel_values.resize((kernel_radius*2+1)*(kernel_radius*2+1));
	
	int current_index = 0;
	int filtered_value = 0;
	int xval, yval, zval;
	
	progressbar = new Q3ProgressDialog("Applying Median Filter...", "Cancel", depth, 0, "progress", TRUE);		
	progressbar->setCaption("Please Wait");
	
	int offset=0;
	if(channels[1]==true) offset=1;
	if(channels[2]==true) offset=2;

	int index;

	int value;
	int helper=0;
	int helper2=0;
	for(float z=volobj->boundingboxMin.z; z<volobj->boundingboxMax.z; z++)
	{
		//progress(z, depth-kernel_radius);
		progressbar->setProgress(helper2);
		if (progressbar->wasCancelled())
			break;

		helper2++;

		for(float y=volobj->boundingboxMin.y; y<volobj->boundingboxMax.y; y++)
		{
			for(float x=volobj->boundingboxMin.x; x<volobj->boundingboxMax.x; x++)
			{				
					if(dimensionality==1)	//3D
					{
						helper=0;
						for(int i=-kernel_radius; i<=kernel_radius; i++)
						{
							for(int j=-kernel_radius; j<=kernel_radius; j++)
							{
								for(int k=-kernel_radius; k<=kernel_radius; k++)
								{
									zval = z+i;
									yval = y+j;
									xval = x+k;

									if(zval>volobj->boundingboxMax.z-1) zval = volobj->boundingboxMax.z-1;
									if(yval>volobj->boundingboxMax.y-1) yval = volobj->boundingboxMax.y-1;
									if(xval>volobj->boundingboxMax.x-1) xval = volobj->boundingboxMax.x-1;

									if(zval<volobj->boundingboxMin.z) zval = volobj->boundingboxMin.z;
									if(yval<volobj->boundingboxMin.y) yval = volobj->boundingboxMin.y;
									if(xval<volobj->boundingboxMin.x) xval = volobj->boundingboxMin.x;
									
									index = 3*(((((zval-volobj->boundingboxMin.z)*height)+(yval-volobj->boundingboxMin.y))*width)+(xval-volobj->boundingboxMin.x));

									value = source_array[index+offset];
									
									kernel_values[helper] = value;
									helper++;
								}
							}
						}
					}
					else		//2D
					{
						helper=0;
						for(int i=-kernel_radius; i<=kernel_radius; i++)
						{
							for(int j=-kernel_radius; j<=kernel_radius; j++)
							{
									xval = x+i;
									yval = y+j;

									if(yval>volobj->boundingboxMax.y-1) yval = volobj->boundingboxMax.y-1;
									if(xval>volobj->boundingboxMax.x-1) xval = volobj->boundingboxMax.x-1;
									if(yval<volobj->boundingboxMin.y) yval = volobj->boundingboxMin.y;
									if(xval<volobj->boundingboxMin.x) xval = volobj->boundingboxMin.x;
									
									index = 3*(((((z-volobj->boundingboxMin.z)*height)+(yval-volobj->boundingboxMin.y))*width)+(xval-volobj->boundingboxMin.x));
									
									value = source_array[index+offset];
									
									kernel_values[helper] = value;
									helper++;
							}
						}
					}
					
					sort(kernel_values.begin(), kernel_values.end());
					filtered_value = kernel_values[kernel_values.size()/2.0];

					//index = 3*(((((((int)z)-volobj->boundingboxMin.z)*height)+((int)y-volobj->boundingboxMin.y))*width)+((int)x-volobj->boundingboxMin.x));
					//filtered_value = source_array[index+offset];

					current_index = 3*((((((int)z)*volobj->texheight)+((int)y))*volobj->texwidth)+((int)x));
					volobj->texture3d[current_index+offset]=filtered_value;
			}
		}
	}
	
	progressbar->setProgress(depth);
	delete progressbar;
	progressbar = NULL;
	
	delete source_array;
	source_array=NULL;
}
void Filter::apply_mean_filter(int kernel_radius, int dimensionality, vector<bool> channels)
{
	copy_source3D();
	
	int current_index = 0;
	int filtered_value = 0;
	int xval, yval, zval;
	int sizehelper=0;
	
	//progressbar = new Q3ProgressDialog("Applying Mean Filter...", "Cancel", depth, 0, "progress", TRUE);		
	//progressbar->setCaption("Please Wait");

	for(int z=0; z<depth; z++)
	{
		//progress(z, depth);

		//progressbar->setProgress(z);
		//if (progressbar->wasCancelled())
		//	break;
			
		for(int x=0; x<width; x++)
		{
			for(int y=0; y<height; y++)
			{					
					sizehelper = 0;
					
					if(dimensionality==1)
					{
						for(int i=-kernel_radius; i<=kernel_radius; i++)
						{
							for(int j=-kernel_radius; j<=kernel_radius; j++)
							{
								for(int k=-kernel_radius; k<=kernel_radius; k++)
								{
									zval = z+i;
									yval = y+j;
									xval = x+k;

									if(zval>depth-1) zval = depth-1;
									if(xval>width-1) xval = width-1;
									if(yval>height-1) yval = height-1;
									if(zval<0) zval = 0;
									if(xval<0) xval = 0;
									if(yval<0) yval = 0;
									
									int index = 3*(((((zval)*height)+(yval))*width)+(xval));
									
									if(channels[0]==true) filtered_value = source_array[index+0];
									else if(channels[1]==true) filtered_value = source_array[index+1];
									else if(channels[2]==true) filtered_value = source_array[index+2];
									sizehelper++;
								}
							}
						}
					}
					else
					{
						for(int j=-kernel_radius; j<=kernel_radius; j++)
						{
							for(int k=-kernel_radius; k<=kernel_radius; k++)
							{
								yval = y+j;
								xval = x+k;

								if(xval>width-1) xval = width-1;
								if(yval>height-1) yval = height-1;
								if(xval<0) xval = 0;
								if(yval<0) yval = 0;
								
								int index = 3*(((((z)*height)+(yval))*width)+(xval));
								
								if(channels[0]==true) filtered_value = source_array[index+0];
								else if(channels[1]==true) filtered_value = source_array[index+1];
								else if(channels[2]==true) filtered_value = source_array[index+2];
								sizehelper++;
							}
						}
					}
					
					filtered_value /= (float) sizehelper;
					
					current_index = 3*((((z*height)+y)*width)+x);

					if(channels[0]==true) volobj->texture3d[current_index+0]=filtered_value;
					else if(channels[1]==true) volobj->texture3d[current_index+1]=filtered_value;
					else if(channels[2]==true) volobj->texture3d[current_index+2]=filtered_value;
			}
		}
	}
	
	//progressbar->setProgress(depth);
	//delete progressbar;
	//progressbar = NULL;
	
	delete source_array;
	source_array=NULL;
}
/*
void Filter::apply_canny3D(int kernel_radius, double sigma, double minthresh, double maxthresh)
{
	//temp image arrays for our sobel arrays;
	int _size = width*height*depth*1;

	//allocate some temp storage
	short* sobel_h = 0;
	sobel_h = new short [_size];
	short* sobel_v = 0;
	sobel_v = new short [_size];
	short* sobel_d = 0;
	sobel_d = new short [_size];
	
	unsigned char* non_maxima = 0;
	non_maxima = new unsigned char [_size*4];

	//apply a guassian to our image
	cout<<"Gausian3D..."<<endl;
	apply_gaussian3D(kernel_radius, sigma);
	result2source3D();

	//apply a 3D sobel horizontal edge detector
	cout<<endl<<"Sobel3D_H..."<<endl;
	apply_sobel3D(SOBEL_HORIZ);
	sobel_result2newarray3D(sobel_h);

	//apply a 3D sobel vertical edge detector
	cout<<endl<<"Sobel3D_V..."<<endl;
	apply_sobel3D(SOBEL_VERTI);
	sobel_result2newarray3D(sobel_v);

	//apply a 3D sobel vertical edge detector
	cout<<endl<<"Sobel3D_D..."<<endl;
	apply_sobel3D(SOBEL_DEPTH);
	sobel_result2newarray3D(sobel_d);

	//delete our sobel_result_array
	if(sobel_result_array) delete[] sobel_result_array;

	//apply a non maxima suppression
	cout<<endl<<"Non Maxima Suppression..."<<endl;
	nonMaximaSuppression3D(sobel_v, sobel_h, sobel_d);
	result2newarray3D(non_maxima);
 
	//delete our sobel v,h,d arrays
	if(sobel_v)		delete[] sobel_v;
	if(sobel_h)		delete[] sobel_h;
	if(sobel_d)		delete[] sobel_d;

	//apply histeresis
	cout<<endl<<"Histeresis..."<<endl;
	histeresis3D(non_maxima, minthresh, maxthresh);

	//delete our temp storage
	if(non_maxima)	delete[] non_maxima;
}

void Filter::nonMaximaSuppression3D(short* sobel_v, short* sobel_h, short* sobel_d)
{
	allocate_result3D();

	for(int k=1; k<depth-1; k++)
	{
		progress(k, depth-1);

		for(int i=1; i<width-1; i++)
		{
			for(int j=1; j<height-1; j++)
			{
				nMS3D(sobel_v, sobel_h, sobel_d, i, j, k, 0);
				nMS3D(sobel_v, sobel_h, sobel_d, i, j, k, 1);
				nMS3D(sobel_v, sobel_h, sobel_d, i, j, k, 2);
			}
		}
	}
}

void Filter::nMS3D(short* sobel_v, short* sobel_h, short* sobel_d, int x, int y, int z, int channel)
{
	double prevPixel;
	double nextPixel;
	double theta;
	double sum;
	double sumX;
	double sumY;
	double sumZ;

	double alpha;

	int index = ((((z*height)+y)*width)+x);
	
	sumX = sobel_h[index];
	sumY = sobel_v[index];
	sumZ = sobel_d[index];

	//=================================
	//gradient magnitude approximation
	//=================================
	sum = abs(sumX) + abs(sumY) + abs(sumZ);

	//=================================
	//magnitude orientation
	//=================================
	theta = atan2(sumY, sumX) * (180/PI);;
	alpha = atan2(sumZ, sqrt(sumX*sumX+sumY*sumY)) * (180/PI);;

	//====================================================
	// Find edgeDirection by assigning theta a value of
	// either 0, 45, 90 or 135 degrees, depending on which
	// value theta is closest to
	//====================================================
	if		   (theta > -22.5 && theta <=  22.5)	theta = 0;
	else if	   (theta >  22.5 && theta <=  67.5)	theta = 45;
	else if	   (theta >  67.5 && theta <= 112.5)	theta = 90;
	else if	   (theta > 112.5 && theta <= 157.5)	theta = 135;
	else if	   (theta > 157.5 || theta <=-157.5)	theta = -180;
	else if	   (theta >-157.5 && theta <=-112.5)	theta = -135;
	else if	   (theta >-112.5 && theta <= -67.5)	theta = -90;
	else if	   (theta > -67.5 && theta <= -22.5)	theta = -45;
	
	if		   (alpha > -22.5 && alpha <=  22.5)	alpha = 0;
	else if	   (alpha >  22.5 && alpha <=  67.5)	alpha = 45;
	else if	   (alpha >  67.5 && alpha <= 112.5)	alpha = 90;
	else if	   (alpha > 112.5 && alpha <= 157.5)	alpha = 135;
	else if	   (alpha > 157.5 || alpha <=-157.5)	alpha = -180;
	else if	   (alpha >-157.5 && alpha <=-112.5)	alpha = -135;
	else if	   (alpha >-112.5 && alpha <= -67.5)	alpha = -90;
	else if	   (alpha > -67.5 && alpha <= -22.5)	alpha = -45;

	int MPP=1; int ZPP=1; int PPP=1; 
	int MZP=1; int ZZP=1; int PZP=1;
	int MMP=1; int ZMP=1; int PMP=1;

	int MPZ=1; int ZPZ=1; int PPZ=1;
	int MZZ=1; int ZZZ=1; int PZZ=1;
	int MMZ=1; int ZMZ=1; int PMZ=1;

	int MPM=1; int ZPM=1; int PPM=1;
	int MZM=1; int ZZM=1; int PZM=1;
	int MMM=1; int ZMM=1; int PMM=1;

	if(alpha==-90 && ZZP && ZZM)
	{
		//ZZP
		index = (((((z+1)*height)+(y))*width)+(x));
		prevPixel  = abs(sobel_h[index]) + abs(sobel_v[index]) + abs(sobel_d[index]);

		//ZZM
		index = (((((z-1)*height)+(y))*width)+(x));
		nextPixel  = abs(sobel_h[index]) + abs(sobel_v[index]) + abs(sobel_d[index]);
	}
	else if(alpha==90 && ZZM && ZZP)
	{
		//ZZM
		index = (((((z-1)*height)+(y))*width)+(x));
		prevPixel  = abs(sobel_h[index]) + abs(sobel_v[index]) + abs(sobel_d[index]);
		
		//ZZP
		index = (((((z+1)*height)+(y))*width)+(x));
		nextPixel  = abs(sobel_h[index]) + abs(sobel_v[index]) + abs(sobel_d[index]);
	}
	else if(theta == 0)   
	{
		if(alpha == 45 && MZP && PZM)   
		{
			//PZM
			index = (((((z-1)*height)+(y))*width)+(x+1));
			prevPixel  = abs(sobel_h[index]) + abs(sobel_v[index]) + abs(sobel_d[index]);

			//MZP
			index = (((((z+1)*height)+(y))*width)+(x-1));
			nextPixel  = abs(sobel_h[index]) + abs(sobel_v[index]) + abs(sobel_d[index]);
		}
		else if(alpha == 0 && PZZ && MZZ)   
		{
			//PZZ
			index = (((((z)*height)+(y))*width)+(x+1));
			prevPixel  = abs(sobel_h[index]) + abs(sobel_v[index]) + abs(sobel_d[index]);

			//MZZ
			index = (((((z)*height)+(y))*width)+(x-1));
			nextPixel  = abs(sobel_h[index]) + abs(sobel_v[index]) + abs(sobel_d[index]);
		}
		else if(alpha == -45 && PZP && MZM)   
		{
			//PZP
			index = (((((z+1)*height)+(y))*width)+(x+1));
			prevPixel  = abs(sobel_h[index]) + abs(sobel_v[index]) + abs(sobel_d[index]);

			//MZM
			index = (((((z-1)*height)+(y))*width)+(x-1));
			nextPixel  = abs(sobel_h[index]) + abs(sobel_v[index]) + abs(sobel_d[index]);
		}
	}
	else if(theta == 45)   
	{
		if(alpha == 45 && PPM && MMP)   
		{
			//PPM
			index = (((((z-1)*height)+(y+1))*width)+(x+1));
			prevPixel  = abs(sobel_h[index]) + abs(sobel_v[index]) + abs(sobel_d[index]);
			
			//MMP
			index = (((((z+1)*height)+(y-1))*width)+(x-1));
			nextPixel  = abs(sobel_h[index]) + abs(sobel_v[index]) + abs(sobel_d[index]);
		}
		else if(alpha == 0 && PPZ && MMZ)   
		{
			//PPZ
			index = (((((z)*height)+(y+1))*width)+(x+1));
			prevPixel  = abs(sobel_h[index]) + abs(sobel_v[index]) + abs(sobel_d[index]);

			//MMZ
			index = (((((z)*height)+(y-1))*width)+(x-1));
			nextPixel  = abs(sobel_h[index]) + abs(sobel_v[index]) + abs(sobel_d[index]);
		}
		else if(alpha == -45 && PPP && MMM)   
		{
			//PPP
			index = (((((z+1)*height)+(y+1))*width)+(x+1));
			prevPixel  = abs(sobel_h[index]) + abs(sobel_v[index]) + abs(sobel_d[index]);

			//MMM
			index = (((((z-1)*height)+(y-1))*width)+(x-1));
			nextPixel  = abs(sobel_h[index]) + abs(sobel_v[index]) + abs(sobel_d[index]);

		}
	}
	else if(theta == 90)   
	{
		if(alpha == 45 && ZPM && ZMP)   
		{
			//ZPM
			index = (((((z-1)*height)+(y+1))*width)+(x));
			prevPixel  = abs(sobel_h[index]) + abs(sobel_v[index]) + abs(sobel_d[index]);

			//ZMP
			index = (((((z+1)*height)+(y-1))*width)+(x));
			nextPixel  = abs(sobel_h[index]) + abs(sobel_v[index]) + abs(sobel_d[index]);
		}
		else if(alpha == 0 && ZPZ && ZMZ)   
		{
			//ZPZ
			index = (((((z)*height)+(y+1))*width)+(x));
			prevPixel  = abs(sobel_h[index]) + abs(sobel_v[index]) + abs(sobel_d[index]);

			//ZMZ
			index = (((((z)*height)+(y-1))*width)+(x));
			nextPixel  = abs(sobel_h[index]) + abs(sobel_v[index]) + abs(sobel_d[index]);
		}
		else if(alpha == -45 && ZPP && ZMM)   
		{
			//ZPP
			index = (((((z+1)*height)+(y+1))*width)+(x));
			prevPixel  = abs(sobel_h[index]) + abs(sobel_v[index]) + abs(sobel_d[index]);

			//ZMM
			index = (((((z-1)*height)+(y-1))*width)+(x));
			nextPixel  = abs(sobel_h[index]) + abs(sobel_v[index]) + abs(sobel_d[index]);
		}
	}
	else if(theta == 135)   
	{
		if(alpha == 45 && MPM && PMP)   
		{
			//MPM
			index = (((((z-1)*height)+(y+1))*width)+(x-1));
			prevPixel  = abs(sobel_h[index]) + abs(sobel_v[index]) + abs(sobel_d[index]);

			//PMP
			index = (((((z+1)*height)+(y-1))*width)+(x+1));
			nextPixel  = abs(sobel_h[index]) + abs(sobel_v[index]) + abs(sobel_d[index]);
		}
		else if(alpha == 0 && MPZ && PMZ)   
		{
			//MPZ
			index = (((((z)*height)+(y+1))*width)+(x-1));
			prevPixel  = abs(sobel_h[index]) + abs(sobel_v[index]) + abs(sobel_d[index]);

			//PMZ
			index = (((((z)*height)+(y-1))*width)+(x+1));
			nextPixel  = abs(sobel_h[index]) + abs(sobel_v[index]) + abs(sobel_d[index]);
		}
		else if(alpha == -45 && MPP && PMM)   
		{
			//MPP
			index = (((((z+1)*height)+(y+1))*width)+(x-1));
			prevPixel  = abs(sobel_h[index]) + abs(sobel_v[index]) + abs(sobel_d[index]);

			//PMM
			index = (((((z-1)*height)+(y-1))*width)+(x+1));
			nextPixel  = abs(sobel_h[index]) + abs(sobel_v[index]) + abs(sobel_d[index]);
		}
	}
	else if(theta == -180)   
	{
		if(alpha == 45 && MZM && PZP)   
		{
			//MZM
			index = (((((z-1)*height)+(y))*width)+(x-1));
			prevPixel  = abs(sobel_h[index]) + abs(sobel_v[index]) + abs(sobel_d[index]);

			//PZP
			index = (((((z+1)*height)+(y))*width)+(x+1));
			nextPixel  = abs(sobel_h[index]) + abs(sobel_v[index]) + abs(sobel_d[index]);
		}
		else if(alpha == 0 && MZZ && PZZ)   
		{
			//MZZ
			index = (((((z)*height)+(y))*width)+(x-1));
			prevPixel  = abs(sobel_h[index]) + abs(sobel_v[index]) + abs(sobel_d[index]);

			//PZZ
			index = (((((z)*height)+(y))*width)+(x+1));
			nextPixel  = abs(sobel_h[index]) + abs(sobel_v[index]) + abs(sobel_d[index]);
		}
		else if(alpha == -45 && MZP && PZM)   
		{
			//MZP
			index = (((((z+1)*height)+(y))*width)+(x-1));
			prevPixel  = abs(sobel_h[index]) + abs(sobel_v[index]) + abs(sobel_d[index]);

			//PZM
			index = (((((z-1)*height)+(y))*width)+(x+1));
			nextPixel  = abs(sobel_h[index]) + abs(sobel_v[index]) + abs(sobel_d[index]);
		}
	}
	else if(theta == -135)   
	{
		if(alpha == 45 && MMM && PPP)   
		{
			//MMM
			index = (((((z-1)*height)+(y-1))*width)+(x-1));
			prevPixel  = abs(sobel_h[index]) + abs(sobel_v[index]) + abs(sobel_d[index]);

			//PPP
			index = (((((z+1)*height)+(y+1))*width)+(x+1));
			nextPixel  = abs(sobel_h[index]) + abs(sobel_v[index]) + abs(sobel_d[index]);
		}
		else if(alpha == 0 && MMZ && PPZ)   
		{
			//MMZ
			index = (((((z)*height)+(y-1))*width)+(x-1));
			prevPixel  = abs(sobel_h[index]) + abs(sobel_v[index]) + abs(sobel_d[index]);

			//PPZ
			index = (((((z)*height)+(y+1))*width)+(x+1));
			nextPixel  = abs(sobel_h[index]) + abs(sobel_v[index]) + abs(sobel_d[index]);

		}
		else if(alpha == -45 && MMP && PPM)   
		{
			//MMP
			index = (((((z+1)*height)+(y-1))*width)+(x-1));
			prevPixel  = abs(sobel_h[index]) + abs(sobel_v[index]) + abs(sobel_d[index]);

			//PPM
			index = (((((z-1)*height)+(y+1))*width)+(x+1));
			nextPixel  = abs(sobel_h[index]) + abs(sobel_v[index]) + abs(sobel_d[index]);
		}
	}
	else if(theta == -90)   
	{
		if(alpha == 45 && ZMM && ZPP)   
		{
			//ZMM
			index = (((((z-1)*height)+(y-1))*width)+(x));
			prevPixel  = abs(sobel_h[index]) + abs(sobel_v[index]) + abs(sobel_d[index]);

			//ZPP
			index = (((((z+1)*height)+(y+1))*width)+(x));
			nextPixel  = abs(sobel_h[index]) + abs(sobel_v[index]) + abs(sobel_d[index]);
		}
		else if(alpha == 0 && ZMZ && ZPM)   
		{
			//ZMZ
			index = (((((z)*height)+(y-1))*width)+(x));
			prevPixel  = abs(sobel_h[index]) + abs(sobel_v[index]) + abs(sobel_d[index]);

			//ZPM
			index = (((((z)*height)+(y+1))*width)+(x));
			nextPixel  = abs(sobel_h[index]) + abs(sobel_v[index]) + abs(sobel_d[index]);
		}
		else if(alpha == -45 && ZMP && ZPM)   
		{
			//ZMP
			index = (((((z+1)*height)+(y-1))*width)+(x));
			prevPixel  = abs(sobel_h[index]) + abs(sobel_v[index]) + abs(sobel_d[index]);

			//ZPM
			index = (((((z-1)*height)+(y+1))*width)+(x));
			nextPixel  = abs(sobel_h[index]) + abs(sobel_v[index]) + abs(sobel_d[index]);

		}
	}
	else if(theta == -45)   
	{
		if(alpha == 45 && PMM && MPP)   
		{
			//PMM
			index = (((((z-1)*height)+(y-1))*width)+(x+1));
			prevPixel  = abs(sobel_h[index]) + abs(sobel_v[index]) + abs(sobel_d[index]);

			//MPP
			index = (((((z+1)*height)+(y+1))*width)+(x-1));
			nextPixel  = abs(sobel_h[index]) + abs(sobel_v[index]) + abs(sobel_d[index]);
		}
		else if(alpha == 0 && PMZ && MPZ)   
		{
			//PMZ
			index = (((((z)*height)+(y-1))*width)+(x+1));
			prevPixel  = abs(sobel_h[index]) + abs(sobel_v[index]) + abs(sobel_d[index]);

			//MPZ
			index = (((((z)*height)+(y+1))*width)+(x-1));
			nextPixel  = abs(sobel_h[index]) + abs(sobel_v[index]) + abs(sobel_d[index]);

		}
		else if(alpha == -45 && PMP && MPM)   
		{
			//PMP
			index = (((((z+1)*height)+(y-1))*width)+(x+1));
			prevPixel  = abs(sobel_h[index]) + abs(sobel_v[index]) + abs(sobel_d[index]);
			
			//MPM
			index = (((((z-1)*height)+(y+1))*width)+(x-1));
			nextPixel  = abs(sobel_h[index]) + abs(sobel_v[index]) + abs(sobel_d[index]);
		}
	}
	else
	{
		prevPixel = nextPixel = 0;
	}

	index = (((((z)*height)+(y))*width)+(x))*4 + channel;
	
	if(sum<prevPixel || sum<nextPixel)
	{
		result_array[index+0] = 0;
		result_array[index+1] = 0;
		result_array[index+2] = 0;
		result_array[index+3] = 0;
	}
	else
	{
		if(sum<0)	sum = 0;
		if(sum>255) sum = 255;

		result_array[index+0] = sum;
		result_array[index+1] = sum;
		result_array[index+2] = sum;
		result_array[index+3] = sum;
	}
}

vector<Vector> Filter::find_neighbours3D(int x, int y, int z, int channel)
{
	int index=0;

	vector<Vector> temp;
	Vector tempV;

	int mask[27];
	int iter = 0;

	mask[0] = 1; mask[1] = 1; mask[2] = 1;
	mask[3] = 1; mask[4] = 1; mask[5] = 1;
	mask[6] = 1; mask[7] = 1; mask[8] = 1;

	mask[9]  = 1; mask[10] = 1; mask[11] = 1;
	mask[12] = 1; mask[13] = 1; mask[14] = 1;
	mask[15] = 1; mask[16] = 1; mask[17] = 1;

	mask[18] = 1; mask[19] = 1; mask[20] = 1;
	mask[21] = 1; mask[22] = 1; mask[23] = 1;
	mask[24] = 1; mask[25] = 1; mask[26] = 1;

	for(int i=-1; i<=1; i++)
	{
		for(int j=-1; j<=1; j++)
		{
			for(int k=-1; k<=1; k++)
			{
				if(mask[iter]==1)
				{
					if(i==0 && j==0 && k==0)
					{
						//skip centre pixel
					}
					else
					{
						if((x+i)>=0 && (y+j)>=0 && (z+k)>=0 && (x+i)<width && (y+j)<height && (z+k)<depth)
						{
							tempV.x = (x+i);
							tempV.y = (y+j);
							tempV.z = (z+k);

							tempV.w = (((((z+k)*height)+(y+j))*width)+(x+i))*4 + channel;

							temp.push_back(tempV);
						}
					}
				}

				iter++;
			}
		}
	}
	
	//cout<<temp.size()<<endl;


	return temp;
}

void Filter::histeresis3D(unsigned char* non_maxima_sup, double minthresh, double maxthresh)
{
	allocate_result3D();

	vector<Vector> stack;
	vector<Vector> neighbours;

	int* visitedpixels =  new int [width*height*depth];
	for(int i=0; i<width*height*depth; i++) visitedpixels[i]=-1;

	int index;
	Vector current_index;
	Vector current_neighbour_index;
	Vector col;

	for(int z=0; z<depth; z++)
	{
		progress(z, depth);

		for(int x=0; x<width; x++)
		{
			for(int y=0; y<height; y++)
			{
				index = ((((z*height)+y)*width)+x)*4+0;

				//if pixel is not visited
				if(visitedpixels[index/4]==-1)
				{
					//if it is below the min thresh
					if(non_maxima_sup[index] < minthresh )
					{
						// safely mark it as a non edge

						//mark visited
						visitedpixels[index/4]=1;
						
						//non-edge
						result_array[index]	  = 0;
						result_array[index+1] = 0;
						result_array[index+2] = 0;
					}
					else if( non_maxima_sup[index] >= maxthresh )
					{
						//mark visited
						visitedpixels[index/4]=1;

						//col.x = (float) rand()/RAND_MAX*255;
						//col.y = (float) rand()/RAND_MAX*255;
						//col.z = (float) rand()/RAND_MAX*255;
						//col.w = 255;

						col = 255;

						//edge
						result_array[index]   = col.x;
						result_array[index+1] = col.y;
						result_array[index+2] = col.z;
						
						//add current pixel to stack
						current_index.x = x;
						current_index.y = y;
						current_index.z = z;
						current_index.w= index;

						stack.push_back(current_index);

						//while stack is not empty
						while(!stack.empty())
						{
							//pop it off
							current_index = stack[stack.size()-1];
							stack.pop_back();
							
							//is it within the min thresh
							if(non_maxima_sup[(int)current_index.w] >=  minthresh)
							{
								//mark it as visited
								visitedpixels[(int)current_index.w/4] = 1;

								//edge
								result_array[(int)current_index.w]   = col.x;
								result_array[(int)current_index.w+1] = col.y;
								result_array[(int)current_index.w+2] = col.z;

								//find its neighbours
								neighbours = find_neighbours3D(current_index.x, current_index.y, current_index.z, 0);

								while(!neighbours.empty())
								{
									//pop it off
									current_neighbour_index = neighbours[neighbours.size()-1];
									neighbours.pop_back();
									
									if( visitedpixels[(int)current_neighbour_index.w/4] == -1 )
									{
										//mark it as visited
										visitedpixels[(int)current_neighbour_index.w/4] = 1;

										//add to stack
										stack.push_back(current_neighbour_index);
									}
								} //end while neighbours not empty
							}
							else
							{
								//non edge
								result_array[index]   = 0;
								result_array[index+1] = 0;
								result_array[index+2] = 0;

								//mark it as visited
								visitedpixels[index/4] = 1;
							}
						} //end while stack is not empty

					}
				}
			}
		}
	}
}
*/
