#ifndef FILTER_H
#define FILTER_H

#include <math.h>
#include <fstream>
#include <iostream>
#include <algorithm>

#include <Q3ProgressDialog>

#define TWOPI 		6.283185307179586476925286766558f
#define PI 			3.141592653589793238462643383279f

#include "Gaussian.h"
#include "Sobel.h"
#include "PCA.h"
#include "Vector.h"
#include "VolumeObject.h"

class Filter
{

	public:
		
		VolumeObject* volobj;
		Q3ProgressDialog*		progressbar;
		
		//======================================================
		//image dimensions
		//======================================================
		int width, height, depth;

		//======================================================
		//source image array and size
		//======================================================
		unsigned char* source_array;

		//======================================================
		//sobel result array
		//======================================================
		short* sobel_result_array;

		//======================================================
		//filtered image array and size
		//======================================================
		unsigned char* result_array;
		
		Filter();
		~Filter();

		void progress(int i, int size);
		
		//======================================================
		//array alloc stuff 3D
		//======================================================
		void copy_source3D(void);
		void allocate_source3D(void);
		void allocate_result3D(void);
		void allocate_sobel3D(void);
		void result2source3D(void);
		void result2newarray3D(unsigned char* new_array);
		void sobel_result2newarray3D(short* new_array);
		//======================================================

		double invtan(double x, double y);

		//======================================================
		//3D image filtering
		//======================================================
		vector< vector< vector<double> > > create_gaussianmask3D(int size, double sigma);
		void apply_gaussian3D(int kernel_radius, double sigma, int qual);
		void apply_sobel3D(int mode);
		void apply_unsharpmask3D(int brightness, int contrast, float sigma, int gsize);
		void auto_levels(void);
		void apply_contrast_stretching(void);
		void apply_harriscorner(void);
		void apply_median(int scale);
		void apply_mean(int scale);
		
		void apply_contrast_stretching_filter(int dimensionality, vector<bool> channels);
		void apply_auto_levels_filter(int dimensionality, vector<bool> channels);
		void apply_sobel3D_filter(int dimensionality, vector<bool> channels);
		void apply_gaussian_filter(int kernel_radius, double sigma, int dimensionality, vector<bool> channels);
		void apply_unsharpmask_filter(int kernel_radius, double sigma, int dimensionality, vector<bool> channels);
		void apply_median_filter(int kernel_radius, int dimensionality, vector<bool> channels);
		void apply_mean_filter(int kernel_radius, int dimensionality, vector<bool> channels);
		
/*		void apply_canny3D(int kernel_radius, double sigma, double minthresh, double maxthresh);
		void nonMaximaSuppression3D(short* sobel_v, short* sobel_h, short* sobel_d);
		void nMS3D(short* sobel_v, short* sobel_h, short* sobel_d, int x, int y, int z, int channel);
		vector<Vector> find_neighbours3D(int x, int y, int z, int channel);
		void histeresis3D(unsigned char* non_maxima_sup, double minthresh, double maxthresh);*/
};

#endif //FILTER_H
