#ifndef FLOODFILL_H
#define FLOODFILL_H

#include <math.h>
#include <iostream>
#include <fstream>
#include <vector>

using namespace std;

#include "VolumeObject.h"
#include "VolIO.h"
#include "Point3D.h"
#include "ColourFun.h"
#include "Vector.h"
#include "PCA.h"
#include "PlaneWidgetInCube.h"

#define COLOUR_RULE	0
#define FILL_RULE	1
#define EDGE_RULE	2
#define DILATE_RULE	3

#define CONNECT6	0
#define CONNECT26	1

class Floodfill
{

	public:
		
		VolumeObject* volobj;
		VolIO* volio;
		
		int width,height,depth;
		bool*** visited_voxels;
		
		vector< vector< vector<bool> > > edges;
	
		vector<int> region_dilate;
		vector<int> region_edge;
		vector< vector<int> > region_indices;
		
		vector< int > region_sizes;
		vector< Vector > region_colours;
		vector<Vector> region_colours_tokeep;

		vector<Vector> celleigenvectors;
		vector<Vector> cellmeans;
		vector<bool> regions_todelete;
	
		int regions;
		float scaleX, scaleY, scaleZ;
		
		int maxrecursiondepth;
		
		Floodfill();
		~Floodfill();
		
		void progress(int i, int size);

		void init(int w, int h, int d);
		void init_visited(void);
		void floodfill(int rule);
		
		void floodfillseeded_dilate(Point3D seedpoint, int rule, int depth);
		void floodfillseeded(Point3D seedpoint, int rule);
		
		void floodfill_peal(int depth);
		void floodfill_peal2(int depth, PlaneWidgetInCube clip);

		void delete_visited(void);
		
		int get1Dindex(Point3D p);
		Point3D get3Dindex(int index);
		
		void search_neighborhood(int x, int y, int z, vector<Point3D>* stack, int rule, int connectivity);

		bool apply_rule(int x0, int y0, int z0, int x1, int y1, int z1, int rule);
		int getValue(Point3D p, bool red, bool green, bool blue);
		
		void eval_connectivity(void);
		
		void apply_regiothreshold(void);
		void apply_result(int minsize, int maxsize);
};

#endif //FLOODFILL_H