/***********************************************************************
* Project:      VolViewer
* Title:        Main.cpp
* Author:       Jerome Avondo
*
* Purpose:      
*
************************************************************************/

//Added by qt3to4:
#include <QPixmap>	
#include <qapplication.h>
#include <qgl.h>
#include <qstring.h>
//#include <Wincon.h>
#include <QtPlugin>

#include "QtMainWindow.h"
#include "QtSplashScreen.h"

#include "Timer.h"
int window_consolle=0;
int window_main_screen=0;

void load_inifile_viewparams(void)
{
	string label;

	//input file for reading in parameter ranges
	ifstream input_file; 
	input_file.open("settings.ini");

	if(!input_file.is_open())
	{
		qWarning( "Error loading INI file!\n" );
		exit(1);
	}

	//tokenize our input file
	Tokenizer token(input_file);

	//until oef is reached step through each token
	while(!input_file.eof()){
		if(token.ttype()==TT_WORD)
		{
			//get the first string lable
			label = token.sval();
									
			if(label=="window_main_screen")
			{		
				//skip the equal sign
				token.nextToken(); 
				token.nextToken();
				if(token.ttype()==TT_NUMBER) window_main_screen = token.nval();
			}	
			else if(label=="window_consolle")
			{		
				//skip the equal sign
				token.nextToken(); 
				token.nextToken();
				if(token.ttype()==TT_NUMBER) window_consolle = token.nval();
				return;
			}					
			//else we dont know what it is, go to next label
			else
			{
				//cout<<"WARNING: Unrecognized Label..."<<endl;
				token.nextToken();
			}
		}
		else token.nextToken();
	}
	
	input_file.close();
}
int main( int argc, char **argv )
{
	//create a Qt application
    QApplication::setColorSpec( QApplication::CustomColor );
	//QApplication::addLibraryPath("plugins/");

    QApplication a(argc,argv,true);			

	//check if the system supports OpenGL
    if ( !QGLFormat::hasOpenGL() ) 
	{
		qWarning( "This system has no OpenGL support. Exiting." );
		return -1;
    }

	load_inifile_viewparams();
	
	//create a consolle (debug)
	if(window_consolle==1)
	{	
		#ifdef WIN32
		if(AllocConsole())
		{
			freopen("CON", "w", stdout);
			freopen("CON", "w", stderr);
		}
		#endif
	}	

	//create a splash screen
    QPixmap pixmap( "icons/splash.png" );
    QtSplashScreen *splash = new QtSplashScreen( pixmap, window_main_screen);

	//create a QtMainWindow for our application
    QtMainWindow *mw = new QtMainWindow();
	a.setMainWidget( mw );
	mw->setCaption( "Bioptonics Viewer v2.0" );
		
	//check if we have an parsed volume filename
	if(argc>1)
	{
		//printf("%s\n", argv[1]);
		mw->dragndrop_slot(argv[1]);
	}

	mw->load_inifile();
	
	//set the mainwindow to visible and launch the app
	QTimer::singleShot( 1000, splash, SLOT(finish()) );
	QTimer::singleShot( 1000, mw, SLOT(show()) );

	return 	a.exec();
}
