#include "QtCropWidget.h"
//Added by qt3to4:
#include <QPixmap>


QtCropWidget::QtCropWidget(QWidget* parent, const char* name)
: QWidget( parent, name )
{
	currentworkingdir="";
	setAcceptDrops(true);
}
QtCropWidget::~QtCropWidget()
{
}

void QtCropWidget::rebuild(void)
{
}
void QtCropWidget::reset(void)
{
	lloopmode_button->setOn(false);
	invcrop->setOn(false);

	emit crop_reset_signal();
}
void QtCropWidget::dragndrop_slot(QString sFileName)
{	
}
void QtCropWidget::dragEnterEvent(QDragEnterEvent* event)
{
	event->accept(Q3TextDrag::canDecode(event));
}
void QtCropWidget::dropEvent(QDropEvent* event)
{
	Q3StrList URIs;

	if ( Q3UriDrag::decode(event, URIs) ) 
	{
		QString text = Q3UriDrag::uriToLocalFile(URIs.getFirst());
		dragndrop_slot(text);
	}
}
void QtCropWidget::create(void)
{
/*	Q3ButtonGroup *toggle_grp = new Q3ButtonGroup( 1, Qt::Vertical, "Channels:", this );
	connect(toggle_grp, SIGNAL(clicked(int)), this, SLOT(channel_button_event(int)));
	toggle_grp->setExclusive(true);
	channels.resize(3);

		red = new QPushButton("Red", toggle_grp);
		red->setToggleButton(TRUE);
		red->setOn(true);
		channels[0] = true;
		//connect( red, SIGNAL( pressed() ), this, SLOT( red_button_event() ) );

		green = new QPushButton("Green", toggle_grp);
		green->setToggleButton(true);
		green->setOn(false);
		channels[1] = false;
		//connect( green, SIGNAL( pressed() ), this, SLOT( green_button_event() ) );

		blue = new QPushButton("Blue", toggle_grp);
		blue->setToggleButton(true);
		blue->setOn(false);
		channels[2] = false;
		//connect( blue, SIGNAL( pressed() ), this, SLOT( blue_button_event() ) );
*/
	Q3ButtonGroup *act_grp = new Q3ButtonGroup( 2, Qt::Horizontal, "Actions:", this );

		Q3ButtonGroup *crop_grp = new Q3ButtonGroup( 1, Qt::Horizontal, "", act_grp );
		
			QPixmap lloopmodeIcon = QPixmap( "Icons/crop0.png" );
			lloopmode_button		= new QPushButton(lloopmodeIcon, "",	crop_grp);
			lloopmode_button->setToolTip("Line Loop");
			lloopmode_button->setToggleButton(true);
			lloopmode_button->setOn(false);
			lloopmode_button->setFixedSize(66, 66);
			lloopmode_button->setIconSize(QSize(64,64));
			connect(lloopmode_button, SIGNAL( clicked () ), this, SLOT( cropmode_event() ) );

		Q3ButtonGroup *clipoperators_grp = new Q3ButtonGroup( 2, Qt::Vertical, "", act_grp );
			invcrop = new QPushButton("Inverse Selection", clipoperators_grp);
			invcrop->setToggleButton(true);
			invcrop->setOn(false);
			emit crop_invsel_signal(0);
			connect( invcrop, SIGNAL( pressed() ), this, SLOT(invcrop_button_event() ) );
			recentre = new QPushButton("Recentre Data", clipoperators_grp);
			connect( recentre, SIGNAL( pressed() ), this, SLOT(recentre_button_event() ) );

	Q3BoxLayout *vboxlayoutRIGHT = new Q3BoxLayout ( 0, Q3BoxLayout::TopToBottom, 0, 5, "vboxlayout");
	//vboxlayoutRIGHT->addWidget(toggle_grp, 0, Qt::AlignTop);
	vboxlayoutRIGHT->addWidget(act_grp, 0, Qt::AlignTop);

	Q3BoxLayout *topmost= new Q3BoxLayout ( this, Q3BoxLayout::LeftToRight, 10, 5, "topmost");
	topmost->addLayout(vboxlayoutRIGHT, 10);
}
void QtCropWidget::invcrop_button_event(void)
{
	if(invcrop->isOn())
	{
		QPixmap lloopmodeIcon = QPixmap( "Icons/crop0.png" );
		lloopmode_button->setIcon(lloopmodeIcon);
		emit crop_invsel_signal(1);
	}
	else
	{
		QPixmap lloopmodeIcon = QPixmap( "Icons/crop1.png" );
		lloopmode_button->setIcon(lloopmodeIcon);
		emit crop_invsel_signal(0);
	}
}
void QtCropWidget::recentre_button_event(void)
{
	emit crop_recentre_signal();
}
void QtCropWidget::cropmode_event(void)
{
	if(lloopmode_button->isOn())
	{
		//printf("on\n");
		emit crop_start_signal();
	}
	else
	{
		//printf("off\n");
		emit crop_end_signal();
	}
}
void QtCropWidget::exit(void)
{
}
void QtCropWidget::reset_button_event(void)
{
}
void QtCropWidget::channel_button_event(int selected)
{
	if(selected==0)
	{
		channels[0] = true;
		channels[1] = false;
		channels[2] = false;
	}
	else if(selected==1)
	{
		channels[0] = false;
		channels[1] = true;
		channels[2] = false;
	}
	else if(selected==2)
	{
		channels[0] = false;
		channels[1] = false;
		channels[2] = true;
	}
}
void QtCropWidget::load_event(void)
{
}
void QtCropWidget::save_event(void)
{
}