#include "QtFilterWidget.h"
//Added by qt3to4:
#include <QPixmap>


QtFilterWidget::QtFilterWidget(QWidget* parent, const char* name)
: QWidget( parent, name )
{
	currentworkingdir="";
	setAcceptDrops(true);
}
QtFilterWidget::~QtFilterWidget()
{
}

void QtFilterWidget::rebuild(void)
{
}
void QtFilterWidget::reset(void)
{
}
void QtFilterWidget::dragndrop_slot(QString sFileName)
{	
}
void QtFilterWidget::dragEnterEvent(QDragEnterEvent* event)
{
	event->accept(Q3TextDrag::canDecode(event));
}
void QtFilterWidget::dropEvent(QDropEvent* event)
{
	Q3StrList URIs;

	if ( Q3UriDrag::decode(event, URIs) ) 
	{
		QString text = Q3UriDrag::uriToLocalFile(URIs.getFirst());
		dragndrop_slot(text);
	}
}
void QtFilterWidget::create(void)
{
/*	Q3ButtonGroup *loadsave_grp = new Q3ButtonGroup( 1, Qt::Horizontal, "File:", this );

		load_pb = new QPushButton(QIcon(QPixmap("icons/fileopen.xpm")), "Open", loadsave_grp, "open");
		connect( load_pb, SIGNAL( clicked () ), this, SLOT( load_event() ) );

		save_pb = new QPushButton(QIcon(QPixmap("icons/filesave.xpm")), "Save", loadsave_grp, "save");
		connect( save_pb, SIGNAL( clicked () ), this, SLOT( save_event() ) );
*/
	Q3ButtonGroup *toggle_grp = new Q3ButtonGroup( 1, Qt::Vertical, "Channels:", this );
	connect(toggle_grp, SIGNAL(clicked(int)), this, SLOT(channel_button_event(int)));
	toggle_grp->setExclusive(true);
	channels.resize(3);

		red = new QPushButton("Red", toggle_grp);
		red->setToggleButton(TRUE);
		red->setOn(true);
		channels[0] = true;
		//connect( red, SIGNAL( pressed() ), this, SLOT( red_button_event() ) );

		green = new QPushButton("Green", toggle_grp);
		green->setToggleButton(true);
		green->setOn(false);
		channels[1] = false;
		//connect( green, SIGNAL( pressed() ), this, SLOT( green_button_event() ) );

		blue = new QPushButton("Blue", toggle_grp);
		blue->setToggleButton(true);
		blue->setOn(false);
		channels[2] = false;
		//connect( blue, SIGNAL( pressed() ), this, SLOT( blue_button_event() ) );

	/*Q3ButtonGroup *reset_grp = new Q3ButtonGroup( 1, Qt::Horizontal, "Reset:", this );

		reset_pb = new QPushButton("Reset", reset_grp);
		connect( reset_pb, SIGNAL( pressed() ), this, SLOT( reset_button_event() ) );
*/
	filter_grp = new Q3ButtonGroup( 1, Qt::Horizontal, "Filters:", this );
		
		QPushButton* thresh_pb = new QPushButton("Threshold by Opacity", filter_grp, "thresh");
		connect( thresh_pb, SIGNAL( clicked () ), this, SLOT( thresh_event() ) );

		QPushButton* binary_pb = new QPushButton("Convert to Binary", filter_grp, "binary");
		connect( binary_pb, SIGNAL( clicked () ), this, SLOT( binary_event() ) );

		QPushButton* lvls_pb = new QPushButton("Histogram Equalization", filter_grp, "level");
		connect( lvls_pb, SIGNAL( clicked () ), this, SLOT( autolevels_event() ) );

		QPushButton* contra_pb = new QPushButton("Stretch Contrast", filter_grp, "contra");
		connect( contra_pb, SIGNAL( clicked () ), this, SLOT( contraststretch_event() ) );

		QPushButton* mean_pb = new QPushButton("Mean Filter", filter_grp, "mean");
		connect( mean_pb, SIGNAL( clicked () ), this, SLOT( mean_event() ) );
		mean_pb->hide();

		QPushButton* median_pb = new QPushButton("Median Filter", filter_grp, "median");
		connect( median_pb, SIGNAL( clicked () ), this, SLOT( median_event() ) );

		QPushButton* gaussian_pb = new QPushButton("Gaussian Smooth", filter_grp, "gaussian");
		connect( gaussian_pb, SIGNAL( clicked () ), this, SLOT( gaussian_event() ) );

		QPushButton* unsharp_pb = new QPushButton("Unsharp Mask", filter_grp, "unsharp");
		connect( unsharp_pb, SIGNAL( clicked () ), this, SLOT( unsharp_event() ) );
		
		QPushButton* sobel_pb = new QPushButton("Sobel Edge Detector", filter_grp, "sobel");
		connect( sobel_pb, SIGNAL( clicked () ), this, SLOT( sobel_event() ) );

	Q3BoxLayout *vboxlayoutRIGHT = new Q3BoxLayout ( 0, Q3BoxLayout::TopToBottom, 0, 5, "vboxlayout");
	vboxlayoutRIGHT->addWidget(toggle_grp, 0, Qt::AlignTop);
	vboxlayoutRIGHT->addWidget(filter_grp, 0, Qt::AlignTop);
/*
	Q3BoxLayout *vboxlayoutLEFT = new Q3BoxLayout ( 0, Q3BoxLayout::TopToBottom, 0, 5, "vboxlayout");
	vboxlayoutLEFT->setAlignment(Qt::AlignTop);
	vboxlayoutLEFT->addWidget(loadsave_grp, 0, Qt::AlignTop);
//	vboxlayoutLEFT->addWidget(reset_grp, 0, Qt::AlignTop);
*/
	Q3BoxLayout *topmost= new Q3BoxLayout ( this, Q3BoxLayout::LeftToRight, 10, 5, "topmost");
//	topmost->addLayout(vboxlayoutLEFT,1);
	topmost->addLayout(vboxlayoutRIGHT, 10);
}
void QtFilterWidget::gaussian_event(void)
{
	filter_selected=1;
    filter_dialogue = new QDialog(this, "Gaussian Smooth", 0);
	
	QValidator *int_validator = new QIntValidator(1, 32, this);
	QValidator *float_validator = new QDoubleValidator(0.0, 32.0, 2, this);

		Q3BoxLayout* filter_layout = new Q3BoxLayout(filter_dialogue, Q3BoxLayout::TopToBottom, 4, 4, "filter_layout");

			Q3ButtonGroup *dim_butgroup = new Q3ButtonGroup( 2, Qt::Horizontal, "", this);
			dim_butgroup->setExclusive(true);
			
				twod_pb = new QPushButton("2D", dim_butgroup, "ok");
				twod_pb->setToggleButton(true);
				twod_pb->setOn(false);
				
				threed_pb = new QPushButton("3D", dim_butgroup, "cancel");
				threed_pb->setToggleButton(true);
				threed_pb->setOn(true);

			Q3ButtonGroup *kernel_butgroup = new Q3ButtonGroup( 2, Qt::Horizontal, "", this);
			
				QLabel* kernel_size_lb = new QLabel("Kernel Width", kernel_butgroup);
				kernel_size_le = new QLineEdit("3", kernel_butgroup);
				kernel_size_le->setValidator(int_validator);

				QLabel* kernel_strength_lb = new QLabel("Kernel Strength", kernel_butgroup);
				kernel_strength_le = new QLineEdit("0.5", kernel_butgroup);
				kernel_strength_le->setValidator(float_validator);
				
			Q3ButtonGroup *okcancel_butgroup = new Q3ButtonGroup( 2, Qt::Horizontal, "", this);

				QPushButton* filterok_pb = new QPushButton("OK", okcancel_butgroup, "ok");
				connect( filterok_pb, SIGNAL( clicked () ), this, SLOT( filterok_event() ) );

				QPushButton* filtercancel_pb = new QPushButton("Cancel", okcancel_butgroup, "cancel");
				connect( filtercancel_pb, SIGNAL( clicked () ), this, SLOT( filtercancel_event() ) );
				
	filter_layout->addWidget(dim_butgroup);
	filter_layout->addWidget(kernel_butgroup);
	filter_layout->addWidget(okcancel_butgroup);	

	filter_dialogue->show();
}
void QtFilterWidget::median_event(void)
{
	filter_selected=2;
    filter_dialogue = new QDialog(this, "Median", 0);

	QValidator *int_validator = new QIntValidator(1, 32, this);
	QValidator *float_validator = new QDoubleValidator(0.0, 32.0, 2, this);
 
		Q3BoxLayout* filter_layout = new Q3BoxLayout(filter_dialogue, Q3BoxLayout::TopToBottom, 4, 4, "filter_layout");

			Q3ButtonGroup *dim_butgroup = new Q3ButtonGroup( 2, Qt::Horizontal, "", this);
			dim_butgroup->setExclusive(true);
			
				twod_pb = new QPushButton("2D", dim_butgroup, "ok");
				twod_pb->setToggleButton(true);
				twod_pb->setOn(false);
				
				threed_pb = new QPushButton("3D", dim_butgroup, "cancel");
				threed_pb->setToggleButton(true);
				threed_pb->setOn(true);

			Q3ButtonGroup *kernel_butgroup = new Q3ButtonGroup( 2, Qt::Horizontal, "", this);
			
				QLabel* kernel_size_lb = new QLabel("Kernel Width", kernel_butgroup);
				kernel_size_le = new QLineEdit("1", kernel_butgroup);
				kernel_size_le->setValidator(int_validator);
				
			Q3ButtonGroup *okcancel_butgroup = new Q3ButtonGroup( 2, Qt::Horizontal, "", this);

				QPushButton* filterok_pb = new QPushButton("OK", okcancel_butgroup, "ok");
				connect( filterok_pb, SIGNAL( clicked () ), this, SLOT( filterok_event() ) );

				QPushButton* filtercancel_pb = new QPushButton("Cancel", okcancel_butgroup, "cancel");
				connect( filtercancel_pb, SIGNAL( clicked () ), this, SLOT( filtercancel_event() ) );
				
	filter_layout->addWidget(dim_butgroup);
	filter_layout->addWidget(kernel_butgroup);
	filter_layout->addWidget(okcancel_butgroup);	

	filter_dialogue->show();
}
void QtFilterWidget::mean_event(void)
{
	filter_selected=4;
    filter_dialogue = new QDialog(this, "Median", 0);

	QValidator *int_validator = new QIntValidator(1, 32, this);
	QValidator *float_validator = new QDoubleValidator(0.0, 32.0, 2, this);
 
		Q3BoxLayout* filter_layout = new Q3BoxLayout(filter_dialogue, Q3BoxLayout::TopToBottom, 4, 4, "filter_layout");

			Q3ButtonGroup *dim_butgroup = new Q3ButtonGroup( 2, Qt::Horizontal, "", this);
			dim_butgroup->setExclusive(true);
			
				twod_pb = new QPushButton("2D", dim_butgroup, "ok");
				twod_pb->setToggleButton(true);
				twod_pb->setOn(false);
				
				threed_pb = new QPushButton("3D", dim_butgroup, "cancel");
				threed_pb->setToggleButton(true);
				threed_pb->setOn(true);

			Q3ButtonGroup *kernel_butgroup = new Q3ButtonGroup( 2, Qt::Horizontal, "", this);
			
				QLabel* kernel_size_lb = new QLabel("Kernel Width", kernel_butgroup);
				kernel_size_le = new QLineEdit("1", kernel_butgroup);
				kernel_size_le->setValidator(int_validator);
				
			Q3ButtonGroup *okcancel_butgroup = new Q3ButtonGroup( 2, Qt::Horizontal, "", this);

				QPushButton* filterok_pb = new QPushButton("OK", okcancel_butgroup, "ok");
				connect( filterok_pb, SIGNAL( clicked () ), this, SLOT( filterok_event() ) );

				QPushButton* filtercancel_pb = new QPushButton("Cancel", okcancel_butgroup, "cancel");
				connect( filtercancel_pb, SIGNAL( clicked () ), this, SLOT( filtercancel_event() ) );
				
	filter_layout->addWidget(dim_butgroup);
	filter_layout->addWidget(kernel_butgroup);
	filter_layout->addWidget(okcancel_butgroup);	

	filter_dialogue->show();
}
void QtFilterWidget::unsharp_event(void)
{
	filter_selected=3;
    filter_dialogue = new QDialog(this, "Unsharp Mask", 0);
	
	QValidator *int_validator = new QIntValidator(1, 32, this);
	QValidator *float_validator = new QDoubleValidator(0.0, 32.0, 2, this);

		Q3BoxLayout* filter_layout = new Q3BoxLayout(filter_dialogue, Q3BoxLayout::TopToBottom, 4, 4, "filter_layout");

			Q3ButtonGroup *dim_butgroup = new Q3ButtonGroup( 2, Qt::Horizontal, "", this);
			dim_butgroup->setExclusive(true);
			
				twod_pb = new QPushButton("2D", dim_butgroup, "ok");
				twod_pb->setToggleButton(true);
				twod_pb->setOn(false);
				
				threed_pb = new QPushButton("3D", dim_butgroup, "cancel");
				threed_pb->setToggleButton(true);
				threed_pb->setOn(true);

			Q3ButtonGroup *kernel_butgroup = new Q3ButtonGroup( 2, Qt::Horizontal, "", this);
			
				QLabel* kernel_size_lb = new QLabel("Kernel Width", kernel_butgroup);
				kernel_size_le = new QLineEdit("3", kernel_butgroup);
				kernel_size_le->setValidator(int_validator);
			
				QLabel* kernel_strength_lb = new QLabel("Kernel Strength", kernel_butgroup);
				kernel_strength_le = new QLineEdit("0.5", kernel_butgroup);
				kernel_strength_le->setValidator(float_validator);
				
			Q3ButtonGroup *okcancel_butgroup = new Q3ButtonGroup( 2, Qt::Horizontal, "", this);

				QPushButton* filterok_pb = new QPushButton("OK", okcancel_butgroup, "ok");
				connect( filterok_pb, SIGNAL( clicked () ), this, SLOT( filterok_event() ) );

				QPushButton* filtercancel_pb = new QPushButton("Cancel", okcancel_butgroup, "cancel");
				connect( filtercancel_pb, SIGNAL( clicked () ), this, SLOT( filtercancel_event() ) );
				
	filter_layout->addWidget(dim_butgroup);
	filter_layout->addWidget(kernel_butgroup);
	filter_layout->addWidget(okcancel_butgroup);	

	filter_dialogue->show();
}
void QtFilterWidget::filterok_event(void)
{
	filter_dialogue->close();

	int kernel_width;
	float kernel_strength;
	int dim_mode;
	
	if(twod_pb->isOn()) dim_mode = 0;
	else dim_mode = 1;
	
	QString txt;
	bool ok;
	
	txt = kernel_size_le->text();
	kernel_width = txt.toInt();
	
	if(filter_selected!=2 && filter_selected!=4)
	{
		txt = kernel_strength_le->text();
		kernel_strength = txt.toFloat();
	}
	
	printf("r: %d, g: %d, b: %d\n", (int)channels[0], (int)channels[1], (int)channels[2]);
	printf("filter_selected: %d\n", filter_selected);
	printf("dim_mode: %d\n", dim_mode);
	printf("kernel_width: %d\n", kernel_width);
	if(filter_selected!=2 && filter_selected!=4) printf("kernel_strength: %f\n", kernel_strength);

	emit filter_signal(filter_selected, kernel_width, kernel_strength, dim_mode, channels);
	
	delete filter_dialogue;
}
void QtFilterWidget::thresh_event(void)
{
	filter_selected=5;
	emit filter_signal(filter_selected, 0, 0, 0, channels);
}
void QtFilterWidget::binary_event(void)
{
	filter_selected=6;
	emit filter_signal(filter_selected, 0, 0, 0, channels);
}
void QtFilterWidget::sobel_event(void)
{
	filter_selected=7;
	emit filter_signal(filter_selected, 0, 0, 0, channels);
}
void QtFilterWidget::autolevels_event(void)
{
	filter_selected=8;
	emit filter_signal(filter_selected, 0, 0, 0, channels);
}
void QtFilterWidget::contraststretch_event(void)
{
	filter_selected=9;
	emit filter_signal(filter_selected, 0, 0, 0, channels);
}
void QtFilterWidget::filtercancel_event(void)
{
	filter_dialogue->close();
	delete filter_dialogue;
}
void QtFilterWidget::exit(void)
{
}
void QtFilterWidget::reset_button_event(void)
{
}
void QtFilterWidget::channel_button_event(int selected)
{
	if(selected==0)
	{
		channels[0] = true;
		channels[1] = false;
		channels[2] = false;
	}
	else if(selected==1)
	{
		channels[0] = false;
		channels[1] = true;
		channels[2] = false;
	}
	else if(selected==2)
	{
		channels[0] = false;
		channels[1] = false;
		channels[2] = true;
	}
}
void QtFilterWidget::load_event(void)
{
}
void QtFilterWidget::save_event(void)
{
}