#ifndef QTFILTER_H
#define QTFILTER_H

#include <qpainter.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qslider.h>
#include <qstring.h>
#include <qpushbutton.h> 
#include <qcombobox.h>
#include <qcheckbox.h>
#include <qspinbox.h>
#include <QDragEnterEvent>
#include <QDropEvent>
#include <qdir.h>
#include <QFileDialog>
#include <QDialog>
#include <QLineEdit>

#include <q3boxlayout.h>
#include <q3buttongroup.h>
#include <q3dragobject.h>

#include "QtGLObjWin.h"

class QtFilterWidget: public QWidget
{
	Q_OBJECT
		
public:

	QtFilterWidget(QWidget* parent = 0, const char* name = 0);
	~QtFilterWidget();

	QString currentworkingdir;
	
	int filter_selected;
	
	vector<bool> channels;
	
	QPushButton* red;
	QPushButton* green;
	QPushButton* blue;
	
	QPushButton* load_pb;
	QPushButton* save_pb;
	QPushButton* reset_pb;
	
	Q3ButtonGroup* filter_grp;

	QDialog* filter_dialogue;
	QPushButton* twod_pb;
	QPushButton* threed_pb;
	QLineEdit* kernel_size_le;
	QLineEdit* kernel_strength_le;
	
	void create(void);
	void exit(void);
	void reset(void);
	void rebuild(void);

private slots:

	void dragEnterEvent(QDragEnterEvent *event);
	void dropEvent(QDropEvent *event);
	void reset_button_event(void);
	void channel_button_event(int selected);
	void load_event(void);
	void save_event(void);

	void filterok_event(void);
	void filtercancel_event(void);

	void gaussian_event(void);
	void median_event(void);
	void unsharp_event(void);
	void mean_event(void);
	void thresh_event(void);
	void binary_event(void);
	void sobel_event(void);
	void autolevels_event(void);
	void contraststretch_event(void);

public slots:

	void dragndrop_slot(QString sFileName);
	
signals:
	void filter_signal(int filter_type, int size, double sigma, int dim, vector<bool> channels);

};

#endif // QTFILTER_H
