#include <qlayout.h>
#include <q3frame.h>
#include <qnamespace.h>
#include <qsplitter.h>
#include <qpushbutton.h>

#include "QtGLObjWin.h"
#include "QtGLWidget.h"

#include <QPixmap>
#include <QLabel>

QtGLObjectWindow::QtGLObjectWindow( QWidget* parent, const char* name )
    : QWidget( parent, name )
{
	//===================================================
	 //Qtframe to put our GLWidgets inside.
	QFrame* glvoxelframe;
	glvoxelframe = new QFrame( this, "glvoxelframe" );
	glvoxelframe->setFrameStyle( Q3Frame::Sunken | Q3Frame::Panel );
	glvoxelframe->setLineWidth( 1 );

	//===================================================
	// Create OpenGL widget and put it inside the fame

	QGLFormat glformat;
	glformat = QGLFormat(QGL::DoubleBuffer|QGL::DepthBuffer|QGL::AlphaChannel|QGL::DirectRendering);
//	glformat = QGLFormat(QGL::DoubleBuffer|QGL::DepthBuffer|QGL::AlphaChannel|QGL::DirectRendering|QGL::StereoBuffers);

	glvoxel	  = new QtGLWidget(glformat, glvoxelframe, "glvoxel", 0);

	QBoxLayout* flayout1 = new QBoxLayout( glvoxelframe, QBoxLayout::TopToBottom, 0, 0,"flayout1");
	flayout1->setMargin(0);
	flayout1->setSpacing(0);
	flayout1->addWidget( glvoxel);

	//===================================================
	// Put the GL widget and widgets inside a layout
	QBoxLayout* blayout_main = new QBoxLayout( QBoxLayout::TopToBottom, 1, "blayout_main");
  	blayout_main->setMargin(0);
	blayout_main->setSpacing(0);
	blayout_main->addWidget( glvoxelframe);
	blayout_main->setResizeMode(QLayout::FreeResize);

	//===================================================
	//	OUR 3 SLICE WIDGETS XY, XZ, YZ,
	//===================================================
	slice_arrayXY=0;
	slice_arrayXZ=0;
	slice_arrayYZ=0;

	//===================================================
	// XY SLICES
	//===================================================
    // XY PIXMAP LABEL
	xylb = new QtSliceFrame(this, "xylb");
	xylb->mode = 0;
	//===================================================
    // XY SLIDER
    slider_xy = new QSlider ( 0, 0, 1, 0, Qt::Vertical, this, "zsl" );
    slider_xy->setTickmarks( QSlider::Left );
	//slider_xy->setTracking(TRUE);
	//slider_xy->setStyle(new QMotifPlusStyle );
    connect( slider_xy, SIGNAL(valueChanged(int)), this, SLOT(makeXYPixmapEvent(int)) );
	//===================================================
    // XY SLIDER LABEL
 	slider_xy_lb = new QLabel( "   0", this );
	slider_xy_lb->setFont( QFont("System", 12 ) );
	//===================================================
	// XY SLIDER LAYOUT (XY SLIDER + XY SLIDER LABEL)
	QBoxLayout* slider_xy_layout = new QBoxLayout(QBoxLayout::TopToBottom, -1, "slider_xy_layout");
  	slider_xy_layout->setMargin(0);
	slider_xy_layout->setSpacing (5);
    slider_xy_layout->addWidget( slider_xy);
    slider_xy_layout->addWidget( slider_xy_lb);
	//===================================================
	// XY LAYOUT (XY LABEL + XY SLIDER + XY SLIDER LABEL)
	QBoxLayout * slicexy_layout = new QBoxLayout (QBoxLayout::LeftToRight, -1, "slicexy_layout");
  	slicexy_layout->setMargin(0);
	slicexy_layout->setSpacing (0);
    slicexy_layout->addWidget( xylb,5);
    slicexy_layout->addLayout( slider_xy_layout,1);
	//===================================================

	//===================================================
	// XZ SLICES
	//===================================================
    // XZ PIXMAP LABEL
	xzlb = new QtSliceFrame(this, "xzlb");
	xzlb->mode = 1;
	//===================================================
    // XZ SLIDER  
	slider_xz = new QSlider ( 0, 0, 1, 0, Qt::Vertical, this, "ysl" );
    slider_xz->setTickmarks( QSlider::Left );
	slider_xz->setTracking(TRUE);
    connect( slider_xz, SIGNAL(valueChanged(int)), this, SLOT(makeXZPixmapEvent(int)) );
	//===================================================
    // XZ SLIDER LABEL
	slider_xz_lb = new QLabel(this, "   0" );
	slider_xz_lb->setFont( QFont( "System", 12 ) );
	//===================================================
	// XZ SLIDER LAYOUT (XZ SLIDER + XZ SLIDER LABEL)
	QBoxLayout* slider_xz_layout = new QBoxLayout( QBoxLayout::TopToBottom, -1, "slider_xz_layout");
  	slider_xz_layout->setMargin(0);
	slider_xz_layout->setSpacing (5);
    slider_xz_layout->addWidget( slider_xz);
    slider_xz_layout->addWidget( slider_xz_lb);
	//===================================================
	// XZ LAYOUT (XZ LABEL + XZ SLIDER LAYOUT)
	QBoxLayout * slicexz_layout = new QBoxLayout (QBoxLayout::LeftToRight, -1, "slicexz_layout");
 	slicexz_layout->setMargin(0);
	slicexz_layout->setSpacing (0);
    slicexz_layout->addWidget( xzlb,5);
    slicexz_layout->addLayout( slider_xz_layout,1);
	
	//===================================================

	//===================================================
	// YZ SLICES
	//===================================================
	  // YZ PIXMAP LABEL
	yzlb = new QtSliceFrame(this, "yzlb");
	yzlb->mode = 2;
	//===================================================
    // YZ SLIDER
    slider_yz = new QSlider ( 0, 0, 1, 0, Qt::Vertical, this, "xsl" );
    slider_yz->setTickmarks( QSlider::Left );
	slider_yz->setTracking(TRUE);
	connect( slider_yz, SIGNAL(valueChanged(int)), this, SLOT(makeYZPixmapEvent(int)) );
	//===================================================
    // YZ SLIDER LABEL
	slider_yz_lb = new QLabel( "   0", this );
	slider_yz_lb->setFont( QFont( "System", 12 ) );
	//===================================================
	// YZ SLIDER LAYOUT (YZ SLIDER + YZ SLIDER LABEL)
	QBoxLayout* slider_yz_layout = new QBoxLayout( QBoxLayout::TopToBottom, -1, "slider_yz_layout");
 	slider_yz_layout->setMargin(0);
	slider_yz_layout->setSpacing (5);
    slider_yz_layout->addWidget( slider_yz);
    slider_yz_layout->addWidget( slider_yz_lb);
	//===================================================
	// YZ LAYOUT (YZ LABEL + YZ SLIDER LAYOUT)
	QBoxLayout * sliceyz_layout = new QBoxLayout (QBoxLayout::LeftToRight, -1, "sliceyz_layout");
	sliceyz_layout->setMargin(0);
	sliceyz_layout->setSpacing (0);
	sliceyz_layout->addWidget( yzlb,5);
    sliceyz_layout->addLayout( slider_yz_layout,1);
	//===================================================

	//===================================================
	// Now that we have all the widgets,  
	// put them into a nice layout
	//===================================================
	cursor_label = new QLabel( this, "cursor_label", Qt::Widget );
	cursor_label->setBackgroundColor(Qt::white);
	cursor_label->setAutoFillBackground(true);
	cursor_label->setAlignment(Qt::AlignVCenter | Qt::AlignRight);
	cursor_label->setMaximumHeight(32);
	cursor_label->setText("cursor: [x:0 y:0 z:0][r:0 g:0 b:0] ");
	
 	//===================================================
    // Put the slices on top of each other
	//===================================================
	QBoxLayout* slices_layout = new QBoxLayout(0, QBoxLayout::TopToBottom, 3, 0, "slices_layout");
	slices_layout->setMargin(0);
	slices_layout->setSpacing(0);
	slices_layout->addLayout( slicexy_layout, 1);
	slices_layout->addLayout( slicexz_layout, 1);
	slices_layout->addLayout( sliceyz_layout, 1);
	slices_layout->addWidget( cursor_label, 1);
	slices_layout->setSizeConstraint (QLayout::SetMinimumSize);

	//===================================================
	//voxel view + slice views
	//===================================================    
	// Top level layout, puts the sliders to the left of the frame/GL widget
    QBoxLayout * blayout = new QBoxLayout ( 0, QBoxLayout::LeftToRight, 0, 0, "blayout");
	blayout->setMargin(0);
	blayout->setSpacing (0);
	blayout->addLayout( blayout_main, 3);
	blayout->addLayout( slices_layout, 1);

	QLabel* logo_label = new QLabel( this, "logo", Qt::Widget );
	//logo_label->setBackgroundPixmap(QPixmap("icons/biooptonics_logo_start.png"));
	logo_label->setPixmap(QPixmap("Icons/biooptonics_logo.png"));
	logo_label->setMaximumHeight(QPixmap("Icons/biooptonics_logo.png").height());
	logo_label->setBackgroundColor(Qt::white);
	logo_label->setAutoFillBackground(true);
	logo_label->setAlignment(Qt::AlignRight);
    
	info_label = new QLabel( this, "info_label", Qt::Widget );
	info_label->setBackgroundColor(Qt::white);
	info_label->setAutoFillBackground(true);
	info_label->setAlignment(Qt::AlignLeft);
	info_label->setText("");
	info_label->setAlignment(Qt::AlignVCenter);

	QBoxLayout * blayout3 = new QBoxLayout ( 0, QBoxLayout::LeftToRight, 0, -1, "blayout3");
	blayout3->addWidget(info_label, 1);
	blayout3->addWidget(logo_label, 1);

	QBoxLayout * blayout2 = new QBoxLayout ( this, QBoxLayout::TopToBottom, 0, -1, "blayout2");
	blayout2->setMargin(5);
	blayout2->setSpacing (5);
	blayout2->addLayout(blayout, 10);
	blayout2->addLayout(blayout3, 1);

	sections_toggle=0;

	create();
}
QtGLObjectWindow::~QtGLObjectWindow()
{	
	glvoxel=NULL;

	//lets be clean
	destroy();
}
void QtGLObjectWindow::destroy(void)
{
//	xylb->slice_pixmap = new QPixmap(100, 100);
//	xylb->slice_pixmap->fill(Qt::black);

//	xzlb->slice_pixmap = new QPixmap(100, 100);
//	xzlb->slice_pixmap->fill(Qt::black);

//	yzlb->slice_pixmap = new QPixmap(100, 100);
//	yzlb->slice_pixmap->fill(Qt::black);

//	if(slice_arrayXY!=NULL) delete[] slice_arrayXY;
//	if(slice_arrayXZ!=NULL) delete[] slice_arrayXZ;
//	if(slice_arrayYZ!=NULL) delete[] slice_arrayYZ;
}
void QtGLObjectWindow::create(void)
{
//	printf("Trying to create slice frames!\n");
	
	if(glvoxel->volobject.texwidth&&glvoxel->volobject.texheight&&glvoxel->volobject.texdepth==1) return;
	if(glvoxel->volobject.texture3d==NULL) return;
	if(glvoxel->volrender.volume_render_mode==4) return;

//	printf("Creating slice frames!\n");
	
//	progressbar = new Q3ProgressDialog("Creating 2D Slices...", "Cancel", 4, 0, "progress", TRUE);		
//	progressbar->setCaption("Please Wait");
	
	//update our progress bar
//    progressbar->setProgress(1);

	//XY SLICE
	//======================================
	//create an array to store our XY slices
	if(slice_arrayXY) delete[] slice_arrayXY;
	slice_arrayXY = new unsigned char[4*glvoxel->volobject.texwidth*glvoxel->volobject.texheight];
	
	//set its slider according to what we have read in
	if(slider_xy)
	{
		slider_xy->setMaxValue(glvoxel->volobject.texdepth-1);
		slider_xy->setTickInterval(glvoxel->volobject.texdepth/8);
		slider_xy->setTracking(true);
		slider_xy->setValue(glvoxel->volobject.texdepth/2.0);
	}

	//let frame obj now about it
	//makeXYPixmapEvent(glvoxel->volobject.texdepth/2.0);
	glvoxel->volrender.z_slice = glvoxel->volobject.texdepth/2.0;
	xylb->z = glvoxel->volobject.texdepth/2.0;
	xzlb->z = glvoxel->volobject.texdepth/2.0;
	yzlb->z = glvoxel->volobject.texdepth/2.0;	
	makeXYPixmapEvent(xylb->z);

	//update our progress bar
//    progressbar->setProgress(2);

	//XZ SLICE
	//======================================
	//create an array to store our XY slices
	if(slice_arrayXZ) delete[] slice_arrayXZ;
	slice_arrayXZ = new unsigned char[4*glvoxel->volobject.texwidth*glvoxel->volobject.texdepth];
		
	//set its slider according to what we have read in
	if(slider_xz)
	{
		slider_xz->setMaxValue(glvoxel->volobject.texheight-1);
		slider_xz->setTickInterval(glvoxel->volobject.texheight/8);
		slider_xz->setTracking(true);
		slider_xz->setValue(glvoxel->volobject.texheight/2.0);
	}

	//let frame obj now about it
	//makeXZPixmapEvent((int)(glvoxel->volobject.texheight/2.0));
	glvoxel->volrender.y_slice = glvoxel->volobject.texheight/2.0;
	xylb->y = glvoxel->volobject.texheight/2.0;
	xzlb->y = glvoxel->volobject.texheight/2.0;
	yzlb->y = glvoxel->volobject.texheight/2.0;	
	makeXZPixmapEvent(xzlb->y );

	//update our progress bar
//    progressbar->setProgress(3);

	//YZ SLICE
	//======================================
	//create an array to store our XY slices
	if(slice_arrayYZ) delete[] slice_arrayYZ;
	slice_arrayYZ = new unsigned char[4*glvoxel->volobject.texheight*glvoxel->volobject.texdepth];
	
	//set its slider according to what we have read in
	if(slider_yz)
	{
		slider_yz->setMaxValue(glvoxel->volobject.texwidth-1);
		slider_yz->setTickInterval(glvoxel->volobject.texwidth/8);
		slider_yz->setTracking(true);
		slider_yz->setValue(glvoxel->volobject.texwidth/2.0);
	}

	//let frame obj now about it
	//makeYZPixmapEvent((int)(glvoxel->volobject.texwidth/2.0));	
	glvoxel->volrender.x_slice = glvoxel->volobject.texwidth/2.0;
	xylb->x = glvoxel->volobject.texwidth/2.0;
	xzlb->x = glvoxel->volobject.texwidth/2.0;
	yzlb->x = glvoxel->volobject.texwidth/2.0;	
	makeYZPixmapEvent(yzlb->x );

	xylb->update();
	xzlb->update();
	yzlb->update();

	//update our progress bar
/*    progressbar->setProgress(4);
	delete progressbar;
	progressbar=NULL;*/
}
void QtGLObjectWindow::save_sectionimage_slot(QString fn, int axis, int index)
{
	if(axis==0)
	{
		makeYZPixmapEvent(index);		
		if(!yzlb->slice_pixmap->isNull()) yzlb->slice_pixmap->save(fn, "PNG");
	}
	if(axis==1)
	{
		makeXZPixmapEvent(index);		
		if(!xzlb->slice_pixmap->isNull()) xzlb->slice_pixmap->save(fn, "PNG");
	}
	if(axis==2)
	{
		makeXYPixmapEvent(index);		
		if(!xylb->slice_pixmap->isNull()) xylb->slice_pixmap->save(fn, "PNG");
	}
}
void QtGLObjectWindow::makeXYPixmapEvent(int z)
{ 
	//check we have some data
	if(glvoxel->volobject.texwidth==1 || glvoxel->volobject.texheight==1 || glvoxel->volobject.texdepth==1) return;
	if(z>glvoxel->volobject.texdepth-1) return;
	if(glvoxel->volobject.texture3d==NULL) return;

	//index helpers
	int index_2D;
	int index_3D;

	//save the slice #
	glvoxel->volrender.z_slice = z;
	xylb->z = z;
	xzlb->z = z;
	yzlb->z = z;
	
	int r,g,b;
	int result_r, result_g, result_b;
	
	//get the slice the user has asked for
	for(int x=0; x<glvoxel->volobject.texwidth; x++)
	{
		for(int y=0; y<glvoxel->volobject.texheight; y++)
		{
			index_2D = 4*((y*glvoxel->volobject.texwidth)+x);
			index_3D = 3*((((z*glvoxel->volobject.texheight)+y)*glvoxel->volobject.texwidth)+x);

			result_r = r = glvoxel->volobject.texture3d[index_3D+0];
			result_g = g = glvoxel->volobject.texture3d[index_3D+1];
			result_b = b = glvoxel->volobject.texture3d[index_3D+2];		
	
			if(glvoxel->volobject.has_red==false) result_r=0;
			if(glvoxel->volobject.has_green==false) result_g=0;
			if(glvoxel->volobject.has_blue==false)  result_b=0;
			if(glvoxel->volobject.is_greyscale==true) result_g=result_b=result_r;

			if(glvoxel->volobject.is16bit)
			{
				result_r = result_b = result_g;
			}
			
 			slice_arrayXY[index_2D+0] = (unsigned char) result_r;//glvoxel->volrender.rgb_tfunc[3*glvoxel->volobject.texture3d[index_3D+0]+0];
			slice_arrayXY[index_2D+1] = (unsigned char) result_g;//glvoxel->volrender.rgb_tfunc[3*glvoxel->volobject.texture3d[index_3D+1]+1];
			slice_arrayXY[index_2D+2] = (unsigned char) result_b;//glvoxel->volrender.rgb_tfunc[3*glvoxel->volobject.texture3d[index_3D+2]+2];
			slice_arrayXY[index_2D+3] = (unsigned char) 255;//(result_r+result_g+result_b)/3.0;
		}
	}
	
	//if(glvoxel->volrender.slice_draw_mode==2)
	{
		//upload our slice to gfx card
		glBindTexture (GL_TEXTURE_2D, glvoxel->volrender.SLICEZ); 
		glPixelStorei (GL_UNPACK_ALIGNMENT, 1);
		glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR_MIPMAP_LINEAR);
		glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_LINEAR);
		glTexEnvf (GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
		glTexImage2D (GL_TEXTURE_2D, 0, GL_RGBA, glvoxel->volobject.texwidth, glvoxel->volobject.texheight, 0, GL_RGBA, GL_UNSIGNED_BYTE, (GLvoid*)slice_arrayXY);
		gluBuild2DMipmaps(GL_TEXTURE_2D, GL_RGBA, glvoxel->volobject.texwidth, glvoxel->volobject.texheight, GL_RGBA, GL_UNSIGNED_BYTE, (GLvoid*)slice_arrayXY); 
	}
	//create a QImage using our RAW RGB data
	QImage xy_image = QImage(slice_arrayXY, glvoxel->volobject.texwidth, glvoxel->volobject.texheight, 32, 0, 256, QImage::LittleEndian );
	xy_image.setAlphaBuffer(false);

	//create a QPixmap using our QImage
	xy_pixmap.convertFromImage(xy_image.swapRGB());

	//if we are successful update the label
    if ( !xy_pixmap.isNull() ) 
	{ 
		xylb->slice_pixmap = &xy_pixmap;
		xylb->setPixmap( xy_pixmap );
		//xylb->update();
		xzlb->update();
		yzlb->update();
    }
	//else display an error message in the frame
    else 
	{
		xylb->setText( "ERROR: makeXYPixmap()" );
    }
	
	//Our slider label value
	//We need to make sure our label is always same size
	//or our window will reshape due to new size...
	QString s;
	if(z<9)
	{
		QString n;
		n.setNum(z);

		s = "    ";
		s += n;
	}
	else if(z<99)
	{
		QString n;
		n.setNum(z);

		s = "  ";
		s += n;
	}
	else
	{
		s.setNum(z);
	}


	slider_xy_lb->setText(s);

	//xy_image.reset();
}
void QtGLObjectWindow::makeXZPixmapEvent(int y)
{
	//check we have some data
	if(glvoxel->volobject.texwidth==1 || glvoxel->volobject.texheight==1 || glvoxel->volobject.texdepth==1) return;
	if(y>glvoxel->volobject.texheight-1) return;
	if(glvoxel->volobject.texture3d==NULL) return;

	//index helpers
	int index_2D;
	int index_3D;

	//save the slice #
	glvoxel->volrender.y_slice = y;
	xylb->y = y;
	xzlb->y = y;
	yzlb->y = y;

	int r,g,b;
	int result_r, result_g, result_b;
	//get the slice the user has asked for
	for(int x=0; x<glvoxel->volobject.texwidth; x++)
	{
		for(int z=0; z<glvoxel->volobject.texdepth; z++)
		{
			index_2D = 4*((z*glvoxel->volobject.texwidth)+x);
			index_3D = 3*((((z*glvoxel->volobject.texheight)+y)*glvoxel->volobject.texwidth)+x);
		
			result_r = r = glvoxel->volobject.texture3d[index_3D+0];
			result_g = g = glvoxel->volobject.texture3d[index_3D+1];
			result_b = b = glvoxel->volobject.texture3d[index_3D+2];

			if(glvoxel->volobject.has_red==false) result_r=0;
			if(glvoxel->volobject.has_green==false) result_g=0;
			if(glvoxel->volobject.has_blue==false)  result_b=0;
			if(glvoxel->volobject.is_greyscale==true) result_g=result_b=result_r;

			if(glvoxel->volobject.is16bit)
			{
				result_r = result_b = result_g;
			}
			
			slice_arrayXZ[index_2D+0] = result_r;//(unsigned char) glvoxel->volrender.rgb_tfunc[3*glvoxel->volobject.texture3d[index_3D+0]+0];
			slice_arrayXZ[index_2D+1] = result_g;//(unsigned char) glvoxel->volrender.rgb_tfunc[3*glvoxel->volobject.texture3d[index_3D+1]+1];
			slice_arrayXZ[index_2D+2] = result_b;//(unsigned char) glvoxel->volrender.rgb_tfunc[3*glvoxel->volobject.texture3d[index_3D+2]+2];
			slice_arrayXZ[index_2D+3] = 255;//(result_r+result_g+result_b)/3.0;
		}
	}

	//if(glvoxel->volrender.slice_draw_mode==2)
	{
		//upload our slice to gfx card
		glBindTexture (GL_TEXTURE_2D, glvoxel->volrender.SLICEY); 
		glPixelStorei (GL_UNPACK_ALIGNMENT, 1);
		glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR_MIPMAP_LINEAR);
		glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_LINEAR);
		glTexEnvf (GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
		glTexImage2D (GL_TEXTURE_2D, 0, GL_RGBA, glvoxel->volobject.texwidth, glvoxel->volobject.texdepth, 0, GL_RGBA, GL_UNSIGNED_BYTE, (GLvoid*)slice_arrayXZ);
		gluBuild2DMipmaps(GL_TEXTURE_2D, GL_RGBA, glvoxel->volobject.texwidth, glvoxel->volobject.texdepth, GL_RGBA, GL_UNSIGNED_BYTE, (GLvoid*)slice_arrayXZ); 
	}

	//create a QImage using our RAW RGB data
	QImage xz_image = QImage(slice_arrayXZ, glvoxel->volobject.texwidth, glvoxel->volobject.texdepth, 32, 0, 256, QImage::LittleEndian );
	xz_image.setAlphaBuffer(false);
	
	//create a QPixmap using our QImage
	xz_pixmap.convertFromImage(xz_image.swapRGB());

	//if we are successful update the label
	if ( !xz_pixmap.isNull() ) 
	{
		xzlb->slice_pixmap = &xz_pixmap; 
		xzlb->setPixmap( xz_pixmap );
		//xzlb->update();
		xylb->update();
		yzlb->update();
	}
 	//else display an error message in the frame
	else 
	{
		xzlb->setText( "ERROR: makeXZPixmap()" );
	}

	//Our slider label value
	//We need to make sure our label is always same size
	//or our window will reshape due to new size...
	QString s;
	if(y<9)
	{
		QString n;
		n.setNum(y);

		s = "    ";
		s += n;
	}
	else if(y<99)
	{
		QString n; 
		n.setNum(y);

		s = "  ";
		s += n;
	}
	else
	{
		s.setNum(y);
	}
	slider_xz_lb->setText(s);

	//xz_image.reset();
}
void QtGLObjectWindow::makeYZPixmapEvent(int x)
{
	//check we have some data
	if(glvoxel->volobject.texwidth==1 || glvoxel->volobject.texheight==1 || glvoxel->volobject.texdepth==1) return;
	if(x>glvoxel->volobject.texwidth-1) return;
	if(glvoxel->volobject.texture3d==NULL) return;

	//index helpers
	int index_2D;
	int index_3D;

	//save the slice #
	glvoxel->volrender.x_slice = x;
	xylb->x = x;
	xzlb->x = x;
	yzlb->x = x;

	int r,g,b;
	int result_r, result_g, result_b;
	//get the slice the user has asked for
	for(int y=0; y<glvoxel->volobject.texheight; y++)
	{
		for(int z=0; z<glvoxel->volobject.texdepth; z++)
		{
			index_2D = 4*((z*glvoxel->volobject.texheight)+y);
			index_3D = 3*((((z*glvoxel->volobject.texheight)+y)*glvoxel->volobject.texwidth)+x);

			result_r = r = glvoxel->volobject.texture3d[index_3D+0];
			result_g = g = glvoxel->volobject.texture3d[index_3D+1];
			result_b = b = glvoxel->volobject.texture3d[index_3D+2];

			if(glvoxel->volobject.has_red==false) result_r=0;
			if(glvoxel->volobject.has_green==false) result_g=0;
			if(glvoxel->volobject.has_blue==false)  result_b=0;
			if(glvoxel->volobject.is_greyscale==true) result_g=result_b=result_r;

			if(glvoxel->volobject.is16bit)
			{
				result_r = result_b = result_g;
			}
			
			slice_arrayYZ[index_2D+0] = (unsigned char) result_r;//glvoxel->volrender.rgb_tfunc[3*glvoxel->volobject.texture3d[index_3D+0]+0];
			slice_arrayYZ[index_2D+1] = (unsigned char) result_g;//glvoxel->volrender.rgb_tfunc[3*glvoxel->volobject.texture3d[index_3D+1]+1];
			slice_arrayYZ[index_2D+2] = (unsigned char) result_b;//glvoxel->volrender.rgb_tfunc[3*glvoxel->volobject.texture3d[index_3D+2]+2];
			slice_arrayYZ[index_2D+3] = (unsigned char) 255;//(result_r+result_g+result_b)/3.0;
		}
	}

	//if(glvoxel->volrender.slice_draw_mode==2)
	{
		//upload our slice to gfx card
		glBindTexture (GL_TEXTURE_2D, glvoxel->volrender.SLICEX); 
		glPixelStorei (GL_UNPACK_ALIGNMENT, 1);
		glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR_MIPMAP_LINEAR);
		glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_LINEAR);
		glTexEnvf (GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
		glTexImage2D (GL_TEXTURE_2D, 0, GL_RGBA, glvoxel->volobject.texheight, glvoxel->volobject.texdepth, 0, GL_RGBA, GL_UNSIGNED_BYTE, (GLvoid*)slice_arrayYZ);
		gluBuild2DMipmaps(GL_TEXTURE_2D, GL_RGBA, glvoxel->volobject.texheight, glvoxel->volobject.texdepth, GL_RGBA, GL_UNSIGNED_BYTE, (GLvoid*)slice_arrayYZ); 
	}

	//create a QImage using our RAW RGB data
	QImage yz_image = QImage(slice_arrayYZ, glvoxel->volobject.texheight, glvoxel->volobject.texdepth, 32, 0, 256, QImage::LittleEndian );
	yz_image.setAlphaBuffer(false);

	//create a QPixmap using our QImage
	yz_pixmap.convertFromImage(yz_image.swapRGB());

	//if we are successful update the label
    if ( !yz_pixmap.isNull() ) 
	{
		yzlb->slice_pixmap = &yz_pixmap; 
		yzlb->setPixmap( yz_pixmap );
		//yzlb->update();
		xylb->update();
		xzlb->update();
   }
 	//else display an error message in the frame
    else 
	{
		yzlb->setText( "ERROR: makeYZPixmap()" );
    }

	//Our slider label value
	//We need to make sure our label is always same size
	//or our window will reshape due to new size...
	QString s;
	if(x<9)
	{
		QString n;
		n.setNum(x);

		s = "    ";
		s += n;
	}
	else if(x<99)
	{
		QString n;
		n.setNum(x);

		s = "  ";
		s += n;
	}
	else
	{
		s.setNum(x);
	}

	slider_yz_lb->setText(s);

	//yz_image.reset();
}
void QtGLObjectWindow::saveimageEvent(QString filename, int mode)
{
	//check we have some data
	if(glvoxel->volobject.texwidth==1 || glvoxel->volobject.texheight==1 || glvoxel->volobject.texdepth==1) return;

	if(filename[int(filename.length()-4)]!='.') filename += ".png";
	
	if(mode==1)
	{
		//save our rendering window
		QImage im = glvoxel->volrender.render_framebuffer(false);
		QPixmap pm;
		pm.convertFromImage(im);
		im.reset();

		if(!pm.isNull()) pm.save(filename, "PNG");
	}
	else if(mode==2)
	{
		//save XY slice
		if(!xy_pixmap.isNull()) xy_pixmap.save( filename, "PNG" );
	}
	else if(mode==3)
	{
		//save XZ slice
		if(!xz_pixmap.isNull()) xz_pixmap.save( filename, "PNG" );
	}
	else if(mode==4)
	{
		//save YZ slice
		if(!yz_pixmap.isNull()) yz_pixmap.save( filename, "PNG" );
	}
	else
	{
		return;
	}
}
void QtGLObjectWindow::frames_redraw_slot(void)
{	
	//check we have some data
	if(glvoxel->volobject.texwidth==1 || glvoxel->volobject.texheight==1 || glvoxel->volobject.texdepth==1) return;

	makeXZPixmapEvent(glvoxel->volrender.y_slice);
	makeXYPixmapEvent(glvoxel->volrender.z_slice);
	makeYZPixmapEvent(glvoxel->volrender.x_slice);
//	glvoxel->redraw_event();

/*	//=============================================================
	//update histogram
	//=============================================================
	int histogram[256];
	int numb_voxels = glvoxel->volobject.texwidth*glvoxel->volobject.texheight*glvoxel->volobject.texdepth;

	//build histogram
	int i;
	for(i=0; i<256; i++)
	{
		histogram[i]=0;
	}
	for(i=0; i<numb_voxels; i++)
	{
		int val = glvoxel->volobject.texture3d[3*i+3];

		if(val>255) val = 255;
		if(val<0) val = 0;

		histogram[val]++;
	}

	emit histogram_signal(&histogram[0]);*/
}
