#include "QtGLWidget.h"
//Added by qt3to4:
#include <Q3StrList>
#include <QPixmap>
#include <QMouseEvent>
#include <QDragEnterEvent>
#include <QKeyEvent>
#include <QDropEvent>
#include "Constant.h"

QtGLWidget::QtGLWidget( QWidget* parent, const char* name, const QGLWidget* shareWidget )
    : QGLWidget( parent, name, shareWidget )
{
    startTimer( timer_interval );
	setMouseTracking (true );
	setAcceptDrops(true);
	setAutoFillBackground(false);
	argc_mode=0;
//	grabKeyboard();

/*	QSizePolicy sp = QSizePolicy(QSizePolicy::Expanding, QSizePolicy::Expanding, false);
	sp.setHeightForWidth(true);
	setSizePolicy(sp);*/
}
QtGLWidget::QtGLWidget( const QGLFormat& format, QWidget* parent, const char* name, 
	      const QGLWidget* shareWidget )
    : QGLWidget( format, parent, name, shareWidget )
{
    startTimer( timer_interval );
	setMouseTracking (true );
	setAcceptDrops(true);
	setAutoFillBackground(false);
	argc_mode=0;
//	grabKeyboard();

/*	QSizePolicy sp = QSizePolicy(QSizePolicy::Expanding, QSizePolicy::Expanding, false);
	sp.setHeightForWidth(true);
	setSizePolicy(sp);*/
}
QtGLWidget::~QtGLWidget()
{
	app=NULL;
}

//===========================================================================================================

void QtGLWidget::initvariables()
{
	active = OBJ_ANGLE;
	planes_toggle = 0;

/*	OPT_objective = 0.0;
	OPT_magnification = 0.0;
	OPT_voxelspermicron = 6.629355427;
*/
	volio.volobj = volrender.volobj = &volobject;
	volrender.volio = &volio;
	
	dw = 1.0;
	
	render = 1;
	
	currentworkingdir = "";

	serifFontBG = QFont("Arial", 18, QFont::Bold);
	serifFont = QFont("Arial", 16, QFont::Bold);
	serifFontLabel = QFont("Arial", 10, QFont::Bold);
}
void QtGLWidget::initializeGL()
{
/*	QGLFormat fmt;
	fmt.setDoubleBuffer(true);
	fmt.setStereo(false);
	fmt.setDirectRendering(true);
	fmt.setDepth(true);
	fmt.setAlpha(true);

	QGLFormat::setDefaultFormat(fmt);
*/	
	//setAutoBufferSwap(true);
	//setDoubleBuffer(true);
	
	initvariables();

	volrender.initializeGL();

	if(argc_mode==1)
	{
		argc_mode=0;
		emit arc_mode_signal();
	}
}
void QtGLWidget::redraw_event(void)
{	
	//printf("Redraw Event\n");
	render=1;

	//makeOverlayCurrent();
	updateGL();
	update();
	
	render=0;
}
void QtGLWidget::resizeGL( int w, int h )
{
	int maxsize=0;
	if(maxsize<w) maxsize = w;
	if(maxsize<h) maxsize = h;

	volrender.resizeGL(w,h);

	//makeOverlayCurrent();
	//updateGL();
	
 	redraw_event();
}
void QtGLWidget::paintGL()
{	
	//glClear( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT );
	//if(render)
	{
		volrender.displayGL(render);

		//now render some 2D UI non FBO stuff.
		glPushMatrix();

			glMatrixMode(GL_PROJECTION);
			glLoadIdentity();
			
			//glOrtho(-volobject.maxres-volrender.zoom, volobject.maxres+volrender.zoom, -volobject.maxres-volrender.zoom, volobject.maxres+volrender.zoom, -1024, 1024);
			glOrtho(-volobject.maxres, volobject.maxres, -volobject.maxres, volobject.maxres, -1024, 1024);

			glMatrixMode(GL_MODELVIEW);
			glLoadIdentity();

			//glEnable(GL_BLEND);
			glDisable(GL_LIGHTING);

				if(volrender.scalebar_toggle)
				{
					glColor3f(volrender.background_fontcolour.red()/255.0, volrender.background_fontcolour.blue()/255.0, volrender.background_fontcolour.green()/255.0);
					volrender.render_scalebar();
				}

				QFontMetrics fmetric = QFontMetrics(serifFontBG);
				QPainter painter(this);
	
				if(volrender.fps_toggle)
				{
					QString fps;
					fps.setNum(volrender.timer.fps, 'g', 2);
					fps = "FPS: " + fps;
					
					//glColor3f(volrender.background_fontcolour.red()/255.0, volrender.background_fontcolour.blue()/255.0, volrender.background_fontcolour.green()/255.0);
					//renderText(14,28, fps.latin1(), serifFontBG);
					
					painter.setPen(volrender.background_fontcolour) ;
					painter.setFont(serifFontBG);
					QRect rect = fmetric.boundingRect(fps);
					painter.translate(24-rect.width()*0.125, 38-rect.height()*0.125);
					rect.setWidth(rect.width()*1.25);
					rect.setHeight(rect.height()*1.25);
					painter.drawRect(rect);
					//painter.drawRoundedRect(rect, 16, 16);
					volrender.background_fontcolour.setAlpha(32);
					painter.fillRect(rect, volrender.background_fontcolour);
					volrender.background_fontcolour.setAlpha(255);
					painter.resetTransform();
					painter.drawText(QPoint(24, 38), fps);
				}
				
				if(volrender.scalebar_toggle)
				{
					painter.setPen(volrender.background_fontcolour);
					painter.setFont(serifFontBG);
					painter.drawText(QPoint(volrender.scalebarfontpos.x,volrender.scalebarfontpos.y), volrender.scalebartext);
					//renderText((int)volrender.scalebarfontpos.x, (int)volrender.scalebarfontpos.y, volrender.scalebartext.latin1(), serifFontBG);
				}
				
				if(volobject.texture3d!=NULL && volrender.measure_vertlabel==1)
				{

					QString numb;
					for(int i=0; i<volrender.current_measure_points.size(); i++)
					{
						double dpX, dpY, dpZ, rZ;
						Vector v0 = volrender.current_measure_points[i];
						//printf("v0: %f, %f, %f\n", v0.x, v0.y, v0.z);
						
						//project our 3d coord to 2d screen space
						//glPushMatrix();
						//glMatrixMode(GL_PROJECTION);
						//glLoadIdentity(); // Reset The Projection Matrix
						gluProject((double)v0.x,(double)v0.y, (double)v0.z, volrender.mvmatrix, volrender.projmatrix, volrender.viewport, &dpX, &dpY, &dpZ);
						//glPopMatrix();
						
						double offset = volrender.winWidth-volrender.winHeight;
						offset /= 2.0;
						dpY = volrender.winWidth-(dpY+offset);

						//printf("screenspace: %f, %f %f\n", dpX, dpY, dpZ);

						Vector texcoord;
						texcoord.x = (((double)(dpX)/(double)volrender.winWidth))*(double)volrender.FBO_SIZE;
						texcoord.y = (((double)(dpY)/(double)volrender.winWidth))*(double)volrender.FBO_SIZE;
						if(texcoord.x>volrender.FBO_SIZE-1) texcoord.x=volrender.FBO_SIZE-1;
						if(texcoord.y>volrender.FBO_SIZE-1) texcoord.y=volrender.FBO_SIZE-1;
						if(texcoord.x<0.0) texcoord.x=0.0;
						if(texcoord.y<0.0) texcoord.y=0.0;
						rZ = volrender.depthdata[(int)(texcoord.x+0.5)+(volrender.FBO_SIZE*(int)(texcoord.y+0.5))];
						rZ /= 4294967296.0;
						
						//printf("rZ: %f\n", rZ);
						//dpY = volrender.winWidth+(dpY-offset);
						//dpY = volrender.winWidth-(dpY+offset);

						//double oX, oY, oZ;
						//gluUnProject((double)dpX, (double)dpY, (double)dpZ, volrender.mvmatrix, volrender.projmatrix, volrender.viewport, &oX, &oY, &oZ);
						//printf("v1: %f, %f, %f\n", oX, oY, oZ);

						//dZ = rZ;
						//now perform our z cull
						dpZ -= 0.005;
						//printf("index: %d texcoord: %f, %f\n", i, texcoord.x, texcoord.y);
						//printf("index: %d dZ: %f, rZ: %f\n", i, (double)dpZ, (double)rZ);
						
						//if(dpZ<rZ)
						{

							numb.setNum(i+1);
							QString txt = "p"+numb;
							
							fmetric = QFontMetrics(serifFontLabel);

							painter.setPen(Qt::yellow);
							painter.setFont(serifFontLabel);

							QRect rect = fmetric.boundingRect(txt);
							painter.translate(dpX-((rect.width()*0.125)), dpY-((rect.height()*0.125)));
							rect.setWidth(rect.width()*1.25);
							rect.setHeight(rect.height()*1.25);
							//painter.drawRect(rect);
							//volrender.background_colour.setAlpha(32);
							//painter.fillRect(rect, volrender.background_colour);
							//volrender.background_colour.setAlpha(255);
							painter.resetTransform();
							painter.drawText(QPoint(dpX, dpY), txt);
						}
					}
				}
				if(volobject.texture3d!=NULL && volrender.measure_lengthlabel==1)
				{
					QString numb;
					for(int i=0; i<volrender.current_edges.size(); i++)
					{
						Vector v1 = volrender.current_measure_points[volrender.current_edges[i].v0];
						Vector v2 = volrender.current_measure_points[volrender.current_edges[i].v1];
						Vector v3 = v2;
						Vector v4 = v1-(v1+Vector(0,10,0));

						Vector v5 = v2-v1;
						float l = v5.length();

						Vector pos = (v1+v2)/2.0f;

						double dpX, dpY, dpZ, rZ;
						gluProject((double)pos.x,(double)pos.y, (double)pos.z, volrender.mvmatrix, volrender.projmatrix, volrender.viewport, &dpX, &dpY, &dpZ);					
						double offset = volrender.winWidth-volrender.winHeight;
						offset /= 2.0;
						dpY = volrender.winWidth-(dpY+offset);

						double d0X, d0Y, d0Z;
						gluProject((double)v3.x,(double)v3.y, (double)v3.z, volrender.mvmatrix, volrender.projmatrix, volrender.viewport, &d0X, &d0Y, &d0Z);					
						d0Y = volrender.winWidth-(d0Y+offset);

						double d1X, d1Y, d1Z;
						gluProject((double)v4.x,(double)v4.y, (double)v4.z, volrender.mvmatrix, volrender.projmatrix, volrender.viewport, &d1X, &d1Y, &d1Z);					
						d1Y = volrender.winWidth-(d1Y+offset);

						v3 = Vector(d0X, d0Y, 0.0);
						v4 = Vector(d1X, d1Y, 0.0);

						//printf("d: %f, %f %f\n", dpX, dpY, dpZ);
						//printf("d0: %f, %f %f\n", d0X, d0Y, d0Z);
						//printf("d1: %f, %f %f\n", d1X, d1Y, d1Z);

						numb.setNum(l, 'f', 2);
									
						fmetric = QFontMetrics(serifFontLabel);
						QRect rect = fmetric.boundingRect(numb);
						painter.setFont(serifFontLabel);
						painter.setPen(Qt::red);

						Vector vi = Vector(dpX, dpY, 0)-Vector(d0X, d0Y, 0);
						Vector vj = Vector(dpX, dpY, 0)-Vector(dpX+64, dpY, 0);

						float perpdot = vi.x*vj.y-vi.y*vj.x;
						float dot = vi.x*vj.x-vi.y*vj.y;
						float angs = atan2(perpdot, dot)* (180.0/PI);


						painter.translate(dpX, dpY);
						painter.rotate(-angs);

						//rect.setWidth(rect.width());
						//rect.setHeight(rect.height());
						//rect.translate(-rect.width()*0.5, 0.0);
						//volrender.background_colour.setAlpha(32);
						//painter.fillRect(rect, volrender.background_colour);
						//volrender.background_colour.setAlpha(255);
						painter.drawText(QPoint(-rect.width()*0.5, -rect.height()*0.5), numb);
						painter.resetTransform();											
					}
				}
				if(volobject.texture3d!=NULL && volrender.measure_anglelabel==1)
				{
					QString numb;
					for(int i=0; i<volrender.current_edges.size(); i++)
					{
						int vi_index1 = volrender.current_edges[i].v0;
						int vi_index2 = volrender.current_edges[i].v1;

						Vector vi1 = volrender.current_measure_points[vi_index1];
						Vector vi2 = volrender.current_measure_points[vi_index2];
						Vector vi3 = vi1-vi2;

						for(int j=0; j<volrender.current_edges.size(); j++)
						{
							int vj_index1 = volrender.current_edges[j].v0;
							int vj_index2 = volrender.current_edges[j].v1;

							if(vi_index1==vj_index2)
							{
								Vector vj1 = volrender.current_measure_points[vj_index1];
								Vector vj2 = volrender.current_measure_points[vj_index2];
								Vector vj3 = vj1-vj2;

								Vector norm;
								norm.get_normal(vi1, vi2, vj1);
								float angle = vi3.signed_angle(vj3, norm) * (180.0/PI);

								Vector pos = (vi1+vi2+vj1+vj2)*0.25f;
								double dpX, dpY, dpZ, rZ;
								gluProject((double)pos.x,(double)pos.y, (double)pos.z, volrender.mvmatrix, volrender.projmatrix, volrender.viewport, &dpX, &dpY, &dpZ);					
								double offset = volrender.winWidth-volrender.winHeight;
								offset /= 2.0;
								dpY = volrender.winWidth-(dpY+offset);

								if(angle<0) angle = -angle;

								if(angle!=0)
								{
									numb.setNum(angle, 'f', 2);
								//	renderText(dX, dY, numb, serifFontLabel);

									fmetric = QFontMetrics(serifFontLabel);

									painter.setPen(Qt::green);
									painter.setFont(serifFontLabel);

									QRect rect = fmetric.boundingRect(numb);
									painter.translate(dpX-((rect.width()*0.125)), dpY-((rect.height()*0.125)));
									rect.setWidth(rect.width()*1.25);
									rect.setHeight(rect.height()*1.25);
									//painter.drawRect(rect);
									volrender.background_colour.setAlpha(32);
									painter.fillRect(rect, volrender.background_colour);
									volrender.background_colour.setAlpha(255);
									painter.resetTransform();
									painter.drawText(QPoint(dpX, dpY), numb);
									
								}
							}
							else if(vi_index1==vj_index1)
							{
								Vector vj1 = volrender.current_measure_points[vj_index1];
								Vector vj2 = volrender.current_measure_points[vj_index2];
								Vector vj3 = vj1-vj2;

								Vector norm;
								norm.get_normal(vi1, vi2, vj2);
								float angle = vi3.signed_angle(vj3, norm) * (180.0/PI);

								Vector pos = (vi1+vi2+vj1+vj2)*0.25f;
								double dX, dY, dZ, rZ;
								gluProject((double)pos.x,(double)pos.y, (double)pos.z, volrender.mvmatrix, volrender.projmatrix, volrender.viewport, &dX, &dY, &dZ);					
								double offset = volrender.winWidth-volrender.winHeight;
								offset /= 2.0;
								dY = volrender.winWidth-(dY+offset);

								if(angle<0) angle = -angle;

								if(angle!=0)
								{
									numb.setNum(angle, 'f', 2);
								//	renderText(dX, dY, numb, serifFontLabel);

									fmetric = QFontMetrics(serifFontLabel);

									painter.setPen(Qt::green);
									painter.setFont(serifFontLabel);

									QRect rect = fmetric.boundingRect(numb);
									painter.translate(dX-((rect.width()*0.125)), dY-((rect.height()*0.125)));
									rect.setWidth(rect.width()*1.25);
									rect.setHeight(rect.height()*1.25);
									//painter.drawRect(rect);
									volrender.background_colour.setAlpha(32);
									painter.fillRect(rect, volrender.background_colour);
									volrender.background_colour.setAlpha(255);
									painter.resetTransform();
									painter.drawText(QPoint(dX, dY), numb);
								}
							}	
						}
					}
				}
				painter.end();

			glColor3f(1,1,1);
			//glDisable(GL_BLEND);
			glDisable(GL_LIGHTING);

			glMatrixMode(GL_PROJECTION);
			glLoadIdentity();
			glMatrixMode(GL_MODELVIEW);
			glLoadIdentity();
			glEnable(GL_DEPTH_TEST);
			glDepthFunc(GL_LEQUAL);

		glPopMatrix();

				/*unsigned char* tempimgdata = new unsigned char[4*volrender.FBO_SIZE*volrender.FBO_SIZE];
				for(int i=0; i<volrender.FBO_SIZE; i++)
				for(int j=0; j<volrender.FBO_SIZE; j++)
				{
					tempimgdata[4*(i+j*volrender.FBO_SIZE)+0] = 
					tempimgdata[4*(i+j*volrender.FBO_SIZE)+1] = 
					tempimgdata[4*(i+j*volrender.FBO_SIZE)+2] = volrender.depthdata[i+j*volrender.FBO_SIZE];

					tempimgdata[4*(i+j*volrender.FBO_SIZE)+3] = 255;
				}

				QImage dstimg = QImage(tempimgdata, volrender.FBO_SIZE, volrender.FBO_SIZE, QImage::Format_ARGB32);
				QPainter painter2(&dstimg);
				
				for(int i=0; i<volrender.current_measure_points.size(); i++)
				{
					double dX, dY, dZ, rZ;
					Vector v0 = volrender.current_measure_points[i];
					//v0.z -= volrender.zoom;
					//v0 = v0.mult_matrix(volrender.arcball.Transform.M);

					//project our 3d coord to 2d screen space
					gluProject((double)v0.x,(double)v0.y, (double)v0.z, volrender.mvmatrix, volrender.projmatrix, volrender.viewport, &dX, &dY, &dZ);
					
					double offset = volrender.winWidth-volrender.winHeight;
					offset /= 2.0;
					dY = volrender.winWidth-(dY+offset);
					
					Vector texcoord;	
					texcoord.x = ((float)(dX)/(float)volrender.viewport[2])*(float)volrender.FBO_SIZE;
					texcoord.y = ((float)(dY)/(float)volrender.viewport[3])*(float)volrender.FBO_SIZE;
					if(texcoord.x>volrender.FBO_SIZE-1) texcoord.x=volrender.FBO_SIZE-1;
					if(texcoord.y>volrender.FBO_SIZE-1) texcoord.y=volrender.FBO_SIZE-1;
					if(texcoord.x<0.0) texcoord.x=0.0;
					if(texcoord.y<0.0) texcoord.y=0.0;

					rZ = volrender.depthdata[(int)(texcoord.x)+volrender.FBO_SIZE*(int)((volrender.FBO_SIZE-1)-texcoord.y)];
					rZ /= 4294967296.0;

					printf("index: %d dZ: %f, rZ: %f\n", i, (double)dZ, (double)rZ);
					if(dZ<rZ) painter2.setPen(QColor(0,255,0));
					else painter2.setPen(QColor(255,0,0));

					printf("texcoord %f, %f\n",texcoord.x, texcoord.y);
					painter2.drawEllipse ((int)texcoord.x-0.5, (int)texcoord.y-0.5, 2.0, 2.0);
				}
				//painter2.drawEllipse(0,0,5,5);
				painter2.end();
				dstimg.save("Depth.png", "PNG");*/
		//glFinish();

		//render=0;
		//swapBuffers();
		//update();
	}
}
void QtGLWidget::keyPressEvent ( QKeyEvent * e)
{
    switch ( tolower(e->ascii()) ) 
	{
        case 'a':
			volrender.testerJA++;
			if(volrender.testerJA>volrender.numbslices+volrender.numbslices/2) volrender.testerJA=volrender.numbslices+volrender.numbslices/2;

            break;
        case 'z':
			volrender.testerJA--;
			if(volrender.testerJA<-volrender.numbslices/2) volrender.testerJA=-volrender.numbslices/2;

            break;
        case 'd':
			volrender.tx -= 5;
            break;
        case 'w':
			volrender.ty += 5;
            break;
        case 's':
			volrender.ty -= 5;
            break;
        case 'x':
			volrender.zoom -= 5;
            break;
        case 'q':
			volrender.camera.fov ++;
        	resizeGL(width(),height());
		    break;
        case 'e':                              
			volrender.camera.fov --;
			resizeGL(width(),height());
            break;

        case 'g':
			volrender.brick ++;

			if(volrender.brick>pow((float)volrender.BRICKS_SUBDIV, 3)) volrender.brick = pow((float)volrender.BRICKS_SUBDIV, 3);
            break;
        case 'b':
			volrender.brick --;
			if(volrender.brick<0) volrender.brick=0;
            break;

		default:
			break;
    }

	redraw_event();
	updateGL();
}
void QtGLWidget::keyReleaseEvent ( QKeyEvent * e)
{

}
void QtGLWidget::wheelEvent(QWheelEvent *event)
{
	int numDegrees = event->delta() / (8);
	int numSteps = numDegrees / 15;

	if (event->orientation() == Qt::Horizontal) 
	{

	} 
	else if (event->orientation() == Qt::Vertical) 
	{
		dx = numSteps;
		dy = numSteps;

		int selected=-1;
		for(int i=0; i<6; i++)
		{
			if(volrender.cutting_planes.selected[i]==1) selected = i;
		}

		if(selected==-1)
		{

			if(volrender.measure_editmode==1 || volrender.measure_modify==1)
			{
				volrender.cutting_planes.selected[0]=1;
				render = 1;			
				active=CUTTING;
				cutplane_interact(-dy/dw);
				active=-1;
				volrender.cutting_planes.selected[0]=0;
			}
			else
			{
				volrender.zoom -= dy;
				if(volrender.zoom<-volobject.maxres) volrender.zoom = -volobject.maxres+2;		
				if(volrender.projection_toggle==1) volrender.resizeGL(volrender.winWidth, volrender.winHeight);
				redraw_event();
			}
		}
		else
		{		
			render = 1;			
			active=CUTTING;
			cutplane_interact(-dy/dw);
			active=-1;
		}

	}
}
void QtGLWidget::mouseDoubleClickEvent(QMouseEvent * e)
{
	mouspos.x = e->x();
	mouspos.y = e->y();

	if(volrender.measure_dragmode==0 && active!=OBJ_ANGLE && active!=OBJ_ZOOM) processDepthClick(mouspos.x, mouspos.y, 3);
}
void QtGLWidget::mouseMoveEvent  ( QMouseEvent * e )
{
	mouspos.x = e->x();
	mouspos.y = e->y();
	dx = mouspos.x - global_mousepos.x;
	dy = mouspos.y - global_mousepos.y;
	//global_mousepos = mouspos;

	//printf("volrender.current_measure_vertindex: %d\n", volrender.current_measure_vertindex);

	if(volrender.measure_dragmode==0 && active!=OBJ_ANGLE && active!=OBJ_ZOOM) processDepthClick(mouspos.x, mouspos.y, 2);
	if(volrender.measure_dragmode==0 && active!=OBJ_ANGLE && active!=OBJ_ZOOM) processDepthClickCrop(mouspos.x, mouspos.y, 2);

	if(volrender.crop_shape_selected!=-1)
	{
		if ((e->buttons()&Qt::LeftButton))
		{
			processDepthClickCrop(mouspos.x, mouspos.y, 1);
			return;
		}
	}

	if(volrender.current_measure_vertindex!=-1)
	{
		if ((e->buttons()&Qt::LeftButton))
		{
			processDepthClick(mouspos.x, mouspos.y, 1);
			return;
		}
	}

	if(volrender.measure_modify==1 && volrender.current_measure_vertindex==-1)
	{
		switch(active)
		{
			case OBJ_ANGLE:
//				volrender.measure_arcball.mousemotion(&mouspos);
				measure_modify_rotatecurrent(0, (float)dy*0.01);
				measure_modify_rotatecurrent(1, (float)dx*0.01);
				redraw_event();
				break;
			case OBJ_TRANSLATE:			
				//volrender.measure_arcball.mousemotion(&mouspos);
				measure_modify_rotatecurrent(2, (float)dy*0.01);
				redraw_event();
				break;
			case OBJ_ZOOM:	
				measure_modify_zoomcurrent(1.0+(dy*0.001));
				redraw_event();
				break;
			default:
				break;
		}
		global_mousepos = mouspos;
		return;
	}

	{
		switch(active)
		{
			case OBJ_ANGLE:
				volrender.arcball.mousemotion(&mouspos);

				redraw_event();
				break;
			case CUTTING:
				
				cutplane_interact(dy);
								
				redraw_event();
				break;
			case OBJ_ZOOM:	
				
				volrender.zoom -= dy;
				if(volrender.zoom<-volobject.maxres) volrender.zoom = -volobject.maxres+2; 

				//printf("zoom: %d\n", (int)volrender.zoom);
				
				if(volrender.projection_toggle==1)
				{
					volrender.resizeGL(volrender.winWidth, volrender.winHeight);
				}

				redraw_event();
				break;

			case OBJ_TRANSLATE:
				volrender.tx += dx;
				volrender.ty -= dy;
				redraw_event();
				break;
			default:
				break;
			//global_mousepos = mouspos;
		}
	}
	global_mousepos = mouspos;
	//------------------------------------------------
	//Get the depth texture (z-buffer)
	//------------------------------------------------
	if(volrender.volume_toggle)
	{
		volrender.measure_toggle = 0;
		volrender.offscreen_toggle = 1;
		redraw_event();
		volrender.measure_toggle = 1;
		volrender.offscreen_toggle = 0;
	}
	else
	{
		volrender.offscreen_toggle = 1;
		redraw_event();
		volrender.offscreen_toggle = 0;
	}
	glBindTexture(GL_TEXTURE_2D, volrender.TEXTURE2D_FBO_DP);
	glGetTexImage(GL_TEXTURE_2D, 0, GL_DEPTH_COMPONENT, GL_UNSIGNED_INT, volrender.depthdata);

	//redraw_event();
}
void QtGLWidget::mouseReleaseEvent(QMouseEvent * e )
{
	volrender.arcball.isDragging = false;
	mouspos.x = e->x();
	mouspos.y = e->y();
	global_mousepos = mouspos;

	//volrender.measure_arcball.setIdentity();

	active = -1;
	render = 0;
	volrender.measure_dragmode = 0;
	emit measure_editpoint_select_signal(-1);

	if(volrender.FBOmoveLOD_toggle)
	{
		volrender.update_FBOsize(0);
		volrender.postprocess2d_shader();
	}
	if(volrender.SlicesmoveLOD_toggle)
	{
		volrender.numbslices = volrender.slices;
		volrender.load_1DLookupTables();
	}

	volrender.cutting_planes.mouseRelease();
	redraw_event();
}
void QtGLWidget::mousePressEvent ( QMouseEvent * e )
{
	mouspos.x = e->x();
	mouspos.y = e->y();
	global_mousepos = mouspos;

	int selected=-1;
	for(int i=0; i<6; i++)
	{
		if(volrender.cutting_planes.selected[i]==1) selected = i;
	}
	
	if ((e->button()&Qt::LeftButton)) 
	{			
		render = 1;

		if(volrender.cutting_planes.renderall==1)
		{	
			if(processClickOnAnyPlane(mouspos.x, mouspos.y)) processClick(mouspos.x, mouspos.y, 0);
			return;
		}

		if(volrender.cropping_mode==1)
		{
			if(volrender.crop_shape_selected==-1)
			{
				processDepthClickCrop(mouspos.x, mouspos.y, 0);
			}
			else
			{
				processDepthClickCrop(mouspos.x, mouspos.y, 1);
			}
			return;
		}

		if(volrender.measure_mode==1|| volrender.measure_editmode==1) //|| volrender.cutting_planes.renderall==1 
		{
			if(volrender.current_measure_vertindex==-1)
			{
				processDepthClick(mouspos.x, mouspos.y, 0);
			}
			else
			{
				processDepthClick(mouspos.x, mouspos.y, 1);
			}
		}
	
		//ROTATE OBJECT
		active = OBJ_ANGLE;
		//volrender.measure_arcball.setIdentity();
		//volrender.measure_arcball.orien_type=0;
		volrender.arcball.clickDrag(&mouspos);	 

		if(volrender.FBOmoveLOD_toggle)
		{
			volrender.update_FBOsize(1);
			volrender.postprocess2d_shader();
		}
		if(volrender.SlicesmoveLOD_toggle)
		{
			volrender.numbslices = volrender.sliceslod;
			volrender.load_1DLookupTables();
		}
		
		if(selected!=-1)
		{
			if(processClickOnSelectedPlane(mouspos.x, mouspos.y)) active=CUTTING;
		}
		
		mouseMoveEvent(e);
    }
	if((e->button()&Qt::MidButton))
	{
		render = 1;
		active = OBJ_TRANSLATE;

		if(volrender.FBOmoveLOD_toggle)
		{
			volrender.update_FBOsize(1);
		}
		if(volrender.SlicesmoveLOD_toggle)
		{
			volrender.numbslices = volrender.sliceslod;
			volrender.load_1DLookupTables();
		}

		tempx =volrender.tx;
		tempy =volrender.ty;

		//processDepthClick(mouspos.x, mouspos.y);

		mouseMoveEvent(e);
	}
	if((e->button()&Qt::RightButton))
	{
		render = 1;
		active = OBJ_ZOOM;

		processDepthClick(mouspos.x, mouspos.y, 4);

		if(volrender.FBOmoveLOD_toggle)
		{
			volrender.update_FBOsize(1);
		}
		if(volrender.SlicesmoveLOD_toggle)
		{
			volrender.numbslices = volrender.sliceslod;
			volrender.load_1DLookupTables();
		}
		
		mouseMoveEvent(e);
	}
}

bool QtGLWidget::processClickOnSelectedPlane(int x, int y)
{
	// This function will find 2 points in world space that are on the line into the screen defined by screenspace point (x,y)
	double dX, dY, dZ, dClickY; // glUnProject uses doubles, but I'm using floats for these 3D vectors
	//viewport[3]

	double offset = volrender.winWidth-volrender.winHeight;
	offset /= 2.0;

	dClickY = double (volrender.winWidth-(y+offset)); // OpenGL renders with (0,0) on bottom, mouse reports with (0,0) on top
	
	gluUnProject((double) x, dClickY, 0.0, volrender.mvmatrix, volrender.projmatrix, volrender.viewport, &dX, &dY, &dZ);
	Vector ClickRayP1 = Vector( (float) dX, (float) dY, (float) dZ );

	gluUnProject((double) x, dClickY, 1.0, volrender.mvmatrix, volrender.projmatrix, volrender.viewport, &dX, &dY, &dZ);
	Vector ClickRayP2 = Vector( (float) dX, (float) dY, (float) dZ );

	Vector vClickSlope;
	vClickSlope = ClickRayP2 - ClickRayP1;

	float fDistance = 9999999999999999999999999999.9;

	Vector v;
	Vector v1, v2, v3;
	Vector intersect;
	
	int selected=-1;
	for(int i=0; i<6; i++)
	{
		if(volrender.cutting_planes.selected[i]==1) selected = i;
	}

	if(selected!=-1)
	{
		//build up our plane faces
		vector<Face> faces;
		Face f;
		for(int j=1; j<volrender.cutting_planes.plane_clippoints[selected].size(); j++)
		{
			f.vert[0] = &volrender.cutting_planes.plane_clippoints[selected][j-1];
			f.vert[1] = &volrender.cutting_planes.plane_clippoints[selected][j];
			f.vert[2] = &volrender.cutting_planes.planes[selected].centre;	
			f.uv[0][0] = selected;

			faces.push_back(f);
		}
		f.vert[0] = &volrender.cutting_planes.plane_clippoints[selected][volrender.cutting_planes.plane_clippoints[selected].size()-1];
		f.vert[1] = &volrender.cutting_planes.plane_clippoints[selected][0];
		f.vert[2] = &volrender.cutting_planes.planes[selected].centre;
		f.uv[0][0] = selected;
		faces.push_back(f);
	
		Vector normal;
		for (int ii = 0; ii <faces.size(); ii++)
		{
			if(faces[ii].line_intersection(ClickRayP2, ClickRayP1, intersect))
			{
				Vector vSelSlope =  intersect - ClickRayP1;	
				float fTestDist = vSelSlope.length();

				if (fTestDist < fDistance)
				{
					fDistance = fTestDist;
					normal = faces[ii].facenormal;
					return true;
				}
			}	
		}
	}
	
	return false;
}
bool QtGLWidget::processClickOnAnyPlane(int x, int y)
{
	// This function will find 2 points in world space that are on the line into the screen defined by screenspace point (x,y)
	double dX, dY, dZ, dClickY; // glUnProject uses doubles, but I'm using floats for these 3D vectors
	//viewport[3]

	double offset = volrender.winWidth-volrender.winHeight;
	offset /= 2.0;

	dClickY = double (volrender.winWidth-(y+offset)); // OpenGL renders with (0,0) on bottom, mouse reports with (0,0) on top
	
	gluUnProject((double) x, dClickY, 0.0, volrender.mvmatrix, volrender.projmatrix, volrender.viewport, &dX, &dY, &dZ);
	Vector ClickRayP1 = Vector( (float) dX, (float) dY, (float) dZ );

	gluUnProject((double) x, dClickY, 1.0, volrender.mvmatrix, volrender.projmatrix, volrender.viewport, &dX, &dY, &dZ);
	Vector ClickRayP2 = Vector( (float) dX, (float) dY, (float) dZ );

	Vector vClickSlope;
	vClickSlope = ClickRayP2 - ClickRayP1;

	float fDistance = 9999999999999999999999999999.9;

	Vector v;
	Vector v1, v2, v3;
	Vector intersect;
	
	//build up our plane faces
	vector<Face> faces;
	Face f;
	for(int i=0; i<6; i++)
	{
		for(int j=1; j<volrender.cutting_planes.plane_clippoints[i].size(); j++)
		{
			f.vert[0] = &volrender.cutting_planes.plane_clippoints[i][j-1];
			f.vert[1] = &volrender.cutting_planes.plane_clippoints[i][j];
			f.vert[2] = &volrender.cutting_planes.planes[i].centre;	
			f.uv[0][0] = i;

			faces.push_back(f);
		}
		f.vert[0] = &volrender.cutting_planes.plane_clippoints[i][volrender.cutting_planes.plane_clippoints[i].size()-1];
		f.vert[1] = &volrender.cutting_planes.plane_clippoints[i][0];
		f.vert[2] = &volrender.cutting_planes.planes[i].centre;
		f.uv[0][0] = i;
		faces.push_back(f);
	}

	Vector normal;
	for (int ii = 0; ii <faces.size(); ii++)
	{
		if(faces[ii].line_intersection(ClickRayP2, ClickRayP1, intersect))
		{
			Vector vSelSlope =  intersect - ClickRayP1;	
			float fTestDist = vSelSlope.length();

			if (fTestDist < fDistance)
			{
				fDistance = fTestDist;
				normal = faces[ii].facenormal;
				return true;
			}
		}	
	}
	
	return false;
}
void QtGLWidget::processDepthClickCrop(int x, int y, int mode)
{
	Vector ss_point;

	// This function will find 2 points in world space that are on the line into the screen defined by screenspace point (x,y)
	double dX, dY, dZ, dClickY; // glUnProject uses doubles, but I'm using floats for these 3D vectors

	double offset = volrender.winWidth-volrender.winHeight;
	offset /= 2.0;

	//dClickY =double(volrender.viewport[3] - (y-offset));
	dClickY = double (volrender.winWidth-(y+offset)); // OpenGL renders with (0,0) on bottom, mouse reports with (0,0) on top

	ss_point.x = x;
	ss_point.y = dClickY;
	ss_point.z = 0.0;

	gluUnProject((double)ss_point.x, (double)ss_point.y, (double)ss_point.z, volrender.mvmatrix, volrender.projmatrix, volrender.viewport, &dX, &dY, &dZ);
	
	volrender.cursor3D_screenspace.x = dX;
	volrender.cursor3D_screenspace.y = dY;
	volrender.cursor3D_screenspace.z = dZ;

	//printf("ss_point: %f, %f, %f\n", ss_point.x, ss_point.y, ss_point.z);
	gluUnProject((double)ss_point.x, (double)ss_point.y, (double)ss_point.z, volrender.mvmatrix, volrender.projmatrix, volrender.viewport, &dX, &dY, &dZ);

	Vector v;
	v.x = dX;
	v.y = dY;
	v.z = dZ;

	float screenzoom = (float)(volobject.maxres+volrender.zoom)/(float)volobject.maxres;
	float linesize = ((float)volobject.maxres/100.0)/screenzoom;
	float pointsize = ((float)volobject.maxres/100.0)/screenzoom;

	Vector bb_size = Vector(volobject.texwidth*volobject.xsize/volobject.maxsize, volobject.texheight*volobject.ysize/volobject.maxsize, volobject.texdepth*volobject.zsize/volobject.maxsize);
	bb_size /= 2.0;
	float maxl = bb_size.x;
	maxl = max (maxl, bb_size.y);
	maxl = max (maxl, bb_size.z);
	pointsize = (float)((2*maxl)/20.0)*screenzoom;
	linesize = (float)((2*maxl)/20.0)*screenzoom;
	if(pointsize>1.0) pointsize = 1.0;
	if(pointsize<0.25) pointsize = 0.25;
	if(linesize>2.0) linesize = 2.0;
	if(linesize<1.0) linesize = 1.0;
	float sizebb = pointsize*4;

	if(mode==0)			//CLICK
	{
		volrender.crop_shape.push_back(v);

		ss_point.w = volrender.crop_shape.size()-1;
		volrender.crop_shape2d.push_back(ss_point);

		printf("computing normals\n");

		double dX, dY, dZ;
		volrender.crop_normals.clear();
		volrender.crop_centroids.clear();

		Vector planecentre;
		for(int iii=1; iii<volrender.crop_shape.size(); iii++)
		{
			planecentre += volrender.crop_shape[iii];
		}
		planecentre/= volrender.crop_shape.size();

		volrender.crop_triangles.clear();
		Triangulate::Process(volrender.crop_shape2d, volrender.crop_triangles);

		//NORMALS
		if(volrender.crop_shape.size()>2)
		{
			for(int iii=0; iii<volrender.crop_triangles.size()/3; iii++)
			{
				int index0 = volrender.crop_triangles[3*iii].w;
				int index1 = volrender.crop_triangles[3*iii+1].w;
				int index2 = volrender.crop_triangles[3*iii+2].w;

				Vector v0 = volrender.crop_shape[index0];
				Vector v1 = volrender.crop_shape[index1];
						
				gluProject((double)v0.x,(double)v0.y, (double)v0.z, volrender.mvmatrix, volrender.projmatrix, volrender.viewport, &dX, &dY, &dZ);
				Vector ssv2 = Vector(dX, dY, 1.0);

				gluProject((double)v1.x,(double)v1.y, (double)v1.z, volrender.mvmatrix, volrender.projmatrix, volrender.viewport, &dX, &dY, &dZ);
				Vector ssv3 = Vector(dX, dY, 1.0);

				gluUnProject((double)ssv2.x, (double)ssv2.y, (double)ssv2.z, volrender.mvmatrix, volrender.projmatrix, volrender.viewport, &dX, &dY, &dZ);
				Vector v2 = Vector((float)dX, (float)dY, (float)dZ);
				gluUnProject((double)ssv3.x, (double)ssv3.y, (double)ssv3.z, volrender.mvmatrix, volrender.projmatrix, volrender.viewport, &dX, &dY, &dZ);
				Vector v3 = Vector((float)dX, (float)dY, (float)dZ);

				Vector centroid = (v0+v1+v2+v3)/4.0f;
				volrender.crop_centroids.push_back(centroid);

				Vector normal0;
				normal0.get_normal(v2,v1,v0);
				volrender.crop_normals.push_back(normal0);

				//--------------------------------------------------------------------

				v0 = volrender.crop_shape[index1];
				v1 = volrender.crop_shape[index2];
						
				gluProject((double)v0.x,(double)v0.y, (double)v0.z, volrender.mvmatrix, volrender.projmatrix, volrender.viewport, &dX, &dY, &dZ);
				ssv2 = Vector(dX, dY, 1.0);

				gluProject((double)v1.x,(double)v1.y, (double)v1.z, volrender.mvmatrix, volrender.projmatrix, volrender.viewport, &dX, &dY, &dZ);
				ssv3 = Vector(dX, dY, 1.0);

				gluUnProject((double)ssv2.x, (double)ssv2.y, (double)ssv2.z, volrender.mvmatrix, volrender.projmatrix, volrender.viewport, &dX, &dY, &dZ);
				v2 = Vector((float)dX, (float)dY, (float)dZ);
				gluUnProject((double)ssv3.x, (double)ssv3.y, (double)ssv3.z, volrender.mvmatrix, volrender.projmatrix, volrender.viewport, &dX, &dY, &dZ);
				v3 = Vector((float)dX, (float)dY, (float)dZ);

				centroid = (v0+v1+v2+v3)/4.0f;
				volrender.crop_centroids.push_back(centroid);

				normal0;
				normal0.get_normal(v2,v1,v0);
				volrender.crop_normals.push_back(normal0);

				//--------------------------------------------------------------------

				v0 = volrender.crop_shape[index2];
				v1 = volrender.crop_shape[index0];
						
				gluProject((double)v0.x,(double)v0.y, (double)v0.z, volrender.mvmatrix, volrender.projmatrix, volrender.viewport, &dX, &dY, &dZ);
				ssv2 = Vector(dX, dY, 1.0);

				gluProject((double)v1.x,(double)v1.y, (double)v1.z, volrender.mvmatrix, volrender.projmatrix, volrender.viewport, &dX, &dY, &dZ);
				ssv3 = Vector(dX, dY, 1.0);

				gluUnProject((double)ssv2.x, (double)ssv2.y, (double)ssv2.z, volrender.mvmatrix, volrender.projmatrix, volrender.viewport, &dX, &dY, &dZ);
				v2 = Vector((float)dX, (float)dY, (float)dZ);
				gluUnProject((double)ssv3.x, (double)ssv3.y, (double)ssv3.z, volrender.mvmatrix, volrender.projmatrix, volrender.viewport, &dX, &dY, &dZ);
				v3 = Vector((float)dX, (float)dY, (float)dZ);

				centroid = (v0+v1+v2+v3)/4.0f;
				volrender.crop_centroids.push_back(centroid);

				normal0;
				normal0.get_normal(v2,v1,v0);
				volrender.crop_normals.push_back(normal0);
			}
		}
	}
	else if(mode==1)	//DRAG
	{
		volrender.measure_dragmode=1;
		if(volrender.crop_shape_selected!=-1)
		{
			ss_point.w = volrender.crop_shape_selected;
			volrender.crop_shape[volrender.crop_shape_selected] = v;
			volrender.crop_shape2d[volrender.crop_shape_selected] = ss_point;

			volrender.crop_triangles.clear();
			Triangulate::Process(volrender.crop_shape2d, volrender.crop_triangles);

			redraw_event();
		}
	}
	else if(mode==2)	//HOVER
	{
		volrender.crop_shape_selected=-1;
		for(int i=0; i<volrender.crop_shape.size(); i++)
		{
			Vector v0 = volrender.crop_shape[i];						
			gluProject((double)v0.x,(double)v0.y, (double)v0.z, volrender.mvmatrix, volrender.projmatrix, volrender.viewport, &dX, &dY, &dZ);
			Vector screenspace = Vector(dX, dY, dZ);

			//printf("sspace: %f, %f, %f\n", screenspace.x, screenspace.y, screenspace.z);
			if(ss_point.x+sizebb*2.0 > screenspace.x
			&& ss_point.x-sizebb*2.0 < screenspace.x
			&& ss_point.y+sizebb*2.0 > screenspace.y
			&& ss_point.y-sizebb*2.0 < screenspace.y)
			{
				//printf("SELECT POINT: 2D POINT FOUND.\n");
				volrender.crop_shape_selected = i;
				redraw_event();				
			}
		}
	}
}
void QtGLWidget::processDepthClick(int x, int y, int mode)
{
	Vector ss_point;

	// This function will find 2 points in world space that are on the line into the screen defined by screenspace point (x,y)
	double dX, dY, dZ, dClickY; // glUnProject uses doubles, but I'm using floats for these 3D vectors
	//viewport[3]

	double offset = volrender.winWidth-volrender.winHeight;
	offset /= 2.0;

	//dClickY =double(volrender.viewport[3] - (y-offset));
	dClickY = double (volrender.winWidth-(y+offset)); // OpenGL renders with (0,0) on bottom, mouse reports with (0,0) on top

	ss_point.x = x;
	ss_point.y = dClickY;
	ss_point.z = 0.0;

	//measure_magnetline_vert=-1;

	/*render=0;
	volrender.fbo_depth=0;
	volrender.render_scene(1);
	QImage qimg = grabFrameBuffer (false);
	Vector click_point;
	click_point.x = x;
	click_point.y = y;
	QPainter painter;
	painter.begin(&qimg);
	painter.setPen(QColor(0,255,0));
	painter.drawEllipse ((int)click_point.x-5.0, (int)click_point.y-5.0, 10.0, 10.0);
	painter.end();
	qimg.save("FrameBuffer.png", "PNG");*/
	
	/*QRgb pixel = qimg.pixel((int)click_point.x, (int)click_point.y);
	float val = (float)qGray(pixel)/255.0f;
	ss_point.z = 1-val;*/

	//printf("val: %f\n", val);

//	unsigned int* imgdata = new unsigned int[volrender.FBO_SIZE*volrender.FBO_SIZE];
//	glBindTexture(GL_TEXTURE_2D, volrender.TEXTURE2D_FBO_DP);
//	glGetTexImage(GL_TEXTURE_2D, 0, GL_DEPTH_COMPONENT, GL_UNSIGNED_INT, imgdata);

	Vector texcoord;	
	texcoord.x = ((float)(ss_point.x)/(float)volrender.viewport[2])*(float)volrender.FBO_SIZE;
	texcoord.y = ((float)(ss_point.y)/(float)volrender.viewport[3])*(float)volrender.FBO_SIZE;
	
	if(texcoord.x>volrender.FBO_SIZE-1) texcoord.x=volrender.FBO_SIZE-1;
	if(texcoord.y>volrender.FBO_SIZE-1) texcoord.y=volrender.FBO_SIZE-1;
	if(texcoord.x<0.0) texcoord.x=0.0;
	if(texcoord.y<0.0) texcoord.y=0.0;

	float val = volrender.depthdata[(int)(texcoord.x)+volrender.FBO_SIZE*(int)(texcoord.y)];
	val /= 4294967296.0;

	float zoom = (float)(volobject.maxres-volrender.zoom)/(float)volobject.maxres;

	//printf("ZOOM: %f\n", (float)(volrender.maxres-volrender.zoom)/(float)volrender.maxres);
	//printf("DEPTH: %f\n", val);

	//volrender.fbo_depth=0;
/*
	unsigned char* tempimgdata = new unsigned char[4*volrender.FBO_SIZE*volrender.FBO_SIZE];
	for(int i=0; i<volrender.FBO_SIZE; i++)
	for(int j=0; j<volrender.FBO_SIZE; j++)
	{
		tempimgdata[4*(i+j*volrender.FBO_SIZE)+0] = 
		tempimgdata[4*(i+j*volrender.FBO_SIZE)+1] = 
		tempimgdata[4*(i+j*volrender.FBO_SIZE)+2] = imgdata[i+j*volrender.FBO_SIZE];

		tempimgdata[4*(i+j*volrender.FBO_SIZE)+3] = 255;
	}
	
	QImage dstimg = QImage(tempimgdata, volrender.FBO_SIZE, volrender.FBO_SIZE, QImage::Format_ARGB32);
	QPainter painter;
	painter.begin(&dstimg);
	painter.setPen(QColor(0,255,0));
	painter.drawEllipse ((int)texcoord.x-5.0, (int)texcoord.y-5.0, 10.0, 10.0);
	painter.end();
	dstimg.save("Depth.png", "PNG");
	
	delete[] tempimgdata;
	tempimgdata = 0;
*/
//	delete[] imgdata;
//	imgdata = 0;
	
	if(val==0 || val==1.0)
	{
		val=0.5;
		//if(mode==2) emit measure_editpoint_select_signal(-1);
		//return;
	}

	//printf("texval: %f\n", val/4294967296.0);

	ss_point.z = (val);

	gluUnProject((double)ss_point.x, (double)ss_point.y, (double)ss_point.z, volrender.mvmatrix, volrender.projmatrix, volrender.viewport, &dX, &dY, &dZ);
	
	volrender.cursor3D_screenspace.x = dX;
	volrender.cursor3D_screenspace.y = dY;
	volrender.cursor3D_screenspace.z = dZ;
	int selected = -1;


	float screenzoom = (float)(volobject.maxres+volrender.zoom)/(float)volobject.maxres;
	float linesize = ((float)volobject.maxres/100.0)/screenzoom;
	float pointsize = ((float)volobject.maxres/100.0)/screenzoom;

	Vector bb_size = Vector(volobject.texwidth*volobject.xsize/volobject.maxsize, volobject.texheight*volobject.ysize/volobject.maxsize, volobject.texdepth*volobject.zsize/volobject.maxsize);
	bb_size /= 2.0;

	float maxl = bb_size.x;
	maxl = max (maxl, bb_size.y);
	maxl = max (maxl, bb_size.z);
	
	pointsize = (float)((2*maxl)/20.0)*screenzoom;
	linesize = (float)((2*maxl)/20.0)*screenzoom;

	if(pointsize>1.0) pointsize = 1.0;
	if(pointsize<0.5) pointsize = 0.5;
	if(linesize>2.0) linesize = 2.0;
	if(linesize<1.0) linesize = 1.0;

	float sizebb = pointsize*2;

	if(mode==0)	//LEFT CLICK
	{
			//printf("ADD POINT\n");
			if(volrender.current_measure_vertindex==-1)
			{
				printf("ADD POINT: ADDING A POINT\n");

				volrender.current_normals.push_back(Vector(0,0,0));
				volrender.current_measure_points.push_back(volrender.cursor3D_screenspace);
	
				//printf("current_edges size: %d\n", volrender.current_edges.size());

				if(volrender.current_measure_drawmode==6)
				{
					//volrender.measure_magnetline_vert_old = volrender.measure_magnetline_vert;
					volrender.measure_magnetline_vert = volrender.current_measure_points.size()-1;

					//printf("measure_magnetline: %d, %d\n", volrender.measure_magnetline_vert, volrender.measure_magnetline_vert_old);
				}

				measure_rebuild_current_edges();
				
				printf("volrender.measure_magnetline_helper: %d\n", volrender.measure_magnetline_helper);
				printf("volrender.current_edges.size(): %d\n", volrender.current_edges.size());

				/*if(volrender.measure_magnetline_helper==-1 && !volrender.current_edges.empty())
				{
					printf("BOH\n");
					volrender.measure_magnetline_destvert = volrender.current_edges[volrender.current_edges.size()-1].v0;
					printf("volrender.measure_magnetline_destvert: %d\n", volrender.measure_magnetline_destvert);
					volrender.measure_magnetline_helper=1;
				}*/

				emit measure_point_signal(volrender.cursor3D_screenspace);
				emit measure_currentverts_signal(volrender.current_measure_points);
				emit measure_currentedges_signal(volrender.current_edges);
				redraw_event();
			}
	}
	else if(mode==1) //DRAG
	{
		//printf("EDIT POINT\n");
		if(volrender.current_measure_vertindex!=-1)
		{
			//printf("EDIT POINT: DRAG\n");
			if(volrender.measure_editmode==0 && volrender.measure_modify==0)
			{
				//printf("EDIT POINT: EXISTING POINT NOT FOUND!\n");

				volrender.measure_dragmode = 1;
				volrender.current_measure_points[volrender.current_measure_vertindex] = volrender.cursor3D_screenspace;
				volrender.current_normals[volrender.current_measure_vertindex] = Vector(0,0,0);
				emit measure_editpoint_signal(volrender.cursor3D_screenspace);
			}
			else if(volrender.measure_editmode==0 && volrender.measure_modify==1)
			{
				volrender.measure_dragmode = 1;

				Vector v = volrender.current_measure_points[volrender.current_measure_vertindex]-volrender.cursor3D_screenspace;
				volrender.current_measure_points[volrender.current_measure_vertindex] = volrender.cursor3D_screenspace;

				for(int i=0; i<volrender.current_measure_points.size(); i++)
				{
					if(i!=volrender.current_measure_vertindex)
					{
						volrender.current_measure_points[i] -= v;
					}
					emit measure_editgrppoint_signal(i, volrender.current_measure_points[i]);
				}
				measure_modify_start_slot();
			}

			/*unsigned char* imgdata2 = new unsigned char[4*volrender.FBO_SIZE*volrender.FBO_SIZE];
			glBindTexture(GL_TEXTURE_2D, volrender.TEXTURE2D_FBO_FB);
			glGetTexImage(GL_TEXTURE_2D, 0, GL_RGBA, GL_UNSIGNED_BYTE, imgdata2);

			volrender.measure_current_point_colour.x = imgdata2[4*((int)(texcoord.x)+volrender.FBO_SIZE*(int)(texcoord.y))+0]/255.0;
			volrender.measure_current_point_colour.y = imgdata2[4*((int)(texcoord.x)+volrender.FBO_SIZE*(int)(texcoord.y))+1]/255.0;
			volrender.measure_current_point_colour.z = imgdata2[4*((int)(texcoord.x)+volrender.FBO_SIZE*(int)(texcoord.y))+2]/255.0;
			
			QImage dstimg = QImage(imgdata2, volrender.FBO_SIZE, volrender.FBO_SIZE, QImage::Format_ARGB32);
			QPainter painter;
			painter.begin(&dstimg);
			painter.setPen(QColor(0,255,0));
			painter.drawEllipse ((int)texcoord.x-5.0, (int)texcoord.y-5.0, 10.0, 10.0);
			painter.end();
			dstimg.save("FrameBuffer.png", "PNG");

			delete[] imgdata2;
			imgdata2 = 0;*/
			
			if(volrender.current_measure_drawmode==6 && volrender.measure_mode==1)
			{
				if(volrender.measure_magnetline_vert_old!=-1 && volrender.measure_magnetline_vert!=-1 && volrender.measure_magnetline_vert_old!=volrender.measure_magnetline_vert)
				{
					measure_rebuild_current_edges();
				}
				volrender.measure_magnetline_vert_old = volrender.measure_magnetline_vert;
			}
				
			redraw_event();
	}


	}
	else if(mode==2) //HOVER
	{
		//printf("SELECT POINT\n");
		selected = -1;
		volrender.measure_magnetline_vert = selected;
		volrender.measure_magnetline_edge=selected;
		//volrender.measure_dragmode = 0;

		//LOOK FOR A VERTEX IN 3D
		for(int i=0; i<volrender.current_measure_points.size(); i++)
		{
			//int i = volrender.measure_magnetline_destvert;

			if(volrender.current_measure_points[i].x+sizebb > volrender.cursor3D_screenspace.x
				&& volrender.current_measure_points[i].x-sizebb < volrender.cursor3D_screenspace.x
				&& volrender.current_measure_points[i].y+sizebb > volrender.cursor3D_screenspace.y
				&& volrender.current_measure_points[i].y-sizebb < volrender.cursor3D_screenspace.y
				&& volrender.current_measure_points[i].z+sizebb > volrender.cursor3D_screenspace.z
				&& volrender.current_measure_points[i].z-sizebb < volrender.cursor3D_screenspace.z)
			{
				printf("SELECT POINT: 3D POINT FOUND.\n");
				selected = i;
				
				if(volrender.current_measure_drawmode==6)
				{
					//printf("volrender.measure_editmode: %d\n", volrender.measure_editmode);
					volrender.measure_magnetline_vert = i;
					if(volrender.measure_editmode==0) volrender.measure_magnetline_vert_old = i;
				}

				redraw_event();
			}
		}

		//LOOK FOR A VERTEX IN 2D
		if(selected==-1) //&& volrender.measure_mode==1
		{
			for(int i=0; i<volrender.current_measure_points.size(); i++)
			{
				//int i = volrender.measure_magnetline_destvert;

				Vector v0 = volrender.current_measure_points[i];						
				gluProject((double)v0.x,(double)v0.y, (double)v0.z, volrender.mvmatrix, volrender.projmatrix, volrender.viewport, &dX, &dY, &dZ);
				Vector screenspace = Vector(dX, dY, dZ);

				//printf("sspace: %f, %f, %f\n", screenspace.x, screenspace.y, screenspace.z);
				if(ss_point.x+sizebb*2.0 > screenspace.x
				&& ss_point.x-sizebb*2.0 < screenspace.x
				&& ss_point.y+sizebb*2.0 > screenspace.y
				&& ss_point.y-sizebb*2.0 < screenspace.y)
				{
					printf("SELECT POINT: 2D POINT FOUND.\n");
					selected = i;
					
					if(volrender.current_measure_drawmode==6)
					{
						//printf("volrender.measure_editmode: %d\n", volrender.measure_editmode);

						volrender.measure_magnetline_vert = i;
						if(volrender.measure_editmode==0) volrender.measure_magnetline_vert_old = i;
					}

					redraw_event();				
				}
			}
		}

		//LOOK FOR AN EDGE IN 3D
		if(selected==-1 && volrender.measure_mode==0)
		{
			volrender.measure_magnetline_edge=-1;
			for(int i=0; i<volrender.current_edges.size(); i++)
			{
				float dist = volrender.cursor3D_screenspace.distance_to_line(volrender.current_measure_points[volrender.current_edges[i].v0], volrender.current_measure_points[volrender.current_edges[i].v1]);
				//printf("dist: %f\n", dist);
				if(dist<sizebb)
				{
					printf("SELECT EDGE: 3D EDGE FOUND.\n");

					volrender.measure_magnetline_edge=i;
					volrender.current_measure_vertindex=-1;
					volrender.measure_magnetline_vert_old=-1;
				}
			}
		}

		//LOOK FOR AN EDGE IN 2D
		if(selected==-1 && volrender.measure_magnetline_edge==-1 && volrender.measure_mode==0)
		{
			//volrender.measure_magnetline_edge=-1;
			for(int i=0; i<volrender.current_edges.size(); i++)
			{
				Vector v0 = volrender.current_measure_points[volrender.current_edges[i].v0];						
				gluProject((double)v0.x,(double)v0.y, (double)v0.z, volrender.mvmatrix, volrender.projmatrix, volrender.viewport, &dX, &dY, &dZ);
				Vector screenspace_v0 = Vector(dX, dY, dZ);

				Vector v1 = volrender.current_measure_points[volrender.current_edges[i].v1];						
				gluProject((double)v1.x,(double)v1.y, (double)v1.z, volrender.mvmatrix, volrender.projmatrix, volrender.viewport, &dX, &dY, &dZ);
				Vector screenspace_v1 = Vector(dX, dY, dZ);

				float dist = ss_point.distance_to_line(screenspace_v0, screenspace_v1);
				//printf("dist: %f\n", dist);
				if(dist<sizebb)
				{
					printf("SELECT EDGE: 2D EDGE FOUND.\n");

					volrender.measure_magnetline_edge=i;
					volrender.current_measure_vertindex=-1;
					volrender.measure_magnetline_vert_old=-1;
				}
			}
		}

		emit measure_editpoint_select_signal(selected);
	}
	else if(mode==3) //DOUBLE CLICK
	{
		volrender.measure_magnetline_edge=-1;
		
		for(int i=0; i<volrender.current_edges.size(); i++)
		{
			float dist = volrender.cursor3D_screenspace.distance_to_line(volrender.current_measure_points[volrender.current_edges[i].v0], volrender.current_measure_points[volrender.current_edges[i].v1]);
			//printf("dist: %f\n", dist);
			if(dist<sizebb*2.0)
			{
				volrender.measure_magnetline_edge=i;
			}
		}

		//LOOK FOR AN EDGE IN 2D
		if(volrender.measure_magnetline_edge==-1)
		{
			//volrender.measure_magnetline_edge=-1;
			for(int i=0; i<volrender.current_edges.size(); i++)
			{
				Vector v0 = volrender.current_measure_points[volrender.current_edges[i].v0];						
				gluProject((double)v0.x,(double)v0.y, (double)v0.z, volrender.mvmatrix, volrender.projmatrix, volrender.viewport, &dX, &dY, &dZ);
				Vector screenspace_v0 = Vector(dX, dY, dZ);

				Vector v1 = volrender.current_measure_points[volrender.current_edges[i].v1];						
				gluProject((double)v1.x,(double)v1.y, (double)v1.z, volrender.mvmatrix, volrender.projmatrix, volrender.viewport, &dX, &dY, &dZ);
				Vector screenspace_v1 = Vector(dX, dY, dZ);

				float dist = ss_point.distance_to_line(screenspace_v0, screenspace_v1);
				//printf("dist: %f\n", dist);
				if(dist<sizebb*4.0)
				{
					printf("SELECT EDGE: 2D EDGE FOUND.\n");

					volrender.measure_magnetline_edge=i;
					volrender.current_measure_vertindex=-1;
					volrender.measure_magnetline_vert_old=-1;
				}
			}
		}		
		if(volrender.measure_magnetline_edge!=-1)
		{
			Vector v0 = volrender.current_measure_points[volrender.current_edges[volrender.measure_magnetline_edge].v0];
			Vector v1 = volrender.current_measure_points[volrender.current_edges[volrender.measure_magnetline_edge].v1];
					
			gluProject((double)v0.x,(double)v0.y, (double)v0.z, volrender.mvmatrix, volrender.projmatrix, volrender.viewport, &dX, &dY, &dZ);
			Vector screenspace = Vector(dX, dY, dZ);

			//printf("sspace: %f, %f, %f\n", screenspace.x, screenspace.y, screenspace.z);

			Vector ssv2, ssv3;
			ssv2.x = ssv3.x = screenspace.x;
			ssv2.y = ssv3.y = screenspace.y;
			ssv2.z = 1.0;
			ssv3.z = 0.0;

			gluUnProject((double)ssv2.x, (double)ssv2.y, (double)ssv2.z, volrender.mvmatrix, volrender.projmatrix, volrender.viewport, &dX, &dY, &dZ);
			Vector v2 = Vector((float)dX, (float)dY, (float)dZ);

			gluUnProject((double)ssv3.x, (double)ssv3.y, (double)ssv3.z, volrender.mvmatrix, volrender.projmatrix, volrender.viewport, &dX, &dY, &dZ);
			Vector v3 = Vector((float)dX, (float)dY, (float)dZ);
	
			volrender.cutting_planes.planes[0]._v1 = (v0);
			volrender.cutting_planes.planes[0]._v2 = (v1);
			volrender.cutting_planes.planes[0]._v3 = (v2);
			volrender.cutting_planes.planes[0]._v4 = (v3);
			volrender.cutting_planes.planes[0].normal.get_normal(v0,v1,v2);

			volrender.cutting_planes.planes[0].eval_planeequation();
			volrender.cutting_planes.eval_planeintersections();
		}

		redraw_event();
	}
	else if(mode==4)	//RIGHT CLICK
	{
		if(volrender.current_measure_drawmode==6)
		{
			if(volrender.measure_magnetline_edge==-1)
			{
				volrender.measure_magnetline_vert_old = volrender.measure_magnetline_vert;
				emit measure_editpoint_select_signal(volrender.measure_magnetline_vert_old);
			}
			else
			{
				//printf("Deleting edge: %d\n", volrender.measure_magnetline_edge);
				if(volrender.measure_magnetline_edge!=0) volrender.current_edges.erase(volrender.current_edges.begin()+volrender.measure_magnetline_edge);
				else volrender.current_edges.erase(volrender.current_edges.begin());

				volrender.measure_magnetline_edge = -1;

			}
		}
	}

	if(volrender.cursor_toggle==1) sliceframe_updatepixel();

	//printf("imgspace: %d, %d\n", x,y);
	//printf("cursor3D_screenspace: %f, %f, %f\n", dX, dY, dZ);
	glDisable(GL_CULL_FACE);
}
void QtGLWidget::processClick(int x, int y, int mode)
{
	// This function will find 2 points in world space that are on the line into the screen defined by screenspace point (x,y)
	double dX, dY, dZ, dClickY; // glUnProject uses doubles, but I'm using floats for these 3D vectors
	//viewport[3]

	double offset = volrender.winWidth-volrender.winHeight;
	offset /= 2.0;

	dClickY = double (volrender.winWidth-(y+offset)); // OpenGL renders with (0,0) on bottom, mouse reports with (0,0) on top
	
	gluUnProject((double) x, dClickY, 0.0, volrender.mvmatrix, volrender.projmatrix, volrender.viewport, &dX, &dY, &dZ);
	Vector ClickRayP1 = Vector( (float) dX, (float) dY, (float) dZ );

	gluUnProject((double) x, dClickY, 1.0, volrender.mvmatrix, volrender.projmatrix, volrender.viewport, &dX, &dY, &dZ);
	Vector ClickRayP2 = Vector( (float) dX, (float) dY, (float) dZ );

	Vector vClickSlope;
	vClickSlope = ClickRayP2 - ClickRayP1;

	float fDistance = 9999999999999999999999999999.9;

	Vector v;
	Vector v1, v2, v3;
	Vector intersect;

	vector<Face> faces;

	if(volrender.measure_mode==0 && volrender.measure_editmode==0)
	{	
		//printf("Resetting selected...\n");
		for(int i=0; i<6; i++) volrender.cutting_planes.selected[i] = -1;
	}

	int selected=-1;
	for(int i=0; i<6; i++)
	{
		//printf("i: %d,  selected: %d \n", i, (int)volrender.cutting_planes.selected[i]);

		if(volrender.cutting_planes.selected[i]==1) selected = i;
	}
	//printf("selected: %d\n", (int) selected);
	
	if(selected!=-1)
	{
		//printf("Process Click, plane already selected\n");
		emit cutplane_enableplanepanel_signal();

		Face f;
		for(int j=1; j<volrender.cutting_planes.plane_clippoints[selected].size(); j++)
		{
			f.vert[0] = &volrender.cutting_planes.plane_clippoints[selected][j-1];
			f.vert[1] = &volrender.cutting_planes.plane_clippoints[selected][j];
			f.vert[2] = &volrender.cutting_planes.planes[selected].centre;	
			f.uv[0][0] = selected;

			faces.push_back(f);
		}

		f.vert[0] = &volrender.cutting_planes.plane_clippoints[selected][volrender.cutting_planes.plane_clippoints[selected].size()-1];
		f.vert[1] = &volrender.cutting_planes.plane_clippoints[selected][0];
		f.vert[2] = &volrender.cutting_planes.planes[selected].centre;
		f.uv[0][0] = selected;

		faces.push_back(f);
	
		bool b_intersection = false;
		Vector normal;
		for (int ii = 0; ii <faces.size(); ii++)
		{
			if(faces[ii].line_intersection(ClickRayP2, ClickRayP1, intersect))
			{
				Vector vSelSlope =  intersect - ClickRayP1;	
				float fTestDist = vSelSlope.length();

				if (fTestDist < fDistance)
				{
					fDistance = fTestDist;
					normal = faces[ii].facenormal;
					b_intersection=true;
				}
			}	
		}

		if(b_intersection==true)
		{
			if(volrender.measure_mode==1)
			{
				//printf("ADD POINT\n");

				if(volrender.current_measure_drawmode==1 && volrender.current_measure_points.size()>=2) return;
				if(volrender.current_measure_drawmode==5 && volrender.current_measure_points.size()>=2) return;

				volrender.current_normals.push_back(normal);
				volrender.current_measure_points.push_back(intersect);
				if(volrender.current_measure_drawmode==4) measure_evalcurrent_triangles_slot();
				emit measure_point_signal(intersect);
				emit measure_currentverts_signal(volrender.current_measure_points);
				emit measure_currentedges_signal(volrender.current_edges);
			}
			
			if(volrender.measure_editmode==1)
			{
				//printf("EDIT POINT\n");
				
				//if mode == clicked nb mode == 1 == drag...
				if(mode==0)
				{
					int selected = -1;
					for(int i=0; i<volrender.current_measure_points.size(); i++)
					{
						float sizebb = volrender.volobj->maxres/64.0f;
						if(sizebb<1.0) sizebb=1.0;
						sizebb=5.0;

						if(volrender.current_measure_points[i].x+sizebb > intersect.x)
						if(volrender.current_measure_points[i].x-sizebb < intersect.x)
						if(volrender.current_measure_points[i].y+sizebb > intersect.y)
						if(volrender.current_measure_points[i].y-sizebb < intersect.y)
						if(volrender.current_measure_points[i].z+sizebb > intersect.z)
						if(volrender.current_measure_points[i].z-sizebb < intersect.z)
						{
							selected = i;
						}
					}

					if(selected!=-1)
					{
						if(volrender.current_measure_drawmode==4) measure_evalcurrent_triangles_slot();
						emit measure_editpoint_select_signal(selected);
						return;
					}
				}

				if(volrender.current_measure_vertindex>=0 || volrender.current_measure_vertindex<volrender.current_measure_points.size()-1)
				{
					//printf("volrender.current_measure_vertindex: %d\n", volrender.current_measure_vertindex);
					volrender.current_measure_points[volrender.current_measure_vertindex] = intersect;
					volrender.current_normals[volrender.current_measure_vertindex] = normal;
					if(volrender.current_measure_drawmode==4) measure_evalcurrent_triangles_slot();

					emit measure_editpoint_signal(intersect);
				}
			}
		}	
	
	}
	else
	{
		//printf("Process Click, plane not selected\n");

		Face f;
		for(int sel=0; sel<6; sel++)
		{
			for(int j=1; j<volrender.cutting_planes.plane_clippoints[sel].size(); j++)
			{
				f.vert[0] = &volrender.cutting_planes.plane_clippoints[sel][j];
				f.vert[1] = &volrender.cutting_planes.plane_clippoints[sel][j-1];
				f.vert[2] = &volrender.cutting_planes.planes[sel].centre;
				f.uv[0][0] = sel;

				faces.push_back(f);
			}

			f.vert[0] = &volrender.cutting_planes.plane_clippoints[sel][volrender.cutting_planes.plane_clippoints[sel].size()-1];
			f.vert[1] = &volrender.cutting_planes.plane_clippoints[sel][0];
			f.vert[2] = &volrender.cutting_planes.planes[sel].centre;
			f.uv[0][0] = sel;

			faces.push_back(f);
		}
		//printf("selected: %d\n", selected);

		selected = -1;
		Vector normal;
		for (int ii = 0; ii <faces.size(); ii++)
		{
			if(faces[ii].line_intersection(ClickRayP2, ClickRayP1, intersect))
			{
				Vector vSelSlope =  intersect - ClickRayP1;
				float fTestDist = vSelSlope.length();

				if (fTestDist < fDistance)
				{
					fDistance = fTestDist;
					normal = faces[ii].facenormal;
					//volrender.intersect = intersect;
					selected = (int)faces[ii].uv[0][0];
				}
			}
		}

		//printf("selected: %d\n", selected);

		if(selected==-1) emit cutplane_selected_signal(0, -1);
		else
		{
			for(int iiii=0; iiii<6; iiii++) volrender.cutting_planes.selected[iiii] = 0;
			volrender.cutting_planes.selected[selected] = 1;
			emit cutplane_selected_signal(selected, volrender.plane_rendermode[selected]);
			emit cutplane_enableplanepanel_signal();
		}
	}

	redraw_event();
}

void QtGLWidget::dragEnterEvent(QDragEnterEvent* event)
{
	event->accept(Q3TextDrag::canDecode(event));
}
void QtGLWidget::dropEvent(QDropEvent* event)
{
	Q3StrList URIs;

	if ( Q3UriDrag::decode(event, URIs) ) 
	{
		QString text = Q3UriDrag::uriToLocalFile(URIs.getFirst());
		emit dragndrop_signal(text);
	}
}

//===========================================================================================================

void QtGLWidget::realign(void)
{
	PCA pca;
	int i;
	Vector v;
	int x0,y0,z0;
	int x,y,z;
	int r,g,b;
	int index;
	int index0;
	
	Q3ProgressDialog* progressbar = new Q3ProgressDialog("Recomputing Centre of the Volume Data...", "Cancel", volobject.texdepth*2, 0, "progress", TRUE);		
	progressbar->setCaption("Please Wait");
	progressbar->setMinimumDuration(10);

	for(z = 0; z <volobject.texdepth; z++)
	{	
		progressbar->setProgress(z);
		if (progressbar->wasCancelled()) break;

		for(x = 0; x <volobject.texwidth; x++)
		{
			for(y = 0; y <volobject.texheight; y++)
			{
				index = ((((z*volobject.texheight)+y)*volobject.texwidth)+x);

				r = volobject.texture3d[3*index+0];
				g = volobject.texture3d[3*index+1];
				b = volobject.texture3d[3*index+2];

				if(r+g+b>0)
				{
					v = Vector(x,y,z,index);
					pca.data.push_back(v);
				}
			}
		}
	}

	pca.eval_PCA();

	int volsize = 3*volobject.texdepth*volobject.texwidth*volobject.texheight;
	unsigned char* temptex = new unsigned char[volsize];
	
	for (i=0; i<volsize; i++)
	{
		temptex[i] = volobject.texture3d[i];
		volobject.texture3d[i]=0;
	}
	
	for (i=0; i<pca.aligned_data.size(); i++)
	{		
		x = pca.aligned_data[i].x+pca.originalmeanx;
		y = pca.aligned_data[i].y+pca.originalmeany;
		z = pca.aligned_data[i].z+pca.originalmeanz;
		index0 = pca.aligned_data[i].w;
		
		if(x>volobject.texwidth-1) x = volobject.texwidth-1;
		if(y>volobject.texheight-1) y = volobject.texheight-1;
		if(z>volobject.texdepth-1) z = volobject.texdepth-1;
		if(x<0) x = 0;
		if(y<0) y = 0;
		if(z<0) z = 0;
		
		index = ((((z*volobject.texheight)+y)*volobject.texwidth)+x);
		
		volobject.texture3d[3*index+0] = temptex[3*index0+0];
		volobject.texture3d[3*index+1] = temptex[3*index0+1];
		volobject.texture3d[3*index+2] = temptex[3*index0+2];
	}

	delete temptex;
	
	volio.pad(1.0);

	progressbar->setProgress(volobject.texdepth*2);
	delete progressbar;	
}
void QtGLWidget::recentre(void)
{
	int x,y,z;
	int x1,y1,z1;
	int r,g,b;
	int index=0;
	int index2=0;
	Vector v;
	Vector v1;
	Vector centre=Vector(0,0,0);
	int numbvox=1;

        float maxsize =  max(volobject.xsize, volobject.ysize);
        maxsize =  max(maxsize, volobject.zsize);

	Q3ProgressDialog* progressbar = new Q3ProgressDialog("Recomputing Centre of the Volume Data...", "Cancel", volobject.texdepth*2, 0, "progress", TRUE);		
	progressbar->setCaption("Please Wait");
	progressbar->setMinimumDuration(10);

	for(z = 0; z <volobject.texdepth; z++)
	{	
		progressbar->setProgress(z);

		if (progressbar->wasCancelled()) break;

		for(x = 0; x <volobject.texwidth; x++)
		{
			for(y = 0; y <volobject.texheight; y++)
			{
				index = ((((z*volobject.texheight)+y)*volobject.texwidth)+x);

				r=g=b=0;

				if(volobject.has_red) r = volobject.texture3d[3*index+0];
				if(volobject.has_green) g = volobject.texture3d[3*index+1];
				if(volobject.has_blue) b = volobject.texture3d[3*index+2];

				if(r+g+b>0)
				{
					v.x = x;
					v.y = y;
					v.z = z;
					v.w = 0;

                    v.x *= volobject.xsize/maxsize;
                    v.y *= volobject.ysize/maxsize;
                    v.z *= volobject.zsize/maxsize;

					v1 = Vector(x,y,z,0);
					centre += v1;
					numbvox++;
				}
			}
		}
	}

	Vector offset = Vector(volobject.texwidth/2.0, volobject.texheight/2.0, volobject.texdepth/2.0);
	//centre = centre - offset;
	centre /= (float)numbvox;
	centre = offset - centre;

	centre.x = int(centre.x+0.5);
	centre.y = int(centre.y+0.5);
	centre.z = int(centre.z+0.5);

	printf("%f, %f, %f\n", centre.x, centre.y, centre.z);

	int xend, zend, yend;
	int xbegin, zbegin, ybegin;
	int xincr, zincr, yincr;

	if(centre.z<=0)
	{
		zbegin = z = 0;
		zbegin=0;
		zend=volobject.texdepth-1;
		zincr=1;
	}
	else
	{
		z = volobject.texdepth-1;
		zbegin=z;
		zend=0;
		zincr=-1;
	}

	if(centre.y<=0)
	{
		y = 0;
		ybegin=0;
		yend=volobject.texheight-1;
		yincr=1;
	}
	else
	{
		y = volobject.texheight-1;
		ybegin=y;
		yend=0;
		yincr=-1;
	}

	if(centre.x<=0)
	{
		x = 0;
		xbegin=0;
		xend=volobject.texwidth-1;
		xincr=1;
	}
	else
	{
		x = volobject.texwidth-1;
		xbegin=x;
		xend=0;
		xincr=-1;
	}

	//now recentre the data.

	int zprog=0;
	while(z!=zend)
	{	
		progressbar->setProgress(volobject.texdepth+zprog);
		if (progressbar->wasCancelled()) break;

		while(x!=xend)
		{
			while(y!=yend)
			{
				x1 = x-(centre.x);
				y1 = y-(centre.y);
				z1 = z-(centre.z);

				if(x1>volobject.texwidth-1) x1 = volobject.texwidth-1;
				if(y1>volobject.texheight-1) y1 = volobject.texheight-1;
				if(z1>volobject.texdepth-1) z1 = volobject.texdepth-1;

				if(x1<0) x1 = 0;
				if(y1<0) y1 = 0;
				if(z1<0) z1 = 0;

				index = ((((z*volobject.texheight)+y)*volobject.texwidth)+x);
				index2 = ((((z1*volobject.texheight)+y1)*volobject.texwidth)+x1);

				volobject.texture3d[3*index+0] = volobject.texture3d[3*index2+0];
				volobject.texture3d[3*index+1] = volobject.texture3d[3*index2+1];
				volobject.texture3d[3*index+2] = volobject.texture3d[3*index2+2];
				y += yincr;
			}
			y=ybegin;
			x += xincr;
		}
		x=xbegin;
		z += zincr;
		zprog++;
	}
	
	//also pad the data to avoid texture boundary issues.
	volio.pad(1.0);

	progressbar->setProgress(volobject.texdepth*2);
	delete progressbar;
}
void QtGLWidget::invcrop(void)
{
	//printf("Applying CLIPPING planes... \n");
	int index=0;
	Vector v = Vector(0,0,0,0);
	
	Q3ProgressDialog* progressbar = new Q3ProgressDialog("Cropping the Volume Data...", "Cancel", volobject.texdepth, 0, "progress", TRUE);		
	progressbar->setCaption("Please Wait");
	progressbar->setMinimumDuration(10);

	float halfw = volobject.texwidth/2.0;
	float halfh = volobject.texheight/2.0;
	float halfd = volobject.texdepth/2.0;
	int r,g,b;

	float maxsize =  max(volobject.xsize, volobject.ysize);
	maxsize =  max(maxsize, volobject.zsize);

	Vector c;
	Vector res = Vector((volobject.xsize/maxsize), (volobject.ysize/maxsize), (volobject.zsize/maxsize));

	for(int z = 0; z <volobject.texdepth; z++)
	{	
		//progress(z, volobject.texdepth);
		progressbar->setProgress(z);
		if (progressbar->wasCancelled()) break;

		for(int x = 0; x <volobject.texwidth; x++)
		{
			for(int y = 0; y <volobject.texheight; y++)
			{
				index = ((((z*volobject.texheight)+y)*volobject.texwidth)+x);
				
				r = volobject.texture3d[3*index+0];
				g = volobject.texture3d[3*index+1];
				b = volobject.texture3d[3*index+2];

				if(r+g+b>0)
				{
					v.x = x-halfw;
					v.y = y-halfh;
					v.z = z-halfd;
					v.w = 0.0;

                                        v.x *= volobject.xsize/maxsize;
                                        v.y *= volobject.ysize/maxsize;
                                        v.z *= volobject.zsize/maxsize;

					int helper=0;
					for(int i=0; i<volrender.cutting_planes.planes.size(); i++)
					{
                                                c = volrender.cutting_planes.planes[i].centre;

						if(volrender.cutting_planes.planes[i].normal.dot(v-c)>0.0)
						{
							helper++;
						}
					}
					if(helper==6)
					{
						if(volrender.redclip_toggle==1) volobject.texture3d[3*index+0] = GLubyte(0);
						if(volrender.greenclip_toggle==1) volobject.texture3d[3*index+1] = GLubyte(0);
						if(volrender.blueclip_toggle==1) volobject.texture3d[3*index+2] = GLubyte(0); 						
					}
				}
			}
		}
	}

	progressbar->setProgress(volobject.texdepth);
	delete progressbar;	
}
void QtGLWidget::crop(void)
{
	//printf("Applying CLIPPING planes... \n");
	int index=0;
	Vector v = Vector(0,0,0,0);
	
	Q3ProgressDialog* progressbar = new Q3ProgressDialog("Cropping the Volume Data...", "Cancel", volobject.texdepth, 0, "progress", TRUE);		
	progressbar->setCaption("Please Wait");
	progressbar->setMinimumDuration(10);

	float halfw = volobject.texwidth/2.0;
	float halfh = volobject.texheight/2.0;
	float halfd = volobject.texdepth/2.0;
	int r,g,b;

	float maxsize =  max(volobject.xsize, volobject.ysize);
	maxsize =  max(maxsize, volobject.zsize);

	Vector c;
	Vector res = Vector((volobject.xsize/maxsize), (volobject.ysize/maxsize), (volobject.zsize/maxsize));

	for(int z = 0; z <volobject.texdepth; z++)
	{	
		//progress(z, volobject.texdepth);
		progressbar->setProgress(z);
		if (progressbar->wasCancelled()) break;

		for(int x = 0; x <volobject.texwidth; x++)
		{
			for(int y = 0; y <volobject.texheight; y++)
			{
				index = ((((z*volobject.texheight)+y)*volobject.texwidth)+x);
				
				r = volobject.texture3d[3*index+0];
				g = volobject.texture3d[3*index+1];
				b = volobject.texture3d[3*index+2];

				if(r+g+b>0)
				{
					v.x = x-halfw;
					v.y = y-halfh;
					v.z = z-halfd;
					v.w = 0.0;

					v.x *= volobject.xsize/maxsize;
					v.y *= volobject.ysize/maxsize;
					v.z *= volobject.zsize/maxsize;

					for(int i=0; i<volrender.cutting_planes.planes.size(); i++)
					{
						c = volrender.cutting_planes.planes[i].centre;

						if(volrender.cutting_planes.planes[i].normal.dot(v-c)<0.0 && v.w!=-1.0)
						{
							v.w = -1.0;

							if(volrender.redclip_toggle==1) volobject.texture3d[3*index+0] = GLubyte(0);
							if(volrender.greenclip_toggle==1) volobject.texture3d[3*index+1] = GLubyte(0);
							if(volrender.blueclip_toggle==1) volobject.texture3d[3*index+2] = GLubyte(0); 
						}
					}
				}
			}
		}
	}

	progressbar->setProgress(volobject.texdepth);
	delete progressbar;
}
void QtGLWidget::transfer_function( vector<Vector> cp, float graphsize, float border, int mode)
{
	if(volobject.texture3d==NULL) return;
	int size = volobject.texwidth * volobject.texheight * volobject.texdepth * 3;

	double rvalue=0;
	double gvalue=0;
	double bvalue=0;
	double avalue=0;
	double new_value=0;

	float max_func = (256+cp[0].z);

	printf("Applying TRANSFER FUNCTION to volume... \n");

	border -=0.5;

//	undo_volobject = volobject;

	for(int i=0; i<size; i+=3)
	{
		rvalue = (int)volobject.texture3d[i+0];
		gvalue = (int)volobject.texture3d[i+1];
		bvalue = (int)volobject.texture3d[i+2];
	//	avalue = (int)volobject.texture3d[i+3];

		progress(i, size);

		//Luminance
		if(mode==1)
		{
			new_value = 255-(cp[rvalue].y-border);				
			volobject.texture3d[i+0] = int(new_value+0.5);
			
			new_value = 255-(cp[gvalue].y-border);				
			volobject.texture3d[i+1] = int(new_value+0.5);

			new_value = 255-(cp[bvalue].y-border);				
			volobject.texture3d[i+2] = int(new_value+0.5);
		}
	/*	//Alpha
		if(mode==2)
		{
			new_value = 255-(cp[avalue].y-border);
			volobject.texture3d[i+3]= int(new_value+0.5);
		}*/
/*		//R
		if(mode==3)
		{
			new_value = 255-(cp[rvalue].y-border);
			volobject.texture3d[i+0] = int(new_value+0.5);
		}
		//G
		if(mode==4)
		{
			new_value = 255-(cp[gvalue].y-border);
			volobject.texture3d[i+1] = int(new_value+0.5);
		}
		//B
		if(mode==5)
		{
			new_value = 255-(cp[bvalue].y-border);
			volobject.texture3d[i+2] = int(new_value+0.5);
		}
	/*	//A
		if(mode==6)
		{
			new_value = 255-(cp[avalue].y-border);
			volobject.texture3d[i+3] = int(new_value+0.5);
		}*/
	}
	 
	printf("\n");

	volrender.load_TextureMap();
	redraw_event();
}
void QtGLWidget::gaussian(int size, float sigma)
{
	if(volobject.texwidth==1 || volobject.texheight==1 || volobject.texdepth==1) return;

	Filter filter;
	filter.volobj = &volobject;
	filter.apply_gaussian3D(size, sigma, 1.0);	
	filter.volobj = 0;

	volrender.load_TextureMap();
	redraw_event();
}
void QtGLWidget::sobel(void)
{
	if(volobject.texwidth==1 || volobject.texheight==1 || volobject.texdepth==1) return;

	Filter filter;
	filter.volobj = &volobject;
	filter.apply_sobel3D(SOBEL_HVD);	
	filter.volobj = 0;

	volrender.load_TextureMap();
	redraw_event();
}
void QtGLWidget::unsharp_slot(int size, float sigma, int bright, int cont)
{
	if(volobject.texture3d==NULL) return;

	Filter filter;
	filter.volobj = &volobject;
	filter.apply_unsharpmask3D(-bright, -cont, sigma, size);	
	filter.volobj = 0;

	volrender.load_TextureMap();
	emit frames_redraw_signal();
	redraw_event();
}
void QtGLWidget::thresholdmin_slot(int value)
{
/*	if(volobject.texture3d==NULL) return;
    glEnable(GL_ALPHA_TEST);
	glAlphaFunc(GL_GREATER, (float)(value)/255.0);

	redraw_event();*/
}
void QtGLWidget::thresholdmax_slot(int value)
{
/*	if(volobject.texture3d==NULL) return;
	glEnable(GL_ALPHA_TEST);
	glAlphaFunc(GL_LESS, (float)(value)/255.0);
	redraw_event();*/
}
void QtGLWidget::threshold_slot(int min, int max)
{
	if(volobject.texture3d==NULL) return;

//	threshold(min, max);
//	emit frames_redraw_signal();	
	redraw_event();
}
void QtGLWidget::brightcontrast_slot(int b, int c)
{
	if(volobject.texture3d==NULL) return;

//	undo_volobject = volobject;

	int size = 3*volobject.texwidth * volobject.texheight * volobject.texdepth;

	printf("Applying Brightness & Contrast to volume... \n");

//	undo_volobject = volobject;

	float K_os =   (float)b/100.0;
	float K_oe = (float)c/100.0;

//	printf("%f, %f\n", K_os, K_oe);

	float value;
	for(int i=0; i<size; i++)
	{
		value = (float)volobject.texture3d[i];

		if(value)
		{
			value = pow((K_os*value),K_oe);

			if(value<0) value = 0;
			if(value>255) value = 255;

			volobject.texture3d[i] = value;
		}
	}

	volrender.load_TextureMap();
//	emit frames_redraw_signal();
	redraw_event();
}
void QtGLWidget::make_filter(void)
{
	printf("Filtering...\n");

	Filter filt;
	filt.volobj = &volobject;

//	filt.auto_levels();
//	filt.apply_contrast_stretching();
	
	filt.apply_median(1.0);
	//filt.apply_median(4.0);

	//filt.auto_levels();
	//filt.apply_median(2.0);
	//filt.apply_median(3.0);

	//filt.apply_median(4.0);
	//filt.apply_median(8.0);
	//filt.apply_mean(2.0);

	printf("Loading Texture...\n");
	volrender.load_TextureMap();

	emit frames_redraw_signal();
	redraw_event();
}

void QtGLWidget::make_vertfinder(void)
{

	Floodfill ffill;
	ffill.volobj = &volobject;
	ffill.volio = &volio;
	ffill.floodfill_peal(10);
	
/*
        Filter filt;
        filt.volobj = &volobject;

        printf("Thresholding...\n");
        for(int z = 0; z <volobject.texdepth; z++)
        {
                for(int x = 0; x <volobject.texwidth; x++)
                {
                        for(int y = 0; y <volobject.texheight; y++)
                        {
                                        int index1d = ((((z*volobject.texheight)+y)*volobject.texwidth)+x);
                                        int voxel = volrender.ragaba_tfunc[3*volobject.texture3d[3*index1d+0]];

                                        if(voxel>volrender.la_tmin)
                                        {
                                                volobject.texture3d[3*index1d+0] = 255;
                                                volobject.texture3d[3*index1d+1] = 255;
                                                volobject.texture3d[3*index1d+2] = 255;
                                        }
                                        else
                                        {
                                                volobject.texture3d[3*index1d+0] = 0;
                                                volobject.texture3d[3*index1d+1] = 0;
                                                volobject.texture3d[3*index1d+2] = 0;
                                        }
                        }
                }
        }


       // printf("Appling Sobel...\n");
        //filt.apply_sobel3D(SOBEL_HV);

        printf("Appling Harris Corner Detector...\n");
  //      filt.apply_gaussian3D(3.0, 1.0, 100.0);
        filt.apply_harriscorner();
*/
     printf("Loading Texture...\n");
	volrender.cutting_planes.save("temp.slc");
	volrender.load_TextureMap();
	volrender.cutting_planes.load("temp.slc");

	emit frames_redraw_signal();
	redraw_event();
}

void QtGLWidget::make_binary(void)
{
	volrender.cutting_planes.save("temp.slc");

	/*vector<bool> c;
	c.push_back(false);
	c.push_back(false);
	c.push_back(true);
	
	filter_slot(1,3,2.0,1,c);*/

	Floodfill ffill;
	ffill.volobj = &volobject;
	ffill.volio = &volio;
	ffill.floodfill_peal2(10, volrender.cutting_planes);
		
    printf("Loading Texture...\n");
	volrender.load_TextureMap();

	volrender.cutting_planes.load("temp.slc");

	emit frames_redraw_signal();
	redraw_event();
//	printf("Filtering...\n");
//	Filter filt;
//	filt.volobj = &volobject;
//	filt.auto_levels();
//	filt.apply_contrast_stretching();
//	filt.apply_median(4.0);
/*
	printf("Thresholding...\n");
	for(int z = 0; z <volobject.texdepth; z++)
	{	
		for(int x = 0; x <volobject.texwidth; x++)
		{
			for(int y = 0; y <volobject.texheight; y++)
			{
					int index1d = ((((z*volobject.texheight)+y)*volobject.texwidth)+x);	
					int voxel = volrender.ragaba_tfunc[3*volobject.texture3d[3*index1d+0]];
					
					if(voxel>volrender.la_tmin)
					{
						volobject.texture3d[3*index1d+0] = 0;
						volobject.texture3d[3*index1d+1] = 255;
						volobject.texture3d[3*index1d+2] = 0;
					}
					else
					{
						volobject.texture3d[3*index1d+0] = 0;
						volobject.texture3d[3*index1d+1] = 0;
						volobject.texture3d[3*index1d+2] = 255;						
					}
			}
		}
	}
	
	printf("Labelling...\n");

	Floodfill ffill;
	ffill.volobj = &volobject;
	ffill.volio = &volio;
	ffill.floodfill(COLOUR_RULE);
	ffill.apply_result();
	ffill.delete_visited();
	
	for(int i=0; i<volrender.time_celleigenvectors.size(); i++)
	{
		volrender.time_celleigenvectors[i].clear();
		volrender.time_cellmeans[i].clear();
	}
	volrender.time_celleigenvectors.clear();
	volrender.time_cellmeans.clear();

	for(int i=0; i<ffill.celleigenvectors.size(); i++)
	{
		volrender.celleigenvectors.push_back(ffill.celleigenvectors[i]);
		volrender.cellmeans.push_back(ffill.cellmeans[i]);
	}
	volrender.time_celleigenvectors.push_back(volrender.celleigenvectors);
	volrender.time_cellmeans.push_back(volrender.cellmeans);
	volrender.celleigenvectors.clear();
	volrender.cellmeans.clear();
	
	//volio.pad(5);
	
	Vector v;
	
	volrender.time_celledges.resize(1);
	volrender.time_celledges[0].resize(volrender.time_cellmeans[0].size());
	
	for(int j=0; j<volrender.time_celledges[0].size(); j++)
		volrender.time_celledges[0][j].resize(volrender.time_cellmeans[0].size());
	
	for(int i=0; i<volrender.time_celledges[0].size(); i++)
		for(int j=0; j<volrender.time_celledges[0][i].size(); j++)
			volrender.time_celledges[0][i][j]=false;

	printf("\nFinding Neighbours...\n");
	
	ffill.eval_connectivity();
	
	for(int z = 0; z <ffill.edges.size(); z++)
	{	
		for(int x = 0; x <ffill.edges[z].size(); x++)
		{
			for(int y = 0; y <ffill.edges[z][x].size(); y++)
			{
				volrender.time_celledges[z][3*x][3*y] = ffill.edges[z][x][y];
			}
		}
	}
			
/*	Vector x_axis = Vector(1,0,0);
	Vector y_axis = Vector(0,1,0);
	Vector z_axis = Vector(0,0,1);
	Matrix4x4 rot;
	Vector eigenvec0;
	Vector eigenvec1;
	Vector eigenvec2;
	
	for(int j=0; j<volrender.time_cellmeans.size(); j++)
	{
		for(int k=0; k<volrender.time_cellmeans[j].size()/3; k++)
		{
			Vector mean = volrender.time_cellmeans[j][3*k];
			
			for(int i=0; i<volrender.time_cellmeans[j].size()/3; i++)
			{
				if(i!=k)
				{
					v = mean-volrender.time_cellmeans[j][3*i];
					eigenvec0 = volrender.time_celleigenvectors[j][3*i+0];
					eigenvec1 = volrender.time_celleigenvectors[j][3*i+1];
					eigenvec2 = volrender.time_celleigenvectors[j][3*i+2];
					
					//rot.find_rotationfromaxis(x_axis, y_axis, z_axis, eigenvec0, eigenvec1, eigenvec2);
					//v = rot*v;
					
					volrender.time_celledges[0][3*k][3*i] = false;
					volrender.time_celledges[0][3*k][3*i+1] = false;
					volrender.time_celledges[0][3*k][3*i+2] = false;

					float len = (0.75*volrender.time_celleigenvectors[j][3*i].length())+volrender.time_celleigenvectors[j][3*i+1].length()+volrender.time_celleigenvectors[j][3*i+2].length();
					len /= 3.0;
					
					printf("vlength: %f, meansl: %f \n", v.length(), len*3.0);
					if(v.length()<(len*3.0))
					{
						printf("EDGE FOUND!\n");
						volrender.time_celledges[0][3*k][3*i] = true;
					}
				}
			}
		}
	}
	*/
/*
	printf("Loading Texture...\n");
	volrender.load_TextureMap();

	ofstream fout;										// Here we create an ofstream and we will call it "fout", like "cout".
	fout.open("Cells.txt");								// We call a function from our ofstream object called open().

	for(int i=0; i<volrender.time_celleigenvectors.size(); i++)
	{
		fout<<"TIMEPOINT: "<<i<<endl;
		for(int j=0; j<volrender.time_celleigenvectors[i].size()/3; j++)
		{
			//if(volrender.time_celleigenvectors[i][3*j+1].length()>40)
			{
				fout<<"\tCELLID: "<<j<<endl;
				fout<<"\t\tMEAN:"<<endl;
				fout<<"\t\t"<<volrender.time_cellmeans[i][3*j+0].x<<" "<<volrender.time_cellmeans[i][3*j+0].y<<" "<<volrender.time_cellmeans[i][3*j+0].z<<endl;
				fout<<"\t\tEIGENVECTORS:"<<endl;
				fout<<"\t\t"<<volrender.time_celleigenvectors[i][3*j+0].x<<" "<<volrender.time_celleigenvectors[i][3*j+0].y<<" "<<volrender.time_celleigenvectors[i][3*j+0].z<<endl;
				fout<<"\t\t"<<volrender.time_celleigenvectors[i][3*j+1].x<<" "<<volrender.time_celleigenvectors[i][3*j+1].y<<" "<<volrender.time_celleigenvectors[i][3*j+1].z<<endl;
				fout<<"\t\t"<<volrender.time_celleigenvectors[i][3*j+2].x<<" "<<volrender.time_celleigenvectors[i][3*j+2].y<<" "<<volrender.time_celleigenvectors[i][3*j+2].z<<endl;
				fout<<"\t\tLENGTHS:"<<endl;
				fout<<"\t\t"<<volrender.time_celleigenvectors[i][3*j+0].length()<<" "<<volrender.time_celleigenvectors[i][3*j+1].length()<<" "<<volrender.time_celleigenvectors[i][3*j+2].length()<<endl;
			}
		}
	}
	fout.close();
	
	emit frames_redraw_signal();
	redraw_event();*/
}
void QtGLWidget::setcurrentworkingdir_slot(QString dn)
{
	currentworkingdir = dn;
}

//===========================================================================================================

void QtGLWidget::hist_reset_transfer_function_parameters_slot(int _r_tmin, int _r_tmax, int _g_tmin, int _g_tmax, int _b_tmin, int _b_tmax, int _ra_tmin, int _ra_tmax, int _ga_tmin, int _ga_tmax, int _ba_tmin, int _ba_tmax,
													int _r_bright, int _r_cont, int _g_bright, int _g_cont, int _b_bright, int _b_cont, int _ra_bright, int _ra_cont, int _ga_bright, int _ga_cont, int _ba_bright, int _ba_cont,
													bool _inv_r,	bool _inv_g, bool _inv_b, bool _inv_ra, bool _inv_ga, bool _inv_ba)
{
//	printf("RESET\n");
	volrender.reset_transfer_function_parameters(_r_tmin, _r_tmax, _g_tmin, _g_tmax, _b_tmin, _b_tmax, _ra_tmin, _ra_tmax, _ga_tmin, _ga_tmax, _ba_tmin, _ba_tmax,
														_r_bright, _r_cont, _g_bright, _g_cont, _b_bright, _b_cont, _ra_bright, _ra_cont, _ga_bright, _ga_cont, _ba_bright, _ba_cont,
														_inv_r,	_inv_g, _inv_b, _inv_ra, _inv_ga, _inv_ba);

	redraw_event();
}
void QtGLWidget::hist_tfunc_slot(const vector<Vector>& tfunc_curvepts, float graphsize, float border, int mode, int slice_toggle)
{

	volrender.apply_transfer_function(tfunc_curvepts, graphsize, border, mode);
	
//	if(slice_toggle) emit frames_redraw_signal();
	redraw_event();
}
void QtGLWidget::hist_transfer_function_all_slot(const vector<Vector>& r_tfunc_curvepts,  const vector<Vector>& g_tfunc_curvepts,  const vector<Vector>& b_tfunc_curvepts, 
			          					    const vector<Vector>& ra_tfunc_curvepts, const vector<Vector>& ga_tfunc_curvepts, const vector<Vector>& ba_tfunc_curvepts,
									        float graphsize, float border)
{
	//	printf("transfer_function_all_slot\n");
	volrender.apply_transfer_function_all(r_tfunc_curvepts, g_tfunc_curvepts, b_tfunc_curvepts, ra_tfunc_curvepts, ga_tfunc_curvepts, ba_tfunc_curvepts, graphsize, border);
	redraw_event();

	//	emit frames_redraw_signal();
}
void QtGLWidget::hist_tfunc16bit_slot(const vector<Vector>& controlpnts, float graphsize, float border, int mode, int slice_toggle)
{
/*	printf("hist_tfunc16bit_slot\n");
	
	printf("controlpnts.size(): %d \n", controlpnts.size());	
	printf("graphsize: %d \n", graphsize);	
	printf("border: %d \n", border);	
	printf("mode: %d \n", mode);	
	printf("slice_toggle: %d \n", slice_toggle);

	BSpline bspline;
		
	bspline.poly_degree = 3;
	bspline.num_control_points = controlpnts.size();
	bspline.num_curve_points = 65536;

	bspline.control_points.clear();
	bspline.control_points.resize(bspline.num_control_points);

	for(int i=0; i<controlpnts.size(); i++)
	{	
			bspline.control_points[i] = controlpnts[i];
	}
	
	bspline.compute();

	/*for(int i=0; i<bspline.curve_points.size(); i++)
	{
		bspline.curve_points[i].y *= 256;	
//		printf("bspline[ %d ]: %f\n", i, bspline.curve_points[bspline.curve_points.size()-i].y);
	}*/

	/*for(int i=0; i<256; i++)
	{
		printf("bspline[ %d ]: %f\n", i, bspline.curve_points[bspline.curve_points.size()-(i*256)].y);
	}*/
/*		
	int index=0;
	int index2d=0;
	uint16 indexlookup16bitR=0;
	uint16 indexlookup16bitG=0;
	uint16 indexlookup16bitB=0;
		
	printf("la_tmin: %d\n", volrender.la_tmin);
	printf("la_tmax: %d\n", volrender.la_tmax);

	uint16 minthresh = (volrender.la_tmin/255.0) * 65535;
	uint16 maxthresh = (volrender.la_tmax/255.0) * 65535;
	uint16 range = maxthresh - minthresh;
	uint16 value=0;
	
	int value8bit=0;
	
	printf("la_tmin 16bit: %d\n", minthresh);
	printf("la_tmax 16bit: %d\n", maxthresh);
	printf("range 16bit: %d\n", range);

	printf("z: %d texdepth: %d \n", volobject.voldatasize, volobject.texdepth);

	Q3ProgressDialog* progressbar = new Q3ProgressDialog("Remapping 16bit data to 8bit...", "Cancel", volobject.texdepth, 0, "progress", TRUE);		
	progressbar->setCaption("Please Wait");

	for(int z=0; z<volobject.texdepth; z++)
	{
		//update our progress bar
		progressbar->setProgress((int)z);
		if (progressbar->wasCancelled())
			break;

		for(int y=0; y<volobject.texheight; y++)
		{
			for(int x=0; x<volobject.texwidth; x++)
			{
				index = (((z*volobject.texheight)+y)*volobject.texwidth)+x;
				index2d = (y*volobject.texwidth)+x;

				indexlookup16bitR = volobject.voldata[z][index2d];
//				indexlookup16bitG = volobject.voldata[z][3*index2d+1];
	//			indexlookup16bitB = volobject.voldata[z][3*index2d+2];

				//value = 256-bspline.curve_points[indexlookup16bitR].y;
				
				value = indexlookup16bitR;
				 
				//	printf("original: %f\n", value);

				if(value<minthresh) value = 0.0;
				if(value>maxthresh) value = 0.0;

				//printf("thresholded value: %f\n", value);
				
			//	if(value!=0.0)
			//	{
					if(value>minthresh) value = value - minthresh;
					
					value8bit = ((float)value/(float)range)*255.0;
			//	}
				//printf("rescaled value: %f\n", value);
				
				volobject.texture3d[3*index+0] = 
				volobject.texture3d[3*index+1] = 
				volobject.texture3d[3*index+2] = (int)(value8bit+0.5);

				/*volobject.texture3d[3*index+0] = int(256-bspline.curve_points[indexlookup16bitR].y);
				volobject.texture3d[3*index+1] = int(256-bspline.curve_points[indexlookup16bitR].y);
				volobject.texture3d[3*index+2] = int(256-bspline.curve_points[indexlookup16bitR].y);*/
	/*		}
		}	
	}

	progressbar->setProgress(volobject.texdepth);
	delete progressbar;
	progressbar=NULL;
	
	volrender.load_3DTextureMap();
	redraw_event();*/
}

//===========================================================================================================

void QtGLWidget::isosurface_new_slot(QString name, int quality, int value, int smooth, Vector col, bool* channels, int clipstate)
{
	//printf("isosurface_new_slot\n");
	
//	VolumeObject	filteredvolobject;
//	filteredvolobject = volobject;

//	filteredvolobject.resize((float)quality/100.0f);
//	quality=100;

	float size = 1.0;
	float sigma = 1.0;

	if(smooth==25)
	{
		size = 3.0;
		sigma = 0.5;
	}
	else if(smooth==50)
	{
		size = 3.0;
		sigma = 1.5;
	}
	else if(smooth==75)
	{
		size = 3.0;
		sigma = 2.5;
	}
	else if(smooth==100)
	{
		size = 3.0;
		sigma = 3.5;
	}
	else
	{
		smooth=0.0;
		size = 1.0;
		sigma = 1.0;
	}
		
	printf("smooth: %f\n", smooth);
	printf("size: %f\n", size);
	printf("sigma: %f\n", sigma);
	
	/*if(smooth!=0)
	{
		//printf("smooth %d\n", smooth);
		Filter filt;
		filt.volobj = &volobject;
		filt.apply_gaussian3D(size, sigma, quality);
	}*/

	//printf("isosurface_new_slot\n");

	mcubes.mesh = volrender.meshlist.new_mesh();
	mcubes.volobj = &volobject;
	
	if(smooth==0) mcubes.vMarchingCubes(channels, quality, value, volrender.ragaba_tfunc);
	else mcubes.vMarchingCubes(channels, quality, value, volrender.ragaba_tfunc, size, sigma);

	float maxsize =  max((float) mcubes.volobj->texwidth, (float)mcubes.volobj->texheight);
	maxsize =  max((int)maxsize, (int)mcubes.volobj->texdepth);
	Vector vscale = Vector(1.0/(maxsize/(float)mcubes.volobj->texwidth),1.0/(maxsize/(float)mcubes.volobj->texdepth),  1.0/(maxsize/(float)mcubes.volobj->texheight));
	
	maxsize =  max(mcubes.volobj->xsize, mcubes.volobj->ysize);
	maxsize =  max(maxsize, mcubes.volobj->zsize);
	Vector voxrescale = Vector(mcubes.volobj->xsize/maxsize, mcubes.volobj->zsize/maxsize, mcubes.volobj->ysize/maxsize);

	vscale = vscale*voxrescale;
	mcubes.mesh->scalev(vscale);

	volrender.meshlist.add(name, col, quality, value, size, sigma, clipstate);

	//safe to clear our mcubes data now
	mcubes.clear();
	
	mcubes.mesh = NULL;
	mcubes.volobj = NULL;

	//volrender.load_TextureMap();

	emit frames_redraw_signal();
	redraw_event();
}
void QtGLWidget::isosurface_get_slot(QString name, int* quality, int* value, int* smooth, Vector* col, int* nv, int* nf, int* clipstate)
{

	float size = 0.0;
	float sigma = 0.0;
	
	volrender.meshlist.get(name, quality, value, &size, &sigma, col, nv, nf, clipstate);

	if(size==3.0&&sigma==0.5)
	{
		*smooth = 25;
	}
	else if(size==3.0&&sigma==1.5)
	{
		*smooth = 50;
	}
	else if(size==3.0&&sigma==2.5)
	{
		*smooth = 75;
	}
	else if(size==3.0&&sigma==3.5)
	{
		*smooth = 100;
	}
	

//	emit isosurface_get_signal();
	redraw_event();
}
void QtGLWidget::isosurface_del_slot(QString name)
{
	volrender.meshlist.del(name);

	//emit redraw event
	redraw_event();
}
void QtGLWidget::isosurface_update_slot(QString oldname, QString name, int quality, int value, int smooth, Vector col, bool* channels, int clpst)
{
	float size = 1.0;
	float sigma = 1.0;

	if(smooth==25)
	{
		size = 3.0;
		sigma = 0.5;
	}
	else if(smooth==50)
	{
		size = 3.0;
		sigma = 1.5;
	}
	else if(smooth==75)
	{
		size = 3.0;
		sigma = 2.5;
	}
	else if(smooth==100)
	{
		size = 3.0;
		sigma = 3.5;
	}

	int index = volrender.meshlist.set(oldname, name, quality, value, size, sigma, col, clpst);

	//if val or qual has been changed recompute iso-surface for index
	if(index!=-1)
	{
	//	volrender.meshlist.del(name);
	//	isosurface_new_slot(name, quality, value, smooth, col, channels, clpst);
		
		/*if(smooth!=0)
		{
			Filter filt;
			filt.volobj = &volobject;
			filt.apply_gaussian3D(3.0, 2.0, quality);
		}*/
		
		printf("update2!!\n");
		
		mcubes.mesh = NULL;
		volrender.meshlist.meshes[index].reset();
		mcubes.mesh = &volrender.meshlist.meshes[index];
		mcubes.volobj = &volobject;
		//mcubes.vMarchingCubes(channels, quality, value, volrender.rgb_tfunc, size, sigma);

		if(smooth==0) mcubes.vMarchingCubes(channels, quality, value, volrender.ragaba_tfunc);
		else mcubes.vMarchingCubes(channels, quality, value, volrender.ragaba_tfunc, size, sigma);

		float maxsize =  max(mcubes.volobj->texwidth, mcubes.volobj->texheight);
		maxsize =  max((float)maxsize, (float)mcubes.volobj->texdepth);
		Vector vscale = Vector(1.0/(maxsize/(float)mcubes.volobj->texwidth),1.0/(maxsize/(float)mcubes.volobj->texdepth),  1.0/(maxsize/(float)mcubes.volobj->texheight));
		
		maxsize =  max(mcubes.volobj->xsize, mcubes.volobj->ysize);
		maxsize =  max(maxsize, mcubes.volobj->zsize);
		Vector voxrescale = Vector(mcubes.volobj->xsize/maxsize, mcubes.volobj->zsize/maxsize, mcubes.volobj->ysize/maxsize);

		vscale = vscale*voxrescale;
		mcubes.mesh->scalev(vscale);

		//update mesh
		volrender.meshlist.meshes[index].glextensions = volrender.meshlist.glextensions;
		volrender.meshlist.meshes[index].init_vbo();

		//reset
		mcubes.clear();
		mcubes.volobj = NULL;
		mcubes.mesh = NULL;
	}

	//emit redraw event
	redraw_event();
}
void QtGLWidget::isosurface_load_slot(QString fn)
{
	printf("isosurface_load_slot\n");

	Q3ProgressDialog* progressbar = new Q3ProgressDialog("Loading OBJ file...", "Cancel", 2, 0, "progress", TRUE);		
	progressbar->setCaption("Please Wait");
    progressbar->setProgress(1);

	volrender.meshlist.load(fn);

	isosurface_addnew_signal(volrender.meshlist.names[volrender.meshlist.names.size()-1], volrender.meshlist.colours[volrender.meshlist.names.size()-1]);
   
	progressbar->setProgress(2);
	delete progressbar;
	progressbar=NULL;
}
void QtGLWidget::isosurface_save_slot(void)
{
	printf("isosurface_save_slot\n");

	QString fn = QFileDialog::getExistingDirectory ( this, "Please pick a save directory.", currentworkingdir, QFileDialog::ShowDirsOnly | QFileDialog::DontResolveSymlinks);
	if(fn.isEmpty()) return;
	
	fn+="/";
	
	volrender.meshlist.save(fn);
}
void QtGLWidget::isosurface_crop_slot(int selected)
{
	printf("selected: %d\n", selected);
	if(volobject.texture3d==NULL) return;

	int index=0;
	Vector v = Vector(0,0,0,0);
	
	Q3ProgressDialog* progressbar = new Q3ProgressDialog("Cropping the Volume Data...", "Cancel", volobject.texdepth, 0, "progress", TRUE);		
	progressbar->setCaption("Please Wait");
	progressbar->setMinimumDuration(10);

	float halfw = volobject.texwidth/2.0;
	float halfh = volobject.texheight/2.0;
	float halfd = volobject.texdepth/2.0;
	int r,g,b;

	int v0, v1, v2;
	float maxsize =  max(volobject.xsize, volobject.ysize);
	maxsize =  max(maxsize, volobject.zsize);

	Vector c;
	Vector res = Vector((volobject.xsize/maxsize), (volobject.ysize/maxsize), (volobject.zsize/maxsize));

	for(int i=0; i<volrender.meshlist.meshes[selected].nf; i++)
	{
		v0 = volrender.meshlist.meshes[selected].localfaces[i].vertindex[0];
		v1 = volrender.meshlist.meshes[selected].localfaces[i].vertindex[1];
		v2 = volrender.meshlist.meshes[selected].localfaces[i].vertindex[2];
		
		volrender.meshlist.meshes[selected].localfaces[i].facenormal.get_normal(volrender.meshlist.meshes[selected].vert[v0], volrender.meshlist.meshes[selected].vert[v1], volrender.meshlist.meshes[selected].vert[v2]);
	}
	
	for(int z = 0; z <volobject.texdepth; z++)
	{	
		//progress(z, volobject.texdepth);
		progressbar->setProgress(z);
		if (progressbar->wasCancelled()) break;

		for(int x = 0; x <volobject.texwidth; x++)
		{
			for(int y = 0; y <volobject.texheight; y++)
			{
				index = ((((z*volobject.texheight)+y)*volobject.texwidth)+x);
				
				r = volobject.texture3d[3*index+0];
				g = volobject.texture3d[3*index+1];
				b = volobject.texture3d[3*index+2];

				if(r+g+b>0)
				{
					v.x = x-halfw;
					v.y = y-halfh;
					v.z = z-halfd;
					v.w = 0.0;
					
					for(int i=0; i<volrender.meshlist.meshes[selected].nf; i++)
					{
						v0 = volrender.meshlist.meshes[selected].localfaces[i].vertindex[0];
						v1 = volrender.meshlist.meshes[selected].localfaces[i].vertindex[1];
						v2 = volrender.meshlist.meshes[selected].localfaces[i].vertindex[2];
						
						c = volrender.meshlist.meshes[selected].vert[v0]+volrender.meshlist.meshes[selected].vert[v1]+volrender.meshlist.meshes[selected].vert[v2];
						c /= 3.0;
												
						if(volrender.meshlist.meshes[selected].localfaces[i].facenormal.dot(v-c)<0.0)
						{
							//printf("BOH\n");
							if(volrender.redclip_toggle==1) volobject.texture3d[3*index+0] = GLubyte(0);
							if(volrender.greenclip_toggle==1) volobject.texture3d[3*index+1] = GLubyte(0);
							if(volrender.blueclip_toggle==1) volobject.texture3d[3*index+2] = GLubyte(0); 							
						}
					}
					
					/*for(int i=0; i<volrender.cutting_planes.planes.size(); i++)
					{
						c = volrender.cutting_planes.planes[i].centre/res;

						if(volrender.cutting_planes.planes[i].normal.dot(v-c)<0.0 && v.w!=-1.0)
						{
							v.w = -1.0;

							if(volrender.redclip_toggle==1) volobject.texture3d[3*index+0] = GLubyte(0);
							if(volrender.greenclip_toggle==1) volobject.texture3d[3*index+1] = GLubyte(0);
							if(volrender.blueclip_toggle==1) volobject.texture3d[3*index+2] = GLubyte(0); 
						}
					}*/
				}
			}
		}
	}

	progressbar->setProgress(volobject.texdepth);
	delete progressbar;

	volrender.load_TextureMap();

	emit frames_redraw_signal();
	redraw_event();

}
//===========================================================================================================

void QtGLWidget::tfunc_collapse_slot(void)
{
	if(volobject.texture3d==NULL) return;

	//printf("Applying CLIPPING planes... \n");
	int index=0;
	int r,g,b;

	Q3ProgressDialog* progressbar = new Q3ProgressDialog("Collapsing the Volume Data to a Single Channel...", "Cancel", volobject.texdepth, 0, "progress", TRUE);		
	progressbar->setCaption("Please Wait");
	progressbar->setMinimumDuration(10);

	for(int z = 0; z <volobject.texdepth; z++)
	{	
		//progress(z, volobject.texdepth);
		progressbar->setProgress(z);

		if (progressbar->wasCancelled()) break;

		for(int x = 0; x <volobject.texwidth; x++)
		{
			for(int y = 0; y <volobject.texheight; y++)
			{
				index = ((((z*volobject.texheight)+y)*volobject.texwidth)+x);
				
				r = volobject.texture3d[3*index+0];
				g = volobject.texture3d[3*index+1];
				b = volobject.texture3d[3*index+2];

				if(r+g+b>0)
				{
					int helper=0;
					if(r>0) helper++;
					if(g>0) helper++;
					if(b>0) helper++;

					volobject.texture3d[3*index+0] = volobject.texture3d[3*index+1] = volobject.texture3d[3*index+2] = (r+g+b)/(float)helper;
				}
			}
		}
	}

	progressbar->setProgress(volobject.texdepth);
	delete progressbar;

	volobject.is_greyscale = 1;
	volobject.has_red = 0;
	volobject.has_green = 0;
	volobject.has_blue = 0;

	emit single_channel_signal();

	volrender.load_TextureMap();

	emit frames_redraw_signal();
	redraw_event();

}
void QtGLWidget::tfunc_histoupdate_slot(int toggle)
{
//	printf("toggle: %d\n", toggle);
	volrender.updatehisto = toggle;
	volrender.build_histogram();
}
void QtGLWidget::tfunc_rebuild_histogram_slot(void)
{
	if(volobject.texture3d==NULL) return;
	volrender.build_histogram();
}
void QtGLWidget::tfunc_brightcontrast_shader_slot(int mode, int bright, int cont)
{
//	printf("BOH\n");

	volrender.apply_brightcontrast(mode, bright, cont);
	//emit frames_redraw_signal();
	redraw_event();
}
void QtGLWidget::tfunc_threshold_shader_slot(int mode, int tmin, int tmax)
{
	//cout<<mode<<" "<<tmin<<" "<<tmax<<endl;
	volrender.apply_threshold(mode, tmin, tmax);
	//emit frames_redraw_signal();
	redraw_event();
}
void QtGLWidget::tfunc_invert_slot(int mode, int togglestate)
{
	if(togglestate==3)
	{
		volrender.apply_invert16(mode, togglestate);
	}
	else
	{
		volrender.apply_invert(mode, togglestate);
	}
//	emit frames_redraw_signal();
	redraw_event();
}
void QtGLWidget::tfunc_histequ_slot(int mode, int togglestate)
{
	printf("histequ_slot\n");
	printf("mode: %d\n", mode);
	printf("togglestate: %d\n", togglestate);

	int histogram[256];
	int cumfreq[256];
	int lookup[256];
	float numb_nonblackvoxels = 0;
	int i = 0;

	if(togglestate==1)
	{
		for(i=1; i<256; i++) numb_nonblackvoxels += volobject.histogram[3*i];

		//build cummulative frequency table
		double sum=0;
		for(i=0; i<256; i++)
		{
			sum+=volobject.histogram[3*i];
			cumfreq[i] = sum;
		}

		//build equalisation table
		float alpha = 255.0f/numb_nonblackvoxels;
		for(i=0; i<256; i++)
		{
			volrender.rgb_tfunc[3*i+0] = int(((float)(cumfreq[i])*alpha)+0.5 );
			volrender.rgb_tfunc[3*i+1] = int(((float)(cumfreq[i])*alpha)+0.5 );
			volrender.rgb_tfunc[3*i+2] = int(((float)(cumfreq[i])*alpha)+0.5 );
		}
	}
	else
	{

	}

	volrender.load_1DLookupTables();
	//volrender.build_histogram();
	redraw_event();
}
void QtGLWidget::tfunc_convertR_slot(void)
{
	if(volobject.texture3d==NULL) return;
	printf("convert R\n");

	int size = volobject.texwidth*volobject.texheight*volobject.texdepth;

	/*Q3ProgressDialog* progressbar = new Q3ProgressDialog("Converting the Volume Data to the Red Channel...", "Cancel", size, 0, "progress", TRUE);		
	progressbar->setCaption("Please Wait");
	//progressbar->setMinimumDuration(10);
*/
	float helper=0;
	if(volobject.is_greyscale)
	{
		helper=1;
	}
	else
	{
		if(volobject.has_red) helper++;
		if(volobject.has_green) helper++;
		if(volobject.has_blue) helper++;
	}

	int r,g,b, vox;
	for(int i=0; i<size; i++)
	{
		/*if((i%(int)((float)size/10.0))==0)
		{
			progressbar->setProgress(i);
			if (progressbar->wasCancelled()) break;
		}*/

		r = volobject.texture3d[3*i+0];
		g = volobject.texture3d[3*i+1];
		b = volobject.texture3d[3*i+2];

		vox = (r+g+b)/helper;

		volobject.texture3d[3*i+0]=vox;
		volobject.texture3d[3*i+1]=0;
		volobject.texture3d[3*i+2]=0;
	}

	/*progressbar->setProgress(size);
	delete progressbar;*/

	volobject.is_greyscale=false;
	volobject.has_red = true;
	volobject.has_green = false;
	volobject.has_blue = false;

	volrender.load_TextureMap();
	emit update_channels_signal();
	
	redraw_event();
}
void QtGLWidget::tfunc_convertG_slot(void)
{
	if(volobject.texture3d==NULL) return;
	printf("convert G\n");

	int size = volobject.texwidth*volobject.texheight*volobject.texdepth;

	/*Q3ProgressDialog* progressbar = new Q3ProgressDialog("Converting the Volume Data to the Green Channel...", "Cancel", size, 0, "progress", TRUE);		
	progressbar->setCaption("Please Wait");
	progressbar->setMinimumDuration(10);*/

	volobject.is_greyscale=false;
	volobject.has_red = false;
	volobject.has_green = true;
	volobject.has_blue = false;

	float helper=0;
	if(volobject.is_greyscale)
	{
		helper=1;
	}
	else
	{
		if(volobject.has_red) helper++;
		if(volobject.has_green) helper++;
		if(volobject.has_blue) helper++;
	}

	int r,g,b, vox;
	for(int i=0; i<size; i++)
	{
		/*progressbar->setProgress(i);
		if (progressbar->wasCancelled()) break;*/

		r = volobject.texture3d[3*i+0];
		g = volobject.texture3d[3*i+1];
		b = volobject.texture3d[3*i+2];

		vox = (r+g+b)/helper;

		volobject.texture3d[3*i+0]=0;
		volobject.texture3d[3*i+1]=vox;
		volobject.texture3d[3*i+2]=0;
	}
/*
	progressbar->setProgress(size);
	delete progressbar;
*/
	volrender.load_TextureMap();
	emit update_channels_signal();
	emit frames_redraw_signal();

	redraw_event();
}
void QtGLWidget::tfunc_convertB_slot(void)
{
	if(volobject.texture3d==NULL) return;
	printf("convert B\n");

	int size = volobject.texwidth*volobject.texheight*volobject.texdepth;

	/*Q3ProgressDialog* progressbar = new Q3ProgressDialog("Converting the Volume Data to the Blue Channel...", "Cancel", size, 0, "progress", TRUE);		
	progressbar->setCaption("Please Wait");
	progressbar->setMinimumDuration(10);*/

	volobject.is_greyscale=false;
	volobject.has_red = false;
	volobject.has_green = false;
	volobject.has_blue = true;

	float helper=0;
	if(volobject.is_greyscale)
	{
		helper=1;
	}
	else
	{
		if(volobject.has_red) helper++;
		if(volobject.has_green) helper++;
		if(volobject.has_blue) helper++;
	}

	int r,g,b, vox;
	for(int i=0; i<size; i++)
	{
		/*progressbar->setProgress(i);
		if (progressbar->wasCancelled()) break;*/

		r = volobject.texture3d[3*i+0];
		g = volobject.texture3d[3*i+1];
		b = volobject.texture3d[3*i+2];

		vox = (r+g+b)/helper;

		volobject.texture3d[3*i+0]=0;
		volobject.texture3d[3*i+1]=0;
		volobject.texture3d[3*i+2]=vox;
	}
/*
	progressbar->setProgress(size);
	delete progressbar;
*/
	volrender.load_TextureMap();
	emit update_channels_signal();
	
	redraw_event();
}
void QtGLWidget::tfunc_contstrat_slot(int mode, int togglestate)
{
	printf("contstrat_slot\n");

	float numb_voxels = volobject.texwidth*volobject.texheight*volobject.texdepth;
	float min_out, max_out;
	float min_in,  max_in;
	int i=0;

	min_out = 0.0;
	max_out = 255.0;

	//take bounds to be 5th and 95th percentile
	float lower_bound = numb_voxels*0.05;
	float upper_bound = numb_voxels*0.95;

	float counter=0;
	int help1=1;
	int help2=1;
	for(i=0; i<256; i++)
	{
		counter += volobject.histogram[3*i];

		if(counter>lower_bound && help1)
		{
			min_in = i;
			help1=0;
		}

		if(counter<upper_bound) max_in = i;

	}
	for(i=0; i<256; i++)
	{
		float result = (i-min_in)*((max_out-min_out)/(max_in-min_in))+min_out;
	
		if(result>255)	  result = 255;
		if(result<0)	  result = 0;

		volrender.rgb_tfunc[3*i+0] = result;
		volrender.rgb_tfunc[3*i+1] = result;
		volrender.rgb_tfunc[3*i+2] = result;
	}

	volrender.load_1DLookupTables();
	volrender.build_histogram();
	redraw_event();
}
void QtGLWidget::tfunc_slider_released_slot(void)
{
//	emit frames_redraw_signal();
}
/*void QtGLWidget::tfunc_remap16bit_slot(int min, int max, const vector<Vector>& tfunc_curvepts)
{
	if(volobject.texture3d==NULL) return;

	int index=0;
	int index2d=0;
	uint16 indexlookup16bit=0;

	uint16 minthresh = min;
	uint16 maxthresh = max;
	uint16 range = maxthresh - minthresh;
	uint16 value=0;
	
	printf("min: %d\n", min);
	printf("max: %d\n", max);
	printf("range 16bit: %d\n", range);
//	printf("tfunc[0]: %d\n", (int)tfunc_curvepts[0].y);	
	int value8bit=0;
	
	Q3ProgressDialog* progressbar = new Q3ProgressDialog("Remapping 16bit data to 8bit...", "Cancel", volobject.texdepth, 0, "progress", TRUE);		
	progressbar->setCaption("Please Wait");
	progressbar->setMinimumDuration(10);

	for(int i=0; i<256*3; i++) volobject.histogram[i]=0.0;
	
	for(int z=0; z<volobject.texdepth; z++)
	{
		//update our progress bar
		progressbar->setProgress((int)z);
		if (progressbar->wasCancelled())
			break;

		for(int y=0; y<volobject.texheight; y++)
		{
			for(int x=0; x<volobject.texwidth; x++)
			{
				index = (((z*volobject.texheight)+y)*volobject.texwidth)+x;
				index2d = (y*volobject.texwidth)+x;

				indexlookup16bit = volobject.voldata[z][index2d];

				if(indexlookup16bit<minthresh) indexlookup16bit = 0.0;
				if(indexlookup16bit>maxthresh) indexlookup16bit = 0.0;
				
				value = 65536 - tfunc_curvepts[(int)indexlookup16bit].y;			 
				
				//if(value!=indexlookup16bit) printf("remap: %d, %d\n", value, indexlookup16bit);
				
				if(value>minthresh) value = value - minthresh;
					
				value8bit = ((float)value/(float)range)*255.0;
				value8bit = (int)(value8bit+0.5);
				
				if(value8bit>255) value8bit = 255;
				if(value8bit<0) value8bit = 0;
				
				//printf("index3d: %d of %d\n", index, 512*512*512*3);
				//printf("value8bit: %d\n", value8bit);

				volobject.texture3d[3*index+0] = 
				volobject.texture3d[3*index+1] = 
				volobject.texture3d[3*index+2] = value8bit;
			
				volobject.histogram[3*value8bit+0]++;
				volobject.histogram[3*value8bit+1]++;
				volobject.histogram[3*value8bit+2]++;
			}
		}	
	}
	
	delete progressbar;
	progressbar=NULL;
	
	volrender.load_3DTextureMap();

	tfunc_rebuild_histogram_slot();
	emit tfunc_histogram_signal(&volobject.histogram[0]);
	emit tfunc_16bit_histogram_signal(&volobject.histogram16bit[0], &volobject.histogram[0]);
	
	redraw_event();	
}*/

void QtGLWidget::tfunc_remap16bit_slot(int min_l, int max_l, const vector<Vector>& tfunc_curvepts_luminance, int min_o, int max_o, const vector<Vector>& tfunc_curvepts_opacity)
{
	/*if(volobject.texture3d==NULL) return;

	int index=0;
	int index2d=0;	
	uint16 indexlookup16bit=0;
	uint16 value=0;

	uint16 minthresh_l = min_l;
	uint16 maxthresh_l = max_l;
	uint16 range_l = maxthresh_l - minthresh_l;
	
	uint16 minthresh_o = min_o;
	uint16 maxthresh_o = max_o;
	uint16 range_o = maxthresh_o - minthresh_o;

	printf("min_l: %d\n", min_l);
	printf("max_l: %d\n", max_l);
	printf("range_l 16bit: %d\n", range_l);
	printf("min_o: %d\n", min_o);
	printf("max_o: %d\n", max_o);
	printf("range_o 16bit: %d\n", range_o);

	int value8bit_l=0;
	int value8bit_o=0;
	
	Q3ProgressDialog* progressbar = new Q3ProgressDialog("Remapping 16bit data to 8bit...", "Cancel", volobject.texdepth, 0, "progress", TRUE);		
	progressbar->setCaption("Please Wait");
	progressbar->setMinimumDuration(10);

	for(int i=0; i<256*3; i++) volobject.histogram[i]=0.0;
	
	for(int z=0; z<volobject.texdepth; z++)
	{
		//update our progress bar
		progressbar->setProgress((int)z);
		if (progressbar->wasCancelled())
			break;

		for(int y=0; y<volobject.texheight; y++)
		{
			for(int x=0; x<volobject.texwidth; x++)
			{
				index = (((z*volobject.texheight)+y)*volobject.texwidth)+x;
				index2d = (y*volobject.texwidth)+x;

				indexlookup16bit = volobject.voldata[z][index2d];
				
				if(indexlookup16bit<minthresh_l) indexlookup16bit = 0.0;
				if(indexlookup16bit>maxthresh_l) indexlookup16bit = 0.0;
				value = 65535 - tfunc_curvepts_luminance[(int)indexlookup16bit].y;			 
				if(value>minthresh_l) value = value - minthresh_l;					
				value8bit_l = ((float)value/(float)range_l)*255.0;
				//value8bit_l = (int)(value8bit_l+0.5);				
				if(value8bit_l>255) value8bit_l = 255;
				if(value8bit_l<0) value8bit_l = 0;

				indexlookup16bit = volobject.voldata[z][index2d];

				if(indexlookup16bit<minthresh_o) indexlookup16bit = 0.0;
				if(indexlookup16bit>maxthresh_o) indexlookup16bit = 0.0;
				value = 65536 - tfunc_curvepts_opacity[(int)indexlookup16bit].y;			 
				if(value>minthresh_o) value = value - minthresh_o;					
				value8bit_o = ((float)value/(float)range_o)*255.0;
				//value8bit_o = (int)(value8bit_o+0.5);				
				if(value8bit_o>255) value8bit_o = 255;
				if(value8bit_o<0) value8bit_o = 0;
				
				value = (float)value8bit_l*(float)value8bit_o;
				if(value>255) value = 255;
				if(value<0) value = 0;

				//printf("index3d: %d of %d\n", index, 512*512*512*3);
				//if(value8bit_o!=255 && value8bit_o !=0) printf("value8bit_o: %d\n", value8bit_o);

				volobject.texture3d[3*index+0] = value8bit_o;
				volobject.texture3d[3*index+1] = value8bit_o;
				volobject.texture3d[3*index+2] = 0;
			
				volobject.histogram[3*value8bit_o+0]++;
				volobject.histogram[3*value8bit_o+1]++;
				volobject.histogram[3*value8bit_o+2]++;
			}
		}	
	}
	
	delete progressbar;
	progressbar=NULL;
	
	volio.pad(1.0);
	
	volrender.load_3DTextureMap();

	tfunc_rebuild_histogram_slot();
	emit tfunc_histogram_signal(&volobject.histogram[0]);
	emit tfunc_16bit_histogram_signal(&volobject.histogram16bit[0], &volobject.histogram[0]);
	
	redraw_event();
	emit frames_redraw_signal();*/
}
//===========================================================================================================
void QtGLWidget::sliceframe_updatepixel(void)
{
	if(volobject.texture3d==NULL) return;

	volrender.x_slice = volrender.cursor3D_texturespace.x = volrender.cursor3D_screenspace.x + (float)volobject.texwidth/2.0;;
	volrender.y_slice = volrender.cursor3D_texturespace.y = volrender.cursor3D_screenspace.y + (float)volobject.texheight/2.0;;
	volrender.z_slice = volrender.cursor3D_texturespace.z = volrender.cursor3D_screenspace.z + (float)volobject.texdepth/2.0;;

	/*volrender.cursor3D_screenspace.x = mouse_x - (float)volobject.texwidth/2.0; //int( ((((float)mouse_x/(float)width)-0.5) * (float)volobject.texwidth));
	volrender.cursor3D_screenspace.y = mouse_y - (float)volobject.texheight/2.0; //int( ((((float)mouse_y/(float)height)-0.5)  * (float)volobject.texheight));
	volrender.cursor3D_screenspace.z = z - (float)volobject.texdepth/2.0;
*/
	QString s;
	volrender.cursor3D = "(";
	s.setNum(volrender.cursor3D_texturespace.x);
	volrender.cursor3D +=s;
	volrender.cursor3D +=",";
	s.setNum(volrender.cursor3D_texturespace.y);
	volrender.cursor3D +=s;
	volrender.cursor3D +=",";
	s.setNum(volrender.cursor3D_texturespace.z);
	volrender.cursor3D +=s;
	volrender.cursor3D +=")";

	redraw_event();
	emit frames_redraw_signal();
	emit updatestatus_cursor_signal();
	//redraw_event();
}
//===========================================================================================================
void QtGLWidget::sliceframe_pixelXY_slot(int x, int y, int z, int r, int g, int b, int mouse_x,int mouse_y, int width, int height)
{
	if(volobject.texture3d==NULL) return;

	volrender.cursor3D_texturespace.x = mouse_x; //int( (((float)mouse_x/(float)width)  * (float)volobject.width)+0.5);
	volrender.cursor3D_texturespace.y = mouse_y; //int( (((float)mouse_y/(float)height)  * (float)volobject.height)+0.5);
	volrender.cursor3D_texturespace.z = z;

	volrender.cursor3D_screenspace.x = mouse_x - (float)volobject.texwidth/2.0; //int( ((((float)mouse_x/(float)width)-0.5) * (float)volobject.texwidth));
	volrender.cursor3D_screenspace.y = mouse_y - (float)volobject.texheight/2.0; //int( ((((float)mouse_y/(float)height)-0.5)  * (float)volobject.texheight));
	volrender.cursor3D_screenspace.z = z - (float)volobject.texdepth/2.0;

	QString s;
	volrender.cursor3D = "(";
	s.setNum(volrender.cursor3D_texturespace.x);
	volrender.cursor3D +=s;
	volrender.cursor3D +=",";
	s.setNum(volrender.cursor3D_texturespace.y);
	volrender.cursor3D +=s;
	volrender.cursor3D +=",";
	s.setNum(volrender.cursor3D_texturespace.z);
	volrender.cursor3D +=s;
	volrender.cursor3D +=")";

//	printf("%f %f\n", (float)mouse_x, (float)mouse_y);
	
	printf("cursor3D_screenspace: %f %f %f\n", volrender.cursor3D_screenspace.x, volrender.cursor3D_screenspace.y, volrender.cursor3D_screenspace.z);

	redraw_event();
}
void QtGLWidget::sliceframe_pixelXZ_slot(int x, int y, int z, int r, int g, int b, int mouse_x,int mouse_y, int width, int height)
{
	if(volobject.texture3d==NULL) return;
	
	volrender.cursor3D_texturespace.x = mouse_x; //int( (((float)mouse_x/(float)width)  * (float)volobject.width )+0.5);
	volrender.cursor3D_texturespace.y = y;
	volrender.cursor3D_texturespace.z = mouse_y; //int( (((float)mouse_y/(float)height) * (float)volobject.depth )+0.5);

	volrender.cursor3D_screenspace.x = mouse_x - (float)volobject.texwidth/2.0; //int( (((float)mouse_x/(float)width)  * (float)volobject.texwidth )+0.5);
	volrender.cursor3D_screenspace.y = y - (float)volobject.texheight/2.0;
	volrender.cursor3D_screenspace.z = mouse_y - (float)volobject.texdepth/2.0; //int( (((float)mouse_y/(float)height) * (float)volobject.texdepth )+0.5);

	QString s;
	volrender.cursor3D = "(";
	s.setNum(volrender.cursor3D_texturespace.x);
	volrender.cursor3D +=s;
	volrender.cursor3D +=",";
	s.setNum(volrender.cursor3D_texturespace.y);
	volrender.cursor3D +=s;
	volrender.cursor3D +=",";
	s.setNum(volrender.cursor3D_texturespace.z);
	volrender.cursor3D +=s;
	volrender.cursor3D +=")";

	redraw_event();
}
void QtGLWidget::sliceframe_pixelYZ_slot(int x, int y, int z, int r, int g, int b, int mouse_x,int mouse_y, int width, int height)
{
	if(volobject.texture3d==NULL) return;
	
	volrender.cursor3D_texturespace.x = x;
	volrender.cursor3D_texturespace.y = mouse_x; //int( (((float)mouse_x/(float)width)  * (float)volobject.height)+0.5);
	volrender.cursor3D_texturespace.z = mouse_y; //int( (((float)mouse_y/(float)height) * (float)volobject.depth)+0.5);

	volrender.cursor3D_screenspace.x = x- (float)volobject.texwidth/2.0;
	volrender.cursor3D_screenspace.y = mouse_x - (float)volobject.texheight/2.0; //int( (((float)mouse_x/(float)width) * (float)volobject.texheight )+0.5);
	volrender.cursor3D_screenspace.z = mouse_y - (float)volobject.texdepth/2.0; //int( (((float)mouse_y/(float)height)  * (float)volobject.texdepth )+0.5);

	QString s;
	volrender.cursor3D = "(";
	s.setNum(volrender.cursor3D_texturespace.x);
	volrender.cursor3D +=s;
	volrender.cursor3D +=",";
	s.setNum(volrender.cursor3D_texturespace.y);
	volrender.cursor3D +=s;
	volrender.cursor3D +=",";
	s.setNum(volrender.cursor3D_texturespace.z);
	volrender.cursor3D +=s;
	volrender.cursor3D +=")";

	redraw_event();
}

//===========================================================================================================
void QtGLWidget::measure_modify_rotatecurrent(int mode, float angle)
{
	//printf("rotate\n");

	int helper=0;
	volrender.current_measure_centre = Vector(0,0,0);
	for(int i=0; i<volrender.current_measure_points.size(); i++)
	{
		Vector v = volrender.current_measure_points[i];
		volrender.current_measure_centre += v;
		helper++;
	}
	volrender.current_measure_centre /= (float)helper;

	Vector axis, axis2;
	if(mode==0) axis=Vector(1,0,0);
	else if(mode==1) axis=Vector(0,1,0);
	else if(mode==2) axis=Vector(0,0,1);

	Matrix4fT mat = Matrix4fInverse(&volrender.arcball.Transform);
	//Matrix4fMulVector4f(Matrix4fInverse(&volrender.arcball.Transform), &axis);
	RotateVector(mat.M,axis,axis2);
	axis = axis2;

	for(int i=0; i<volrender.current_measure_points.size(); i++)
	{
		Vector v = volrender.current_measure_points[i];
		v -= volrender.current_measure_centre;
		//Matrix4fMulVector4f(Matrix4fInverse(&volrender.arcball.Transform), &v);
		v.rotate3D(axis, angle);
		//Matrix4fMulVector4f(volrender.arcball.Transform, &v);
		v += volrender.current_measure_centre;
		volrender.current_measure_points[i] = v;
	}

	updateGL();
}
void QtGLWidget::measure_modify_zoomcurrent(float zoom)
{
	int helper=0;
	volrender.current_measure_centre = Vector(0,0,0);
	for(int i=0; i<volrender.current_measure_points.size(); i++)
	{
		Vector v = volrender.current_measure_points[i];
		volrender.current_measure_centre += v;
		helper++;
	}
	volrender.current_measure_centre /= (float)helper;

	for(int i=0; i<volrender.current_measure_points.size(); i++)
	{
		Vector v = volrender.current_measure_points[i];
		v -= volrender.current_measure_centre;
		v *= zoom;
		v += volrender.current_measure_centre;
		volrender.current_measure_points[i] = v;
	}
	updateGL();
}
void QtGLWidget::measure_modify_start_slot(void)
{
	volrender.measure_modify=1;
	updateGL();
}
void QtGLWidget::measure_modify_stop_slot(void)
{
	volrender.measure_modify=0;
}
void QtGLWidget::measure_clearall_slot(void)
{
	//printf("CLEARING\n");
	
	volrender.current_measure_points.clear();
	volrender.current_normals.clear();
	volrender.current_edges.clear();
	volrender.measure_objects_drawmode.clear();
	volrender.measure_objects_visible.clear();

	for(int i=0; i<volrender.measure_objects.size(); i++)
	{
		volrender.measure_objects[i].clear();
		volrender.measure_normals[i].clear();
		volrender.measure_edges[i].clear();		
	}
	
	volrender.measure_objects.clear();
	volrender.measure_normals.clear();
	volrender.measure_edges.clear();
}
void QtGLWidget::measure_start_slot(void)
{
	int selected = -1;
	for(int i=0; i<6; i++)
	{
		if(volrender.cutting_planes.selected[i]==1) selected=1;
	}

	volrender.measure_mode = 1;
	volrender.measure_editmode = 1;
	redraw_event();
}
void QtGLWidget::measure_pause_slot(void)
{
	volrender.measure_mode = 0;
	volrender.measure_editmode = 0;
	redraw_event();
}
void QtGLWidget::measure_edit_slot(void)
{
	volrender.measure_editmode = 1;
	volrender.measure_mode = 0;
	redraw_event();
}
void QtGLWidget::measure_stop_slot(void)
{
	volrender.measure_mode = 0;
	volrender.measure_editmode = 0;

	volrender.current_measure_index = -1;
	volrender.current_measure_vertindex = -1;
	
	//cutplane_unselect_slot();
	//emit cutplane_unselect_signal();

	redraw_event();
}
void QtGLWidget::measure_eval_triangles_slot(int index)
{
	/*if(volrender.current_measure_drawmode==4 && !volrender.measure_objects[index].empty())
	{		
		PCA pca;
		int i;
		
		for(i=0; i<volrender.measure_objects[index].size(); i++)
		{
			volrender.measure_objects[index][i].w=i;
			pca.data.push_back(volrender.measure_objects[index][i]);
		}

		pca.eval_PCA();
		pca.eval_aligned_data();

		float x, y, z;
		x=y=z=0;
		for (i=0; i<pca.aligned_data.size(); i++)
		{
			pca.aligned_data[i].round(4);
			x =+ pca.aligned_data[i].x;
			y =+ pca.aligned_data[i].y;
			z =+ pca.aligned_data[i].z;
		}

		int axis = -1;
		if(x==0) axis=0;
		else if(y==0) axis=1;
		else axis=2;

		vector < Vector > points2d;
		vector < Vector > result;

		for (i=0; i<pca.aligned_data.size(); i++)
		{
			if(axis==0)
			{
				points2d.push_back(Vector(pca.aligned_data[i].y, pca.aligned_data[i].z,0,i));
			}
			else if(axis==1)
			{
				points2d.push_back(Vector(pca.aligned_data[i].x, pca.aligned_data[i].z,0,i));
			}
			else if(axis==2)
			{
				points2d.push_back(Vector(pca.aligned_data[i].x, pca.aligned_data[i].y,0,i));
			}
		}

		Triangulate::Process(points2d,result);

		int numbtris = result.size()/3;
		for (i=0; i<numbtris; i++)
		{
			volrender.current_triangles.push_back((int)result[3*i+0].w);
			volrender.current_triangles.push_back((int)result[3*i+1].w);
			volrender.current_triangles.push_back((int)result[3*i+2].w);
		}
	
	}*/
}
void QtGLWidget::measure_evalcurrent_triangles_slot	(void)
{
	/*if(volrender.current_measure_drawmode==4 && !volrender.current_measure_points.empty())
	{
		volrender.current_triangles.clear();

		PCA pca;
		int i;
		
		for(i=0; i<volrender.current_measure_points.size(); i++)
		{
			volrender.current_measure_points[i].w=i;

			pca.data.push_back(volrender.current_measure_points[i]);
		}

		pca.eval_PCA();
		pca.eval_aligned_data();

		float x, y, z;
		x=y=z=0;
		for (i=0; i<pca.aligned_data.size(); i++)
		{
			pca.aligned_data[i].round(4);
			x =+ pca.aligned_data[i].x;
			y =+ pca.aligned_data[i].y;
			z =+ pca.aligned_data[i].z;
		}

		int axis = -1;
		if(x==0) axis=0;
		else if(y==0) axis=1;
		else axis=2;

		printf("(x:%f, y:%f, z:%f)\n", x, y, z);

		vector < Vector > points2d;
		vector < Vector > result;

		for (i=0; i<pca.aligned_data.size(); i++)
		{
			if(axis==0)
			{
				points2d.push_back(Vector(pca.aligned_data[i].y, pca.aligned_data[i].z,0,i));
			}
			else if(axis==1)
			{
				points2d.push_back(Vector(pca.aligned_data[i].x, pca.aligned_data[i].z,0,i));
			}
			else if(axis==2)
			{
				points2d.push_back(Vector(pca.aligned_data[i].x, pca.aligned_data[i].y,0,i));
			}
		}

		Triangulate::Process(points2d,result);

		int numbtris = result.size()/3;
		for (i=0; i<numbtris; i++)
		{
			printf("indices: %d %d %d \n", result[3*i+0].w, result[3*i+1].w, result[3*i+2].w);

			volrender.current_triangles.push_back((int)result[3*i+0].w);
			volrender.current_triangles.push_back((int)result[3*i+1].w);
			volrender.current_triangles.push_back((int)result[3*i+2].w);
		}
	}*/
}
void QtGLWidget::measure_load_item_slot(vector< Vector > pnts, vector< Edge > edges, int draw_mode)
{
	volrender.current_measure_index = -1;
	
	//printf("size: %d\n", volrender.measure_objects.size());

	volrender.measure_objects.push_back(pnts);
	volrender.measure_objects_drawmode.push_back(draw_mode);
	volrender.measure_objects_visible.push_back(true);

	volrender.current_normals.clear();
	for(int i=0; i<pnts.size(); i++) volrender.current_normals.push_back(Vector(0,0,0));
	volrender.measure_normals.push_back(volrender.current_normals);

	volrender.measure_edges.push_back(edges);

	volrender.current_normals.clear();
	volrender.current_measure_points.clear();
	volrender.current_edges.clear();

	printf("size: %d\n", volrender.measure_objects.size());

	redraw_event();
}

void QtGLWidget::measure_add_item_slot(vector< Vector > pnts, int draw_mode)
{
	volrender.current_measure_index = -1;
	
	volrender.measure_objects.push_back(volrender.current_measure_points);
	volrender.measure_objects_drawmode.push_back(volrender.current_measure_drawmode);
	volrender.measure_objects_visible.push_back(true);

	if(!volrender.current_normals.empty()) volrender.current_normals.clear();
	for(int i=0; i<volrender.current_measure_points.size(); i++) volrender.current_normals.push_back(Vector(0,0,0));
	volrender.measure_normals.push_back(volrender.current_normals);

	volrender.measure_edges.push_back(volrender.current_edges);
	emit measure_edges_signal(volrender.current_edges);

	//find which plane we have currently active
	/*int selected=-1;
	for(int i=0; i<6; i++)
	{
		if(volrender.cutting_planes.selected[i]==1) selected = i;
	}*/
	/*
	if(selected==-1) return;
	
	printf("ADD ITEM: %d %f %f %f \n", selected, volrender.cutting_planes.planes[selected].translate, volrender.cutting_planes.planes[selected].angleX, volrender.cutting_planes.planes[selected].angleY);

	emit measure_savecutplane_signal(selected, volrender.cutting_planes.planes[selected].translate, volrender.cutting_planes.planes[selected].angleX, volrender.cutting_planes.planes[selected].angleY);
	*/

	volrender.current_normals.clear();
	volrender.current_measure_points.clear();
	volrender.current_edges.clear();
	redraw_event();
}
void QtGLWidget::measure_update_item_slot(int index, vector< Vector > pnts, int draw_mode)
{
	int i=0;
	volrender.current_measure_index = -1;
	volrender.measure_normals[index].clear();
	volrender.measure_objects[index].clear();
	volrender.measure_edges[index].clear();

	volrender.measure_objects_drawmode[index] = draw_mode;

	for(i=0; i<volrender.current_measure_points.size(); i++)
	{
		volrender.measure_objects[index].push_back(volrender.current_measure_points[i]);
		volrender.measure_normals[index].push_back(volrender.current_normals[i]);
	}
	for(i=0; i<volrender.current_edges.size(); i++)
	{
		volrender.measure_edges[index].push_back(volrender.current_edges[i]);
	}

	emit measure_update_edges_signal(index, volrender.measure_edges[index]);

	redraw_event();

	measure_cancel_slot();
}
void QtGLWidget::measure_cancel_slot(void)
{
	volrender.current_measure_index = -1;
	volrender.current_measure_vertindex = -1;
	volrender.current_measure_points.clear();
	volrender.current_normals.clear();
	volrender.current_edges.clear();

	redraw_event();
}
void QtGLWidget::measure_update_current_verts_slot(vector<Vector> pnts)
{
/*	volrender.current_measure_points.clear();
	
	if(!pnts.empty())
	{
		for(int i=0; i<pnts.size(); i++)
		{
			volrender.current_measure_points.push_back(pnts[i]);
		}
	}

	//measure_evalcurrent_triangles_slot();

	redraw_event();*/
}
void QtGLWidget::measure_rmv_current_verts_slot(int index)
{
//	printf("DELETING POINT\n");
//	printf("delete index: %d\n", index);
	
	if(volrender.current_measure_points.empty()) return;

	if(index==0) volrender.current_measure_points.erase(volrender.current_measure_points.begin());
	else volrender.current_measure_points.erase(volrender.current_measure_points.begin()+index);

	//volrender.current_measure_points.erase(volrender.current_measure_points.begin()+index);

//	if(volrender.current_measure_vertindex>volrender.current_measure_points.size()-1) volrender.current_measure_vertindex = volrender.current_measure_points.size()-1;

	vector<int> todelete;
	
//	printf("delete edges\n");
	for(int i=0; i<volrender.current_edges.size(); i++)
	{
		int v0 = volrender.current_edges[i].v0;
		int v1 = volrender.current_edges[i].v1;

		if(v0==index || v1==index)
		{
	//		printf("v0: %d v1: %d\n", v0, v1);

			todelete.push_back(i);
		}
	}
	//printf("edge list before delete\n");
/*
	for(int i=0; i<volrender.current_edges.size(); i++)
	{
		int v0 = volrender.current_edges[i].v0;
		int v1 = volrender.current_edges[i].v1;
		printf("v0: %d v1: %d\n", v0, v1);
	}
*/
	int delindex;
	//printf("deleting edges: \n");
	for(int i=todelete.size()-1; i>=0; i--)
	{
		delindex = todelete[i];

		int v0 = volrender.current_edges[delindex].v0;
		int v1 = volrender.current_edges[delindex].v1;
	//	printf("v0: %d v1: %d\n", v0, v1);

		if(delindex==0) volrender.current_edges.erase(volrender.current_edges.begin());
		else volrender.current_edges.erase(volrender.current_edges.begin()+(delindex));
	}

	//printf("adjusting old edges: \n");
	for(int i=0; i<volrender.current_edges.size(); i++)
	{
		int v0 = volrender.current_edges[i].v0;
		int v1 = volrender.current_edges[i].v1;

		if(v0>index)
		{
			//printf("before: (v0): %d v1: %d\n", volrender.current_edges[i].v0, volrender.current_edges[i].v1);
			volrender.current_edges[i].v0--;
			//printf("after: (v0): %d v1: %d\n", volrender.current_edges[i].v0, volrender.current_edges[i].v1);
		}
		if(v1>index)
		{
			//printf("before: v0: %d (v1): %d\n", volrender.current_edges[i].v0, volrender.current_edges[i].v1);
			volrender.current_edges[i].v1--;
			//printf("after: v0: %d (v1): %d\n", volrender.current_edges[i].v0, volrender.current_edges[i].v1);
		}
		
	}
	
	volrender.measure_magnetline_vert_old = volrender.current_measure_points.size()-1;

	//printf("edge list after delete\n");
/*
	for(int i=0; i<volrender.current_edges.size(); i++)
	{
		int v0 = volrender.current_edges[i].v0;
		int v1 = volrender.current_edges[i].v1;
		printf("v0: %d v1: %d\n", v0, v1);
	}
*/
	//printf("\n");
	//printf("\n");

	if(volrender.current_measure_drawmode!=6) measure_rebuild_current_edges();

	redraw_event();
}
void QtGLWidget::measure_update_visible_slot(int index, bool state)
{
	printf("state: %d\n", (int) state);

	if(volrender.measure_objects_visible.size()<=index) return;

	volrender.measure_objects_visible[index] = state;
	redraw_event();
}
void QtGLWidget::measure_delete_item_slot(int index)
{
	volrender.current_measure_index = -1;
	volrender.measure_objects[index].clear();
	volrender.measure_objects.erase(volrender.measure_objects.begin()+index);

	volrender.measure_normals[index].clear();
	volrender.measure_normals.erase(volrender.measure_normals.begin()+index);
	
	volrender.measure_edges[index].clear();
	volrender.measure_edges.erase(volrender.measure_edges.begin()+index);

//	volrender.measure_triangles[index].clear();
//	volrender.measure_triangles.erase(volrender.measure_triangles.begin()+index);

	volrender.measure_objects_drawmode.erase(volrender.measure_objects_drawmode.begin()+index);
	volrender.measure_objects_visible.erase(volrender.measure_objects_visible.begin()+index);

	redraw_event();
}
void QtGLWidget::measure_update_current_slot(int index)
{
	volrender.current_measure_index = index;

	volrender.current_measure_points.clear();
	volrender.current_normals.clear();
	volrender.current_edges.clear();

//	volrender.current_triangles.clear();

	for(int i=0; i<volrender.measure_objects[index].size(); i++)
	{
		volrender.current_measure_points.push_back(volrender.measure_objects[index][i]);
		volrender.current_normals.push_back(volrender.measure_normals[index][i]);
	}
	for(int i=0; i<volrender.measure_edges[index].size(); i++)
	{
		volrender.current_edges.push_back(volrender.measure_edges[index][i]);
	}

	emit measure_currentverts_signal(volrender.current_measure_points);
	emit measure_currentedges_signal(volrender.current_edges);

	//for(int ii=0; ii<volrender.measure_triangles[index].size(); ii++)
	//	volrender.current_triangles.push_back(volrender.measure_triangles[index][ii]);
	
	redraw_event();
}
void QtGLWidget::measure_rebuild_current_edges(void)
{

	if(volrender.current_measure_drawmode!=6) volrender.current_edges.clear();

	Edge e;
	if(volrender.current_measure_drawmode==0)
	{
	}
	else if(volrender.current_measure_drawmode==1)
	{
		for(int i=0; i<volrender.current_measure_points.size(); i++)
		{
			if(i%2==0)
			{
				if(i<volrender.current_measure_points.size()-1)
				{
					e.v1 = i;
					e.v0 = i+1;
					volrender.current_edges.push_back(e);
				}
			}
		}
	}
	else if(volrender.current_measure_drawmode==2 || volrender.current_measure_drawmode==3)
	{
		Edge e;
		for(int i=0; i<volrender.current_measure_points.size(); i++)
		{
			if(i<volrender.current_measure_points.size()-1)
			{
				e.v1 = i;
				e.v0 = i+1;
				volrender.current_edges.push_back(e);
			}			
		}
		if(volrender.current_measure_drawmode==3)
		{
			if(volrender.current_measure_points.size()>1)
			{
				e.v0 = volrender.current_measure_points.size()-1;
				e.v1 = 0;
				volrender.current_edges.push_back(e);
			}
		}
	}
	else if(volrender.current_measure_drawmode==6)
	{

		if(volrender.current_measure_points.size()>1)
		{
			if(volrender.current_measure_points.size()==2) volrender.measure_magnetline_vert_old = 0;

			Edge e;
			if(volrender.measure_magnetline_vert!=-1 && volrender.measure_magnetline_vert_old!=-1 && volrender.measure_magnetline_vert!=volrender.measure_magnetline_vert_old)
			{
				printf("building edges1\n");
				e.v0 = volrender.measure_magnetline_vert_old;
				e.v1 = volrender.measure_magnetline_vert;

				for(int i=0; i<volrender.current_edges.size(); i++)
				{
					int v0 = volrender.current_edges[i].v0;
					int v1 = volrender.current_edges[i].v1;

					if(e.v1==v0 && e.v0==v1) return;
					if(e.v1==v1 && e.v0==v0) return;
				}

				volrender.current_edges.push_back(e);
				volrender.measure_magnetline_vert_old = volrender.measure_magnetline_vert;

				printf("edge: %d, %d\n", e.v0,e.v1);
			}
			else if(volrender.measure_magnetline_vert_old!=-1)
			{
				printf("building edges2\n");
				e.v0 = volrender.current_measure_points.size()-1;
				e.v1 = volrender.measure_magnetline_vert_old;

				for(int i=0; i<volrender.current_edges.size(); i++)
				{
					int v0 = volrender.current_edges[i].v0;
					int v1 = volrender.current_edges[i].v1;

					if(e.v1==v0 && e.v0==v1) return;
					if(e.v1==v1 && e.v0==v0) return;
				}

				volrender.current_edges.push_back(e);
				volrender.measure_magnetline_vert_old=volrender.current_measure_points.size()-1;;

				printf("edge: %d, %d\n", e.v0,e.v1);
			}
		}

		/*for(int i=0; i<volrender.current_edges.size(); i++)
		{
			int v0 = volrender.current_edges[i].v0;
			int v1 = volrender.current_edges[i].v1;
			printf("v0: %d v1: %d\n", v0, v1);
		}*/
	}
}
void QtGLWidget::measure_labellermin_slot(int j)
{
	//check slider bounds
	if(j>labellermax)
	{
		j = labellermax;
		labellermin_slider->setValue(j);
	}
	labellermin = j;
	
	float val = (float)j/2.0f;
	//update our slider label
	QString s;
	QString text;
	text = "Min. Region:	";
	s.setNum(val);
	text += s;
	text += "%";
	labellermin_lb->setText (text);

	emit measure_clearcurrent_signal();

	volrender.current_normals.clear();
	volrender.current_measure_points.clear();

	float min = ((float)labellermin/200.0f) * (float)(volrender.measure_region_size_max);
	float max = ((float)labellermax/200.0f) * (float)(volrender.measure_region_size_max);
//	printf("labeller: %d, %d\n", min, max);
	for(int i=0; i<volrender.measure_region_means.size(); i++)
	{
		if(volrender.measure_region_sizes[i]>min && volrender.measure_region_sizes[i]<max)
		{
			volrender.current_normals.push_back(Vector(0,0,0));
			volrender.current_measure_points.push_back(volrender.measure_region_means[i]);
			emit measure_point_signal(volrender.measure_region_means[i]);
			emit measure_currentverts_signal(volrender.current_measure_points);
			emit measure_currentedges_signal(volrender.current_edges);
		}
	}

	redraw_event();
}
void QtGLWidget::measure_labellermax_slot(int j)
{
	//check slider bounds
	if(j<labellermin)
	{
		j = labellermin;
		labellermax_slider->setValue(j);
	}
	labellermax = j;

	float val = (float)j/2.0f;
	//update our slider label
	QString s;
	QString text;
	text = "Max. Region:	";
	s.setNum(val);
	text += s;
	text += "%";
	labellermax_lb->setText (text);

	emit measure_clearcurrent_signal();

	volrender.current_normals.clear();
	volrender.current_measure_points.clear();

	float min = ((float)labellermin/200.0f) * (float)(volrender.measure_region_size_max);
	float max = ((float)labellermax/200.0f) * (float)(volrender.measure_region_size_max);
//	printf("labeller: %d, %d\n", min, max);
	for(int i=0; i<volrender.measure_region_means.size(); i++)
	{
		if(volrender.measure_region_sizes[i]>min && volrender.measure_region_sizes[i]<max)
		{
			volrender.current_normals.push_back(Vector(0,0,0));
			volrender.current_measure_points.push_back(volrender.measure_region_means[i]);
			emit measure_point_signal(volrender.measure_region_means[i]);
			emit measure_currentverts_signal(volrender.current_measure_points);
			emit measure_currentedges_signal(volrender.current_edges);
		}
	}


	redraw_event();
}
void QtGLWidget::measure_labellerokbutton_event(void)
{
	/*volrender.current_normals.clear();
	volrender.current_measure_points.clear();
	
	labellermin = ((float)labellermin/200.0f) * (float)(volobject.texdepth*volobject.texheight*volobject.texwidth);
	labellermax = ((float)labellermax/200.0f) * (float)(volobject.texdepth*volobject.texheight*volobject.texwidth);

	printf("labeller: %d, %d\n", labellermin, labellermax);
*/
	/*Floodfill ffill;
	ffill.volobj = &volobject;
	ffill.volio = &volio;
	ffill.floodfill(COLOUR_RULE);
	ffill.apply_result(labellermin, labellermax);
	ffill.delete_visited();

	Vector v;
	for(int i=0; i<ffill.cellmeans.size(); i++)
	{
		if(ffill.regions_todelete[i]==false)
		{
			v = ffill.cellmeans[i];
			v.x -= (float)volobject.texwidth/2.0;
			v.y -= (float)volobject.texheight/2.0;
			v.z -= (float)volobject.texdepth/2.0;

			v.x *= ffill.scaleX;
			v.y *= ffill.scaleY;
			v.z *= ffill.scaleZ;

			volrender.current_normals.push_back(Vector(0,0,0));
			volrender.current_measure_points.push_back(v);
			emit measure_point_signal(v);
		}
	}*/
	


	labeller_dialogue->close();
	delete labeller_dialogue;
}
void QtGLWidget::measure_labellercancbutton_event(void)
{
	volrender.current_normals.clear();
	volrender.current_measure_points.clear();
	labeller_dialogue->close();
	delete labeller_dialogue;
}
void QtGLWidget::measure_labellerdialogue_event(void)
{
/*	Floodfill ffill;
	ffill.volobj = &volobject;
	ffill.volio = &volio;
	ffill.floodfill(COLOUR_RULE);
	//ffill.apply_result(0, volobject.texdepth*volobject.texheight*volobject.texwidth);
	ffill.delete_visited();

	/*Vector v;
	for(int i=0; i<ffill.cellmeans.size(); i++)
	{
		if(ffill.regions_todelete[i]==false)
		{
			v = ffill.cellmeans[i];
			v.x -= (float)volobject.texwidth/2.0;
			v.y -= (float)volobject.texheight/2.0;
			v.z -= (float)volobject.texdepth/2.0;

			v.x *= ffill.scaleX;
			v.y *= ffill.scaleY;
			v.z *= ffill.scaleZ;

			volrender.current_normals.push_back(Vector(0,0,0));
			volrender.current_measure_points.push_back(v);
			emit measure_point_signal(v);
		}
	}*/
	/*
	volrender.measure_region_size_min = volobject.texdepth*volobject.texheight*volobject.texwidth;
	volrender.measure_region_size_max = 0;
	volrender.measure_region_sizes.clear();
	int s;
	for(int i=0; i<ffill.region_indices.size(); i++)
	{
		s = ffill.region_indices[i].size();
		if(s>volrender.measure_region_size_max) volrender.measure_region_size_max = s;
		if(s<volrender.measure_region_size_min) volrender.measure_region_size_min = s;

		volrender.measure_region_sizes.push_back(s);
	}

	Vector v;
	volrender.measure_region_means.clear();
	for(int i=0; i<ffill.cellmeans.size(); i++)
	{
		v = ffill.cellmeans[i];
		v.x -= (float)volobject.texwidth/2.0;
		v.y -= (float)volobject.texheight/2.0;
		v.z -= (float)volobject.texdepth/2.0;

		v.x *= ffill.scaleX;
		v.y *= ffill.scaleY;
		v.z *= ffill.scaleZ;

		volrender.measure_region_means.push_back(v);
	}

	for(int i=0; i<volrender.measure_region_means.size(); i++)
	{
		volrender.current_normals.push_back(Vector(0,0,0));
		volrender.current_measure_points.push_back(volrender.measure_region_means[i]);
		emit measure_point_signal(volrender.measure_region_means[i]);
	}

	labeller_dialogue = new QDialog(this, "Labeller", 0);

		Q3BoxLayout* labeller_grp = new Q3BoxLayout(labeller_dialogue, Q3BoxLayout::TopToBottom, 4, 4, "labeller_grp");

			Q3ButtonGroup *labellermax_grp = new Q3ButtonGroup( 2, Qt::Horizontal, "", this);
				labellermax = 200;
				labellermax_lb = new QLabel( "Max. Region:	100%", labellermax_grp );
				labellermax_lb->setFixedWidth(128.0);
				//our max labellerold slicer
				labellermax_slider = new QSlider ( 0, 200, 1, 200, Qt::Horizontal, labellermax_grp, "labellermax_slider" );
				labellermax_slider->setTickmarks( QSlider::Below );
				labellermax_slider->setTracking(FALSE);
				labellermax_slider->setPageStep(0);
				labellermax_slider->setSingleStep(0);	   
				labellermax_slider->setTickInterval(10);
				labellermax_slider->setFixedWidth(256.0);
				connect( labellermax_slider, SIGNAL(valueChanged(int)), this, SLOT(measure_labellermax_slot(int)) );

			Q3ButtonGroup *labellermin_grp = new Q3ButtonGroup( 2, Qt::Horizontal, "", this);
				labellermin = 0;
				labellermin_lb = new QLabel( "Min. Region:	0%", labellermin_grp );
				labellermin_lb->setFixedWidth(128.0);
				//our min labellerold slicer
				labellermin_slider = new QSlider ( 0, 200, 1, 0, Qt::Horizontal, labellermin_grp, "labellermin_slider" );
				labellermin_slider->setTickmarks( QSlider::Below );
				labellermin_slider->setTracking(FALSE);
				labellermin_slider->setPageStep(0);
				labellermin_slider->setSingleStep(0);	   
				labellermin_slider->setTickInterval(10);
				labellermin_slider->setFixedWidth(256.0);
				connect( labellermin_slider, SIGNAL(valueChanged(int)), this, SLOT(measure_labellermin_slot(int)) );

			QPushButton *okbutton		= new QPushButton("OK",	this);
			connect(okbutton, SIGNAL( clicked () ), this, SLOT( measure_labellerokbutton_event() ) );

			QPushButton *cancelbutton		= new QPushButton("Cancel",	this);
			connect(cancelbutton, SIGNAL( clicked () ), this, SLOT( measure_labellercancbutton_event() ) );

		labeller_grp->addWidget(labellermin_grp);
		labeller_grp->addWidget(labellermax_grp);
		labeller_grp->addWidget(okbutton);
		labeller_grp->addWidget(cancelbutton);

	labeller_dialogue->show();*/
}
void QtGLWidget::measure_update_current_drawmode_slot(int drawmode)
{
//	printf("measure_update_current_drawmode_slot");

	volrender.current_measure_drawmode  = drawmode;
	
	if(volrender.current_measure_drawmode!=6) measure_rebuild_current_edges();
	if(volrender.current_measure_drawmode==8)
	{

		measure_labellerdialogue_event();
	//int maxsize=(float)(width*height*depth)/8.0f;
	//int minsize=1000;
	}

	redraw_event();
//	printf("measure_update_current_drawmode_slot: %d\n", volrender.current_measure_drawmode);
}
void QtGLWidget::measure_selected_vertindex_slot(int index)
{
	volrender.current_measure_vertindex = index;
	redraw_event();
	
	//printf("measure_selected_vertindex_slot current_measure_vertindex: %d\n",volrender.current_measure_vertindex);
}
void QtGLWidget::measure_setcutplane_slot(int selected, float translate, float rotang1, float rotang2)
{
	printf("SET ITEM: %d %f %f %f \n", selected, translate, rotang1, rotang2);
	
	if(selected==-1) return;
	
	cutplane_resetall_slot();
	cutplane_select_slot(selected);
	
	volrender.cutting_planes.planes[selected].translate = translate;
	volrender.cutting_planes.planes[selected].angleX = rotang1;
	volrender.cutting_planes.planes[selected].angleY = rotang2;

	Vector v1cen, v2cen, v3cen, v4cen, n, cen, vcen;
	Matrix4x4 rot_matX, rot_matY, axis_rotmat;
	
	//============================================================================
	//TRANSLATE
	//============================================================================		
	Vector _v1 = volrender.cutting_planes.planes[selected]._v1;
	Vector _v2 = volrender.cutting_planes.planes[selected]._v2;
	Vector _v3 = volrender.cutting_planes.planes[selected]._v3;
	Vector _v4 = volrender.cutting_planes.planes[selected]._v4;
	Vector _normal = volrender.cutting_planes.planes[selected].normal;
	
	Vector vv_0 = (_v1+(volrender.cutting_planes.planes[selected].translate*_normal));		
	Vector vv_1 = (_v2+(volrender.cutting_planes.planes[selected].translate*_normal));		
	Vector vv_2 = (_v3+(volrender.cutting_planes.planes[selected].translate*_normal));		
	Vector vv_3 = (_v4+(volrender.cutting_planes.planes[selected].translate*_normal));		

	volrender.cutting_planes.planes[selected]._v1 = (vv_0);
	volrender.cutting_planes.planes[selected]._v2 = (vv_1);
	volrender.cutting_planes.planes[selected]._v3 = (vv_2);
	volrender.cutting_planes.planes[selected]._v4 = (vv_3);
	volrender.cutting_planes.planes[selected].eval_planeequation();

	//============================================================================
	//ANGLEX
	//============================================================================

	//translate our clipping plane to the origin
	cen = volrender.cutting_planes.planes[selected].v1+volrender.cutting_planes.planes[selected].v2+volrender.cutting_planes.planes[selected].v3+volrender.cutting_planes.planes[selected].v4;
	cen *= 0.25;
	v1cen = volrender.cutting_planes.planes[selected].v1-cen;
	v2cen = volrender.cutting_planes.planes[selected].v2-cen;
	v3cen = volrender.cutting_planes.planes[selected].v3-cen;
	v4cen = volrender.cutting_planes.planes[selected].v4-cen;
	
	//rotate our x axis by our new angle
	v1cen.build_rotatemat(volrender.cutting_planes.planes[selected].perpX, volrender.cutting_planes.planes[selected].angleX, &rot_matX.m[0]);
	volrender.cutting_planes.planes[selected].perpY = volrender.cutting_planes.planes[selected].perpY.mult_matrix(rot_matX.m);
	
	//and evaluate our new normal for the new plane rotation
	n.cross(volrender.cutting_planes.planes[selected].perpY,volrender.cutting_planes.planes[selected].perpX);
	
	//now we can evaluate the rotation matrix to go from our original set of axis to the other
	axis_rotmat.find_rotationfromaxis(volrender.cutting_planes.planes[selected].perpX, volrender.cutting_planes.planes[selected].perpY, n, volrender.cutting_planes.planes[selected].axisX, volrender.cutting_planes.planes[selected].axisY, volrender.cutting_planes.planes[selected].axisZ);
	volrender.cutting_planes.planes[selected].rot_mat = axis_rotmat;
	
	//rotate our plane vertices now
	volrender.cutting_planes.planes[selected].rot_mat = axis_rotmat;	
	v1cen = v1cen.mult_matrix(volrender.cutting_planes.planes[selected].rot_mat.m);
	v2cen = v2cen.mult_matrix(volrender.cutting_planes.planes[selected].rot_mat.m);
	v3cen = v3cen.mult_matrix(volrender.cutting_planes.planes[selected].rot_mat.m);
	v4cen = v4cen.mult_matrix(volrender.cutting_planes.planes[selected].rot_mat.m);

	//and now retranslate our plane to its original position
	volrender.cutting_planes.planes[selected]._v1 = v1cen+cen;
	volrender.cutting_planes.planes[selected]._v2 = v2cen+cen;
	volrender.cutting_planes.planes[selected]._v3 = v3cen+cen;
	volrender.cutting_planes.planes[selected]._v4 = v4cen+cen;
	vcen = volrender.cutting_planes.planes[selected].centre-cen;
	volrender.cutting_planes.planes[selected]._v1 += vcen;
	volrender.cutting_planes.planes[selected]._v2 += vcen;
	volrender.cutting_planes.planes[selected]._v3 += vcen;
	volrender.cutting_planes.planes[selected]._v4 += vcen;
	volrender.cutting_planes.planes[selected].eval_planeequation();

	//============================================================================
	//ANGLEY
	//============================================================================

	//translate our clipping plane to the origin
	cen = volrender.cutting_planes.planes[selected].v1+volrender.cutting_planes.planes[selected].v2+volrender.cutting_planes.planes[selected].v3+volrender.cutting_planes.planes[selected].v4;
	cen *= 0.25;
	v1cen = volrender.cutting_planes.planes[selected].v1-cen;
	v2cen = volrender.cutting_planes.planes[selected].v2-cen;
	v3cen = volrender.cutting_planes.planes[selected].v3-cen;
	v4cen = volrender.cutting_planes.planes[selected].v4-cen;
	
	//rotate our y axis by our new angle
	v1cen.build_rotatemat(volrender.cutting_planes.planes[selected].perpY, volrender.cutting_planes.planes[selected].angleY, &rot_matY.m[0]);
	volrender.cutting_planes.planes[selected].perpX = volrender.cutting_planes.planes[selected].perpX.mult_matrix(rot_matY.m);

	//and evaluate our new normal for the new plane rotation
	n.cross(volrender.cutting_planes.planes[selected].perpX,volrender.cutting_planes.planes[selected].perpY);

	//now we can evaluate the rotation matrix to go from our original set of axis to the other
	axis_rotmat.find_rotationfromaxis(volrender.cutting_planes.planes[selected].perpX, volrender.cutting_planes.planes[selected].perpY, n, volrender.cutting_planes.planes[selected].axisX, volrender.cutting_planes.planes[selected].axisY, volrender.cutting_planes.planes[selected].axisZ);
	volrender.cutting_planes.planes[selected].rot_mat = axis_rotmat;
	
	//rotate our plane vertices now
	v1cen = v1cen.mult_matrix(volrender.cutting_planes.planes[selected].rot_mat.m);
	v2cen = v2cen.mult_matrix(volrender.cutting_planes.planes[selected].rot_mat.m);
	v3cen = v3cen.mult_matrix(volrender.cutting_planes.planes[selected].rot_mat.m);
	v4cen = v4cen.mult_matrix(volrender.cutting_planes.planes[selected].rot_mat.m);
	
	//and now retranslate our plane to its original position	
	volrender.cutting_planes.planes[selected]._v1 = v1cen+cen;
	volrender.cutting_planes.planes[selected]._v2 = v2cen+cen;
	volrender.cutting_planes.planes[selected]._v3 = v3cen+cen;
	volrender.cutting_planes.planes[selected]._v4 = v4cen+cen;
	vcen = volrender.cutting_planes.planes[selected].centre-cen;
	volrender.cutting_planes.planes[selected]._v1 += vcen;
	volrender.cutting_planes.planes[selected]._v2 += vcen;
	volrender.cutting_planes.planes[selected]._v3 += vcen;
	volrender.cutting_planes.planes[selected]._v4 += vcen;

	//============================================================================
	//evaluate the equation of the plane, the intersection points with the bounding box, and upload our planes to the GPU
	//============================================================================
	volrender.cutting_planes.planes[selected].eval_planeequation();
	volrender.cutting_planes.eval_planeintersections();
}
void QtGLWidget::measure_labels_slot(int vert_label, int length_label, int angle_label)
{
	volrender.measure_vertlabel = vert_label;
	volrender.measure_lengthlabel = length_label;
	volrender.measure_anglelabel = angle_label;
	redraw_event();
}
//===========================================================================================================

void QtGLWidget::light_volshader_slot(int id)
{
	volrender.volshader_event(id);

	redraw_event();
}
void QtGLWidget::light_gooch_lighting_slot(Vector warm, Vector cool, int contrib, int expon, int alpha, int degen)
{
	//printf("contrib: %d\n", contrib);
	//printf("expon: %d\n", expon);

	volrender.shaderGoochEvent(warm, cool, contrib, expon, alpha, degen);
	redraw_event();
}
void QtGLWidget::light_altitude_slot(float alt)
{
	volrender.light_altitude = alt;
//	volrender.aim_light();
	redraw_event();
}
void QtGLWidget::light_azimuth_slot(float azi)
{
	volrender.light_azimuth = azi;
//	volrender.aim_light();
	redraw_event();
}
void QtGLWidget::light_colour_slot(Vector amb, Vector diff, Vector spec)
{
	volrender.light_colours(amb, diff, spec);
	redraw_event();
}

//===========================================================================================================
void QtGLWidget::filter_slot(int filtertype, int size, double sigma, int dim, vector<bool> channels)
{
	printf("filter_slot\n");
	if(volobject.texwidth==1 || volobject.texheight==1 || volobject.texdepth==1) return;

	Filter filter;
	filter.volobj = &volobject;
	
	printf("channels: %d, %d, %d\n", (int)channels[0], (int)channels[1], (int)channels[2]);

	if(filtertype==1)
	{
		filter.apply_gaussian_filter(size, sigma, dim, channels);	
	}
	else if(filtertype==2)
	{
		filter.apply_median_filter(size, dim, channels);	
	}
	else if(filtertype==3)
	{
		filter.apply_unsharpmask_filter(size, sigma, dim, channels);	
	}
	else if(filtertype==4)
	{
		filter.apply_mean_filter(size, dim, channels);	
	}
	else if(filtertype==5)
	{
		int index1d;
		int voxel;

		int offset=0;
		if(channels[1]==true) offset=1;
		else if(channels[2]==true) offset=2;

		int threshval = volrender.ra_tmin;
		if(channels[1]==true) threshval = volrender.ga_tmin;
		else if(channels[2]==true) threshval = volrender.ba_tmin;

		//printf("Thresholding...\n");
		Q3ProgressDialog* progressbar = new Q3ProgressDialog("Thresholding...", "Cancel", volobject.texdepth, 0, "progress", TRUE);		
		progressbar->setCaption("Please Wait");
		progressbar->setMinimumDuration(10);

		//for(int z=volobject.boundingboxMin.z; z<volobject.boundingboxMax.z; z++)
		for(int z = 0; z <volobject.texdepth; z++)
		{	
			progressbar->setProgress(z);
			if (progressbar->wasCancelled()) break;
			
			//for(int x=volobject.boundingboxMin.x; x<volobject.boundingboxMax.x; x++)
			for(int x = 0; x <volobject.texwidth; x++)
			{
				//for(int y=volobject.boundingboxMin.y; y<volobject.boundingboxMax.y; y++)
				for(int y = 0; y <volobject.texheight; y++)
				{
					index1d = ((((z*volobject.texheight)+y)*volobject.texwidth)+x);						
					voxel = volrender.ragaba_tfunc[3*volobject.texture3d[3*index1d+offset]];						
					if(voxel<=threshval)	volobject.texture3d[3*index1d+offset] = 0;
				}
			}
		}
		progressbar->setProgress(volobject.texdepth);
		delete progressbar;
	}	
	else if(filtertype==6)
	{
		int index1d;
		int voxel;

		int offset=0;
		if(channels[1]==true) offset=1;
		else if(channels[2]==true) offset=2;

		Q3ProgressDialog* progressbar = new Q3ProgressDialog("Convertig to Binary...", "Cancel", volobject.texdepth, 0, "progress", TRUE);		
		progressbar->setCaption("Please Wait");
		progressbar->setMinimumDuration(10);

		//for(int z=volobject.boundingboxMin.z; z<volobject.boundingboxMax.z; z++)
		for(int z = 0; z <volobject.texdepth; z++)
		{	
			progressbar->setProgress(z);
			if (progressbar->wasCancelled()) break;
			
			//for(int x=volobject.boundingboxMin.x; x<volobject.boundingboxMax.x; x++)
			for(int x = 0; x <volobject.texwidth; x++)
			{
				//for(int y=volobject.boundingboxMin.y; y<volobject.boundingboxMax.y; y++)
				for(int y = 0; y <volobject.texheight; y++)
				{
					index1d = ((((z*volobject.texheight)+y)*volobject.texwidth)+x);	
					voxel = volrender.ragaba_tfunc[3*volobject.texture3d[3*index1d+offset]];					
					if(voxel>0)volobject.texture3d[3*index1d+offset] = 255;
				}
			}
		}		
		progressbar->setProgress(volobject.texdepth);
		delete progressbar;
	}
	else if(filtertype==7)
	{
		filter.apply_sobel3D_filter(dim, channels);	
	}
	else if(filtertype==8)
	{
		//autolevels_event
		filter.apply_auto_levels_filter(dim, channels);	
	}
	else if(filtertype==9)
	{
		//contraststretch_event	
		filter.apply_contrast_stretching_filter(dim, channels);	
	}

	filter.volobj = 0;

	volrender.load_TextureMap();
	emit frames_redraw_signal();
	redraw_event();
}
//===========================================================================================================

void QtGLWidget::rendersettings_framebuffer_lod_slot(int value)
{
	volrender.LOD_FBO_SIZE = value;
	if(value==0) return;
	volrender.init_FBO();
	redraw_event();
}
void QtGLWidget::rendersettings_framebuffer_slot(int value)
{
	volrender.FBO_SIZE = value;
	if(value==0) return;
	volrender.init_FBO();
	redraw_event();
}
void QtGLWidget::rendersettings_postprocess_slot(int value)
{
	volrender.postprocess2d_amount = value/100.0;
	volrender.postprocess2d_shader();
//	updateGL();

	redraw_event();
}
void QtGLWidget::rendersettings_silhouettes_slot(int value)
{
	volrender.silhouette_amount = value/100.0;
	volrender.silhouette_shader();
	updateGL();

//	redraw_event();
}
void QtGLWidget::rendersettings_numbslices_slot(int s)
{
	printf("numbslices: %d\n", s);

	volrender.slices = s;
	volrender.numbslices = s;
	volrender.load_1DLookupTables();

	redraw_event();
}
void QtGLWidget::rendersettings_numbsliceslod_slot(int s)
{
//	printf("%d\n", s);

	volrender.sliceslod = s;
	volrender.load_1DLookupTables();

	redraw_event();
}
void QtGLWidget::rendersettings_numbsliceslodtoggle_slot(int t)
{
	volrender.SlicesmoveLOD_toggle = t;
	volrender.load_1DLookupTables();
//	printf("%d\n", t);

	redraw_event();
}
void QtGLWidget::rendersettings_framebuffertoggle_slot(int t)
{
	volrender.FBOmoveLOD_toggle = t;

	redraw_event();
}
void QtGLWidget::rendersettings_postprocesstoggle_slot(int t)
{
	volrender.PostProcess_toggle = t;
//	printf("%d\n", t);

	redraw_event();
}
void QtGLWidget::rendersettings_maxtexturesize_slot(int t)
{
	volobject.maxsizeZ = volobject.maxsizeY = volobject.maxsizeX = t;
}
void QtGLWidget::rendersettings_renderquality_slot(float w)
{
	volrender.numbslices = volrender.slices = w*volobject.maxres*0.5;
	volrender.FBO_SIZE = w*volobject.maxres*0.75;

	if(volrender.FBO_SIZE>2.0*volobject.maxres) volrender.FBO_SIZE = 2.0*volobject.maxres;
	//if(volrender.numbslices>volobject.maxres) volrender.numbslices = volobject.maxres;

	/*printf("\n interp: %f\n\n", w);*/
//	printf("slices: %d\n", (int)volrender.numbslices);
//	printf("fbo: %d\n", volrender.FBO_SIZE);

	volrender.init_FBO();
	volrender.load_1DLookupTables();
	volrender.postprocess2d_shader();
	redraw_event();

}
void QtGLWidget::rendersettings_renderqualitylod_slot(float w)
{
	volrender.sliceslod = w*volobject.maxres*0.25;
	volrender.LOD_FBO_SIZE = w*volobject.maxres*0.5;
	//volrender.LOD_FBO_SIZE = volrender.FBO_SIZE;

	//if(volrender.FBO_SIZE>2.0*volobject.maxres) volrender.FBO_SIZE = 2.0*volobject.maxres;
	//if(volrender.numbslices>volobject.maxres) volrender.numbslices = volobject.maxres;

	/*printf("\n lod_interp: %f\n\n", w);*/
//	printf("lod_slices: %d\n", (int)volrender.sliceslod);
//	printf("lod_fbo: %d\n", volrender.LOD_FBO_SIZE);

	volrender.init_FBO();
	volrender.load_1DLookupTables();
	volrender.postprocess2d_shader();
	redraw_event();
}
void QtGLWidget::rendersettings_channelmode_slot(int r,int g,int b,int i)
{
//	printf("%d, %d, %d, %d\n", r,g,b,i);

	volrender.r_channel = r;
	volrender.g_channel = g;
	volrender.b_channel = b;

	redraw_event();
}
//===========================================================================================================
void QtGLWidget::crop_invsel_slot(int mode)
{
	printf("mode: %d\n", mode);

	volrender.crop_inv=!volrender.crop_inv;
	//else volrender.crop_inv=false;
}
void QtGLWidget::crop_reset_slot(void)
{
	printf("reset\n");
	volrender.cropping_mode=0;

	volrender.crop_shape.clear();
	volrender.crop_shape2d.clear();
	volrender.crop_triangles.clear();
	redraw_event();
}
void QtGLWidget::crop_start_slot(void)
{
	//printf("crop start\n");
	
	volrender.current_measure_drawmode = 3;
	volrender.cropping_mode=1;
	volrender.crop_shape.clear();
	volrender.crop_shape2d.clear();
	volrender.crop_triangles.clear();
	//measure_start_slot();
}
void QtGLWidget::crop_end_slot(void)
{
	//printf("crop end\n");
	volrender.cropping_mode=0;

	printf("crop mode: %d\n", (int)volrender.crop_inv);

	//printf("Applying CLIPPING planes... \n");
	int index=0;
	Vector v = Vector(0,0,0,0);
	
	Q3ProgressDialog* progressbar = new Q3ProgressDialog("Cropping the Volume Data...", "Cancel", volobject.texdepth, 0, "progress", TRUE);		
	progressbar->setCaption("Please Wait");
	progressbar->setMinimumDuration(10);

	float halfw = volobject.texwidth/2.0;
	float halfh = volobject.texheight/2.0;
	float halfd = volobject.texdepth/2.0;
	int r,g,b;

	float maxsize =  max(volobject.xsize, volobject.ysize);
	maxsize =  max(maxsize, volobject.zsize);

	Vector c;
	Vector res = Vector((volobject.xsize/maxsize), (volobject.ysize/maxsize), (volobject.zsize/maxsize));
	
	int helper,helper2;

	for(int z = 0; z <volobject.texdepth; z++)
	{	
		//progress(z, volobject.texdepth);
		progressbar->setProgress(z);
		if (progressbar->wasCancelled()) break;

		for(int x = 0; x <volobject.texwidth; x++)
		{
			for(int y = 0; y <volobject.texheight; y++)
			{
				index = ((((z*volobject.texheight)+y)*volobject.texwidth)+x);
				
				r = volobject.texture3d[3*index+0];
				g = volobject.texture3d[3*index+1];
				b = volobject.texture3d[3*index+2];

				if(r+g+b>0)
				{
					v.x = x-halfw;
					v.y = y-halfh;
					v.z = z-halfd;
					v.w = 0.0;

					v.x *= volobject.xsize/maxsize;
					v.y *= volobject.ysize/maxsize;
					v.z *= volobject.zsize/maxsize;

					helper2=0;
					for(int i=0; i<volrender.crop_normals.size()/3; i++)
					{
						helper=0;
						c = volrender.crop_centroids[3*i];
						if(volrender.crop_normals[3*i].dot(v-c)<0.0) helper++;
						c = volrender.crop_centroids[3*i+1];
						if(volrender.crop_normals[3*i+1].dot(v-c)<0.0) helper++;
						c = volrender.crop_centroids[3*i+2];
						if(volrender.crop_normals[3*i+2].dot(v-c)<0.0) helper++;

						if(helper==3)
						{
							//INSIDE
							if(volrender.crop_inv==true)
							{
								if(volrender.r_channel==1) volobject.texture3d[3*index+0] = GLubyte(0);
								if(volrender.g_channel==1) volobject.texture3d[3*index+1] = GLubyte(0);
								if(volrender.b_channel==1) volobject.texture3d[3*index+2] = GLubyte(0);
							}
						}
						else
						{
							//OUTSIDE
							if(volrender.crop_inv==false)
							{
								helper2++;
							}
						}
					}
					if(volrender.crop_inv==false)
					{
						if(helper2==volrender.crop_normals.size()/3)
						{
							//OUTSIDE ALL TRIANGLES
							if(volrender.r_channel==1) volobject.texture3d[3*index+0] = GLubyte(0);
							if(volrender.g_channel==1) volobject.texture3d[3*index+1] = GLubyte(0);
							if(volrender.b_channel==1) volobject.texture3d[3*index+2] = GLubyte(0); 
						}
					}
				}
			}
		}
	}

	progressbar->setProgress(volobject.texdepth);
	delete progressbar;

	volobject.compute_boundingbox();

	volrender.load_TextureMap();

	volrender.crop_shape.clear();
	volrender.crop_shape2d.clear();
	volrender.crop_triangles.clear();

	redraw_event();
	emit frames_redraw_signal();
}

//===========================================================================================================

void QtGLWidget::stereo_onoff_slot(int toggle)
{
	volrender.stereo_toggle = toggle;
	redraw_event();
}
void QtGLWidget::stereo_rendermode_slot(int mode)
{
	volrender.stereo_mode = mode;
	redraw_event();
}
void QtGLWidget::stereo_seperation_slot(float sep)
{
	volrender.stereo_eye_seperation = sep;
	redraw_event();
}

//===========================================================================================================

void QtGLWidget::cutplane_invert_slot(int selected)
{
	volrender.cutting_planes.invert_cut=selected;

	if(selected==1) volrender.cutting_planes.renderall=selected;
	if(selected==0)
	{
		volrender.cutting_planes.renderall=selected;
		planes_toggle = 0;
	}
	redraw_event();
}
void QtGLWidget::cutplane_showall_slot(int selected)
{
	volrender.cutting_planes.renderall=selected;
	volrender.cutting_planes.eval_planeintersections();
	redraw_event();
}
void QtGLWidget::cutplane_select_slot(int selected)
{
	volrender.cutting_planes.select(selected);

	planes_toggle = 0;
	for(int i=0; i<6; i++)
	{
		if(volrender.cutting_planes.selected[i]==1) planes_toggle=1;
	}
	redraw_event();
}
void QtGLWidget::cutplane_load_slot(QString fn)
{
	//volrender.cutting_planes.load(fn);
        cutplane_resetall_slot();
        volrender.cutting_planes.load(fn);      

        for(int i=0; i<6; i++)
        {
            volrender.cutting_planes.planes[i].perpX = volrender.cutting_planes.planes[i]._v2 - volrender.cutting_planes.planes[i]._v1;
            volrender.cutting_planes.planes[i].perpY = volrender.cutting_planes.planes[i]._v4 - volrender.cutting_planes.planes[i]._v1;

            volrender.cutting_planes.planes[i].perpX.normalize();
            volrender.cutting_planes.planes[i].perpY.normalize();

            cutplane_selected_slot(i);
            cutplane_planeslider_slot(0.0);
            cutplane_unselect_slot();

            /* Matrix4x4 axis_rotmat;

            axis_rotmat.find_rotationfromaxis(volrender.cutting_planes.planes[i].v1, volrender.cutting_planes.planes[i].v2, volrender.cutting_planes.planes[i].v3,
            volrender.cutting_planes.planes[i]._v1, volrender.cutting_planes.planes[i]._v2, volrender.cutting_planes.planes[i]._v3);

            volrender.cutting_planes.planes[i].perpX = volrender.cutting_planes.planes[i].axisX.mult_matrix(axis_rotmat.m);
            volrender.cutting_planes.planes[i].perpY = volrender.cutting_planes.planes[i].axisY.mult_matrix(axis_rotmat.m);
*/
            /*volrender.cutting_planes.planes[i].angleY = volrender.cutting_planes.planes[i].perpX.dot(volrender.cutting_planes.planes[i].axisX);
            volrender.cutting_planes.planes[i].angleX = volrender.cutting_planes.planes[i].perpY.dot(volrender.cutting_planes.planes[i].axisY);

            printf("angleX: %f\n", volrender.cutting_planes.planes[i].angleX);
            printf("angleY: %f\n", volrender.cutting_planes.planes[i].angleY);*/

            volrender.cutting_planes.planes[i].angleX = 0.0;
            volrender.cutting_planes.planes[i].angleY = 0.0;
            volrender.cutting_planes.planes[i].translate = 0.0;
        }

        redraw_event();
}
void QtGLWidget::cutplane_resetall_slot(void)
{
	volrender.cutting_planes.reset_all();
	planes_toggle = 0;
	redraw_event();
}
void QtGLWidget::cutplane_resetcurrent_slot(void)
{
	volrender.cutting_planes.reset_selected();
	redraw_event();
}
void QtGLWidget::cutplane_save_slot(QString fn)
{
	volrender.cutting_planes.save(fn);
	redraw_event();
}
void QtGLWidget::cutplane_redclip_slot(void)
{
	volrender.redclip_toggle = !volrender.redclip_toggle;
	redraw_event();
}
void QtGLWidget::cutplane_greenclip_slot(void)
{
	volrender.greenclip_toggle = !volrender.greenclip_toggle;
	redraw_event();
}
void QtGLWidget::cutplane_blueclip_slot(void)
{
	volrender.blueclip_toggle = !volrender.blueclip_toggle;
	redraw_event();
}
void QtGLWidget::cutplane_isoclip_slot(void)
{
	volrender.isoclip_toggle = !volrender.isoclip_toggle;
	redraw_event();
}
void QtGLWidget::cutplane_interact_clicked_slot(int mode)
{
	//emit cutplane_selected_signal(-1);
	volrender.cutting_planes.rotmode = mode;
}
void QtGLWidget::cutplane_applyall_drawmode_slot(void)
{
	int selected=-1;
	int i;

	for(i=0; i<6; i++)
	{
		if(volrender.cutting_planes.selected[i]==1) selected = i;
	}

	if(selected==-1) return;

	int drawmode = volrender.plane_rendermode[selected];

//	printf("drawmode: %d\n", drawmode);

	for(i=0; i<6; i++)
	{
		volrender.plane_rendermode[i]=drawmode;
	}

	redraw_event();	
}
void QtGLWidget::cutplane_solid_slot(bool on)
{
	//printf("boh\n");
	if(on)
	{
		volrender.volume_toggle=0;
		volrender.plane_rendermode[0]=2;
	}
	else
	{
		volrender.volume_toggle=1;
		volrender.plane_rendermode[0]=0;
	}
	redraw_event();	
}
void QtGLWidget::cutplane_unselect_slot(void)
{
	for(int i=0; i<6; i++) volrender.cutting_planes.selected[i] = -1;

	redraw_event();
}
void QtGLWidget::cutplane_selected_slot(int index)
{
	for(int i=0; i<6; i++)
	{
		volrender.cutting_planes.selected[i]=-1;
	}

	volrender.cutting_planes.select(index);
	emit cutplane_selectedupdate_signal(index, volrender.plane_rendermode[index]);	

	redraw_event();	
}
void QtGLWidget::cutplane_invcrop_slot(void)
{
	if(volobject.texture3d==NULL) return;

	invcrop();

	volrender.load_TextureMap();

	emit frames_redraw_signal();
	redraw_event();	
}
void QtGLWidget::cutplane_crop_slot(void)
{
	if(volobject.texture3d==NULL) return;

	crop();

	volrender.load_TextureMap();

	emit frames_redraw_signal();
	redraw_event();
}
void QtGLWidget::cutplane_realign_slot(void)
{
	if(volobject.texture3d==NULL) return;

	realign();

	volrender.load_TextureMap();

	emit frames_redraw_signal();
	redraw_event();	
}
void QtGLWidget::cutplane_recentre_slot(void)
{
	if(volobject.texture3d==NULL) return;

	recentre();

	volrender.load_TextureMap();

	volobject.compute_boundingbox();	

	float maxsize =  max((float)volobject.xsize, (float)volobject.ysize);
	maxsize =  max((float)maxsize, (float)volobject.zsize);
	
	//volrender.cutting_planes.init(volobject.boundingboxX*volobject.xsize/maxsize*1.25, volobject.boundingboxY*volobject.ysize/maxsize*1.25, volobject.boundingboxZ*volobject.zsize/maxsize*1.25);

	//TODO recompute the bounding box dimensions.!!!

	/*	Vector bb_size = Vector(volobject.boundingboxX*volobject.xsize/maxsize, volobject.boundingboxY*volobject.ysize/maxsize, volobject.boundingboxZ*volobject.zsize/maxsize);
	bb_size /= 2.0;
	volrender.bb_v1=volrender.bb_v1*bb_size;
	volrender.bb_v2=volrender.bb_v2*bb_size;
	volrender.bb_v3=volrender.bb_v3*bb_size;
	volrender.bb_v4=volrender.bb_v4*bb_size;
	volrender.bb_v5=volrender.bb_v5*bb_size;
	volrender.bb_v6=volrender.bb_v6*bb_size;
	volrender.bb_v7=volrender.bb_v7*bb_size;
	volrender.bb_v8=volrender.bb_v8*bb_size;
*/	
	
	emit frames_redraw_signal();
	redraw_event();
}
void QtGLWidget::cutplane_rendermode_slot(int drawmode)
{
//	printf("drawmode: %d\n", drawmode);
	
	int selected=-1;
	for(int i=0; i<6; i++)
	{
		if(volrender.cutting_planes.selected[i]==1) selected = i;
	}

	if(selected==-1) return;

	volrender.plane_rendermode[selected]=drawmode;
	redraw_event();	
}
void QtGLWidget::cutplane_planeslider_slot(float dist)
{
	int selected=-1;
	for(int i=0; i<6; i++)
	{
		if(volrender.cutting_planes.selected[i]==1) selected = i;
	}

	if(selected==-1) return;

//	printf("selected: %d\n", selected);
	
	Vector _v1 = volrender.cutting_planes.planes[selected]._v1;
	Vector _v2 = volrender.cutting_planes.planes[selected]._v2;
	Vector _v3 = volrender.cutting_planes.planes[selected]._v3;
	Vector _v4 = volrender.cutting_planes.planes[selected]._v4;
	Vector _normal = volrender.cutting_planes.planes[selected].normal;
	
	Vector vv_0 = (_v1+(dist*_normal));		
	Vector vv_1 = (_v2+(dist*_normal));		
	Vector vv_2 = (_v3+(dist*_normal));		
	Vector vv_3 = (_v4+(dist*_normal));		

	volrender.cutting_planes.planes[selected]._v1 = (vv_0);
	volrender.cutting_planes.planes[selected]._v2 = (vv_1);
	volrender.cutting_planes.planes[selected]._v3 = (vv_2);
	volrender.cutting_planes.planes[selected]._v4 = (vv_3);

	volrender.cutting_planes.planes[selected].eval_planeequation();
	volrender.cutting_planes.eval_planeintersections();

	Vector c1 = volrender.cutting_planes.planes[selected]._v1 + volrender.cutting_planes.planes[selected]._v2 + volrender.cutting_planes.planes[selected]._v3 + volrender.cutting_planes.planes[selected]._v4;
	c1 /= 4.0;
	Vector c2 = volrender.cutting_planes.planes[selected].v1 + volrender.cutting_planes.planes[selected].v2 + volrender.cutting_planes.planes[selected].v3 + volrender.cutting_planes.planes[selected].v4;
	c2 /= 4.0;
	Vector l = c1-c2;
	
	volrender.cutting_planes.planes[selected].translate = l.length();
//	printf("dist: %f\n", volrender.cutting_planes.planes[selected].translate);

	redraw_event();
}
void QtGLWidget::cutplane_planerot1_slot(float angle)
{
	//find which plane we have currently active
	int selected=-1;
	for(int i=0; i<6; i++)
	{
		if(volrender.cutting_planes.selected[i]==1) selected = i;
	}
	//if none then stop
	if(selected==-1) return;

	//increment our angle of rotation.
	volrender.cutting_planes.planes[selected].angleX += angle;

	//translate our clipping plane to the origin
	Vector cen = volrender.cutting_planes.planes[selected].v1+volrender.cutting_planes.planes[selected].v2+volrender.cutting_planes.planes[selected].v3+volrender.cutting_planes.planes[selected].v4;
	cen *= 0.25;
	Vector v1cen = volrender.cutting_planes.planes[selected].v1-cen;
	Vector v2cen = volrender.cutting_planes.planes[selected].v2-cen;
	Vector v3cen = volrender.cutting_planes.planes[selected].v3-cen;
	Vector v4cen = volrender.cutting_planes.planes[selected].v4-cen;

	Matrix4x4 rot_matX, axis_rotmat;
	Vector n;
	
	//rotate our x axis by our new angle
	v1cen.build_rotatemat(volrender.cutting_planes.planes[selected].perpX, angle, &rot_matX.m[0]);
	volrender.cutting_planes.planes[selected].perpY = volrender.cutting_planes.planes[selected].perpY.mult_matrix(rot_matX.m);
	
	//and evaluate our new normal for the new plane rotation
	n.cross(volrender.cutting_planes.planes[selected].perpY,volrender.cutting_planes.planes[selected].perpX);
	
	//now we can evaluate the rotation matrix to go from our original set of axis to the other
	axis_rotmat.find_rotationfromaxis(volrender.cutting_planes.planes[selected].perpX, volrender.cutting_planes.planes[selected].perpY, n, volrender.cutting_planes.planes[selected].axisX, volrender.cutting_planes.planes[selected].axisY, volrender.cutting_planes.planes[selected].axisZ);
	volrender.cutting_planes.planes[selected].rot_mat = axis_rotmat;
	
	//rotate our plane vertices now
	volrender.cutting_planes.planes[selected].rot_mat = axis_rotmat;	
	v1cen = v1cen.mult_matrix(volrender.cutting_planes.planes[selected].rot_mat.m);
	v2cen = v2cen.mult_matrix(volrender.cutting_planes.planes[selected].rot_mat.m);
	v3cen = v3cen.mult_matrix(volrender.cutting_planes.planes[selected].rot_mat.m);
	v4cen = v4cen.mult_matrix(volrender.cutting_planes.planes[selected].rot_mat.m);

	//and now retranslate our plane to its original position
	volrender.cutting_planes.planes[selected]._v1 = v1cen+cen;
	volrender.cutting_planes.planes[selected]._v2 = v2cen+cen;
	volrender.cutting_planes.planes[selected]._v3 = v3cen+cen;
	volrender.cutting_planes.planes[selected]._v4 = v4cen+cen;
	Vector vcen = volrender.cutting_planes.planes[selected].centre-cen;
	volrender.cutting_planes.planes[selected]._v1 += vcen;
	volrender.cutting_planes.planes[selected]._v2 += vcen;
	volrender.cutting_planes.planes[selected]._v3 += vcen;
	volrender.cutting_planes.planes[selected]._v4 += vcen;

	//evaluate the equation of the plane, the intersection points with the bounding box, and upload our planes to the GPU
	volrender.cutting_planes.planes[selected].eval_planeequation();
	volrender.cutting_planes.eval_planeintersections();
}
void QtGLWidget::cutplane_planerot2_slot(float angle)
{
	//find which plane we have currently active
	int selected=-1;
	for(int i=0; i<6; i++)
	{
		if(volrender.cutting_planes.selected[i]==1) selected = i;
	}
	//if none then stop
	if(selected==-1) return;

	//increment our angle of rotation.
	volrender.cutting_planes.planes[selected].angleY += angle;

	//translate our clipping plane to the origin
	Vector cen = volrender.cutting_planes.planes[selected].v1+volrender.cutting_planes.planes[selected].v2+volrender.cutting_planes.planes[selected].v3+volrender.cutting_planes.planes[selected].v4;
	cen *= 0.25;
	Vector v1cen = volrender.cutting_planes.planes[selected].v1-cen;
	Vector v2cen = volrender.cutting_planes.planes[selected].v2-cen;
	Vector v3cen = volrender.cutting_planes.planes[selected].v3-cen;
	Vector v4cen = volrender.cutting_planes.planes[selected].v4-cen;

	Matrix4x4 rot_matY, axis_rotmat;
	Vector n;
	
	//rotate our y axis by our new angle
	v1cen.build_rotatemat(volrender.cutting_planes.planes[selected].perpY, angle, &rot_matY.m[0]);
	volrender.cutting_planes.planes[selected].perpX = volrender.cutting_planes.planes[selected].perpX.mult_matrix(rot_matY.m);

	//and evaluate our new normal for the new plane rotation
	n.cross(volrender.cutting_planes.planes[selected].perpX,volrender.cutting_planes.planes[selected].perpY);

	//now we can evaluate the rotation matrix to go from our original set of axis to the other
	axis_rotmat.find_rotationfromaxis(volrender.cutting_planes.planes[selected].perpX, volrender.cutting_planes.planes[selected].perpY, n, volrender.cutting_planes.planes[selected].axisX, volrender.cutting_planes.planes[selected].axisY, volrender.cutting_planes.planes[selected].axisZ);
	volrender.cutting_planes.planes[selected].rot_mat = axis_rotmat;
	
	//rotate our plane vertices now
	v1cen = v1cen.mult_matrix(volrender.cutting_planes.planes[selected].rot_mat.m);
	v2cen = v2cen.mult_matrix(volrender.cutting_planes.planes[selected].rot_mat.m);
	v3cen = v3cen.mult_matrix(volrender.cutting_planes.planes[selected].rot_mat.m);
	v4cen = v4cen.mult_matrix(volrender.cutting_planes.planes[selected].rot_mat.m);
	
	//and now retranslate our plane to its original position	
	volrender.cutting_planes.planes[selected]._v1 = v1cen+cen;
	volrender.cutting_planes.planes[selected]._v2 = v2cen+cen;
	volrender.cutting_planes.planes[selected]._v3 = v3cen+cen;
	volrender.cutting_planes.planes[selected]._v4 = v4cen+cen;
	Vector vcen = volrender.cutting_planes.planes[selected].centre-cen;
	volrender.cutting_planes.planes[selected]._v1 += vcen;
	volrender.cutting_planes.planes[selected]._v2 += vcen;
	volrender.cutting_planes.planes[selected]._v3 += vcen;
	volrender.cutting_planes.planes[selected]._v4 += vcen;

	//evaluate the equation of the plane, the intersection points with the bounding box, and upload our planes to the GPU
	volrender.cutting_planes.planes[selected].eval_planeequation();
	volrender.cutting_planes.eval_planeintersections();
}
void QtGLWidget::cutplane_interact(float dy)
{
	int selected=-1;
	for(int i=0; i<6; i++)
	{
		if(volrender.cutting_planes.selected[i]==1) selected = i;
	}
	
	if(selected==-1) return;
	
	float translate, angle1, angle2;

	if(volrender.cutting_planes.rotmode==0)
	{
		dy *= (float)volobject.maxres/200.0;
		translate = dy;
		cutplane_planeslider_slot(dy);
		redraw_event();
	}
	if(volrender.cutting_planes.rotmode==1)
	{
		dy *= 360.0/200.0;
		Vector n0;
		n0.get_normal(volrender.cutting_planes.planes[selected].v1, volrender.cutting_planes.planes[selected].v2, volrender.cutting_planes.planes[selected].v3);
		Vector vv5;
		vv5.cross(n0, volrender.cutting_planes.planes[selected].normal);
		float angle = n0.signed_angle(volrender.cutting_planes.planes[selected].normal, vv5);
		angle=dy*(PI/180.0);
		angle1 = angle;
		cutplane_planerot1_slot(angle);
		redraw_event();
	}
	if(volrender.cutting_planes.rotmode==2)
	{
		dy *= 360.0/200.0;
		Vector n0;
		n0.get_normal(volrender.cutting_planes.planes[selected].v1, volrender.cutting_planes.planes[selected].v2, volrender.cutting_planes.planes[selected].v3);				
		Vector vv5;
		vv5.cross(n0, volrender.cutting_planes.planes[selected].normal);
		float angle = n0.signed_angle(volrender.cutting_planes.planes[selected].normal, vv5);
		angle=dy*(PI/180.0);
		angle2 = angle;
		cutplane_planerot2_slot(angle);
		redraw_event();
	}
}

//===========================================================================================================

void QtGLWidget::movie_orthosectmovie_slot(QWidget* parent, int sampling, int preview, QString dn)
{
	QColor oldcol = volrender.background_colour;
	QColor oldbackupcol = volrender.old_background_colour;
	
	volrender.old_background_colour = Qt::black;
	volrender.background_colour = Qt::black;

	int steps = sampling;
	int framecount_helper=0;
	int numbframes = ((volobject.texdepth)/steps)+((volobject.texheight)/steps)+((volobject.texwidth)/steps);

	int oldzoom = volrender.zoom;
	volrender.zoom = -(volobject.maxres/2.0)*0.85;
	
	Q3ProgressDialog* progressbar = new Q3ProgressDialog("Saving Movie Frames...", "Cancel", numbframes, parent, "progress", TRUE);		
	progressbar->setCaption("Please Wait");
	progressbar->setMinimumDuration(10);
	
	volrender.winWidth = width();
	volrender.winHeight = height();
	volrender.arcball.setBounds((GLfloat)width(), (GLfloat)height());

	QString filename = dn;
	QString extension = ".png";
	QString framenumber;

	if(!preview)
	{
		QDir dir = QDir(dn);
		dir.mkdir("XSections");
		dir.mkdir("YSections");
		dir.mkdir("ZSections");
	}
	
	QImage im;
	QPixmap pm;

	int x=0;
	int y=0;
	int z=0;
	int oldx=0;
	int oldy=0;
	int oldz=0;
	int i=0;
	int framecount=0;

	Vector mousepos;

	volrender.setViewfromEuler(x,y,z);

	volrender.x_slice=0;
	volrender.y_slice=0;
	volrender.z_slice=0;
	volrender.volume_toggle = 0;
	volrender.slice_draw_mode = 2;

	redraw_event();	

	for(i=0; i<volobject.texdepth; i+= steps)
	{
		emit frames_redraw_signal();
		redraw_event();
	
		//====================================================
		//save the current frame
		//====================================================
		framenumber.setNum(framecount+300000);
		filename = dn+"\\ZSections\\";
		filename += framenumber;
		filename += extension;
		makeCurrent();
		
		if(!preview) emit save_sectionimage_signal(filename, 0, i);
		
		/*if(!preview)
		{
			im = volrender.render_framebuffer(false);
			pm.convertFromImage(im);
			im.reset();
			if(!pm.isNull()) pm.save(filename, "PNG");
		}*/

		framecount++;
		//if(i<volobject.texdepth-1) 
		volrender.z_slice+=steps;
		//else volrender.z_slice-=steps;
		
		//if(volrender.z_slice<0) volrender.z_slice=0;
		framecount_helper++;
		progressbar->setProgress(framecount_helper);
		qApp->processEvents();
		if (progressbar->wasCancelled())
		{
			volrender.volume_toggle = 1;
			volrender.slice_draw_mode = 0;
			volrender.background_colour = oldcol;
			volrender.old_background_colour = oldbackupcol;
			volrender.zoom = oldzoom;

			redraw_event();
			delete progressbar;
			return;
		}
	}
	volrender.x_slice=0;
	volrender.y_slice=0;
	volrender.z_slice=0;

	x += 90;
	volrender.setViewfromEuler2(x,y,z);
	redraw_event();

	framecount=0;
	for(i=0; i<volobject.texheight; i+= steps)
	{
		emit frames_redraw_signal();
	
		redraw_event();	

		//====================================================
		//save the current frame
		//====================================================
		framenumber.setNum(framecount+200000);
		filename = dn+"\\YSections\\";
		filename += framenumber;
		filename += extension;

		if(!preview) emit save_sectionimage_signal(filename, 1, i);
		
		/*if(!preview)
		{
			im = volrender.render_framebuffer(false);
			pm.convertFromImage(im);			
			im.reset();
			if(!pm.isNull()) pm.save(filename, "PNG");
		}*/

		framecount++;
		//if(i<volobject.texheight-1) 
		volrender.y_slice+=steps;
		//else volrender.y_slice-=steps;
		//if(volrender.y_slice<0) volrender.y_slice=0;
		framecount_helper++;
		progressbar->setProgress(framecount_helper);
		qApp->processEvents();
		if (progressbar->wasCancelled())
		{
			volrender.volume_toggle = 1;
			volrender.slice_draw_mode = 0;
			volrender.background_colour = oldcol;
			volrender.old_background_colour = oldbackupcol;
			volrender.zoom = oldzoom;
			redraw_event();
			delete progressbar;
			return;
		}
	}
	volrender.x_slice=0;
	volrender.y_slice=0;
	volrender.z_slice=0;

	z += 90;
	volrender.setViewfromEuler2(x,y,z);
	redraw_event();
	updateOverlayGL();

	framecount=0;
	for(i=0; i<volobject.texwidth; i+= steps)
	{
		emit frames_redraw_signal();
		redraw_event();
	
		//====================================================
		//save the current frame
		//====================================================
		framenumber.setNum(framecount+100000);
		filename = dn+"\\XSections\\";
		filename += framenumber;
		filename += extension;
		makeCurrent();
		
		/*if(!preview)
		{
			im = volrender.render_framebuffer(false);
			pm.convertFromImage(im);
			im.reset();			
			if(!pm.isNull()) pm.save(filename, "PNG");
		}*/
		if(!preview) emit save_sectionimage_signal(filename, 2, i);
	

		framecount++;
		//if(i<volobject.texwidth-1)
		volrender.x_slice+=steps;
		//else volrender.x_slice-=steps;
		//if(volrender.x_slice<0) volrender.x_slice=0;
		framecount_helper++;
		progressbar->setProgress(framecount_helper);
		qApp->processEvents();
		if (progressbar->wasCancelled())
		{
			volrender.volume_toggle = 1;
			volrender.slice_draw_mode = 0;
			volrender.background_colour = oldcol;
			volrender.old_background_colour = oldbackupcol;
			volrender.zoom = oldzoom;
			redraw_event();
			delete progressbar;
			return;
		}
	}

	volrender.volume_toggle = 1;
	volrender.slice_draw_mode = 0;
	volrender.background_colour = oldcol;
	volrender.old_background_colour = oldbackupcol;
	volrender.zoom = oldzoom;

	redraw_event();
	
	delete progressbar;
	progressbar = NULL;
}
void QtGLWidget::movie_rockmovie_slot(QWidget* parent, int sampling, int preview, QString dn, float ang)
{
	int framecount=0;
	int steps = sampling;

	/*Q3ProgressDialog* progressbar = new Q3ProgressDialog("Saving Movie Frames...", "Cancel", ang, parent, "progress", TRUE);		
	progressbar->setCaption("Please Wait");
	progressbar->setMinimumDuration(10);*/

	for(int ii=0; ii<volrender.timelapsefoldersize; ii+=2)
	{
		for(int i=0; i>=-ang/2.0; i-=steps)
		{
			volrender.setViewfromEuler2(0,(float)i,0);

			/*progressbar->setProgress(i);
			qApp->processEvents();
			if (progressbar->wasCancelled())
			{
				delete progressbar;
				progressbar = NULL;
				volrender.setViewfromEuler2(0,0,0);
				makeCurrent();
				redraw_event();
				updateOverlayGL();
				return;
			}*/

			QString filename = dn + "//";
			QString extension = ".png";
			QString framenumber;		
			framenumber.setNum(framecount+100000);
			filename += framenumber;
			filename += extension;
			
			redraw_event();
			
			if(!preview)
			{
				QImage im = volrender.render_framebuffer(false);
				QPixmap pm;
				pm.convertFromImage(im);
				im.reset();
				if(!pm.isNull()) pm.save(filename, "PNG");	
			}
			
			framecount = framecount + 1;
		}
		emit timelapseEvent();
		for(int i=-ang/2.0; i<=ang/2.0; i+=steps)
		{
			volrender.setViewfromEuler2(0,(float)i,0);

			/*progressbar->setProgress(i);
			qApp->processEvents();
			if (progressbar->wasCancelled())
			{
				delete progressbar;
				progressbar = NULL;
				volrender.setViewfromEuler2(0,0,0);
				makeCurrent();
				redraw_event();
				updateOverlayGL();
				return;
			}*/

			QString filename = dn + "//";
			QString extension = ".png";
			QString framenumber;		
			framenumber.setNum(framecount+100000);
			filename += framenumber;
			filename += extension;
			
			redraw_event();
			
			if(!preview)
			{
				QImage im = volrender.render_framebuffer(false);
				QPixmap pm;
				pm.convertFromImage(im);
				im.reset();
				if(!pm.isNull()) pm.save(filename, "PNG");	
			}
			
			framecount = framecount + 1;
		}
		emit timelapseEvent();
		for(int i=ang/2.0; i>=0; i-=steps)
		{
			volrender.setViewfromEuler2(0,(float)i,0);

			/*progressbar->setProgress(i);
			qApp->processEvents();
			if (progressbar->wasCancelled())
			{
				delete progressbar;
				progressbar = NULL;
				volrender.setViewfromEuler2(0,0,0);
				makeCurrent();
				redraw_event();
				updateOverlayGL();
				return;
			}*/

			QString filename = dn + "//";
			QString extension = ".png";
			QString framenumber;		
			framenumber.setNum(framecount+100000);
			filename += framenumber;
			filename += extension;
			
			redraw_event();
			
			if(!preview)
			{
				QImage im = volrender.render_framebuffer(false);
				QPixmap pm;
				pm.convertFromImage(im);
				im.reset();
				if(!pm.isNull()) pm.save(filename, "PNG");	
			}
			
			framecount = framecount + 1;
		}
	}
/*	delete progressbar;
	progressbar = NULL;
	volrender.benchmark=0;*/

	/*for(int i=0; i<volrender.timelapsefoldersize; i++)
	{
		emit timelapseEvent();
		redraw_event();
	}*/

	redraw_event();
}
void QtGLWidget::movie_rotmovie_slot(QWidget* parent, int sampling, int preview, QString dn, int x, int y, int z, float ang)
{
//	volrender.benchmark=1;

	/*ofstream fout;												
	if(volrender.benchmark)
	{
		volrender.timer.startQTime();
	}*/

	int framecount=0;
	int steps = sampling;

	Q3ProgressDialog* progressbar = new Q3ProgressDialog("Saving Movie Frames...", "Cancel", ang, parent, "progress", TRUE);		
	progressbar->setCaption("Please Wait");
	progressbar->setMinimumDuration(10);

	for(int i=0; i<=ang; i+=steps)
	{
		if(x==1 && y==0 && z==0) volrender.setViewfromEuler2((float)i,0,0);
		if(x==0 && y==1 && z==0) volrender.setViewfromEuler2(0,(float)i,0);
		if(x==0 && y==0 && z==1) volrender.setViewfromEuler2(0,0,(float)i);
		if(x==1 && y==1 && z==0) volrender.setViewfromEuler2((float)i,(float)i,0);
		if(x==1 && y==0 && z==1) volrender.setViewfromEuler2((float)i,0,(float)i);
		if(x==0 && y==1 && z==1) volrender.setViewfromEuler2(0,(float)i,(float)i);
		if(x==1 && y==1 && z==1) volrender.setViewfromEuler2((float)i,(float)i,(float)i);

		progressbar->setProgress(i);
		qApp->processEvents();
		if (progressbar->wasCancelled())
		{
			delete progressbar;
			progressbar = NULL;
			volrender.setViewfromEuler2(0,0,0);
			makeCurrent();
			redraw_event();
			updateOverlayGL();
			return;
		}

		QString filename = dn + "//";
		QString extension = ".png";
		QString framenumber;		
		framenumber.setNum(framecount+100000);
		filename += framenumber;
		filename += extension;
		
		redraw_event();
		
		if(!preview)
		{
			QImage im = volrender.render_framebuffer(false);
			QPixmap pm;
			pm.convertFromImage(im);
			im.reset();
			if(!pm.isNull()) pm.save(filename, "PNG");	
		}
		
		framecount = framecount + 1;
	}
	
	/*if(volrender.benchmark)
	{
		float sec = volrender.timer.endQTime();
		fout.open("benchmark.txt");
		fout<<sec<<endl;
		fout.close();
	}*/
	
	delete progressbar;
	progressbar = NULL;
	volrender.benchmark=0;

	redraw_event();
}
void QtGLWidget::movie_crossfademovie_slot(QWidget* parent, int sampling, int preview, QString dn, int x, int y, int z, float ang, int ch1, int ch2, int ch3)
{
	int framecount=0;
	int steps = sampling;
	float interp=0;

	Q3ProgressDialog* progressbar = new Q3ProgressDialog("Saving Movie Frames...", "Cancel", ang, parent, "progress", TRUE);		
	progressbar->setCaption("Please Wait");
	progressbar->setMinimumDuration(10);

	printf("%d %d %d\n", ch1, ch2, ch3);

	float anginterp = 0.0;

	if(ch1!=3)
	{
		anginterp++;
	}
	if(ch2!=3)
	{
		anginterp++;
	}
	if(ch3!=3)
	{
		anginterp++;
	}

	if(anginterp==0) return;
	//printf("anginterp: %f\n", anginterp);

	int dontrotate=0;

	if(ang==0.0)
	{
		ang = 200;
		dontrotate=1; 
	}
	float angleperchannel = ang/(anginterp-1);

	//printf("angleperchannel: %f\n", angleperchannel);

	float racont = volrender.ra_cont;
	float gacont = volrender.ga_cont;
	float bacont = volrender.ba_cont;

	volrender.apply_brightcontrast(6, volrender.ra_bright, racont*(0.0)); 
	volrender.apply_brightcontrast(7, volrender.ga_bright, gacont*(0.0)); 
	volrender.apply_brightcontrast(8, volrender.ba_bright, bacont*(0.0));
	makeCurrent();
	redraw_event();
	updateOverlayGL();

	for(int i=0; i<=angleperchannel; i+=steps)
	{
		interp = (i/angleperchannel);		

		if(ch1==0) volrender.apply_brightcontrast(6, volrender.ra_bright, racont*(1.0-interp)); 
		else if(ch1==1) volrender.apply_brightcontrast(7, volrender.ga_bright, gacont*(1.0-interp)); 
		else if(ch1==2) volrender.apply_brightcontrast(8, volrender.ba_bright, bacont*(1.0-interp));

		if(ch2==0) volrender.apply_brightcontrast(6, volrender.ra_bright, racont*interp); 
		else if(ch2==1) volrender.apply_brightcontrast(7, volrender.ga_bright, gacont*interp); 
		else if(ch2==2) volrender.apply_brightcontrast(8, volrender.ba_bright, bacont*interp);

		if(dontrotate==0)
		{
			if(x==1 && y==0 && z==0) volrender.setViewfromEuler2((float)i,0,0);
			if(x==0 && y==1 && z==0) volrender.setViewfromEuler2(0,(float)i,0);
			if(x==0 && y==0 && z==1) volrender.setViewfromEuler2(0,0,(float)i);
			if(x==1 && y==1 && z==0) volrender.setViewfromEuler2((float)i,(float)i,0);
			if(x==1 && y==0 && z==1) volrender.setViewfromEuler2((float)i,0,(float)i);
			if(x==0 && y==1 && z==1) volrender.setViewfromEuler2(0,(float)i,(float)i);
			if(x==1 && y==1 && z==1) volrender.setViewfromEuler2((float)i,(float)i,(float)i);
		}

		progressbar->setProgress(i);
		qApp->processEvents();

		if (progressbar->wasCancelled())
		{
			delete progressbar;
			progressbar = NULL;
			volrender.setViewfromEuler2(0,0,0);
			volrender.apply_brightcontrast(6, volrender.ra_bright, racont); 
			volrender.apply_brightcontrast(7, volrender.ga_bright, gacont); 
			volrender.apply_brightcontrast(8, volrender.ba_bright, bacont); 
			makeCurrent();
			redraw_event();
			updateOverlayGL();
			return;
		}

		QString filename = dn + "//";
		QString extension = ".png";
		QString framenumber;		
		framenumber.setNum(framecount+100000);
		filename += framenumber;
		filename += extension;
		
		makeCurrent();
		redraw_event();
		updateOverlayGL();
		
		if(!preview)
		{
			QImage im = volrender.render_framebuffer(false);
			QPixmap pm;
			pm.convertFromImage(im);
			im.reset();
			if(!pm.isNull()) pm.save(filename, "PNG");	
		}
		
		framecount = framecount + 1;
	}
	for(int i=angleperchannel; i<=angleperchannel+angleperchannel; i+=steps)
	{
		interp = ((i-angleperchannel)/angleperchannel);		

		if(ch2==0) volrender.apply_brightcontrast(6, volrender.ra_bright, racont*(1.0-interp)); 
		else if(ch2==1) volrender.apply_brightcontrast(7, volrender.ga_bright, gacont*(1.0-interp)); 
		else if(ch2==2) volrender.apply_brightcontrast(8, volrender.ba_bright, bacont*(1.0-interp));

		if(ch3==0) volrender.apply_brightcontrast(6, volrender.ra_bright, racont*interp); 
		else if(ch3==1) volrender.apply_brightcontrast(7, volrender.ga_bright, gacont*interp); 
		else if(ch3==2) volrender.apply_brightcontrast(8, volrender.ba_bright, bacont*interp);

		if(dontrotate==0)
		{
			if(x==1 && y==0 && z==0) volrender.setViewfromEuler2((float)i,0,0);
			if(x==0 && y==1 && z==0) volrender.setViewfromEuler2(0,(float)i,0);
			if(x==0 && y==0 && z==1) volrender.setViewfromEuler2(0,0,(float)i);
			if(x==1 && y==1 && z==0) volrender.setViewfromEuler2((float)i,(float)i,0);
			if(x==1 && y==0 && z==1) volrender.setViewfromEuler2((float)i,0,(float)i);
			if(x==0 && y==1 && z==1) volrender.setViewfromEuler2(0,(float)i,(float)i);
			if(x==1 && y==1 && z==1) volrender.setViewfromEuler2((float)i,(float)i,(float)i);
		}

		progressbar->setProgress(i);
		qApp->processEvents();

		if (progressbar->wasCancelled())
		{
			delete progressbar;
			progressbar = NULL;
			volrender.setViewfromEuler2(0,0,0);
			volrender.apply_brightcontrast(6, volrender.ra_bright, racont); 
			volrender.apply_brightcontrast(7, volrender.ga_bright, gacont); 
			volrender.apply_brightcontrast(8, volrender.ba_bright, bacont); 
			makeCurrent();
			redraw_event();
			updateOverlayGL();
			return;
		}

		QString filename = dn + "//";
		QString extension = ".png";
		QString framenumber;		
		framenumber.setNum(framecount+100000);
		filename += framenumber;
		filename += extension;
		
		makeCurrent();
		redraw_event();
		updateOverlayGL();
		
		if(!preview)
		{
			QImage im = volrender.render_framebuffer(false);
			QPixmap pm;
			pm.convertFromImage(im);
			im.reset();
			if(!pm.isNull()) pm.save(filename, "PNG");	
		}
		
		framecount = framecount + 1;
	}
	
	delete progressbar;
	progressbar = NULL;

	volrender.apply_brightcontrast(6, volrender.ra_bright, racont); 
	volrender.apply_brightcontrast(7, volrender.ga_bright, gacont); 
	volrender.apply_brightcontrast(8, volrender.ba_bright, bacont);

	redraw_event();
	updateOverlayGL();	
}
void QtGLWidget::movie_fademovie_slot(QWidget* parent, int sampling, int preview, QString dn, int x, int y, int z, float ang, int ch1, int ch2, int ch3)
{
	int framecount=0;
	int steps = sampling;
	float interp=0;

	Q3ProgressDialog* progressbar = new Q3ProgressDialog("Saving Movie Frames...", "Cancel", ang, parent, "progress", TRUE);		
	progressbar->setCaption("Please Wait");
	progressbar->setMinimumDuration(10);

	printf("%d %d %d\n", ch1, ch2, ch3);

	float racont = volrender.ra_cont;
	float gacont = volrender.ga_cont;
	float bacont = volrender.ba_cont;

	for(int i=0; i<=ang; i+=steps)
	{
		if(i<(ang/3.0))
		{
			interp = 1.0-(i/(ang/3.0));
			//interp *= 100.0;
			//printf("%f\n", interp);

			if(ch1==0) volrender.apply_brightcontrast(6, volrender.ra_bright, racont*interp); 
			if(ch2==0) volrender.apply_brightcontrast(7, volrender.ga_bright, gacont*interp); 
			if(ch3==0) volrender.apply_brightcontrast(8, volrender.ba_bright, bacont*interp);
		}

		if(i>(2.0*(ang/3.0)))
		{
			interp = (i-(2.0*(ang/3.0)))/(ang/3.0);
			//interp *= 100.0;
			//printf("%f\n", interp);

			if(ch1==0) volrender.apply_brightcontrast(6, volrender.ra_bright, racont*interp); 
			if(ch2==0) volrender.apply_brightcontrast(7, volrender.ga_bright, gacont*interp); 
			if(ch3==0) volrender.apply_brightcontrast(8, volrender.ba_bright, bacont*interp);
		}


		if(x==1 && y==0 && z==0) volrender.setViewfromEuler2((float)i,0,50);
		if(x==0 && y==1 && z==0) volrender.setViewfromEuler2(0,(float)i,0);
		if(x==0 && y==0 && z==1) volrender.setViewfromEuler2(0,0,(float)i);
		if(x==1 && y==1 && z==0) volrender.setViewfromEuler2((float)i,(float)i,0);
		if(x==1 && y==0 && z==1) volrender.setViewfromEuler2((float)i,0,(float)i);
		if(x==0 && y==1 && z==1) volrender.setViewfromEuler2(0,(float)i,(float)i);
		if(x==1 && y==1 && z==1) volrender.setViewfromEuler2((float)i,(float)i,(float)i);

		progressbar->setProgress(i);
		qApp->processEvents();

		if (progressbar->wasCancelled())
		{
			delete progressbar;
			progressbar = NULL;
			volrender.setViewfromEuler2(0,0,0);
			volrender.apply_brightcontrast(6, volrender.ra_bright, racont); 
			volrender.apply_brightcontrast(7, volrender.ga_bright, gacont); 
			volrender.apply_brightcontrast(8, volrender.ba_bright, bacont); 
			makeCurrent();
			redraw_event();
			updateOverlayGL();
			return;
		}

		QString filename = dn + "//";
		QString extension = ".png";
		QString framenumber;		
		framenumber.setNum(framecount+100000);
		filename += framenumber;
		filename += extension;
		
		makeCurrent();
		redraw_event();
		updateOverlayGL();
		
		if(!preview)
		{
			QImage im = volrender.render_framebuffer(false);
			QPixmap pm;
			pm.convertFromImage(im);
			im.reset();
			if(!pm.isNull()) pm.save(filename, "PNG");	
		}
		
		framecount = framecount + 1;
	}
	
	delete progressbar;
	progressbar = NULL;

	redraw_event();
	updateOverlayGL();	
}
void QtGLWidget::movie_clipmovie_slot(QWidget* parent, int sampling, int preview, QString dn, int xaxis, int yaxis, int zaxis, float ang, int clipmode, int clipafterrot)
{
	int x=0;
	int y=0;
	int z=0;
	int oldx=0;
	int oldy=0;
	int oldz=0;
	int i=0;
	int steps = sampling;
	int framecount = 0;
	
	Vector mousepos = 0.0;
	volrender.cutting_planes.invert_cut=0;
	planes_toggle = 1;

	//select the right clipping plane and size
	int clipplane_selected = 0;
	int clipdimensions = 0;

	volrender.cutting_planes.moviemode = 1;

	if(clipmode==3)
	{
		clipplane_selected = 1;
		clipdimensions = volobject.texdepth;
	}
	else if(clipmode==2)
	{
		clipplane_selected = 5;
		clipdimensions = volobject.texheight;
	}
	else if(clipmode==1)
	{
		clipplane_selected = 3;
		clipdimensions = volobject.texwidth;
	}
	else if(clipmode==0)
	{
		clipplane_selected = 1;
	
		clipdimensions=0.0;

		if(clipdimensions<volobject.texdepth*1.5)
			clipdimensions = volobject.texdepth*1.5;
		
		if(clipdimensions<volobject.texheight*1.5)
			clipdimensions = volobject.texheight*1.5;

		if(clipdimensions<volobject.texwidth*1.5)
			clipdimensions = volobject.texwidth*1.5;

		Vector v1, v2, v3, v4;
		v1 = Vector(-1.0,  1.0,  1.0);
		v2 = Vector( 1.0,  1.0,  1.0);
		v3 = Vector(-1.0, -1.0,  1.0);
		v4 = Vector( 1.0, -1.0,  1.0);
		v1 *= clipdimensions/2.0;
		v2 *= clipdimensions/2.0;
		v3 *= clipdimensions/2.0;
		v4 *= clipdimensions/2.0;

		//Matrix4f_t mat = Matrix4fInverse(&volrender.arcball.Transform);
		Matrix4f_t mat = volrender.arcball.Transform;
		
	/*	v1 = v1.mult_matrix(mat.M);
		v2 = v2.mult_matrix(mat.M);
		v3 = v3.mult_matrix(mat.M);
		v4 = v4.mult_matrix(mat.M);
*/
		Matrix4fMulVector4f(mat, &v1);
		Matrix4fMulVector4f(mat, &v2);
		Matrix4fMulVector4f(mat, &v3);
		Matrix4fMulVector4f(mat, &v4);

		volrender.cutting_planes.planes[clipplane_selected] = PlaneWidget(v1,v2,v4,v3,1);
		volrender.cutting_planes.planes[clipplane_selected]._v1 = v1;
		volrender.cutting_planes.planes[clipplane_selected]._v2 = v2;
		volrender.cutting_planes.planes[clipplane_selected]._v3 = v4;
		volrender.cutting_planes.planes[clipplane_selected]._v4 = v3;
		volrender.cutting_planes.planes[clipplane_selected].v1 = v1;
		volrender.cutting_planes.planes[clipplane_selected].v2 = v2;
		volrender.cutting_planes.planes[clipplane_selected].v3 = v4;
		volrender.cutting_planes.planes[clipplane_selected].v4 = v3;
		volrender.cutting_planes.planes[clipplane_selected].normal.get_normal(v1,v2,v3);
		volrender.cutting_planes.planes[clipplane_selected].eval_planeequation();
		volrender.cutting_planes.planes[clipplane_selected].mouseMove(Vector(0.0, 0.0, 0.0));

		//volrender.cutting_planes.planes[clipplane_selected].eval_planeequation();
	}

	float anglestepper = ang / clipdimensions;
	anglestepper /= 2.0;
	anglestepper *= steps;

	if(ang==0) anglestepper = 0.0;
	float angiterp = 0;

	if(clipafterrot==0) ang = 0;

	Q3ProgressDialog* progressbar = new Q3ProgressDialog("Saving Movie Frames...", "Cancel", ang+2+(clipdimensions*2.0)/steps, parent, "progress", TRUE);		
	progressbar->setCaption("Please Wait");
	progressbar->setMinimumDuration(10);

	if(clipafterrot==1)
	{
		for(int i=0; i<=ang; i+=steps)
		{
			if(xaxis==1 && yaxis==0 && zaxis==0) volrender.setViewfromEuler2((float)i,0,0);
			if(xaxis==0 && yaxis==1 && zaxis==0) volrender.setViewfromEuler2(0,(float)i,0);
			if(xaxis==0 && yaxis==0 && zaxis==1) volrender.setViewfromEuler2(0,0,(float)i);
			if(xaxis==1 && yaxis==1 && zaxis==0) volrender.setViewfromEuler2((float)i,(float)i,0);
			if(xaxis==1 && yaxis==0 && zaxis==1) volrender.setViewfromEuler2((float)i,0,(float)i);
			if(xaxis==0 && yaxis==1 && zaxis==1) volrender.setViewfromEuler2(0,(float)i,(float)i);
			if(xaxis==1 && yaxis==1 && zaxis==1) volrender.setViewfromEuler2((float)i,(float)i,(float)i);

			progressbar->setProgress(i);
			qApp->processEvents();
			if (progressbar->wasCancelled())
			{
				delete progressbar;
				progressbar = NULL;
				volrender.setViewfromEuler2(0,0,0);
				volrender.cutting_planes.reset_all();
				makeCurrent();
				redraw_event();
				updateOverlayGL();
				return;
			}

			QString filename = dn + "//";
			QString extension = ".png";
			QString framenumber;		
			framenumber.setNum(framecount+100000);
			filename += framenumber;
			filename += extension;
			
			makeCurrent();
			redraw_event();
			updateOverlayGL();
			
			if(!preview)
			{
				QImage im = volrender.render_framebuffer(false);
				QPixmap pm;
				pm.convertFromImage(im);
				im.reset();
				if(!pm.isNull()) pm.save(filename, "PNG");
			}
			
			framecount = framecount + 1;
		}
	}

	volrender.cutting_planes.select(clipplane_selected);
	volrender.cutting_planes.mousePress(mousepos, 3);
	for(i=0; i>=-clipdimensions; i-=steps)
	{
		if(clipafterrot==0)
		{
			if(xaxis==1 && yaxis==0 && zaxis==0) volrender.setViewfromEuler2((float)angiterp,0,0);
			if(xaxis==0 && yaxis==1 && zaxis==0) volrender.setViewfromEuler2(0,(float)angiterp,0);
			if(xaxis==0 && yaxis==0 && zaxis==1) volrender.setViewfromEuler2(0,0,(float)angiterp);
			if(xaxis==1 && yaxis==1 && zaxis==0) volrender.setViewfromEuler2((float)angiterp,(float)angiterp,0);
			if(xaxis==1 && yaxis==0 && zaxis==1) volrender.setViewfromEuler2((float)angiterp,0,(float)angiterp);
			if(xaxis==0 && yaxis==1 && zaxis==1) volrender.setViewfromEuler2(0,(float)angiterp,(float)angiterp);
			if(xaxis==1 && yaxis==1 && zaxis==1) volrender.setViewfromEuler2((float)angiterp,(float)angiterp,(float)angiterp);
		}

		//move our clipping plane
		mousepos.y = i;
		volrender.cutting_planes.mouseMove(mousepos);

		//save the current frame
		QString filename = dn + "//";
		QString extension = ".png";
		QString framenumber;		
		framenumber.setNum(framecount+100000);
		filename += framenumber;
		filename += extension;
		
		makeCurrent();
		redraw_event();
		updateOverlayGL();
		if(!preview)
		{
			QImage im = volrender.render_framebuffer(false);
			QPixmap pm;
			pm.convertFromImage(im);
			im.reset();
			if(!pm.isNull()) pm.save(filename, "PNG");	
		}

		//update our frame counter
		framecount = framecount + 1;

		//update our progress bar
		progressbar->setProgress(framecount);
		qApp->processEvents();
		if (progressbar->wasCancelled()) 
		{
			Vector v1, v2, v3, v4;
			v1 = Vector(-1.0,  1.0,  1.0);
			v2 = Vector( 1.0,  1.0,  1.0);
			v3 = Vector(-1.0, -1.0,  1.0);
			v4 = Vector( 1.0, -1.0,  1.0);
			v1 *= clipdimensions/2.0;
			v2 *= clipdimensions/2.0;
			v3 *= clipdimensions/2.0;
			v4 *= clipdimensions/2.0;
			volrender.cutting_planes.planes[clipplane_selected] = PlaneWidget(v1,v2,v4,v3,1);

			volrender.setViewfromEuler2(0,0,0);
			//volrender.cutting_planes.select(-1);
			planes_toggle = 0;
			volrender.cutting_planes.reset_all();
			redraw_event();
			updateOverlayGL();
			volrender.cutting_planes.moviemode = 0;
			return;
		}

		angiterp += anglestepper;
	}
	for(i=-clipdimensions; i<=0; i+=steps)
	{
		if(clipafterrot==0)
		{
			if(xaxis==1 && yaxis==0 && zaxis==0) volrender.setViewfromEuler2((float)angiterp,0,0);
			if(xaxis==0 && yaxis==1 && zaxis==0) volrender.setViewfromEuler2(0,(float)angiterp,0);
			if(xaxis==0 && yaxis==0 && zaxis==1) volrender.setViewfromEuler2(0,0,(float)angiterp);
			if(xaxis==1 && yaxis==1 && zaxis==0) volrender.setViewfromEuler2((float)angiterp,(float)angiterp,0);
			if(xaxis==1 && yaxis==0 && zaxis==1) volrender.setViewfromEuler2((float)angiterp,0,(float)angiterp);
			if(xaxis==0 && yaxis==1 && zaxis==1) volrender.setViewfromEuler2(0,(float)angiterp,(float)angiterp);
			if(xaxis==1 && yaxis==1 && zaxis==1) volrender.setViewfromEuler2((float)angiterp,(float)angiterp,(float)angiterp);
		}		
			//move our clipping plane
			mousepos.y = i;
			volrender.cutting_planes.mouseMove(mousepos);

			//save the current frame
			QString filename = dn + "//";
			QString extension = ".png";
			QString framenumber;		
			framenumber.setNum(framecount+100000);
			filename += framenumber;
			filename += extension;
			
			makeCurrent();
			redraw_event();
			updateOverlayGL();
			if(!preview)
			{
				QImage im = volrender.render_framebuffer(false);
				QPixmap pm;
				pm.convertFromImage(im);
				im.reset();
				if(!pm.isNull()) pm.save(filename, "PNG");	
			}

			//update our frame counter
			framecount = framecount + 1;
			
			progressbar->setProgress(framecount);
			qApp->processEvents();
			if (progressbar->wasCancelled())
			{
				Vector v1, v2, v3, v4;
				v1 = Vector(-1.0,  1.0,  1.0);
				v2 = Vector( 1.0,  1.0,  1.0);
				v3 = Vector(-1.0, -1.0,  1.0);
				v4 = Vector( 1.0, -1.0,  1.0);
				v1 *= clipdimensions/2.0;
				v2 *= clipdimensions/2.0;
				v3 *= clipdimensions/2.0;
				v4 *= clipdimensions/2.0;
				volrender.cutting_planes.planes[clipplane_selected] = PlaneWidget(v1,v2,v4,v3,1);

				volrender.setViewfromEuler2(0,0,0);
				//volrender.cutting_planes.select(-1);
				volrender.cutting_planes.reset_all();
				planes_toggle = 0;
				redraw_event();
				updateOverlayGL();
				volrender.cutting_planes.moviemode = 0;
				return;
			}

			angiterp += anglestepper;
	}

	delete progressbar;

	volrender.cutting_planes.moviemode = 0;

	//volrender.cutting_planes.select(-1);
	volrender.cutting_planes.reset_all();
	planes_toggle = 0;
	redraw_event();
	updateOverlayGL();	
}
