#ifndef QTGLWIDGET_H
#define QTGLWIDGET_H

#define ISOSURFACE 0
#define	DEGTORAD(x)	( ((x) * PI) / 180.0 )
#define	RADTODEG(x)	( ((x) * 180.0) / PI )
#define PI 	3.141592653589793238462643383279f

#include <qapplication.h>
#include <qgl.h>
#include <qdatetime.h>
#include <qcolordialog.h>
#include <qevent.h>
#include <qsizepolicy.h>
#include <qtimer.h>
#include <QKeyEvent>
#include <QDragEnterEvent>
#include <QDropEvent>
#include <QMouseEvent>
#include <QPainter>

#include <q3filedialog.h>
#include <q3progressdialog.h>
#include <q3dragobject.h>

#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <iostream>

#include "Global.h"
#include "Vector.h"
#include "MarchingCubes.h"
#include "ColourFun.h"
#include "ArcBall.h"
#include "Filter.h"
#include "PCA.h"
#include "Camera.h"
#include "VolumeRender.h"
#include "VolumeObject.h"
#include "VolIO.h"
#include "BSpline.h"
#include "Floodfill.h"
#include "Edge.h"

static int timer_interval = 1;			// timer interval (millisec)

enum {R, G, B, A};
enum {OBJ_ANGLE, CUTTING, OBJ_ZOOM, OBJ_TRANSLATE, OBJ_ARB2DPLANE}; 

class QtGLWidget : public QGLWidget
{
    Q_OBJECT

public:

	int argc_mode;
	int render;

	unsigned int* depthimgdata;

	//global mouse position
	Vector global_mousepos;
	Vector mouspos;
	float dx, dy;
	float dw;
	int tempx,tempy;
	int stopped;

	QFont serifFontBG;
	QFont serifFont;
	QFont serifFontLabel;

	//volume object and utilitisourceobjectes
	VolumeObject	volobject;
	VolumeRender	volrender;
	VolIO			volio;

	//our marching cubes class
	MCubes mcubes;

	QString movie_dir;
	QString currentworkingdir;
	
	QDialog* labeller_dialogue;
	int labellermax;
	QLabel* labellermax_lb;
	QSlider* labellermax_slider;
	int labellermin;
	QLabel* labellermin_lb;
	QSlider* labellermin_slider;

	//toggle plane
	int planes_toggle;

	QApplication* app;
	int active;

	Q3ProgressDialog*		pb;

	//-----------------------------------------------
    QtGLWidget( QWidget* parent, const char* name, const QGLWidget* shareWidget=0 );
    QtGLWidget( const QGLFormat& format, QWidget* parent, const char* name, 
	   const QGLWidget* shareWidget=0 );
    ~QtGLWidget();

	void		set_app(QApplication* app);
	void		initvariables();
	
	//RENDERING STUFF	
	void		initializeGL();
	void		paintGL();
    void		resizeGL( int w, int h );

	//VOLUME UTILITY FUNCTIONS (CPU based)
	void		crop(void);
	void		recentre(void);
	void		invcrop(void);
	void		realign(void);
    void		gaussian( int size, float sigma);
	void 		unsharp_slot(int size, float sigma, int bright, int cont);
	void		sobel(void);
	void		transfer_function( vector<Vector> cp, float size,  float border, int mode);
	void		make_binary(void);
	void		make_filter(void);
	void		make_vertfinder(void);

protected:

    //USER INTERACTION EVENTS
	void		keyPressEvent	(QKeyEvent * ); 
	void		keyReleaseEvent (QKeyEvent * );
	void		mouseMoveEvent  (QMouseEvent * e);
	void		mousePressEvent (QMouseEvent * e);
	void		mouseReleaseEvent(QMouseEvent * e);
	void		mouseDoubleClickEvent(QMouseEvent * e);
	void		wheelEvent(QWheelEvent *event);
	void		dragEnterEvent(QDragEnterEvent* event);
	void		dropEvent(QDropEvent* event);
	void		processDepthClickCrop(int x, int y, int mode);
	void		processDepthClick(int x, int y, int mode);
	void		processClick(int x, int y, int mode);
	bool		processClickOnSelectedPlane(int x, int y);
	bool		processClickOnAnyPlane(int x, int y);
	
public slots:

	//clipping plane editor slots
	void		cutplane_select_slot(int selected);
	void		cutplane_invert_slot(int selected);
	void		cutplane_load_slot(QString fn);
	void		cutplane_save_slot(QString fn);
	void		cutplane_showall_slot(int selected);
	void		cutplane_resetall_slot(void);
	void		cutplane_resetcurrent_slot(void);
	void 		cutplane_recentre_slot(void);
	void		cutplane_crop_slot(void);
	void 		cutplane_realign_slot(void);
	void		cutplane_invcrop_slot(void);
	void		cutplane_redclip_slot(void);
	void		cutplane_greenclip_slot(void);
	void		cutplane_blueclip_slot(void);
	void		cutplane_isoclip_slot(void);
	void 		cutplane_applyall_drawmode_slot(void);
	void 		cutplane_interact_clicked_slot(int);
	void 		cutplane_unselect_slot(void);
	void 		cutplane_selected_slot(int);
	void 		cutplane_planeslider_slot(float dist);
	void 		cutplane_planerot1_slot(float ang);
	void 		cutplane_planerot2_slot(float ang);
	void 		cutplane_rendermode_slot(int);
	void 		cutplane_interact(float dy);
	void		cutplane_solid_slot(bool on);

	//render settings widget
	void		rendersettings_framebuffer_lod_slot(int);
	void 		rendersettings_framebuffer_slot(int);
	void 		rendersettings_postprocess_slot(int);
	void 		rendersettings_silhouettes_slot(int);
	void 		rendersettings_numbslices_slot(int);
	void 		rendersettings_numbsliceslod_slot(int s);
	void 		rendersettings_numbsliceslodtoggle_slot(int);
	void 		rendersettings_framebuffertoggle_slot(int);
	void 		rendersettings_postprocesstoggle_slot(int);
	void 		rendersettings_maxtexturesize_slot(int);
	void 		rendersettings_renderquality_slot(float);
	void 		rendersettings_renderqualitylod_slot(float);
	void 		rendersettings_channelmode_slot(int r,int g,int b,int i);

	//isosurface editor
	void		isosurface_new_slot(QString name, int quality, int value, int smooth, Vector col, bool* channels, int clpstate);
	void		isosurface_get_slot(QString name, int* quality, int* value, int* smooth, Vector* col, int* nv, int* nf, int* clpstate);
	void		isosurface_del_slot(QString name);
	void		isosurface_update_slot(QString oldname, QString name, int quality, int value, int smooth, Vector col, bool* channels, int clpst);
	void		isosurface_load_slot(QString fn);
	void		isosurface_save_slot(void);
	void		isosurface_crop_slot(int selected);

	//crop widget
	void crop_start_slot(void);
	void crop_end_slot(void);
	void crop_invsel_slot(int);
	void crop_reset_slot(void);

	//measure widget
	void		measure_start_slot(void);
	void 		measure_stop_slot(void);
	void 		measure_pause_slot(void);
	void 		measure_edit_slot(void);
	void		measure_load_item_slot(vector< Vector > pnts, vector< Edge > edges, int draw_mode);
	void 		measure_add_item_slot(vector< Vector > pnts, int draw_mode);
	void 		measure_update_item_slot(int index, vector< Vector > pnts, int draw_mode);
	void 		measure_update_current_verts_slot(vector<Vector> pnts);
	void 		measure_delete_item_slot(int index);
	void 		measure_update_current_slot(int index);
	void 		measure_update_current_drawmode_slot(int drawmode);
	void 		measure_selected_vertindex_slot(int index);
	void 		measure_eval_triangles_slot(int index);
	void 		measure_evalcurrent_triangles_slot(void);
	void 		measure_setcutplane_slot(int, float, float, float);
	void		measure_clearall_slot(void);
	void		measure_cancel_slot(void);
	void		measure_rmv_current_verts_slot(int);
	void		measure_rebuild_current_edges(void);
	void		measure_update_visible_slot(int, bool);

	void		measure_labellermin_slot(int);
	void		measure_labellermax_slot(int);
	void		measure_labellerokbutton_event(void);
	void		measure_labellercancbutton_event(void);
	void		measure_labellerdialogue_event(void);

	void		measure_modify_start_slot(void);
	void		measure_modify_stop_slot(void);
	void		measure_modify_zoomcurrent(float zoom);
	void		measure_modify_rotatecurrent(int mode, float angle);
	void		measure_labels_slot(int, int, int);

	//lighting
	void		light_altitude_slot(float);
	void 		light_azimuth_slot(float);
	void 		light_colour_slot(Vector, Vector, Vector);
	void 		light_volshader_slot(int);
	void 		light_gooch_lighting_slot(Vector, Vector, int, int, int, int);

	//stereo
	void 		stereo_onoff_slot(int);
	void 		stereo_rendermode_slot(int);
	void 		stereo_seperation_slot(float);

	//filter
	void		filter_slot(int filter_type, int size, double sigma, int dim, vector<bool> channels);
	
	//movie editor slots
	void		movie_orthosectmovie_slot(QWidget* parent, int sampling, int preview, QString dn);
	void		movie_rockmovie_slot(QWidget* parent, int sampling, int preview, QString dn, float ang);
	void		movie_rotmovie_slot(QWidget* parent, int sampling, int preview, QString dn, int x, int y, int z, float ang);
	void		movie_crossfademovie_slot(QWidget* parent, int sampling, int preview, QString dn, int x, int y, int z, float ang, int ch1, int ch2, int ch3);
	void		movie_fademovie_slot(QWidget* parent, int sampling, int preview, QString dn, int x, int y, int z, float ang, int ch1, int ch2, int ch3);
	void		movie_clipmovie_slot(QWidget* parent, int sampling, int preview, QString dn, int x, int y, int z, float ang, int clipmode, int clipafterrot);

	//sliceframe slots
	void 		sliceframe_pixelXY_slot(int x, int y, int z, int r, int g, int b, int mouse_x,int mouse_y, int width, int height);
	void 		sliceframe_pixelXZ_slot(int x, int y, int z, int r, int g, int b, int mouse_x,int mouse_y, int width, int height);
	void 		sliceframe_pixelYZ_slot(int x, int y, int z, int r, int g, int b, int mouse_x,int mouse_y, int width, int height);
	void		sliceframe_updatepixel(void);

	//general slots
	void		redraw_event(void);
		
	//tfunc editor slots
	void		tfunc_rebuild_histogram_slot(void);
	void		tfunc_histequ_slot(int mode, int togglestate);
	void		tfunc_contstrat_slot(int mode, int togglestate);
	void		tfunc_brightcontrast_shader_slot(int mode, int bright, int cont);
	void		tfunc_threshold_shader_slot(int mode, int tmin, int tmax);
	void		tfunc_invert_slot(int mode, int togglestate);
	void		tfunc_slider_released_slot(void);
	void		tfunc_histoupdate_slot(int toggle);	
	void		tfunc_collapse_slot(void);	

	void		tfunc_convertR_slot(void);
	void		tfunc_convertG_slot(void);
	void		tfunc_convertB_slot(void);

//	void 		tfunc_remap16bit_slot(int min, int max, const vector<Vector>& tfunc_curvepts);	
	void		tfunc_remap16bit_slot(int min_l, int max_l, const vector<Vector>& tfunc_curvepts_luminance, int min_o, int max_o, const vector<Vector>& tfunc_curvepts_opacity);

	//hist
	void		hist_tfunc_slot(const vector<Vector>& cp, float graphsize, float border, int mode, int slice_toggle);	
	void		hist_transfer_function_all_slot(const vector<Vector>& r_tfunc_curvepts,  const vector<Vector>& g_tfunc_curvepts,  const vector<Vector>& b_tfunc_curvepts, 
										   const vector<Vector>& ra_tfunc_curvepts, const vector<Vector>& ga_tfunc_curvepts, const vector<Vector>& ba_tfunc_curvepts,
										   float graphsize, float border);
	void		hist_reset_transfer_function_parameters_slot(int _r_tmax, int _r_tmin, int _g_tmax, int _g_tmin, int _b_tmax, int _b_tmin, int _ra_tmax, int _ra_tmin, int _ga_tmax, int _ga_tmin, int _ba_tmax, int _ba_tmin,
													    int _r_bright, int _r_cont, int _g_bright, int _g_cont, int _b_bright, int _b_cont, int _ra_bright, int _ra_cont, int _ga_bright, int _ga_cont, int _ba_bright, int _ba_cont,
													    bool _inv_r,	bool _inv_g, bool _inv_b, bool _inv_ra, bool _inv_ga, bool _inv_ba);
	
	void hist_tfunc16bit_slot(const vector<Vector>& controlpnts, float graphsize, float border, int mode, int slice_toggle);
		
	//==================================================================================================================================
	
	void		setcurrentworkingdir_slot(QString dn);
	void		brightcontrast_slot(int b, int c);
	void		thresholdmin_slot(int);
	void		thresholdmax_slot(int);
    void		threshold_slot( int min, int max);
	
signals:
	void		update_channels_signal(void);
	void		updatestatus_cursor_signal(void);

	void		measure_currentverts_signal(vector<Vector> verts);
	void		measure_currentedges_signal(vector<Edge> edges);
	void		measure_point_signal(Vector v);
	void		measure_editpoint_signal(Vector v);
	void		measure_editpoint_select_signal(int sel);
	void		measure_savecutplane_signal(int, float, float, float);
	void		measure_close_signal(void);
	void		measure_clearcurrent_signal(void);
	void		measure_edges_signal(vector<Edge> edges);
	void		measure_update_edges_signal(int index, vector<Edge> edges);
	void		measure_editgrppoint_signal(int i, Vector v);

	void		tfunc_16bit_histogram_signal(double* histo16,double* histo8);

	void		arc_mode_signal(void);
	void		frames_redraw_signal(void);
	void		single_channel_signal(void);
 
	void		dragndrop_signal(QString filename);
	void		openImageDir_signal(QString dirname);

	void		cutplane_enableplanepanel_signal();
	void		cutplane_selected_signal(int index,int drawmode);
	void		cutplane_selectedupdate_signal(int index, int drawmode);
	void		cutplane_planeslider_signal(int val);
	void		cutplane_unselect_signal(void);
	
	void		tfunc_histogram_signal(double*);
	
	void		isosurface_addnew_signal(QString name, Vector col);
	
	void 		save_sectionimage_signal(QString fn, int axis, int index);

	void		timelapseEvent(void); 
};

#endif // QTGLWIDGET_H

