#define max(a,b) (((a)>(b))?(a):(b)) 

#include "QtHistogram.h"
//Added by qt3to4:
#include <QPaintEvent>
#include <QResizeEvent>
#include <Q3Frame>
#include <QPixmap>
#include <QLabel>
#include <QMouseEvent>
#include <QEvent>

QtHistogram::QtHistogram(QWidget* parent, const char* name, float size): QLabel( parent, name )
{
	currentworkingdir="";
	is16bitdata = false;
	
	max_histogram = 0;
	data=NULL;
	
	hist_enable=1;
	cumfreq_enable=0;
	tfunc_enable=1;
	maxthr=minthr=0;

	logscale=0;

//	if(width()<height()) size = width();
//		else size = height();

	graph_size = size;
	canvas_size = size*1.25;
	border = (canvas_size-graph_size)/2.0;

	setFrameStyle(QFrame::Panel | QFrame::Sunken);
	setAlignment(Qt::AlignCenter);
	setMouseTracking(true);
	setScaledContents(true);

	/*QSizePolicy sizepolicy;
//	sizepolicy.setHeightForWidth(true);
	sizepolicy.setVerticalPolicy(QSizePolicy::Expanding);
	sizepolicy.setHorizontalPolicy(QSizePolicy::Expanding);
	setSizePolicy(sizepolicy);*/

	//resize(256,256);
	//setSizePolicy(QSizePolicy(QSizePolicy::Expanding, QSizePolicy::Expanding));

	//brightness & contrast
	l_bright =
	l_cont =
	la_bright =
	la_cont =
	r_bright =
	r_cont =
	g_bright =
	g_cont =
	b_bright =
	b_cont =
	ra_bright =
	ra_cont =
	ga_bright =
	ga_cont =
	ba_bright =
	ba_cont = 100;

	//threshold
	l_tmin =
	la_tmin =
	r_tmin =
	g_tmin =
	b_tmin = 
	ra_tmin =
	ga_tmin =
	ba_tmin = 0;
	l_tmax =
	la_tmax =
	r_tmax =
	g_tmax =
	b_tmax =
	ra_tmax =
	ga_tmax =
	ba_tmax = 255;

	//invert
	inv_l=
	inv_la=
	inv_r=
	inv_g=
	inv_b=
	inv_ra=
	inv_ga=
	inv_ba=false;

	slice_toggle = 0;
	create();
	
}

QtHistogram::~QtHistogram()
{
	data=NULL;
}
void QtHistogram::reset(void)
{
	max_histogram = 0;
	
	hist_enable=1;
	cumfreq_enable=0;
	tfunc_enable=1;
	maxthr=minthr=0;

	fe_r.reset();
	fe_g.reset();
	fe_b.reset();
	fe_ra.reset();
	fe_ga.reset();
	fe_ba.reset();
	fe_l.reset();
	fe_la.reset();

	//brightness & contrast
	l_bright =
	l_cont =
	la_bright =
	la_cont =
	r_bright =
	r_cont =
	g_bright =
	g_cont =
	b_bright =
	b_cont =
	ra_bright =
	ra_cont =
	ga_bright =
	ga_cont =
	ba_bright =
	ba_cont = 100;

	//threshold
	l_tmin =
	la_tmin =
	r_tmin =
	g_tmin =
	b_tmin = 
	ra_tmin =
	ga_tmin =
	ba_tmin = 0;
	l_tmax =
	la_tmax =
	r_tmax =
	g_tmax =
	b_tmax =
	ra_tmax =
	ga_tmax =
	ba_tmax = 255;

	//invert
	inv_l=
	inv_la=
	inv_r=
	inv_g=
	inv_b=
	inv_ra=
	inv_ga=
	inv_ba=false;

	for(int i=0; i<256; i++) data[i]=0;
}
void QtHistogram::reload_transfer_function_parameters(void)
{
	emit hist_reset_transfer_function_parameters_signal(r_tmin, r_tmax, g_tmin, g_tmax, b_tmin, b_tmax, ra_tmin, ra_tmax, ga_tmin, ga_tmax, ba_tmin, ba_tmax,
													   r_bright, r_cont, g_bright, g_cont, b_bright, b_cont, ra_bright, ra_cont, ga_bright, ga_cont, ba_bright, ba_cont,
													   inv_r, inv_g, inv_b, inv_ra, inv_ga, inv_ba);
}
void QtHistogram::reset_transfer_function_parameters(void)
{
	//if we are in intensity mode, then set all othe
	//parameters to that of L & I
	if(fe_seleted==1)
	{
		printf("l_cont: %d\n", l_cont);

		r_bright = g_bright = b_bright = l_bright;
		r_cont = g_cont = b_cont = l_cont;
		r_tmin = g_tmin = b_tmin = l_tmin;
		r_tmax = g_tmax = b_tmax = l_tmax;
		inv_r= inv_g= inv_b= inv_l;
	}
	if(fe_seleted==2)
	{
		ra_bright =	ga_bright =	ba_bright = la_bright;
		ra_cont = ga_cont =	ba_cont = la_cont;
		ra_tmin = ga_tmin =	ba_tmin = la_tmin;
		ra_tmax = ga_tmax =	ba_tmax = la_tmax;
		inv_ra = inv_ga = inv_ba= inv_la;
	}
	
	reload_transfer_function_parameters();

	emit hist_reset_transfer_function_parameters_signal(r_tmin, r_tmax, g_tmin, g_tmax, b_tmin, b_tmax, ra_tmin, ra_tmax, ga_tmin, ga_tmax, ba_tmin, ba_tmax,
													   r_bright, r_cont, g_bright, g_cont, b_bright, b_cont, ra_bright, ra_cont, ga_bright, ga_cont, ba_bright, ba_cont,
													   inv_r, inv_g, inv_b, inv_ra, inv_ga, inv_ba);

	emit hist_transfer_function_all_signal(fe_r.bs.curve_points, fe_g.bs.curve_points, fe_b.bs.curve_points, fe_ra.bs.curve_points, fe_ga.bs.curve_points, fe_ba.bs.curve_points, graph_size, 0);

	//emit_tfunc_current();
}
void QtHistogram::reset_l(void)
{
	max_histogram = 0;
	
	hist_enable=1;
	cumfreq_enable=0;
	tfunc_enable=1;
	maxthr=minthr=0;

	fe_l.reset();
	fe_r.reset();
	fe_g.reset();
	fe_b.reset();

	//brightness & contrast
	r_bright = g_bright = b_bright = l_bright =
	r_cont = g_cont = b_cont = l_cont = 100;

	//threshold
	r_tmin = g_tmin = b_tmin = l_tmin = 0;
	r_tmax = g_tmax = b_tmax = l_tmax = 255;

	//invert
	inv_r = inv_g = inv_b = inv_l = false;
}
void QtHistogram::reset_la(void)
{
	max_histogram = 0;
	
	hist_enable=1;
	cumfreq_enable=0;
	tfunc_enable=1;
	maxthr=minthr=0;

	fe_la.reset();
	fe_ra.reset();
	fe_ga.reset();
	fe_ba.reset();

	//brightness & contrast
	ra_bright = g_bright = b_bright = l_bright =
	ra_cont = g_cont = b_cont = l_cont = 100;

	//threshold
	ra_tmin = ga_tmin = ba_tmin = la_tmin = 0;
	ra_tmax = ga_tmax = ba_tmax = la_tmax = 255;

	//invert
	inv_ra = inv_ga = inv_ba = inv_la = false;

}
void QtHistogram::reset_r(void)
{
	max_histogram = 0;
	
	hist_enable=1;
	cumfreq_enable=0;
	tfunc_enable=1;
	maxthr=minthr=0;

	fe_r.reset();

	//brightness & contrast
	r_bright =
	r_cont = 100;

	//threshold
	r_tmin = 0;
	r_tmax = 255;

	//invert
	inv_r = false;
}
void QtHistogram::reset_g(void)
{
	max_histogram = 0;
	
	hist_enable=1;
	cumfreq_enable=0;
	tfunc_enable=1;
	maxthr=minthr=0;

	fe_g.reset();

	//brightness & contrast
	g_bright =
	g_cont = 100;

	//threshold
	g_tmin = 0;
	g_tmax = 255;

	//invert
	inv_g=false;
}
void QtHistogram::reset_b(void)
{
	max_histogram = 0;
	
	hist_enable=1;
	cumfreq_enable=0;
	tfunc_enable=1;
	maxthr=minthr=0;

	fe_b.reset();

	//brightness & contrast
	b_bright =
	b_cont = 100;

	//threshold
	b_tmin = 0;
	b_tmax = 255;

	//invert
	inv_b= false;
}
void QtHistogram::reset_ra(void)
{
	max_histogram = 0;
	
	hist_enable=1;
	cumfreq_enable=0;
	tfunc_enable=1;
	maxthr=minthr=0;

	fe_ra.reset();

	//brightness & contrast
	ra_bright =
	ra_cont = 100;

	//threshold
	ra_tmin = 0;
	ra_tmax = 255;

	//invert
	inv_ra = false; 
}
void QtHistogram::reset_ga(void)
{
	max_histogram = 0;
	
	hist_enable=1;
	cumfreq_enable=0;
	tfunc_enable=1;
	maxthr=minthr=0;

	fe_ga.reset();

	//brightness & contrast
	ga_bright =
	ga_cont = 100;

	//threshold
	ga_tmin = 0;
	ga_tmax = 255;

	//invert
	inv_ga = false;
}
void QtHistogram::reset_ba(void)
{
	max_histogram = 0;
	
	hist_enable=1;
	cumfreq_enable=0;
	tfunc_enable=1;
	maxthr=minthr=0;

	fe_ba.reset();

	//brightness & contrast
	ba_bright =
	ba_cont = 100;

	//threshold
	ba_tmin = 0;
	ba_tmax = 255;

	//invert
	inv_ba = false; 
}

void QtHistogram::create(void)
{
/*    setFrameStyle( Q3Frame::Panel );
	setLineWidth( 2 );
	setAlignment( Qt::AlignCenter );
	setMargin(0);
	setScaledContents(TRUE);
 */
	//printf("graph_size: %d\n", (int)graph_size);


	fe_l.init(graph_size, 0, 10);
	fe_la.init(graph_size, 0, 10);
	fe_r.init(graph_size, 0, 10);
	fe_g.init(graph_size, 0, 10);
	fe_b.init(graph_size, 0, 10);
	fe_ra.init(graph_size, 0, 10);
	fe_ga.init(graph_size, 0, 10);
	fe_ba.init(graph_size, 0, 10);
}
void QtHistogram::set_transfer_mode(int mode)
{
	fe_seleted=mode;
	//draw_transfer();
}


void QtHistogram::draw_functioneditoronpixmap(QPainter* p, FunctionEditor* func, QColor col)
{
	//Input image map
	/*
	QImage strip_img = QImage(255, 10, QImage::Format_RGB32);
	for(int i=0; i<strip_img.width(); i++)
	{
		for(int j=0; j<strip_img.height(); j++)
		{
			strip_img.setPixel(i, j, qRgb(i,i,i));
		}
	}
	p->drawImage(QRectF(0,-border*0.5,255, 10), strip_img);
	*/
/*
	QImage strip_img = QImage(255, 10, QImage::Format_RGB32);
	for(int i=0; i<strip_img.width(); i++)
	{
		for(int j=0; j<strip_img.height(); j++)
		{
			int p = 256-(float)func->bs.curve_points[i].y;

			QColor c = QColor(p,p,p);
			c.setRed(c.red() * (col.red()/255.0));
			c.setGreen(c.green() * (col.green()/255.0));
			c.setBlue(c.blue() * (col.blue()/255.0));

			strip_img.setPixel(i, j, qRgb(c.red(), c.green(), c.blue()));
		}
	}
	p->drawImage(QRectF(0,-border*0.5,255, 10), strip_img);
	//p->drawImage(QRectF(255+border*0.125,0,10, 255), strip_img);
*/
	if(col==QColor(Qt::white))
	{
		col=QColor(Qt::darkGray);
	}
	//draw our control points line
	QPainterPath cplinepath;
	cplinepath.moveTo(func->bs.control_points[0].x, func->bs.control_points[0].y);
	for(int i=0; i<func->bs.control_points.size(); i++)
	{		 
		cplinepath.lineTo(func->bs.control_points[i].x, func->bs.control_points[i].y);		
	}
	p->setPen( QPen(col, 1, Qt::DashLine, Qt::FlatCap, Qt::RoundJoin) );
	p->drawPath(cplinepath);
	
	//draw our control points
	QPainterPath cppath;
	cppath.moveTo(func->bs.control_points[0].x, func->bs.control_points[0].y);
	for(int i=0; i<func->bs.control_points.size(); i++)
	{	
		cppath.moveTo(func->bs.control_points[i].x, func->bs.control_points[i].y);
		//cppath.addRect( func->bs.control_points[i].x-2.5, func->bs.control_points[i].y-2.5, 5, 5);
	}
	p->setBrush(col);
	p->setPen( QPen(Qt::black, 1, Qt::SolidLine, Qt::FlatCap, Qt::RoundJoin) );
	p->drawPath(cppath);
	p->setBrush(Qt::NoBrush);

	for(int i=0; i<func->bs.control_points.size(); i++)
	{
		QColor c = col;
/*			QColor(255-func->bs.control_points_colours[i].x, 255-func->bs.control_points_colours[i].y, 255-func->bs.control_points_colours[i].z);
		c.setRed(c.red() * (col.red()/255.0));
		c.setGreen(c.green() * (col.green()/255.0));
		c.setBlue(c.blue() * (col.blue()/255.0));
*/		
		p->setBrush(c);
		p->setPen(c);
		p->drawRect(func->bs.control_points[i].x-2.5, func->bs.control_points[i].y-2.5, 5, 5);
	}
	p->setBrush(col);
	p->setPen( QPen(Qt::black, 1, Qt::SolidLine, Qt::FlatCap, Qt::RoundJoin) );
	p->setBrush(Qt::NoBrush);

	//if(i==func->selected)

	if(func->delete_event==1)
	{
		p->setPen(Qt::yellow);
		p->drawRect( func->v.x-2.5, func->v.y-2.5, 5, 5);		
	}

	//draw our curve as line segments
	QPainterPath curvepath;
	curvepath.moveTo(func->bs.curve_points[0].x, func->bs.curve_points[0].y);
	for(int ij=0; ij<func->bs.curve_points.size(); ij++)
	{		 
		curvepath.lineTo(func->bs.curve_points[ij].x, func->bs.curve_points[ij].y);
	}

	//printf("%f\n", func->bs.curve_points[0].y);

	p->setPen( QPen(Qt::black, 1, Qt::SolidLine, Qt::RoundCap, Qt::RoundJoin) );
	p->drawPath(curvepath);
}

void QtHistogram::draw_functioneditor(QPainter* p)
{
	//draw our histogram
	draw_histogram(p);

	if(tfunc_enable)
	{
		if(fe_seleted==1)
		{
			draw_functioneditoronpixmap(p, &fe_l, Qt::white);
		}
		else if(fe_seleted==2)
		{
			draw_functioneditoronpixmap(p, &fe_la, Qt::white);
		}
		else if(fe_seleted==3)
		{
			draw_functioneditoronpixmap(p, &fe_r, Qt::red);
		}
		else if(fe_seleted==4)
		{
			draw_functioneditoronpixmap(p, &fe_g, Qt::green);
		}
		else if(fe_seleted==5)
		{
			draw_functioneditoronpixmap(p, &fe_b, Qt::blue);
		}
		else if(fe_seleted==6)
		{
			draw_functioneditoronpixmap(p, &fe_ra, Qt::red);
		}
		else if(fe_seleted==7)
		{
			draw_functioneditoronpixmap(p, &fe_ga, Qt::green);
		}
		else if(fe_seleted==8)
		{
			draw_functioneditoronpixmap(p, &fe_ba, Qt::blue);
		}	
	}
}


void QtHistogram::draw_histogram(QPainter* p)
{	
	//find the max value in our histogram
	max_histogram=0;
	float max_loghisto =0;
	float min_loghisto = log(1024.0*1024.0*1024.0);
	for(int iii=1; iii<255; iii++) 
	{
		max_histogram = max(max_histogram, data[iii]);
		if(data[iii]!=0)
		{
			max_loghisto = max((float)max_loghisto, (float)log(data[iii]));
			min_loghisto= min((float)min_loghisto, (float)log(data[iii]));
		}
		//printf("%d\n", data[iii]);
	}

	//draw a background rect
	p->setPen(Qt::NoPen);

	p->setBrush(Qt::white);
	p->drawRect(0,0,graph_size-1, graph_size-1);

	//reset our painter's brush
	p->setBrush(Qt::NoBrush);

	//draw a grid
	p->setPen(Qt::black);
	QFont serifFont("Arial", 6, QFont::Bold);
	p->setFont(serifFont);
	float grid_steps = (graph_size-1)/8.0;
		
	float grid_step=0;
	float loggrid_step=0;
	float logrid_stepincr=max_histogram/8.0;

	QString label;
	for(int ii=0; ii<9; ii++)
	{
		//linear scale
		if(logscale==0)
		{
			//x,y grid lines
			p->drawLine(grid_step, 0, grid_step, graph_size-1+border*0.25);
			p->drawLine(-border*0.25, grid_step, graph_size-1, grid_step);

			//x,y labels
			label.setNum((int)(grid_step),10);
			p->drawText( QRectF(grid_step-grid_steps/2.0, graph_size-1+border*0.4, grid_steps, 8), Qt::AlignCenter, label);
			p->drawText( QRectF(-border, graph_size-1-grid_step-4, grid_steps, 8), Qt::AlignCenter, label);
		}
		else
		{	
			//x,y grid lines

			//Y AXIS LINES
			p->drawLine(grid_step, 0, grid_step, graph_size+border*0.25);
			label.setNum((int)(grid_step),10);
			p->drawText( QRectF(grid_step-grid_steps/2.0, graph_size-1+border*0.4, grid_steps, 8), Qt::AlignCenter, label);

			p->drawText( QRectF(-border, graph_size-1-grid_step-4, grid_steps, 8), Qt::AlignCenter, label);
			p->drawLine(-border*0.25, grid_step, graph_size-1, grid_step);
			/*//X AXIS LINES
			double height;
			int i;
			float iterp=0;

			if(grid_step!=0) iterp = (double)(log(loggrid_step)-min_loghisto)/(double)(max_loghisto-min_loghisto);
			else iterp = 0;

			if(iterp>1.0) iterp=1.0;
			if(iterp<0.0) iterp=0.0;

			height = (graph_size)*iterp;
			height = (int)(height+0.5);

			p->drawLine(-border*0.25, height, graph_size, height);
						
			label.setNum((int)loggrid_step,10);

			p->drawText( QRectF(-border, graph_size-height-4, logrid_stepincr, 8), Qt::AlignCenter, label);*/
		}
//		p->drawRect(QRectF(grid_step-grid_steps/2.0, graph_size+border*0.4, grid_steps, 8));
//		p->drawRect(QRectF(-border, graph_size-grid_step-4, grid_steps, 8));

		grid_step+=grid_steps;
		//loggrid_step+=logrid_stepincr;
	}

	if(hist_enable==1)
	{
		//dray our histogram bars
		//editor->fe_seleted
		// 1 = RGB// 2 = RGBA// 3 = R// 4 = G// 5 = B// 6 = A
		p->setBrush(Qt::NoBrush);
		p->setPen(Qt::NoPen);

		if(fe_seleted==1) p->setBrush( QColor(32,32,32, 255) );
		else if(fe_seleted==2) p->setBrush( QColor(64,64,64, 255) );
		else if(fe_seleted==3) p->setBrush( QColor(255,0,0, 255) );
		else if(fe_seleted==4) p->setBrush( QColor(0,200,0, 255) );
		else if(fe_seleted==5) p->setBrush( QColor(0,0,255, 255) );
		else if(fe_seleted==6) p->setBrush( QColor(100,0,0, 255) );
		else if(fe_seleted==7) p->setBrush( QColor(0,100,0, 255) );
		else if(fe_seleted==8) p->setBrush( QColor(0,0,100, 255) );
		
		double height;
		int i;
		float xpos=0.0;
	
		//QPolygonF polygon;
		float iterp=0;

		if(max_histogram==0) max_histogram=1;

		for(i=0 ; i<256; i++)
		{
			//linear scale
			if(logscale==0) iterp = ((double)data[i]/(double)max_histogram);
			else
			{
				if(data[i]!=0) iterp = (double)(log(data[i])-min_loghisto)/(double)(max_loghisto-min_loghisto);
				else iterp = 0;
			}

//			printf("data[i]: %f\n", (float)data[i]);
//			printf("max_histogram: %f\n", (float)max_histogram);
//			printf("LOGdata[i]: %f\n", (float)log(data[i]));
//			printf("max_loghisto: %f\n", (float)max_loghisto);
//			printf("min_loghisto: %f\n", (float)min_loghisto);
//			printf("iterp: %f\n", (float)iterp);

			if(iterp>1.0) iterp=1.0;
			if(iterp<0.0) iterp=0.0;

			height = (graph_size)*iterp;
			height = (int)(height+0.5);
			
			//printf("%f\n", (float)height);
			//if(height>graph_size) height=graph_size;
			//if(height<0.0) height=0.0;
			//if(i==0) height=0.0;
			//if(i==255) height=0.0;

			xpos = i;

			//polygon << QPointF(xpos, graph_size-height) ;
			QRectF rectangle((float)xpos-0.5, graph_size, 1.0, -height);
			p->drawRect(rectangle);

			//p->drawRoundRect(rectangle, 25, 25);

			//p->drawRect(xpos, 0.0, 1.0, 128);
			//p->drawLine(xpos, graph_size, xpos, graph_size-height);
		}

		//p->drawPolygon(polygon, Qt::OddEvenFill);
	}
	if(cumfreq_enable==1)
	{
		//draw our cummulatative frequency
		//dray our histogram bars
		double sum =0;
		double maxsum =0;
		double height;
		for(int i=0 ; i<256; i++)
		{
			maxsum += data[i];
		}

		if(maxsum)
		{
			QPainterPath cumpath;
			cumpath.moveTo(0,0);
			for(int i=0 ; i<256; i++)
			{
				sum += data[i];
				height = (graph_size)*(((double)sum/(double)maxsum));
				height = 255-(int)(height+0.5);
				cumpath.lineTo (i, height );
			}
			p->setPen(Qt::red);
			p->setBrush(Qt::NoBrush);

			//p->setBrush(Qt::red);
			p->drawPath(cumpath);
		}
	}

	//draw our thresholding...
	if(fe_seleted==1)
	{
		p->setPen(Qt::black);
		p->setBrush(QBrush ( QColor(128,128,128,128), Qt::SolidPattern ));
		QRectF rectangle(0.0, 0.0, l_tmin, graph_size-1);
		p->drawRect(rectangle);

		QRectF rectangle2(l_tmax, 0.0, graph_size-1-l_tmax, graph_size-1);
		p->drawRect(rectangle2);
	}
	else if(fe_seleted==2)
	{
		p->setPen(Qt::black);
		p->setBrush(QBrush ( QColor(128,128,128,128), Qt::SolidPattern ));
		QRectF rectangle(0.0, 0.0, la_tmin, graph_size-1);
		p->drawRect(rectangle);

		QRectF rectangle2(la_tmax, 0.0, graph_size-1-la_tmax, graph_size-1);
		p->drawRect(rectangle2);
	}
	else if(fe_seleted==3)
	{
		p->setPen(Qt::red);
		p->setBrush(QBrush ( QColor(255,0,0,128), Qt::SolidPattern ));
		QRectF rectangle(0.0, 0.0, r_tmin, graph_size-1);
		p->drawRect(rectangle);

		QRectF rectangle2(r_tmax, 0.0, graph_size-1-r_tmax, graph_size-1);
		p->drawRect(rectangle2);
	}
	else if(fe_seleted==4)
	{
		p->setPen(Qt::green);
		p->setBrush(QBrush ( QColor(0,255,0,128), Qt::SolidPattern ));
		QRectF rectangle(0.0, 0.0, g_tmin, graph_size-1);
		p->drawRect(rectangle);

		QRectF rectangle2(g_tmax, 0.0, graph_size-1-g_tmax, graph_size-1);
		p->drawRect(rectangle2);
	}
	else if(fe_seleted==5)
	{
		p->setPen(Qt::blue);
		p->setBrush(QBrush ( QColor(0,0,255,128), Qt::SolidPattern ));
		QRectF rectangle(0.0, 0.0, b_tmin, graph_size-1);
		p->drawRect(rectangle);

		QRectF rectangle2(b_tmax, 0.0, graph_size-1-b_tmax, graph_size-1);
		p->drawRect(rectangle2);	
	}
	else if(fe_seleted==6)
	{
		p->setPen(Qt::red);
		p->setBrush(QBrush ( QColor(255,0,0,128), Qt::SolidPattern ));
		QRectF rectangle(0.0, 0.0, ra_tmin, graph_size-1);
		p->drawRect(rectangle);

		QRectF rectangle2(ra_tmax, 0.0, graph_size-1-ra_tmax, graph_size-1);
		p->drawRect(rectangle2);
	}
	else if(fe_seleted==7)
	{
		p->setPen(Qt::green);
		p->setBrush(QBrush ( QColor(0,255,0,128), Qt::SolidPattern ));
		QRectF rectangle(0.0, 0.0, ga_tmin, graph_size-1);
		p->drawRect(rectangle);

		QRectF rectangle2(ga_tmax, 0.0, graph_size-1-ga_tmax, graph_size-1);
		p->drawRect(rectangle2);
	}
	else if(fe_seleted==8)
	{
		p->setPen(Qt::blue);
		p->setBrush(QBrush ( QColor(0,0,255,128), Qt::SolidPattern ));
		QRectF rectangle(0.0, 0.0, ba_tmin, graph_size-1);
		p->drawRect(rectangle);

		QRectF rectangle2(ba_tmax, 0.0, graph_size-1-ba_tmax, graph_size-1);
		p->drawRect(rectangle2);
	}

	p->setBrush(Qt::NoBrush);
}


void QtHistogram::draw_transfer(void)
{
	//setPixmap(histogram_pm);
	update();
}


void QtHistogram::paintEvent( QPaintEvent *e )
{	
	QPainter pp(this);
	pp.setRenderHint(QPainter::Antialiasing, false);	

	//pp.scale((float)width()/(float)graph_size, (float)height()/(float)graph_size);

	pp.scale((float)width()/(float)canvas_size, (float)height()/(float)canvas_size);
	
	//Change to constructor, and QPallete SetBrush BackgroundRole
	pp.fillRect(QRect(0, 0, canvas_size, canvas_size), QBrush ( QColor(128,128,128,255), Qt::SolidPattern ));

	pp.translate(border,border);
	draw_functioneditor(&pp);
}
void QtHistogram::resizeEvent ( QResizeEvent *e )
{
//	setMinimumHeight(e->size().height());

//	setMinimumWidth(e->size().height());

//	setMaximumHeight(e->size().height());
//	setMaximumWidth(e->size().height());

//	printf("W, H: %d, %d\n", width(), height());

//	histogram_pm.resize(1, 1);
//	float oldsize = size;

/*	if(width()<height()) size = width();
		else size = height();
	
	graph_size=size;
*/
//	graph_size = size*0.7;
//	border = (size-graph_size)/2.0;

	//histogram_pm = histogram_pm.scaled(width(), height(), Qt::KeepAspectRatio, Qt::SmoothTransformation);
	//setPixmap(histogram_pm);
//	maxthr= ((float)maxthr/oldsize) * size;
//	minthr= ((float)minthr/oldsize) * size;;*/
}

void QtHistogram::mouseMoveEvent  ( QMouseEvent * e )
{
	if(!tfunc_enable) return;

	float x = (((float)(e->x())/(float)width())*canvas_size)-border;
	float y = (((float)(e->y())/(float)height())*canvas_size)-border;
	
	if(fe_seleted==1) if(fe_l.selected!=-1|| fe_l.delete_event==1) fe_l.movePoint(x, y);
	if(fe_seleted==2) if(fe_la.selected!=-1|| fe_la.delete_event==1) fe_la.movePoint(x, y);
	if(fe_seleted==3) if(fe_r.selected!=-1|| fe_r.delete_event==1) fe_r.movePoint(x, y);
	if(fe_seleted==4) if(fe_g.selected!=-1|| fe_g.delete_event==1) fe_g.movePoint(x, y);
	if(fe_seleted==5) if(fe_b.selected!=-1|| fe_b.delete_event==1) fe_b.movePoint(x, y);
	if(fe_seleted==6) if(fe_ra.selected!=-1|| fe_ra.delete_event==1) fe_ra.movePoint(x, y);
	if(fe_seleted==7) if(fe_ga.selected!=-1|| fe_ga.delete_event==1) fe_ga.movePoint(x, y);
	if(fe_seleted==8) if(fe_ba.selected!=-1|| fe_ba.delete_event==1) fe_ba.movePoint(x, y);

	//for(int i=0; i<256; i++) 
	//printf("fe: %d \n", (int)fe_la.bs.curve_points[0].y);

	//draw_transfer();
	update();
}
void QtHistogram::mouseDoubleClickEvent(QMouseEvent * e)
{
	if(!tfunc_enable) return;
	
	float x = (((float)(e->x())/(float)width())*canvas_size)-border;
	float y = (((float)(e->y())/(float)height())*canvas_size)-border;

	if ((e->button()==Qt::LeftButton)) 
	{
		if(fe_seleted==1) fe_l.selectPoint(x, y);	
		else if(fe_seleted==2) fe_la.selectPoint(x, y);
		else if(fe_seleted==3) fe_r.selectPoint(x, y);
		else if(fe_seleted==4) fe_g.selectPoint(x, y);
		else if(fe_seleted==5) fe_b.selectPoint(x, y);
		else if(fe_seleted==6) fe_ra.selectPoint(x, y);
		else if(fe_seleted==7) fe_ga.selectPoint(x, y);
		else if(fe_seleted==8) fe_ba.selectPoint(x, y);
	}
}
void QtHistogram::mousePressEvent  ( QMouseEvent * e )
{
	if(!tfunc_enable) return;
	
	float x = (((float)(e->x())/(float)width())*canvas_size)-border;
	float y = (((float)(e->y())/(float)height())*canvas_size)-border;

	if ((e->button()==Qt::LeftButton)) 
	{
		if(fe_seleted==1) fe_l.selectPoint(x, y);	
		else if(fe_seleted==2) fe_la.selectPoint(x, y);
		else if(fe_seleted==3) fe_r.selectPoint(x, y);
		else if(fe_seleted==4) fe_g.selectPoint(x, y);
		else if(fe_seleted==5) fe_b.selectPoint(x, y);
		else if(fe_seleted==6) fe_ra.selectPoint(x, y);
		else if(fe_seleted==7) fe_ga.selectPoint(x, y);
		else if(fe_seleted==8) fe_ba.selectPoint(x, y);
	}
	else if ((e->button()==Qt::MidButton)) 
	{
		if(fe_seleted==1)
		{
			if(fe_l.selectPoint(x, y)) fe_l.deletePoint();
		}
		if(fe_seleted==2)
		{
			if(fe_la.selectPoint(x, y)) fe_la.deletePoint();
		}
		if(fe_seleted==3)
		{
			if(fe_r.selectPoint(x, y)) fe_r.deletePoint();
		}
		if(fe_seleted==4)
		{
			if(fe_g.selectPoint(x, y)) fe_g.deletePoint();
		}
		if(fe_seleted==5)
		{
			if(fe_b.selectPoint(x, y)) fe_b.deletePoint();
		}
		if(fe_seleted==6)
		{
			if(fe_ra.selectPoint(x, y)) fe_ra.deletePoint();
		}
		if(fe_seleted==7)
		{
			if(fe_ga.selectPoint(x, y)) fe_ga.deletePoint();
		}		
		if(fe_seleted==8)
		{
			if(fe_ba.selectPoint(x, y)) fe_ba.deletePoint();
		}
	}
	else if ((e->button()==Qt::RightButton)) 
	{
		if(fe_seleted==1)
		{
			fe_l.addPoint(x,y);
		}
		if(fe_seleted==2)
		{
			fe_la.addPoint(x,y);
		}
		if(fe_seleted==3)
		{
			fe_r.addPoint(x,y);
		}
		if(fe_seleted==4)
		{
			fe_g.addPoint(x,y);
		}
		if(fe_seleted==5)
		{
			fe_b.addPoint(x,y);
		}
		if(fe_seleted==6)
		{
			fe_ra.addPoint(x,y);
		}
		if(fe_seleted==7)
		{
			fe_ga.addPoint(x,y);
		}		
		if(fe_seleted==8)
		{
			fe_ba.addPoint(x,y);
		}	
		
		//draw_transfer();
	}
}
void QtHistogram::mouseReleaseEvent(QMouseEvent * e )
{
	if(!tfunc_enable) return;
	
	if ((e->state()&QEvent::MouseButtonRelease))
	{
		mouse_release();
		//draw_transfer();
	}	
}
void QtHistogram::mouse_release(void)
{
	setCursor(QCursor(Qt::waitCursor));

	if(fe_seleted==1)
	{
		fe_l.selected = -1;
		fe_l.delete_event=0;
	}
	if(fe_seleted==2)
	{
		fe_la.selected = -1;
		fe_la.delete_event=0;
	}
	if(fe_seleted==3)
	{
		fe_r.selected = -1;
		fe_r.delete_event=0;
	}
	if(fe_seleted==4)
	{
		fe_g.selected = -1;
		fe_g.delete_event=0;
	}
	if(fe_seleted==5)
	{
		fe_b.selected = -1;
		fe_b.delete_event=0;
	}
	if(fe_seleted==6)
	{
		fe_ra.selected = -1;
		fe_ra.delete_event=0;
	}
	if(fe_seleted==7)
	{
		fe_ga.selected = -1;
		fe_ga.delete_event=0;
	}		
	if(fe_seleted==8)
	{
		fe_ba.selected = -1;
		fe_ba.delete_event=0;
	}

	emit_tfunc_current();
	emit hist_redraw_signal();

	setCursor(QCursor(Qt::arrowCursor));
}

void QtHistogram::emit_redraw(void)
{
	emit hist_redraw_signal();	
}

void QtHistogram::emit_tfunc_reloadall(void)
{

	//now just let the shader know about the new lookup table
	//we generated.

	emit hist_transfer_function_all_signal(fe_r.bs.curve_points, fe_g.bs.curve_points, fe_b.bs.curve_points, 
									  fe_ra.bs.curve_points, fe_ga.bs.curve_points, fe_ba.bs.curve_points, graph_size, 0);

}
void QtHistogram::emit_tfunc_all(void)
{
	//if we are in intensity mode, then set all othe
	//lookups to that of L & I
	if(fe_seleted==1)
	{
		fe_r.bs = fe_g.bs = fe_b.bs = fe_l.bs;
	}
	if(fe_seleted==2)
	{
		fe_ra.bs = fe_ga.bs = fe_ba.bs = fe_la.bs;
	}

	//now just let the shader know about the new lookup table
	//we generated.

	emit hist_transfer_function_all_signal(fe_r.bs.curve_points, fe_g.bs.curve_points, fe_b.bs.curve_points, 
									  fe_ra.bs.curve_points, fe_ga.bs.curve_points, fe_ba.bs.curve_points, graph_size, 0);

}
void QtHistogram::emit_tfunc_current(void)
{
	//if we are in intensity mode, then set all othe
	//lookups to that of L & I
	if(fe_seleted==1)
	{
		fe_r.bs = fe_g.bs = fe_b.bs = fe_l.bs;
	}
	if(fe_seleted==2)
	{
		fe_ra.bs = fe_ga.bs = fe_ba.bs = fe_la.bs;
	}

	if(is16bitdata==false)
	{
		//now just let the shader know about the new lookup table
		//we generated.
		if(fe_seleted==1)
			emit hist_tfunc_signal(fe_l.bs.curve_points, 255, 0, fe_seleted, slice_toggle);
		else if(fe_seleted==2)
			emit hist_tfunc_signal(fe_la.bs.curve_points, 255, 0, fe_seleted, slice_toggle);
		if(fe_seleted==3)
			emit hist_tfunc_signal(fe_r.bs.curve_points, 255, 0, fe_seleted, slice_toggle);
		else if(fe_seleted==4)
			emit hist_tfunc_signal(fe_g.bs.curve_points, 255, 0, fe_seleted, slice_toggle);
		else if(fe_seleted==5)
			emit hist_tfunc_signal(fe_b.bs.curve_points, 255, 0, fe_seleted, slice_toggle);
		else if(fe_seleted==6)
			emit hist_tfunc_signal(fe_ra.bs.curve_points, 255, 0, fe_seleted, slice_toggle);
		else if(fe_seleted==7)
			emit hist_tfunc_signal(fe_ga.bs.curve_points, 255, 0, fe_seleted, slice_toggle);
		else if(fe_seleted==8)
			emit hist_tfunc_signal(fe_ba.bs.curve_points, 255, 0, fe_seleted, slice_toggle);
	}
	else
	{
		//now just let the shader know about the new lookup table
		//we generated.
		if(fe_seleted==1)
			emit hist_tfunc16bit_signal(fe_l.bs.control_points, 255, 0, fe_seleted, slice_toggle);
		else if(fe_seleted==2)
			emit hist_tfunc16bit_signal(fe_la.bs.control_points, 255, 0, fe_seleted, slice_toggle);
		if(fe_seleted==3)
			emit hist_tfunc16bit_signal(fe_r.bs.control_points, 255, 0, fe_seleted, slice_toggle);
		else if(fe_seleted==4)
			emit hist_tfunc16bit_signal(fe_g.bs.control_points, 255, 0, fe_seleted, slice_toggle);
		else if(fe_seleted==5)
			emit hist_tfunc16bit_signal(fe_b.bs.control_points, 255, 0, fe_seleted, slice_toggle);
		else if(fe_seleted==6)
			emit hist_tfunc16bit_signal(fe_ra.bs.control_points, 255, 0, fe_seleted, slice_toggle);
		else if(fe_seleted==7)
			emit hist_tfunc16bit_signal(fe_ga.bs.control_points, 255, 0, fe_seleted, slice_toggle);
		else if(fe_seleted==8)
			emit hist_tfunc16bit_signal(fe_ba.bs.control_points, 255, 0, fe_seleted, slice_toggle);		
	}
}

void QtHistogram::save(void)
{
	printf("tfunc_save_slot\n");
	int i;
	
	QFileDialog* fd = new QFileDialog(this);
	QString fn = fd->getSaveFileName(currentworkingdir, "*.tfn", this );

	if(fn.isEmpty()) return;

	//check the user entered the extension, otherwise add it to the filename
	if(fn[int(fn.length()-4)]!='.') fn += ".tfn";

	if (fn.isEmpty()) return;

	ofstream fout;												
	fout.open(fn.latin1());

	fout<<"// Transfer Function File"<<endl<<endl;
	
	fout<<"// brightness, contrast, threshmax, threshmin, invert"<<endl;
	fout<<"// int, int, int, int, bool"<<endl;
	fout<<"//=========================================================="<<endl;
	fout<<"L	"<<l_bright<<"	"<<l_cont<<"	"<<l_tmax<<"	"<<l_tmin<<"	"<<inv_l<<endl;
	fout<<"LA	"<<la_bright<<"	"<<la_cont<<"	"<<la_tmax<<"	"<<la_tmin<<"	"<<inv_la<<endl;
	fout<<"R	"<<r_bright<<"	"<<r_cont<<"	"<<r_tmax<<"	"<<r_tmin<<"	"<<inv_r<<endl;
	fout<<"G	"<<g_bright<<"	"<<g_cont<<"	"<<g_tmax<<"	"<<g_tmin<<"	"<<inv_g<<endl;
	fout<<"B	"<<b_bright<<"	"<<b_cont<<"	"<<b_tmax<<"	"<<b_tmin<<"	"<<inv_b<<endl<<endl;
	fout<<"RA	"<<ra_bright<<"	"<<ra_cont<<"	"<<ra_tmax<<"	"<<ra_tmin<<"	"<<inv_ra<<endl;
	fout<<"GA	"<<ga_bright<<"	"<<ga_cont<<"	"<<ga_tmax<<"	"<<ga_tmin<<"	"<<inv_ga<<endl;
	fout<<"BA	"<<ba_bright<<"	"<<ba_cont<<"	"<<ba_tmax<<"	"<<ba_tmin<<"	"<<inv_ba<<endl<<endl;

	fout<<"// Trasnfer Functions"<<endl;
	fout<<"// size, cp.x, cp.y, cp.z ....."<<endl;
	fout<<"// int, float, float, float ...."<<endl;
	fout<<"//=========================================================="<<endl;

	fout<<"TF_L_CONTROL_POINTS"<<endl;
	fout<<fe_l.bs.control_points.size()<<endl;
	for(i=0; i<fe_l.bs.control_points.size(); i++)
	{
		fout<<fe_l.bs.control_points[i].x<<"	"<<fe_l.bs.control_points[i].y<<"	"<<fe_l.bs.control_points[i].z<<endl;
	}
	fout<<endl;
	fout<<"TF_LA_CONTROL_POINTS"<<endl;
	fout<<fe_la.bs.control_points.size()<<endl;
	for(i=0; i<fe_la.bs.control_points.size(); i++)
	{
		fout<<fe_la.bs.control_points[i].x<<"	"<<fe_la.bs.control_points[i].y<<"	"<<fe_la.bs.control_points[i].z<<endl;
	}
	fout<<endl;	
	fout<<"TF_R_CONTROL_POINTS"<<endl;
	fout<<fe_r.bs.control_points.size()<<endl;
	for(i=0; i<fe_r.bs.control_points.size(); i++)
	{
		fout<<fe_r.bs.control_points[i].x<<"	"<<fe_r.bs.control_points[i].y<<"	"<<fe_r.bs.control_points[i].z<<endl;
	}
	fout<<endl;
	fout<<"TF_RA_CONTROL_POINTS"<<endl;
	fout<<fe_ra.bs.control_points.size()<<endl;
	for(i=0; i<fe_ra.bs.control_points.size(); i++)
	{
		fout<<fe_ra.bs.control_points[i].x<<"	"<<fe_ra.bs.control_points[i].y<<"	"<<fe_ra.bs.control_points[i].z<<endl;
	}
	fout<<endl;
	fout<<"TF_G_CONTROL_POINTS"<<endl;
	fout<<fe_g.bs.control_points.size()<<endl;
	for(i=0; i<fe_g.bs.control_points.size(); i++)
	{
		fout<<fe_g.bs.control_points[i].x<<"	"<<fe_g.bs.control_points[i].y<<"	"<<fe_g.bs.control_points[i].z<<endl;
	}
	fout<<endl;
	fout<<"TF_GA_CONTROL_POINTS"<<endl;
	fout<<fe_ga.bs.control_points.size()<<endl;
	for(i=0; i<fe_ga.bs.control_points.size(); i++)
	{
		fout<<fe_ga.bs.control_points[i].x<<"	"<<fe_ga.bs.control_points[i].y<<"	"<<fe_ga.bs.control_points[i].z<<endl;
	}
	fout<<endl;
	fout<<"TF_B_CONTROL_POINTS"<<endl;
	fout<<fe_b.bs.control_points.size()<<endl;
	for(i=0; i<fe_b.bs.control_points.size(); i++)
	{
		fout<<fe_b.bs.control_points[i].x<<"	"<<fe_b.bs.control_points[i].y<<"	"<<fe_b.bs.control_points[i].z<<endl;
	}
	fout<<endl;
	fout<<"TF_BA_CONTROL_POINTS"<<endl;
	fout<<fe_ba.bs.control_points.size()<<endl;
	for(i=0; i<fe_ba.bs.control_points.size(); i++)
	{
		fout<<fe_ba.bs.control_points[i].x<<"	"<<fe_ba.bs.control_points[i].y<<"	"<<fe_ba.bs.control_points[i].z<<endl;
	}
	fout<<endl;

	fout.close();

	delete fd;
}
void QtHistogram::loadfile(QString fn)
{
	if(fn.isEmpty()) return;

	//temp storage for param parsing
	string label;
	int i;
	int size;
	Vector v;

	//clear our BSs
	fe_l.bs.clear();
	fe_la.bs.clear();
	fe_r.bs.clear();
	fe_ra.bs.clear();
	fe_g.bs.clear();
	fe_ga.bs.clear();
	fe_b.bs.clear();
	fe_ba.bs.clear();

	//input file for reading in parameter ranges
	ifstream input_file; 
	input_file.open(fn.latin1());

	//tokenize our input file
	Tokenizer token(input_file);

	//until oef is reached step through each token
	while(!input_file.eof()){
		if(token.ttype()==TT_WORD)
		{
			//get the first string lable
			label = token.sval();
			
			if(label=="L")
			{		
				token.nextToken();
				if(token.ttype()==TT_NUMBER) l_bright = token.nval();
				token.nextToken();
				if(token.ttype()==TT_NUMBER) l_cont = token.nval();
				token.nextToken();
				if(token.ttype()==TT_NUMBER) l_tmax = token.nval();
				token.nextToken();
				if(token.ttype()==TT_NUMBER) l_tmin = token.nval();
				token.nextToken();
				if(token.ttype()==TT_NUMBER) inv_l = token.nval();
			}
			else if(label=="LA")
			{		
				token.nextToken();
				if(token.ttype()==TT_NUMBER) la_bright = token.nval();
				token.nextToken();
				if(token.ttype()==TT_NUMBER) la_cont = token.nval();
				token.nextToken();
				if(token.ttype()==TT_NUMBER) la_tmax = token.nval();
				token.nextToken();
				if(token.ttype()==TT_NUMBER) la_tmin = token.nval();
				token.nextToken();
				if(token.ttype()==TT_NUMBER) inv_la = token.nval();
			}
			else if(label=="R")
			{		
				token.nextToken();
				if(token.ttype()==TT_NUMBER) r_bright = token.nval();
				token.nextToken();
				if(token.ttype()==TT_NUMBER) r_cont = token.nval();
				token.nextToken();
				if(token.ttype()==TT_NUMBER) r_tmax = token.nval();
				token.nextToken();
				if(token.ttype()==TT_NUMBER) r_tmin = token.nval();
				token.nextToken();
				if(token.ttype()==TT_NUMBER) inv_r = token.nval();
			}
			else if(label=="G")
			{		
				token.nextToken();
				if(token.ttype()==TT_NUMBER) g_bright = token.nval();
				token.nextToken();
				if(token.ttype()==TT_NUMBER) g_cont = token.nval();
				token.nextToken();
				if(token.ttype()==TT_NUMBER) g_tmax = token.nval();
				token.nextToken();
				if(token.ttype()==TT_NUMBER) g_tmin = token.nval();
				token.nextToken();
				if(token.ttype()==TT_NUMBER) inv_g = token.nval();
			}			
			else if(label=="B")
			{		
				token.nextToken();
				if(token.ttype()==TT_NUMBER) b_bright = token.nval();
				token.nextToken();
				if(token.ttype()==TT_NUMBER) b_cont = token.nval();
				token.nextToken();
				if(token.ttype()==TT_NUMBER) b_tmax = token.nval();
				token.nextToken();
				if(token.ttype()==TT_NUMBER) b_tmin = token.nval();
				token.nextToken();
				if(token.ttype()==TT_NUMBER) inv_b = token.nval();
			}			
			else if(label=="RA")
			{		
				token.nextToken();
				if(token.ttype()==TT_NUMBER) ra_bright = token.nval();
				token.nextToken();
				if(token.ttype()==TT_NUMBER) ra_cont = token.nval();
				token.nextToken();
				if(token.ttype()==TT_NUMBER) ra_tmax = token.nval();
				token.nextToken();
				if(token.ttype()==TT_NUMBER) ra_tmin = token.nval();
				token.nextToken();
				if(token.ttype()==TT_NUMBER) inv_ra = token.nval();
			}
			else if(label=="GA")
			{		
				token.nextToken();
				if(token.ttype()==TT_NUMBER) ga_bright = token.nval();
				token.nextToken();
				if(token.ttype()==TT_NUMBER) ga_cont = token.nval();
				token.nextToken();
				if(token.ttype()==TT_NUMBER) ga_tmax = token.nval();
				token.nextToken();
				if(token.ttype()==TT_NUMBER) ga_tmin = token.nval();
				token.nextToken();
				if(token.ttype()==TT_NUMBER) inv_ga = token.nval();
			}			
			else if(label=="BA")
			{		
				token.nextToken();
				if(token.ttype()==TT_NUMBER) ba_bright = token.nval();
				token.nextToken();
				if(token.ttype()==TT_NUMBER) ba_cont = token.nval();
				token.nextToken();
				if(token.ttype()==TT_NUMBER) ba_tmax = token.nval();
				token.nextToken();
				if(token.ttype()==TT_NUMBER) ba_tmin = token.nval();
				token.nextToken();
				if(token.ttype()==TT_NUMBER) inv_ba = token.nval();
			}			
			else if(label=="TF_L_CONTROL_POINTS")
			{		
				token.nextToken();
				if(token.ttype()==TT_NUMBER) size = token.nval();
				
				for(i=0; i<size; i++)
				{
					token.nextToken();
					if(token.ttype()==TT_NUMBER) v.x = token.nval();
					token.nextToken();
					if(token.ttype()==TT_NUMBER) v.y = token.nval();
					token.nextToken();
					if(token.ttype()==TT_NUMBER) v.z = token.nval();

					fe_l.bs.control_points.push_back(v);
				}
			}			
			else if(label=="TF_LA_CONTROL_POINTS")
			{		
				token.nextToken();
				if(token.ttype()==TT_NUMBER) size = token.nval();
				
				for(i=0; i<size; i++)
				{
					token.nextToken();
					if(token.ttype()==TT_NUMBER) v.x = token.nval();
					token.nextToken();
					if(token.ttype()==TT_NUMBER) v.y = token.nval();
					token.nextToken();
					if(token.ttype()==TT_NUMBER) v.z = token.nval();

					fe_la.bs.control_points.push_back(v);
				}
			}
			else if(label=="TF_R_CONTROL_POINTS")
			{		
				token.nextToken();
				if(token.ttype()==TT_NUMBER) size = token.nval();
				
				for(i=0; i<size; i++)
				{
					token.nextToken();
					if(token.ttype()==TT_NUMBER) v.x = token.nval();
					token.nextToken();
					if(token.ttype()==TT_NUMBER) v.y = token.nval();
					token.nextToken();
					if(token.ttype()==TT_NUMBER) v.z = token.nval();

					fe_r.bs.control_points.push_back(v);
				}
			}
			else if(label=="TF_RA_CONTROL_POINTS")
			{		
				token.nextToken();
				if(token.ttype()==TT_NUMBER) size = token.nval();
				
				for(i=0; i<size; i++)
				{
					token.nextToken();
					if(token.ttype()==TT_NUMBER) v.x = token.nval();
					token.nextToken();
					if(token.ttype()==TT_NUMBER) v.y = token.nval();
					token.nextToken();
					if(token.ttype()==TT_NUMBER) v.z = token.nval();

					fe_ra.bs.control_points.push_back(v);
				}
			}
			else if(label=="TF_G_CONTROL_POINTS")
			{		
				token.nextToken();
				if(token.ttype()==TT_NUMBER) size = token.nval();
				
				for(i=0; i<size; i++)
				{
					token.nextToken();
					if(token.ttype()==TT_NUMBER) v.x = token.nval();
					token.nextToken();
					if(token.ttype()==TT_NUMBER) v.y = token.nval();
					token.nextToken();
					if(token.ttype()==TT_NUMBER) v.z = token.nval();

					fe_g.bs.control_points.push_back(v);
				}
			}
			else if(label=="TF_GA_CONTROL_POINTS")
			{		
				token.nextToken();
				if(token.ttype()==TT_NUMBER) size = token.nval();
				
				for(i=0; i<size; i++)
				{
					token.nextToken();
					if(token.ttype()==TT_NUMBER) v.x = token.nval();
					token.nextToken();
					if(token.ttype()==TT_NUMBER) v.y = token.nval();
					token.nextToken();
					if(token.ttype()==TT_NUMBER) v.z = token.nval();

					fe_ga.bs.control_points.push_back(v);
				}
			}
			else if(label=="TF_B_CONTROL_POINTS")
			{		
				token.nextToken();
				if(token.ttype()==TT_NUMBER) size = token.nval();
				
				for(i=0; i<size; i++)
				{
					token.nextToken();
					if(token.ttype()==TT_NUMBER) v.x = token.nval();
					token.nextToken();
					if(token.ttype()==TT_NUMBER) v.y = token.nval();
					token.nextToken();
					if(token.ttype()==TT_NUMBER) v.z = token.nval();

					fe_b.bs.control_points.push_back(v);
				}
			}
			else if(label=="TF_BA_CONTROL_POINTS")
			{		
				token.nextToken();
				if(token.ttype()==TT_NUMBER) size = token.nval();
				
				for(i=0; i<size; i++)
				{
					token.nextToken();
					if(token.ttype()==TT_NUMBER) v.x = token.nval();
					token.nextToken();
					if(token.ttype()==TT_NUMBER) v.y = token.nval();
					token.nextToken();
					if(token.ttype()==TT_NUMBER) v.z = token.nval();

					fe_ba.bs.control_points.push_back(v);
				}
			}	
			//else if we dont know what it is, go to next label
			else
			{
				//f<<"WARNING: Unrecognized Label..."<<endl;
				token.nextToken();
			}
		}
		else token.nextToken();
	}

	input_file.close();

	//compute our BS curve from our loaded control points
	fe_l.bs.compute();
	fe_la.bs.compute();
	fe_r.bs.compute();
	fe_ra.bs.compute();
	fe_g.bs.compute();
	fe_ga.bs.compute();
	fe_b.bs.compute();
	fe_ba.bs.compute();
}
void QtHistogram::load(void)
{
	QFileDialog* fd = new QFileDialog( this );

	QString fn = fd->getOpenFileName(currentworkingdir, "*.tfn", this );
	loadfile(fn);
	delete fd;
}
void QtHistogram::hist_setcurrentworkingdir_slot(QString dn)
{
	currentworkingdir = dn;
}
void QtHistogram::hist_is16bit_slot(bool value)
{
	is16bitdata = value;
}