#ifndef QTHISTOGRAM_H
#define QTHISTOGRAM_H

#include <qpainter.h>
#include <qpixmap.h>
#include <qlabel.h>
#include <qsizepolicy.h>
#include <qcursor.h>
#include <QPaintEvent>
#include <QResizeEvent>
#include <QMouseEvent>
#include <QPainterPath>
#include <QRectF>
#include <qfiledialog.h>

#include <stdio.h>
#include <stdlib.h>
#include <fstream>

#include "FunctionEditor.h"
#include "Tokenizer.h"
#include "Vector.h"

class QtHistogram: public QLabel
{
	Q_OBJECT
		
public:

	QString currentworkingdir;

	bool is16bitdata;
	
	//toggles update of slices upon
	//tfunc change
	int slice_toggle;

	int hist_enable;
	int cumfreq_enable;
	int tfunc_enable;

	int fe_seleted;
	int fe_l_update;
	int fe_la_update;
	int fe_r_update;
	int fe_g_update;
	int fe_b_update;
	int fe_ra_update;
	int fe_ga_update;
	int fe_ba_update;

	//transfer functions
	FunctionEditor fe_l;
	FunctionEditor fe_la;
	FunctionEditor fe_r;
	FunctionEditor fe_g;
	FunctionEditor fe_b;
	FunctionEditor fe_ra;
	FunctionEditor fe_ga;
	FunctionEditor fe_ba;

	//brightness & contrast
	int l_bright;
	int l_cont;
	int la_bright;
	int la_cont;
	int r_bright;
	int r_cont;
	int g_bright;
	int g_cont;
	int b_bright;
	int b_cont;
	int ra_bright;
	int ra_cont;
	int ga_bright;
	int ga_cont;
	int ba_bright;
	int ba_cont;

	//threshold
	int l_tmin;
	int l_tmax;
	int la_tmin;
	int la_tmax;
	int r_tmin;
	int r_tmax;
	int g_tmin;
	int g_tmax;
	int b_tmin;
	int b_tmax;
	int ra_tmin;
	int ra_tmax;
	int ga_tmin;
	int ga_tmax;
	int ba_tmin;
	int ba_tmax;

	//invert
	bool inv_l;
	bool inv_la;
	bool inv_r;
	bool inv_g;
	bool inv_b;
	bool inv_ra;
	bool inv_ga;
	bool inv_ba;

	//Pixmap Graph, we could use QCanvas, TO DO...
	float canvas_size;
	float graph_size;
	float border;

	//pointer to our histogram data
	double* data;
	double max_histogram;

	int minthr;
	int maxthr;

	int logscale;

	QtHistogram(QWidget* parent=0, const char* name=0, float size=1);
	~QtHistogram();

	void reset(void);
	void reset_transfer_function_parameters(void);
	void reload_transfer_function_parameters(void);
	void reset_l(void);
	void reset_la(void);
	void reset_r(void);
	void reset_g(void);
	void reset_b(void);
	void reset_ra(void);
	void reset_ga(void);
	void reset_ba(void);
	void create(void);
	void save(void);
	void load(void);
	void loadfile(QString);

	void set_transfer_mode(int mode);
	
	void draw_functioneditor(QPainter* p);
	void draw_functioneditoronpixmap(QPainter* p, FunctionEditor* func, QColor col);

	void draw_histogram(QPainter* p);
	void draw_transfer(void);
	void mouse_release(void);
	void emit_tfunc_all(void);
	void emit_tfunc_reloadall(void);
	void emit_tfunc_current(void);
	void emit_redraw(void);
protected:
	void mouseDoubleClickEvent(QMouseEvent * e);	
	void mouseMoveEvent   ( QMouseEvent * e );
	void mousePressEvent  ( QMouseEvent * e );
	void mouseReleaseEvent(QMouseEvent * e );
    void paintEvent( QPaintEvent * pe);
	void resizeEvent ( QResizeEvent * );

public slots:

	void hist_is16bit_slot(bool value);
	void hist_setcurrentworkingdir_slot(QString dn);

signals:

	void hist_redraw_signal(void);

	void hist_tfunc_signal(const vector<Vector>& cp, float size, float border, int mode, int toggle);
	
	void hist_tfunc16bit_signal(const vector<Vector>& cp, float size, float border, int mode, int toggle);
	
	void hist_transfer_function_all_signal(const vector<Vector>& r_tfunc_curvepts,  const vector<Vector>& g_tfunc_curvepts,  const vector<Vector>& b_tfunc_curvepts, 
									  const vector<Vector>& ra_tfunc_curvepts, const vector<Vector>& ga_tfunc_curvepts, const vector<Vector>& ba_tfunc_curvepts,
									  float graphsize, float border);
								  
	void hist_reset_transfer_function_parameters_signal(int _r_tmax, int _r_tmin, int _g_tmax, int _g_tmin, int _b_tmax, int _b_tmin, int _ra_tmax, int _ra_tmin, int _ga_tmax, int _ga_tmin, int _ba_tmax, int _ba_tmin,
													    int _r_bright, int _r_cont, int _g_bright, int _g_cont, int _b_bright, int _b_cont, int _ra_bright, int _ra_cont, int _ga_bright, int _ga_cont, int _ba_bright, int _ba_cont,
													    bool _inv_r,	bool _inv_g, bool _inv_b, bool _inv_ra, bool _inv_ga, bool _inv_ba);

};

#endif // QTHISTOGRAM_H
