#include "QtMainWindow.h"

QtMainWindow::QtMainWindow()
    : QMainWindow( 0, "", Qt::WDestructiveClose )
{
	auto_centre=1;
	main_width = 494*2;
	main_height = 383*2;
	channel_mode = 0;
	view_orientation = -1;
	window_main_screen = 0;
	maximised = 0;
	timelapsehelper=0;

	qfilesystemwatcher = new QFileSystemWatcher(this);
	qfilesystemwatcher->addPath("settings.ini");

	//=================================================
    //GL window
	// -------------------------------------------------------------------------	
	glwindow = new QtGLObjectWindow( this, "editor" );
	glwindow->setFocus();
    setCentralWidget( glwindow );

	//========================================================================
	//fileMenu = menuBar()->addMenu(tr("&File"));
	 	 
			 QAction* rawopenAct = new QAction(tr("&RAW Volume"), this);
			 rawopenAct->setShortcut(tr("Ctrl+R"));
			 rawopenAct->setStatusTip(tr("Open a RAW Volume image."));
			 connect(rawopenAct, SIGNAL(triggered()), this, SLOT(openraw_event()));
			 
			 QAction* stackopenAct = new QAction(tr("BMP/PNG/JPG/TIFF &Stack"), this);
			 stackopenAct->setShortcut(tr("Ctrl+S"));
			 stackopenAct->setStatusTip(tr("Open a series of BMP/PNG/JPG/TIFF stack images."));
			 connect(stackopenAct, SIGNAL(triggered()), this, SLOT(openImage_event()));
			 
			 QAction* timediropenAct = new QAction(tr("Open Timelapse &Direcotry"), this);
			 timediropenAct->setShortcut(tr("Ctrl+D"));
			 timediropenAct->setStatusTip(tr("Open a directory of BMP/PNG/JPG/TIFF stack images."));
			 connect(timediropenAct, SIGNAL(triggered()), this, SLOT(openTimelapse_event()));

		 openMenu =  new QMenu("Open Menu", this);//fileMenu->addMenu(tr("&Open"));
		 openMenu->addAction(rawopenAct);
		 openMenu->addAction(stackopenAct);
		 openMenu->addAction(timediropenAct);
		 openMenu->setTearOffEnabled(true);
		 openMenu->setTitle("Open Menu");

			 QAction* rawsaveAct = new QAction(tr("&RAW Volume"), this);
			 rawsaveAct->setShortcut(tr("Alt+R"));
			 rawsaveAct->setStatusTip(tr("Save a RAW Volume image."));
			 connect(rawsaveAct, SIGNAL(triggered()), this, SLOT(saveraw_event()));

			 QAction* pngsaveAct = new QAction(tr("PNG &Stack"), this);
			 pngsaveAct->setShortcut(tr("Alt+S"));
			 pngsaveAct->setStatusTip(tr("Save a PNG stack."));
			 connect(pngsaveAct, SIGNAL(triggered()), this, SLOT(savepng_event()));
			 
			 QAction* tiffsaveAct = new QAction(tr("multi-page &TIFF"), this);
			 tiffsaveAct->setShortcut(tr("Alt+T"));
			 tiffsaveAct->setStatusTip(tr("Save as a multi-page TIFF."));
			 connect(tiffsaveAct, SIGNAL(triggered()), this, SLOT(savetiff_event()));

			 QAction* rendersaveAct = new QAction(tr("&PNG Render Image"), this);
			 rendersaveAct->setShortcut(tr("Alt+P"));
			 rendersaveAct->setStatusTip(tr("Save a render image."));
			 connect(rendersaveAct, SIGNAL(triggered()), this, SLOT(saveImage_event()));

		 saveMenu =  new QMenu("Save Menu", this); //fileMenu->addMenu(tr("&Save"));
		 saveMenu->addAction(rawsaveAct);
		 saveMenu->addAction(pngsaveAct);
		 saveMenu->addAction(rendersaveAct);
		 //saveMenu->setTearOffEnabled(true);
		 saveMenu->setTitle("Save Menu");

	//========================================================================

	QMenu *viewMenu = new QMenu("View Menu", this);
	viewMenu->setTitle("View Menu");
	viewMenu->setTearOffEnabled(true);

			 QAction* fullscreenAct = new QAction(tr("Full Screen (ON/OFF)"), this);
			 //QPixmap fullscreenIcon = QPixmap( "icons/FS.png" );
			 fullscreenAct->setStatusTip(tr("Enable or Disable Full Screen Mode."));
			 fullscreenAct->setCheckable(true);
			 //fullscreenAct->setIcon(fullscreenIcon);
			 connect(fullscreenAct, SIGNAL(triggered()), this, SLOT(minibutton_fullscreen_event()));

			 QAction* viewResetAllAct = new QAction(tr("Reset All"), this);
			 //viewResetAllAct->setShortcut(tr("Alt+1"));
			 viewResetAllAct->setStatusTip(tr("Reset All (Zoom/Translation/Orientation)."));
			 connect(viewResetAllAct, SIGNAL(triggered()), this, SLOT(resetviewall_event()));

			 QAction* viewResetZoomAct = new QAction(tr("Reset Zoom"), this);
			// viewFrontAct->setShortcut(tr("Alt+1"));
			 viewResetZoomAct->setStatusTip(tr("Reset the Zoom."));
			 connect(viewResetZoomAct, SIGNAL(triggered()), this, SLOT(resetviewzoom_event()));

			 QAction* viewTranslationAct = new QAction(tr("Reset Translation"), this);
			 //viewFrontAct->setShortcut(tr("Alt+1"));
			 viewTranslationAct->setStatusTip(tr("Reset Translation."));
			 connect(viewTranslationAct, SIGNAL(triggered()), this, SLOT(resetviewtrans_event()));

			 QAction* viewBottomAct = new QAction(tr("Bottom"), this);
			 viewBottomAct->setShortcut(tr("Alt+1"));
			 viewBottomAct->setStatusTip(tr("View Volume image from Bottom."));
			 connect(viewBottomAct, SIGNAL(triggered()), this, SLOT(bottom_event()));

			 QAction* viewTopAct = new QAction(tr("Top"), this);
			 viewTopAct->setShortcut(tr("Alt+2"));
			 viewTopAct->setStatusTip(tr("View Volume image from Top."));
			 connect(viewTopAct, SIGNAL(triggered()), this, SLOT(top_event()));

			 QAction* viewBackAct = new QAction(tr("Back"), this);
			 viewBackAct->setShortcut(tr("Alt+3"));
			 viewBackAct->setStatusTip(tr("View Volume image from Back."));
			 connect(viewBackAct, SIGNAL(triggered()), this, SLOT(back_event()));
			 
			 QAction* viewFrontAct = new QAction(tr("Front"), this);
			 viewFrontAct->setShortcut(tr("Alt+4"));
			 viewFrontAct->setStatusTip(tr("View Volume image from Front."));
			 connect(viewFrontAct, SIGNAL(triggered()), this, SLOT(front_event()));

			 QAction* viewLeftAct = new QAction(tr("Left"), this);
			 viewLeftAct->setShortcut(tr("Alt+5"));
			 viewLeftAct->setStatusTip(tr("View Volume image from Left."));
			 connect(viewLeftAct, SIGNAL(triggered()), this, SLOT(left_event()));

			 QAction* viewRightAct = new QAction(tr("Right"), this);
			 viewRightAct->setShortcut(tr("Alt+6"));
			 viewRightAct->setStatusTip(tr("View Volume image from Right."));
			 connect(viewRightAct, SIGNAL(triggered()), this, SLOT(right_event()));

	viewMenu->addAction(fullscreenAct);
	viewMenu->addAction(viewResetAllAct);
	viewMenu->addAction(viewResetZoomAct);
	viewMenu->addAction(viewTranslationAct);
	viewMenu->addAction(viewBottomAct);
	viewMenu->addAction(viewTopAct);
	viewMenu->addAction(viewBackAct);
	viewMenu->addAction(viewFrontAct);
	viewMenu->addAction(viewLeftAct);
	viewMenu->addAction(viewRightAct);

	//========================================================================
	QMenu *renderinqualMenu = new QMenu("Render Quality Menu", this);
	renderinqualMenu->setTearOffEnabled(true);
	renderinqualMenu->setTitle("Render Quality Menu");

		QAction* hqAct = new QAction(tr("High Quality"), this);
		QPixmap hqIcon = QPixmap( "Icons/HQ.png" );
		hqAct->setStatusTip(tr("Change Rendering to High Quality Preset."));
		hqAct->setIcon(hqIcon);
		connect(hqAct, SIGNAL(triggered()), this, SLOT(minibutton_hq_event()));

		QAction* mqAct = new QAction(tr("Medium Quality"), this);
		QPixmap mqIcon = QPixmap( "Icons/mq.png" );
		mqAct->setStatusTip(tr("Change Rendering to Medium Quality Preset."));
		mqAct->setIcon(mqIcon);
		connect(mqAct, SIGNAL(triggered()), this, SLOT(minibutton_mq_event()));

		QAction* lqAct = new QAction(tr("Low Quality"), this);
		QPixmap lqIcon = QPixmap( "Icons/lq.png" );
		lqAct->setStatusTip(tr("Change Rendering to Low Quality Preset."));
		lqAct->setIcon(lqIcon);
		connect(lqAct, SIGNAL(triggered()), this, SLOT(minibutton_lq_event()));

	renderinqualMenu->addAction(hqAct);
	renderinqualMenu->addAction(mqAct);
	renderinqualMenu->addAction(lqAct);

	//============================================================================

	QPixmap intenIcon = QPixmap( "Icons/I.png" );
    intentb	= new QToolButton( intenIcon, "inten", QString::null,
			   this, SLOT(minibutton_I_event()), 0, "Intensity/RGB Channel Toggle" );
	intentb->setTextLabel("Intensity/RGB Channel Toggle");
	intentb->setToggleButton(true);

	QPixmap redIcon = QPixmap( "Icons/red.png" );
    redtb = new QToolButton( redIcon, "red", QString::null,
			   this, SLOT(minibutton_red_event()), 0, "red" );
	redtb->setTextLabel("Red Channel Toggle");
	redtb->setToggleButton(true);

	QPixmap greenIcon = QPixmap( "Icons/green.png" );
    greentb	= new QToolButton( greenIcon, "green", QString::null,
			   this, SLOT(minibutton_green_event()), 0, "Green Channel Toggle" );
	greentb->setTextLabel("Green Channel Toggle");
	greentb->setToggleButton(true);

	QPixmap blueIcon = QPixmap( "Icons/blue.png" );
    bluetb	= new QToolButton( blueIcon, "blue", QString::null,
			   this, SLOT(minibutton_blue_event()), 0, "Blue Channel Toggle" );
	bluetb->setTextLabel("Blue Channel Toggle");
	bluetb->setToggleButton(true);

	QPixmap surfacesIcon = QPixmap( "Icons/s.png" );
    QToolButton * surfacestb
	= new QToolButton( surfacesIcon, "Surfaces Display Toggle", QString::null,
			   this, SLOT(minibutton_surfaces_event()), 0, "surfaces" );
	surfacestb->setTextLabel("Surfaces Display Toggle");
	surfacestb->setToggleButton(true);
	surfacestb->setOn(true);

	//===============================================================
	QPixmap mipIcon = QPixmap( "Icons/mip.png" );
    QToolButton * miptb
	= new QToolButton( mipIcon, "mip", QString::null,
			   this, SLOT(minibutton_mip_event()), 0, "Maximum Intensity Projection Toggle" );
	miptb->setTextLabel("Maximum Intensity Projection Toggle");
	miptb->setToggleButton(true);

	QPixmap bgIcon = QPixmap( "Icons/bg.png" );
    bgtb = new QToolButton( bgIcon, "Background Colour Options", QString::null,
			   this, SLOT(minibutton_bg_event()), 0, "bg" );
	bgtb->setTextLabel("Background Colour Options");

	//===============================================================
	QMenu *toggleMenu = new QMenu("Toggle Menu", this);
	toggleMenu->setTearOffEnabled(true);
	toggleMenu->setTitle("Toggle Menu");

			 boundingboxAct = new QAction(tr("Bounding Box (ON/OFF)"), this);
			 QPixmap bbIcon = QPixmap( "Icons/bb.png" );
			 boundingboxAct->setStatusTip(tr("Enable or Disable the object Bounding Box."));
			 boundingboxAct->setCheckable(true);
			 boundingboxAct->setIcon(bbIcon);
			 connect(boundingboxAct, SIGNAL(triggered()), this, SLOT(minibutton_bb_event()));

 			 lightAct = new QAction(tr("Light (ON/OFF)"), this);
			 QPixmap lightIcon = QPixmap( "Icons/l.png" );
			 lightAct->setStatusTip(tr("Enable or Disable the display of the Light."));
			 lightAct->setCheckable(true);
			 lightAct->setIcon(lightIcon);
			 connect(lightAct, SIGNAL(triggered()), this, SLOT(minibutton_lights_event()));

 			 axisAct = new QAction(tr("Axis (ON/OFF)"), this);
			 QPixmap axisIcon = QPixmap( "Icons/a.png" );
			 axisAct->setStatusTip(tr("Enable or Disable the display of the Axis."));
			 axisAct->setCheckable(true);
			 axisAct->setIcon(axisIcon);
			 connect(axisAct, SIGNAL(triggered()), this, SLOT(minibutton_axis_event()));

 			 cursorAct = new QAction(tr("Cursor (ON/OFF)"), this);
			 QPixmap cursorIcon = QPixmap( "Icons/c.png" );
			 cursorAct->setStatusTip(tr("Enable or Disable the display of the Cursor."));
			 cursorAct->setCheckable(true);
			 cursorAct->setIcon(cursorIcon);
			 connect(cursorAct, SIGNAL(triggered()), this, SLOT(minibutton_cursor_event()));

			 scalebarAct = new QAction(tr("Scalebar (ON/OFF)"), this);
			 QPixmap scalebarIcon = QPixmap( "Icons/scalebar.png" );
			 scalebarAct->setStatusTip(tr("Enable or Disable the display of the Scalebar."));
			 scalebarAct->setCheckable(true);
			 scalebarAct->setIcon(scalebarIcon);
			 connect(scalebarAct, SIGNAL(triggered()), this, SLOT(toggle_scalebar_event()));

			 fpsAct = new QAction(tr("FPS (ON/OFF)"), this);
			 QPixmap fpsIcon = QPixmap( "Icons/fps.png" );
			 fpsAct->setStatusTip(tr("Enable or Disable the display of the Frames per Second."));
			 fpsAct->setCheckable(true);
			 fpsAct->setIcon(fpsIcon);
			 connect(fpsAct, SIGNAL(triggered()), this, SLOT(minibutton_fps_event()));
	
	//toggleMenu->addAction(fullscreenAct);
	toggleMenu->addAction(boundingboxAct);
	toggleMenu->addAction(lightAct);
	toggleMenu->addAction(axisAct);
	toggleMenu->addAction(cursorAct);
	toggleMenu->addAction(scalebarAct);
	toggleMenu->addAction(fpsAct);

	//===============================================================
	QPixmap infoIcon = QPixmap( "Icons/info.png" );
    QToolButton * infotb
	= new QToolButton( infoIcon, "Info Display Toggle", QString::null,
			   this, SLOT(minibutton_info_event()), 0, "info" );
	infotb->setTextLabel("Info Display Toggle");
 	infotb->setToggleButton(true);

	QPixmap threeDIcon = QPixmap( "Icons/3D.png" );
    QToolButton * threeDb
	= new QToolButton( threeDIcon, "3D", QString::null,
			   this, SLOT(minibutton_stereo_event()), 0, "3D" );
	threeDb->setTextLabel("Stereo Display Options");

	//===============================================================================================
		QPixmap viewIcon = QPixmap( "Icons/view.png" );
		QToolButton * viewb = new QToolButton(this);
		viewb->setIcon(viewIcon);
	//( viewIcon, "view", QString::null,
	//			   this, SLOT(), 0, "Viewing Direction Options" );
		viewb->setTextLabel("Viewing Direction Options");
		viewb->setMenu(viewMenu);
		viewb->setPopupMode(QToolButton::MenuButtonPopup);

		QPixmap toggleIcon = QPixmap( "Icons/onoff.png" );
		//QToolButton * toggleb
		QToolButton * toggleb = new QToolButton(this);
		toggleb->setIcon(toggleIcon);
	//	= new QToolButton( toggleIcon, "view", QString::null,
	//			   this, SLOT(), 0, "Viewing Direction Options" );
		toggleb->setTextLabel("Viewing Direction Options");
		toggleb->setMenu(toggleMenu);
		toggleb->setPopupMode(QToolButton::MenuButtonPopup);

		QPixmap renderIcon = QPixmap( "Icons/quality.png" );
		//QToolButton * renderqualb
		//= new QToolButton( renderIcon, "qual", QString::null,
		//		   this, SLOT(), 0, "Render Quality Options" );
		QToolButton * renderqualb = new QToolButton(this);
		renderqualb->setIcon(renderIcon);
		renderqualb->setTextLabel("Render Quality Options");
		renderqualb->setMenu(renderinqualMenu);
		renderqualb->setPopupMode(QToolButton::MenuButtonPopup);

	//===============================================================================================
    /*QToolButton * filtertb = new QToolButton(renderIcon, "filter", QString::null, this, SLOT(minibutton_filter_event()), 0, "Filter" );
	filtertb->setTextLabel("Filter");
	filtertb->setToggleButton(false);

    QToolButton * labeltb = new QToolButton(toggleIcon, "label", QString::null, this, SLOT(minibutton_label_event()), 0, "Label" );
	labeltb->setTextLabel("Label");
	labeltb->setToggleButton(false);

    QToolButton * vertfindertb = new QToolButton(renderIcon, "vertfinder", QString::null, this, SLOT(minibutton_vertfinder_event()), 0, "VertFinder" );
	vertfindertb->setTextLabel("VertFinder");
	vertfindertb->setToggleButton(false);*/
	
	QPixmap emptyIcon = QPixmap( "Icons/empty.png" );

    QToolButton * vertfindertb = new QToolButton(emptyIcon, "label", QString::null, this, SLOT(minibutton_vertfinder_event()), 0, "VertFinder" );
	vertfindertb->setTextLabel("VertFinder");
	vertfindertb->setToggleButton(false);
    QToolButton * labeltb = new QToolButton(emptyIcon, "label", QString::null, this, SLOT(minibutton_label_event()), 0, "Label" );
	labeltb->setTextLabel("Label");
	labeltb->setToggleButton(false);
	//===============================================================================================
		
    QToolBar* buttonTools = new QToolBar("ToolBar", this);
	buttonTools->setLabel( "Buttons Menu" );
	buttonTools->setIconSize(QSize(24,24));
	buttonTools->setMovable(true);
	buttonTools->setOrientation(Qt::Vertical);
	buttonTools->setToolButtonStyle(Qt::ToolButtonIconOnly); //Qt::ToolButtonIconOnly

	buttonTools->addSeparator();
	buttonTools->addWidget(intentb);
	buttonTools->addWidget(redtb);
	buttonTools->addWidget(greentb);
	buttonTools->addWidget(bluetb);
	buttonTools->addWidget(surfacestb);
	buttonTools->addSeparator();
	buttonTools->addWidget(miptb);
	buttonTools->addWidget(bgtb);
	buttonTools->addWidget(threeDb);
    buttonTools->addSeparator();
	//buttonTools->addWidget(filtertb);
	//buttonTools->addWidget(labeltb);
    
	buttonTools->addWidget(vertfindertb);
	buttonTools->addWidget(labeltb);
	buttonTools->addSeparator();

	buttonTools->addWidget(renderqualb);
	buttonTools->addWidget(viewb);
	buttonTools->addWidget(toggleb);
	buttonTools->addSeparator();

	addToolBar(Qt::LeftToolBarArea, buttonTools);

	//==================================================
		QPixmap loadIcon = QPixmap( "Icons/load.png" );
		QToolButton * loadb = new QToolButton(this);
		loadb->setIcon(loadIcon);
//		= new QToolButton( loadIcon, "load", QString::null,
//				   this, SLOT(), 0, "Load Menu..." );
		loadb->setTextLabel("Load data...");
		loadb->setMenu(openMenu);
		loadb->setPopupMode(QToolButton::MenuButtonPopup);

		//-------------------------------------------------------

		QPixmap saveIcon = QPixmap( "Icons/save.png" );
		QToolButton * saveb  = new QToolButton(this);
//		= new QToolButton( saveIcon, "save", QString::null,
//				   this, SLOT(), 0, "Save Menu..." );
		saveb->setIcon(saveIcon);
		saveb->setTextLabel("Save data...");
		saveb->setMenu(saveMenu);
		saveb->setPopupMode(QToolButton::MenuButtonPopup);

		//-------------------------------------------------------

		QPixmap viewprefIcon = QPixmap( "Icons/spanner.png" );
		QToolButton * viewpref
		= new QToolButton( viewprefIcon, "Render Settings", QString::null,
				   this, SLOT(viewpref_event()), 0, "Render Settings" );
		viewpref->setTextLabel("Render Settings");

		//-------------------------------------------------------

		QPixmap isosurfIcon = QPixmap( "Icons/surface.png" );
		QToolButton * isosurf
		= new QToolButton( isosurfIcon, "Surfaces", QString::null,
				   this, SLOT(volume_editor_event()), 0, "Surfaces" );
		isosurf->setTextLabel("Surfaces");

		//-------------------------------------------------------

		QPixmap clippingIcon = QPixmap( "Icons/cut.png" );
		QToolButton * clipping = new QToolButton( clippingIcon, "Clipping Planes", QString::null, 
												  this, SLOT(transform_editor_event()), 0, "Clipping Planes" );
		clipping->setTextLabel("Clipping Planes");
	
		//-------------------------------------------------------

		QPixmap tfuncIcon = QPixmap( "Icons/function.png" );
		QToolButton * tfunc
		= new QToolButton( tfuncIcon, "Transfer Functions", QString::null,
				   this, SLOT(transfer_editor_event()), 0, "Transfer Functions" );
		tfunc->setTextLabel("Transfer Functions");

		//-------------------------------------------------------

		QPixmap lightprefIcon = QPixmap( "Icons/light.png" );
		QToolButton * lightpref
		= new QToolButton( lightprefIcon, "Light & Shading", QString::null,
				   this, SLOT(lightpref_event()), 0, "Light/Shader Settings" );

		lightpref->setTextLabel("Light & Shading");

		//-------------------------------------------------------

		QPixmap movieprefIcon = QPixmap( "Icons/movie.png" );
		QToolButton * moviepref
		= new QToolButton( movieprefIcon , "Movie Output", QString::null,
				   this, SLOT(moviepref_event()), 0, "movie Preferences" );

		moviepref->setTextLabel("Movie Output");

		//-------------------------------------------------------

		QPixmap measureprefIcon = QPixmap( "Icons/ruler.png" );
		QToolButton * measurepref
		= new QToolButton( measureprefIcon , "Measure", QString::null,
				   this, SLOT(measurepref_event()), 0, "Measuring Tool" );

		measurepref->setTextLabel("Measure");
	
		//-------------------------------------------------------

		QPixmap filterprefIcon = QPixmap( "Icons/filter.png" );
		QToolButton * filterpref
		= new QToolButton( filterprefIcon , "Filters", QString::null,
				   this, SLOT(filterpref_event()), 0, "Filter Tool" );

		filterpref->setTextLabel("Filter");
		

		QPixmap cropprefIcon = QPixmap( "Icons/crop.png" );
		QToolButton * croppref
		= new QToolButton( cropprefIcon, "Crop", QString::null,
				   this, SLOT(croppref_event()), 0, "Crop Tool" );

		filterpref->setTextLabel("Crop");
                //-------------------------------------------------------
                //-------------------------------------------------------
               /* QPixmap tfunctionIcon = QPixmap( "icons/simple/function.png" );
                QToolButton * tfunctionpref
                = new QToolButton( tfunctionIcon , "Measure", QString::null,
                                   this, SLOT(tfunction_event()), 0, "TransferFunction" );

                tfunctionpref->setTextLabel("Tfunc");*/
                //-------------------------------------------------------
                //-------------------------------------------------------

    QToolBar* fileTools = new QToolBar("File Menu", this);
	fileTools->setLabel( "File Menu" );
	fileTools->setIconSize(QSize(48,48));
	fileTools->setMovable(true);
	fileTools->setToolButtonStyle(Qt::ToolButtonIconOnly);
	fileTools->addSeparator();
	fileTools->addWidget(loadb);
	fileTools->addWidget(saveb);
	fileTools->addSeparator();
    
    QToolBar* prefTools = new QToolBar("Tools Menu", this);
	prefTools->setLabel( "Tools Menu" );
	prefTools->setIconSize(QSize(48,48));
	prefTools->setMovable(true);
	prefTools->setToolButtonStyle(Qt::ToolButtonIconOnly);
	prefTools->addSeparator();
	prefTools->addWidget(tfunc);
	prefTools->addSeparator();
	prefTools->addWidget(croppref);
	prefTools->addSeparator();
	prefTools->addWidget(clipping);
	prefTools->addSeparator();
	prefTools->addWidget(measurepref);
	prefTools->addSeparator();
	prefTools->addWidget(isosurf);
	prefTools->addSeparator();
	prefTools->addWidget(filterpref);
	prefTools->addSeparator();
	
    QToolBar* settingsTools = new QToolBar("Settings Menu", this);
	settingsTools->setLabel( "Settings Menu" );
	settingsTools->setIconSize(QSize(48,48));
	settingsTools->setMovable(true);
	settingsTools->setToolButtonStyle(Qt::ToolButtonIconOnly);
	settingsTools->addSeparator();
	settingsTools->addWidget(moviepref);
	settingsTools->addSeparator();
	settingsTools->addWidget(lightpref);
	settingsTools->addSeparator();
	settingsTools->addWidget(viewpref);
	settingsTools->addSeparator();
    /*settingsTools->addWidget(tfunctionpref);
    settingsTools->addSeparator();*/

	addToolBar(Qt::TopToolBarArea, fileTools);
	addToolBar(Qt::TopToolBarArea, prefTools);
	addToolBar(Qt::TopToolBarArea, settingsTools);

	/*
	QPixmap logoIcon = QPixmap( "icons/biooptonics_logo.png" );
    QToolButton * logo
	= new QToolButton( logoIcon, "", QString::null,
			   this, SLOT(), fileTools, "" );
	*/


	// -------------------------------------------------------------------------
	// create our EDITOR TAB dialogues,
	// -------------------------------------------------------------------------
	transferfunction_editor_tabdlg	= new QtTransferFunctionEditorDialogue(this, "QtTransferFunction", false);	
	volume_editor_tabdlg			= new QtVolumeEditorDialogue(this, "QtVolumeEditor", false);
	clipping_editor_tabdlg			= new QtClippingEditorDialogue(this, "QtClippingEditor", false);
	view_editor_tabdlg				= new QtViewEditorDialogue(this, "QtViewEditor", false);
	light_editor_tabdlg				= new QtLightEditorDialogue(this, "QtLightEditor", false);
	stereo_editor_tabdlg			= new QtStereoEditorDialogue(this, "QtStereoEditor", false);
	movie_editor_tabdlg				= new QtMovieEditorDialogue(this, "QtMovieEditor", false);
	measure_editor_tabdlg			= new QtMeasuringEditorDialogue(this, "QtMeasureEditor", false);
	filter_editor_tabdlg			= new QtFilterEditorDialogue(this, "QtFilterEditor", false);
	crop_editor_tabdlg				= new QtCropEditorDialogue(this, "QtCropEditor", false);

	channel_editor_tabdlg = new QtChannelEditorDialogue(this, "QtChannelEditor", false);
	qtnetworkclient = new QtNetworkClient();

    transferfunc16bit_dialogue = new QtTransferFuncDialogue(this, "QtTransferFuncDialogue", false);

	glwindow->glvoxel->volrender.editor = transferfunction_editor_tabdlg;

	// -------------------------------------------------------------------------
	//INFO dialogue box
	// -------------------------------------------------------------------------
	info_dlg = new QDialog ( this, "Info", 0, 0);
	filename_lb = new QLabel( "Filename: ", info_dlg );
	cursor_lb = new QLabel( "Position: x=0 y=0 z=0 \t Colour: r=0 g=0 b=0", info_dlg );
	resolution_lb = new QLabel( "Resolution: ", info_dlg );
	datatype_lb = new QLabel( "Data Type: ", info_dlg );
	QLabel* empty_lb = new QLabel( "", info_dlg );
	QLabel* cursorname_lb = new QLabel( "Cursor (Texture Space):", info_dlg );
        Q3BoxLayout* blayout_main = new Q3BoxLayout(info_dlg, Q3BoxLayout::TopToBottom, 10, 0);
        blayout_main->addWidget( filename_lb, 1 );
        blayout_main->addWidget( datatype_lb, 1 );
        blayout_main->addWidget( resolution_lb, 1 );
        blayout_main->addWidget( empty_lb, 1 );
        blayout_main->addWidget( empty_lb, 1 );
        blayout_main->addWidget( cursorname_lb, 1 );
        blayout_main->addWidget( cursor_lb, 1 );

	// -------------------------------------------------------------------------
	//connect our SIGNALS and SLOTS between our widgets
	// -------------------------------------------------------------------------
	connect_signals_and_slots();

	// load our settings.ini file
	//load_inifile();

/*	
	//do we have a default filename to load?
	if(!default_filename.isEmpty())
	{
		glwindow->glvoxel->argc_mode = 1;
		glwindow->glvoxel->volobject.file_name = default_filename;		
	}
*/
	glwindow->glvoxel->redraw_event();
	// -------------------------------------------------------------------------
}

QtMainWindow::~QtMainWindow()
{
}

void QtMainWindow::connect_signals_and_slots(void)
{
	//printf("connect_signals_and_slots\n");

	// -------------------------------------------------------------------------
	//THIS
	// -------------------------------------------------------------------------
	connect(this, SIGNAL(measure_setscale2_signal(float,float,float)), 		measure_editor_tabdlg->measuring_tab, SLOT(measure_setscale2_slot(float,float,float)));
	connect(this, SIGNAL(measure_setrescale_signal(float,float,float)), 	measure_editor_tabdlg->measuring_tab, SLOT(measure_setrescale_slot(float,float,float)));
	connect(this, SIGNAL(measure_setspacing_signal(float,float,float)), 	measure_editor_tabdlg->measuring_tab, SLOT(measure_setspacing_slot(float,float,float)));
	connect(this, SIGNAL(measure_setoriginalfn_signal(QString)), 			measure_editor_tabdlg->measuring_tab, SLOT(measure_setoriginalfn_slot(QString)));
	
//**************************************************************************************************************************************************
    connect(this, SIGNAL(tfunc_16bit_histogram_signal(double*, double*)), 	transferfunc16bit_dialogue->tranfer_func_tab, SLOT(tfunc_16bit_histogram_slot(double*, double*)));
//**************************************************************************************************************************************************

	connect(this, SIGNAL(currentworkingdir_signal(QString)), 				measure_editor_tabdlg->measuring_tab, SLOT(measure_setcurrentworkingdir_slot(QString)));
	connect(this, SIGNAL(currentworkingdir_signal(QString)), 				volume_editor_tabdlg->isosurface_tab, SLOT(isosurface_setcurrentworkingdir_slot(QString)));
	connect(this, SIGNAL(currentworkingdir_signal(QString)), 				transferfunction_editor_tabdlg->tranfer_function_tab->hist, SLOT(hist_setcurrentworkingdir_slot(QString)));
	connect(this, SIGNAL(currentworkingdir_signal(QString)), 				clipping_editor_tabdlg->cliptab, SLOT(cutplane_setcurrentworkingdir_slot(QString)));
	connect(this, SIGNAL(currentworkingdir_signal(QString)), 				glwindow->glvoxel, SLOT(setcurrentworkingdir_slot(QString)));

//**************************************************************************************************************************************************
//	connect(this, SIGNAL(currentworkingdir_signal(QString)), 				transferfunc16bit_dialogue->tranfer_func_tab->histogrampixmap_luminance, SLOT(hist16_setcurrentworkingdir_slot(QString)));
//	connect(this, SIGNAL(currentworkingdir_signal(QString)), 				transferfunc16bit_dialogue->tranfer_func_tab->histogrampixmap_opacity, SLOT(hist16_setcurrentworkingdir_slot(QString)));
	connect(this, SIGNAL(currentworkingdir_signal(QString)), 				transferfunc16bit_dialogue->tranfer_func_tab, SLOT(tfunc16_setcurrentworkingdir_slot(QString)));
//**************************************************************************************************************************************************
	
	//VOLIO
	QObject::connect(glwindow->glvoxel->volio.watcher, SIGNAL(finished()), this, SLOT(uploadTextureSlot()));

	// -------------------------------------------------------------------------
	//Transform editor signals
	// -------------------------------------------------------------------------
	connect(clipping_editor_tabdlg->cliptab, SIGNAL(cutplane_redclip_signal(void)),			glwindow->glvoxel, SLOT(cutplane_redclip_slot(void)));
	connect(clipping_editor_tabdlg->cliptab, SIGNAL(cutplane_blueclip_signal(void)),			glwindow->glvoxel, SLOT(cutplane_blueclip_slot(void)));
	connect(clipping_editor_tabdlg->cliptab, SIGNAL(cutplane_greenclip_signal(void)),			glwindow->glvoxel, SLOT(cutplane_greenclip_slot(void)));
	connect(clipping_editor_tabdlg->cliptab, SIGNAL(cutplane_isoclip_signal(void)),			glwindow->glvoxel, SLOT(cutplane_isoclip_slot(void)));
	connect(clipping_editor_tabdlg->cliptab, SIGNAL(cutplane_resetall_signal(void)), 			glwindow->glvoxel, SLOT(cutplane_resetall_slot(void)));
	connect(clipping_editor_tabdlg->cliptab, SIGNAL(cutplane_resetcurrent_signal(void)), 		glwindow->glvoxel, SLOT(cutplane_resetcurrent_slot(void)));
	connect(clipping_editor_tabdlg->cliptab, SIGNAL(cutplane_invert_signal(int)), 				glwindow->glvoxel, SLOT(cutplane_invert_slot(int)));
	connect(clipping_editor_tabdlg->cliptab, SIGNAL(cutplane_showall_signal(int)), 			glwindow->glvoxel, SLOT(cutplane_showall_slot(int)));
	connect(clipping_editor_tabdlg->cliptab, SIGNAL(cutplane_load_signal(QString)), 			glwindow->glvoxel, SLOT(cutplane_load_slot(QString)));
	connect(clipping_editor_tabdlg->cliptab, SIGNAL(cutplane_save_signal(QString)), 			glwindow->glvoxel, SLOT(cutplane_save_slot(QString)));
	connect(clipping_editor_tabdlg->cliptab, SIGNAL(cutplane_realign_signal(void)), 			glwindow->glvoxel, SLOT(cutplane_realign_slot(void)));
	connect(clipping_editor_tabdlg->cliptab, SIGNAL(cutplane_invcrop_signal(void)), 			glwindow->glvoxel, SLOT(cutplane_invcrop_slot(void)));
	connect(clipping_editor_tabdlg->cliptab, SIGNAL(cutplane_recentre_signal(void)), 			glwindow->glvoxel, SLOT(cutplane_recentre_slot(void)));
	connect(clipping_editor_tabdlg->cliptab, SIGNAL(cutplane_crop_signal(void)), 				glwindow->glvoxel, SLOT(cutplane_crop_slot(void)));
	connect(clipping_editor_tabdlg->cliptab, SIGNAL(cutplane_interact_clicked_signal(int)),	glwindow->glvoxel, SLOT(cutplane_interact_clicked_slot(int)));
	connect(clipping_editor_tabdlg->cliptab, SIGNAL(cutplane_unselect_signal(void)), 			glwindow->glvoxel, SLOT(cutplane_unselect_slot(void)));
	connect(clipping_editor_tabdlg->cliptab, SIGNAL(cutplane_rendermode_signal(int)), 			glwindow->glvoxel, SLOT(cutplane_rendermode_slot(int)));
	connect(clipping_editor_tabdlg->cliptab, SIGNAL(cutplane_selected_signal(int)), 			glwindow->glvoxel, SLOT(cutplane_selected_slot(int)));
	connect(clipping_editor_tabdlg->cliptab, SIGNAL(cutplane_applyall_drawmode_signal(void)),	glwindow->glvoxel, SLOT(cutplane_applyall_drawmode_slot(void)));

	// -------------------------------------------------------------------------
	//Volume editor signals
	// -------------------------------------------------------------------------
	connect(volume_editor_tabdlg->isosurface_tab, SIGNAL(isosurface_new_signal(QString , int , int , int, Vector, bool*, int )), 			 glwindow->glvoxel, SLOT(isosurface_new_slot(QString , int , int , int , Vector, bool*, int ))); 
	connect(volume_editor_tabdlg->isosurface_tab, SIGNAL(isosurface_get_signal(QString , int* , int* , int* , Vector*, int*, int*, int* )),  glwindow->glvoxel, SLOT(isosurface_get_slot(QString , int* , int* ,int* ,  Vector*, int*, int*, int* ))); 
	connect(volume_editor_tabdlg->isosurface_tab, SIGNAL(isosurface_del_signal(QString )), 													 glwindow->glvoxel, SLOT(isosurface_del_slot(QString ))); 
	connect(volume_editor_tabdlg->isosurface_tab, SIGNAL(isosurface_update_signal(QString, QString , int , int, int , Vector, bool*, int )), glwindow->glvoxel, SLOT(isosurface_update_slot(QString, QString , int, int , int , Vector, bool*, int ))); 
	connect(volume_editor_tabdlg->isosurface_tab, SIGNAL(isosurface_load_signal(QString)),													 glwindow->glvoxel, SLOT(isosurface_load_slot(QString)));
	connect(volume_editor_tabdlg->isosurface_tab, SIGNAL(isosurface_save_signal(void)), 													 glwindow->glvoxel, SLOT(isosurface_save_slot(void)));	
	connect(volume_editor_tabdlg->isosurface_tab, SIGNAL(isosurface_crop_signal(int)), 													 glwindow->glvoxel, SLOT(isosurface_crop_slot(int)));	

	// -------------------------------------------------------------------------
	// View Editor
	// -------------------------------------------------------------------------
	connect(view_editor_tabdlg->rendersettings_tab, SIGNAL(rendersettings_framebuffer_lod_signal(int)),				glwindow->glvoxel, SLOT(rendersettings_framebuffer_lod_slot(int)) );
	connect(view_editor_tabdlg->rendersettings_tab, SIGNAL(rendersettings_framebuffer_signal(int)), 				glwindow->glvoxel, SLOT(rendersettings_framebuffer_slot(int)) );
	connect(view_editor_tabdlg->rendersettings_tab, SIGNAL(rendersettings_postprocess_signal(int)), 				glwindow->glvoxel, SLOT(rendersettings_postprocess_slot(int)) );
	connect(view_editor_tabdlg->rendersettings_tab, SIGNAL(rendersettings_silhouettes_signal(int)), 				glwindow->glvoxel, SLOT(rendersettings_silhouettes_slot(int)) );
	connect(view_editor_tabdlg->rendersettings_tab, SIGNAL(rendersettings_channelmode_signal(int,int,int,int)),		glwindow->glvoxel, SLOT(rendersettings_channelmode_slot(int,int,int,int)) );
	connect(view_editor_tabdlg->rendersettings_tab, SIGNAL(rendersettings_numbslices_signal(int)), 					glwindow->glvoxel, SLOT(rendersettings_numbslices_slot(int)) );
	connect(view_editor_tabdlg->rendersettings_tab, SIGNAL(rendersettings_numbsliceslod_signal(int)), 				glwindow->glvoxel, SLOT(rendersettings_numbsliceslod_slot(int)) );
	connect(view_editor_tabdlg->rendersettings_tab, SIGNAL(rendersettings_numbsliceslodtoggle_signal(int)), 		glwindow->glvoxel, SLOT(rendersettings_numbsliceslodtoggle_slot(int)) );
	connect(view_editor_tabdlg->rendersettings_tab, SIGNAL(rendersettings_framebuffertoggle_signal(int)), 			glwindow->glvoxel, SLOT(rendersettings_framebuffertoggle_slot(int)) );
	connect(view_editor_tabdlg->rendersettings_tab, SIGNAL(rendersettings_postprocesstoggle_signal(int)), 			glwindow->glvoxel, SLOT(rendersettings_postprocesstoggle_slot(int)) );
	connect(view_editor_tabdlg->rendersettings_tab, SIGNAL(rendersettings_maxtexturesize_signal(int)), 				glwindow->glvoxel, SLOT(rendersettings_maxtexturesize_slot(int)) );
	connect(view_editor_tabdlg->rendersettings_tab, SIGNAL(rendersettings_renderquality_signal(float)), 			glwindow->glvoxel, SLOT(rendersettings_renderquality_slot(float)) );
	connect(view_editor_tabdlg->rendersettings_tab, SIGNAL(rendersettings_renderqualitylod_signal(float)), 			glwindow->glvoxel, SLOT(rendersettings_renderqualitylod_slot(float)) );

	// -------------------------------------------------------------------------
	// Lighting Editor
	// -------------------------------------------------------------------------
	connect(light_editor_tabdlg->lightettings_tab, SIGNAL(light_azimuth_signal(float)), 										glwindow->glvoxel, SLOT(light_azimuth_slot(float)) );
	connect(light_editor_tabdlg->lightettings_tab, SIGNAL(light_altitude_signal(float)), 										glwindow->glvoxel, SLOT(light_altitude_slot(float)) );
	connect(light_editor_tabdlg->lightettings_tab, SIGNAL(light_colour_signal(Vector,Vector,Vector)), 							glwindow->glvoxel, SLOT(light_colour_slot(Vector,Vector,Vector)) );
	connect(light_editor_tabdlg->lightettings_tab, SIGNAL(light_volshader_signal(int)), 										glwindow->glvoxel, SLOT(light_volshader_slot(int)) );
	connect(light_editor_tabdlg->lightettings_tab, SIGNAL(light_gooch_lighting_signal(Vector, Vector, int, int, int, int)), 	glwindow->glvoxel, SLOT(light_gooch_lighting_slot(Vector, Vector, int, int, int, int)) );

	// -------------------------------------------------------------------------
	// Stereo Editor
	// -------------------------------------------------------------------------
	connect(stereo_editor_tabdlg->stereosettings_tab, SIGNAL(stereo_onoff_signal(int)), 		glwindow->glvoxel, SLOT(stereo_onoff_slot(int)) );
	connect(stereo_editor_tabdlg->stereosettings_tab, SIGNAL(stereo_rendermode_signal(int)), 	glwindow->glvoxel, SLOT(stereo_rendermode_slot(int)) );
	connect(stereo_editor_tabdlg->stereosettings_tab, SIGNAL(stereo_seperation_signal(float)), 	glwindow->glvoxel, SLOT(stereo_seperation_slot(float)) );

	// -------------------------------------------------------------------------
	// Measure Editor
	// -------------------------------------------------------------------------
	connect(measure_editor_tabdlg->measuring_tab, SIGNAL(measure_start_signal(void)),								glwindow->glvoxel, SLOT(measure_start_slot(void)) );
	connect(measure_editor_tabdlg->measuring_tab, SIGNAL(measure_stop_signal(void)),								glwindow->glvoxel, SLOT(measure_stop_slot(void)) );
	connect(measure_editor_tabdlg->measuring_tab, SIGNAL(measure_edit_signal(void)),								glwindow->glvoxel, SLOT(measure_edit_slot(void)) );
	//connect(measure_editor_tabdlg->measuring_tab, SIGNAL(measure_stopedit_signal(void)),							glwindow->glvoxel, SLOT(measure_stopedit_slot(void)) );
	connect(measure_editor_tabdlg->measuring_tab, SIGNAL(measure_add_item_signal(vector< Vector >, int)), 			glwindow->glvoxel, SLOT(measure_add_item_slot(vector< Vector >, int)) );
	connect(measure_editor_tabdlg->measuring_tab, SIGNAL(measure_update_item_signal(int, vector< Vector >, int)),	glwindow->glvoxel, SLOT(measure_update_item_slot(int, vector< Vector >, int)) );
	connect(measure_editor_tabdlg->measuring_tab, SIGNAL(measure_delete_item_signal(int)),							glwindow->glvoxel, SLOT(measure_delete_item_slot(int)) );
	connect(measure_editor_tabdlg->measuring_tab, SIGNAL(measure_update_current_signal(int)),						glwindow->glvoxel, SLOT(measure_update_current_slot(int)) );
	connect(measure_editor_tabdlg->measuring_tab, SIGNAL(measure_update_current_drawmode_signal(int)), 				glwindow->glvoxel, SLOT(measure_update_current_drawmode_slot(int)));
	connect(measure_editor_tabdlg->measuring_tab, SIGNAL(measure_pause_signal(void)),								glwindow->glvoxel, SLOT(measure_pause_slot(void)));
	connect(measure_editor_tabdlg->measuring_tab, SIGNAL(measure_selected_vertindex_signal(int)),					glwindow->glvoxel, SLOT(measure_selected_vertindex_slot(int)));
	connect(measure_editor_tabdlg->measuring_tab, SIGNAL(measure_update_current_verts_signal(vector<Vector>)),		glwindow->glvoxel, SLOT(measure_update_current_verts_slot(vector<Vector>)));
	connect(measure_editor_tabdlg->measuring_tab, SIGNAL(measure_setscale_signal(float, float, float)), 			this,			   SLOT(measure_setscale_slot(float, float, float)));
	connect(measure_editor_tabdlg->measuring_tab, SIGNAL(measure_setcutplane_signal(int, float, float, float)),		glwindow->glvoxel, SLOT(measure_setcutplane_slot(int, float, float, float)));
	connect(measure_editor_tabdlg->measuring_tab, SIGNAL(measure_enableunselect_signal(void)),		clipping_editor_tabdlg->cliptab,   SLOT(measure_enableunselect_slot(void)));
	connect(measure_editor_tabdlg->measuring_tab, SIGNAL(measure_disableunselect_signal(void)),		clipping_editor_tabdlg->cliptab,   SLOT(measure_disableunselect_slot(void)));
	connect(measure_editor_tabdlg->measuring_tab, SIGNAL(measure_setcutplane_signal(int, float, float, float)),		clipping_editor_tabdlg->cliptab, SLOT(measure_setcutplane_slot(int, float, float, float)));
	connect(measure_editor_tabdlg->measuring_tab, SIGNAL(measure_clearall_signal(void)),							glwindow->glvoxel, SLOT(measure_clearall_slot(void)));
	connect(measure_editor_tabdlg->measuring_tab, SIGNAL(measure_cancel_signal(void)),								glwindow->glvoxel, SLOT(measure_cancel_slot(void)));
	connect(measure_editor_tabdlg->measuring_tab, SIGNAL(measure_rmv_current_verts_signal(int)),					glwindow->glvoxel, SLOT(measure_rmv_current_verts_slot(int)));
	connect(measure_editor_tabdlg->measuring_tab, SIGNAL(measure_update_visible_signal(int, bool)),					glwindow->glvoxel, SLOT(measure_update_visible_slot(int, bool)));
	connect(measure_editor_tabdlg->measuring_tab, SIGNAL(cutplane_resetall_signal(void)), 							glwindow->glvoxel, SLOT(cutplane_resetall_slot(void)));
	connect(measure_editor_tabdlg->measuring_tab, SIGNAL(cutplane_solid_signal(bool)), 								glwindow->glvoxel, SLOT(cutplane_solid_slot(bool)));

	connect(measure_editor_tabdlg->measuring_tab, SIGNAL(measure_load_item_signal(vector< Vector >, vector< Edge >, int)), glwindow->glvoxel, SLOT(measure_load_item_slot(vector< Vector >, vector< Edge >, int)));
	connect(measure_editor_tabdlg->measuring_tab, SIGNAL(measure_modify_start_signal(void)), glwindow->glvoxel, SLOT(measure_modify_start_slot(void)));
	connect(measure_editor_tabdlg->measuring_tab, SIGNAL(measure_modify_stop_signal(void)), glwindow->glvoxel, SLOT(measure_modify_stop_slot(void)));
	
	connect(measure_editor_tabdlg->measuring_tab, SIGNAL(measure_labels_signal(int, int, int)), glwindow->glvoxel, SLOT(measure_labels_slot(int, int, int)));
	
	// -------------------------------------------------------------------------
	// Movie Editor
	// -------------------------------------------------------------------------
	connect(movie_editor_tabdlg->moviesettings_tab, SIGNAL(movie_orthosectmovie_signal(QWidget*, int, int, QString)), 										glwindow->glvoxel, SLOT(movie_orthosectmovie_slot(QWidget*, int, int, QString)));

	connect(movie_editor_tabdlg->moviesettings_tab, SIGNAL(movie_rockmovie_signal(QWidget*, int, int, QString, float)), 						glwindow->glvoxel, SLOT(movie_rockmovie_slot(QWidget*, int, int, QString, float)));
	connect(movie_editor_tabdlg->moviesettings_tab, SIGNAL(movie_rotmovie_signal(QWidget*, int, int, QString, int, int, int, float)), 						glwindow->glvoxel, SLOT(movie_rotmovie_slot(QWidget*, int, int, QString, int, int, int, float)));
	connect(movie_editor_tabdlg->moviesettings_tab, SIGNAL(movie_fademovie_signal(QWidget*, int, int, QString, int, int, int, float, int, int, int)), 		glwindow->glvoxel, SLOT(movie_fademovie_slot(QWidget*, int, int, QString, int, int, int, float, int, int, int)));
	connect(movie_editor_tabdlg->moviesettings_tab, SIGNAL(movie_clipmovie_signal(QWidget*, int, int, QString, int, int, int, float, int, int)), 			glwindow->glvoxel, SLOT(movie_clipmovie_slot(QWidget*, int, int, QString, int, int, int, float, int, int)));
	connect(movie_editor_tabdlg->moviesettings_tab, SIGNAL(movie_crossfademovie_signal(QWidget*, int, int, QString, int, int, int, float, int, int, int)), 	glwindow->glvoxel, SLOT(movie_crossfademovie_slot(QWidget*, int, int, QString, int, int, int, float, int, int, int)));
	
	// -------------------------------------------------------------------------
	//Filter editor
	// -------------------------------------------------------------------------
	connect(filter_editor_tabdlg->filtertab, SIGNAL(filter_signal(int, int, double, int, vector<bool>)),			glwindow->glvoxel,	SLOT(filter_slot(int, int, double, int, vector<bool>)));
	
	// -------------------------------------------------------------------------
	//SliceFrame image
	// -------------------------------------------------------------------------
	connect(glwindow->xylb, SIGNAL(sliceframe_pixel_signal(int,int,int,int,int,int,int,int,int,int)),			glwindow->glvoxel,	SLOT(sliceframe_pixelXY_slot(int,int,int,int,int,int,int,int,int,int)));
	connect(glwindow->xzlb, SIGNAL(sliceframe_pixel_signal(int,int,int,int,int,int,int,int,int,int)),			glwindow->glvoxel,	SLOT(sliceframe_pixelXZ_slot(int,int,int,int,int,int,int,int,int,int)));
	connect(glwindow->yzlb, SIGNAL(sliceframe_pixel_signal(int,int,int,int,int,int,int,int,int,int)),			glwindow->glvoxel,	SLOT(sliceframe_pixelYZ_slot(int,int,int,int,int,int,int,int,int,int)));
	connect(glwindow->xylb, SIGNAL(sliceframe_pixel_signal(int,int,int,int,int,int,int,int,int,int)), 			this, 				SLOT(sliceframe_pixelXY_slot(int,int,int,int,int,int,int,int,int,int)));
	connect(glwindow->xzlb, SIGNAL(sliceframe_pixel_signal(int,int,int,int,int,int,int,int,int,int)), 			this, 				SLOT(sliceframe_pixelXZ_slot(int,int,int,int,int,int,int,int,int,int)));
	connect(glwindow->yzlb, SIGNAL(sliceframe_pixel_signal(int,int,int,int,int,int,int,int,int,int)), 			this, 				SLOT(sliceframe_pixelYZ_slot(int,int,int,int,int,int,int,int,int,int)));	
	connect(glwindow->xylb, SIGNAL(sliceframe_selected_signal(int)), 											glwindow->xzlb, 	SLOT(sliceframe_selected_slot(int)));
	connect(glwindow->xylb, SIGNAL(sliceframe_selected_signal(int)),											glwindow->yzlb, 	SLOT(sliceframe_selected_slot(int)));
	connect(glwindow->xzlb, SIGNAL(sliceframe_selected_signal(int)),											glwindow->xylb, 	SLOT(sliceframe_selected_slot(int)));
	connect(glwindow->xzlb, SIGNAL(sliceframe_selected_signal(int)),											glwindow->yzlb, 	SLOT(sliceframe_selected_slot(int)));
	connect(glwindow->yzlb, SIGNAL(sliceframe_selected_signal(int)),											glwindow->xzlb, 	SLOT(sliceframe_selected_slot(int)));
	connect(glwindow->yzlb, SIGNAL(sliceframe_selected_signal(int)),											glwindow->xylb, 	SLOT(sliceframe_selected_slot(int)));

	// -------------------------------------------------------------------------
	//Transfer Function Editor
	// -------------------------------------------------------------------------
	connect(transferfunction_editor_tabdlg->tranfer_function_tab,		SIGNAL(tfunc_rebuild_histogram_signal()),										glwindow->glvoxel, SLOT(tfunc_rebuild_histogram_slot()));	
	connect(transferfunction_editor_tabdlg->tranfer_function_tab,		SIGNAL(tfunc_histequ_signal(int, int)), 										glwindow->glvoxel, SLOT(tfunc_histequ_slot(int, int)));	
	connect(transferfunction_editor_tabdlg->tranfer_function_tab,		SIGNAL(tfunc_contstrat_signal(int, int)), 										glwindow->glvoxel, SLOT(tfunc_contstrat_slot(int, int)));	
	connect(transferfunction_editor_tabdlg->tranfer_function_tab, 		SIGNAL(tfunc_brightcontrast_signal(int, int, int)), 							glwindow->glvoxel, SLOT(tfunc_brightcontrast_shader_slot(int, int, int)));
 	connect(transferfunction_editor_tabdlg->tranfer_function_tab,		SIGNAL(tfunc_threshold_signal(int, int, int)), 									glwindow->glvoxel, SLOT(tfunc_threshold_shader_slot(int, int, int)));
 	connect(transferfunction_editor_tabdlg->tranfer_function_tab,		SIGNAL(tfunc_invert_signal(int, int)), 											glwindow->glvoxel, SLOT(tfunc_invert_slot(int, int)));
 	connect(transferfunction_editor_tabdlg->tranfer_function_tab,		SIGNAL(tfunc_slider_released_signal(void)), 									glwindow->glvoxel, SLOT(tfunc_slider_released_slot(void)));
 	connect(transferfunction_editor_tabdlg->tranfer_function_tab,		SIGNAL(tfunc_histoupdate_signal(int)), 											glwindow->glvoxel, SLOT(tfunc_histoupdate_slot(int)));
 	connect(transferfunction_editor_tabdlg->tranfer_function_tab,		SIGNAL(tfunc_collapse_signal(void)), 											glwindow->glvoxel, SLOT(tfunc_collapse_slot(void)));

 	connect(transferfunction_editor_tabdlg->tranfer_function_tab,		SIGNAL(tfunc_convertR_signal(void)), 											glwindow->glvoxel, SLOT(tfunc_convertR_slot(void)));
 	connect(transferfunction_editor_tabdlg->tranfer_function_tab,		SIGNAL(tfunc_convertG_signal(void)), 											glwindow->glvoxel, SLOT(tfunc_convertG_slot(void)));
 	connect(transferfunction_editor_tabdlg->tranfer_function_tab,		SIGNAL(tfunc_convertB_signal(void)), 											glwindow->glvoxel, SLOT(tfunc_convertB_slot(void)));
	
	// 	connect(transferfunction_editor_tabdlg->tranfer_function_tab,		SIGNAL(tfunc_remap16bit_signal(int, int)), 										glwindow->glvoxel, SLOT(tfunc_remap16bit_slot(int, int)));

//**************************************************************************************************************************************************
	connect(transferfunc16bit_dialogue->tranfer_func_tab, 		SIGNAL(tfunc_brightcontrast_signal(int, int, int)), glwindow->glvoxel, SLOT(tfunc_brightcontrast_shader_slot(int, int, int)));
	
 	connect(transferfunc16bit_dialogue->tranfer_func_tab, SIGNAL(tfunc_remap16bit_signal(int, int, const vector<Vector>&, int, int, const vector<Vector>&)), glwindow->glvoxel, SLOT(tfunc_remap16bit_slot(int, int, const vector<Vector>&, int, int, const vector<Vector>&)));
	
 	connect(transferfunc16bit_dialogue->tranfer_func_tab,		SIGNAL(tfunc_invert_signal(int, int)), 				glwindow->glvoxel, SLOT(tfunc_invert_slot(int, int)));
	
//**************************************************************************************************************************************************
	// -------------------------------------------------------------------------
	//Crop Editor
	// -------------------------------------------------------------------------
	connect(crop_editor_tabdlg->croptab, SIGNAL(crop_start_signal(void)), glwindow->glvoxel, SLOT(crop_start_slot(void)));
	connect(crop_editor_tabdlg->croptab, SIGNAL(crop_end_signal(void)),  glwindow->glvoxel, SLOT(crop_end_slot(void)));
	connect(crop_editor_tabdlg->croptab, SIGNAL(crop_recentre_signal(void)),  glwindow->glvoxel, SLOT(cutplane_recentre_slot(void)));
	connect(crop_editor_tabdlg->croptab, SIGNAL(crop_invsel_signal(int)),  glwindow->glvoxel, SLOT(crop_invsel_slot(int)));
	connect(crop_editor_tabdlg->croptab, SIGNAL(crop_reset_signal(void)),  glwindow->glvoxel, SLOT(crop_reset_slot(void)));

	// -------------------------------------------------------------------------
	//Histogram Widget
	// -------------------------------------------------------------------------
	connect(transferfunction_editor_tabdlg->tranfer_function_tab->hist, SIGNAL(hist_tfunc_signal(const vector<Vector>&, float, float, int, int)), glwindow->glvoxel, SLOT(hist_tfunc_slot(const vector<Vector>&, float, float, int, int)));
	connect(transferfunction_editor_tabdlg->tranfer_function_tab->hist, SIGNAL(hist_transfer_function_all_signal(const vector<Vector>&, const vector<Vector>&, const vector<Vector>&, const vector<Vector>&, const vector<Vector>&, const vector<Vector>&, float, float)), glwindow->glvoxel, SLOT(hist_transfer_function_all_slot(const vector<Vector>&, const vector<Vector>&, const vector<Vector>&, const vector<Vector>&, const vector<Vector>&, const vector<Vector>&,float, float)));
	connect(transferfunction_editor_tabdlg->tranfer_function_tab->hist, SIGNAL(hist_reset_transfer_function_parameters_signal(int, int, int, int,int, int, int, int, int, int,int, int, int, int, int, int,int, int, int, int, int, int,int, int, bool, bool, bool, bool, bool, bool)), glwindow->glvoxel, SLOT(hist_reset_transfer_function_parameters_slot(int, int, int, int,int, int, int, int, int, int,int, int, int, int, int, int,int, int, int, int, int, int,int, int, bool, bool, bool, bool, bool, bool)));

	connect(transferfunction_editor_tabdlg->tranfer_function_tab->hist, SIGNAL(hist_redraw_signal(void)), glwindow->glvoxel, SLOT(redraw_event(void)));
	
	// -------------------------------------------------------------------------
	// OME Network Client
	// -------------------------------------------------------------------------
	connect(qtnetworkclient, SIGNAL(ome_allocate_memory_signal(int, int, int, int, int)), 	this, SLOT(ome_allocate_memory_slot(int, int, int, int, int)));
	connect(qtnetworkclient, SIGNAL(ome_finished_signal(void)), 							this, SLOT(ome_finished_slot(void)));
	connect(qtnetworkclient, SIGNAL(ome_load_signal(int, QPixmap)), 						this, SLOT(ome_loadPixmap_slot(int, QPixmap)));

	// -------------------------------------------------------------------------
	// GLWidget
	// -------------------------------------------------------------------------
	connect(glwindow->glvoxel, SIGNAL(arc_mode_signal(void)), 						this, SLOT(arc_mode_slot(void)));
	connect(glwindow->glvoxel, SIGNAL(frames_redraw_signal(void)), 					glwindow, SLOT(frames_redraw_slot(void)));
	connect(glwindow->glvoxel, SIGNAL(dragndrop_signal(QString)), 					this, SLOT(dragndrop_slot(QString)));
	connect(glwindow->glvoxel, SIGNAL(isosurface_addnew_signal(QString, Vector)),	volume_editor_tabdlg->isosurface_tab, SLOT(addnew_event(QString, Vector)));
	connect(glwindow->glvoxel, SIGNAL(single_channel_signal(void)), 				this, SLOT(single_channel_slot(void)));
	
	connect(glwindow->glvoxel, SIGNAL(measure_point_signal(Vector)),				measure_editor_tabdlg->measuring_tab, SLOT(measure_point_slot(Vector)));
	connect(glwindow->glvoxel, SIGNAL(measure_editpoint_signal(Vector)),			measure_editor_tabdlg->measuring_tab, SLOT(measure_editpoint_slot(Vector)));
	connect(glwindow->glvoxel, SIGNAL(measure_editpoint_select_signal(int)),		measure_editor_tabdlg->measuring_tab, SLOT(measure_editpoint_select_slot(int)));
	connect(glwindow->glvoxel, SIGNAL(measure_savecutplane_signal(int, float, float, float)),		measure_editor_tabdlg->measuring_tab, SLOT(measure_savecutplane_slot(int, float, float, float)));
	connect(glwindow->glvoxel, SIGNAL(measure_close_signal(void)),					measure_editor_tabdlg->measuring_tab, SLOT(measure_close_slot( void)));
	connect(glwindow->glvoxel, SIGNAL(measure_clearcurrent_signal(void)),					measure_editor_tabdlg->measuring_tab, SLOT(measure_clearcurrent_slot( void)));
	connect(glwindow->glvoxel, SIGNAL(measure_edges_signal(vector<Edge>)),					measure_editor_tabdlg->measuring_tab, SLOT(measure_edges_slot(vector<Edge>)));
	connect(glwindow->glvoxel, SIGNAL(measure_update_edges_signal(int, vector<Edge>)),					measure_editor_tabdlg->measuring_tab, SLOT(measure_update_edges_slot(int, vector<Edge>)));
	connect(glwindow->glvoxel, SIGNAL(measure_editgrppoint_signal(int, Vector)),					measure_editor_tabdlg->measuring_tab, SLOT(measure_editgrppoint_slot(int, Vector)));
	connect(glwindow->glvoxel, SIGNAL(measure_currentedges_signal(vector<Edge>)),					measure_editor_tabdlg->measuring_tab, SLOT(measure_currentedges_slot(vector<Edge>)));

	connect(glwindow->glvoxel, SIGNAL(measure_currentverts_signal(vector<Vector>)),					measure_editor_tabdlg->measuring_tab, SLOT(measure_currentverts_slot(vector<Vector>)));
		
	connect(glwindow->glvoxel, SIGNAL(cutplane_unselect_signal(void)),				clipping_editor_tabdlg->cliptab, SLOT(cutplane_unselect_slot(void)));
	connect(glwindow->glvoxel, SIGNAL(cutplane_selectedupdate_signal(int,int)),		clipping_editor_tabdlg->cliptab, SLOT(cutplane_selectedupdate_slot(int,int)));
	connect(glwindow->glvoxel, SIGNAL(cutplane_selected_signal(int,int)),			clipping_editor_tabdlg->cliptab, SLOT(cutplane_selected_slot(int,int)));
	connect(glwindow->glvoxel, SIGNAL(cutplane_enableplanepanel_signal(void)),		clipping_editor_tabdlg->cliptab, SLOT(cutplane_enableplanepanel_slot(void)));
	//connect(glwindow->glvoxel, SIGNAL(openImageDir_signal(QString)),				clipping_editor_tabdlg->cliptab, SLOT(openImageDir(QString)));
	connect(glwindow->glvoxel, SIGNAL(save_sectionimage_signal(QString, int, int)),	glwindow, SLOT(save_sectionimage_slot(QString, int, int)));
	connect(glwindow->glvoxel, SIGNAL(timelapseEvent(void)),	this, SLOT(timelapseEvent(void)));

	connect(glwindow->glvoxel, SIGNAL(update_channels_signal(void)),	this, SLOT(update_channels_slot(void)));
	connect(glwindow->glvoxel, SIGNAL(updatestatus_cursor_signal(void)),	this, SLOT(updatestatus_cursor_slot(void)));
	
	
	
//**************************************************************************************************************************************************
	connect(glwindow->glvoxel, SIGNAL(tfunc_16bit_histogram_signal(double*, double*)), 	transferfunc16bit_dialogue->tranfer_func_tab, SLOT(tfunc_16bit_histogram_slot(double*, double*)));
//**************************************************************************************************************************************************
	
	connect(glwindow->glvoxel, SIGNAL(tfunc_histogram_signal(double*)), 	transferfunction_editor_tabdlg->tranfer_function_tab, SLOT(tfunc_histogram_slot(double*)));
	
	// -------------------------------------------------------------------------
	// QFilesystemwatcher
	// -------------------------------------------------------------------------
        connect(qfilesystemwatcher, SIGNAL(fileChanged(QString)), this, SLOT(fileChanged(QString)));
}
void QtMainWindow::fileChanged(QString fn)
{
	load_inifile();
}
void QtMainWindow::updatestatus_cursor_slot(void)
{
	printf("BOH\n");

	int r,g,b;

	int x = glwindow->glvoxel->volrender.cursor3D_texturespace.x;
	int y = glwindow->glvoxel->volrender.cursor3D_texturespace.x;
	int z = glwindow->glvoxel->volrender.cursor3D_texturespace.x;

	if(x>=glwindow->glvoxel->volobject.texwidth)  x=glwindow->glvoxel->volobject.texwidth-1;
	if(y>=glwindow->glvoxel->volobject.texheight) y=glwindow->glvoxel->volobject.texheight-1;
	if(z>=glwindow->glvoxel->volobject.texdepth)  z=glwindow->glvoxel->volobject.texdepth-1;

	int index_3D;
	index_3D = 3*((((z*glwindow->glvoxel->volobject.texheight)+y)*glwindow->glvoxel->volobject.texwidth)+x);
	
	r = glwindow->glvoxel->volobject.texture3d[index_3D+0];
	g = glwindow->glvoxel->volobject.texture3d[index_3D+1];
	b = glwindow->glvoxel->volobject.texture3d[index_3D+2];

	QString s;
	QString text;

	text = "cursor: [x:";
	s.setNum((int)glwindow->glvoxel->volrender.cursor3D_texturespace.x);
	text += s;
	text += " y:";
	s.setNum((int)glwindow->glvoxel->volrender.cursor3D_texturespace.y);
	text += s;
	text += " z:";
	s.setNum((int)glwindow->glvoxel->volrender.cursor3D_texturespace.z);
	text += s;
	text += "][ r:";
	s.setNum(r);
	text += s;
	text += " g:";
	s.setNum(g);
	text += s;
	text += " b:";
	s.setNum(b);
	text += s;
	text += "] ";

	cursor_lb->setText(text);
	
	glwindow->cursor_label->setText(text);
	
	emit frames_redraw_signal();
}
void QtMainWindow::sliceframe_pixelXY_slot(int x,int y,int z,int r,int g,int b, int mouse_x,int mouse_y, int width, int height)
{
	int volx, voly, volz;

	mouse_x = width-mouse_x;

	voly = ((float)mouse_y/(float)height)  * (float)glwindow->glvoxel->volobject.texwidth;
	volx = ((float)mouse_x/(float)width)  * (float)glwindow->glvoxel->volobject.texheight;
	volz = z;
	QString s;
	QString text;

	text = "cursor: [x:";
	s.setNum(glwindow->glvoxel->volrender.cursor3D_texturespace.x);
	text += s;
	text += " y:";
	s.setNum(glwindow->glvoxel->volrender.cursor3D_texturespace.y);
	text += s;
	text += " z:";
	s.setNum(glwindow->glvoxel->volrender.cursor3D_texturespace.z);
	text += s;
	text += "][ r:";
	s.setNum(r);
	text += s;
	text += " g:";
	s.setNum(g);
	text += s;
	text += " b:";
	s.setNum(b);
	text += s;
	text += "] ";

	cursor_lb->setText(text);
	
	glwindow->cursor_label->setText(text);
	
	emit frames_redraw_signal();
}
void QtMainWindow::sliceframe_pixelXZ_slot(int x,int y,int z,int r,int g,int b, int mouse_x,int mouse_y, int width, int height)
{
	int volx, voly, volz;

	volx = ((float)mouse_x/(float)width)  * (float)glwindow->glvoxel->volobject.texwidth;
	voly = y;
	volz = ((float)mouse_y/(float)height) * (float)glwindow->glvoxel->volobject.texdepth;

	QString s;
	QString text;

	text = "cursor: [x:";
	s.setNum(glwindow->glvoxel->volrender.cursor3D_texturespace.x);
	text += s;
	text += " y:";
	s.setNum(glwindow->glvoxel->volrender.cursor3D_texturespace.y);
	text += s;
	text += " z:";
	s.setNum(glwindow->glvoxel->volrender.cursor3D_texturespace.z);
	text += s;
	text += "][ r:";
	s.setNum(r);
	text += s;
	text += " g:";
	s.setNum(g);
	text += s;
	text += " b:";
	s.setNum(b);
	text += s;
	text += "] ";

	cursor_lb->setText(text);
	glwindow->cursor_label->setText(text);
		
	emit frames_redraw_signal();
}
void QtMainWindow::sliceframe_pixelYZ_slot(int x,int y,int z,int r,int g,int b, int mouse_x,int mouse_y, int width, int height)
{
	int volx, voly, volz;

	volx = x;
	voly = ((float)mouse_x/(float)width)  * (float)glwindow->glvoxel->volobject.texheight;
	volz = ((float)mouse_y/(float)height) * (float)glwindow->glvoxel->volobject.texdepth;

	QString s;
	QString text;
		
	text = "cursor: [x:";
	s.setNum(glwindow->glvoxel->volrender.cursor3D_texturespace.x);
	text += s;
	text += " y:";
	s.setNum(glwindow->glvoxel->volrender.cursor3D_texturespace.y);
	text += s;
	text += " z:";
	s.setNum(glwindow->glvoxel->volrender.cursor3D_texturespace.z);
	text += s;
	text += "][ r:";
	s.setNum(r);
	text += s;
	text += " g:";
	s.setNum(g);
	text += s;
	text += " b:";
	s.setNum(b);
	text += s;
	text += "] ";

	cursor_lb->setText(text);
	glwindow->cursor_label->setText(text);
	
	emit frames_redraw_signal();
}
void QtMainWindow::render0_event()
{
/*    render_mode->setItemChecked( render0_id, TRUE );
    render_mode->setItemChecked( render1_id, FALSE );
    render_mode->setItemChecked( render2_id, FALSE );
*/
	glwindow->glvoxel->volrender.volume_render_mode = 1;
	glwindow->glvoxel->volrender.load_TextureMap();
	view_editor_tabdlg->rebuild_tabs();
	glwindow->glvoxel->update();
	glwindow->glvoxel->redraw_event();
	update();
}

void QtMainWindow::render1_event()
{
/*    render_mode->setItemChecked( render0_id, FALSE );
    render_mode->setItemChecked( render1_id, TRUE );
    render_mode->setItemChecked( render2_id, FALSE );
*/
	glwindow->glvoxel->volrender.volume_render_mode = 5;
	glwindow->glvoxel->volrender.load_TextureMap();
	view_editor_tabdlg->rebuild_tabs();
	glwindow->glvoxel->update();
	glwindow->glvoxel->redraw_event();
	update();
}
void QtMainWindow::render2_event()
{
/*    render_mode->setItemChecked( render0_id, FALSE);
    render_mode->setItemChecked( render1_id, FALSE);
    render_mode->setItemChecked( render2_id, TRUE);
*/
	glwindow->glvoxel->volrender.volume_render_mode = 2;
	glwindow->glvoxel->volrender.load_TextureMap();
	view_editor_tabdlg->rebuild_tabs();
	glwindow->glvoxel->update();
	glwindow->glvoxel->redraw_event();
	update();
}
void QtMainWindow::render3_event()
{
 /*   render_mode->setItemChecked( render0_id, FALSE);
    render_mode->setItemChecked( render1_id, FALSE);
    render_mode->setItemChecked( render2_id, TRUE);
*/
	//pick_numb_bricks();

	glwindow->glvoxel->volrender.volume_render_mode = 4;
	glwindow->glvoxel->volrender.load_TextureMap();
	glwindow->glvoxel->update();
	glwindow->glvoxel->redraw_event();
	update();
}

void QtMainWindow::blend_mode1_event()
{
 /*   blend->setItemChecked( blend_id, TRUE );
    blend->setItemChecked( max_blend_id, FALSE );
    blend->setItemChecked( min_blend_id, FALSE );
*/
	glwindow->glvoxel->volrender.blend_mode(1);
	glwindow->glvoxel->update();
	glwindow->glvoxel->redraw_event();
	update();
}
void QtMainWindow::blend_mode2_event()
{
  /*  blend->setItemChecked( blend_id, FALSE );
    blend->setItemChecked( max_blend_id, TRUE );
    blend->setItemChecked( min_blend_id, FALSE );
*/
	glwindow->glvoxel->volrender.blend_mode(2);
	glwindow->glvoxel->update();
	glwindow->glvoxel->redraw_event();
	update();
}
void QtMainWindow::blend_mode3_event()
{
 /*   blend->setItemChecked( blend_id, FALSE );
    blend->setItemChecked( max_blend_id, FALSE );
    blend->setItemChecked( min_blend_id, TRUE );
*/
	glwindow->glvoxel->volrender.blend_mode(3);
	glwindow->glvoxel->update();
	glwindow->glvoxel->redraw_event();
	update();
}
void QtMainWindow::blend_mode4_event()
{
	/* 
		blend->setItemChecked( blend_id, FALSE );
		blend->setItemChecked( max_blend_id, FALSE );
		blend->setItemChecked( min_blend_id, FALSE );
		blend->setItemChecked( atten_blend_id, TRUE );
	*/

	glwindow->glvoxel->volrender.blend_mode(4);
	glwindow->glvoxel->update();
	glwindow->glvoxel->redraw_event();
	update();
}
void QtMainWindow::toggle_scalebar_event(void)
{
	//toggle our scalebar
	glwindow->glvoxel->volrender.scalebar_toggle = !glwindow->glvoxel->volrender.scalebar_toggle;

	glwindow->glvoxel->redraw_event();
	update();
}
void QtMainWindow::togglemoveLOD_event(void)
{
	/*
	glwindow->glvoxel->moveLOD_toggle = !glwindow->glvoxel->moveLOD_toggle;

	if(glwindow->glvoxel->moveLOD_toggle) view->setItemChecked( movelod_id, TRUE );
	else view->setItemChecked( movelod_id, FALSE);
	glwindow->glvoxel->update();
	glwindow->glvoxel->redraw_event();
	update();
	*/
}
void QtMainWindow::openImageR_event(void)
{
	channel_mode = 1;
	channel_dlg->close(1);
}
void QtMainWindow::openImageG_event(void)
{
	channel_mode = 2;
	channel_dlg->close(1);
}
void QtMainWindow::openImageB_event(void)
{
	channel_mode = 3;
	channel_dlg->close(1);
}
void QtMainWindow::openImageRGBA_event(void)
{
	channel_mode = 4;
	channel_dlg->close();
}
void QtMainWindow::openImageI_event(void)
{
	channel_mode = 5;
	channel_dlg->close(1);
}
void QtMainWindow::openImagechannelmsgbox_event()
{
	channel_dlg = new QDialog(this, Qt::WindowTitleHint | Qt::WindowSystemMenuHint |  Qt::WindowStaysOnTopHint);
	channel_dlg->setModal(true);
	channel_dlg->setWindowTitle("Select Channel Mode");

	Q3BoxLayout* channel_layout = new Q3BoxLayout(channel_dlg, Q3BoxLayout::LeftToRight, 4, 4, "channel_layout");
	QPushButton *rgba = new QPushButton("RGBA", channel_dlg);
	QPushButton *r	  = new QPushButton("R",	channel_dlg);
	QPushButton *g	  = new QPushButton("G",	channel_dlg);
	QPushButton *b	  = new QPushButton("B",	channel_dlg);

	connect(r,		SIGNAL(clicked()), SLOT(openImageR_event()));
	connect(g,		SIGNAL(clicked()), SLOT(openImageG_event()));
	connect(b,		SIGNAL(clicked()), SLOT(openImageB_event()));
	connect(rgba,		SIGNAL(clicked()), SLOT(openImageRGBA_event()));

	channel_layout->addWidget(rgba, 1);
	channel_layout->addWidget(r, 1);
	channel_layout->addWidget(g, 1);
	channel_layout->addWidget(b, 1);

	//updateStatusBar();

	channel_dlg->exec();
	glwindow->glvoxel->update();
	update();
}
void QtMainWindow::update_info_labels(void)
{
	QString fn = "Filename: ";
	fn += glwindow->glvoxel->volobject.file_name;
	filename_lb->setText(fn);

	QString s;
	QString text;
	text = "Resolution: ";
	s.setNum(glwindow->glvoxel->volobject.texwidth);
	text += s;
	text += "x";
	s.setNum(glwindow->glvoxel->volobject.texheight);
	text += s;
	text += "x";
	s.setNum(glwindow->glvoxel->volobject.texdepth);
	text += s;
	resolution_lb->setText(text);

	datatype_lb->setText("Data Type: UCHAR");

	cursor_lb->setText("Position: x=0 y=0 z=0 \t Colour: r=0 g=0 b=0");
}
void QtMainWindow::openChannelEditor_event(void)
{
	channel_editor_tabdlg->show();
}
void QtMainWindow::openOME_event(void)
{
	qtnetworkclient->show();
}
void QtMainWindow::ome_allocate_memory_slot(int x, int y, int z, int c, int t)
{
	printf("alloc OME\n");
	
	//set up our texture info
	glwindow->glvoxel->volobject.width = glwindow->glvoxel->volobject.texwidth = x;
	glwindow->glvoxel->volobject.height = glwindow->glvoxel->volobject.texheight = y;
	glwindow->glvoxel->volobject.depth = glwindow->glvoxel->volobject.texdepth = z; 

	int size = x*y*z*3;

	if(glwindow->glvoxel->volobject.texture3d) delete[] glwindow->glvoxel->volobject.texture3d;
	glwindow->glvoxel->volobject.texture3d = NULL;

	//lets have some memory for our texture data
	glwindow->glvoxel->volobject.texture3d = (GLubyte *) malloc(size * sizeof(GLubyte));

	//initialise everything to zero
	for(int ii=0; ii<size; ii++) glwindow->glvoxel->volobject.texture3d[ii] = 0;
}
void QtMainWindow::ome_loadPixmap_slot(int index, QPixmap pixmap)
{
	//printf("load pixmap OME\n");
	
	int index1D, r, g, b;

	QImage img = pixmap.toImage();

	//printf("%d\n", index);

	//printf("%d x %d @ %d\n", pixmap.width(), pixmap.height(), index);

	for(int x=0; x<img.width(); x++)
	{
		for(int y=0; y<img.height(); y++)
		{
				QRgb pixel = img.pixel(int(x),int(y));
				index1D = (((((index)*img.height())+(y))*img.width())+(x));

				r = qRed(pixel);
				g = qGreen(pixel);
				b = qBlue(pixel);

				//printf("%d, %d, %d\n", r,g,b);
	
				glwindow->glvoxel->volobject.texture3d[3*index1D+0] = GLubyte(r);
				glwindow->glvoxel->volobject.texture3d[3*index1D+1] = GLubyte(g); 
				glwindow->glvoxel->volobject.texture3d[3*index1D+2] = GLubyte(b); 
				glwindow->glvoxel->volobject.histogram[(3*int(r))+0]++;
				glwindow->glvoxel->volobject.histogram[(3*int(g))+1]++;
				glwindow->glvoxel->volobject.histogram[(3*int(b))+2]++;
		}
	}
}
void QtMainWindow::ome_finished_slot(void)
{
	printf("finished OME\n");

	//update our histogram
	glwindow->glvoxel->mcubes.clear();
	
	glwindow->glvoxel->mcubes.clear();
	volume_editor_tabdlg->isosurface_tab->del_all();	

	//load our data to opengl
	glwindow->glvoxel->volrender.load_TextureMap();

	//save a copy of original data
//	glwindow->glvoxel->undo_volobject = glwindow->glvoxel->sourceobject = glwindow->glvoxel->volobject;

	view_editor_tabdlg->rebuild_tabs();

	//setup our slice arrays and slice sliders
	glwindow->create();
}
void QtMainWindow::update_channels_slot(void)
{
		intentb->setOn(true);
		if(glwindow->glvoxel->volobject.has_red==true)
		{
			glwindow->glvoxel->volrender.r_channel = true;
			redtb->setOn(true);
			transferfunction_editor_tabdlg->tranfer_function_tab->red_pb->setEnabled(true);
		}
		else
		{
			glwindow->glvoxel->volrender.r_channel = false;
			redtb->setOn(false);
			transferfunction_editor_tabdlg->tranfer_function_tab->red_pb->setEnabled(false);
		}

		if(glwindow->glvoxel->volobject.has_green==true)
		{
			glwindow->glvoxel->volrender.g_channel = true;
			greentb->setOn(true);
			transferfunction_editor_tabdlg->tranfer_function_tab->green_pb->setEnabled(true);
		}
		else
		{
			glwindow->glvoxel->volrender.g_channel = false;
			greentb->setOn(false);
			transferfunction_editor_tabdlg->tranfer_function_tab->green_pb->setEnabled(false);
		}

		if(glwindow->glvoxel->volobject.has_blue==true)
		{
			glwindow->glvoxel->volrender.b_channel = true;
			bluetb->setOn(true);
			transferfunction_editor_tabdlg->tranfer_function_tab->blue_pb->setEnabled(true);
		}
		else
		{
			glwindow->glvoxel->volrender.b_channel = false;
			bluetb->setOn(false);
			transferfunction_editor_tabdlg->tranfer_function_tab->blue_pb->setEnabled(false);
		}
}
void QtMainWindow::openTimelapse_event(void)
{
	QFileDialog* fd = new QFileDialog( this );
	fd->setFilter(QDir::Dirs | QDir::NoSymLinks | QDir::NoDotAndDotDot);

	QString dn = fd->getExistingDirectory(this, "Please select a Timelapse Directory", last_working_dir);
	last_working_dir = dn;
	
	QDir tldir = QDir(dn);
	tldir.setFilter(QDir::Dirs | QDir::NoSymLinks | QDir::NoDotAndDotDot);
	timelapsedirs = tldir.entryList();

	if(!timelapsedirs.isEmpty())
	{
		glwindow->glvoxel->volrender.timelapsefolder = 0;

		timelapsehelper=0;
		QString temp = last_working_dir;
		openImageDir(last_working_dir+"/"+timelapsedirs.at(0)+"/");
		last_working_dir = temp;

		glwindow->glvoxel->volrender.timelapsefolder = 1;
	}
}
void QtMainWindow::openImage_event(void)
{		
	Q3FileDialog* fd = new Q3FileDialog( this );
	QString fn = fd->getOpenFileName(last_working_dir, "*.png *.bmp *.jpg *.jpeg *.tif *.tiff", this );
	last_working_dir = fn;

	openImageDir(fn);
}
void QtMainWindow::uploadTextureSlot(void)
{
	glwindow->glvoxel->volrender.load_TextureMap();
}
void QtMainWindow::openImageDir(QString fn)
{
	QString dn = fn;

	//remove the filename of first file to get only dirname
	int pos = dn.findRev(QString("/").latin1(), -1, false);
	dn.replace(pos+1, dn.length()-pos+1, "");

	//QTime t;
	//t.start();

	printf("LOADING: Image Dir: %s\n", dn.latin1());

	//if we actually got something back,
	//then load up the data in that dir
	if ( !dn.isEmpty() )
	{
		glwindow->glvoxel->volobject.file_name = dn;
		glwindow->glvoxel->volobject.file_type = 0;
		last_working_dir = dn;

		emit measure_setoriginalfn_signal(dn);		
		emit currentworkingdir_signal(dn);
		
		if(glwindow->glvoxel->volrender.volume_render_mode!=4)	//NOT BRICKS
		{
			//printf("NOT BRICKS\n");

			if(timelapsehelper==0)
			{
				//choose which channel mode
				openImagechannelmsgbox_event();

				for(int i=0; i<glwindow->glvoxel->volrender.brick_textures.size(); i++)
					glwindow->glvoxel->volrender.brick_textures[i].clear();

				glwindow->glvoxel->volrender.brick_textures.clear();
				glwindow->glvoxel->volrender.brick_centres.clear();
				glwindow->glvoxel->volrender.empty_brick.clear();
			}
			else	
			{
				channel_mode=4;
			}
			//QTime t2;
			//t2.start();
			glwindow->glvoxel->volio.load_PNG(fn, channel_mode);
			//printf("sub-time: %d msec.\n", t2.elapsed());
 
		}
		else		//BRICKS
		{
			//printf("BRICKS\n");
			
			if(glwindow->glvoxel->volobject.texture3d!=0) delete glwindow->glvoxel->volobject.texture3d;
			
			if(timelapsehelper==0)
			{
				//choose which channel mode
				openImagechannelmsgbox_event();

				for(int i=0; i<glwindow->glvoxel->volrender.brick_textures.size(); i++)
					glwindow->glvoxel->volrender.brick_textures[i].clear();
				
				glwindow->glvoxel->volrender.brick_textures.clear();
				glwindow->glvoxel->volrender.brick_centres.clear();
				glwindow->glvoxel->volrender.empty_brick.clear();
			}
			else
			{
				channel_mode=4;
			}

			glwindow->glvoxel->volio.init_subimageloading(dn, channel_mode);
			glwindow->glvoxel->volobject.texture3d = new unsigned char[1*1*1];
		}

		//have we selected something sensible?
		if(channel_mode==0)
		{
 			//statusBar->message("Error Loading, Error with Data!", 4000);	
			printf("ERROR: no channel_mode has been selected!\n");
			return;
		}
		
		update_info_labels();
	}
	else //if we dont have a proper filename, stop
	{
		glwindow->glvoxel->volobject.file_name = "";
		glwindow->glvoxel->volobject.file_type = -1;
		printf("ERROR: filename/directory name is empty!\n");

	    //statusBar->message("Error Loading, No Filename!", 4000);	
		return;
	}

	channel_mode=0;
	Vector res = Vector((glwindow->glvoxel->volobject.xsize/glwindow->glvoxel->volobject.maxsize), (glwindow->glvoxel->volobject.ysize/glwindow->glvoxel->volobject.maxsize), (glwindow->glvoxel->volobject.zsize/glwindow->glvoxel->volobject.maxsize));
	emit measure_setscale2_signal(glwindow->glvoxel->volobject.xscale, glwindow->glvoxel->volobject.yscale, glwindow->glvoxel->volobject.zscale);
	emit measure_setrescale_signal(glwindow->glvoxel->volobject.x_resize, glwindow->glvoxel->volobject.y_resize, glwindow->glvoxel->volobject.z_resize);
	emit measure_setspacing_signal(res.x, res.y, res.z);

	glwindow->glvoxel->volrender.volume_toggle=1;
	glwindow->glvoxel->volrender.r_channel = glwindow->glvoxel->volrender.g_channel = glwindow->glvoxel->volrender.b_channel = 0;
	//if(glwindow->glvoxel->volobject.has_red==1) 
		
	glwindow->glvoxel->volrender.r_channel = glwindow->glvoxel->volobject.has_red;
	glwindow->glvoxel->volrender.g_channel = glwindow->glvoxel->volobject.has_green;
	glwindow->glvoxel->volrender.b_channel = glwindow->glvoxel->volobject.has_blue;
	
	//if(glwindow->glvoxel->volobject.has_green==1) glwindow->glvoxel->volrender.g_channel = 1;
	//if(glwindow->glvoxel->volobject.has_blue==1) glwindow->glvoxel->volrender.b_channel = 1;
	//if(glwindow->glvoxel->volrender.g_channel==1 || glwindow->glvoxel->volrender.b_channel==1) glwindow->glvoxel->volobject.is_greyscale==0;

	/*if(glwindow->glvoxel->volobject.is_greyscale==1)
	{
		transferfunction_editor_tabdlg->tranfer_function_tab->red_pb->setEnabled(false);
		transferfunction_editor_tabdlg->tranfer_function_tab->green_pb->setEnabled(false);
		transferfunction_editor_tabdlg->tranfer_function_tab->blue_pb->setEnabled(false);

		intentb->setOn(true);
		redtb->setOn(false);
		greentb->setOn(false);
		bluetb->setOn(false);
	}
	else
	{*/
		transferfunction_editor_tabdlg->tranfer_function_tab->red_pb->setEnabled(glwindow->glvoxel->volobject.has_red);
		transferfunction_editor_tabdlg->tranfer_function_tab->green_pb->setEnabled(glwindow->glvoxel->volobject.has_green);
		transferfunction_editor_tabdlg->tranfer_function_tab->blue_pb->setEnabled(glwindow->glvoxel->volobject.has_blue);

		intentb->setOn(glwindow->glvoxel->volobject.is_greyscale);
		redtb->setOn(glwindow->glvoxel->volobject.has_red);
		greentb->setOn(glwindow->glvoxel->volobject.has_green);
		bluetb->setOn(glwindow->glvoxel->volobject.has_blue);	
	//}

	//reset our transfer dialogue
	volume_editor_tabdlg->reset();

	//glwindow->glvoxel->mcubes.clear();
	//volume_editor_tabdlg->isosurface_tab->del_all();	

	//update our histogram
	volume_editor_tabdlg->rebuild_tabs();
	view_editor_tabdlg->rebuild_tabs();

	//update how many slices we discretize the volume with
	view_editor_tabdlg->rendersettings_tab->rebuild();

	//load our data to opengl
	glwindow->glvoxel->volrender.load_TextureMap();

//	if(glwindow->glvoxel->volrender.volume_render_mode!=4)
	if(timelapsehelper==0)
	{
		glwindow->glvoxel->volrender.timelapsefoldersize = timelapsedirs.size();

		if(view_orientation==1) front_event();
		else if(view_orientation==2) back_event();
		else if(view_orientation==3) left_event();
		else if(view_orientation==4) right_event();
		else if(view_orientation==5) top_event();
		else if(view_orientation==6) bottom_event();
	}

	//setup our slice arrays and slice sliders
	glwindow->create();
	updateStatusBar();

	if(glwindow->glvoxel->volobject.is16bit)
	{
		transferfunction_editor_tabdlg->hide();
		transferfunction_editor_tabdlg->tranfer_function_tab->resetall_button_action();
		transferfunc16bit_dialogue->tranfer_func_tab->reset();
		emit tfunc_16bit_histogram_signal(&glwindow->glvoxel->volobject.histogram16bit[0], &glwindow->glvoxel->volobject.histogram[0]);
	}
	else
	{
		transferfunc16bit_dialogue->hide();
	}


	glwindow->glvoxel->redraw_event();

	//printf("LOADING: Total Time: %d msec.\n", t.elapsed());
}
void QtMainWindow::openwlz_event(void)
{
	Q3FileDialog* fd = new Q3FileDialog( this );
	//statusBar->message("Loading WLZ Volume...");
	QString fn = fd->getOpenFileName(last_working_dir, "*.wlz", this );

	//remove the filename of first file to get only dirname
	//and save a copy of last working dir
	QString fn2 = fn; 
	int pos = fn2.findRev(QString("/").latin1(), -1, false);
	last_working_dir = fn2.replace(pos+1, fn2.length()-pos+1, "");

	//if we actually got something back,
	//then load up the data in that dir
	if ( !fn.isEmpty() )
	{
		glwindow->glvoxel->volobject.file_name = fn;
		glwindow->glvoxel->volobject.file_type = 2;

		//choose which channel mode
		openImagechannelmsgbox_event();

		//if we have a good channel mode, try loading
//		if(channel_mode!=0) glwindow->glvoxel->volio.load_WLZ(fn, channel_mode);

		//have we selected something sensible?
		if(channel_mode==0)
		{
 			//statusBar->message("Error Loading, Error with Data!", 4000);	
			return;
		}
		
		//all good, let the user know about it.
	    //statusBar->message("Done", 1000);
	    //statusBar->message("Ready", 2000);
		update_info_labels();
	}
	else //got no filename, then stop
	{
		glwindow->glvoxel->volobject.file_name = "";
		glwindow->glvoxel->volobject.file_type = -1;
	    //statusBar->message("Error Loading, No Filename!", 2000);	
		return;
	}

	channel_mode=0;

	glwindow->glvoxel->volrender.r_channel = glwindow->glvoxel->volrender.g_channel = glwindow->glvoxel->volrender.b_channel = false;
	view_editor_tabdlg->rendersettings_tab->r_toggle = view_editor_tabdlg->rendersettings_tab->g_toggle = view_editor_tabdlg->rendersettings_tab->b_toggle = false;
	
	glwindow->glvoxel->volrender.volume_toggle=1;
	glwindow->glvoxel->volrender.r_channel = glwindow->glvoxel->volrender.g_channel = glwindow->glvoxel->volrender.b_channel = false;
	if(glwindow->glvoxel->volio.red==true) glwindow->glvoxel->volrender.r_channel = true;
	if(glwindow->glvoxel->volio.green==true) glwindow->glvoxel->volrender.g_channel = true;
	if(glwindow->glvoxel->volio.blue==true) glwindow->glvoxel->volrender.b_channel = true;

	if(glwindow->glvoxel->volrender.g_channel==true || glwindow->glvoxel->volrender.b_channel==true) glwindow->glvoxel->volobject.is_greyscale==0;

	if(glwindow->glvoxel->volobject.is_greyscale==1)
	{
		transferfunction_editor_tabdlg->tranfer_function_tab->red_pb->setEnabled(false);
		transferfunction_editor_tabdlg->tranfer_function_tab->green_pb->setEnabled(false);
		transferfunction_editor_tabdlg->tranfer_function_tab->blue_pb->setEnabled(false);

		intentb->setOn(true);
		redtb->setOn(false);
		greentb->setOn(false);
		bluetb->setOn(false);
	}
	else
	{
		transferfunction_editor_tabdlg->tranfer_function_tab->red_pb->setEnabled(true);
		transferfunction_editor_tabdlg->tranfer_function_tab->green_pb->setEnabled(true);
		transferfunction_editor_tabdlg->tranfer_function_tab->blue_pb->setEnabled(true);

		intentb->setOn(true);
		redtb->setOn(true);
		greentb->setOn(true);
		bluetb->setOn(true);
	}

	//reset our transfer dialogue
	volume_editor_tabdlg->reset();

	glwindow->glvoxel->mcubes.clear();
	volume_editor_tabdlg->isosurface_tab->del_all();	

	//update our ui
	volume_editor_tabdlg->rebuild_tabs();
	view_editor_tabdlg->rebuild_tabs();

	//load our data to opengl
	glwindow->glvoxel->volrender.load_TextureMap();

	//setup our slice arrays and slice sliders
	glwindow->create();
}

void QtMainWindow::openRawFile(QString fn)
{
	emit measure_setoriginalfn_signal(fn);
	
	//remove the filename of first file to get only dirname
	//and save a copy of last working dir
	QString fn2 = fn; 
	int pos = fn2.findRev(QString("/").latin1(), -1, false);
	last_working_dir = fn2.replace(pos+1, fn2.length()-pos+1, "");
	
	emit currentworkingdir_signal(last_working_dir);

	fn.truncate(fn.length()-3);                            
	fn += "dat";

	//if we actually got something back,
	//then load up the data in that dir
	if ( !fn.isEmpty() )
	{
		glwindow->glvoxel->volobject.file_name = fn;
		glwindow->glvoxel->volobject.file_type = 1;

		//choose which channel mode
		openImagechannelmsgbox_event();

		//if we have a good channel mode, try loading
		if(channel_mode!=0)
		{
			glwindow->glvoxel->volio.load_RAW(fn, channel_mode);
		}

		//have we selected something sensible?
		if(channel_mode==0)
		{
 			//statusBar->message("Error Loading, Error with Data!", 4000);	
			return;
		}

	    //statusBar->message("Done", 1000);
	    //statusBar->message("Ready", 2000);
		update_info_labels();
	}
	else //got no filename, then stop
	{
		glwindow->glvoxel->volobject.file_name = "";
		glwindow->glvoxel->volobject.file_type = -1;
	    //statusBar->message("Error Loading, No Filename!", 2000);	
		return;
	}

	channel_mode=0;

	emit measure_setscale2_signal(glwindow->glvoxel->volobject.xscale, glwindow->glvoxel->volobject.yscale, glwindow->glvoxel->volobject.zscale);
	emit measure_setrescale_signal(glwindow->glvoxel->volobject.x_resize, glwindow->glvoxel->volobject.y_resize, glwindow->glvoxel->volobject.z_resize);

	glwindow->glvoxel->volrender.volume_toggle=1;
	glwindow->glvoxel->volrender.r_channel = glwindow->glvoxel->volrender.g_channel = glwindow->glvoxel->volrender.b_channel = false;
	if(glwindow->glvoxel->volio.red==true) glwindow->glvoxel->volrender.r_channel = true;
	if(glwindow->glvoxel->volio.green==true) glwindow->glvoxel->volrender.g_channel = true;
	if(glwindow->glvoxel->volio.blue==true) glwindow->glvoxel->volrender.b_channel = true;
	
	if(glwindow->glvoxel->volrender.g_channel==true || glwindow->glvoxel->volrender.b_channel==true) glwindow->glvoxel->volobject.is_greyscale==0;

	if(glwindow->glvoxel->volobject.is_greyscale==1)
	{
		transferfunction_editor_tabdlg->tranfer_function_tab->red_pb->setEnabled(false);
		transferfunction_editor_tabdlg->tranfer_function_tab->green_pb->setEnabled(false);
		transferfunction_editor_tabdlg->tranfer_function_tab->blue_pb->setEnabled(false);

		intentb->setOn(true);
		redtb->setOn(false);
		greentb->setOn(false);
		bluetb->setOn(false);
	}
	else
	{
		redtb->setOn(false);
		greentb->setOn(false);
		bluetb->setOn(false);
		transferfunction_editor_tabdlg->tranfer_function_tab->red_pb->setEnabled(false);
		transferfunction_editor_tabdlg->tranfer_function_tab->green_pb->setEnabled(false);
		transferfunction_editor_tabdlg->tranfer_function_tab->blue_pb->setEnabled(false);

		intentb->setOn(true);
		if(glwindow->glvoxel->volrender.r_channel==true)
		{
			transferfunction_editor_tabdlg->tranfer_function_tab->red_pb->setEnabled(true);
			redtb->setOn(true);
		}
		if(glwindow->glvoxel->volrender.g_channel==true)
		{
			transferfunction_editor_tabdlg->tranfer_function_tab->green_pb->setEnabled(true);
			greentb->setOn(true);
		}
		if(glwindow->glvoxel->volrender.b_channel==true)
		{
			transferfunction_editor_tabdlg->tranfer_function_tab->blue_pb->setEnabled(true);
			bluetb->setOn(true);
		}
	}

	float maxsize =  max(glwindow->glvoxel->volobject.xsize, glwindow->glvoxel->volobject.ysize);
	maxsize =  max(maxsize, glwindow->glvoxel->volobject.zsize);
	Vector res = Vector((glwindow->glvoxel->volobject.xsize/maxsize), (glwindow->glvoxel->volobject.ysize/maxsize), (glwindow->glvoxel->volobject.zsize/maxsize));
	emit measure_setspacing_signal(res.x, res.y, res.z);

	//update our histogram
	glwindow->glvoxel->mcubes.clear();
	
	glwindow->glvoxel->mcubes.clear();
	volume_editor_tabdlg->isosurface_tab->del_all();	

	//load our data to opengl
	glwindow->glvoxel->volrender.load_TextureMap();

	if(view_orientation==1) front_event();
	else if(view_orientation==2) back_event();
	else if(view_orientation==3) left_event();
	else if(view_orientation==4) right_event();
	else if(view_orientation==5) top_event();
	else if(view_orientation==6) bottom_event();
	
	//save a copy of original data
//	glwindow->glvoxel->undo_volobject = glwindow->glvoxel->sourceobject = glwindow->glvoxel->volobject;

	view_editor_tabdlg->rebuild_tabs();

	glwindow->glvoxel->volobject.is16bit = false;
	transferfunc16bit_dialogue->hide();

	//setup our slice arrays and slice sliders
	glwindow->create();
	//statusBar->showMessage(glwindow->glvoxel->volobject.file_name, 0);
	updateStatusBar();
}
void QtMainWindow::openraw_event(void)
{
	Q3FileDialog* fd = new Q3FileDialog( this );
	//statusBar->message("Loading RAW Volume...");
	QString fn = fd->getOpenFileName(last_working_dir, "*.dat", this );
	
	openRawFile(fn);
}
void QtMainWindow::togglestereo_event(void)
{
	glwindow->glvoxel->volrender.stereo_toggle = !glwindow->glvoxel->volrender.stereo_toggle;

//    if(glwindow->glvoxel->volrender.stereo_toggle) render->setItemChecked( stereo_id, TRUE );
//	else render->setItemChecked( stereo_id, FALSE);

	glwindow->glvoxel->update();
	glwindow->glvoxel->redraw_event();
	update();

}

void QtMainWindow::togglecursor_event()
{
	glwindow->glvoxel->volrender.cursor_toggle = !glwindow->glvoxel->volrender.cursor_toggle;

 /*   if(glwindow->glvoxel->volrender.cursor_toggle) render->setItemChecked( cursor_id, TRUE );
	else render->setItemChecked( cursor_id, FALSE);
*/
	glwindow->glvoxel->update();
	glwindow->glvoxel->redraw_event();
	update();
}
void QtMainWindow::togglefps_event()
{
	glwindow->glvoxel->volrender.fps_toggle = !glwindow->glvoxel->volrender.fps_toggle;

//    if(glwindow->glvoxel->volrender.fps_toggle) render->setItemChecked( fps_id, TRUE );
//	else render->setItemChecked( fps_id, FALSE);

	glwindow->glvoxel->update();
	glwindow->glvoxel->redraw_event();
	update();
}
void QtMainWindow::togglelights_event(void)
{
	glwindow->glvoxel->volrender.lights_toggle = !glwindow->glvoxel->volrender.lights_toggle;

 /*   if(glwindow->glvoxel->volrender.lights_toggle) render->setItemChecked( lights_id, TRUE );
	else render->setItemChecked( lights_id, FALSE);
*/
	glwindow->glvoxel->update();
	glwindow->glvoxel->redraw_event();
	update();
}

void QtMainWindow::toggleaxis_event(void)
{
	glwindow->glvoxel->volrender.axis_toggle = !glwindow->glvoxel->volrender.axis_toggle;

 /*   if(glwindow->glvoxel->volrender.axis_toggle) render->setItemChecked( axis_id, TRUE );
	else render->setItemChecked( axis_id, FALSE);
*/
	glwindow->glvoxel->update();
	glwindow->glvoxel->redraw_event();
	update();
}

void QtMainWindow::toggleBB_event(void)
{
	glwindow->glvoxel->volrender.BB_toggle = !glwindow->glvoxel->volrender.BB_toggle;

    if(glwindow->glvoxel->volrender.BB_toggle)
	{
		QColorDialog* coldialogue=0;
		glwindow->glvoxel->volrender.bb_colour = coldialogue->getColor(glwindow->glvoxel->volrender.bb_colour, this, "Choose a colour");
	//	render->setItemChecked( bb_id, TRUE );
	}
	//else render->setItemChecked( bb_id, FALSE);

	glwindow->glvoxel->update();
	glwindow->glvoxel->redraw_event();
	update();
}
void QtMainWindow::togglesurfaces_event(void)
{
	glwindow->glvoxel->volrender.isosurface_toggle = !glwindow->glvoxel->volrender.isosurface_toggle;

//    if(glwindow->glvoxel->volrender.isosurface_toggle) render->setItemChecked( surf_id, TRUE );
//	else render->setItemChecked( surf_id, FALSE);

	glwindow->glvoxel->update();
	glwindow->glvoxel->redraw_event();
	update();
}
void QtMainWindow::togglevoxels_event(void)
{
	glwindow->glvoxel->volrender.volume_toggle = !glwindow->glvoxel->volrender.volume_toggle;

 //   if(glwindow->glvoxel->volrender.volume_toggle) render->setItemChecked( vol_id, TRUE );
//	else render->setItemChecked( vol_id, FALSE);

	glwindow->glvoxel->update();
	glwindow->glvoxel->redraw_event();
	update();
}

void QtMainWindow::slicemode0_event(void)
{
 /*   slice->setItemChecked(slicemode0_id, TRUE );
    slice->setItemChecked(slicemode1_id, FALSE );
    slice->setItemChecked(slicemode2_id, FALSE );
    slice->setItemChecked(slicemode3_id, FALSE );
*/
	glwindow->glvoxel->volrender.slice_draw_mode = 0;

	glwindow->xylb->slices = 0;
	glwindow->xzlb->slices = 0;
	glwindow->yzlb->slices = 0;

	glwindow->frames_redraw_slot();
	glwindow->glvoxel->update();
	glwindow->glvoxel->redraw_event();
	update();
}
void QtMainWindow::slicemode1_event(void)
{
 /*   slice->setItemChecked(slicemode0_id, FALSE );
    slice->setItemChecked(slicemode1_id, TRUE );
    slice->setItemChecked(slicemode2_id, FALSE );
    slice->setItemChecked(slicemode3_id, FALSE );
*/
	glwindow->glvoxel->volrender.slice_draw_mode = 1;

	glwindow->xylb->slices = 1;
	glwindow->xzlb->slices = 1;
	glwindow->yzlb->slices = 1;

	glwindow->frames_redraw_slot();
	glwindow->glvoxel->update();
	glwindow->glvoxel->redraw_event();
	update();
}
void QtMainWindow::slicemode2_event(void)
{
  /*  slice->setItemChecked(slicemode0_id, FALSE );
    slice->setItemChecked(slicemode1_id, FALSE );
    slice->setItemChecked(slicemode2_id, TRUE );
    slice->setItemChecked(slicemode3_id, FALSE );
*/
	glwindow->glvoxel->volrender.slice_draw_mode = 2;

	glwindow->xylb->slices = 1;
	glwindow->xzlb->slices = 1;
	glwindow->yzlb->slices = 1;

	glwindow->frames_redraw_slot();
	glwindow->glvoxel->update();
	glwindow->glvoxel->redraw_event();
	update();
}
void QtMainWindow::slicemode3_event(void)
{
/*    slice->setItemChecked(slicemode0_id, FALSE );
    slice->setItemChecked(slicemode1_id, FALSE );
    slice->setItemChecked(slicemode2_id, FALSE );
    slice->setItemChecked(slicemode3_id, TRUE );
*/	
	glwindow->glvoxel->volrender.slice_draw_mode = 3;

	glwindow->xylb->slices = 1;
	glwindow->xzlb->slices = 1;
	glwindow->yzlb->slices = 1;

	glwindow->frames_redraw_slot();
	glwindow->glvoxel->update();
	glwindow->glvoxel->redraw_event();
	update();
}
void QtMainWindow::savetiff_event(void)
{
	QString fn = QFileDialog::getExistingDirectory ( this, "Please pick a save directory.", last_working_dir, QFileDialog::ShowDirsOnly | QFileDialog::DontResolveSymlinks);

	//remove the filename of first file to get only dirname
	//and save a copy of last working dir
	QString fn2 = fn; 
	//int pos = fn2.findRev(QString("/").latin1(), -1, false);
	last_working_dir = fn2 + "/"; //fn2.replace(pos+1, fn2.length()-pos+1, "");
  	
	printf("last_working_dir: %s\n",last_working_dir.latin1());
	//statusBar->message("Saving PNG Volume Slices...", 1000);
  
	if ( !fn.isEmpty() ) 
	{			
		glwindow->glvoxel->volio.save_TIFFstack(fn);
	    //statusBar->message("Done", 1000);
	    //statusBar->message("Ready", 2000);
	}
	else
	{
	    //statusBar->message("Error Saving", 2000);		
	}

	if(glwindow->glvoxel->volobject.texwidth&&glwindow->glvoxel->volobject.texheight&&glwindow->glvoxel->volobject.texdepth==1) return;
	if(glwindow->glvoxel->volobject.texture3d==NULL) return;

	//save a copy of original data
	//glwindow->glvoxel->sourceobject = glwindow->glvoxel->volobject;

	glwindow->glvoxel->update();
	update();
}
void QtMainWindow::savepng_event(void)
{
//	QString fn = Q3FileDialog::getSaveFileName(last_working_dir, "*.png", this );
 
/*	QString fn = QFileDialog::getSaveFileName(this, tr("Open File"),
                                                "/home/jana",
                                                tr("Images (*.png *.xpm *.jpg)"));
*/
	QString fn = QFileDialog::getExistingDirectory ( this, "Please pick a save directory.", last_working_dir, QFileDialog::ShowDirsOnly | QFileDialog::DontResolveSymlinks);

	//remove the filename of first file to get only dirname
	//and save a copy of last working dir
	QString fn2 = fn; 
	//int pos = fn2.findRev(QString("/").latin1(), -1, false);
	last_working_dir = fn2 + "/"; //fn2.replace(pos+1, fn2.length()-pos+1, "");
  	
	printf("last_working_dir: %s\n",last_working_dir.latin1());
	//statusBar->message("Saving PNG Volume Slices...", 1000);
  
	if ( !fn.isEmpty() ) 
	{			
		glwindow->glvoxel->volio.save_PNG(fn);
	    //statusBar->message("Done", 1000);
	    //statusBar->message("Ready", 2000);
	}
	else
	{
	    //statusBar->message("Error Saving", 2000);		
	}

	if(glwindow->glvoxel->volobject.texwidth&&glwindow->glvoxel->volobject.texheight&&glwindow->glvoxel->volobject.texdepth==1) return;
	if(glwindow->glvoxel->volobject.texture3d==NULL) return;

	//save a copy of original data
	//glwindow->glvoxel->sourceobject = glwindow->glvoxel->volobject;

	glwindow->glvoxel->update();
	update();
}

void QtMainWindow::saveraw_event(void)
{
	QString fn = Q3FileDialog::getSaveFileName(last_working_dir, "*.dat", this );
  	
	//remove the filename of first file to get only dirname
	//and save a copy of last working dir
	QString fn2 = fn; 
	int pos = fn2.findRev(QString("/").latin1(), -1, false);
	last_working_dir = fn2.replace(pos+1, fn2.length()-pos+1, "");

	//statusBar->message("Saving RAW Volume...", 1000);
  
	if ( !fn.isEmpty() ) 
	{			
		glwindow->glvoxel->volio.save_RAW(fn);	     
	    //statusBar->message("Done", 1000);
	    //statusBar->message("Ready", 2000);
	}
	else
	{
	    //statusBar->message("Error Saving", 2000);		
	}

	if(glwindow->glvoxel->volobject.texwidth&&glwindow->glvoxel->volobject.texheight&&glwindow->glvoxel->volobject.texdepth==1) return;
	if(glwindow->glvoxel->volobject.texture3d==NULL) return;

	//save a copy of original data
	//glwindow->glvoxel->sourceobject = glwindow->glvoxel->volobject;

	glwindow->glvoxel->update();
	update();
}
void QtMainWindow::saveobj_event(void)
{	
	QDir qdir("");
	QString dirstring = qdir.filePath("Data");
	QString fn = Q3FileDialog::getSaveFileName(dirstring, "*.obj", this );
  	
	//statusBar->message("Saving OBJ Surface...", 1000);
  
	if ( !fn.isEmpty() ) 
	{	
		glwindow->glvoxel->volio.save_OBJ(fn);	     
	    //statusBar->message("Done", 1000);
	    //statusBar->message("Ready", 2000);
	}
	else
	{
	    //statusBar->message("Error Saving", 2000);		
	}

	glwindow->glvoxel->update();
	update();
}

void QtMainWindow::saveImage_event(void)
{
 	//set rendering of off, 
	//we want all those precious cpu cycles	
	QString fn = Q3FileDialog::getSaveFileName(last_working_dir, "*.png", this );
  
	//remove the filename of first file to get only dirname
	//and save a copy of last working dir
	QString fn2 = fn; 
	int pos = fn2.findRev(QString("/").latin1(), -1, false);
	last_working_dir = fn2.replace(pos+1, fn2.length()-pos+1, "");

	//statusBar->message("Saving PNG image...", 1000);
  
	if ( !fn.isEmpty() ) 
	{	
		saveImagemsgbox_event();

		if(image_mode==0) 
		{
			//statusBar->message("Error Saving", 2000);
			return;
		}
		else
		{
			glwindow->saveimageEvent(fn, image_mode);
					
			//statusBar->message("Done", 1000);
			//statusBar->message("Ready", 2000);
		}
	}
	else
	{
	    //statusBar->message("Error Saving", 2000);
		return;
	}

	glwindow->glvoxel->update();
	update();
}
void QtMainWindow::saveImagemsgbox_event()
{
    image_dlg = new QDialog(this, "Choose Slice", TRUE);
	image_dlg->setModal(true);

	Q3BoxLayout* image_layout	= new Q3BoxLayout(image_dlg, Q3BoxLayout::LeftToRight, 4, 4, "image_layout");
	QPushButton *ren			= new QPushButton("RENDERING",	image_dlg);
	QPushButton *xy				= new QPushButton("XY",	image_dlg);
	QPushButton *xz				= new QPushButton("XZ",	image_dlg);
	QPushButton *yz				= new QPushButton("YZ",	image_dlg);

	connect(ren,	SIGNAL(clicked()), SLOT(saveImageREN_event()));
	connect(xy,		SIGNAL(clicked()), SLOT(saveImageXY_event()));
	connect(xz,		SIGNAL(clicked()), SLOT(saveImageXZ_event()));
	connect(yz,		SIGNAL(clicked()), SLOT(saveImageYZ_event()));

	image_layout->addWidget(ren, 1);
	image_layout->addWidget(xy, 1);
	image_layout->addWidget(xz, 1);
	image_layout->addWidget(yz, 1);

	image_dlg->exec();
	glwindow->glvoxel->update();
	update();
}
void QtMainWindow::saveImageREN_event()
{
	image_mode = 1;
	image_dlg->close(1);
}
void QtMainWindow::saveImageXY_event()
{
	image_mode = 2;
	image_dlg->close(1);
}
void QtMainWindow::saveImageXZ_event()
{
	image_mode = 3;
	image_dlg->close(1);
}
void QtMainWindow::saveImageYZ_event()
{
	image_mode = 4;
	image_dlg->close(1);
}

void QtMainWindow::info_event()
{
	if(info_dlg->isVisible()) info_dlg->hide();
	else info_dlg->show();		
}

void QtMainWindow::about()
{
    QMessageBox::about( this, "Bioptonics Viewer v2.0",
			"A GPU-based volume rendering application.\n"
			"Developed for Optical Projection Tomography data.\n\n"
			"University of East Anglia / John Innes Centre.\n"
			"Jerome Avondo\n\n");

	glwindow->glvoxel->update();
	update();
}
 
void QtMainWindow::custom_layout_event()
{
	QColorDialog* coldialogue=0;

	glwindow->glvoxel->volrender.old_background_colour = glwindow->glvoxel->volrender.background_colour = coldialogue->getColor(glwindow->glvoxel->volrender.background_colour, this, "Choose a colour");

	Vector rgb, hsv;
	rgb.x = glwindow->glvoxel->volrender.background_colour.red()/255.0;
	rgb.y = glwindow->glvoxel->volrender.background_colour.green()/255.0;
	rgb.z = glwindow->glvoxel->volrender.background_colour.blue()/255.0;
	RGBtoHSV(rgb, &hsv);

	if(hsv.z>0.5)
	{
		glwindow->glvoxel->volrender.background_fontcolour = QColor(0.0,0.0,0.0);
	}
	else
	{
		glwindow->glvoxel->volrender.background_fontcolour = QColor(255.0,255.0,255.0);
	}

	glwindow->glvoxel->redraw_event();
	update();
}
void QtMainWindow::resetviewall_event(void)
{
	if(view_orientation==1) front_event();
	else if(view_orientation==2) back_event();
	else if(view_orientation==3) left_event();
	else if(view_orientation==4) right_event();
	else if(view_orientation==5) top_event();
	else if(view_orientation==6) bottom_event();

	glwindow->glvoxel->volrender.zoom = 0.0;
	glwindow->glvoxel->volrender.tx = 0.0;
	glwindow->glvoxel->volrender.ty = 0.0;
	glwindow->glvoxel->redraw_event();
}
void QtMainWindow::resetviewzoom_event(void)
{
	glwindow->glvoxel->volrender.zoom = 0.0;
	glwindow->glvoxel->redraw_event();
}
void QtMainWindow::resetviewtrans_event(void)
{
	glwindow->glvoxel->volrender.tx = 0.0;
	glwindow->glvoxel->volrender.ty = 0.0;
	glwindow->glvoxel->redraw_event();
}

void QtMainWindow::back_event(void)
{
	glwindow->glvoxel->volrender.setViewfromEuler(90,0,0);
	glwindow->glvoxel->redraw_event();
}
void QtMainWindow::front_event(void)
{
	glwindow->glvoxel->volrender.setViewfromEuler(-90,180,0);
	glwindow->glvoxel->redraw_event();
}
void QtMainWindow::right_event(void)
{
	glwindow->glvoxel->volrender.setViewfromEuler(0,90,0);
	glwindow->glvoxel->volrender.setViewfromEuler2(0,0,-90);
	glwindow->glvoxel->redraw_event();
}
void QtMainWindow::left_event(void)
{
	glwindow->glvoxel->volrender.setViewfromEuler(0,-90,0);
	glwindow->glvoxel->volrender.setViewfromEuler2(0,0,90);
	glwindow->glvoxel->redraw_event();
}
void QtMainWindow::top_event(void)
{
	glwindow->glvoxel->volrender.setViewfromEuler(0,180,0);
	glwindow->glvoxel->redraw_event();
}
void QtMainWindow::bottom_event(void)
{
	glwindow->glvoxel->volrender.setViewfromEuler(0,0,0);
	glwindow->glvoxel->redraw_event();
}

void QtMainWindow::transfer_editor_event()
{
	if(glwindow->glvoxel->volobject.is16bit)
	{
		transferfunc16bit_dialogue->show();
		transferfunc16bit_dialogue->raise();
	}
	else
	{
		transferfunction_editor_tabdlg->show();
		transferfunction_editor_tabdlg->raise();
	}
	glwindow->glvoxel->update();
	update();
}
void QtMainWindow::viewpref_event()
{
	view_editor_tabdlg->show();
	view_editor_tabdlg->raise();
	glwindow->glvoxel->update();
	update();
}
void QtMainWindow::lightpref_event()
{
	light_editor_tabdlg->show();
	light_editor_tabdlg->raise();
	glwindow->glvoxel->update();
	update();
}
void QtMainWindow::moviepref_event()
{
	movie_editor_tabdlg->show();
	movie_editor_tabdlg->raise();
	glwindow->glvoxel->update();
	update();
}
void QtMainWindow::measurepref_event()
{
	measure_editor_tabdlg->show();
	measure_editor_tabdlg->raise();
	glwindow->glvoxel->update();
	update();
}
void QtMainWindow::tfunction_event()
{
/*        transferfunc_dialogue->show();
        transferfunc_dialogue->raise();
        glwindow->glvoxel->update();
        update();
*/
}
void QtMainWindow::croppref_event()
{
	crop_editor_tabdlg->show();
	crop_editor_tabdlg->raise();
	glwindow->glvoxel->update();
	update();
}

void QtMainWindow::filterpref_event()
{
	filter_editor_tabdlg->show();
	filter_editor_tabdlg->raise();
	glwindow->glvoxel->update();
	update();
}

void QtMainWindow::volume_editor_event()
{
	volume_editor_tabdlg->show();
	volume_editor_tabdlg->raise();
	glwindow->glvoxel->update();
	update();
}

void QtMainWindow::transform_editor_event()
{
	clipping_editor_tabdlg->show();
	clipping_editor_tabdlg->raise();
	glwindow->glvoxel->update();
	update();
}
/*void QtMainWindow::measure_editor_event()
{
	measure_editor_tabdlg->show();
	measure_editor_tabdlg->raise();
	glwindow->glvoxel->update();
	update();
}
void QtMainWindow::domain_editor_event()
{
	domain_editor_tabdlg->show();
	domain_editor_tabdlg->raise();
	glwindow->glvoxel->update();
	*update();
}*/
void QtMainWindow::close_event( QCloseEvent* ce )
{
	ce->accept();
	qApp->quit();
}

void QtMainWindow::arc_mode_slot(void)
{
	printf("%s\n", glwindow->glvoxel->volobject.file_name);

//	dragndrop_slot(glwindow->glvoxel->volobject.file_name);

	glwindow->glvoxel->volio.load_RAW(glwindow->glvoxel->volobject.file_name, 4);

	//update our histogram
	volume_editor_tabdlg->rebuild_tabs();
	//load our data to opengl
	glwindow->glvoxel->volrender.load_TextureMap();
	//setup our slice arrays and slice sliders
	glwindow->create();
}
void QtMainWindow::resizeEvent ( QResizeEvent * e)
{
/*	int w, h;

	w = width();
	h = height();

	w = w-main_width;
	h = h-main_height;

	if( (w>h && w>0) || (w<h && w<0))
	{
		main_width += w;
		main_height += w;
	}
	else
	{
		main_width += h;
		main_height += h;
	}
*/
//	resize(main_width, main_height);
}

void QtMainWindow::dragndrop_slot(QString sFileName)
{	
	if (!sFileName.isEmpty()) 
	{

		timelapsehelper=0;
		QFile* file = new QFile(sFileName);

		if(!file->exists()) return;

		if(sFileName.contains(".dat", true) || sFileName.contains(".DAT", true)) 
		{	
			openRawFile(sFileName);
		}
		else if(sFileName.contains(".raw", true) || sFileName.contains(".RAW", true)) 
		{		
			openRawFile(sFileName);
		}
		else if(sFileName.contains(".png", true) || sFileName.contains(".PNG", true)
			|| sFileName.contains(".bmp", true) || sFileName.contains(".BMP", true)
			|| sFileName.contains(".jpg", true) || sFileName.contains(".JPG", true) 
			|| sFileName.contains(".tif", true) || sFileName.contains(".TIF", true)) 
		{
			//remove the filename of first file to get only dirname
			//int pos = sFileName.findRev(QString("/").latin1(), -1, false);
			//sFileName.replace(pos+1, sFileName.length()-pos+1, "");

			openImageDir(sFileName);
		}
		else if(sFileName.contains(".obj", true) || sFileName.contains(".OBJ", true))
		{
			//printf("sFileName: %s\n", sFileName.latin1());
			glwindow->glvoxel->isosurface_load_slot(sFileName.latin1());
		}
		/*else if(sFileName.contains(".wlz", true) || sFileName.contains(".WLZ", true)) 
		{
//			glwindow->glvoxel->volio.load_WLZ(sFileName, 4);
			glwindow->glvoxel->volobject.file_name = sFileName;
			glwindow->glvoxel->volobject.file_type = 1;
		//	glwindow->glvoxel->volrender.slices = glwindow->glvoxel->volobject.texwidth;
			glwindow->glvoxel->volrender.load_TextureMap();
			glwindow->create();
			volume_editor_tabdlg->reset();
			glwindow->glvoxel->mcubes.clear();
			volume_editor_tabdlg->isosurface_tab->del_all();	
			volume_editor_tabdlg->rebuild_tabs();
			view_editor_tabdlg->rebuild_tabs();
			update_info_labels();
			glwindow->glvoxel->redraw_event();	
		}*/
		else if(sFileName.contains(".slc", true) || sFileName.contains(".SLC", true)) 
		{	
			clipping_editor_tabdlg->cliptab->dragndrop_slot(sFileName);
		}
		else if(sFileName.contains(".msr", true) || sFileName.contains(".MSR", true)) 
		{	
			measure_editor_tabdlg->measuring_tab->dragndrop_slot(sFileName);
		}
		else if(sFileName.contains(".tfn", true) || sFileName.contains(".TFN", true)) 
		{	
			transferfunction_editor_tabdlg->tranfer_function_tab->dragndrop_slot(sFileName);
		}	
		else if(sFileName.contains(".tf2", true) || sFileName.contains(".TF2", true)) 
		{	
			transferfunc16bit_dialogue->tranfer_func_tab->dragndrop_slot(sFileName);
		}	
		else 
		{
			return;
		}
  }
}
void QtMainWindow::updateStatusBar(void)
{
	QString x, y, z;
	x.setNum(glwindow->glvoxel->volobject.width, 10);
	y.setNum(glwindow->glvoxel->volobject.height, 10);
	z.setNum(glwindow->glvoxel->volobject.depth, 10);

	QString c;
	if(glwindow->glvoxel->volobject.is_greyscale) c = "1";
	else
	{
		int nchannels=0;
		if(glwindow->glvoxel->volobject.has_red) nchannels ++;
		if(glwindow->glvoxel->volobject.has_green) nchannels ++;
		if(glwindow->glvoxel->volobject.has_blue) nchannels ++;

		c.setNum(nchannels, 10);
	}
	QString statmsg = "vol: [" + x + "x" + y + "x" + z + "x" + c + "]" + " | file: [" + glwindow->glvoxel->volobject.file_name + "]";
	glwindow->info_label->setText(statmsg);
	//BTAAAAAP	
	//statusBar->showMessage(statmsg, 0);
	//updateStatusBar();
}
void QtMainWindow::load_inifile(void)
{
	printf("LOADING: Settings.ini file...\n");

	string label;

//	QDir dir;
//	QString s;
//	s = dir.rootDirPath();
//	printf("%s\n", s.latin1());

	//input file for reading in parameter ranges
	ifstream input_file; 
	input_file.open("settings.ini");

	if(!input_file.is_open())
	{
		printf("Error loading INI file!\n");
		system("pause");
		exit(1);
	}

	//tokenize our input file
	Tokenizer token(input_file);

	default_filename="";

	//until oef is reached step through each token
	while(!input_file.eof()){
		if(token.ttype()==TT_WORD)
		{
			//get the first string lable
			label = token.sval();
			
			if(label=="window_width")
			{		
				//skip the equal sign
				token.nextToken(); 
				token.nextToken();
				if(token.ttype()==TT_NUMBER) main_width = token.nval();
			}
			else if(label=="window_height")
			{
				//skip the equal sign
				token.nextToken(); 
				token.nextToken();
				if(token.ttype()==TT_NUMBER) main_height = token.nval();
			}
			else if(label=="window_maximised")
			{
				//skip the equal sign
				token.nextToken(); 
				token.nextToken();
				if(token.ttype()==TT_NUMBER) maximised = token.nval();
			}
			else if(label=="window_consolle")
			{
				//skip the equal sign
				token.nextToken(); 
				token.nextToken();
				if(token.ttype()==TT_NUMBER) consolle = token.nval();
			}							
			else if(label=="window_main_screen")
			{		
				//skip the equal sign
				token.nextToken(); 
				token.nextToken();
				if(token.ttype()==TT_NUMBER) window_main_screen = token.nval();
			}					
			else if(label=="view_volume_toggle")
			{
				//skip the equal sign
				token.nextToken(); 
				token.nextToken();
				if(token.ttype()==TT_NUMBER) glwindow->glvoxel->volrender.volume_toggle = token.nval();
			}
			else if(label=="mouse_wheel_sensitivity")
			{
				//skip the equal sign
				token.nextToken(); 
				token.nextToken();
				if(token.ttype()==TT_NUMBER) glwindow->glvoxel->dw = token.nval();
			}
			else if(label=="view_stereo_toggle")
			{
				//skip the equal sign
				token.nextToken(); 
				token.nextToken();
				if(token.ttype()==TT_NUMBER) glwindow->glvoxel->volrender.stereo_toggle = token.nval();
			}
			else if(label=="view_stereo_mode")
			{
				//skip the equal sign
				token.nextToken(); 
				token.nextToken();
				if(token.ttype()==TT_NUMBER) glwindow->glvoxel->volrender.stereo_mode = token.nval();
			}
			else if(label=="view_stereo_seperation")
			{
				//skip the equal sign
				token.nextToken(); 
				token.nextToken();
				if(token.ttype()==TT_NUMBER) glwindow->glvoxel->volrender.stereo_eye_seperation = token.nval();
			//	cout<<glwindow->glvoxel->volrender.stereo_eye_seperation<<endl;
			}
			else if(label=="view_isosurface_toggle")
			{
				//skip the equal sign
				token.nextToken(); 
				token.nextToken();
				if(token.ttype()==TT_NUMBER) glwindow->glvoxel->volrender.isosurface_toggle = token.nval();
			}
			else if(label=="view_BB_toggle")
			{
				//skip the equal sign
				token.nextToken(); 
				token.nextToken();
				if(token.ttype()==TT_NUMBER) glwindow->glvoxel->volrender.BB_toggle = token.nval();

				if(glwindow->glvoxel->volrender.BB_toggle) boundingboxAct->setChecked(true);
				else  boundingboxAct->setChecked(false);
			}
			else if(label=="view_cursor_toggle")
			{
				//skip the equal sign
				token.nextToken(); 
				token.nextToken();
				if(token.ttype()==TT_NUMBER) glwindow->glvoxel->volrender.cursor_toggle = token.nval();
				
				if(glwindow->glvoxel->volrender.cursor_toggle) cursorAct->setChecked(true);
				else  cursorAct->setChecked(false);
			}
			else if(label=="view_fps_toggle")
			{
				//skip the equal sign
				token.nextToken(); 
				token.nextToken();
				if(token.ttype()==TT_NUMBER) glwindow->glvoxel->volrender.fps_toggle = token.nval();

				if(glwindow->glvoxel->volrender.fps_toggle) fpsAct->setChecked(true);
				else  fpsAct->setChecked(false);
			}
			else if(label=="view_axis_toggle")
			{
				//skip the equal sign
				token.nextToken(); 
				token.nextToken();
				if(token.ttype()==TT_NUMBER) glwindow->glvoxel->volrender.axis_toggle = token.nval();				

				if(glwindow->glvoxel->volrender.axis_toggle) axisAct->setChecked(true);
				else  axisAct->setChecked(false);

			}
			else if(label=="view_slice_draw_mode")
			{
				//skip the equal sign
				token.nextToken(); 
				token.nextToken();
				if(token.ttype()==TT_NUMBER) glwindow->glvoxel->volrender.slice_draw_mode = token.nval();
			}
			else if(label=="view_background_colour")
			{
				int r,g,b;

				//skip the equal sign
				token.nextToken(); 
				token.nextToken();
				if(token.ttype()==TT_NUMBER) r = token.nval();
				token.nextToken();
				if(token.ttype()==TT_NUMBER) g = token.nval();
				token.nextToken();
				if(token.ttype()==TT_NUMBER) b = token.nval();

				glwindow->glvoxel->volrender.background_colour.setRgb(r,g,b);
				glwindow->glvoxel->volrender.old_background_colour.setRgb(r,g,b);
			
				Vector rgb, hsv;
				rgb.x = glwindow->glvoxel->volrender.background_colour.red()/255.0;
				rgb.y = glwindow->glvoxel->volrender.background_colour.green()/255.0;
				rgb.z = glwindow->glvoxel->volrender.background_colour.blue()/255.0;
				RGBtoHSV(rgb, &hsv);

				if(hsv.z>0.5)
				{
					glwindow->glvoxel->volrender.background_fontcolour = QColor(0.0,0.0,0.0);
				}
				else
				{
					glwindow->glvoxel->volrender.background_fontcolour = QColor(255.0,255.0,255.0);
				}
			}	
			else if(label=="view_bb_colour")
			{
				int r,g,b;

				//skip the equal sign
				token.nextToken(); 
				token.nextToken();
				if(token.ttype()==TT_NUMBER) r = token.nval();
				token.nextToken();
				if(token.ttype()==TT_NUMBER) g = token.nval();
				token.nextToken();
				if(token.ttype()==TT_NUMBER) b = token.nval();

				glwindow->glvoxel->volrender.bb_colour.setRgb(r,g,b);
			}
			else if(label=="view_default_orientation")
			{
				//skip the equal sign
				token.nextToken(); 
				token.nextToken();
				QString orient;
				if(token.ttype()==TT_STRING) orient = string(token.sval()).data();
				
				//printf("%s\n", orient.latin1());
				
				if(orient=="FRONT")
				{
					view_orientation = 1;
					front_event();
				}
				else if(orient=="BACK")
				{
					view_orientation = 2;
					back_event();
				}
				else if(orient=="LEFT")
				{
					view_orientation = 3;
					left_event();
				}
				else if(orient=="RIGHT")
				{
					view_orientation = 4;
					right_event();
				}
				else if(orient=="TOP")
				{
					view_orientation = 5;
					top_event();
				}
				else if(orient=="BOTTOM")
				{
					view_orientation = 6;
					bottom_event();
				}
			}
			else if(label=="view_light_toggle")
			{
				token.nextToken(); 
				token.nextToken();
				if(token.ttype()==TT_NUMBER) glwindow->glvoxel->volrender.lights_toggle = token.nval();
				
				if(glwindow->glvoxel->volrender.lights_toggle==1) lightAct->setChecked(true);				
				else  lightAct->setChecked(false);
			}
			else if(label=="view_scalebar_toggle")
			{
				token.nextToken(); 
				token.nextToken();
				if(token.ttype()==TT_NUMBER) glwindow->glvoxel->volrender.scalebar_toggle = token.nval();
				
				if(glwindow->glvoxel->volrender.scalebar_toggle==1) scalebarAct->setChecked(true);				
				else  scalebarAct->setChecked(false);
			}
			else if(label=="volume_maxquality")
			{
				//skip the equal sign
				token.nextToken(); 
				token.nextToken();
				if(token.ttype()==TT_NUMBER)
				{
					int val = token.nval();
					view_editor_tabdlg->rendersettings_tab->rebuild();
					view_editor_tabdlg->rendersettings_tab->renderquality_slider->setMaximum(val);
				}
			}
			else if(label=="volume_maxquality_onmove")
			{
				//skip the equal sign
				token.nextToken(); 
				token.nextToken();
				if(token.ttype()==TT_NUMBER)
				{
					int val = token.nval();
					view_editor_tabdlg->rendersettings_tab->rebuild();
					view_editor_tabdlg->rendersettings_tab->renderquality_lod_slider->setMaximum(val);
				}
			}
			else if(label=="volume_maxsize")
			{
				//skip the equal sign
				token.nextToken(); 
				token.nextToken();
				if(token.ttype()==TT_NUMBER) glwindow->glvoxel->volobject.maxsizeZ = glwindow->glvoxel->volobject.maxsizeY = glwindow->glvoxel->volobject.maxsizeX = token.nval();
			}
			else if(label=="volume_render_mode")
			{
				//skip the equal sign
				token.nextToken(); 
				token.nextToken();
				if(token.ttype()==TT_NUMBER) glwindow->glvoxel->volrender.volume_render_mode = token.nval();
			}
			else if(label=="volume_viewport_size")
			{
				//skip the equal sign
				token.nextToken(); 
				token.nextToken();
				if(token.ttype()==TT_NUMBER) glwindow->glvoxel->volrender.FBO_SIZE = token.nval();
			}
			else if(label=="volume_viewport_size_onmove")
			{
				//skip the equal sign
				token.nextToken(); 
				token.nextToken();
				if(token.ttype()==TT_NUMBER) glwindow->glvoxel->volrender.LOD_FBO_SIZE = token.nval();
			}
			else if(label=="volume_viewport_toggle")
			{
				//skip the equal sign
				token.nextToken(); 
				token.nextToken();
				if(token.ttype()==TT_NUMBER) glwindow->glvoxel->volrender.FBOmoveLOD_toggle = token.nval();

			}
			else if(label=="volume_slices")
			{
				//skip the equal sign
				token.nextToken(); 
				token.nextToken();
				if(token.ttype()==TT_NUMBER) glwindow->glvoxel->volrender.numbslices = glwindow->glvoxel->volrender.slices = token.nval();
		
			}
			else if(label=="volume_slices_onmove")
			{
				//skip the equal sign
				token.nextToken(); 
				token.nextToken();
				if(token.ttype()==TT_NUMBER) glwindow->glvoxel->volrender.sliceslod = token.nval();
		
			}
			else if(label=="volume_slices_toggle")
			{
				//skip the equal sign
				token.nextToken(); 
				token.nextToken();
				if(token.ttype()==TT_NUMBER) glwindow->glvoxel->volrender.SlicesmoveLOD_toggle = token.nval();
		
			}
			else if(label=="volume_postprocess")
			{
				//skip the equal sign
				token.nextToken(); 
				token.nextToken();
				if(token.ttype()==TT_NUMBER) glwindow->glvoxel->volrender.PostProcess_toggle = token.nval();
		
				if(glwindow->glvoxel->volrender.PostProcess_toggle==1) view_editor_tabdlg->rendersettings_tab->postprocess_pb->setOn(TRUE);
				else view_editor_tabdlg->rendersettings_tab->postprocess_pb->setOn(FALSE);
			}
			else if(label=="volume_lodonmove_toggle")
			{
				//skip the equal sign
				token.nextToken(); 
				token.nextToken();
				if(token.ttype()==TT_NUMBER)
				{
					int val = token.nval();
					glwindow->glvoxel->volrender.SlicesmoveLOD_toggle = val;
					glwindow->glvoxel->volrender.FBOmoveLOD_toggle = val;
					
					if(val==1) view_editor_tabdlg->rendersettings_tab->renderquality_lod_pb->setOn(TRUE);
					else view_editor_tabdlg->rendersettings_tab->renderquality_lod_pb->setOn(FALSE);
				}
			}
			else if(label=="volume_postprocess_amount")
			{
				//skip the equal sign
				token.nextToken(); 
				token.nextToken();
				if(token.ttype()==TT_NUMBER) glwindow->glvoxel->volrender.postprocess2d_amount = token.nval();
			}
			else if(label=="volume_quality")
			{
				//skip the equal sign
				token.nextToken(); 
				token.nextToken();
				if(token.ttype()==TT_NUMBER) view_editor_tabdlg->rendersettings_tab->renderquality = token.nval();
			}
			else if(label=="volume_quality_onmove")
			{
				//skip the equal sign
				token.nextToken(); 
				token.nextToken();
				if(token.ttype()==TT_NUMBER) view_editor_tabdlg->rendersettings_tab->renderquality_lod = token.nval();
			}	
			else if(label=="file_default_filename")
			{
				//skip the equal sign
				token.nextToken(); 
				token.nextToken();
				if(token.ttype()==TT_STRING) default_filename = string(token.sval()).data();
			}
			else if(label=="file_type")
			{
				//skip the equal sign
				token.nextToken(); 
				token.nextToken();
				if(token.ttype()==TT_NUMBER) glwindow->glvoxel->volobject.file_type = token.nval();
			}
			else if(label=="file_last_working_dir")
			{
				//skip the equal sign
				token.nextToken(); 
				token.nextToken();
				if(token.ttype()==TT_STRING) last_working_dir = string(token.sval()).data();
			}
			else if(label=="file_defaul_movie_dir")
			{
				//skip the equal sign
				token.nextToken(); 
				token.nextToken();
				if(token.ttype()==TT_STRING)
				{
					movie_editor_tabdlg->moviesettings_tab->defaul_movie_dir = string(token.sval()).data();
					QDir dir(movie_editor_tabdlg->moviesettings_tab->defaul_movie_dir);
					if(!dir.exists())movie_editor_tabdlg->moviesettings_tab->defaul_movie_dir="";

					movie_editor_tabdlg->moviesettings_tab->choosedir_te->setText(movie_editor_tabdlg->moviesettings_tab->defaul_movie_dir);
				}
			}			
			//else we dont know what it is, go to next label
			else
			{
				//cout<<"WARNING: Unrecognized Label..."<<endl;
				token.nextToken();
			}
		}
		else token.nextToken();
	}
	input_file.close();

	//UPDATA GUI STUFF NOW...
	if(glwindow->glvoxel->volrender.FBOmoveLOD_toggle && glwindow->glvoxel->volrender.SlicesmoveLOD_toggle)
	{
		view_editor_tabdlg->rendersettings_tab->renderquality_lod_pb->setOn(TRUE);
	}
	else
	{
		view_editor_tabdlg->rendersettings_tab->renderquality_lod_pb->setOn(FALSE);
	}

	if(glwindow->glvoxel->volobject.maxsizeZ)
	{
		view_editor_tabdlg->rendersettings_tab->maxtexturesize = glwindow->glvoxel->volobject.maxsizeZ;
	}


	if(glwindow->glvoxel->volrender.PostProcess_toggle)
	{
		view_editor_tabdlg->rendersettings_tab->postprocess_pb->setOn(TRUE);
	}
	else
	{
		view_editor_tabdlg->rendersettings_tab->postprocess_pb->setOn(FALSE);
	}

	if(glwindow->glvoxel->volrender.postprocess2d_amount)
	{
		view_editor_tabdlg->rendersettings_tab->postprocess = glwindow->glvoxel->volrender.postprocess2d_amount;
	}

	if(!default_filename.isEmpty())
	{
		dragndrop_slot(default_filename);
	}
	
	view_editor_tabdlg->rebuild_tabs();

	stereo_editor_tabdlg->stereosettings_tab->set_fromini(glwindow->glvoxel->volrender.stereo_toggle, glwindow->glvoxel->volrender.stereo_mode, glwindow->glvoxel->volrender.stereo_eye_seperation);

	int x_pos, y_pos;
	int screen0_w, screen0_h, screen1_w, screen1_h;
	
	resize(main_width, main_height);
	
	if((int)QApplication::desktop()->numScreens()>1)
	{
		//printf("mutli-screen \n");
		
		screen0_w = QApplication::desktop()->screenGeometry(0).width();
		screen0_h = QApplication::desktop()->screenGeometry(0).height();
		screen1_w = QApplication::desktop()->screenGeometry(1).width();
		screen1_h = QApplication::desktop()->screenGeometry(1).height();

		//printf("screen0: %d x %d\n", screen0_w, screen0_h);
		//printf("screen1: %d x %d\n", screen1_w, screen1_h);
		
		if(window_main_screen==0)
		{		
			printf("pos screen0: %d x %d\n", (int)((screen0_w/2.0) - (main_width/2.0)),  (int)((screen0_h/2.0) - (main_height/2.0)));
			move(screen0_w/2.0 - main_width/2.0,  screen0_h/2.0 - main_height/2.0);
		}
		else
		{
			//printf("pos screen1: %d x %d\n", (int) ((screen0_w + (screen1_w/2.0)) - (main_width/2.0)),  (int)((screen1_h/2.0) - (main_height/2.0)));
			move((screen0_w + (screen1_w/2.0)) - (main_width/2.0),  (screen1_h/2.0) - (main_height/2.0));		
		}
	}
	else
	{
		//printf("single-screen \n");

		screen0_w = QApplication::desktop()->width();
		screen0_h = QApplication::desktop()->height(); 
		move(screen0_w/2.0 - main_width/2.0,  screen0_h/2.0 - main_height/2.0);		
	}		
	
	if(maximised==1)
	{
		//printf("showMaximized\n");
		activateWindow ();
		raise();
		showMaximized();
	}	
	else
	{
		//printf("showNormal\n");
		activateWindow ();
		raise();
		showNormal();
	}
	
	glwindow->glvoxel->redraw_event();
}
void QtMainWindow::minibutton_I_event(void)
{
	togglevoxels_event();

	/*if(intentb->isOn())
	{
		redtb->setOn(true);
		greentb->setOn(true);
		bluetb->setOn(true);
	}
	else
	{
		redtb->setOn(false);
		greentb->setOn(false);
		bluetb->setOn(false);
	}*/
}
void QtMainWindow::minibutton_red_event(void)
{
	if(glwindow->glvoxel->volrender.r_channel) glwindow->glvoxel->volrender.r_channel =0;
	else glwindow->glvoxel->volrender.r_channel = 1;
	glwindow->glvoxel->redraw_event();
}
void QtMainWindow::minibutton_green_event(void)
{
	if(glwindow->glvoxel->volrender.g_channel) glwindow->glvoxel->volrender.g_channel =0;
	else glwindow->glvoxel->volrender.g_channel = 1;
	glwindow->glvoxel->redraw_event();
}
void QtMainWindow::minibutton_blue_event(void)
{
	if(glwindow->glvoxel->volrender.b_channel) glwindow->glvoxel->volrender.b_channel =0;
	else glwindow->glvoxel->volrender.b_channel = 1;
	glwindow->glvoxel->redraw_event();
}
void QtMainWindow::minibutton_bg_event(void)
{
	if(glwindow->glvoxel->volrender.bldmode==2) return;
	
	custom_layout_event();
}


void QtMainWindow::minibutton_vertfinder_event(void)
{
/*	glwindow->glvoxel->make_vertfinder();

	glwindow->glvoxel->volobject.has_red = 1;
	glwindow->glvoxel->volobject.has_green = 1;
	glwindow->glvoxel->volobject.has_blue = 1;

	glwindow->glvoxel->volrender.r_channel = 1;
	glwindow->glvoxel->volrender.g_channel = 1;
	glwindow->glvoxel->volrender.b_channel = 1;
	glwindow->glvoxel->volobject.is_greyscale=0;

	intentb->setOn(true);
	redtb->setOn(true);
	greentb->setOn(true);
	bluetb->setOn(true);
	transferfunction_editor_tabdlg->tranfer_function_tab->red_pb->setEnabled(true);
	transferfunction_editor_tabdlg->tranfer_function_tab->green_pb->setEnabled(true);
	transferfunction_editor_tabdlg->tranfer_function_tab->blue_pb->setEnabled(true);

	volume_editor_tabdlg->reset();
	volume_editor_tabdlg->rebuild_tabs();
	
	view_editor_tabdlg->rebuild_tabs();	
	view_editor_tabdlg->rendersettings_tab->rebuild();
	
	glwindow->create();
	updateStatusBar();
	
	emit tfunc_is16bit_signal(false);*/

	timelapsehelper++;
	if(timelapsehelper>timelapsedirs.size()-1) timelapsehelper = timelapsedirs.size()-1;
	QString temp = last_working_dir;
	openImageDir(last_working_dir+"/"+timelapsedirs.at(timelapsehelper)+"/");
	last_working_dir = temp;
}
void QtMainWindow::timelapseEvent(void)
{
	timelapsehelper++;
	if(timelapsehelper>timelapsedirs.size()-1) timelapsehelper = timelapsedirs.size()-1;
	QString temp = last_working_dir;
	openImageDir(last_working_dir+"/"+timelapsedirs.at(timelapsehelper)+"/");
	last_working_dir = temp;
}
void QtMainWindow::minibutton_filter_event(void)
{
	/*glwindow->glvoxel->make_filter();

	glwindow->glvoxel->volobject.has_red = 1;
	glwindow->glvoxel->volobject.has_green = 1;
	glwindow->glvoxel->volobject.has_blue = 1;

	glwindow->glvoxel->volrender.r_channel = 1;
	glwindow->glvoxel->volrender.g_channel = 1;
	glwindow->glvoxel->volrender.b_channel = 1;
	glwindow->glvoxel->volobject.is_greyscale=0;

	intentb->setOn(true);
	redtb->setOn(true);
	greentb->setOn(true);
	bluetb->setOn(true);
	transferfunction_editor_tabdlg->tranfer_function_tab->red_pb->setEnabled(true);
	transferfunction_editor_tabdlg->tranfer_function_tab->green_pb->setEnabled(true);
	transferfunction_editor_tabdlg->tranfer_function_tab->blue_pb->setEnabled(true);

	volume_editor_tabdlg->reset();
	volume_editor_tabdlg->rebuild_tabs();
	
	view_editor_tabdlg->rebuild_tabs();	
	view_editor_tabdlg->rendersettings_tab->rebuild();
	
	glwindow->create();
	updateStatusBar();
	
	emit tfunc_is16bit_signal(false);*/
}
void QtMainWindow::minibutton_label_event(void)
{
/*	glwindow->glvoxel->make_binary();

	glwindow->glvoxel->volobject.has_red = 1;
	glwindow->glvoxel->volobject.has_green = 1;
	glwindow->glvoxel->volobject.has_blue = 1;

	glwindow->glvoxel->volrender.r_channel = 1;
	glwindow->glvoxel->volrender.g_channel = 1;
	glwindow->glvoxel->volrender.b_channel = 1;
	glwindow->glvoxel->volobject.is_greyscale=0;

	intentb->setOn(true);
	redtb->setOn(true);
	greentb->setOn(true);
	bluetb->setOn(true);
	transferfunction_editor_tabdlg->tranfer_function_tab->red_pb->setEnabled(true);
	transferfunction_editor_tabdlg->tranfer_function_tab->green_pb->setEnabled(true);
	transferfunction_editor_tabdlg->tranfer_function_tab->blue_pb->setEnabled(true);

	volume_editor_tabdlg->reset();
	volume_editor_tabdlg->rebuild_tabs();
	
	view_editor_tabdlg->rebuild_tabs();	
	view_editor_tabdlg->rendersettings_tab->rebuild();
	
	glwindow->create();
	updateStatusBar();
	
	emit tfunc_is16bit_signal(false);*/
	timelapsehelper--;
	if(timelapsehelper<0) timelapsehelper = 0;
	QString temp = last_working_dir;
	openImageDir(last_working_dir+"/"+timelapsedirs.at(timelapsehelper)+"/");
	last_working_dir = temp;
}

void QtMainWindow::minibutton_mip_event(void)
{
	if(glwindow->glvoxel->volrender.bldmode==1)
	{
		blend_mode2_event();
	}
	else
	{
		blend_mode1_event();
	}

}
void QtMainWindow::minibutton_atten_event(void)
{
	if(glwindow->glvoxel->volrender.bldmode==1) blend_mode4_event();
	else blend_mode1_event();
}
void QtMainWindow::minibutton_bb_event(void)
{
	toggleBB_event();
}
void QtMainWindow::minibutton_lights_event(void)
{
	togglelights_event();
}
void QtMainWindow::minibutton_axis_event(void)
{
	toggleaxis_event();
}
void QtMainWindow::minibutton_cursor_event(void)
{
	togglecursor_event();
}
void QtMainWindow::minibutton_surfaces_event(void)
{
	togglesurfaces_event();
}

void QtMainWindow::minibutton_fps_event(void)
{
	togglefps_event();
}
void QtMainWindow::minibutton_info_event(void)
{
	info_event();
}
void QtMainWindow::minibutton_stereo_event(void)
{
	stereo_editor_tabdlg->show();
}
void QtMainWindow::minibutton_fullscreen_event(void)
{

	glwindow->sections_toggle = !glwindow->sections_toggle;

	if(glwindow->sections_toggle)
	{
		glwindow->yzlb->hide();
		glwindow->slider_yz->setEnabled(false);
		//glwindow->slider_yz->hide();
		glwindow->slider_yz_lb->hide();

		glwindow->xylb->hide();
		glwindow->slider_xy->setEnabled(false);
		//glwindow->slider_xy->hide();
		glwindow->slider_xy_lb->hide();

		glwindow->xzlb->hide();
		glwindow->slider_xz->setEnabled(false);
		//glwindow->slider_xz->hide();
		glwindow->slider_xz_lb->hide();
		
		glwindow->cursor_label->hide();
	}
	else
	{
		glwindow->yzlb->show();
		glwindow->slider_yz->setEnabled(true);
		//glwindow->slider_yz->show();
		glwindow->slider_yz_lb->show();

		glwindow->xylb->show();
		glwindow->slider_xy->setEnabled(true);
		//glwindow->slider_xy->show();
		glwindow->slider_xy_lb->show();

		glwindow->xzlb->show();
		glwindow->slider_xz->setEnabled(true);
		//glwindow->slider_xz->show();
		glwindow->slider_xz_lb->show();

		glwindow->cursor_label->show();	
	}

}
void QtMainWindow::minibutton_hq_event(void)
{
	view_editor_tabdlg->rendersettings_tab->renderquality = 10.0;
	view_editor_tabdlg->rendersettings_tab->renderquality_lod = 10.0;
	view_editor_tabdlg->rebuild_tabs();
}
void QtMainWindow::minibutton_mq_event(void)
{
	view_editor_tabdlg->rendersettings_tab->renderquality = 5.0;
	view_editor_tabdlg->rendersettings_tab->renderquality_lod = 5.0;
	view_editor_tabdlg->rebuild_tabs();
}
void QtMainWindow::minibutton_lq_event(void)
{
	view_editor_tabdlg->rendersettings_tab->renderquality = 2.0;
	view_editor_tabdlg->rendersettings_tab->renderquality_lod = 2.0;
	view_editor_tabdlg->rebuild_tabs();
}
void QtMainWindow::single_channel_slot(void)
{
		intentb->setOn(true);
		redtb->setOn(false);
		greentb->setOn(false);
		bluetb->setOn(false);
}
void QtMainWindow::measure_setscale_slot(float x, float y, float z)
{
	printf("QtMainWindow::measure_setscale_slot\n");
	glwindow->glvoxel->volobject.xscale = x;
	glwindow->glvoxel->volobject.yscale = y;
	glwindow->glvoxel->volobject.zscale = z;
	glwindow->glvoxel->redraw_event();
}
