
 #include <qlayout.h>
#include <qlabel.h> 
#include <qslider.h>
#include <QPixmap>

#include <math.h> 

#include "QtMeasuringEditorDialogue.h"

QtMeasuringEditorDialogue::QtMeasuringEditorDialogue(QWidget * parent, const char * name, bool modal, Qt::WFlags f) 
:Q3TabDialog(parent, name, modal,f)
{
	QSizePolicy sizepolicy;
	sizepolicy.setHeightForWidth(TRUE);
	setSizePolicy(sizepolicy);
 
	setCaption("Measuring Editor");
	setIcon( QPixmap( "Icons/ruler.png" ));

	build_layout();
}

QtMeasuringEditorDialogue::~QtMeasuringEditorDialogue(void)
{
}

void QtMeasuringEditorDialogue::reset(void)
{
	measuring_tab->reset();
}

void QtMeasuringEditorDialogue::build_layout(void)
{
//	printf("creating measuretab\n");

	//measuring tab
	measuring_tab = new QtMeasuringWidget(this, "measuretab");
	measuring_tab->create();

	//our tab pages
	addTab(measuring_tab, "Measuring");

	setCancelButton("Close");
	setOkButton(0);
}
