#include "QtMeasuringWidget.h"
//Added by qt3to4:
#include <Q3Frame>
#include <QPixmap>
#include <QLabel>


QtMeasuringWidget::QtMeasuringWidget(QWidget* parent, const char* name)
: QWidget( parent, name )
{
	lb_index=0;
	pnts_length=0;

	currentworkingdir="";
	voxX = voxY = voxZ = 1.0;
	unitX = unitY = unitZ = 1.0;
	setAcceptDrops(true);
}
QtMeasuringWidget::~QtMeasuringWidget()
{
}
void QtMeasuringWidget::dragndrop_slot(QString sFileName)
{	
	if (!sFileName.isEmpty()) 
	{
		if(sFileName.contains(".msr", true) || sFileName.contains(".MSR", true)) 
		{
			open_file(sFileName);
		}
	}
}
void QtMeasuringWidget::dragEnterEvent(QDragEnterEvent* event)
{
	event->accept(Q3TextDrag::canDecode(event));
}
void QtMeasuringWidget::dropEvent(QDropEvent* event)
{
	Q3StrList URIs;

	if ( Q3UriDrag::decode(event, URIs) ) 
	{
		QString text = Q3UriDrag::uriToLocalFile(URIs.getFirst());
		dragndrop_slot(text);
	}
}
void QtMeasuringWidget::rebuild(void)
{
}
void QtMeasuringWidget::reset(void)
{
}
void QtMeasuringWidget::create(void)
{
    //connect(this, SIGNAL(dragndrop_signal(QString)), this, SLOT(dragndrop_slot(QString)));

	Q3ButtonGroup* opensave_grp = new Q3ButtonGroup( 1, Qt::Horizontal, "File:", this );
    opensave_grp->setExclusive( FALSE );
	opensave_grp->setAlignment(Qt::AlignLeft);
	//opensave_grp->setSizePolicy(QSizePolicy(QSizePolicy::Maximum, QSizePolicy::Maximum, false));

		QPushButton* open = new QPushButton(QIcon(QPixmap("icons/fileopen.xpm")), "Open", opensave_grp, "open");
		connect( open, SIGNAL( clicked () ), this, SLOT( open_event() ) );
		//open->setSizePolicy(QSizePolicy(QSizePolicy::Maximum, QSizePolicy::Maximum, false));
		
		QPushButton* save = new QPushButton(QIcon(QPixmap("icons/filesave.xpm")), "Save", opensave_grp, "save");
		connect( save, SIGNAL( clicked () ), this, SLOT( save_event() ) );
		//save->setSizePolicy(QSizePolicy(QSizePolicy::Maximum, QSizePolicy::Maximum, false));

	Q3ButtonGroup* scale_grp = new Q3ButtonGroup( 1, Qt::Horizontal, "Scale:", this );
    scale_grp->setExclusive( FALSE );

		QPushButton* setscale = new QPushButton("Set Scale", scale_grp, "setscale");
		setscale->setSizePolicy(QSizePolicy(QSizePolicy::Maximum, QSizePolicy::Maximum, false));
		connect( setscale, SIGNAL( clicked() ), this, SLOT( setscale_event() ) );

	Q3ButtonGroup* addrmv_grp = new Q3ButtonGroup( 1, Qt::Horizontal, "Actions:", this );
    addrmv_grp->setExclusive( FALSE );

		QPushButton* add = new QPushButton("New", addrmv_grp, "new");
		add->setSizePolicy(QSizePolicy(QSizePolicy::Maximum, QSizePolicy::Maximum, false));
		connect( add, SIGNAL( clicked() ), this, SLOT( add_event() ) );
		
		QPushButton* del = new QPushButton("Delete", addrmv_grp, "del");
		del->setSizePolicy(QSizePolicy(QSizePolicy::Maximum, QSizePolicy::Maximum, false));
		connect( del, SIGNAL( clicked() ), this, SLOT( del_event() ) );

	Q3ButtonGroup* list_grp = new Q3ButtonGroup( 2, Qt::Horizontal, "", this );
    list_grp->setExclusive( FALSE );

			listbox = new QTableWidget(list_grp);
		    listbox->setColumnCount(2);	
			QStringList headerlist;
			headerlist << "Name" << "Visible";
			listbox->setHorizontalHeaderLabels(headerlist);
			listbox->verticalHeader()->hide();
			listbox->setAlternatingRowColors(true);
			listbox->setColumnWidth(0, 160);
			listbox->setColumnWidth(1, 50);

			connect(listbox, SIGNAL(itemDoubleClicked(QTableWidgetItem*)), this, SLOT(listboxdoubleclick_event(QTableWidgetItem*)));
			connect(listbox, SIGNAL(itemChanged(QTableWidgetItem*)), this, SLOT(listboxitemChanged_event(QTableWidgetItem*)));

	Q3BoxLayout * left_blayout = new Q3BoxLayout ( 0, Q3BoxLayout::TopToBottom, 0, 5, "left_blayout");
	left_blayout->setAlignment(Qt::AlignTop);
    left_blayout->addWidget( opensave_grp, 0, Qt::AlignTop);
    left_blayout->addWidget( scale_grp, 0, Qt::AlignTop);
    left_blayout->addWidget( addrmv_grp, 0, Qt::AlignTop);

	Q3BoxLayout * rigth_blayout = new Q3BoxLayout ( 0, Q3BoxLayout::TopToBottom, 0, 5, "rigth_blayout");
    rigth_blayout->addWidget( list_grp, 0);
	
	//our transfertab top level layout
	Q3BoxLayout * isotab_blayout = new Q3BoxLayout ( this, Q3BoxLayout::LeftToRight, 10, 5, "isotab_blayout");
    isotab_blayout->addLayout( left_blayout, 1);
    isotab_blayout->addLayout( rigth_blayout, 10);
}

void QtMeasuringWidget::open_file(QString fn)
{
	if(!fn.isEmpty())
	{
		ifstream input_file; 
		input_file.open(fn.latin1());

		if(!input_file.is_open()) return;

		Tokenizer token(input_file);
		
		string label;
		Vector v;
		Edge e;
		
		vector<QString> temp_namestrings;
		vector< vector<Vector> > temp_measuring_vertices;
		vector< vector<Edge> > temp_measuring_edges;
		vector<int> temp_measuring_drawmodes;

		/*listbox->clear();
		
		for(int i=0; i<measuring_vertices.size(); i++)
		{
			measuring_vertices[i].clear();
		}
		measuring_vertices.clear();

		measuring_drawmodes.clear();
		current_measurement.clear();
		measuring_planes.clear();*/
		
		int mindex=-1;

		//until oef is reached step through each token
		while(!input_file.eof())
		{
			if(token.ttype()==TT_WORD)
			{
				//get the first string lable
				label = token.sval();
				
				if(label=="OBJECTCOUNT")
				{
					//skip the equal sign
					token.nextToken();
					token.nextToken();
					if(token.ttype()==TT_NUMBER)
					{
						int size = token.nval();
						temp_measuring_vertices.resize(size);
						temp_measuring_edges.resize(size);
					}
				}
				else if(label=="OBJECTNAME")
				{
					//if(current_measurement.size()!=0) measuring_vertices.push_back(current_measurement);
					mindex++;

					//skip the equal sign
					token.nextToken();
					token.nextToken();
					if(token.ttype()==TT_STRING)
					{
						label = token.sval();
						QString name = label.data();
						temp_namestrings.push_back(name);
					}

				}
				else if(label=="OBJECTVERTCOUNT")
				{
					//skip the equal sign
					token.nextToken();
					token.nextToken();
					if(token.ttype()==TT_NUMBER)
					{
						int size = token.nval();
					}
				}
				else if(label=="OBJECTTYPE")
				{		
					//skip the equal sign
					token.nextToken(); 
					token.nextToken();
					if(token.ttype()==TT_STRING)
					{
						label = token.sval();;
					
						QString objtype = label.data();

						if(label == "POINTS") temp_measuring_drawmodes.push_back(0);
						else if(label == "LINES") temp_measuring_drawmodes.push_back(1);
						else if(label == "LINE_STRIP") temp_measuring_drawmodes.push_back(2);
						else if(label == "LINE_LOOP") temp_measuring_drawmodes.push_back(3);
						//else if(label == "GL_POLYGON") temp_measuring_drawmodes.push_back(4);
						//else if(label == "GL_SPHERE") temp_measuring_drawmodes.push_back(5);
						else if(label == "MAGNETIC_LINES") temp_measuring_drawmodes.push_back(6);
					}
				}
				/*else if(label=="PLANE")
				{
					//skip the equal sign
					token.nextToken(); 
					token.nextToken();
					if(token.ttype()==TT_NUMBER) v.x = token.nval();
					token.nextToken();
					if(token.ttype()==TT_NUMBER) v.y = token.nval();
					token.nextToken();
					if(token.ttype()==TT_NUMBER) v.z = token.nval();
					token.nextToken();
					if(token.ttype()==TT_NUMBER) v.w = token.nval();

					//printf("v: %f, %f, %f %f\n", v.x, v.y, v.z,v.w);				
					measuring_planes.push_back(v);
				}*/
				else if(label=="VERT")
				{		
					//skip the equal sign
					token.nextToken(); 
					token.nextToken();
					if(token.ttype()==TT_NUMBER) v.x = token.nval();
					token.nextToken();
					if(token.ttype()==TT_NUMBER) v.y = token.nval();
					token.nextToken();
					if(token.ttype()==TT_NUMBER) v.z = token.nval();
					
					v.w = 0.0;
					temp_measuring_vertices[mindex].push_back(v);
				}
				else if(label=="EDGE")
				{		
					//skip the equal sign
					token.nextToken(); 
					token.nextToken();
					if(token.ttype()==TT_NUMBER) e.v0 = token.nval();
					token.nextToken();
					if(token.ttype()==TT_NUMBER) e.v1 = token.nval();
				
					temp_measuring_edges[mindex].push_back(e);
				}				//else we dont know what it is, go to next label
				else
				{
					token.nextToken();
				}
			}
			else token.nextToken();
		}

		input_file.close();
	
		//emit measure_clearall_signal();

		QTableWidgetItem *newItem;

		printf("measuring_edges: %d\n", measuring_edges.size());

		for(int i=0; i<temp_measuring_vertices.size(); i++)
		{
			listbox->setRowCount(listbox->rowCount()+1);

			newItem = new QTableWidgetItem();
			newItem->setText(temp_namestrings[i]);
			listbox->setItem(listbox->rowCount()-1,0, newItem);

			newItem = new QTableWidgetItem();
			newItem->setTextAlignment(Qt::AlignCenter);
			newItem->setFlags(Qt::ItemIsUserCheckable | Qt::ItemIsEnabled);
			newItem->setCheckState(Qt::Checked);
			listbox->setItem(listbox->rowCount()-1,1, newItem);
		
			measuring_vertices.push_back(temp_measuring_vertices[i]);
			measuring_drawmodes.push_back(temp_measuring_drawmodes[i]);
			measuring_edges.push_back(temp_measuring_edges[i]);

			emit measure_load_item_signal(temp_measuring_vertices[i], temp_measuring_edges[i], temp_measuring_drawmodes[i]);
		}
	
		printf("measuring_edges: %d\n", measuring_edges.size());

		/*QTableWidgetItem* item = new QTableWidgetItem();
		for(int i=0; i<measuring_vertices.size(); i++)
		{
			printf("BOH\n");
			item->setText(namestrings[i]);
			listbox->setItem(i, 0, item);
			emit measure_load_item_signal(measuring_vertices[i], measuring_edges[i], measuring_drawmodes[i]);
		}*/
	}
}

void QtMeasuringWidget::modifygroupbutton_event(void)
{
	if(modifygroupbutton->isOn())
	{
		printf("Start\n");
		addpntbutton->setOn(false);
		addpntbutton_event();
		emit measure_modify_start_signal();
	}
	else
	{
		printf("Stop\n");
		emit measure_modify_stop_signal();
	}
}

void QtMeasuringWidget::open_event(void)
{
	QString fn = QFileDialog::getOpenFileName(currentworkingdir, "*.msr", this );
	open_file(fn);
}

void QtMeasuringWidget::save_event(void)
{
	QString fn = QFileDialog::getSaveFileName(currentworkingdir, "*.msr", this );
	
	if(!fn.isEmpty())
	{
		ofstream fout;
		fout.open(fn.latin1());

		QTableWidgetItem* curr_item;

		fout<<"ORIGINALFILENAME = '"<<originalfilename.latin1()<<"'"<<endl;
		fout<<"OBJECTCOUNT = "<<measuring_vertices.size()<<endl;
		for(int i=0; i<measuring_vertices.size(); i++)
		{
			curr_item = listbox->item(i, 0);


			fout<<"OBJECTNAME = '"<<curr_item->text().latin1()<<"'"<<endl;
					
			//fout<<"OBJECTLENGTH = "<< eval_length(i)<<endl;			
			//fout<<"OBJECTAREA = 0.0"<<endl;
			//fout<<"OBJECTVOLUME = "<<eval_sphere()<<endl;

			QString objtypestring="";
			int objtype = measuring_drawmodes[i];

			if(objtype==0) objtypestring="'POINTS'";
			else if(objtype==1) objtypestring="'LINES'";
			else if(objtype==2) objtypestring="'LINE_STRIP'";
			else if(objtype==3) objtypestring="'LINE_LOOP'";
			//else if(objtype==4) objtypestring="'GL_POLYGON'";
			//else if(objtype==5) objtypestring="'GL_SPHERE'";
			else if(objtype==6) objtypestring="'MAGNETIC_LINES'";
			
			fout<<"OBJECTTYPE = "<<objtypestring.latin1()<<endl;

			fout<<"OBJECTVERTCOUNT = "<<measuring_vertices[i].size()<<endl;
			
			for(int j=0; j<measuring_vertices[i].size(); j++)
			{
				fout<<"VERT = "<<measuring_vertices[i][j].x<<" "<<measuring_vertices[i][j].y<<" "<<measuring_vertices[i][j].z<<endl;
			}

			if(!measuring_edges[i].empty())
			{
				fout<<"OBJECTEDGESCOUNT = "<<measuring_edges[i].size()<<endl;
				for(int j=0; j<measuring_edges[i].size(); j++)
				{
					fout<<"EDGE = "<<measuring_edges[i][j].v0<<" "<<measuring_edges[i][j].v1<<endl;
				}
			}
		}

		fout.close();
	}
}
void QtMeasuringWidget::listboxitemChanged_event(QTableWidgetItem* item)
{
	int row = item->row();
	int column = item->column();
	if(column==1)
	{
		//printf("row: %d, column: %d\n", row, column);
		//QTableWidgetItem* item = listbox->itemAt(row, column);
		
		bool checked;
		if(item->checkState()==Qt::Checked)
		{
			//printf("checked\n");
			checked = true;
		}
		else if(item->checkState()==Qt::Unchecked)
		{
			//printf("un-checked\n");
			checked = false;
		}

		emit measure_update_visible_signal(row, checked);
	}
}
void QtMeasuringWidget::measure_clearcurrent_slot(void)
{
	vertices_listbox->clear();
	current_measurement.clear();
	current_edgemeasurement.clear();
}

void QtMeasuringWidget::listboxdoubleclick_event(QTableWidgetItem* item)
{
	vert_label = length_label = angle_label = 0;

	current_listbox_index = listbox->row(item);
	if(item->column()!=0) return;

	emit measure_update_current_signal(current_listbox_index);
	emit measure_update_current_drawmode_signal(measuring_drawmodes[current_listbox_index]);
	//emit measure_disableunselect_signal();	
	
	printf("DOUBLE CLICK!!\n");
	printf("SENDING CUTPLANE\n");	
	
	if(current_listbox_index<measuring_planes.size())
	{
		printf("listboxdoubleclick_event: %d %f %f %f \n", (int)measuring_planes[current_listbox_index].x, measuring_planes[current_listbox_index].y, measuring_planes[current_listbox_index].z, measuring_planes[current_listbox_index].w);
		emit measure_setcutplane_signal((int)measuring_planes[current_listbox_index].x, measuring_planes[current_listbox_index].y, measuring_planes[current_listbox_index].z, measuring_planes[current_listbox_index].w);
	}
	else
	{
		printf("Uh Oh\n");
		printf("size: %d\n", measuring_planes.size());
	}
	
	QString objstring  = item->text();

        add_dialogue = new QDialog(this, "Measurement Editor", 0);

	Q3BoxLayout* addmeasure_layout = new Q3BoxLayout(add_dialogue, Q3BoxLayout::TopToBottom, 4, 4, "add_dialogue_layout");

		Q3ButtonGroup *name_grp = new Q3ButtonGroup( 1, Qt::Horizontal, "", this);
			QLabel* name_lb = new QLabel("Name:	", name_grp);
			name_le = new QLineEdit(objstring, name_grp);

		Q3ButtonGroup *addrmv_layout = new Q3ButtonGroup( 3, Qt::Horizontal, "", this);
//		addrmv_layout->setExclusive(true);
			
			Q3ButtonGroup *pnts_layout = new Q3ButtonGroup( 1, Qt::Vertical, "Points: ", addrmv_layout);

				QPixmap addIcon = QPixmap( "icons/add.png" );
				addpntbutton		= new QPushButton(addIcon, "",	pnts_layout );
				addpntbutton->setToolTip("Add Items");
				addpntbutton->setToggleButton(true);
				addpntbutton->setOn(false);
				addpntbutton->setFixedSize(48,48);
				addpntbutton->setIconSize(QSize(32,32));
				connect(addpntbutton, SIGNAL( clicked () ), this, SLOT( addpntbutton_event() ) );

				QPixmap removeIcon = QPixmap( "icons/remove.png" );
				rmvpntbutton		= new QPushButton(removeIcon, "",	pnts_layout);
				rmvpntbutton->setToolTip("Delete Items");
				rmvpntbutton->setToggleButton(false);
				rmvpntbutton->setOn(false);
				rmvpntbutton->setFixedSize(48,48);
				rmvpntbutton->setIconSize(QSize(32,32));
				connect(rmvpntbutton, SIGNAL( clicked () ), this, SLOT( rmvpntbutton_event() ) );

			Q3ButtonGroup *planes_layout = new Q3ButtonGroup( 1, Qt::Vertical, "Planes: ", addrmv_layout);

				//QPixmap addIcon = QPixmap( "icons/add.png" );
				resetplanesbutton		= new QPushButton("Reset\n Planes",	planes_layout );
				resetplanesbutton->setToolTip("Reset the clipping planes");
				//resetplanesbutton->setToggleButton(true);
				//resetplanesbutton->setOn(true);
				//resetplanesbutton->setFixedSize(48,48);
				//resetplanesbutton->setIconSize(QSize(32,32));
				connect(resetplanesbutton, SIGNAL( clicked () ), this, SLOT( resetplanesbutton_event() ) );

				solidplanesbutton		= new QPushButton("Enable Solid \n Plane",	planes_layout );
				solidplanesbutton->setToolTip("Set the clipping plane to solid.");
				solidplanesbutton->setToggleButton(true);
				solidplanesbutton->setOn(false);
				connect(solidplanesbutton, SIGNAL( clicked () ), this, SLOT( solidplanesbutton_event() ) );
			
			Q3ButtonGroup *modify_layout = new Q3ButtonGroup( 1, Qt::Vertical, "Group: ", addrmv_layout);
				modifygroupbutton		= new QPushButton("Modify\n Group",	modify_layout );
				modifygroupbutton->setToolTip("Translate, Rotate and Scale the group.");
				modifygroupbutton->setToggleButton(true);
				modifygroupbutton->setOn(false);
				connect(modifygroupbutton, SIGNAL( clicked () ), this, SLOT( modifygroupbutton_event() ) );

		Q3ButtonGroup *labels_layout = new Q3ButtonGroup( 3, Qt::Horizontal, "Labels", this);
			vert_cb = new QCheckBox("Vertices",	 labels_layout );
			length_cb = new QCheckBox("Lengths", labels_layout );
			angle_cb = new QCheckBox("Angles",   labels_layout );
			vert_cb->setChecked(FALSE);
			length_cb->setChecked(FALSE);
			angle_cb->setChecked(FALSE);
			connect( vert_cb,	 SIGNAL( clicked() ), this, SLOT( vert_cb_event() ) );
			connect( length_cb,	 SIGNAL( clicked() ), this, SLOT( length_cb_event() ) );
			connect( angle_cb,	 SIGNAL( clicked() ), this, SLOT( angle_cb_event() ) );
			angle_cb->setDisabled(true);

		Q3ButtonGroup *measuremode_layout = new Q3ButtonGroup(6, Qt::Horizontal, "Select Measuring Mode: ", this);
		measuremode_layout->setExclusive(true);

			QPixmap pointsIcon = QPixmap( "Icons/points.png" );
			pointmode_button		= new QPushButton(pointsIcon, "",	measuremode_layout);
			pointmode_button->setToolTip("Points");
			pointmode_button->setToggleButton(true);
			pointmode_button->setOn(false);
			pointmode_button->setFixedSize(66, 66);
			pointmode_button->setIconSize(QSize(64,64));
			connect(pointmode_button, SIGNAL( clicked () ), this, SLOT( drawmode_event() ) );

			QPixmap linesIcon = QPixmap( "Icons/lines.png" );
			linemode_button		= new QPushButton(linesIcon, "",	measuremode_layout);
			linemode_button->setToolTip("Line(s)");
			linemode_button->setToggleButton(true);
			linemode_button->setOn(false);
			linemode_button->setFixedSize(66, 66);
			linemode_button->setIconSize(QSize(64,64));
			connect(linemode_button, SIGNAL( clicked () ), this, SLOT( drawmode_event() ) );

			/*QPixmap lsegmentIcon = QPixmap( "icons/big/linesegment.png" );
			lsegmentmode_button		= new QPushButton(lsegmentIcon, "",	measuremode_layout);
			lsegmentmode_button->setToolTip("Line Segments");
			lsegmentmode_button->setToggleButton(true);
			lsegmentmode_button->setOn(false);
			lsegmentmode_button->setFixedSize(66, 66);
			lsegmentmode_button->setIconSize(QSize(64,64));
			connect(lsegmentmode_button, SIGNAL( clicked () ), this, SLOT( drawmode_event() ) );
			lsegmentmode_button->hide();

			QPixmap lloopmodeIcon = QPixmap( "icons/big/lineloop.png" );
			lloopmode_button		= new QPushButton(lloopmodeIcon, "",	measuremode_layout);
			lloopmode_button->setToolTip("Line Loop");
			lloopmode_button->setToggleButton(true);
			lloopmode_button->setOn(false);
			lloopmode_button->setFixedSize(66, 66);
			lloopmode_button->setIconSize(QSize(64,64));
			connect(lloopmode_button, SIGNAL( clicked () ), this, SLOT( drawmode_event() ) );
			lloopmode_button->hide();*/
	
			QPixmap magnetlineIcon = QPixmap( "Icons/magneticlines.png" );
			magnetline_button		= new QPushButton(magnetlineIcon, "",	measuremode_layout);
			magnetline_button->setToolTip("Magnetic Lines");
			magnetline_button->setToggleButton(true);
			magnetline_button->setOn(false);
			magnetline_button->setFixedSize(66, 66);
			magnetline_button->setIconSize(QSize(64,64));
			//connect(lloopmode_button, SIGNAL( clicked () ), this, SLOT( drawmode_event() ) );

			/*QPixmap trianglesheetIcon = QPixmap( "icons/big/trianglesheet.png" );
			trianglesheet_button		= new QPushButton(trianglesheetIcon, "",	measuremode_layout);
			trianglesheet_button->setToolTip("Triangle Sheet");
			trianglesheet_button->setToggleButton(true);
			trianglesheet_button->setOn(false);
			trianglesheet_button->setFixedSize(66, 66);
			trianglesheet_button->setIconSize(QSize(64,64));
			trianglesheet_button->hide();
			//connect(lloopmode_button, SIGNAL( clicked () ), this, SLOT( drawmode_event() ) );*/

			QPixmap labellerIcon = QPixmap( "Icons/labeller.png" );
			labeller_button		= new QPushButton(labellerIcon, "",	measuremode_layout);
			labeller_button->setToolTip("Labeller");
			labeller_button->setToggleButton(true);
			labeller_button->setOn(false);
			labeller_button->setFixedSize(66, 66);
			labeller_button->setIconSize(QSize(64,64));
			labeller_button->hide();
			connect(labeller_button, SIGNAL( clicked () ), this, SLOT( drawmode_event() ) );

			/*polygon_button		= new QPushButton("2D Polygon",	measuremode_layout);
			polygon_button->setToggleButton(true);
			polygon_button->setOn(false);
			connect(polygon_button, SIGNAL( clicked () ), this, SLOT( drawmode_event() ) );

			sphere_button		= new QPushButton("Sphere",	measuremode_layout);
			sphere_button->setToggleButton(true);
			sphere_button->setOn(false);
			connect(sphere_button, SIGNAL( clicked () ), this, SLOT( drawmode_event() ) );*/

			if(measuring_drawmodes[current_listbox_index]==0) pointmode_button->setOn(true);
			else if(measuring_drawmodes[current_listbox_index]==1) linemode_button->setOn(true);
			//else if(measuring_drawmodes[current_listbox_index]==2) lsegmentmode_button->setOn(true);
			//else if(measuring_drawmodes[current_listbox_index]==3) lloopmode_button->setOn(true);
			//else if(measuring_drawmodes[current_listbox_index]==4) polygon_button->setOn(true);
			//else if(measuring_drawmodes[current_listbox_index]==5) sphere_button->setOn(true);
			else if(measuring_drawmodes[current_listbox_index]==6) magnetline_button->setOn(true);
			//else if(measuring_drawmodes[current_listbox_index]==7) trianglesheet_button->setOn(true);
			else if(measuring_drawmodes[current_listbox_index]==8) labeller_button->setOn(true);

		Q3ButtonGroup *mainpoints_layout = new Q3ButtonGroup( 1, Qt::Vertical, "Vertices: ", this);

		Q3ButtonGroup *points_layout = new Q3ButtonGroup( 2, Qt::Vertical, "Vertices: ", mainpoints_layout);

			vertices_listbox = new QListWidget(points_layout);
			//vertices_listbox->setDragDropMode(QAbstractItemView::InternalMove);
			connect(vertices_listbox, SIGNAL(itemClicked(QListWidgetItem*)), this, SLOT(vertices_clicked_slot(QListWidgetItem*)) );
			connect(vertices_listbox, SIGNAL(currentItemChanged(QListWidgetItem*,QListWidgetItem*)), this, SLOT(vertices_currentItemChanged_slot(QListWidgetItem*,QListWidgetItem*)) );

			QString pointstr, numb;


			current_measurement.clear();
			for(int i=0; i<measuring_vertices[current_listbox_index].size(); i++)
			{
				numb.setNum(i+1);
				pointstr = "p"+numb;
				vertices_listbox->insertItem(i, pointstr);
				current_measurement.push_back(measuring_vertices[current_listbox_index][i]);
			}

		Q3ButtonGroup *pointsinfo_layout = new Q3ButtonGroup( 8, Qt::Vertical, "Measurements: ", mainpoints_layout);

			name_lb = new QLabel("Count:", pointsinfo_layout);
			pnts_count = new QLineEdit("", pointsinfo_layout);
			pnts_count->setValidator(new QIntValidator(this));
			pnts_count->setMaxLength(21);
			pnts_count->setReadOnly(true);
			numb.setNum((int)current_measurement.size(),10);
			pnts_count->setText(numb);

			name_lb = new QLabel("Total-Length:", pointsinfo_layout);
			pnts_length = new QLineEdit("", pointsinfo_layout);
			pnts_length->setMaxLength(21);
			numb.setNum((double)eval_length(), 'f', 2);
			pnts_length->setText(numb);

			/*name_lb = new QLabel("Area:", pointsinfo_layout);
			pnts_area = new QLineEdit("", pointsinfo_layout);
			pnts_area->setMaxLength(21);

			numb.setNum((double)eval_area(), 'f', 4);
			pnts_area->setText(numb);

			name_lb = new QLabel("Volume:", pointsinfo_layout);
			pnts_volume = new QLineEdit("", pointsinfo_layout);
			pnts_volume->setMaxLength(21);

			numb.setNum((double)eval_sphere(), 'f', 4);
			pnts_volume->setText(numb);*/

	QPushButton *okbutton		= new QPushButton("OK",	this);
	connect(okbutton, SIGNAL( clicked () ), this, SLOT( okeditmeasurebutton_event() ) );

	QPushButton *cancelbutton		= new QPushButton("Cancel",	this);
	connect(cancelbutton, SIGNAL( clicked () ), this, SLOT( cancbutton_event() ) );

	addmeasure_layout->addWidget(name_grp);
	addmeasure_layout->addWidget(measuremode_layout);
	addmeasure_layout->addWidget(addrmv_layout);
	addmeasure_layout->addWidget(labels_layout);	
	addmeasure_layout->addWidget(mainpoints_layout);
	addmeasure_layout->addWidget(okbutton);
	addmeasure_layout->addWidget(cancelbutton);

	//emit measure_start_signal();
	emit measure_pause_signal();

	add_dialogue->show();
}
void QtMeasuringWidget::vertices_currentItemChanged_slot(QListWidgetItem* curr, QListWidgetItem* prev)
{
	int index = vertices_listbox->row(curr);
	vertices_listbox->setItemSelected(curr, true);
	printf("vertices_currentItemChanged_slot %d\n", index);
	current_vert = index;
	emit measure_selected_vertindex_signal(index);
}

void QtMeasuringWidget::vertices_clicked_slot(QListWidgetItem* item)
{
	int index = vertices_listbox->row(item);
//	printf("Clicked\n");
	printf("vertices_clicked_slot %d\n", index);
	current_vert = index;
	emit measure_selected_vertindex_signal(index);
}

void QtMeasuringWidget::drawmode_event(void)
{
	if(pointmode_button->isOn())
	{
		emit measure_update_current_drawmode_signal(0);
	}
	else if(linemode_button->isOn())
	{
		emit measure_update_current_drawmode_signal(1);
	}
	/*else if(lsegmentmode_button->isOn())
	{
		emit measure_update_current_drawmode_signal(2);
	}
	else if(lloopmode_button->isOn())
	{
		emit measure_update_current_drawmode_signal(3);
	}*/
	else if(magnetline_button->isOn())
	{
		emit measure_update_current_drawmode_signal(6);
	}
	/*else if(trianglesheet_button->isOn())
	{
		emit measure_update_current_drawmode_signal(7);
	}*/
	else if(labeller_button->isOn())
	{
		emit measure_update_current_drawmode_signal(8);
	}
	/*else if(polygon_button->isOn())
	{
		emit measure_update_current_drawmode_signal(4);
	}
	else if(sphere_button->isOn())
	{
		if(current_measurement.size()>2)
		{
			pointmode_button->setOn(true);
			emit measure_update_current_drawmode_signal(0);
			return;
		}
		else
		{
			emit measure_update_current_drawmode_signal(5);
		}
	}*/

	QString numb;
	numb.setNum(eval_length());
	pnts_length->setText(numb);

/*	numb.setNum(eval_area());
	pnts_area->setText(numb);

	numb.setNum(eval_sphere());
	pnts_volume->setText(numb);*/
}
void QtMeasuringWidget::del_event(void)
{
//	if(listbox->count()<0) return;
	if(!listbox->currentItem()) return;

	current_listbox_index = listbox->row(listbox->currentItem());
	listbox->takeItem(current_listbox_index, 0);

//	printf("index: %d\n", current_listbox_index);
//	printf("size: %d\n", measuring_vertices.size());
	
	if(current_listbox_index<measuring_vertices.size())
	{
		measuring_vertices[current_listbox_index].clear();
		measuring_edges[current_listbox_index].clear();
		measuring_vertices.erase(measuring_vertices.begin()+current_listbox_index);
		measuring_edges.erase(measuring_edges.begin()+current_listbox_index);
	}
	if(current_listbox_index<measuring_drawmodes.size())
	{
		measuring_drawmodes.erase(measuring_drawmodes.begin()+current_listbox_index);
	}
	if(current_listbox_index<measuring_planes.size())
	{
		measuring_planes.erase(measuring_planes.begin()+current_listbox_index);
	}	

	listbox->removeRow(current_listbox_index);

	emit measure_delete_item_signal(current_listbox_index);
}
void QtMeasuringWidget::add_event(void)
{
	vert_label = length_label = angle_label = 0;

	add_dialogue = new QDialog(this, "Measurement Editor", FALSE);

	emit measure_update_current_drawmode_signal(0);
	//emit measure_disableunselect_signal();	

	QString objstring, numb;
	numb.setNum(measuring_vertices.size()+1);
	objstring = "object"+numb;

	Q3BoxLayout* addmeasure_layout = new Q3BoxLayout(add_dialogue, Q3BoxLayout::TopToBottom, 4, 4, "add_dialogue_layout");

		Q3ButtonGroup *name_grp = new Q3ButtonGroup( 1, Qt::Horizontal, "", this);
			QLabel* name_lb = new QLabel("Name:	", name_grp);
			name_le = new QLineEdit(objstring, name_grp);

			Q3ButtonGroup *addrmv_layout = new Q3ButtonGroup( 3, Qt::Horizontal, "", this);
//			addrmv_layout->setExclusive(true);

			Q3ButtonGroup *pnts_layout = new Q3ButtonGroup( 1, Qt::Vertical, "Points: ", addrmv_layout);

				QPixmap addIcon = QPixmap( "icons/add.png" );
				addpntbutton		= new QPushButton(addIcon, "",	pnts_layout );
				addpntbutton->setToolTip("Add Items");
				addpntbutton->setToggleButton(true);
				addpntbutton->setOn(true);
				addpntbutton->setFixedSize(48,48);
				addpntbutton->setIconSize(QSize(32,32));
				connect(addpntbutton, SIGNAL( clicked () ), this, SLOT( addpntbutton_event() ) );

				QPixmap removeIcon = QPixmap( "icons/remove.png" );
				rmvpntbutton		= new QPushButton(removeIcon, "",	pnts_layout);
				rmvpntbutton->setToolTip("Delete Items");
				rmvpntbutton->setToggleButton(false);
				rmvpntbutton->setOn(false);
				rmvpntbutton->setFixedSize(48,48);
				rmvpntbutton->setIconSize(QSize(32,32));
				connect(rmvpntbutton, SIGNAL( clicked () ), this, SLOT( rmvpntbutton_event() ) );

			Q3ButtonGroup *planes_layout = new Q3ButtonGroup( 1, Qt::Vertical, "Planes: ", addrmv_layout);

				//QPixmap addIcon = QPixmap( "icons/add.png" );
				resetplanesbutton		= new QPushButton("Reset\n Planes",	planes_layout );
				resetplanesbutton->setToolTip("Reset the clipping planes");
				//resetplanesbutton->setToggleButton(true);
				//resetplanesbutton->setOn(true);
				//resetplanesbutton->setFixedSize(48,48);
				//resetplanesbutton->setIconSize(QSize(32,32));
				connect(resetplanesbutton, SIGNAL( clicked () ), this, SLOT( resetplanesbutton_event() ) );
				solidplanesbutton		= new QPushButton("Enable Solid \n Plane",	planes_layout );
				solidplanesbutton->setToolTip("Set the clipping plane to solid.");
				solidplanesbutton->setToggleButton(true);
				solidplanesbutton->setOn(false);
				connect(solidplanesbutton, SIGNAL( clicked () ), this, SLOT( solidplanesbutton_event() ) );

			Q3ButtonGroup *modify_layout = new Q3ButtonGroup( 1, Qt::Vertical, "Group: ", addrmv_layout);
				modifygroupbutton		= new QPushButton("Modify\n Group",	modify_layout );
				modifygroupbutton->setToolTip("Translate, Rotate and Scale the group.");
				modifygroupbutton->setToggleButton(true);
				modifygroupbutton->setOn(false);
				connect(modifygroupbutton, SIGNAL( clicked () ), this, SLOT( modifygroupbutton_event() ) );

		Q3ButtonGroup *labels_layout = new Q3ButtonGroup( 3, Qt::Horizontal, "Labels", this);
			vert_cb = new QCheckBox("Vertices",	 labels_layout );
			length_cb = new QCheckBox("Lengths", labels_layout );
			angle_cb = new QCheckBox("Angles",   labels_layout );
			vert_cb->setChecked(FALSE);
			length_cb->setChecked(FALSE);
			angle_cb->setChecked(FALSE);
			connect( vert_cb,	 SIGNAL( clicked() ), this, SLOT( vert_cb_event() ) );
			connect( length_cb,	 SIGNAL( clicked() ), this, SLOT( length_cb_event() ) );
			connect( angle_cb,	 SIGNAL( clicked() ), this, SLOT( angle_cb_event() ) );
			angle_cb->setDisabled(true);

		Q3ButtonGroup *measuremode_layout = new Q3ButtonGroup(6, Qt::Horizontal, "Measuring Mode: ", this);
		measuremode_layout->setExclusive(true);

			QPixmap pointsIcon = QPixmap( "icons/big/points.png" );
			pointmode_button		= new QPushButton(pointsIcon, "",	measuremode_layout);
			pointmode_button->setToolTip("Points");
			pointmode_button->setToggleButton(true);
			pointmode_button->setOn(true);
			pointmode_button->setFixedSize(66, 66);
			pointmode_button->setIconSize(QSize(64,64));
			connect(pointmode_button, SIGNAL( clicked () ), this, SLOT( drawmode_event() ) );

			QPixmap linesIcon = QPixmap( "icons/big/lines.png" );
			linemode_button		= new QPushButton(linesIcon, "",	measuremode_layout);
			linemode_button->setToolTip("Line(s)");
			linemode_button->setToggleButton(true);
			linemode_button->setOn(false);
			linemode_button->setFixedSize(66, 66);
			linemode_button->setIconSize(QSize(64,64));
			connect(linemode_button, SIGNAL( clicked () ), this, SLOT( drawmode_event() ) );

			/*QPixmap lsegmentIcon = QPixmap( "icons/big/linesegment.png" );
			lsegmentmode_button		= new QPushButton(lsegmentIcon, "",	measuremode_layout);
			lsegmentmode_button->setToolTip("Line Segments");
			lsegmentmode_button->setToggleButton(true);
			lsegmentmode_button->setOn(false);
			lsegmentmode_button->setFixedSize(66, 66);
			lsegmentmode_button->setIconSize(QSize(64,64));
			connect(lsegmentmode_button, SIGNAL( clicked () ), this, SLOT( drawmode_event() ) );
			lsegmentmode_button->hide();

			QPixmap lloopmodeIcon = QPixmap( "icons/big/lineloop.png" );
			lloopmode_button		= new QPushButton(lloopmodeIcon, "",	measuremode_layout);
			lloopmode_button->setToolTip("Line Loop");
			lloopmode_button->setToggleButton(true);
			lloopmode_button->setOn(false);
			lloopmode_button->setFixedSize(66, 66);
			lloopmode_button->setIconSize(QSize(64,64));
			connect(lloopmode_button, SIGNAL( clicked () ), this, SLOT( drawmode_event() ) );
			lloopmode_button->hide();
			*/

			QPixmap magnetlineIcon = QPixmap( "icons/big/magneticlines.png" );
			magnetline_button		= new QPushButton(magnetlineIcon, "",	measuremode_layout);
			magnetline_button->setToolTip("Magnetic Lines");
			magnetline_button->setToggleButton(true);
			magnetline_button->setOn(false);
			magnetline_button->setFixedSize(66, 66);
			magnetline_button->setIconSize(QSize(64,64));
			connect(magnetline_button, SIGNAL( clicked () ), this, SLOT( drawmode_event() ) );

			/*QPixmap trianglesheetIcon = QPixmap( "icons/big/trianglesheet.png" );
			trianglesheet_button		= new QPushButton(trianglesheetIcon, "",	measuremode_layout);
			trianglesheet_button->setToolTip("Triangle Sheet");
			trianglesheet_button->setToggleButton(true);
			trianglesheet_button->setOn(false);
			trianglesheet_button->setFixedSize(66, 66);
			trianglesheet_button->setIconSize(QSize(64,64));
			trianglesheet_button->hide();
			connect(trianglesheet_button, SIGNAL( clicked () ), this, SLOT( drawmode_event() ) );
			*/

			QPixmap labellerIcon = QPixmap( "icons/big/labeller.png" );
			labeller_button		= new QPushButton(labellerIcon, "",	measuremode_layout);
			labeller_button->setToolTip("Labeller");
			labeller_button->setToggleButton(true);
			labeller_button->setOn(false);
			labeller_button->setFixedSize(66, 66);
			labeller_button->setIconSize(QSize(64,64));
			labeller_button->hide();
			connect(labeller_button, SIGNAL( clicked () ), this, SLOT( drawmode_event() ) );

			/*polygon_button		= new QPushButton("2D Polygon",	measuremode_layout);
			polygon_button->setToggleButton(true);
			polygon_button->setOn(false);
			connect(polygon_button, SIGNAL( clicked () ), this, SLOT( drawmode_event() ) );

			sphere_button		= new QPushButton("Sphere",	measuremode_layout);
			sphere_button->setToggleButton(true);
			sphere_button->setOn(false);
			connect(sphere_button, SIGNAL( clicked () ), this, SLOT( drawmode_event() ) );*/

		Q3ButtonGroup *mainpoints_layout = new Q3ButtonGroup( 1, Qt::Vertical, "Vertices: ", this);
		Q3ButtonGroup *points_layout = new Q3ButtonGroup( 2, Qt::Vertical, "Vertices: ", mainpoints_layout);

			vertices_listbox = new QListWidget(points_layout);
			//vertices_listbox->setDragDropMode(QAbstractItemView::InternalMove);
			connect(vertices_listbox, SIGNAL(itemClicked(QListWidgetItem*)), this, SLOT(vertices_clicked_slot(QListWidgetItem*)) );
			connect(vertices_listbox, SIGNAL(currentItemChanged(QListWidgetItem*,QListWidgetItem*)), this, SLOT(vertices_currentItemChanged_slot(QListWidgetItem*,QListWidgetItem*)) );

		Q3ButtonGroup *pointsinfo_layout = new Q3ButtonGroup( 8, Qt::Vertical, "Measurements: ", mainpoints_layout);

			name_lb = new QLabel("Count:", pointsinfo_layout);
			pnts_count = new QLineEdit("", pointsinfo_layout);
			pnts_count->setValidator(new QIntValidator(this));
			pnts_count->setMaxLength(21);
			pnts_count->setReadOnly(true);
			numb.setNum((int)current_measurement.size(),10);
			pnts_count->setText(numb);

			name_lb = new QLabel("Total-Length:", pointsinfo_layout);
			pnts_length = new QLineEdit("", pointsinfo_layout);
			pnts_length->setMaxLength(21);
			printf("LENGTH: %f\n", eval_length());
			numb.setNum((double)eval_length(), 'f', 2);
			pnts_length->setText(numb);

			/*name_lb = new QLabel("Area:", pointsinfo_layout);
			pnts_area = new QLineEdit("", pointsinfo_layout);
			pnts_area->setMaxLength(21);

			numb.setNum((double)eval_area(), 'f', 4);
			pnts_area->setText(numb);

			name_lb = new QLabel("Volume:", pointsinfo_layout);
			pnts_volume = new QLineEdit("", pointsinfo_layout);
			pnts_volume->setMaxLength(21);

			numb.setNum((double)eval_sphere(), 'f', 4);
			pnts_volume->setText(numb);*/

	QPushButton *okbutton		= new QPushButton("OK",	this);
	connect(okbutton, SIGNAL( clicked () ), this, SLOT( okaddmeasurebutton_event() ) );

	QPushButton *cancelbutton		= new QPushButton("Cancel",	this);
	connect(cancelbutton, SIGNAL( clicked () ), this, SLOT( cancbutton_event() ) );
	
	addmeasure_layout->addWidget(name_grp);
	addmeasure_layout->addWidget(measuremode_layout);
	addmeasure_layout->addWidget(addrmv_layout);
	addmeasure_layout->addWidget(labels_layout);
	addmeasure_layout->addWidget(mainpoints_layout);
	addmeasure_layout->addWidget(okbutton);
	addmeasure_layout->addWidget(cancelbutton);

	add_dialogue->show();
	
	emit measure_start_signal();
}
void QtMeasuringWidget::solidplanesbutton_event(void)
{
	bool on;
	if(solidplanesbutton->isOn()) on = true;
	else on = false;

	emit cutplane_solid_signal(on);
}
void QtMeasuringWidget::resetplanesbutton_event(void)
{
	emit cutplane_resetall_signal();
}
void QtMeasuringWidget::cancbutton_event(void)
{
//	printf("cancel!\n");

	if(modifygroupbutton->isOn()) emit measure_modify_stop_signal();
	emit measure_labels_signal(0,0,0);

	current_measurement.clear();
	current_edgemeasurement.clear();

	emit measure_stop_signal();
	emit measure_enableunselect_signal();	
	emit measure_cancel_signal();

	add_dialogue->close();
	delete add_dialogue;
}
void QtMeasuringWidget::okeditmeasurebutton_event(void)
{
//	printf("ok edit!\n");
	if(modifygroupbutton->isOn()) emit measure_modify_stop_signal();

	emit measure_labels_signal(0,0,0);

	emit measure_enableunselect_signal();	
	int a = measuring_drawmodes[current_listbox_index];
	int b = 0;
	
	if(pointmode_button->isOn()) b = 0;
	else if(linemode_button->isOn()) b = 1;
//	else if(lsegmentmode_button->isOn()) b = 2;
//	else if(lloopmode_button->isOn()) b = 3;		
//	else if(polygon_button->isOn()) b = 4;		
//	else if(sphere_button->isOn()) b = 5;		
	else if(magnetline_button->isOn()) b = 6;
	//else if(trianglesheet_button->isOn()) b = 7;
	else if(labeller_button->isOn()) b = 8;

	QTableWidgetItem* item = listbox->item(current_listbox_index,0); 	
	item->setText(name_le->text());

	//if(measuring_vertices[current_listbox_index].size()!=vertices_listbox->count() || a!=b)
	{
		//printf("okeditmeasurebutton_event1\n");
		measuring_vertices[current_listbox_index].clear();
		measuring_vertices[current_listbox_index] = current_measurement;
		measuring_drawmodes[current_listbox_index] = b;

		emit measure_update_item_signal(current_listbox_index, current_measurement,  b);
	}

	//printf("okeditmeasurebutton_event2\n");
	emit measure_stop_signal();
	current_measurement.clear();
	current_edgemeasurement.clear();

	listbox->setCurrentCell(-1, -1);

	add_dialogue->close();
	delete add_dialogue;

	pnts_length=0;
}
void QtMeasuringWidget::okaddmeasurebutton_event(void)
{
//	printf("ok add!\n");
	if(modifygroupbutton->isOn()) emit measure_modify_stop_signal();

	emit measure_labels_signal(0,0,0);

	emit measure_enableunselect_signal();	
	measuring_vertices.push_back(current_measurement);
	
	if(pointmode_button->isOn()) measuring_drawmodes.push_back(0);
	else if(linemode_button->isOn()) measuring_drawmodes.push_back(1);
//	else if(lsegmentmode_button->isOn()) measuring_drawmodes.push_back(2);
//	else if(lloopmode_button->isOn()) measuring_drawmodes.push_back(3);
	//else if(polygon_button->isOn()) measuring_drawmodes.push_back(4);
	//else if(sphere_button->isOn()) measuring_drawmodes.push_back(5);
	else if(magnetline_button->isOn()) measuring_drawmodes.push_back(6);
//	else if(trianglesheet_button->isOn()) measuring_drawmodes.push_back(7);
	else if(labeller_button->isOn()) measuring_drawmodes.push_back(8);

//	QString objstring, numb;
//	numb.setNum(measuring_vertices.size());
//	objstring = "object"+numb;
	QString objstring = name_le->text();

	QTableWidgetItem *newItem = new QTableWidgetItem();
	newItem->setText(objstring);
	listbox->setRowCount(measuring_vertices.size());
	listbox->setItem(measuring_vertices.size()-1,0, newItem);

	newItem = new QTableWidgetItem();
	newItem->setTextAlignment(Qt::AlignCenter);
	newItem->setFlags(Qt::ItemIsUserCheckable | Qt::ItemIsEnabled);
	newItem->setCheckState(Qt::Checked);
	listbox->setItem(measuring_vertices.size()-1,1, newItem);

	emit measure_add_item_signal(current_measurement, measuring_drawmodes[measuring_drawmodes.size()-1]);
	emit measure_stop_signal();	
	
	current_measurement.clear();
	current_edgemeasurement.clear();

	listbox->setCurrentCell(-1, -1);

	add_dialogue->close();
	delete add_dialogue;

	pnts_length=0;
}
void QtMeasuringWidget::measure_update_edges_slot(int index, vector<Edge> edges)
{
	measuring_edges[index].clear();

	Edge e;
	for(int i=0; i<edges.size(); i++)
	{
		e.v0 = edges[i].v0;
		e.v1 = edges[i].v1;
		measuring_edges[index].push_back(e);
	}
}

void QtMeasuringWidget::measure_edges_slot(vector<Edge> edges)
{
	printf("Adding edges\n");
	measuring_edges.push_back(edges);
}
void QtMeasuringWidget::measure_currentverts_slot(vector<Vector> verts)
{
	printf("Updating current verts\n");

	current_measurement.clear();
	for(int i=0; i<verts.size(); i++)
	{
		current_measurement.push_back(verts[i]);
	}

	pnts_length=0;
}
void QtMeasuringWidget::measure_currentedges_slot(vector<Edge> edges)
{
	printf("Updating current edges\n");

	current_edgemeasurement.clear();
	for(int i=0; i<edges.size(); i++)
	{
		current_edgemeasurement.push_back(edges[i]);
	}

	/*if(pnts_length)
	{
		QString numb;
		numb.setNum((double)eval_length(), 'f', 2);
		pnts_length->setText(numb);
	}*/
}

void QtMeasuringWidget::okscalebutton_event(void)
{
	QString str;

	str = voxX_le->text();
	voxX = str.toFloat();

	str = voxY_le->text();
	voxY = str.toFloat();

	str = voxZ_le->text();
	voxZ = str.toFloat();

	str = unitX_le->text();
	unitX = str.toFloat();

	str = unitY_le->text();
	unitY = str.toFloat();

	str = unitZ_le->text();
	unitZ = str.toFloat();

	add_dialogue->close();
	delete add_dialogue;
	listbox->setCurrentCell(-1, -1);

	emit measure_setscale_signal(unitX/voxX, unitY/voxY, unitZ/voxZ);
}
void QtMeasuringWidget::setscale_event(void)
{
	QString str;
	add_dialogue = new QDialog(this, "Scale Editor", FALSE);

	Q3BoxLayout* scale_layout = new Q3BoxLayout(add_dialogue, Q3BoxLayout::TopToBottom, 4, 4, "scale_dialogue_layout");

		Q3ButtonGroup *scalelabels_layout = new Q3ButtonGroup( 1, Qt::Vertical, "", this);
			QLabel* axislabel = new QLabel(scalelabels_layout, 0);
			axislabel->setText("");

			QLabel* voxlabel = new QLabel(scalelabels_layout, 0);
			voxlabel->setText("Voxel(s)");

			QLabel* unitlabel = new QLabel(scalelabels_layout, 0);
			unitlabel->setText("Unit(s)");

		Q3ButtonGroup *scaleXlabels_layout = new Q3ButtonGroup( 1, Qt::Vertical, "", this);
			QLabel* axisXlabel = new QLabel(scaleXlabels_layout, 0);
			axisXlabel->setText("X: ");
	
			voxX_le = new QLineEdit(QString().setNum(voxX), scaleXlabels_layout);
			//voxX_le->setInputMask("9000.000");
			str.setNum(voxX);
			voxX_le->setText(str);

			unitX_le = new QLineEdit(QString().setNum(unitX), scaleXlabels_layout);
			//unitX_le->setInputMask("9000.000");
			str.setNum(unitX);
			unitX_le->setText(str);

		Q3ButtonGroup *scaleYlabels_layout = new Q3ButtonGroup( 1, Qt::Vertical, "", this);
			QLabel* axisYlabel = new QLabel(scaleYlabels_layout, 0);
			axisYlabel->setText("Y: ");

			voxY_le = new QLineEdit(QString().setNum(voxY), scaleYlabels_layout);
			//voxY_le->setInputMask("9000.000");
			str.setNum(voxY);
			voxY_le->setText(str);

			unitY_le = new QLineEdit(QString().setNum(unitY), scaleYlabels_layout);
			//unitY_le->setInputMask("9000.000");
			str.setNum(unitY);
			unitY_le->setText(str);

		Q3ButtonGroup *scaleZlabels_layout = new Q3ButtonGroup( 1, Qt::Vertical, "", this);
			QLabel* axisZlabel = new QLabel(scaleZlabels_layout, 0);
			axisZlabel->setText("Z: ");

			voxZ_le = new QLineEdit(QString().setNum(voxZ), scaleZlabels_layout);
			//voxZ_le->setInputMask("9000.000");
			str.setNum(voxZ);
			voxZ_le->setText(str);

			unitZ_le = new QLineEdit(QString().setNum(unitZ), scaleZlabels_layout);
			//unitZ_le->setInputMask("9000.000");
			str.setNum(unitZ);
			unitZ_le->setText(str);

	QPushButton *okbutton		= new QPushButton("OK",	this);
	connect(okbutton, SIGNAL( clicked () ), this, SLOT( okscalebutton_event() ) );

	QPushButton *cancelbutton		= new QPushButton("Cancel",	this);
	connect(cancelbutton, SIGNAL( clicked () ), this, SLOT( cancbutton_event() ) );

	scale_layout->addWidget(scalelabels_layout);
	scale_layout->addWidget(scaleXlabels_layout);
	scale_layout->addWidget(scaleYlabels_layout);	
	scale_layout->addWidget(scaleZlabels_layout);	
	scale_layout->addWidget(okbutton);
	scale_layout->addWidget(cancelbutton);

	add_dialogue->show();
}
void QtMeasuringWidget::rmvpntbutton_event(void)
{
	addpntbutton->setOn(false);
	addpntbutton_event();

	printf("QtMeasuringWidget::rmvpntbutton_event current_vert: %d\n", current_vert);
	printf("QtMeasuringWidget::rmvpntbutton_event vertices_listbox->count(): %d\n", vertices_listbox->count());

	if(current_vert==-1) return;

	if(current_vert>=0 && current_vert<vertices_listbox->count())
	{
		printf("boh\n");
		emit measure_rmv_current_verts_signal(current_vert);

		if(current_vert==1) current_measurement.erase(current_measurement.begin());
		else current_measurement.erase(current_measurement.begin()+current_vert);
		
		vertices_listbox->takeItem(current_vert);
		
		current_vert = vertices_listbox->count()-1;

		if(current_measurement.empty())vertices_listbox->clear();

		QString numb;
		numb.setNum(current_measurement.size());
		pnts_count->setText(numb);

		numb.setNum(eval_length());
		pnts_length->setText(numb);

		/*numb.setNum(eval_area());
		pnts_area->setText(numb);*/

		//emit measure_rmv_current_verts_signal(current_vert);
		//emit measure_update_current_verts_signal(current_measurement);
	}
}

void QtMeasuringWidget::addpntbutton_event(void)
{
	//if(current_drawmode==2) return;
	//rmvpntbutton->setOn(false);
	//rmvpntbutton_event();

	if(addpntbutton->isOn())
	{
		/*if(measuring_drawmodes[current_listbox_index]==1 && current_measurement.size()>=2)
		{
			addpntbutton->setOn(false);
			return;
		}*/

		emit measure_start_signal();
	}
	else
	{
		emit measure_pause_signal();
	}
}
void QtMeasuringWidget::measure_editpoint_select_slot(int index)
{
	current_vert = index;
	measure_selected_vertindex_signal(index);

	if(index>=0 && index<current_measurement.size()) vertices_listbox->setCurrentRow(index);
}
void QtMeasuringWidget::measure_editgrppoint_slot(int i, Vector v)
{
	if(i>=0 && i<=current_measurement.size())
	{
		current_measurement[i] = v;
		QString numb;
		numb.setNum(eval_length());
		pnts_length->setText(numb);

		/*numb.setNum(eval_area());
		pnts_area->setText(numb);
	
		numb.setNum(eval_sphere());
		pnts_volume->setText(numb);*/
	}
}
void QtMeasuringWidget::measure_editpoint_slot(Vector v)
{	
	if(current_vert>=0 && current_vert<=current_measurement.size())
	{
		current_measurement[current_vert] = v;
		QString numb;
		numb.setNum(eval_length());
		pnts_length->setText(numb);

		/*numb.setNum(eval_area());
		pnts_area->setText(numb);
	
		numb.setNum(eval_sphere());
		pnts_volume->setText(numb);*/
	}
}
void QtMeasuringWidget::measure_point_slot(Vector p)
{
	current_measurement.push_back(p);
	QString pointstr, numb;
	
	numb.setNum(current_measurement.size());
	pointstr = "p"+numb;

	numb.setNum(current_measurement.size());
	pnts_count->setText(numb);

	numb.setNum(eval_length());
	if(pnts_length) pnts_length->setText(numb);

/*	numb.setNum(eval_area());
	pnts_area->setText(numb);
	
	numb.setNum(eval_sphere());
	pnts_volume->setText(numb);
*/
	vertices_listbox->insertItem(current_measurement.size()-1, pointstr);

	current_vert = current_measurement.size()-1;
	printf("QtMeasuringWidget::current_vert: %d\n", current_vert);
}
void QtMeasuringWidget::measure_savecutplane_slot(int index, float translate, float rotang1, float rotang2)
{
	printf("SAVING OK\n");	

	Vector v;
	v.x = index;
	v.y = translate;
	v.z = rotang1;
	v.w = rotang2;
	
	printf("measure save slot: %d, %f, %f, %f\n", index, translate, rotang1, rotang2);
	
	measuring_planes.push_back(v);
}
void QtMeasuringWidget::measure_setspacing_slot(float x, float y, float z)
{
	spacingX = x;
	spacingY = y;
	spacingZ = z;
}
void QtMeasuringWidget::measure_setoriginalfn_slot(QString fn)
{
	originalfilename = fn;
}
float QtMeasuringWidget::eval_area(void)
{
	int n = current_measurement.size();
	float A=0.0f;
	return A;
	
	//-----------DEBUG
	//return A;

	int b = 0;	
	if(pointmode_button->isOn()) b = 0;
	else if(linemode_button->isOn()) b = 1;
	else if(lsegmentmode_button->isOn()) b = 2;
	else if(lloopmode_button->isOn()) b = 3;			
	else if(polygon_button->isOn()) b = 4;			
	else if(sphere_button->isOn()) b = 5;			

	if(b<4) return A;
	if(n<2) return A;

	if(b==5)
	{
		printf("sphere\n");
		Vector v1 = current_measurement[0];
		v1.x *= unitX/voxX;
		v1.y *= unitY/voxY;
		v1.z *= unitZ/voxZ;
		v1.x /= spacingX;
		v1.y /= spacingY;
		v1.z /= spacingZ;
		v1.x *= rescaleX;
		v1.y *= rescaleY;
		v1.z *= rescaleZ;

		Vector v2 = current_measurement[1];
		v2.x *= unitX/voxX;
		v2.y *= unitY/voxY;
		v2.z *= unitZ/voxZ;
		v2.x /= spacingX;
		v2.y /= spacingY;
		v2.z /= spacingZ;
		v2.x *= rescaleX;
		v2.y *= rescaleY;
		v2.z *= rescaleZ;

		Vector v = v1-v2;
		float radius = v.length()*0.5f;
		A = (4.0)*(PI*pow(radius,2.0f));
		
		return A;
	}

	if(n<3) return A;

	PCA pca;
	int i;
	Vector v;
	for(i=0; i<current_measurement.size(); i++)
	{
		v = current_measurement[i];
		v.x *= unitX/voxX;
		v.y *= unitY/voxY;
		v.z *= unitZ/voxZ;
		v.x /= spacingX;
		v.y /= spacingY;
		v.z /= spacingZ;
		v.x *= rescaleX;
		v.y *= rescaleY;
		v.z *= rescaleZ;

		pca.data.push_back(v);
	}

	pca.eval_PCA();
	pca.eval_aligned_data();
	
	float x, y, z;
	x=y=z=0;
	for (i=0; i<pca.aligned_data.size(); i++)
	{
		pca.aligned_data[i].round(4);
		x =+ pca.aligned_data[i].x;
		y =+ pca.aligned_data[i].y;
		z =+ pca.aligned_data[i].z;
	}

	int axis = -1;
	if(x==0) axis=0;
	else if(y==0) axis=1;
	else axis=2;

	vector < Vector > points2d;
	vector < Vector > result;

	for (i=0; i<pca.aligned_data.size(); i++)
	{
		if(axis==0) points2d.push_back(Vector(pca.aligned_data[i].y, pca.aligned_data[i].z,0,i));
		else if(axis==1) points2d.push_back(Vector(pca.aligned_data[i].x, pca.aligned_data[i].z,0,i));
		else if(axis==2) points2d.push_back(Vector(pca.aligned_data[i].x, pca.aligned_data[i].y,0,i));
	}


	for(int p=n-1,q=0; q<n; p=q++)
	{
		A+= points2d[p].x*points2d[q].y - points2d[q].x*points2d[p].y;
	}
	return abs(A*0.5f);
}
float QtMeasuringWidget::eval_sphere(void)
{
	float volume = 0;
	return volume;

	if(current_measurement.size()!=2) return volume;

	int b = 0;	
	if(pointmode_button->isOn()) b = 0;
	else if(linemode_button->isOn()) b = 1;
	else if(lsegmentmode_button->isOn()) b = 2;
	else if(lloopmode_button->isOn()) b = 3;			
	else if(polygon_button->isOn()) b = 4;			
	else if(sphere_button->isOn()) b = 5;			

	if(b!=5) return volume;

	Vector v1 = current_measurement[0];
	v1.x *= unitX/voxX;
	v1.y *= unitY/voxY;
	v1.z *= unitZ/voxZ;
	v1.x /= spacingX;
	v1.y /= spacingY;
	v1.z /= spacingZ;
	v1.x *= rescaleX;
	v1.y *= rescaleY;
	v1.z *= rescaleZ;

	Vector v2 = current_measurement[1];
	v2.x *= unitX/voxX;
	v2.y *= unitY/voxY;
	v2.z *= unitZ/voxZ;
	v2.x /= spacingX;
	v2.y /= spacingY;
	v2.z /= spacingZ;
	v2.x *= rescaleX;
	v2.y *= rescaleY;
	v2.z *= rescaleZ;

	Vector v = v1-v2;
	float radius = v.length()*0.5f;
	volume = (3.0/4.0)*(PI*pow(radius,3.0f));

	return volume;
}
float QtMeasuringWidget::eval_length(void)
{
	float length = 0;

//	if(current_measurement.size()<1) return length;

	printf("EVAL LENGTH!\n");

	/*int b = 0;	
	if(pointmode_button->isOn()) b = 0;
	else if(linemode_button->isOn()) b = 1;
	//else if(lsegmentmode_button->isOn()) b = 2;
	//else if(lloopmode_button->isOn()) b = 3;			
	//else if(polygon_button->isOn()) b = 4;			
	//else if(sphere_button->isOn()) b = 5;			
	else if(magnetline_button->isOn()) b = 6;
	//else if(trianglesheet_button->isOn()) b = 7;
	//else if(labeller_button->isOn()) b = 8;*/

	//if(b==0) return length;
	//if(b==1) return length;

	printf("unitX: %f\n",(float)unitX);
	printf("voxX: %f\n",(float)voxX);
	printf("spacingX: %f\n",(float)spacingX);
	printf("rescaleX: %f\n", (float)rescaleX);

	printf("current_measurement size: %d\n",	 current_measurement.size());
	printf("current_edgemeasurement size: %d\n", current_edgemeasurement.size());

	for(int i=0; i<current_edgemeasurement.size(); i++)
	{
		printf("edge: %d, %d\n", current_edgemeasurement[i].v0, current_edgemeasurement[i].v1);

		Vector v0 = current_measurement[current_edgemeasurement[i].v0];
		Vector v1 = current_measurement[current_edgemeasurement[i].v1];
		v0 += 4096;
		v1 += 4096;

		Vector temp = v0-v1;

		temp.x *= unitX/voxX;
		temp.y *= unitY/voxY;
		temp.z *= unitZ/voxZ;

		temp.x /= spacingX;
		temp.y /= spacingY;
		temp.z /= spacingZ;
		
		temp.x *= rescaleX;
		temp.y *= rescaleY;
		temp.z *= rescaleZ;

		length += temp.length();
	}

	printf("length: %f\n", length);
	return length;
}
float QtMeasuringWidget::eval_length(int index)
{
	printf("EVAL LENGTH2!\n");

	float length = 0.0;

	//if(measuring_vertices[index].size()<1) return length;

	int b = measuring_drawmodes[index];	
	if(b==0) return length;

	for(int i=0; i<measuring_edges[index].size(); i++)
	{
		Vector v0 = measuring_vertices[index][measuring_edges[index][i].v0];
		Vector v1 = measuring_vertices[index][measuring_edges[index][i].v1];
		v0 += 4096;
		v1 += 4096;

		Vector temp = v0-v1;

		temp.x *= unitX/voxX;
		temp.y *= unitY/voxY;
		temp.z *= unitZ/voxZ;

		temp.x /= spacingX;
		temp.y /= spacingY;
		temp.z /= spacingZ;
		
		temp.x *= rescaleX;
		temp.y *= rescaleY;
		temp.z *= rescaleZ;

		length += temp.length();
	}

	return length;
}
void QtMeasuringWidget::measure_setscale2_slot(float x, float y, float z)
{
	//printf("QtMeasuringWidget::measure_setscale_slot\n");
	voxX = 1.0;
	voxY = 1.0;
	voxZ = 1.0;

	unitX = x;
	unitY = y;
	unitZ = z;

	//printf("scale: %f %f %f\n", unitX, unitY, unitZ);
}
void QtMeasuringWidget::measure_close_slot(void)
{
	//printf("close add measure slot\n");
//	add_dialogue->close();
//	delete add_dialogue;
	
	QMessageBox* mb = new QMessageBox( "WARNING",
			"No clipping plane is currently selected! \n",QMessageBox::Warning,
			QMessageBox::Ok | QMessageBox::Default,0,0 );

	mb->exec();
	delete mb;
	
	cancbutton_event();
}
void QtMeasuringWidget::measure_setrescale_slot(float x, float y, float z)
{
	printf("rescale measurewidget: %f, %f, %f \n",x,y,z);	
	rescaleX = x;
	rescaleY = y;
	rescaleZ = z;
}
void QtMeasuringWidget::measure_setcurrentworkingdir_slot(QString dn)
{
	currentworkingdir = dn;
}
void QtMeasuringWidget::vert_cb_event(void)
{
	if(vert_cb->isChecked()) vert_label = 1;
	else vert_label = 0;
	
	emit measure_labels_signal(vert_label, length_label, angle_label);
}
void QtMeasuringWidget::length_cb_event(void)
{
	if(length_cb->isChecked()) length_label = 1;
	else length_label = 0;

	emit measure_labels_signal(vert_label, length_label, angle_label);
}
void QtMeasuringWidget::angle_cb_event(void)
{
	if(angle_cb->isChecked()) angle_label = 1;
	else angle_label = 0;

	emit measure_labels_signal(vert_label, length_label, angle_label);
}
