#ifndef QTIMEASUREWIDGET_H
#define QTIMEASUREWIDGET_H

#include <qpainter.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qslider.h>
#include <QListWidget>
#include <qimage.h>
#include <qcheckbox.h>
#include <qpushbutton.h>
#include <QDialog>
#include <QMessageBox>
#include <qlineedit.h>
#include <qcolordialog.h>
#include <QPixmap>
#include <QFileDialog>
#include <QModelIndex>
#include <QLineEdit>
#include <QDragEnterEvent>
#include <QDropEvent>
#include <QTableWidget>
#include <QHeaderView>

#include <q3buttongroup.h>
#include <q3boxlayout.h>
#include <q3dragobject.h>

#include <iostream>
#include <fstream>
#include <vector>
using namespace std;

#include "Vector.h"
#include "Tokenizer.h"
#include "PCA.h"
#include "Edge.h"

class QtMeasuringWidget: public QWidget
{
	Q_OBJECT
		
public:

	int selected;
	int lb_index;
	QTableWidget*	 listbox;

	QDialog* add_dialogue;

	QString originalfilename;
	
	QString currentworkingdir;

	QPushButton* selec;

	QLineEdit* name_le;
	QPushButton* addpntbutton;
	QPushButton* rmvpntbutton;
	QPushButton* resetplanesbutton;
	QPushButton* solidplanesbutton;

	QPushButton* pointmode_button;
	QPushButton* linemode_button;
	QPushButton* lsegmentmode_button;
	QPushButton* lloopmode_button;
	QPushButton* polygon_button;
	QPushButton* sphere_button;
	QPushButton* magnetline_button;
	QPushButton* trianglesheet_button;
	QPushButton* labeller_button;

	QPushButton* modifygroupbutton;

	QListWidget* vertices_listbox;

	QLineEdit* pnts_count;
	QLineEdit* pnts_length;
	QLineEdit* pnts_area;
	QLineEdit* pnts_volume;

	QLineEdit* voxX_le;
	QLineEdit* voxY_le;
	QLineEdit* voxZ_le;
	QLineEdit* unitX_le;
	QLineEdit* unitY_le;
	QLineEdit* unitZ_le;
	
	int vert_label;
	QCheckBox *vert_cb;
	int length_label;
	QCheckBox *length_cb;
	int angle_label;
	QCheckBox *angle_cb;

	float voxX, voxZ, voxY;
	float unitX, unitZ, unitY ;
	float rescaleX, rescaleY, rescaleZ;
	
	float spacingX, spacingY, spacingZ;

	vector< vector< Edge > > measuring_edges;
	vector< vector< Vector > > measuring_vertices;
	//measuring_objects
	vector<int> measuring_drawmodes;

	vector< Vector > current_measurement;
	vector< Edge > current_edgemeasurement;
	int current_drawmode;

	vector < Vector > measuring_planes;
	
	int current_listbox_index;
	int current_vert;

	QtMeasuringWidget(QWidget* parent = 0, const char* name = 0);
	~QtMeasuringWidget();

	void create(void);
	void reset(void);
	void rebuild(void);
	
	float eval_length(void);
	float eval_length(int index);
	float eval_sphere(void);
	float eval_area(void);

private slots:

	void open_file(QString fn);
	void open_event(void);
	void save_event(void);
	
	void drawmode_event(void);

	void setscale_event(void);
	void okscalebutton_event(void);

	void add_event(void);
	void del_event(void);
	void resetplanesbutton_event(void);
	void solidplanesbutton_event(void);

	void cancbutton_event(void);
	void okaddmeasurebutton_event(void);
	void okeditmeasurebutton_event(void);

	void addpntbutton_event(void);
	void rmvpntbutton_event(void);

	void listboxitemChanged_event(QTableWidgetItem* item);
	void listboxdoubleclick_event(QTableWidgetItem* item);
	void vertices_clicked_slot(QListWidgetItem* item);
	
	void vertices_currentItemChanged_slot(QListWidgetItem* curr, QListWidgetItem* prev);

	void modifygroupbutton_event(void);

	void vert_cb_event(void);
	void length_cb_event(void);
	void angle_cb_event(void);

public slots:
	void measure_currentedges_slot(vector<Edge> edges);
	void measure_point_slot(Vector v);
	void measure_editpoint_slot(Vector v);
	void measure_editgrppoint_slot(int i, Vector v);

	void measure_editpoint_select_slot(int index);
	void measure_setscale2_slot(float x, float y, float z);
	void measure_setspacing_slot(float x, float y, float z);
	void measure_setoriginalfn_slot(QString fn);
	void measure_savecutplane_slot(int, float, float, float);
	void measure_close_slot(void);
	void measure_setrescale_slot(float x, float y, float z);
	void measure_setcurrentworkingdir_slot(QString dn);
	
	void measure_clearcurrent_slot(void);

	void measure_edges_slot(vector<Edge> edges);
	void measure_currentverts_slot(vector<Vector> verts);

	void measure_update_edges_slot(int index, vector<Edge> edges);

	void dragndrop_slot(QString sFileName);
	void dragEnterEvent(QDragEnterEvent *event);
	void dropEvent(QDropEvent *event);

signals:
	void measure_start_signal(void);
	void measure_stop_signal(void);
	void measure_pause_signal(void);
	void measure_edit_signal(void);
	void measure_cancel_signal(void);
		 
	void measure_rmv_current_verts_signal(int);

	void measure_add_item_signal(vector< Vector > pnts, int draw_mode);
	void measure_load_item_signal(vector< Vector > pnts, vector< Edge > edges, int draw_mode);
	void measure_update_item_signal(int index, vector< Vector > pnts, int draw_mode);
	void measure_update_current_verts_signal(vector< Vector > pnts);

	void measure_delete_item_signal(int index);
	void measure_update_current_signal(int index);
	void measure_update_current_drawmode_signal(int drawmode);
	void measure_selected_vertindex_signal(int index);

	void measure_setscale_signal(float x, float y, float z);
	void measure_setcutplane_signal(int, float, float, float);
	void measure_enableunselect_signal(void);
	void measure_disableunselect_signal(void);

	void measure_update_visible_signal(int, bool);

	void measure_clearall_signal(void);

	void measure_modify_start_signal(void);
	void measure_modify_stop_signal(void);

	void cutplane_resetall_signal(void);
	void cutplane_solid_signal(bool on);

	void measure_labels_signal(int, int, int);
};

#endif // QTIMEASUREWIDGET_H
