#include "QtNetworkClient.h"

QtNetworkClient::QtNetworkClient(QWidget *parent, Qt::WFlags flags)
	: QMainWindow(parent, flags)
{
	/*QWidget* widg = new QWidget();
	setCentralWidget(widg);

	serveraddress_lineedit = new QLineEdit(this);
	serveraddress_lineedit->insert("149.155.218.32");
	connect(serveraddress_lineedit, SIGNAL(textChanged(QString)), this, SLOT(serveraddressChanged(QString)));

	serverport_lineedit = new QLineEdit(this);
	serverport_lineedit->insert("54623");
	connect(serverport_lineedit, SIGNAL(textChanged(QString)), this, SLOT(serverportChanged(QString)));
	
	button = new QPushButton("Connect", this);
	connect(button, SIGNAL(pressed()), this, SLOT(button_pressed()));

	QHBoxLayout* hboxlayout = new QHBoxLayout(this);
	hboxlayout->addWidget(serveraddress_lineedit, 0, Qt::AlignRight);
	hboxlayout->addWidget(serverport_lineedit, 0, Qt::AlignLeft);
	hboxlayout->addWidget(button, 0, Qt::AlignLeft);

	QVBoxLayout* vboxlayout = new QVBoxLayout(centralWidget());
	vboxlayout->addLayout(hboxlayout);

    //tcp socket setup
    tcpSocket = new QTcpSocket(this);
	connect(tcpSocket, SIGNAL(readyRead()), this, SLOT(readyRead()));

	hostaddress.setAddress(serveraddress_lineedit->text());

    tcpSocket->abort();
	tcpSocket->connectToHost(hostaddress, serverport_lineedit->text().toInt(), QIODevice::ReadWrite);

    header_read = 0;
    header_string = "";    
    header_size = 0;    
    metadata_size = 0;    
	imgdata_size = 0;
	zhelper=0;*/
}

QtNetworkClient::~QtNetworkClient()
{
    tcpSocket->abort();
	tcpSocket->connectToHost(hostaddress, serverport_lineedit->text().toInt(), QIODevice::ReadWrite);
}
void QtNetworkClient::button_pressed()
{
	printf("Trying to connect to server\n");
    tcpSocket->abort();
	tcpSocket->connectToHost(hostaddress, serverport_lineedit->text().toInt(), QIODevice::ReadWrite);
}
void QtNetworkClient::serveraddressChanged(QString text)
{
	hostaddress.setAddress(serveraddress_lineedit->text());
    tcpSocket->abort();
	tcpSocket->connectToHost(hostaddress, serverport_lineedit->text().toInt(), QIODevice::ReadWrite);
}
void QtNetworkClient::serverportChanged(QString text)
{
    tcpSocket->abort();
	tcpSocket->connectToHost(hostaddress, serverport_lineedit->text().toInt(), QIODevice::ReadWrite);
}
        
void QtNetworkClient::readyRead()
{
	//printf("readyRead() \n");

    QDataStream in(tcpSocket);
	in.setVersion(QDataStream::Qt_4_0);
    
    //have we read our packet header, telling us what we are reading...
    if (header_read == 0)
    {
        printf("Reading header...\n");

        //no, then
        //do we have a size for the header we are expecting?
        if(header_size==0)
        {
            //no then read the header size we expect to find
            printf("Reading header size...\n");
            in >> header_size;
        }
        
        //now dont continue until we have recieved the whole header
        while (tcpSocket->bytesAvailable() < header_size) 
        {
            //just in case we idle for too long...
            if (!tcpSocket->waitForReadyRead(5000)) 
            {
                printf("Client Socket Timeout\n");
                return;
            }
        }
        
        //now it's safe, we have all the data,
        //so read in the header...
        in >> header_string;
		printf("header_string: %s\n", header_string.latin1());
        header_read=1;
    }

    //if we have read a header, then proceed to read some actual data
    if(header_read==1)
    {
        if(header_string == "IMAGEMETA")
        {
            //do we know how big our metadata should be?
            if(metadata_size==0)
            {
                //if no then read it in...
                printf("Reading image metadata size...\n");               
                in >> metadata_size;                    
            }
            
            //now lets get ready to recieve the metadata...
            printf("reading image metadata .");
            
            //dont continue until we have recieved the whole image meta...
            while (tcpSocket->bytesAvailable() < metadata_size) 
            {
                printf(".");
                
                //just in case we idle for too long...
                if (!tcpSocket->waitForReadyRead(5000)) 
                {
                    printf("Client Socket Timeout\n");
                    return;
                }   
            }
            printf("\n");
            
            //now we recieved all the data, parse it in to our
            //variables...
            
            in >> x;
            in >> y;
            in >> z;
            in >> c;
            in >> t;
		
            printf("metadata(%d,%d,%d,%d,%d)\n", x,y,z,c,t);
            
            metadata_size=0;
            imgdata_size=0;
            header_read=0;
            header_string="";
            header_size=0;
			zhelper=0;
			emit ome_allocate_memory_signal(x,y,z,c,t);
        }     	
        if(header_string == "IMAGEDATA")
        {
            //do we know the size of the image we are expecting to recieve?
            if(imgdata_size==0)
            {
                //if no then read it in...
                printf("Reading image size...\n");               
                in >> imgdata_size;
            }

            //now lets get ready to recieve the image...
            printf("Reading image.");               
            
            //dont continue until we have recieved the whole image...
            while (tcpSocket->bytesAvailable() < imgdata_size) 
            {
                printf(".");
                
                //just in case we idle for too long...
                if (!tcpSocket->waitForReadyRead(5000)) 
                {
                    printf("Client Socket Timeout\n");
                    return;
                }   
            }
			printf("\n");

            //we now have read in the whole image, 
            //so save it in a qpixmap

			in >> pixmap;
			printf("image: %d x %d\n", pixmap.width(), pixmap.height());
            
			zhelper++;

            //reset our helper variables...
            metadata_size=0;
            imgdata_size=0;
            header_read=0;
            header_string="";
            header_size=0;

			printf("zhelper %d\n", zhelper);

			if(zhelper>z-1) emit ome_finished_signal();
			else emit ome_load_signal(zhelper, pixmap);

        }
    }	
}
