#ifndef QTNETWORKCLIENT_H
#define QTNETWORKCLIENT_H

#include <QtGui/QMainWindow>

#include <QTcpSocket>
#include <QPixmap>
#include <QLabel>
#include <QHBoxLayout>
#include <QVBoxLayout>
#include <QHostAddress>
#include <QMessageBox>
#include <QLineEdit>
#include <QPushButton>
#include <QProgressDialog>

#include "VolIO.h"

class QtNetworkClient : public QMainWindow
{
	Q_OBJECT

public:

    QPixmap pixmap;
    QLabel* label;
    int x,y,z,c,t;
    
    int header_read;
    QString header_string;    
    int header_size;    
    int metadata_size;    
    int imgdata_size;

	int zhelper;
	//pointer to our volume object
	VolIO* volio;

    QTcpSocket* tcpSocket;
 	QHostAddress hostaddress;
    QLineEdit* serveraddress_lineedit;
    QLineEdit* serverport_lineedit;
	QPushButton* button;
	QProgressDialog* progress;

	QtNetworkClient(QWidget *parent = 0, Qt::WFlags flags = 0);
	~QtNetworkClient();

private slots:

	void readyRead();
	void serveraddressChanged(QString text);
	void serverportChanged(QString text);
	void button_pressed();

signals:

	void ome_allocate_memory_signal(int x, int y, int z, int c, int t);
	void ome_load_signal(int index, QPixmap pix);
	void ome_finished_signal();
};

#endif // QTNETWORKCLIENTC_H
