#include "QtSliceFrame.h"
//Added by qt3to4:
#include <QPixmap>
#include <QResizeEvent>
#include <QEvent>
#include <QLabel>
#include <QMouseEvent>
#include <Q3Frame>
#include <QPaintEvent>

QtSliceFrame::QtSliceFrame(QWidget* parent, const char* name): QLabel( parent, name )
{
	setMouseTracking(true);
	//setBackgroundMode(Qt::NoBackground);
	setFrameStyle(QFrame::StyledPanel);
	x = y = z = 0;
	selected = 0;
	slices=1;

	create();
}

QtSliceFrame::~QtSliceFrame()
{
}
void QtSliceFrame::create(void)
{
	//pp->flush();
	setFrameStyle( Q3Frame::Sunken | Q3Frame::Panel );
    setLineWidth( 2 );
	setAlignment( Qt::AlignCenter );
    setMargin( 0 );
	setScaledContents(false);
	setMinimumSize(128, 128);

	QSizePolicy* sizepolicy = new QSizePolicy(QSizePolicy::Minimum, QSizePolicy::Minimum);
	sizepolicy->setHeightForWidth(true);
	setSizePolicy(*sizepolicy);

	slice_pixmap = new QPixmap(128, 128);
	slice_pixmap->fill(Qt::black);
}
void QtSliceFrame::draw_xy(QPainter* pp)
{
	//draw our pixmap
	pp->drawPixmap(0, 0, width(), height(), *slice_pixmap);

	//draw our x, y lines
	if(x!=0 || y!=0 && slices==1)
	{
		if(slices==1)
		{
			pp->setPen(Qt::red);
			pp->drawLine(0, ((float)y/(float)slice_pixmap->height()) * (float)height(), width(), ((float)y/(float)slice_pixmap->height()) * (float)height());
			
			pp->setPen(qRgb(128,128,255));
			pp->drawLine( (float)x/(float)slice_pixmap->width() * (float)width(), 0, (float)x/(float)slice_pixmap->width() * (float)width(), height());
		}
	}

	//draw rectangle around frame
	pp->setPen(QPen(Qt::green, 3.0));
	pp->drawRect(1.5, 1.5, width()-3.0, height()-3.0);

	if(selected)
	{
		if(z==oldz)
		{
			//cursor
			int x_ = ((float)mouse_x/(float)slice_pixmap->width()) * width();
			int y_ = ((float)mouse_y/(float)slice_pixmap->height()) * height();
			pp->setPen(Qt::yellow);
			pp->drawLine(x_ -5, y_ , x_ +5, y_ );
			pp->drawLine(x_ , y_ -5, x_ , y_ +5);
		}
	}
}
void QtSliceFrame::draw_xz(QPainter* pp)
{	
	//draw our pixmap
	pp->drawPixmap(0, 0, width(), height(), *slice_pixmap);

	//draw our x , z lines
	if(x!=0 || z !=0)
	{
		if(slices==1)
		{
			pp->setPen(Qt::green);
			pp->drawLine(0, ((float)z/(float)slice_pixmap->height()) * (float)height(), width(), ((float)z/(float)slice_pixmap->height()) * (float)height());
			
			pp->setPen(qRgb(128,128,255));
			pp->drawLine( ((float)x/(float)slice_pixmap->width()) * (float)width(), 0, ((float)x/(float)slice_pixmap->width()) * (float)width(), height());


			/*pp->drawLine(0, z, slice_pixmap->width(), z);
			pp->setPen(qRgb(128,128,255));
			pp->drawLine(x, 0, x, slice_pixmap->height());*/
		}
	}

	//draw rectangle around frame
	pp->setPen(QPen(Qt::red, 3.0));
	pp->drawRect(1.5, 1.5, width()-3.0, height()-3.0);

	if(selected)
	{
		if(y==oldy)
		{
			//cursor
			int x_ = ((float)mouse_x/(float)slice_pixmap->width()) * width();
			int y_ = ((float)mouse_y/(float)slice_pixmap->height()) * height();
			pp->setPen(Qt::yellow);
			pp->drawLine(x_ -5, y_ , x_ +5, y_ );
			pp->drawLine(x_ , y_ -5, x_ , y_ +5);
		}
	}
}
void QtSliceFrame::draw_yz(QPainter* pp)
{
	//draw our pixmap
	pp->drawPixmap(0, 0, width(), height(), *slice_pixmap);

	//draw out y, z lines
	if(y!=0 || z!=0)
	{
		if(slices==1)
		{
			pp->setPen(Qt::green);
			pp->drawLine(0, ((float)z/(float)slice_pixmap->height()) * (float)height(), width(), ((float)z/(float)slice_pixmap->height()) * (float)height());
			pp->setPen(Qt::red);
			pp->drawLine( ((float)y/(float)slice_pixmap->height()) * (float)width(), 0, ((float)y/(float)slice_pixmap->height()) * (float)width(), height());

/*			pp->drawLine(0, z, slice_pixmap->width(), z);
			pp->setPen(Qt::red);
			pp->drawLine(y, 0, y, slice_pixmap->height());
			*/
		}
	}
	
	//draw rectangle around frame
//	pp->setPen(QPen(qRgb(128,128,255)));
	pp->setPen(QPen(Qt::blue, 3.0));
	pp->drawRect(1.5, 1.5, width()-3.0, height()-3.0);
	
	if(selected)
	{
		if(x==oldx)
		{
			//cursor
			int x_ = ((float)mouse_x/(float)slice_pixmap->width()) * width();
			int y_ = ((float)mouse_y/(float)slice_pixmap->height()) * height();
			pp->setPen(Qt::yellow);
			pp->drawLine(x_ -5, y_ , x_ +5, y_ );
			pp->drawLine(x_ , y_ -5, x_ , y_ +5);
		}
	}
}
void QtSliceFrame::draw(QPainter* pp)
{
	if(mode==0)
	{
		draw_xy(pp);
	}
	if(mode==1)
	{
		draw_xz(pp);
	}
	if(mode==2)
	{
		draw_yz(pp);
	}
}

void QtSliceFrame::paintEvent( QPaintEvent *e )
{	
	QPainter pp(this);
	draw(&pp);
}

void QtSliceFrame::resizeEvent( QResizeEvent * e )
{
	update();
}

void QtSliceFrame::mouseMoveEvent  ( QMouseEvent * e )
{
	float x = e->x();
	float y = e->y();
}
void QtSliceFrame::mousePressEvent  ( QMouseEvent * e )
{	
	mouse_x = e->x();
	mouse_y = e->y();

	float r,g,b;

	if ((e->button()&Qt::LeftButton)) 
	{ 

		int x_ = (float)mouse_x/width() * slice_pixmap->width();
		int y_ = (float)mouse_y/height() * slice_pixmap->height();

		mouse_x = x_;
		mouse_y = y_;

		QImage img = slice_pixmap->convertToImage();
		QRgb pixel = img.pixel((int)x_,(int)y_);
		
		r = qRed(pixel);
		g = qGreen(pixel);
		b = qBlue(pixel);
		
		img.reset();

		oldx = x;
		oldy = y;
		oldz = z;

		emit sliceframe_pixel_signal(x,y,z, r,g,b, mouse_x, mouse_y, width(), height());
		
		//let frame know its the seleceted one
		selected = 1;
		//and tell all others about it
		emit sliceframe_selected_signal(mode);

		mouse_x = x_;
		mouse_y = y_;

		update();
	}
	else if ((e->button()&Qt::MidButton)) 
	{
	}
	else if ((e->button()&Qt::RightButton)) 
	{
		//emit end_linesegment_signal();
	}
}
void QtSliceFrame::mouseReleaseEvent(QMouseEvent * e )
{	
	if ((e->state()&QEvent::MouseButtonRelease))
	{
	}	
}

void QtSliceFrame::sliceframe_selected_slot(int current)
{
	//printf("current: %d\n", current);
	//cout<<"current: "<<current<<endl;
	
	selected = 0;
	oldx = -1;
	oldy = -1;
	oldz = -1;

	update();
}