#ifndef QTSLICEFRAME_H
#define QTSLICEFRAME_H

#include <qpainter.h>
#include <qpixmap.h>
#include <qlabel.h>
#include <qcursor.h>
#include <qimage.h>
//Added by qt3to4:
#include <QPaintEvent>
#include <QResizeEvent>
#include <QMouseEvent>

#include <iostream>

class QtSliceFrame: public QLabel
{
	Q_OBJECT
		
public:

	//which slice is selected, (for 3d cursor)
	int selected;

	//do we have slice on or off?
	int slices;

	//mode, what type of slice are we
	int mode;

	//x,y,z coords of voxel space
	int x, y, z;
	int oldx, oldy, oldz;
	
	int mouse_x, mouse_y;

	QPixmap* slice_pixmap;

	QtSliceFrame(QWidget* parent=0, const char* name=0);
	~QtSliceFrame();

	void create(void);
	void draw(QPainter* pp);
	void draw_xy(QPainter* pp);
	void draw_xz(QPainter* pp);
	void draw_yz(QPainter* pp);

protected:
	void mouseMoveEvent   ( QMouseEvent * e );
	void mousePressEvent  ( QMouseEvent * e );
	void mouseReleaseEvent(QMouseEvent * e );
    void paintEvent( QPaintEvent * pe);
	void resizeEvent( QResizeEvent * e );

private slots:
	void sliceframe_selected_slot(int);

signals:
	void sliceframe_selected_signal(int);
	void sliceframe_pixel_signal(int,int,int,int,int,int,int,int,int,int);

};

#endif // QTHISTOGRAM_H
