#include "QtTransferFunctionWidget.h"
//Added by qt3to4:
#include <Q3Frame>
#include <QPixmap>
#include <QLabel>

QtTransferFunctionWidget::QtTransferFunctionWidget(QWidget* parent, const char* name )
: QWidget( parent, name )
{
/*	QSizePolicy sizepolicy;
	sizepolicy.setHeightForWidth(TRUE);
	setSizePolicy(sizepolicy);
	*/
	transfer_mode = 1;
	channel_selected=0;
	channelmode_selected=0;

	threshmin = 0;
	threshmax = 255;
	brightness = 100;
	contrast = 100;
	updating_labels=0;
	setAcceptDrops(true);
}

QtTransferFunctionWidget::~QtTransferFunctionWidget()
{
	hist=NULL;
}
void QtTransferFunctionWidget::dragndrop_slot(QString sFileName)
{	
	if (!sFileName.isEmpty()) 
	{
		if(sFileName.contains(".tfn", true) || sFileName.contains(".TFN", true)) 
		{
			setCursor(QCursor(Qt::waitCursor));
			hist->loadfile(sFileName);
			setCursor(QCursor(Qt::waitCursor));

			emit hist->reload_transfer_function_parameters();
			hist->emit_tfunc_reloadall();

			histcb->setChecked(TRUE);
			tfuncb->setChecked(TRUE);
			cumfcb->setChecked(FALSE);	
			channel_button_event(channel_selected);	
			setCursor(QCursor(Qt::arrowCursor));
		}
	}
}
void QtTransferFunctionWidget::dragEnterEvent(QDragEnterEvent* event)
{
	event->accept(Q3TextDrag::canDecode(event));
}
void QtTransferFunctionWidget::dropEvent(QDropEvent* event)
{
	Q3StrList URIs;

	if ( Q3UriDrag::decode(event, URIs) ) 
	{
		QString text = Q3UriDrag::uriToLocalFile(URIs.getFirst());
		dragndrop_slot(text);
	}
}
void QtTransferFunctionWidget::create(void)
{    
	hist = new QtHistogram(this, "histogram", 256);
	//transferfunc16bit_dialogue = new QtTransferFuncDialogue(this, "QtTransferFuncDialogue", false);

	opensave_grp = new Q3ButtonGroup( 1, Qt::Horizontal, "File:", this );
    opensave_grp->setExclusive( FALSE );
	opensave_grp->setAlignment(Qt::AlignLeft);

		QPushButton* open = new QPushButton(QIcon(QPixmap("icons/fileopen.xpm")), "Open", opensave_grp, "open");
		//open->setSizePolicy(QSizePolicy(QSizePolicy::Maximum, QSizePolicy::Maximum, false));
		connect( open, SIGNAL( clicked () ), this, SLOT( open_event() ) );
		QPushButton* save = new QPushButton(QIcon(QPixmap("icons/filesave.xpm")), "Save", opensave_grp, "save");
		//save->setSizePolicy(QSizePolicy(QSizePolicy::Maximum, QSizePolicy::Maximum, false));
		connect( save, SIGNAL( clicked () ), this, SLOT( save_event() ) );

	toggle_grp = new Q3ButtonGroup( 1, Qt::Vertical, "Channels:", this);
    toggle_grp->setExclusive( TRUE );
	toggle_grp->setAlignment(Qt::AlignLeft);
	connect( toggle_grp, SIGNAL( clicked (int) ), this, SLOT( channel_button_event(int) ) );

		intensity_pb = new QPushButton("I", toggle_grp);
		intensity_pb->setToggleButton(TRUE);
		intensity_pb->setOn(TRUE);
		intensity_pb->setMaximumWidth(42);
		intensity_pb->setSizePolicy(QSizePolicy(QSizePolicy::Maximum, QSizePolicy::Maximum, false));

		red_pb = new QPushButton("R", toggle_grp);
		red_pb->setToggleButton(TRUE);
		red_pb->setOn(FALSE);
		red_pb->setPaletteForegroundColor(Qt::red); 
		red_pb->setSizePolicy(QSizePolicy(QSizePolicy::Maximum, QSizePolicy::Maximum, false));
		red_pb->setMaximumWidth(42);

		green_pb = new QPushButton("G", toggle_grp);
		green_pb->setToggleButton(TRUE);
		green_pb->setOn(FALSE);
		green_pb->setPaletteForegroundColor(QColor(0,128,0)); 
		green_pb->setSizePolicy(QSizePolicy(QSizePolicy::Maximum, QSizePolicy::Maximum, false));
		green_pb->setMaximumWidth(42);

		blue_pb = new QPushButton("B", toggle_grp);
		blue_pb->setToggleButton(TRUE);
		blue_pb->setOn(FALSE);
		blue_pb->setPaletteForegroundColor(Qt::blue); 
		blue_pb->setSizePolicy(QSizePolicy(QSizePolicy::Maximum, QSizePolicy::Maximum, false));
		blue_pb->setMaximumWidth(42);

    channelmode_grp = new Q3ButtonGroup( 1, Qt::Vertical, "Channel Mode:", this);
    channelmode_grp->setExclusive( TRUE );
	channelmode_grp->setAlignment(Qt::AlignLeft);
	connect( channelmode_grp, SIGNAL( clicked (int) ), this, SLOT( channelmode_button_event(int) ) );
		
		luminance_pb = new QPushButton("Luminance", channelmode_grp);
		luminance_pb->setToggleButton(TRUE);
		luminance_pb->setOn(FALSE);

		opacity_pb = new QPushButton("Opacity", channelmode_grp);
		opacity_pb->setToggleButton(TRUE);
		opacity_pb->setOn(TRUE);

	reset_grp = new Q3ButtonGroup( 2, Qt::Horizontal, "Reset:", this );

		QPushButton* resetcurr_button = new QPushButton("Reset Current", reset_grp, "restcurr");
		resetcurr_button->setSizePolicy(QSizePolicy(QSizePolicy::Minimum, QSizePolicy::Minimum, false));
		connect( resetcurr_button, SIGNAL( clicked() ), this, SLOT(resetcurr_button_action() ) );

		QPushButton* resetall_button = new QPushButton("Reset All", reset_grp, "restcurr");
		resetall_button->setSizePolicy(QSizePolicy(QSizePolicy::Minimum, QSizePolicy::Minimum, false));
		connect( resetall_button, SIGNAL( clicked() ), this, SLOT(resetall_button_action() ) );

	/*tfunc16bit_grp = new Q3ButtonGroup( 1, Qt::Horizontal, "16bit to 8bit Mapping:", this );
    tfunc16bit_grp->setExclusive( false );
	tfunc16bit_grp->setAlignment(Qt::AlignLeft);

		remap_button = new QPushButton("Transfer Function", tfunc16bit_grp, "invert");
		remap_button->setToggleButton(false);
		connect( remap_button, SIGNAL( pressed() ), this, SLOT(remap_button_action() ) );*/

	//action group
	action_grp = new Q3ButtonGroup( 1, Qt::Horizontal, "Actions:", this );
    action_grp->setExclusive( false );
	action_grp->setAlignment(Qt::AlignLeft);
	
		collapse_button = new QPushButton("Collapse to I", action_grp, "collapse");
		collapse_button->setToggleButton(false);
		connect( collapse_button, SIGNAL( pressed() ), this, SLOT(collapse_button_action() ) );
/*
		convR_button = new QPushButton("Convert to R", action_grp, "convR");
		convR_button->setToggleButton(false);
		connect( convR_button, SIGNAL( pressed() ), this, SLOT(convR_button_action() ) );

		convG_button = new QPushButton("Convert to G", action_grp, "convG");
		convG_button->setToggleButton(false);
		connect( convG_button, SIGNAL( pressed() ), this, SLOT(convG_button_action() ) );

		convB_button = new QPushButton("Convert to B", action_grp, "convB");
		convB_button->setToggleButton(false);
		connect( convB_button, SIGNAL( pressed() ), this, SLOT(convB_button_action() ) );
*/
		invert_button = new QPushButton("Invert Current", action_grp, "invert");
		invert_button->setToggleButton(true);
		connect( invert_button, SIGNAL( pressed() ), this, SLOT(invert_button_action() ) );

		//button group to toggle on/off viewing on histrogram
		// ( HISTOGRAM, CUMMALATATIVE FREQUENCY, TRANSFER FUNCTION)
		view_grp = new Q3ButtonGroup( 3, Qt::Horizontal, "View:", this);
			
			histcb = new QCheckBox("Histogram",	   view_grp );
			cumfcb = new QCheckBox("CumFrequency", view_grp );
			tfuncb = new QCheckBox("TransferFunc", view_grp );
			histcb->setChecked(TRUE);
			tfuncb->setChecked(TRUE);
			cumfcb->setChecked(FALSE);
			connect( histcb,	 SIGNAL( clicked() ), this, SLOT( histoview_action() ) );
			connect( cumfcb,	 SIGNAL( clicked() ), this, SLOT( cumfreview_action() ) );
			connect( tfuncb,	 SIGNAL( clicked() ), this, SLOT( transferfun_action() ) );

		update_grp = new Q3ButtonGroup( 2, Qt::Horizontal, "Histogram:", this);
			
			updatehistcb = new QCheckBox("Update",	   update_grp);
			updatehistcb->setChecked(FALSE);
			connect( updatehistcb,	 SIGNAL( clicked() ), this, SLOT( updatehisto_action() ) );
			updatehisto_action();

			logscalehistcb = new QCheckBox("Log Scale",	   update_grp);
			logscalehistcb->setChecked(TRUE);
			connect( logscalehistcb,	 SIGNAL( clicked() ), this, SLOT( logscalehistcb_action() ) );
			logscalehistcb_action();

		mapping_grp = new Q3ButtonGroup( 2, Qt::Horizontal, "Mapping:", this);
		mapping_grp->setExclusive( true );

			linearmapcb = new QCheckBox("Linear",	   mapping_grp);
			linearmapcb->setChecked(FALSE);
			connect( linearmapcb,	 SIGNAL( clicked() ), this, SLOT( linearmapcb_action() ) );
			linearmapcb_action();

			bsplinecb = new QCheckBox("B-Spline",	   mapping_grp);
			bsplinecb->setChecked(TRUE);
			connect( bsplinecb,	 SIGNAL( clicked() ), this, SLOT( bsplinecb_action() ) );
			bsplinecb_action();
		/*	sliceupdate_button = new QPushButton("Update Sections", action_grp, "sliceupdate_button");
		if(hist->slice_toggle) sliceupdate_button->setToggleButton(TRUE);
		else sliceupdate_button->setToggleButton(FALSE);

		sliceupdate_button->setOn(TRUE);
		connect( sliceupdate_button, SIGNAL( clicked() ), this, SLOT(slice_update_button_action() ) );
*/

		/*histequ_button = new QPushButton("Hist. Equalisation", action_grp, "histequ");
		histequ_button->setToggleButton(true);
		connect( histequ_button, SIGNAL( pressed() ), this, SLOT(histequ_button_action() ) );

		contstrat_button = new QPushButton("Cont. Stretching", action_grp, "contstrat");
		contstrat_button->setToggleButton(true);
		connect( contstrat_button, SIGNAL( pressed() ), this, SLOT(contstrat_button_action() ) );*/

	//threshold slider group
	threshold_grp = new Q3ButtonGroup( 1, Qt::Horizontal, "", this );
    threshold_grp->setExclusive( FALSE );

		threshmin_lb = new QLabel( "Min. Threshold:	0", threshold_grp );
		//our min threshold slider
		threshmin_slider = new QSlider ( 0, 255, 1, 0, Qt::Horizontal, threshold_grp, "threshmin_slider" );
		threshmin_slider->setTickmarks( QSlider::Below );
		threshmin_slider->setTracking(FALSE);
		threshmin_slider->setTickInterval(8);
		connect( threshmin_slider, SIGNAL(valueChanged(int)), this, SLOT(threshmin_action(int)) );
		connect( threshmin_slider, SIGNAL(sliderReleased()), this, SLOT(released_slider_slot()) );
		
		threshmax_lb = new QLabel( "Max. Threshold:	255", threshold_grp );
		//our max threshold slicer
		threshmax_slider = new QSlider ( 0, 255, 1, 255, Qt::Horizontal, threshold_grp, "threshmax_slider" );
		threshmax_slider->setTickmarks( QSlider::Below );
		threshmax_slider->setTracking(FALSE);
		threshmax_slider->setTickInterval(8);
		connect( threshmax_slider, SIGNAL(valueChanged(int)), this, SLOT(threshmax_action(int)) );
		connect( threshmax_slider, SIGNAL(sliderReleased()), this, SLOT(released_slider_slot()) );

	//brightness & contrast slider group
	briconslider_grp = new Q3ButtonGroup( 1, Qt::Horizontal, "", this );
	briconslider_grp->setAlignment(Qt::AlignLeft);
	briconslider_grp->setExclusive( FALSE );

			Q3ButtonGroup* bri_grp = new Q3ButtonGroup( 1, Qt::Horizontal, "", briconslider_grp );
			bri_grp->setExclusive( FALSE );

				QLabel* brightnesstext_lb = new QLabel( "Bright.", bri_grp );
				brightness = 100;
				//our min threshold slider
				brightness_slider = new QSlider ( 0, 200, 1, 100, Qt::Vertical, bri_grp, "threshmin_slider" );
				brightness_slider->setInvertedAppearance(true);
				brightness_slider->setInvertedControls(true);
				brightness_slider->setTickmarks( QSlider::TicksRight );
				brightness_slider->setTracking(FALSE);
				brightness_slider->setTickInterval(10);
				connect( brightness_slider, SIGNAL(valueChanged(int)), this, SLOT(brightness_action(int)) );
				connect( brightness_slider, SIGNAL(sliderReleased()), this, SLOT(released_slider_slot()) );
				brightness_lb = new QLabel( "100%", bri_grp );

			Q3ButtonGroup* con_grp = new Q3ButtonGroup( 1, Qt::Horizontal, "", briconslider_grp );
			con_grp->setExclusive( FALSE );

				QLabel* contrasttext_lb = new QLabel( "Cont.", con_grp );
				contrast = 100;
				//our max threshold slicer
				contrast_slider = new QSlider ( 0, 200, 1, 100, Qt::Vertical, con_grp, "threshmax_slider" );
				contrast_slider->setInvertedAppearance(true);
				contrast_slider->setTickmarks( QSlider::TicksRight );
				contrast_slider->setInvertedControls(true);
				contrast_slider->setTracking(FALSE);
				contrast_slider->setTickInterval(10);
				connect( contrast_slider, SIGNAL(valueChanged(int)), this, SLOT(contrast_action(int)) );
				connect( contrast_slider, SIGNAL(sliderReleased()), this, SLOT(released_slider_slot()) );
				contrast_lb = new QLabel( "100%", con_grp );

			/*
			Q3ButtonGroup *curvepoints_grid = new Q3ButtonGroup( 1, Qt::Vertical, "Control Points:", this );
			curvepoints_grid->setExclusive(TRUE);

				QPushButton* movepoint_button = new QPushButton("<->", curvepoints_grid, "restcurr");
				movepoint_button->resize(16,16);
				movepoint_button->setToggleButton(TRUE);
				movepoint_button->setOn(TRUE);
				connect( movepoint_button, SIGNAL( clicked() ), this, SLOT(resetcurr_button_action() ) );

				QPushButton* addpoint_button = new QPushButton("+", curvepoints_grid, "restcurr");
				addpoint_button->resize(16,16);
				addpoint_button->setToggleButton(TRUE);
				addpoint_button->setOn(FALSE);
				connect( addpoint_button, SIGNAL( clicked() ), this, SLOT(resetcurr_button_action() ) );

				QPushButton* deletepoint_button = new QPushButton("-", curvepoints_grid, "restcurr");
				deletepoint_button->resize(16,16);
				deletepoint_button->setToggleButton(TRUE);
				deletepoint_button->setOn(FALSE);
				connect( deletepoint_button, SIGNAL( clicked() ), this, SLOT(resetcurr_button_action() ) );
*/
	
	histlayout_centre = new Q3BoxLayout ( 0, QBoxLayout::TopToBottom, 0, 5, "histlayout_centre");
	histlayout_centre->addWidget(view_grp, 1);
	histlayout_centre->addWidget(hist, 10);
	histlayout_centre->addWidget(threshold_grp, 1);
	
	//briconslider_grp->hide();
	vboxlayout_centre = new Q3BoxLayout ( 0, QBoxLayout::LeftToRight, 0, 5, "vboxlayout_centre");
	vboxlayout_centre->addLayout(histlayout_centre);
	vboxlayout_centre->addWidget(briconslider_grp);
		
	vboxlayoutRIGHT = new Q3BoxLayout ( 0, QBoxLayout::TopToBottom, 0, 5, "vboxlayout");
	vboxlayoutRIGHT->addLayout(vboxlayout_centre);
	
	vboxlayoutLEFT = new Q3BoxLayout ( 0, QBoxLayout::TopToBottom, 0, 5, "vboxlayout");
	vboxlayoutLEFT->setAlignment(Qt::AlignTop);
	vboxlayoutLEFT->addWidget(opensave_grp, 0, Qt::AlignTop);
	vboxlayoutLEFT->addWidget(toggle_grp, 0, Qt::AlignTop);
	vboxlayoutLEFT->addWidget(channelmode_grp, 0, Qt::AlignTop);	
	//vboxlayoutLEFT->addWidget(tfunc16bit_grp, 0, Qt::AlignTop);
	vboxlayoutLEFT->addWidget(update_grp, 0, Qt::AlignTop);
	vboxlayoutLEFT->addWidget(mapping_grp, 0, Qt::AlignTop);
	vboxlayoutLEFT->addWidget(action_grp, 0, Qt::AlignTop);
	vboxlayoutLEFT->addWidget(reset_grp, 0, Qt::AlignTop);
	
	topmost= new Q3BoxLayout ( this, QBoxLayout::LeftToRight, 0, 5, "topmost");
	topmost->addLayout(vboxlayoutLEFT);
	topmost->addLayout(vboxlayoutRIGHT);

	//default as I/RGB and opacity
	channel_button_event(0);
	channelmode_button_event(1);
	
	//our histogram widget
	//hist->draw_transfer();
}
void QtTransferFunctionWidget::linearmapcb_action(void)
{
	if(linearmapcb->checkState()==Qt::Checked)
	{
		hist->fe_l.bs.linear=true;
		hist->fe_la.bs.linear=true;
		hist->fe_r.bs.linear=true;
		hist->fe_g.bs.linear=true;
		hist->fe_b.bs.linear=true;
		hist->fe_ra.bs.linear=true;
		hist->fe_ga.bs.linear=true;
		hist->fe_ba.bs.linear=true;
	}
	else
	{
	}

	hist->fe_l.bs.compute();
	hist->fe_la.bs.compute();
	hist->fe_r.bs.compute();
	hist->fe_g.bs.compute();
	hist->fe_b.bs.compute();
	hist->fe_ra.bs.compute();
	hist->fe_ga.bs.compute();
	hist->fe_ba.bs.compute();

	hist->update();
	hist->emit_tfunc_current();
}
void QtTransferFunctionWidget::bsplinecb_action(void)
{
	if(bsplinecb->checkState()==Qt::Checked)
	{
		hist->fe_l.bs.linear=false;
		hist->fe_la.bs.linear=false;
		hist->fe_r.bs.linear=false;
		hist->fe_g.bs.linear=false;
		hist->fe_b.bs.linear=false;
		hist->fe_ra.bs.linear=false;
		hist->fe_ga.bs.linear=false;
		hist->fe_ba.bs.linear=false;
	}
	else
	{
	}

	hist->fe_l.bs.compute();
	hist->fe_la.bs.compute();
	hist->fe_r.bs.compute();
	hist->fe_g.bs.compute();
	hist->fe_b.bs.compute();
	hist->fe_ra.bs.compute();
	hist->fe_ga.bs.compute();
	hist->fe_ba.bs.compute();
	hist->update();
	hist->emit_tfunc_current();
}
void QtTransferFunctionWidget::released_slider_slot(void)
{
	//tells our qtglwidget to only redraw slice frames 
	//when a slider is released
	emit tfunc_slider_released_signal();
}
void QtTransferFunctionWidget::resetcurr_button_action(void)
{
	setCursor(QCursor(Qt::waitCursor));
 
	if(transfer_mode==1)
	{
		hist->reset_l();
	}
	if(transfer_mode==2)
	{
		hist->reset_la();
	}
	if(transfer_mode==3)
	{
		hist->reset_r();
	}
	if(transfer_mode==4)
	{
		hist->reset_g();
	}
	if(transfer_mode==5)
	{
		hist->reset_b();
	}
	if(transfer_mode==6)
	{
		hist->reset_ra();
	}
	if(transfer_mode==7)
	{
		hist->reset_ga();
	}
	if(transfer_mode==8)
	{
		hist->reset_ba();
	}

	emit hist->reset_transfer_function_parameters();
	hist->emit_tfunc_current();
	//hist->draw_transfer();
	//hist->emit_redraw();

	histcb->setChecked(TRUE);
	tfuncb->setChecked(TRUE);
	cumfcb->setChecked(FALSE);
	linearmapcb->setChecked(FALSE);
	bsplinecb->setChecked(TRUE);
	channel_button_event(channel_selected);	
	setCursor(QCursor(Qt::arrowCursor));
}
void QtTransferFunctionWidget::resetall_button_action(void)
{
	setCursor(QCursor(Qt::waitCursor));

	hist->reset();

	emit hist->reset_transfer_function_parameters();
	hist->emit_tfunc_all();
	//hist->draw_transfer();
	//hist->emit_redraw();

	histcb->setChecked(TRUE);
	tfuncb->setChecked(TRUE);
	cumfcb->setChecked(FALSE);
	linearmapcb->setChecked(FALSE);
	bsplinecb->setChecked(TRUE);
	channel_button_event(channel_selected);	
	setCursor(QCursor(Qt::arrowCursor));
}
void QtTransferFunctionWidget::open_event(void)
{
	setCursor(QCursor(Qt::waitCursor));
	hist->load();
	setCursor(QCursor(Qt::waitCursor));

	emit hist->reload_transfer_function_parameters();
	hist->emit_tfunc_reloadall();

//	hist->draw_transfer();
//	hist->emit_redraw();

	histcb->setChecked(TRUE);
	tfuncb->setChecked(TRUE);
	cumfcb->setChecked(FALSE);	
	linearmapcb->setChecked(FALSE);
	bsplinecb->setChecked(TRUE);
	channel_button_event(channel_selected);	
	setCursor(QCursor(Qt::arrowCursor));
}
void QtTransferFunctionWidget::save_event(void)
{
	hist->save();

	setCursor(QCursor(Qt::arrowCursor));
}
void QtTransferFunctionWidget::rebuild(void)
{
	//printf("BOH\n");
	//update our histogram
	hist->draw_transfer();
	//hist->update();
}
void QtTransferFunctionWidget::reset(void)
{
	histcb->setChecked(TRUE);
	tfuncb->setChecked(TRUE);
	cumfcb->setChecked(FALSE);

	channel_button_event(0);

	hist->reset();
	hist->set_transfer_mode(transfer_mode);
	
	rebuild();
}
void QtTransferFunctionWidget::channelmode_button_event(int id)
{
	channelmode_selected=id;
	updating_labels=1;

	if(channel_selected==0)
	{			
		if(channelmode_selected==0)
		{
			transfer_mode=1;
			update_slider_labels(hist->l_tmin, hist->l_tmax, hist->l_bright, hist->l_cont);
		}
		else if(channelmode_selected==1)
		{
			transfer_mode=2;
			update_slider_labels(hist->la_tmin, hist->la_tmax, hist->la_bright, hist->la_cont);
		}
	}
	else if(channel_selected==1)
	{	
		if(channelmode_selected==0)
		{
			transfer_mode=3;
			update_slider_labels(hist->r_tmin, hist->r_tmax, hist->r_bright, hist->r_cont);
		}
		else if(channelmode_selected==1)
		{
			transfer_mode=6;
			update_slider_labels(hist->ra_tmin, hist->ra_tmax, hist->ra_bright, hist->ra_cont);
		}	
	}
	else if(channel_selected==2)
	{	
		if(channelmode_selected==0)
		{
			transfer_mode=4;
			update_slider_labels(hist->g_tmin, hist->g_tmax, hist->g_bright, hist->g_cont);
		}
		else if(channelmode_selected==1)
		{
			transfer_mode=7;
			update_slider_labels(hist->ga_tmin, hist->ga_tmax, hist->ga_bright, hist->ga_cont);
		}	
	}
	else if(channel_selected==3)
	{
		if(channelmode_selected==0)
		{
			transfer_mode=5;
			update_slider_labels(hist->b_tmin, hist->b_tmax, hist->b_bright, hist->b_cont);
		}
		else if(channelmode_selected==1)
		{
			transfer_mode=8;
			update_slider_labels(hist->ba_tmin, hist->ba_tmax, hist->ba_bright, hist->ba_cont);
		}	
	}

	updating_labels=0;
	hist->set_transfer_mode(transfer_mode);
	emit tfunc_rebuild_histogram_signal();
	update();
}

void QtTransferFunctionWidget::channel_button_event(int id)
{
	updating_labels=1;
	channel_selected = id;

	if(channel_selected==0)
	{			
		if(channelmode_selected==0)
		{
			transfer_mode=1;
			update_slider_labels(hist->l_tmin, hist->l_tmax, hist->l_bright, hist->l_cont);
		}
		else if(channelmode_selected==1)
		{
			transfer_mode=2;
			update_slider_labels(hist->la_tmin, hist->la_tmax, hist->la_bright, hist->la_cont);
		}
	}
	else if(channel_selected==1)
	{	
		if(channelmode_selected==0)
		{
			transfer_mode=3;
			update_slider_labels(hist->r_tmin, hist->r_tmax, hist->r_bright, hist->r_cont);
		}
		else if(channelmode_selected==1)
		{
			transfer_mode=6;
			update_slider_labels(hist->ra_tmin, hist->ra_tmax, hist->ra_bright, hist->ra_cont);
		}	
	}
	else if(channel_selected==2)
	{	
		if(channelmode_selected==0)
		{
			transfer_mode=4;
			update_slider_labels(hist->g_tmin, hist->g_tmax, hist->g_bright, hist->g_cont);
		}
		else if(channelmode_selected==1)
		{
			transfer_mode=7;
			update_slider_labels(hist->ga_tmin, hist->ga_tmax, hist->ga_bright, hist->ga_cont);
		}	
	}
	else if(channel_selected==3)
	{
		if(channelmode_selected==0)
		{
			transfer_mode=5;
			update_slider_labels(hist->b_tmin, hist->b_tmax, hist->b_bright, hist->b_cont);
		}
		else if(channelmode_selected==1)
		{
			transfer_mode=8;
			update_slider_labels(hist->ba_tmin, hist->ba_tmax, hist->ba_bright, hist->ba_cont);
		}	
	}

	updating_labels=0;
	hist->set_transfer_mode(transfer_mode);
	emit tfunc_rebuild_histogram_signal();
	update();
}

void QtTransferFunctionWidget::transferfun_action(void)
{
	hist->tfunc_enable=!hist->tfunc_enable;
	rebuild();
	update();
}
void QtTransferFunctionWidget::histoview_action(void)
{
	hist->hist_enable=!hist->hist_enable;
	rebuild();
	update();
}
void QtTransferFunctionWidget::cumfreview_action(void)
{
	hist->cumfreq_enable=!hist->cumfreq_enable;
	rebuild();
	update();
}
void QtTransferFunctionWidget::tfunc_histogram_slot(double* histo)
{
	for(int i=0; i<256; i++)
	{
		hist->data[i] = histo[i];			
	}
	
	emit tfunc_rebuild_histogram_signal();
	update();
}
void QtTransferFunctionWidget::histogram_action(int* histo)
{
	for(int i=0; i<256; i++)
	{
		hist->data[i] = histo[i];
	}

	//hist->draw_transfer();
	update();
}
void QtTransferFunctionWidget::emit_transfer_function(void)
{

}

void QtTransferFunctionWidget::update_slider_labels(int tmin, int tmax, int b, int c)
{
	threshmin = tmin;
	threshmax = tmax;
	brightness = b;
	contrast = c;

	QString s;
	QString text;

	threshmin_slider->setValue(tmin);
	text = "Min. Threshold:	";
	s.setNum(tmin);
	text += s;
	threshmin_lb->setText (text);

	threshmax_slider->setValue(tmax);
	text = "Max Threshold:	";
	s.setNum(tmax);
	text += s;
	threshmax_lb->setText (text);

	brightness_slider->setValue(200-b);
	text.setNum(b);
	text += "%";
	brightness_lb->setText (text);

	contrast_slider->setValue(200-c);
	text.setNum(c);
	text += "%";
	contrast_lb->setText (text);
}
void QtTransferFunctionWidget::threshmin_action(int j)
{
	//check slider bounds
	if(j>threshmax)
	{
		j = threshmax;
		threshmin_slider->setValue(j);
	}
	threshmin = j;
	
	//update our slider label
	QString s;
	QString text;
	text = "Min. Threshold:	";
	s.setNum(j);
	text += s;
	threshmin_lb->setText (text);

	if(updating_labels==0)
	{
		if(channel_selected==0)
		{
			if(channelmode_selected==0)	
				hist->r_tmin = hist->g_tmin = hist->b_tmin = hist->l_tmin = threshmin;
			if(channelmode_selected==1)	
				hist->ra_tmin = hist->ga_tmin = hist->ba_tmin = hist->la_tmin = threshmin;
		}
		if(channel_selected==1)
		{
			if(channelmode_selected==0)	hist->r_tmin = threshmin;
			if(channelmode_selected==1)	hist->ra_tmin = threshmin;
		}
		if(channel_selected==2)
		{
			if(channelmode_selected==0)	hist->g_tmin = threshmin;
			if(channelmode_selected==1)	 hist->ga_tmin = threshmin;
		}
		if(channel_selected==3)
		{
			if(channelmode_selected==0)	hist->b_tmin = threshmin;
			if(channelmode_selected==1)	hist->ba_tmin = threshmin;
		}

		emit tfunc_threshold_signal(transfer_mode, threshmin, threshmax);
	}
}
void QtTransferFunctionWidget::threshmax_action(int j)
{
	//check slider bounds
	if(j<threshmin)
	{
		j = threshmin;
		threshmax_slider->setValue(j);
	}
	threshmax = j;

	//update our slider label
	QString s;
	QString text;
	text = "Max Threshold:	";
	s.setNum(j);
	text += s;
	threshmax_lb->setText (text);

	if(updating_labels==0)
	{
		if(channel_selected==0)
		{
			if(channelmode_selected==0)	
				hist->r_tmax = hist->g_tmax = hist->b_tmax = hist->l_tmax = threshmax;
			if(channelmode_selected==1)	
				hist->ra_tmax = hist->ga_tmax = hist->ba_tmax = hist->la_tmax = threshmax;
		}
		if(channel_selected==1)
		{
			if(channelmode_selected==0)	hist->r_tmax = threshmax;
			if(channelmode_selected==1)	hist->ra_tmax = threshmax;
		}
		if(channel_selected==2)
		{
			if(channelmode_selected==0)	hist->g_tmax = threshmax;
			if(channelmode_selected==1)	 hist->ga_tmax = threshmax;
		}
		if(channel_selected==3)
		{
			if(channelmode_selected==0)	hist->b_tmax = threshmax;
			if(channelmode_selected==1)	hist->ba_tmax = threshmax;
		}

		emit tfunc_threshold_signal(transfer_mode, threshmin, threshmax);
	}
}
void QtTransferFunctionWidget::brightness_action(int i)
{
	//update our slider label
	brightness = 200-i;
	QString text;
	text.setNum(brightness);
	text += "%";
	brightness_lb->setText (text);

	if(updating_labels==0)
	{
		if(channel_selected==0)
		{
			if(channelmode_selected==0)	
				hist->r_bright = hist->g_bright = hist->b_bright = hist->l_bright = brightness;
			if(channelmode_selected==1)	
				hist->ra_bright = hist->ga_bright = hist->ba_bright = hist->la_bright = brightness;
		}
		if(channel_selected==1)
		{
			if(channelmode_selected==0)	hist->r_bright = brightness;
			if(channelmode_selected==1)	hist->ra_bright = brightness;
		}
		if(channel_selected==2)
		{
			if(channelmode_selected==0)	hist->g_bright = brightness;
			if(channelmode_selected==1)	 hist->ga_bright = brightness;
		}
		if(channel_selected==3)
		{
			if(channelmode_selected==0)	hist->b_bright = brightness;
			if(channelmode_selected==1)	hist->ba_bright = brightness;
		}

		emit tfunc_brightcontrast_signal(transfer_mode, brightness, contrast);
	}
}
void QtTransferFunctionWidget::contrast_action(int i)
{
	//update our slider label
	contrast = 200-i;
	QString text;
	text.setNum(contrast);
	text += "%";
	contrast_lb->setText (text);

	if(updating_labels==0)
	{
		if(channel_selected==0)
		{
			if(channelmode_selected==0)	
				hist->r_cont = hist->g_cont = hist->b_cont = hist->l_cont = contrast;
			if(channelmode_selected==1)	
				hist->ra_cont = hist->ga_cont = hist->ba_cont = hist->la_cont = contrast;
		}
		if(channel_selected==1)
		{
			if(channelmode_selected==0)	hist->r_cont = contrast;
			if(channelmode_selected==1)	hist->ra_cont = contrast;
		}
		if(channel_selected==2)
		{
			if(channelmode_selected==0)	hist->g_cont = contrast;
			if(channelmode_selected==1)	 hist->ga_cont = contrast;
		}
		if(channel_selected==3)
		{
			if(channelmode_selected==0)	hist->b_cont = contrast;
			if(channelmode_selected==1)	hist->ba_cont = contrast;
		}

		emit tfunc_brightcontrast_signal(transfer_mode, brightness, contrast);
	}
}

void QtTransferFunctionWidget::invert_button_action(void)
{
	if(invert_button->isOn())
	{
		if(transfer_mode==1) hist->inv_l = true;
		if(transfer_mode==2) hist->inv_la = true;
		if(transfer_mode==3) hist->inv_r = true;
		if(transfer_mode==4) hist->inv_g = true;
		if(transfer_mode==5) hist->inv_b = true;
		if(transfer_mode==6) hist->inv_ra = true;
		if(transfer_mode==7) hist->inv_ga = true;
		if(transfer_mode==8) hist->inv_ba = true;

		emit tfunc_invert_signal(transfer_mode, 0);
	}
	else
	{
		if(transfer_mode==1) hist->inv_l = false;
		if(transfer_mode==2) hist->inv_la = false;
		if(transfer_mode==3) hist->inv_r = false;
		if(transfer_mode==4) hist->inv_g = false;
		if(transfer_mode==5) hist->inv_b = false;
		if(transfer_mode==6) hist->inv_ra = false;
		if(transfer_mode==7) hist->inv_ga = false;
		if(transfer_mode==8) hist->inv_ba = false;

		emit tfunc_invert_signal(transfer_mode, 1);
	}

	hist->emit_tfunc_current();
}
void QtTransferFunctionWidget::histequ_button_action(void)
{
	if(histequ_button->isOn())
	{
		emit tfunc_histequ_signal(transfer_mode, 0);
	}
	else
	{
		emit tfunc_histequ_signal(transfer_mode, 1);
	}

	hist->emit_tfunc_current();
	hist->emit_redraw();
}
void QtTransferFunctionWidget::contstrat_button_action(void)
{
	if(contstrat_button->isOn())
	{
		emit tfunc_contstrat_signal(transfer_mode, 0);
	}
	else
	{
		emit tfunc_contstrat_signal(transfer_mode, 1);
	}

	hist->emit_tfunc_current();
	hist->emit_redraw();
}

void QtTransferFunctionWidget::slice_update_button_action(void)
{
	if(sliceupdate_button->isOn())
	{
		hist->slice_toggle=1;
		hist->emit_tfunc_current();
	}
	else
	{
		hist->slice_toggle=0;
	}
}
void QtTransferFunctionWidget::updatehisto_action(void)
{
	int toggle = 0;
	
	if(updatehistcb->checkState()==Qt::Checked) toggle = 1;
	else toggle = 0;

	emit tfunc_histoupdate_signal(toggle);
}
void QtTransferFunctionWidget::logscalehistcb_action(void)
{	
	if(logscalehistcb->checkState()==Qt::Checked) hist->logscale = 1;
	else hist->logscale = 0;

	hist->update();
}
void QtTransferFunctionWidget::collapse_button_action(void)
{
	red_pb->setEnabled(false);
	blue_pb->setEnabled(false);
	green_pb->setEnabled(false);

	emit tfunc_collapse_signal();
}
void QtTransferFunctionWidget::convR_button_action(void)
{
	emit tfunc_convertR_signal();
}
void QtTransferFunctionWidget::convG_button_action(void)
{
	emit tfunc_convertG_signal();
}
void QtTransferFunctionWidget::convB_button_action(void)
{
	emit tfunc_convertB_signal();
}

void QtTransferFunctionWidget::resetbutton_event(void)
{

}
void QtTransferFunctionWidget::applybutton_event(void)
{
//	emit tfunc_remap16bit_signal(remap_threshmin, remap_threshmax);
}
void QtTransferFunctionWidget::closebutton_event(void)
{
//	remap_dialogue->close();
//	delete remap_dialogue;
//	remap_dialogue=0;
}
void QtTransferFunctionWidget::remap_threshmax_event(int value)
{
/*	if(value<remap_threshmin)
	{
		remap_threshmax_slider->setValue(remap_threshmax);
		return;
	}
	
	remap_threshmax_slider->setValue(value);
	remap_threshmax=value;

	//update our slider label
	QString s;
	QString text;
	text = "Max Threshold: ";
	s.setNum(value);
	text += s;
	remap_threshmax_lb->setText (text);		
	
	if(histo16_remaponfly) emit tfunc_remap16bit_signal(remap_threshmin, remap_threshmax);
	else
	{
		tfunc_16bit_histogram_slot(&histo16bit[0], &histo8bit[0]);
		pixmap8bit_lb->setPixmap(*histogram8bit);
		pixmap16bit_lb->setPixmap(*histogram16bit);
	}
*/}
void QtTransferFunctionWidget::remap_threshmin_event(int value)
{
/*	if(value>remap_threshmax)
	{
		remap_threshmin_slider->setValue(remap_threshmin);
		return;
	}
	remap_threshmin_slider->setValue(value);
	remap_threshmin=value;

	//update our slider label
	QString s;
	QString text;
	text = "Min Threshold: ";
	s.setNum(value);
	text += s;
	remap_threshmin_lb->setText (text);	

	if(histo16_remaponfly)	emit tfunc_remap16bit_signal(remap_threshmin, remap_threshmax);
	else 
	{
		tfunc_16bit_histogram_slot(&histo16bit[0], &histo8bit[0]);
		pixmap8bit_lb->setPixmap(*histogram8bit);
		pixmap16bit_lb->setPixmap(*histogram16bit);
	}
*/}
