#ifndef QUATERNION_H
#define QUATERNION_H

#include <math.h>

#include "Vector.h"

class Quaternion  
{
public:

	Vector quat;

	Quaternion();
	Quaternion(Vector v, double rho);
	~Quaternion();

	void create_matrix(float *pMatrix);
	void create_from_angle(Vector pos, float degrees);
	void create_euler(Vector* v);
	Vector apply(const Vector& v) const;

	Quaternion operator *(Quaternion q);
};

void slerp(Quaternion* from, Quaternion * to, float t, Quaternion* res);

#endif	//QUATERNION_H