#ifndef TIMER_H
#define TIMER_H

#include <iostream>
#include <ctime>
//#include <windows.h>
#include <QTime>
using namespace std;

class Timer
{
	public:
	
		QTime timer;
		
		clock_t		  startime;
		clock_t		  endtime;

		float		  speed;
/*
		LARGE_INTEGER TimerFreq;		// Timer Frequency
		LARGE_INTEGER TimeStart;		// Time of start
		LARGE_INTEGER TimeCur;			// Curent Time
		
		LARGE_INTEGER startCounter,
					  result,
					  difference,
					  ticks,
					  value;
*/		
		double fps;						//frames per second
		double cpu_spd;					//cpu speed
		double time_diff;				//start time - end time

		int   fps_count;  				// Frames per second count 
		float fps_time; 				// Frames per second time
		
		float OldTime;       			// Last update time 
		float Time; 	 				// Current time in milliseconds
		float DeltaTime; 				// Time difference from last frame (TIME-OLDTIME)
		
		float Start;       				// Start time in milliseconds
		float End; 	 					// End time in milliseconds
	
		//-------------------------------------------------------------------		
		Timer();

		void init(void);
		void idle(void);
		
		void get_fps(void);
		void get_CPU(void);

		void set_time_start(void);
		void set_time_end(void);
		void set_time_difference(void);

		void set_ticks_start(void);
		void set_ticks_end(void);
		void set_ticks_difference(void);
		
		void startCTimer(void);
		float endCTimer(void);
		void startQTime(void);
		float endQTime(void);
};

#endif //TIMER
