#include "VolIO.h"

VolIO::VolIO()
{
	watcher = new SliceLoader(0);
	WLZ_rescale = 1.0;

	volobj = NULL;

	red=green=blue=false;
	
	res_x=res_y=res_z=0;
	offset_x=offset_y=offset_z=0;
}

VolIO::~VolIO()
{
	volobj = NULL;
}

/*!
	Save an OBJ surface
*/
void VolIO::save_OBJ(QString filename)
{
	if(volobj->texwidth&&volobj->texheight&&volobj->texdepth==1) return;
	if(volobj->texture3d==NULL) return;
	printf("Saving OBJ surface... \n");
	
	//check the user entered the extension, otherwise add it to the filename
	if(filename[int(filename.length()-4)]!='.') filename += ".obj";
	
	//volren->meshes[0].save_OBJ_data(filename.latin1());

	//meshobj->save_OBJ_data(filename.latin1());
	printf("\n");
}
void VolIO::save_PNG(QString filename)
{
	if(volobj->texwidth&&volobj->texheight&&volobj->texdepth==1) return;
	if(volobj->texture3d==NULL) return;

	//remove the filename of first file to get only dirname
	//int pos = filename.findRev(QString("/").latin1(), -1, false);
	QString dirname = filename + "/";//filename.replace(pos+1, filename.length()-pos+1, "");

	printf("%s\n", filename.latin1());

	//index helpers
	int index_2D;
	int index_3D;

	//filename
	QString slice_filename;
	QString numb;

	//array for slice image
	unsigned char* slicearray=NULL;
	slicearray = new unsigned char[volobj->texwidth*volobj->texheight*4];
	if(slicearray==NULL) return;

	printf("%d, %d, %d \n", volobj->texwidth, volobj->texdepth, volobj->texheight);
	progressbar = new Q3ProgressDialog("Saving PNG Slices...", "Cancel", volobj->texdepth, 0, "progress", TRUE);		
	progressbar->setCaption("Please Wait");

	int r,g,b;

	// Loop Through the depth
	for (int z =0; z<volobj->texdepth; z++)
	{	
		//progress(z, volobj->texdepth);
		progressbar->setProgress(z);
		if (progressbar->wasCancelled())
			break;

		//get the current z slice
		for(int x=0; x<volobj->texwidth; x++)
		{
			for(int y=0; y<volobj->texheight; y++)
			{
				index_2D = 4*((y*volobj->texwidth)+x);
				index_3D = 3*((((((volobj->texdepth-1)-z)*volobj->texheight)+y)*volobj->texwidth)+x);
				
				r =  volobj->texture3d[index_3D+0];
				g =  volobj->texture3d[index_3D+1];
				b =  volobj->texture3d[index_3D+2];

				if(volobj->is16bit)
				{
					slicearray[index_2D+0] = volobj->texture3d[index_3D+1];
					slicearray[index_2D+1] = volobj->texture3d[index_3D+1];
					slicearray[index_2D+2] = volobj->texture3d[index_3D+1];
					slicearray[index_2D+3] = 255;				
				}
				else
				{
					if(volobj->is_greyscale==true)
					{
						slicearray[index_2D+0] = r;
						slicearray[index_2D+1] = r;
						slicearray[index_2D+2] = r;
						slicearray[index_2D+3] = 255;

					}
					else
					{
						slicearray[index_2D+0] = slicearray[index_2D+1] = slicearray[index_2D+2] = 0;
						slicearray[index_2D+3] = 255;

						if(volobj->has_red==true) slicearray[index_2D+0] = r;
						if(volobj->has_green==true) slicearray[index_2D+1] = g;
						if(volobj->has_blue==true)  slicearray[index_2D+2] = b;
					}
				}
			}
		}

		//create a QImage using our RAW RGB data
		QImage slice_image = QImage(slicearray, volobj->texwidth, volobj->texheight, 32, 0, 256, QImage::LittleEndian );
		slice_image.setAlphaBuffer(false);
		slice_image = slice_image.swapRGB();

		//generate our slice filename
		slice_filename = dirname + "Slice";		
		if(z<10)
		{
			numb = "";
			slice_filename += numb.setNum(0);
		}
		if(z<100)
		{
			numb = "";
			slice_filename += numb.setNum(0);
		}
		slice_filename += numb.setNum(z);
		slice_filename += ".png";

		//printf("%s\n", slice_filename.latin1());

		//convert image to a pixmap and save it
		QPixmap pm;
		pm.convertFromImage(slice_image);
		slice_image.reset();
		if(!pm.isNull()) pm.save(slice_filename, "PNG");
	}

	
	printf("xresize: %f\n, yresize: %f\n, zresize: %f\n",volobj->xscale*volobj->x_resize, volobj->yscale*volobj->y_resize, volobj->zscale*volobj->z_resize);
	
	ofstream fout;
	QString fn = dirname + "/voxelscale.txt";
	fout.open(fn.latin1());
	fout<<"x "<<volobj->xscale*volobj->x_resize<<endl;
	fout<<"y "<<volobj->yscale*volobj->y_resize<<endl;
	fout<<"z "<<volobj->zscale*volobj->z_resize<<endl;
	fout.close();
	
	fn = dirname + "/voxelspacing.txt";
	fout.open(fn.latin1());
	fout<<"x "<<volobj->xsize<<endl;
	fout<<"y "<<volobj->ysize<<endl;
	fout<<"z "<<volobj->zsize<<endl;
	fout.close();

	delete progressbar;
	progressbar = NULL;
	
	delete[] slicearray;
	slicearray = NULL;
}
/*!
	Save our volume array, RAW binary file format
*/
void VolIO::save_RAW(QString filename)
{
	if(volobj->texwidth&&volobj->texheight&&volobj->texdepth==1) return;
	if(volobj->texture3d==NULL) return;

	//a raw vol file
	RAW_volume raw_vol;

	//check the user entered the extension, otherwise add it to the filename
	if(filename[int(filename.length()-4)]!='.') filename += ".dat";

	raw_vol.save_DAT(filename.latin1(), volobj->texwidth, volobj->texheight, volobj->texdepth, WLZ_rescale);
	
	filename.truncate(filename.length()-3);                            
	filename += "raw";

	// Open "filename" For Reading Bytes
	FILE *f;
	f = fopen(filename.latin1(), "wb");					
	
	if(f== NULL)
	{
		//error opening file
		QMessageBox* mb = new QMessageBox( "WARNING",
				"Could not save file. \n",QMessageBox::Warning,
				QMessageBox::Ok | QMessageBox::Default,0,0 );

		mb->exec();
		exit(1);
//		printf("ERROR: Saving RAW volume...  [VOLIO.cpp\save_RAW()]\n");
//		system("pause");
//		exit(1);
	}

	//printf("Saving RAW volume... \n");
	progressbar = new Q3ProgressDialog("Saving RAW Volume...", "Cancel", volobj->texdepth, 0, "progress", TRUE);		
	progressbar->setCaption("Please Wait");

	// Loop Through the depth
	for (int z =0; z<volobj->texdepth; z++)
	{	
		//progress(z, volobj->texdepth);
		progressbar->setProgress(z);
		if (progressbar->wasCancelled())
			break;

		raw_vol.save_RAW(f, volobj->texture3d, volobj->texwidth, volobj->texheight, z);			
	}
	fclose(f);	// Close The File
	
	delete progressbar;
	progressbar = 0;

	//printf("\n");
}
void VolIO::save_TIFFstack(QString filename)
{
	/*if(volobj->texwidth&&volobj->texheight&&volobj->texdepth==1) return;
	if(volobj->texture3d==NULL) return;

	//remove the filename of first file to get only dirname
	//int pos = filename.findRev(QString("/").latin1(), -1, false);
	QString dirname = filename + "/";//filename.replace(pos+1, filename.length()-pos+1, "");

	printf("%s\n", filename.latin1());

	//index helpers
	int index_2D;
	int index_3D;

	//filename
	QString slice_filename;
	QString numb;

	printf("%d, %d, %d \n", volobj->texwidth, volobj->texdepth, volobj->texheight);
	progressbar = new Q3ProgressDialog("Saving PNG Slices...", "Cancel", volobj->texdepth, 0, "progress", TRUE);		
	progressbar->setCaption("Please Wait");

	uint8 r,g,b;
	uint32* raster32bit=NULL;
	uint32 w, h;
	uint32 pixel;
	uint16 datatype, bpp, unitres, spp;
	float unitresX = 0.0;
	float unitresY = 0.0;
	size_t npixels;
	char* descp;

	w = volobj->texwidth;
	h = volobj->texheight;
	bpp = 8;
	spp = 3;

	TIFF* tifobject = TIFFOpen(filename.latin1(), "w");

	TIFFSetField(tifobject, TIFFTAG_IMAGEWIDTH, w);
	TIFFSetField(tifobject, TIFFTAG_IMAGELENGTH, h);
	TIFFSetField(tifobject, TIFFTAG_BITSPERSAMPLE, bpp);
	TIFFSetField(tifobject, TIFFTAG_SAMPLESPERPIXEL,spp);

	TIFFSetField(tifobject, TIFFTAG_XRESOLUTION, &unitresX);
	TIFFSetField(tifobject, TIFFTAG_YRESOLUTION, &unitresY);
	TIFFSetField(tifobject, TIFFTAG_RESOLUTIONUNIT, &unitres);
	TIFFSetField(tifobject, TIFFTAG_IMAGEDESCRIPTION, &descp);

	npixels = w*h;
	raster32bit = (uint32*) _TIFFmalloc(npixels * sizeof (uint32));
	if(raster32bit==NULL)
	{
		printf("ERROR allocating memory, raster32bit \n");
	}

	QString description = descp;

	// Loop Through the depth
	for (int z =0; z<volobj->texdepth; z++)
	{	
		//progress(z, volobj->texdepth);
		progressbar->setProgress(z);
		if (progressbar->wasCancelled())
			break;

		TIFFSetDirectory(tifobject, z);

		//get the current z slice
		for(int x=0; x<volobj->texwidth; x++)
		{
			for(int y=0; y<volobj->texheight; y++)
			{
				index_2D = ((y*volobj->texwidth)+x);
				index_3D = ((((((volobj->texdepth-1)-z)*volobj->texheight)+y)*volobj->texwidth)+x);
				
				if(volobj->is16bit)
				{
					r = volobj->texture3d[3*index_3D+1];
					g = volobj->texture3d[3*index_3D+1];
					b = volobj->texture3d[3*index_3D+1];
				}
				else
				{
					r = (unsigned char) volobj->texture3d[3*index_3D+2];
					g = (unsigned char) volobj->texture3d[3*index_3D+1];
					b = (unsigned char) volobj->texture3d[3*index_3D+0];
				}
				
			//	TIFFSetR(pixel, r);
			//	TIFFSetG(pixel, g);
			//	TIFFSetB(pixel, b);

				raster32bit[(int)(x+0.5)+(int)(((volobj->height-1)-y)+0.5)*volobj->width] = pixel;
			}
		}
	
//		TIFFWriteRGBAImage(tifobject, w, h, raster32bit, 0);
	}

	TIFFClose(tifobject);*/
}
/*void VolIO::save_WLZ(QString filename, int channelmode)
{
	printf("Saving WLZ volume...\n");

	WlzErrorNum error = WLZ_ERR_NONE;
	WlzObjectType		type;
	WlzObject 			*obj;
	WlzDomain			domain;
	WlzValues			values;
	WlzGreyValueWSpace *gVWSp=NULL;
	WlzIBox3			bbox;

    obj = NULL;
    domain.core = NULL;
    values.core = NULL;

	//create a 3D array of int for our WLZ object
	UBYTE*** texture = 0;
	texture = new UBYTE**[volobj->texwidth];
	for(int i=0; i<volobj->texwidth; i++)
		texture[i] = new UBYTE*[volobj->texheight];
	for(int j=0; j<volobj->texwidth; j++)
		for(int k=0; k<volobj->texheight; k++)
			texture[j][k] = new UBYTE[volobj->texdepth];

	//make an empty WLZ object
//	obj =  WlzMakeMain(WLZ_EMPTY_OBJ, domain, values, NULL,
//		 NULL, &error);
//	obj = WlzMakeEmpty(&error);

	//make sure we didnt generate an erro msg
//	if(error!=WLZ_ERR_NONE) printf("WLZ ERROR!!  [VOLIO.cpp\save_WLZ()]\n");

	//traverse our volume
	int x, y, z;
	int index1D;
	int value;
	for(x=0; x<volobj->texwidth; x++)
	{
		for(y=0; y<volobj->texheight; y++)
		{
			for(z=0; z<volobj->texdepth; z++)	
			{
				//work out the current index
				index1D =  3*(((((z)*volobj->texheight)+(y))*volobj->texwidth)+(x));

				//set the current voxel
				texture[x][y][z] = (UBYTE)volobj->texture3d[index1D+3];
			}
		}
	}

	//obj dimensions
	WlzIVertex3 size;
	size.vtX = volobj->texwidth;
	size.vtY = volobj->texheight;
	size.vtZ = volobj->texdepth;

	//obj origin
	WlzIVertex3 origin;
	origin.vtX = volobj->texwidth/2;
	origin.vtY = volobj->texheight/2;
	origin.vtZ = volobj->texdepth/2;
	
//	origin.vtX = 0;
//	origin.vtY = 0;
//	origin.vtZ = 0;

	//create a new WLZ object from our 3D UBYTE array
	obj =  WlzFromUArray3D(size, texture, origin, &error);

	//make sure we didnt generate an erro msg
	if(error!=WLZ_ERR_NONE) printf("WLZ ERROR!!  [VOLIO.cpp\save_WLZ()]\n");

	bbox = WlzBoundingBox3I(obj, NULL);

	int width = bbox.xMax - bbox.xMin+1;
	int height= bbox.yMax - bbox.yMin+1;
	int depth = bbox.zMax - bbox.zMin+1;

	//traverse our volume
	for(x=bbox.xMin; x<bbox.xMax; x++)
	{
		for(y=bbox.yMin; y<bbox.yMax; y++)
		{
			for(z=bbox.zMin; z<bbox.zMax; z++)	
			{
				value = (int) texture[x][y][z];
				//get the current voxel
				WlzGreyValueGet(gVWSp, x, y, z); 

				//set the current voxel
				*((*(gVWSp->gPtr)).ubp) = value;
			}
		}
	}

    //Open a file stream for our WLZ file
	FILE *fp=NULL;  
	fp = fopen("test.wlz", "wb");

	//make sure we have a file
	if(fp==NULL)
	{
		//error opening file
		printf("ERROR: Writing WLZ volume...  [VOLIO.cpp\save_WLZ()]\n");
		system("pause");
		exit(1);
	}

	//we have a file, then write it to hd
	WlzWriteObj(fp, obj);

	//close our file pointer
	fclose(fp);

	//free up our WLZ objects
	WlzFreeObj(obj);

	//delete our 3D array
	{
	for(int i=0; i<volobj->texwidth; i++)
	{
		for(int j=0; j<volobj->texwidth; j++)
		{
			delete[] texture[i][j];
		}
		
		delete[] texture[i];
	}
	}
}*/
void VolIO::reload_data(void)
{
	printf("Reloading Data...\n");
	if(volobj->file_type==-1) return;
	else if(volobj->file_type==0) load_PNG(volobj->file_name, 4);		
	else if(volobj->file_type==1) load_RAW(volobj->file_name, 4);	
	//else if(volobj->file_type==2) load_WLZ(volobj->file_name, 4);	
}

/*
void VolIO::load_WLZ(QString filename, int channelmode)
{
	red=green=blue=false;
	//	printf("Loading WLZ volume...\n");

	WlzErrorNum error = WLZ_ERR_NONE;
	WlzObject *obj_ini=NULL;
	WlzObject *obj=NULL;
	WlzGreyValueWSpace *gVWSp=NULL;
	WlzIBox3 bbox;
	WlzAffineTransform *sclT;

//	float max_res = volobj->maxsize;

	FILE *fp=NULL;

	volobj->file_name = filename;

	//Open a file stream to our WLZ file
	fp = fopen(filename.latin1(), "rb");

	//make sure we have a file
	if(fp==NULL)
	{
		//error opening file
//		printf("ERROR: Loading WLZ volume...  [VOLIO.cpp\load_WLZ()]\n");
//		system("pause");
//		exit(1);
		QMessageBox* mb = new QMessageBox( "WARNING",
				"Could not open file in [VOLIO.cpp\load_WLZ()]\n",QMessageBox::Warning,
				QMessageBox::Ok | QMessageBox::Default,0,0 );

		mb->exec();
		//exit(1);
		return;
	}

	progressbar = new Q3ProgressDialog("Resizing WLZ Volume...", "Cancel", 8, 0, "progress", TRUE);		
	progressbar->setCaption("Please Wait");
	
	//update our progress bar
    progressbar->setProgress(1);

	//read in our wlz_object from file
	obj_ini = WlzAssignObject(WlzReadObj(fp, &error), NULL);

	if(error!=WLZ_ERR_NONE)
	{
		QMessageBox* mb = new QMessageBox( "WARNING",
				"WLZ ERROR!!  Failed to WlzAssignObject() in [VOLIO.cpp\load_WLZ()]\n",QMessageBox::Warning,
				QMessageBox::Ok | QMessageBox::Default,0,0 );

		delete progressbar;
		progressbar=NULL;
		mb->exec();
		//exit(1);
		return;
		//printf("WLZ ERROR!!  [VOLIO.cpp\load_WLZ()]\n");
	}
	//close our file stream
	fclose(fp);
	//update our progress bar
    progressbar->setProgress(2);

	//create a Wlz bounding box
//	3("Computing Bounding Box...\n");
	bbox = WlzBoundingBox3I(obj_ini, NULL);

	//evaluate our volume bounds, so that we can scale automatically
	//to fit 256x256x256
	int width = bbox.xMax - bbox.xMin + 1;
	int height= bbox.yMax - bbox.yMin + 1;
	int depth = bbox.zMax - bbox.zMin + 1;

	printf("WLZ size: %d , %d , %d \n", width, height, depth);

	//work out how much "too big" we are
	float scalex = (float)width/volobj->maxsizeX;
	float scaley = (float)height/volobj->maxsizeY;
	float scalez = (float)depth/volobj->maxsizeZ;

	//work out which axis is max
	float max=0;
	if(scalex>max) max = scalex;
	if(scaley>max) max = scaley;
	if(scalez>max) max = scalez;

	//now avoid DIV 0 and evaluate our scale factor
	if(max!=0.0)  max = 1.0/max;
	else max = 1.0;
	
	//dont upscale
	if(max>=1.0) max = 1.0;

	WLZ_rescale = max;

	printf("WLZ Scale factor: %f\n", WLZ_rescale);
	//update our progress bar
    progressbar->setProgress(3);

	//create a Wlz affine transform matrix
	sclT = WlzMakeAffineTransform(WLZ_TRANSFORM_3D_AFFINE, 0);

	//set our diagonals ( SCALE )
	sclT->mat[0][0] = max;
	sclT->mat[1][1] = max;
	sclT->mat[2][2] = max;

//	printf("Scaling volume...\n");
	//update our progress bar
    progressbar->setProgress(4);

	//apply our affine transform to our WLZ object
	obj = WlzAffineTransformObj(obj_ini, sclT, WLZ_INTERPOLATION_NEAREST , 0);
	WlzFreeObj(obj_ini);
	//update our progress bar
    progressbar->setProgress(5);

	//create a Wlz bounding box
	bbox = WlzBoundingBox3I(obj, NULL);

	//update our progress bar
    progressbar->setProgress(6);

	//evaluate our new volume bounds
	width = bbox.xMax - bbox.xMin +1;
	height= bbox.yMax - bbox.yMin +1;
	depth = bbox.zMax - bbox.zMin +1;
	
	float value=0;
	int x, y, z;

	//set up our texture info
	volobj->width = width;
	volobj->height = height;
	volobj->depth = depth;

	//update our progress bar
    progressbar->setProgress(7);

	//force our 3d texture to be square
	//makepow2();
	volobj->texwidth = volobj->maxsizeX;
	volobj->texheight = volobj->maxsizeY;
	volobj->texdepth = volobj->maxsizeZ;

	if(volobj->texture3d==0 || channelmode==4 || channelmode==1) 
	{
		//lets be clean
		if(volobj->texture3d) delete[] volobj->texture3d;
		volobj->texture3d = NULL;

		//lets have some memory for our texture data
		volobj->texture3d = (GLubyte *)malloc(volobj->texwidth * volobj->texheight 
								  * volobj->texdepth * 3 * sizeof(GLubyte));

		//check if we managed to allocate some memory
 		if(volobj->texture3d == NULL)
		{
			QMessageBox* mb = new QMessageBox( "ERROR",
					"Failed to allocate memory. \n",QMessageBox::Warning,
					QMessageBox::Ok | QMessageBox::Default,0,0 );

			delete progressbar;
			progressbar=NULL;
			mb->exec();
			exit(1);
			return;
		}

		for(int i=0; i<volobj->texwidth*volobj->texheight*volobj->texdepth*3; i++) volobj->texture3d[i]=0;
	}

	//update our progress bar
    progressbar->setProgress(8);
	delete progressbar;
	progressbar=NULL;

  //printf("WLZ SCALED size: %d , %d , %d \n", width, height, depth);
  //printf("TEXTURE3D size: %d , %d , %d \n", volobj->texwidth, volobj->texheight, volobj->texdepth);

  gVWSp = WlzGreyValueMakeWSp(obj, 0);

  //printf("Setting Values...\n");

  int index1D;
 
  int centrex, centrey, centrez;

  centrex = (volobj->texwidth-width)/2;
  centrey = (volobj->texheight-height)/2;
  centrez = (volobj->texdepth-depth)/2;

  progressbar = new Q3ProgressDialog("Loading WLZ Volume...", "Cancel", width, 0, "progress", TRUE);		
  progressbar->setCaption("Please Wait");

  //traverse our volume
	bool greyscale = false;
  for(x=0; x<width; x++)
  {
    progressbar->setProgress(x);
    if (progressbar->wasCancelled())
        break;

	for(y=0; y<height; y++)
    {
	  for(z=0; z<depth; z++)	
	  {
			//work out the current index
			index1D =  3*(((((centrez+z)*volobj->texheight)+(centrey+y))*volobj->texwidth)+(centrex+x));

			//get the current voxel
			WlzGreyValueGet(gVWSp, bbox.zMin+z, bbox.yMin+y, bbox.xMin+x); 
			
			
			 // WLZ_GREY_INT = 1,
			 // WLZ_GREY_LONG = 0,
			 // WLZ_GREY_SHORT = 2,
			//  WLZ_GREY_UBYTE = 3,
			//  WLZ_GREY_FLOAT = 4,
			//  WLZ_GREY_DOUBLE = 5,
			//  WLZ_GREY_BIT = 6,
			//  WLZ_GREY_RGBA = 7, 
			

			//what type is it
 			if(gVWSp->gType==WLZ_GREY_INT)
			{
			//	printf("WLZ_GREY_INT\n");
				value = (*(gVWSp->gVal)).inv;
			}
			else if(gVWSp->gType==WLZ_GREY_LONG)
			{
			//	printf("WLZ_GREY_LONG\n");
				value = (int)(*(gVWSp->gVal)).lnv;
			}	
			else if(gVWSp->gType==WLZ_GREY_SHORT)
			{
			//	printf("WLZ_GREY_SHORT\n");
				value = (*(gVWSp->gVal)).shv;
			}
			else if(gVWSp->gType==WLZ_GREY_UBYTE)
			{
			//	printf("WLZ_GREY_UBYTE\n");
				value = (*(gVWSp->gVal)).ubv;
			}
			else if(gVWSp->gType==WLZ_GREY_FLOAT)
			{
			//	printf("WLZ_GREY_FLOAT\n");
				value = (*(gVWSp->gVal)).flv;
			}
			else if(gVWSp->gType==WLZ_GREY_DOUBLE)
			{
			//	printf("WLZ_GREY_DOUBLE\n");
				value = (*(gVWSp->gVal)).lnv;	
			}

			//load it up in our texture3d obj,
			if(channelmode==1)
			{
				volobj->texture3d[index1D+0] = (int)value;
				red = true;
		//		volobj->texture3d[index1D+3] = (int)value;
			}
			if(channelmode==2)
			{
				volobj->texture3d[index1D+1] = (int)value;
				green = true;
	//			volobj->texture3d[index1D+3] = max(value,volobj->texture3d[index1D+3]);
			}
			if(channelmode==3)
			{
				volobj->texture3d[index1D+2] = value;
				blue = true;
			//	volobj->texture3d[index1D+3] = max(value,volobj->texture3d[index1D+3]);
			}
			if(channelmode==4)
			{
				volobj->texture3d[index1D+0] = (int)value;
				volobj->texture3d[index1D+1] = (int)value;
				volobj->texture3d[index1D+2] = (int)value;
			//	volobj->texture3d[index1D+3] = (int)value;

				red = true;
				green = false;
				blue = false;
				greyscale=true;
			}
			if(channelmode==5)
			{
				volobj->texture3d[index1D+0] = (int)value;
				volobj->texture3d[index1D+1] = (int)value;
				volobj->texture3d[index1D+2] = (int)value;
			//	volobj->texture3d[index1D+3] = (int)value;

				red = true;
				green = false;
				blue = false;
				greyscale=true;
			}
      }
    }
  }
  delete progressbar;
  progressbar = NULL;
 
 // resize();
  
  //free up our WLZ objects
  WlzFreeObj(obj);
  WlzGreyValueFreeWSp(gVWSp);
  WlzFreeAffineTransform(sclT);

  pad(1);


	if(greyscale && (channelmode==4 || channelmode==5))
	{
		volobj->is_greyscale = 1;
		volobj->has_red = 1;
		volobj->has_green = 0;
		volobj->has_blue = 0;
	}
	else
	{
		volobj->is_greyscale = 0;
		volobj->has_red = red;
		volobj->has_green = green;
		volobj->has_blue = blue;
	}

	max=0;
	if(volobj->texwidth>max) max = volobj->texwidth;
	if(volobj->texheight>max) max = volobj->texheight;
	if(volobj->texdepth>max) max = volobj->texdepth;
	volobj->maxres = max;
	
	cout<<"(r,g,b) "<< red<<" "<<green<<" "<<blue<<endl;
	cout<<"greyscale "<<greyscale<<endl;
	cout<<"maxres "<<volobj->maxres<<endl;
//  system("pause");
}
*/


void VolIO::load_xyzscale_fromlogfile(QString dirname)
{
//	printf("dirname: %s\n", dirname.latin1());

	string label;

	QDir dir;
	dir.setSorting(QDir::Name);
	dir.setFilter( QDir::Files | QDir::Hidden | QDir::NoSymLinks );
	dir.setNameFilter("*.log");
	dir.cd(dirname);

	//string list of our files in the directory
	QStringList strList;
	strList = dir.entryList();
	
	if(strList.size())
	{
		QString logfile = dirname + strList[0].ascii();

		printf("LOADING: logfile: %s\n", logfile.latin1());
		
		ifstream input_logfile; 
		input_logfile.open(logfile.latin1());
		Tokenizer tokenizer(input_logfile);
		
		//until oef is reached step through each token
		while(!input_logfile.eof())
		{			
			if(tokenizer.ttype()==TT_WORD)
			{
				//get the first string lable
				label = tokenizer.sval();									
				//cout<<label<<endl;
				
				if(label=="Pixel")
				{							
					//cout<<"Found Pixel"<<endl;						
					tokenizer.nextToken();
					label = tokenizer.sval();					
					//cout<<"	"<<label<<endl;

					if(label=="Size")
					{		
						//cout<<"Found Size"<<endl;						
						tokenizer.nextToken();
						tokenizer.nextToken();
						tokenizer.nextToken();
						label = tokenizer.sval();					
						//cout<<"		"<<label<<endl;

						if(label=="um")
						{		
							//cout<<"Found scale!"<<endl;
							while(tokenizer.ttype()!=TT_NUMBER) tokenizer.nextToken();
							
							volobj->xscale = volobj->yscale = volobj->zscale = tokenizer.nval();
						}
					}				
					
				}
				//else we dont know what it is, go to next label
				else
				{
					//cout<<"WARNING: Unrecognized Label..."<<endl;
					tokenizer.nextToken();
				}
			}
			else tokenizer.nextToken();
		}
		input_logfile.close();
	}
}

void VolIO::load_xyzscale(QString filename)
{
	string label;
	ifstream input_file; 
	input_file.open(filename.latin1());

	//tokenize our input file
	Tokenizer token(input_file);
	
	if(!input_file.is_open())
	{
		volobj->xscale=1.0;
		volobj->yscale=1.0;
		volobj->zscale=1.0;
	}
	else
	{
		//until oef is reached step through each token
		while(!input_file.eof())
		{
			if(token.ttype()==TT_WORD)
			{
				//get the first string lable
				label = token.sval();
				
				if(label=="x")
				{		
					token.nextToken();
					if(token.ttype()==TT_NUMBER) volobj->xscale = token.nval();
				}
				else if(label=="y")
				{		
					token.nextToken();
					if(token.ttype()==TT_NUMBER) volobj->yscale = token.nval();
				}
				else if(label=="z")
				{		
					token.nextToken();
					if(token.ttype()==TT_NUMBER) volobj->zscale = token.nval();
				}
				//else we dont know what it is, go to next label
				else
				{
					//cout<<"WARNING: Unrecognized Label..."<<endl;
					token.nextToken();
				}
			}
			else token.nextToken();
		}
		input_file.close();
	}

	printf("LOADING: volobj->scale: %f, %f, %f\n", volobj->xscale, volobj->yscale, volobj->zscale);
}

void VolIO::load_xyzspacing(QString filename)
{
	ifstream input_file; 
	input_file.open(filename.latin1());

	Tokenizer tokenizer(input_file);

	if(!input_file.is_open())
	{
		volobj->xsize=1.0;
		volobj->ysize=1.0;
		volobj->zsize=1.0;
	}
	else
	{
		//tokenize our input file
		Tokenizer token(input_file);
		string label;

		//until oef is reached step through each token
		while(!input_file.eof())
		{
			if(token.ttype()==TT_WORD)
			{
				//get the first string lable
				label = token.sval();
				
				if(label=="x")
				{		
					token.nextToken();
					if(token.ttype()==TT_NUMBER) volobj->xsize = token.nval();
				}
				else if(label=="y")
				{		
					token.nextToken();
					if(token.ttype()==TT_NUMBER) volobj->ysize = token.nval();
				}
				else if(label=="z")
				{		
					token.nextToken();
					if(token.ttype()==TT_NUMBER) volobj->zsize = token.nval();
				}
				//else we dont know what it is, go to next label
				else
				{
					//cout<<"WARNING: Unrecognized Label..."<<endl;
					token.nextToken();
				}
			}
			else token.nextToken();
		}
		input_file.close();
	}

	printf("LOADING: volobj->spacing: %f, %f, %f\n", volobj->xsize, volobj->ysize, volobj->zsize);

	volobj->maxsize =  max((float)volobj->xsize, (float)volobj->ysize);
	volobj->maxsize =  max((float)volobj->maxsize, (float)volobj->zsize);
	
	printf("LOADING: volobj->maxsize: %f\n", volobj->maxsize);
}

/*!
	Load up a RAW volume
*/

void VolIO::load_RAW(QString filename, int channelmode)
{
	/*if(volobj->is16bit)
	{
		for(int i=0; i<volobj->voldatasize; i++)
			delete[] volobj->voldata[i];
		
		if(volobj->voldata) delete volobj->voldata;
		volobj->voldata = NULL;		
	}*/

	red=green=blue=false;
	volobj->is16bit=false;

	//load in a raw vol file
	RAW_volume raw_vol;

	QString dirname;
	dirname = filename;
	int pos = dirname.findRev(QString("/").latin1(), -1, false);
	dirname.replace(pos+1, dirname.length()-pos+1, "");

	load_xyzspacing(dirname+"voxelspacing.txt");
	load_xyzscale(dirname+"voxelscale.txt");

	//load RAW description
	raw_vol.load_DAT(filename.latin1());

	WLZ_rescale = raw_vol.WLZ_scale;

	volobj->file_name = filename;

	if(raw_vol.res_x==0) return;
	if(raw_vol.res_y==0) return;
	if(raw_vol.res_z==0) return;

	volobj->width = volobj->texwidth = raw_vol.res_x;
	volobj->height =volobj->texheight = raw_vol.res_y;
	volobj->depth =volobj->texdepth = raw_vol.res_z; 

	cout<<"Volume: "<<raw_vol.res_x<<" "<<raw_vol.res_y<<" "<<raw_vol.res_z<<endl;
	
	printf("WLZ_rescale: %f\n", WLZ_rescale);

	volobj->x_resize = volobj->y_resize = volobj->z_resize = WLZ_rescale;
	
	//printf("channelmode %d\n", channelmode);

	if(volobj->texture3d==0 || channelmode==4 || channelmode==1) 
	{
		//lets be clean
		if(volobj->texture3d) delete[] volobj->texture3d;
		volobj->texture3d = NULL;

		//lets have some memory for our texture data
		volobj->texture3d = (GLubyte *)malloc(volobj->texwidth * volobj->texheight 
								  * volobj->texdepth * 3 * sizeof(unsigned char));

		//check if we managed to allocate some memory
 		if(volobj->texture3d == NULL)
		{
			QMessageBox* mb = new QMessageBox( "ERROR",
					"Failed to allocate memory in [VOLIO.cpp load_RAW()]\n",QMessageBox::Warning,
					QMessageBox::Ok | QMessageBox::Default,0,0 );

			mb->exec();
			//exit(1);
			return;
		}

		//initialise everything to zero
		for(int ii=0; ii<volobj->texwidth*volobj->texheight*volobj->texdepth*3; ii++) volobj->texture3d[ii] = 0;
	}

	filename.truncate(filename.length()-3);                            
	filename += "raw";

	FILE *f;
	f = fopen(filename.latin1(), "rb");					// Open "filename" For Reading Bytes

	if( f== NULL )
	{	
		//error opening file
//		printf("ERROR: Loading RAW volume...  [VOLIO.cpp\load_RAW()]\n");
//		system("pause");
		QMessageBox* mb = new QMessageBox( "WARNING",
				"Could not open file in [VOLIO.cpp load_RAW()] \n",QMessageBox::Warning,
				QMessageBox::Ok | QMessageBox::Default,0,0 );

		mb->exec();
		//exit(1);
		return;
	}

	//printf("Loading RAW volume... \n");

	int z_offset = (volobj->texdepth-raw_vol.res_z)/2.0;

	progressbar = new Q3ProgressDialog("Loading RAW Volume...", "Cancel", volobj->texdepth, 0, "progress", TRUE);		
	progressbar->setCaption("Please Wait");
	progressbar->raise();

	bool greyscale = false;
	int helper=0;

	if(channelmode==4)
	{
		greyscale = red = green = blue = false;
	}

	printf("channelmode: %d\n", (int)channelmode);

	for(int i=0; i<3*256; i++) volobj->histogram[i]=0.0;

	// Loop Through the depth
	for (int z =0; z<volobj->texdepth; z++)
	{	
		//progress(z, raw_vol.res_z+z_offset);
        progressbar->setProgress(z);
        if (progressbar->wasCancelled())
            break;

		raw_vol.load_RAW(z, f, volobj->texture3d, channelmode, volobj->texwidth, volobj->texheight, volobj->histogram, &red, &green, &blue, &greyscale);
		
		if(greyscale) helper++;
	}

	delete progressbar;
	progressbar = NULL;

	fclose(f);	// Close The File
	
	volobj->maxdimension = volobj->texwidth;
	volobj->maxdimension = max((float)volobj->maxdimension, (float)volobj->texheight);
	volobj->maxdimension = max((float)volobj->maxdimension, (float)volobj->texdepth);
	
	if(helper==volobj->texdepth) greyscale=true;
	else greyscale=false;

	printf("(r,b,g): %d, %d, %d\n", (int)red, (int)green, (int)blue);
	printf("greyscale: %d\n", (int) greyscale);

	if(greyscale && channelmode==4)
	{
		volobj->is_greyscale = 1;
		volobj->has_red = 1;
		volobj->has_green = 0;
		volobj->has_blue = 0;
	}
	else
	{
		volobj->is_greyscale = 0;
		volobj->has_red = red;
		volobj->has_green = green;
		volobj->has_blue = blue;
	}

	if(channelmode==1)
	{
		volobj->is_greyscale = 0;
		volobj->has_red = red;
		volobj->has_green = 0;
		volobj->has_blue = 0;
	}
	else if(channelmode==2)
	{
		volobj->is_greyscale = 0;
		volobj->has_green = green;
	}
	else if(channelmode==3)
	{
		volobj->is_greyscale = 0;
		volobj->has_blue = blue;
	}

	printf("(r,b,g): %d, %d, %d\n", (int)volobj->has_red, (int)volobj->has_green, (int)volobj->has_blue);
	printf("greyscale: %d\n", (int) volobj->is_greyscale);

	float x_resize, y_resize, z_resize;
	x_resize = volobj->width/(float) volobj->maxsizeX;
	y_resize = volobj->height/(float) volobj->maxsizeY;
	z_resize = volobj->depth/(float) volobj->maxsizeZ;

	if(x_resize<1.0) x_resize = 1;
	if(y_resize<1.0) y_resize = 1;
	if(z_resize<1.0) z_resize = 1;

	int res_x = ((float)volobj->width/x_resize)+0.5; 
	int res_y = ((float)volobj->height/y_resize)+0.5;
	int res_z = ((float)volobj->depth/z_resize)+0.5; 

	float maxres1 = 0.0;
	maxres1 = max((float)maxres1, (float)res_x);
	maxres1 = max((float)maxres1, (float)res_y);
	maxres1 = max((float)maxres1, (float)res_z);
	volobj->maxres = maxres1;

	resize();
	pad(1);
}

/*!
	Load up a volume from PNG slices
*/
/*
void VolIO::load_PNG(QString filename, int mode)
{
	//set our opt data directory
	QDir d;
	d.setSorting(QDir::Name);
	d.setFilter( QDir::Files | QDir::Hidden | QDir::NoSymLinks );
	d.setNameFilter("*.png *.bmp");
	d.cd(dirname);

	volobj->file_name = dirname;

	if(d.count()==0)
	{
		//error opening file
//		printf("ERROR: No files found in directory...  [VOLIO.cpp\load_PNG()]\n");
//		system("pause");
//		exit(1);
		QMessageBox* mb = new QMessageBox( "WARNING",
				"No files found in directory. \n",QMessageBox::Warning,
				QMessageBox::Ok | QMessageBox::Default,0,0 );

		mb->exec();
		exit(1);
		return;
	}
}*/

void VolIO::load_TIFF(QString dirname, int mode)
{
/*	if(volobj->is16bit)
	{
		for(int i=0; i<volobj->voldatasize; i++)
			delete[] volobj->voldata[i];
		
		if(volobj->voldata) delete volobj->voldata;
		volobj->voldata = NULL;		
	}

	//set our opt data directory
	QDir d;
	d.setSorting(QDir::Name);
	d.setFilter( QDir::Files | QDir::Hidden | QDir::NoSymLinks );
	d.setNameFilter("*.png *.bmp *.jpg *.tif");
	d.cd(dirname);

	//string list of our files in the directory
	QStringList strList;
	strList = d.entryList();

	printf("number of files found: %d\n", d.count());

	QStringList discarded_filenames;
	QString tempfn;
	for(int i=0; i<d.count(); i++)
	{
		tempfn = d[i].ascii();

		if(tempfn.contains("_spr", false))
		{
			discarded_filenames += tempfn;
			//break;
		}

		//tempfn = "";
	}
	
	for(int i=0; i<discarded_filenames.size(); i++)
	{
		strList.remove(discarded_filenames.at(i));
	}
//	if(tempfn!="") strList.remove(tempfn);

	volobj->file_name = dirname;

	if(d.count()==0)
	{
		QMessageBox* mb = new QMessageBox( "WARNING",
				"No files found in directory in [VOLIO.cpp load_PNG()] \n",QMessageBox::Warning,
				QMessageBox::Ok | QMessageBox::Default,0,0 );

		mb->exec();
		//exit(1);
		return;
	}

	//workout our 1st filename
	QString fn = dirname;
	fn += strList[0].ascii();

	int filenamemode=4;
	int greyscale, helper;
	helper =0;

	greyscale = helper = 0;
	TIFF* tifobject = TIFFOpen(fn, "r");

	int dircount = 0;
	do 
	{
	    dircount++;
	}
	while (TIFFReadDirectory(tifobject));

	if(dircount>1)
	{
		printf("Loading mult	QString dirname = fn;

	//remove the filename of first file to get only dirname
	int pos = dirname.findRev(QString("/").latin1(), -1, false);
	dirname.replace(pos+1, dirname.length()-pos+1, "");
i-page TIFF data\n");
		printf("Tiff files: %d\n", dircount);

		if (tifobject) 
		{
			uint32* raster32bit=NULL;
			uint32 w, h;
			uint16 datatype, bpp, unitres, spp;
			float unitresX = 0.0;
			float unitresY = 0.0;
			size_t npixels;
			char* descp;

			TIFFGetField(tifobject, TIFFTAG_IMAGEWIDTH, &w);
			TIFFGetField(tifobject, TIFFTAG_IMAGELENGTH, &h);
			TIFFGetField(tifobject, TIFFTAG_BITSPERSAMPLE, &bpp);
			TIFFGetField(tifobject, TIFFTAG_XRESOLUTION, &unitresX);
			TIFFGetField(tifobject, TIFFTAG_YRESOLUTION, &unitresY);
			TIFFGetField(tifobject, TIFFTAG_RESOLUTIONUNIT, &unitres);
			TIFFGetField(tifobject, TIFFTAG_IMAGEDESCRIPTION, &descp);
			TIFFGetField(tifobject, TIFFTAG_SAMPLESPERPIXEL, &spp);
			QString description = descp;
			
			printf("--------------------------\n");
			printf("Tiff Info:\n");
			printf("%w:%d h:%d\n", (int)w, (int)h);
			printf("bpp: %d\n", (int) bpp);
			printf("spp: %d\n", (int) spp);
			printf("unitresX: %f\n", (float)unitresX);
			printf("unitresY: %f\n", (float)unitresY);
			printf("unitres: %f\n", (float)unitres);
			printf("description: \n%s\n", description.latin1());
			printf("--------------------------\n");
			
			set_metadata((float)unitresX, (float)unitresY, description);

			if(w==0 && h==0)
			{
				QMessageBox* mb = new QMessageBox( "WARNING",
						"Could not open a file in [VOLIO.cppload_PNG()] \n",QMessageBox::Warning,
						QMessageBox::Ok | QMessageBox::Default,0,0 );

				mb->exec();
				return;
			}

			//set up our texture info
			volobj->width = volobj->texwidth = w;
			volobj->height=volobj->texheight = h;
			volobj->depth =volobj->texdepth = dircount; 
				
			uint32 index_3D, index_small;
			float x2, y2, z2;
			int r,g,b,a;
			x2 = offset_x;
			y2 = offset_y;
			z2 = offset_z;
			
			float x,y,z;
			
			//==============================================================
			eval_resize_dimensions();
			
			int size = res_x*res_y*res_z*3;

			//lets have some texture memory
			if(volobj->texture3d==0 || mode==4 || mode==1) 
			{
				if(volobj->texture3d) delete[] volobj->texture3d;
				volobj->texture3d = NULL;

				//lets have some memory for our texture data
				volobj->texture3d = (GLubyte *) malloc(size * sizeof(GLubyte));

				//check if we managed to allocate some memory
				if(volobj->texture3d == NULL)
				{
					QMessageBox* mb = new QMessageBox( "ERROR",
							"Failed to allocate memory in [VOLIO.cpp load_TIF()] \n",QMessageBox::Warning,
							QMessageBox::Ok | QMessageBox::Default,0,0 );

					mb->exec();
					//exit(1);
					return;
				}

				//initialise everything to zero
				for(int ii=0; ii<size; ii++) volobj->texture3d[ii] = 0;
			}		
					
			if(mode==4 || mode==5) for(int i=0; i<3*256; i++) volobj->histogram[i]=0.0;

			progressbar = new Q3ProgressDialog("Loading multi-page TIFF file...", "Cancel", volobj->depth, 0, "progress", TRUE);		
			progressbar->setCaption("Please Wait");
			progressbar->raise();
		

    		if(bpp==8)
			{				
				//now lets allocate some memory for our raw tiff...
				npixels = w*h;
				raster32bit = (uint32*) _TIFFmalloc(npixels * sizeof (uint32));
				if(raster32bit==NULL)
				{
					printf("ERROR allocating memory, raster32bit \n");
				}
				
				//DO SOME STUFF HERE WITH THE IMAGE.
				for(float z=0; z<volobj->depth; z+=volobj->z_resize)
				{
					//update our progress bar
					progressbar->setProgress((int)z);
					if (progressbar->wasCancelled())
						break;
										
					//tifobject = TIFFOpen(fn.latin1(), "r");
					TIFFSetDirectory(tifobject, z);		
					TIFFReadRGBAImage(tifobject, w, h, raster32bit, 0);

					for(float x=0; x<volobj->width; x+=volobj->x_resize)
					{
						for(float y=0; y<volobj->height; y+=volobj->y_resize)
						{
							uint32 pixel = (uint32) raster32bit[(int)(x+0.5)+(int)(((volobj->height-1)-y)+0.5)*volobj->width];

							if(x2>=res_x) x2=res_x-1;
							if(y2>=res_y) y2=res_y-1;
							if(z2>=res_z) z2=res_z-1;

							index_small = ((((((int)((res_z-1)-z2))*(int)(res_y))+((int)(y2)))*(int)(res_x))+((int)(x2)));

							r = (uint8) TIFFGetR(pixel);
							g = (uint8) TIFFGetG(pixel);
							b = (uint8) TIFFGetB(pixel);
							a = (uint8) TIFFGetR(pixel);

							if(r==g && r==b && b==g) greyscale++;

							helper++;

							if(r!=0) red = true;
							if(g!=0) green = true;
							if(b!=0) blue = true;

							if(mode==1)
							{
								volobj->texture3d[3*index_small+0] = GLubyte(r);
								volobj->histogram[(3*int(r))+0]++;
							}
							if(mode==2)
							{
								volobj->texture3d[3*index_small+1] = GLubyte(g); 
								volobj->histogram[(3*int(g))+1]++;
							}
							if(mode==3)
							{
								volobj->texture3d[3*index_small+2] = GLubyte(b); 
								volobj->histogram[(3*int(b))+2]++;
							}				
							if(mode==4)
							{
								volobj->texture3d[3*index_small+0] = GLubyte(r);
								volobj->texture3d[3*index_small+1] = GLubyte(g); 
								volobj->texture3d[3*index_small+2] = GLubyte(b); 
								volobj->histogram[(3*int(r))+0]++;
								volobj->histogram[(3*int(g))+1]++;
								volobj->histogram[(3*int(b))+2]++;
							}
							if(mode==5)
							{
								volobj->texture3d[3*index_small+0] =
								volobj->texture3d[3*index_small+1] =
								volobj->texture3d[3*index_small+2] = GLubyte(a);
								volobj->histogram[(3*int(a))+0]++;
								volobj->histogram[(3*int(a))+1]++;
								volobj->histogram[(3*int(a))+2]++;
							}								
							x2++;
						}
						y2++;
						x2=0;
					}
					z2++;
					y2=0;
				}
				_TIFFfree(raster32bit);
			}
			else if(bpp==16)
			{
					volobj->is16bit=true;

					for(int i=0; i<65536; i++) volobj->histogram16bit[i] = 0.0;
					
					if(volobj->voldata!=NULL) 
					{
						printf("De-allocating 16bit memory\n");
						
						for(int i=0; i<volobj->voldatasize; i++)
							delete[] volobj->voldata[i];
						
						delete volobj->voldata;
						volobj->voldata = NULL;	
					}			

					printf("Trying to allocate 16bit memory\n");				

					volobj->voldatasize = res_z;
					int size2 = res_x*res_y;

					volobj->voldata = new uint16*[res_z];
					for(int i=0; i<res_z; i++)
						volobj->voldata[i] = new uint16 [size2];
				
					if(volobj->voldata==NULL)
					{
						printf("Error allocating 16bit memory\n");
						return;
					}
					else
					{
						printf("Memory allocated OK\n");
					}
					
					//DO SOME STUFF HERE WITH THE IMAGE.
					for(float z=0; z<volobj->depth; z+=volobj->z_resize)
					{
						//update our progress bar
						progressbar->setProgress((int)z);
						if (progressbar->wasCancelled())
							break;
						
						TIFFSetDirectory(tifobject, z);

						uint32 linesize = TIFFScanlineSize(tifobject);
						char *buf = (char*) _TIFFmalloc(linesize * volobj->height);
						for (uint32 itertiff = 0; itertiff < (uint32)volobj->height; itertiff++)
						{							
							TIFFReadScanline(tifobject, &buf[itertiff * linesize], itertiff, 0);
						}
						
						for(float y=0; y<volobj->height; y+=volobj->y_resize)
						{
							for(float x=0; x<volobj->width; x+=volobj->x_resize)
							{
								//QRgb pixel = pm.pixel(int(x+0.5),int(y+0.5));
								uint16 pixel = ((uint16*) buf)[(int)(x+0.5)+((int)(y+0.5)*volobj->width)];
								r = g = b = a = int(((pixel/65535.0)*255.0)+0.5);
								
								//if(r>255) printf("OHNOH!\n");
								//if(r<0) printf("OHNOH!\n");							
								//printf("pixel-16bit: %d \n", pixel);
	//							printf("pixel-8bit: %d \n\n", int(((pixel/65535.0)*255.0)+0.5));
	//							printf("r: %d\n", r);
								//printf("r: %d g: %d b: %d\n", r,g,b);

								if(x2>=res_x) x2=res_x-1;
								if(y2>=res_y) y2=res_y-1;
								if(z2>=res_z) z2=res_z-1;

								index_small = (((z2*res_y)+y2)*res_x)+x2;
								int index2d = (y2*res_x)+x2;
								
								volobj->voldata[(int)(z2)][index2d] = pixel;
								//volobj->voldata[(int)(z2)][3*index2d+1] = pixel;
								//volobj->voldata[(int)(z2)][3*index2d+2] = pixel;
								
								if(r==g && r==b && b==g) greyscale++;

								helper++;

								if(r!=0) red = true;
								if(g!=0) green = true;
								if(b!=0) blue = true;

								volobj->histogram16bit[(int)pixel]++;
								volobj->histogram[(3*int(a))+0]++;
								volobj->histogram[(3*int(a))+1]++;
								volobj->histogram[(3*int(a))+2]++;

								//printf("int: %d\n", (int)pixel);

								if(mode==1)
								{
									volobj->texture3d[3*index_small+0] = a;
									//volobj->histogram[(3*int(a))+0]++;
								}
								else if(mode==2)
								{
									volobj->texture3d[3*index_small+1] = a; 
									//volobj->histogram[(3*int(a))+1]++;
								}
								else if(mode==3)
								{
									volobj->texture3d[3*index_small+2] = a; 
									//volobj->histogram[(3*int(a))+2]++;					
								}				
								else if(mode==4)
								{
									volobj->texture3d[3*index_small+0] = r;
									volobj->texture3d[3*index_small+1] = g; 
									volobj->texture3d[3*index_small+2] = b; 
									//volobj->histogram[(3*int(r))+0]++;
									//volobj->histogram[(3*int(g))+1]++;
									//volobj->histogram[(3*int(b))+2]++;
								}
								else if(mode==5)
								{
									volobj->texture3d[3*index_small+0] =
									volobj->texture3d[3*index_small+1] =
									volobj->texture3d[3*index_small+2] = a;
								}								
								y2++;
							}
							x2++;
							y2=0;
						}
						z2++;
						x2=0;
						_TIFFfree(buf);
				}
				_TIFFfree(raster32bit);
			}
		}
		TIFFClose(tifobject);
		delete progressbar;
		progressbar=NULL;

		//return;
	}
	else
	{
		printf("Loading single TIFF data\n");
		
		if (tifobject) 
		{
			uint32* raster32bit=NULL;
			uint32 w, h;
			uint16 datatype, bpp, unitres;
			float unitresX;
			float unitresY;
			size_t npixels;
			char* descp;

			TIFFGetField(tifobject, TIFFTAG_IMAGEWIDTH, &w);
			TIFFGetField(tifobject, TIFFTAG_IMAGELENGTH, &h);
			TIFFGetField(tifobject, TIFFTAG_BITSPERSAMPLE, &bpp);
			TIFFGetField(tifobject, TIFFTAG_XRESOLUTION, &unitresX);
			TIFFGetField(tifobject, TIFFTAG_YRESOLUTION, &unitresY);
			TIFFGetField(tifobject, TIFFTAG_RESOLUTIONUNIT, &unitres);
			TIFFGetField(tifobject, TIFFTAG_IMAGEDESCRIPTION, &descp);

			QString description = descp;

			printf("--------------------------\n");
			printf("Tiff Info:\n");
			printf("%w:%d h:%d\n", (int)w, (int)h);
			printf("bpp: %d\n", (int) bpp);
			printf("unitresX: %f\n", (float)unitresX);
			printf("unitresY: %f\n", (float)unitresY);
			printf("unitres: %f\n", (float)unitres);
			printf("description: \n%s\n", description.latin1());
			printf("--------------------------\n");
			
			/*TIFFGetField(tifobject, TIFFTAG_DATATYPE, &datatype);
			if(datatype==0)
				printf("TIFF_NOTYPE %d\n", datatype);
			else if(datatype=1)
				printf("TIFF_BYTE %d\n", datatype);
			else if(datatype==2)
				printf("TIFF_ASCII %d\n", datatype);
			else if(datatype==3)
				printf("TIFF_SHORT %d\n", datatype);
			else if(datatype==4)
				printf("TIFF_LONG \n", datatype);
			else if(datatype==5)
				printf("TIFF_RATIONAL \n", datatype);
			else if(datatype==6)
				printf("TIFF_SBYTE %d\n", datatype);
			else if(datatype==7)
				printf("TIFF_UNDEFINED %d\n", datatype);
			else if(datatype==8)
				printf("TIFF_SSHORT %d\n", datatype);
			else if(datatype==9)
				printf("TIFF_SLONG %d\n", datatype);
			else if(datatype==10)
				printf("TIFF_SRATIONAL %d\n", datatype);
			else if(datatype==11)
				printf("TIFF_FLOAT %d\n", datatype);
			else if(datatype==12)
				printf("TIFF_DOUBLE %d\n", datatype);
			else if(datatype==13)
				printf("TIFF_IFD %d\n", datatype);*/
			
			/*if(w==0 && h==0)
			{
				QMessageBox* mb = new QMessageBox( "WARNING",
						"Could not open a file in [VOLIO.cppload_PNG()] \n",QMessageBox::Warning,
						QMessageBox::Ok | QMessageBox::Default,0,0 );

				mb->exec();
				return;
			}

			//set up our texture info
			volobj->width = volobj->texwidth = w;
			volobj->height =volobj->texheight = h;
			volobj->depth =volobj->texdepth = strList.count(); 
				
			uint32 index_3D, index_small;
			float x2, y2, z2;
			int r,g,b,a;
			x2 = offset_x;
			y2 = offset_y;
			z2 = offset_z;
			
			float x,y,z;
			
			//==============================================================
			eval_resize_dimensions();
			
			int size = res_x*res_y*res_z*3;
			
			//lets have some texture memory
			if(volobj->texture3d==0 || mode==4 || mode==1) 
			{
				if(volobj->texture3d) delete[] volobj->texture3d;
				volobj->texture3d = NULL;

				//lets have some memory for our texture data
				volobj->texture3d = (GLubyte *) malloc(size * sizeof(GLubyte));

				//check if we managed to allocate some memory
				if(volobj->texture3d == NULL)
				{
					QMessageBox* mb = new QMessageBox( "ERROR",
							"Failed to allocate memory in [VOLIO.cpp load_PNG()] \n",QMessageBox::Warning,
							QMessageBox::Ok | QMessageBox::Default,0,0 );

					mb->exec();
					//exit(1);
					return;
				}

				//initialise everything to zero
				for(int ii=0; ii<size; ii++) volobj->texture3d[ii] = 0;
			}		
					
			if(mode==4 || mode==5) for(int i=0; i<3*256; i++) volobj->histogram[i]=0.0;

			progressbar = new Q3ProgressDialog("Loading TIFF Stack...", "Cancel", volobj->depth, 0, "progress", TRUE);		
			progressbar->setCaption("Please Wait");
			progressbar->raise();
		
    		if(bpp==8)
			{				
				//now lets allocate some memory for our raw tiff...
				npixels = w*h;
				raster32bit = (uint32*) _TIFFmalloc(npixels * sizeof (uint32));
				if(raster32bit==NULL)
				{
					printf("ERROR allocating memory, raster32bit \n");
				}
				
				//DO SOME STUFF HERE WITH THE IMAGE.
				for(float z=0; z<volobj->depth; z+=volobj->z_resize)
				{
					//update our progress bar
					progressbar->setProgress((int)z);
					if (progressbar->wasCancelled())
						break;
					
					fn = dirname + strList[(int) z].ascii();
					
					tifobject = TIFFOpen(fn.latin1(), "r");
					TIFFReadRGBAImage(tifobject, w, h, raster32bit, 1);
					
					for(float x=0; x<volobj->width; x+=volobj->x_resize)
					{
						for(float y=0; y<volobj->height; y+=volobj->y_resize)
						{
							//QRgb pixel = pm.pixel(int(x+0.5),int(y+0.5));
							uint32 pixel = (uint32) raster32bit[(int)(y+0.5)+(int)(((volobj->width-1)-x)+0.5)*volobj->height];
							
							if(x2>=res_x) x2=res_x-1;
							if(y2>=res_y) y2=res_y-1;
							if(z2>=res_z) z2=res_z-1;

							index_small = ((((((int)((res_z-1)-z2))*(int)(res_y))+((int)(y2)))*(int)(res_x))+((int)(x2)));
							//index_small = (((((x2)*res_y)+(z2))*res_x)+(y2));

							//printf("z: %d, %d, %d\n", (int)(res_z-z2), (int)(z2), (int)(res_z));
							//printf("index: %d\n", index_small);

							r = (uint8) TIFFGetR(pixel);
							g = (uint8) TIFFGetG(pixel);
							b = (uint8) TIFFGetB(pixel);
							a = (uint8) TIFFGetR(pixel);

							if(r==g && r==b && b==g) greyscale++;

							helper++;

							if(r!=0) red = true;
							if(g!=0) green = true;
							if(b!=0) blue = true;

							if(mode==1)
							{
								volobj->texture3d[3*index_small+0] = GLubyte(r);
								volobj->histogram[(3*int(r))+0]++;
							}
							if(mode==2)
							{
								volobj->texture3d[3*index_small+1] = GLubyte(g); 
								volobj->histogram[(3*int(g))+1]++;
							}
							if(mode==3)
							{
								volobj->texture3d[3*index_small+2] = GLubyte(b); 
								volobj->histogram[(3*int(b))+2]++;
							}				
							if(mode==4)
							{
								volobj->texture3d[3*index_small+0] = GLubyte(r);
								volobj->texture3d[3*index_small+1] = GLubyte(g); 
								volobj->texture3d[3*index_small+2] = GLubyte(b); 
								volobj->histogram[(3*int(r))+0]++;
								volobj->histogram[(3*int(g))+1]++;
								volobj->histogram[(3*int(b))+2]++;
							}
							if(mode==5)
							{
								volobj->texture3d[3*index_small+0] =
								volobj->texture3d[3*index_small+1] =
								volobj->texture3d[3*index_small+2] = GLubyte(a);
								volobj->histogram[(3*int(a))+0]++;
								volobj->histogram[(3*int(a))+1]++;
								volobj->histogram[(3*int(a))+2]++;
							}								
							x2++;
						}
						y2++;
						x2=0;
					}
					z2++;
					y2=0;
					TIFFClose(tifobject);
				}
				_TIFFfree(raster32bit);
			}
			else if(bpp==16)
			{
					volobj->is16bit=true;

					for(int i=0; i<65536; i++) volobj->histogram16bit[i] = 0.0;
					
					if(volobj->voldata!=NULL) 
					{
						printf("De-allocating 16bit memory\n");
						
						for(int i=0; i<volobj->voldatasize; i++)
							delete[] volobj->voldata[i];
						
						delete volobj->voldata;
						volobj->voldata = NULL;	
					}			

					printf("Trying to allocate 16bit memory\n");				

					volobj->voldatasize = res_z;
					int size2 = res_x*res_y;

					volobj->voldata = new uint16*[res_z];
					for(int i=0; i<res_z; i++)
						volobj->voldata[i] = new uint16 [size2];
				
					if(volobj->voldata==NULL)
					{
						printf("Error allocating 16bit memory\n");
						return;
					}
					else
					{
						printf("Memory allocated OK\n");
					}
					
					//DO SOME STUFF HERE WITH THE IMAGE.
					for(float z=0; z<volobj->depth; z+=volobj->z_resize)
					{
						//update our progress bar
						progressbar->setProgress((int)z);
						if (progressbar->wasCancelled())
							break;
						
						fn = dirname + strList[(int) z].ascii();
						
						tifobject = TIFFOpen(fn.latin1(), "r");

						uint32 linesize = TIFFScanlineSize(tifobject);
						char *buf = (char*) _TIFFmalloc(linesize * volobj->height);

						for (uint32 itertiff = 0; itertiff < (uint32)volobj->height; itertiff++)
						{
							
	//						printf("TIFFReadScanline: %d\n", TIFFReadScanline(tifobject, buf, itertiff, 0));
							TIFFReadScanline(tifobject, &buf[itertiff * linesize], itertiff, 0);
		
							//&raster32bit[itertiff * linesize] = (tdata_t) buf[itertiff];
							
			/*				for(uint32 itertiff2=0; itertiff2<volobj->width; itertiff2++)
							{
								int tempindex = (itertiff2 * volobj->width)+ (int) (x+0.5);
								raster32bit[tempindex] = 65365;//(uint32) buf[itertiff2];
							}*/
	//-------->				}
						//_TIFFfree(buf);
						
	//						&raster32bit[itertiff * linesize]
						//TIFFReadRGBAImage(tifobject, w, h, raster32bit, 1);

		/*				
						for(float y=0; y<volobj->height; y+=volobj->y_resize)
						{
							for(float x=0; x<volobj->width; x+=volobj->x_resize)
							{
								//QRgb pixel = pm.pixel(int(x+0.5),int(y+0.5));
								uint16 pixel = ((uint16*) buf)[(int)(x+0.5)+((int)(y+0.5)*volobj->width)];
								r = g = b = a = int(((pixel/65535.0)*255.0)+0.5);
								
								//if(r>255) printf("OHNOH!\n");
								//if(r<0) printf("OHNOH!\n");							
								//printf("pixel-16bit: %d \n", pixel);
	//							printf("pixel-8bit: %d \n\n", int(((pixel/65535.0)*255.0)+0.5));
	//							printf("r: %d\n", r);
								//printf("r: %d g: %d b: %d\n", r,g,b);

								if(x2>=res_x) x2=res_x-1;
								if(y2>=res_y) y2=res_y-1;
								if(z2>=res_z) z2=res_z-1;

								index_small = (((z2*res_y)+y2)*res_x)+x2;
								int index2d = (y2*res_x)+x2;
								
								volobj->voldata[(int)(z2)][index2d] = pixel;
								//volobj->voldata[(int)(z2)][3*index2d+1] = pixel;
								//volobj->voldata[(int)(z2)][3*index2d+2] = pixel;
								
								if(r==g && r==b && b==g) greyscale++;

								helper++;

								if(r!=0) red = true;
								if(g!=0) green = true;
								if(b!=0) blue = true;

								volobj->histogram16bit[(int)pixel]++;
								volobj->histogram[(3*int(a))+0]++;
								volobj->histogram[(3*int(a))+1]++;
								volobj->histogram[(3*int(a))+2]++;

								//printf("int: %d\n", (int)pixel);

								if(mode==1)
								{
									volobj->texture3d[3*index_small+0] = a;
									//volobj->histogram[(3*int(a))+0]++;
								}
								else if(mode==2)
								{
									volobj->texture3d[3*index_small+1] = a; 
									//volobj->histogram[(3*int(a))+1]++;
								}
								else if(mode==3)
								{
									volobj->texture3d[3*index_small+2] = a; 
									//volobj->histogram[(3*int(a))+2]++;					
								}				
								else if(mode==4)
								{
									volobj->texture3d[3*index_small+0] = r;
									volobj->texture3d[3*index_small+1] = g; 
									volobj->texture3d[3*index_small+2] = b; 
									//volobj->histogram[(3*int(r))+0]++;
									//volobj->histogram[(3*int(g))+1]++;
									//volobj->histogram[(3*int(b))+2]++;
								}
								else if(mode==5)
								{
									volobj->texture3d[3*index_small+0] =
									volobj->texture3d[3*index_small+1] =
									volobj->texture3d[3*index_small+2] = a;
								}								
								y2++;
							}
							x2++;
							y2=0;
						}
						z2++;
						x2=0;
						_TIFFfree(buf);
					//}
					TIFFClose(tifobject);
				}
				_TIFFfree(raster32bit);
			}
		}

		delete progressbar;
		progressbar=NULL;
	}
	
	
	//set up our texture info
	volobj->width = volobj->texwidth = res_x;
	volobj->height =volobj->texheight = res_y;
	volobj->depth =volobj->texdepth = res_z;

	pad(1);

	volobj->maxdimension = volobj->texwidth;
	volobj->maxdimension = max(volobj->maxdimension, volobj->texheight);
	volobj->maxdimension = max(volobj->maxdimension, volobj->texdepth);
	
	if(greyscale==helper) greyscale=1;
	else greyscale=0;

	if(greyscale && mode==4)
	{
		volobj->is_greyscale = 1;
		volobj->has_red = 1;
		volobj->has_green = 0;
		volobj->has_blue = 0;
	}
	else if(mode==1)
	{
		volobj->is_greyscale = 0;
		volobj->has_red = red;
		volobj->has_green = 0;
		volobj->has_blue = 0;
	}
	else if(mode==2)
	{
		volobj->is_greyscale = 0;
		volobj->has_green = green;
	}
	else if(mode==3)
	{
		volobj->is_greyscale = 0;
		volobj->has_blue = blue;
	}
	else
	{
		volobj->is_greyscale = 0;
		volobj->has_red = red;
		volobj->has_green = green;
		volobj->has_blue = blue;
	}

	printf("(r,b,g): %d, %d, %d\n", (int)volobj->has_red, (int)volobj->has_green, (int)volobj->has_blue);
	printf("greyscale: %d\n", (int) volobj->is_greyscale);	*/
}

void VolIO::eval_resize_dimensions(void)
{
	volobj->x_resize = volobj->y_resize = volobj->z_resize = 0;
	volobj->x_resize = (float)(volobj->width)/(float)(volobj->maxsizeX);
	volobj->y_resize = (float)(volobj->height)/(float)(volobj->maxsizeY);
	volobj->z_resize = (float)(volobj->depth)/(float)(volobj->maxsizeZ);

	if(volobj->x_resize<1.0) volobj->x_resize = 1;
	if(volobj->y_resize<1.0) volobj->y_resize = 1;
	if(volobj->z_resize<1.0) volobj->z_resize = 1;

	float maxresize = 0;
	maxresize = max((float)maxresize, (float)volobj->x_resize);
	maxresize = max((float)maxresize, (float)volobj->y_resize);
	maxresize = max((float)maxresize, (float)volobj->z_resize);
	volobj->x_resize = volobj->y_resize = volobj->z_resize = maxresize;

	//printf("Max Resize: %f\n",maxresize);

	res_x = (((float)volobj->width/volobj->x_resize)+0.5); 
	res_y = (((float)volobj->height/volobj->y_resize)+0.5);
	res_z = (((float)volobj->depth/volobj->z_resize)+0.5); 

	int maxres1 = 0;
	int maxres2 = 0;
	int maxres3 = 0;
	maxres1 = max((float)maxres1, (float)res_x);
	maxres2 = max((float)maxres2, (float)res_y);
	maxres3 = max((float)maxres3, (float)res_z);
	
	volobj->maxres = 0;
	
	volobj->maxres = max((float)maxres1, (float)volobj->maxres);
	volobj->maxres = max((float)maxres2, (float)volobj->maxres);
	volobj->maxres = max((float)maxres3, (float)volobj->maxres);
	
	offset_x = offset_y = offset_z = 0;
	offset_x = ((makepower2(maxres1)-res_x)/2.0);
	offset_y = ((makepower2(maxres2)-res_y)/2.0); 
	offset_z = ((makepower2(maxres3)-res_z)/2.0); 

	res_x = res_y = res_z = 0;
	volobj->resized_texwidth = res_x = makepower2(maxres1);
	volobj->resized_texheight = res_y = makepower2(maxres2);
	volobj->resized_texdepth = res_z = makepower2(maxres3);

	//printf("Max Res: %d\n",volobj->maxres);
	printf("LOADING: Original Dimensions: %d, %d, %d\n", volobj->width, volobj->height, volobj->depth);
	printf("LOADING: Resized Dimensions: %d, %d, %d\n", volobj->resized_texwidth, volobj->resized_texheight, volobj->resized_texdepth);
	printf("Resize Factor: %f, %f, %f\n", volobj->x_resize, volobj->y_resize, volobj->z_resize);
	//printf("Offsets: %d, %d, %d\n", offset_x, offset_y, offset_z);	
}

void VolIO::init_subimageloading(QString dirname, int mode)
{
	volobj->file_name = dirname;
	load_xyzspacing(dirname+"voxelspacing.txt");
	load_xyzscale(dirname+"voxelscale.txt");
	load_xyzscale_fromlogfile(dirname);

	red=green=blue=false;
	volobj->is16bit=false;
	
	//set our opt data directory
	QDir d;
	d.setSorting(QDir::Name);
	d.setFilter( QDir::Files | QDir::Hidden | QDir::NoSymLinks );
	d.setNameFilter("*.png *.bmp *.jpg *.tif");
	d.cd(dirname);
			
	//string list of our files in the directory
	QStringList strList;
	strList = d.entryList();

	QString tempfn;
	for(int i=0; i<d.count(); i++)
	{
		tempfn = d[i].ascii();

		if(tempfn.contains("_spr", false))
		{
			break;
		}

		tempfn = "";
	}

	if(tempfn!="") strList.remove(tempfn);

	volobj->file_name = dirname;

	if(d.count()==0)
	{
		QMessageBox* mb = new QMessageBox( "WARNING",
				"No files found in directory in [VOLIO.cpp load_PNG()] \n",QMessageBox::Warning,
				QMessageBox::Ok | QMessageBox::Default,0,0 );

		mb->exec();
		//exit(1);
		return;
	}

	//workout our 1st filename
	QString fn = dirname;
	fn += strList[0].ascii();

	int filenamemode=0;

	if(fn.contains(".bmp", false)) filenamemode=1;
	else if(fn.contains(".png", false)) filenamemode=2;
	else if(fn.contains(".jpg", false)) filenamemode=3;
	else if(fn.contains(".tif", false)) filenamemode=4;
	else filenamemode = -1;

	//load in our first frame
	QImage pm;
	if(filenamemode==1) pm.load(fn, "BMP");
	else if(filenamemode==2) pm.load(fn, "PNG");
	else if(filenamemode==3) pm.load(fn, "JPG");
	else if(filenamemode==4)
	{
		//pm.load(fn, "TIFF");
		load_TIFF(dirname, mode);
		return;
	}
	
	//printf("fn: %s\n", fn.latin1());
	//printf("filenamemode: %d\n", (int)filenamemode);
	
	
	if(pm.width()==0 && pm.height()==0)
	{
		//error opening file
//		printf("ERROR: Loading volume slices...  [VOLIO.cpp\load_PNG()]\n");
//		system("pause");
//		exit(1);
		QMessageBox* mb = new QMessageBox( "WARNING",
				"Could not open a file in [VOLIO.cppload_PNG()] \n",QMessageBox::Warning,
				QMessageBox::Ok | QMessageBox::Default,0,0 );

		mb->exec();
		//exit(1);
		return;
	}

	if(mode==4 || mode==5) for(int i=0; i<3*256; i++) volobj->histogram[i]=0.0;

	//set up our texture info
	res_x = volobj->width = volobj->texwidth = pm.width();
	res_y = volobj->height =volobj->texheight = pm.height();
	res_z = volobj->depth =volobj->texdepth = strList.count();

	volobj->x_resize = 1.0;
	volobj->y_resize = 1.0;
	volobj->z_resize = 1.0;

	volobj->maxres = volobj->width;
	volobj->maxres = max(volobj->height, volobj->maxres);
	volobj->maxres = max(volobj->depth, volobj->maxres);

	offset_x = offset_y = offset_z = 0;

	volobj->is_greyscale = true;
	volobj->has_red = true;
	volobj->has_green = false;
	volobj->has_blue = false;
}
QStringList VolIO::load_subimage_strngList(void)
{
	QString dirname = volobj->file_name;
	load_xyzspacing(dirname+"voxelspacing.txt");
	load_xyzscale(dirname+"voxelscale.txt");
	load_xyzscale_fromlogfile(dirname);

	//printf("Loading dir: %s\n", dirname.latin1());

	QDir d;
	d.setSorting(QDir::Name);
	d.setFilter( QDir::Files | QDir::Hidden | QDir::NoSymLinks );
	d.setNameFilter("*.png *.bmp *.jpg *.tif");
	d.cd(dirname);
			
	//string list of our files in the directory
	QStringList strList;
	strList = d.entryList();

	QString tempfn;
	for(int i=0; i<d.count(); i++)
	{
		tempfn = d[i].ascii();

		if(tempfn.contains("_spr", false))
		{
			break;
		}

		tempfn = "";
	}

	if(tempfn!="") strList.remove(tempfn);
	//workout our 1st filename
	QString fn = dirname;
	fn += strList[0].ascii();

	int filenamemode=0;

	if(fn.contains(".bmp", false)) filenamemode=1;
	else if(fn.contains(".png", false)) filenamemode=2;
	else if(fn.contains(".jpg", false)) filenamemode=3;
	else if(fn.contains(".tif", false)) filenamemode=4;
	else filenamemode = -1;

	//load in our first frame
	QImage pm;
	if(filenamemode==1) pm.load(fn, "BMP");
	else if(filenamemode==2) pm.load(fn, "PNG");
	else if(filenamemode==3) pm.load(fn, "JPG");
	else if(filenamemode==4)
	{
		return strList;
	}
	
	//printf("fn: %s\n", fn.latin1());
	//printf("filenamemode: %d\n", (int)filenamemode);
	
	if(pm.width()==0 && pm.height()==0)
	{
		//error opening file
//		printf("ERROR: Loading volume slices...  [VOLIO.cpp\load_PNG()]\n");
//		system("pause");
//		exit(1);
		QMessageBox* mb = new QMessageBox( "WARNING",
				"Could not open a file in [VOLIO.cppload_PNG()] \n",QMessageBox::Warning,
				QMessageBox::Ok | QMessageBox::Default,0,0 );

		mb->exec();
		//exit(1);
		return strList;
	}

	//set up our texture info
	volobj->width = volobj->texwidth = pm.width();
	volobj->height =volobj->texheight = pm.height();
	volobj->depth =volobj->texdepth = strList.count(); 

	return strList;
}
void VolIO::pad_subimage(int pad_size, int xstart, int ystart, int zstart, int brickresX, int brickresY, int brickresZ, unsigned char* data)
{
	int x,y,z, index_3D;

	int xend = xstart+brickresX;
	int yend = ystart+brickresY; 
	int zend = zstart+brickresZ;

	//ZX PLANE
	for (z =zstart; z<zend; z++)
	{	
		for(x=xstart; x<xend; x++)
		{
			for(y=ystart; y<ystart+pad_size; y++)
			{
				index_3D = (((((z-zstart)*brickresY)+(y-ystart))*brickresX)+(x-xstart));
			
				volobj->texture3d[3*index_3D+0] = 0;
				volobj->texture3d[3*index_3D+1] = 0;
				volobj->texture3d[3*index_3D+2] = 0;
			}
			for(y=yend-pad_size; y<yend; y++)
			{
				index_3D = (((((z-zstart)*brickresY)+(y-ystart))*brickresX)+(x-xstart));
			
				volobj->texture3d[3*index_3D+0] = 0;
				volobj->texture3d[3*index_3D+1] = 0;
				volobj->texture3d[3*index_3D+2] = 0;
			}
		}
	}
	//XY PLANE
	for (x =xstart; x<xend; x++)
	{	
		for(y=ystart; y<yend; y++)
		{
			for(z=zstart; z<zstart+pad_size; z++)
			{
				index_3D = (((((z-zstart)*brickresY)+(y-ystart))*brickresX)+(x-xstart));
			
				volobj->texture3d[3*index_3D+0] = 0;
				volobj->texture3d[3*index_3D+1] = 0;
				volobj->texture3d[3*index_3D+2] = 0;
			}
			for(z=zend-pad_size; z<zend; z++)
			{
				index_3D = (((((z-zstart)*brickresY)+(y-ystart))*brickresX)+(x-xstart));
			
				volobj->texture3d[3*index_3D+0] = 0;
				volobj->texture3d[3*index_3D+1] = 0;
				volobj->texture3d[3*index_3D+2] = 0;
			}
		}
	}
	//ZY PLANE
	for (z =zstart; z<zend; z++)
	{	
		for(y=ystart; y<yend; y++)
		{
			for(x=xstart; x<xstart+pad_size; x++)
			{
				index_3D = (((((z-zstart)*brickresY)+(y-ystart))*brickresX)+(x-xstart));
			
				volobj->texture3d[3*index_3D+0] = 0;
				volobj->texture3d[3*index_3D+1] = 0;
				volobj->texture3d[3*index_3D+2] = 0;
			}
			for(x=xstart-pad_size; x<xend; x++)
			{
				index_3D = (((((z-zstart)*brickresY)+(y-ystart))*brickresX)+(x-xstart));
			
				volobj->texture3d[3*index_3D+0] = 0;
				volobj->texture3d[3*index_3D+1] = 0;
				volobj->texture3d[3*index_3D+2] = 0;
			}
		}
	}

}
bool VolIO::load_subimage(QStringList strList, int xstart, int ystart, int zstart, int brickresX, int brickresY, int brickresZ, unsigned char* data)
{
	int xend = xstart+brickresX;
	int yend = ystart+brickresY; 
	int zend = zstart+brickresZ;
	QString dirname = volobj->file_name;

	QRgb pixel;
	QString fn;
	int index_small;
	QImage pm;

	//if(volobj->texture3d_brick!=0) delete volobj->texture3d_brick;
	//volobj->texture3d_brick = new unsigned char[brickresX*brickresY*brickresZ];
	
	/*progressbar = new Q3ProgressDialog("Loading PNG/BMP/JPG/TIFF sub-Image...", "Cancel", zend-zstart, 0, "progress", TRUE);		
	progressbar->setCaption("Please Wait");
	progressbar->raise();*/

	bool isempty=true;

	int r,g,b,a;
	for(float z=zstart; z<zend; z++)
	{
		//update our progress bar
        /*progressbar->setProgress(z-zstart);
        if (progressbar->wasCancelled())
            break;*/

		//if(z>strList.count()-1) z = strList.count()-1;

		//workout our filename
		fn = dirname;
		fn += strList[z].ascii(); //(strList.count()-1)-

		//printf("fn: %s\n", fn.latin1());

		//read_texture reads as RGBA		
		//if(filenamemode==1) pm.load(fn, "BMP");
		//if(filenamemode==2) 
		pm.load(fn, "PNG");
		//if(filenamemode==3) pm.load(fn, "JPG");
		//if(filenamemode==4)pm.load(fn, "TIFF");
		
//		printf("w: %d, h: %d \n", pm.width(), pm.height());
		for(float x=xstart; x<xend; x++)
		{
			for(float y=ystart; y<yend; y++)
			{
				//printf("%d, %d\n", int(x+0.5), int(y+0.5));
				/*if(x>pm.width()-1)  x = pm.width()-1;
				if(y>pm.height()-1) y = pm.height()-1;
				if(x<0) x=0;
				if(y<0) y=0;*/

				//make sure we round up to nearest int for x,y
				pixel = pm.pixel(int(x),int(y));
				
				index_small = (((((z-zstart)*brickresY)+(y-ystart))*brickresX)+(x-xstart));

				r = qGray(pixel);
				/*g = qGreen(pixel);
				b = qBlue(pixel);
				a = qGray(pixel);*/

				if(r!=0) isempty = false;
				/*if(g!=0) green = true;
				if(b!=0) blue = true;*/

				/*if(x==ystart) r = 0;
				if(y==xstart) r = 0;
				if(z==zstart) r = 0;

				if(x==xend-1) r = 0;
				if(y==yend-1) r = 0;
				if(z==zend-1) r = 0;*/

				//printf("voxel: %d\n", (int) r);
				data[index_small] = GLubyte(r);
				//volobj->texture3d_brick[index_small] = GLubyte(r);	
			}
		}

		//pm.reset();
	}

	//pad_subimage(1, xstart, ystart, zstart, brickresX, brickresY, brickresZ, data);
	//delete progressbar;
	//progressbar=NULL;

	return isempty;
}

void VolIO::load_sliceThread(const QtThreadedSliceLoader &threadloader)
{
//		printf("fn: %s\n", fn.latin1());
	QImage pm;

	//read_texture reads as RGBA		
	pm.load(threadloader.fn, threadloader.ext);
	
	int index_3D, index_small;
	int r,g,b,a;

	int x3 = threadloader.x2;
	int y3 = threadloader.y2;
	int z3 = threadloader.z2; 

//		printf("w: %d, h: %d \n", pm.width(), pm.height());
	for(float x=0; x<threadloader.volobj->width-1; x+=threadloader.volobj->x_resize)
	{
		for(float y=0; y<threadloader.volobj->height-1; y+=threadloader.volobj->y_resize)
		{
			//printf("%d, %d\n", int(x+0.5), int(y+0.5));

			//make sure we round up to nearest int for x,y
			QRgb pixel = pm.pixel(int(x+0.5),int(y+0.5));
			
			if(x3>=threadloader.volobj->resized_texwidth) x3=threadloader.volobj->resized_texwidth-1;
			if(y3>=threadloader.volobj->resized_texheight) y3=threadloader.volobj->resized_texheight-1;
			if(z3>=threadloader.volobj->resized_texdepth) z3=threadloader.volobj->resized_texdepth-1;

			index_small = (((((z3)*threadloader.volobj->resized_texheight)+(y3))*threadloader.volobj->resized_texwidth)+(x3));

			r = qRed(pixel);
			g = qGreen(pixel);
			b = qBlue(pixel);
			a = qGray(pixel);

			//if(r!=0 || g!=0 || b!=0)
			{
				if(threadloader.mode==4)
				{
					threadloader.volobj->texture3d[3*index_small+0] = GLubyte(r);
					threadloader.volobj->texture3d[3*index_small+1] = GLubyte(g); 
					threadloader.volobj->texture3d[3*index_small+2] = GLubyte(b); 
					threadloader.volobj->histogram[(3*int(r))+0]++;
					threadloader.volobj->histogram[(3*int(g))+1]++;
					threadloader.volobj->histogram[(3*int(b))+2]++;
				}
				else if(threadloader.mode==1)
				{
					threadloader.volobj->texture3d[3*index_small+0] = GLubyte(r);
					threadloader.volobj->histogram[(3*int(r))+0]++;
				}
				else if(threadloader.mode==2)
				{
					threadloader.volobj->texture3d[3*index_small+1] = GLubyte(g); 
					threadloader.volobj->histogram[(3*int(g))+1]++;
				}
				else if(threadloader.mode==3)
				{
					threadloader.volobj->texture3d[3*index_small+2] = GLubyte(b); 
					threadloader.volobj->histogram[(3*int(b))+2]++;
				}				
			}

			y3++;
		}
		x3++;
		y3=0;
	}

	//return threadloader;
}
QtThreadedSliceLoader runme(QtThreadedSliceLoader threadloader)
{
	threadloader.run();
	return threadloader;
}
/*!
	Load up a volume from PNG slices
*/
void VolIO::load_PNG(QString fn, int mode)//QImage frame
{
/*	if(volobj->is16bit)
	{
		for(int i=0; i<volobj->voldatasize; i++)
			delete[] volobj->voldata[i];
		
		if(volobj->voldata) delete volobj->voldata;
		volobj->voldata = NULL;		
	}

	red=green=blue=false;
	volobj->is16bit=false;
	
	load_xyzspacing(dirname+"voxelspacing.txt");
	load_xyzscale(dirname+"voxelscale.txt");
	load_xyzscale_fromlogfile(dirname);
	
	//set our opt data directory
	QDir d;
	d.setSorting(QDir::Name);
	d.setFilter( QDir::Files | QDir::Hidden | QDir::NoSymLinks );
	d.setNameFilter("*.png *.bmp *.jpg *.tif ^*_spr*.*");
	d.cd(dirname);

	//string list of our files in the directory
	QStringList strList;
	strList = d.entryList();

	volobj->file_name = dirname;

	//workout our 1st filename
	QString fn = dirname;
	fn += strList[strList.size()/2.0].ascii();

	QString ext="";
	if(fn.contains(".bmp", false)) ext="BMP";
	else if(fn.contains(".png", false)) ext="PNG";
	else if(fn.contains(".jpg", false)) ext="JPG";
	else if(fn.contains(".tif", false)) ext="TIFF";

	//load in our first frame
	QImage pm;
	pm.load(fn, ext);

	if(ext=="TIFF")
	{
		//pm.load(fn, "TIFF");
		load_TIFF(dirname, mode);
		return;
	}
	
	//printf("fn: %s\n", fn.latin1());
	//printf("filenamemode: %d\n", (int)filenamemode);
	//printf("is greyscale: %d\n", pm.allGray());

	greyscale = false;
	if(pm.allGray()) greyscale = true;

	//set up our texture info
	volobj->width = volobj->texwidth = pm.width();
	volobj->height =volobj->texheight = pm.height();
	volobj->depth =volobj->texdepth = strList.count(); 

	pm.reset();

	//==============================================================
	eval_resize_dimensions();
	int size = res_x*res_y*res_z*3;

	//lets have some memory
	//lets be clean
	if(mode==4 || mode==1) 
	{
		if(volobj->texture3d) delete[] volobj->texture3d;
		volobj->texture3d = NULL;

		//lets have some memory for our texture data
		volobj->texture3d = (GLubyte *) malloc(size * sizeof(GLubyte));

		//check if we managed to allocate some memory
 		if(volobj->texture3d == NULL)
		{
			QMessageBox* mb = new QMessageBox( "ERROR",
					"Failed to allocate memory in [VOLIO.cpp load_PNG()] \n",QMessageBox::Warning,
					QMessageBox::Ok | QMessageBox::Default,0,0 );

			mb->exec();
			//exit(1);
			return;
		}

		//initialise everything to zero
		for(int i=0; i<size; i++) volobj->texture3d[i] = 0;
		for(int i=0; i<3*256; i++) volobj->histogram[i]=0.0;
	}

	QProgressDialog* pg = new QProgressDialog("Loading PNG/BMP/JPG/TIFF Stack...", "Cancel", 0, volobj->depth, 0, 0);		
	pg->setCaption("Ple	QString dn = fn;

	//remove the filename of first file to get only dirname
	int pos = dn.findRev(QString("/").latin1(), -1, false);
	dn.replace(pos+1, dn.length()-pos+1, "");
ase Wait");
	//progressbar->setProgress(0);
	pg->setMinimumDuration(500);
	pg->setLabelText(QString("Loading PNG/BMP/JPG/TIFF Stack...\n Using %1 thread(s).").arg(QThread::idealThreadCount()));
	pg->raise();

	//int index_3D, index_small;
	float x2, y2, z2;
	//int r,g,b,a;
	x2 = offset_x;
	y2 = offset_y;
	z2 = offset_z;

	QTime time;
	time.start();

	QList<QtThreadedSliceLoader> load_PNGslicelist;
	for(float z=0; z<volobj->depth; z+=volobj->z_resize)
	{
		//workout our filename
		fn = dirname;
		fn += strList[(strList.count()-1)-z].ascii();
		
		//LOAD SLICES
		//load_sliceThread(QtThreadedSliceLoader(volobj, fn, ext, x2, y2, z2, mode));
		slicelist.append(QtThreadedSliceLoader(volobj, fn, ext, x2, y2, z2, mode));

		z2++;
		x2=0;
		y2=0;
	}

	watcher->setFuture(QtConcurrent::map(slicelist, runme));
	QObject::connect(watcher, SIGNAL(progressValueChanged(int)), pg, SLOT(setValue(int)));
	QObject::connect(watcher, SIGNAL(progressRangeChanged(int, int)), pg, SLOT(setRange(int, int)));
	QObject::connect(watcher, SIGNAL(finished()), pg, SLOT(reset()));
	QObject::connect(pg, SIGNAL(canceled()), watcher, SLOT(cancel()));
	pg->exec();
*/
	//pg->show();

	//watcher->waitForFinished();
	
	/*
	QThreadPool threadpool = QThreadPool();
	threadpool.setMaxThreadCount(8);
	for(float z=0; z<volobj->depth; z+=volobj->z_resize)
	{
		//update our progress bar
        //if((int)(z)%(int)(((volobj->depth)/50.0)+1)==0)
	/*	{
			progressbar->setProgress(z);
			if (progressbar->wasCancelled())
				break;
		}
*/
	/*	//workout our filename
		fn = dirname;
		fn += strList[z].ascii();
		
		//LOAD SLICES
		load_sliceThread(QtThreadedSliceLoader(volobj, fn, ext, x2, y2, z2, mode));
		//threadpool.start(new QtThreadedSliceLoader(volobj, fn, ext, x2, y2, z2, mode)); //QThread::TimeCriticalPriority

		z2++;
		x2=0;
	}*/
	/*
	delete pg;
	pg=NULL;
	
//	threadpool.waitForDone();

	printf("LOADING: HD to RAM: %d msec.\n", time.elapsed());

	//set up our texture info
	volobj->width = volobj->texwidth = volobj->resized_texwidth;
	volobj->height =volobj->texheight = volobj->resized_texheight;
	volobj->depth =volobj->texdepth = volobj->resized_texdepth;

	pad(1);

	volobj->maxdimension = volobj->texwidth;
	volobj->maxdimension = max(volobj->maxdimension, volobj->texheight);
	volobj->maxdimension = max(volobj->maxdimension, volobj->texdepth);


	if(mode==4)
	{
		if(greyscale==1)
		{
			volobj->is_greyscale = 1;
			volobj->has_red = 1;
			volobj->has_green = 0;
			volobj->has_blue = 0;
		}
		else
		{	
			volobj->is_greyscale = 0;
			volobj->has_red = 1;
			volobj->has_green = 1;
			volobj->has_blue = 1;
		}
	}
	else if(mode==1)
	{
		volobj->is_greyscale = 0;
		volobj->has_red = 1;
		volobj->has_green = 0;
		volobj->has_blue = 0;
	}
	else if(mode==2)
	{
		volobj->is_greyscale = 0;
		volobj->has_green = 1;
	}
	else if(mode==3)
	{
		volobj->is_greyscale = 0;
		volobj->has_blue = 1;
	}
	cout<<"LOADING: (greyscale) "<<greyscale<<" | ";
	cout<<"(r,g,b) "<<volobj->has_red<<" "<<volobj->has_green<<" "<<volobj->has_blue<<endl;
*//*
	if(greyscale && mode==4)
	{
		volobj->is_greyscale = 1;
		volobj->has_red = 1;
		volobj->has_green = 0;
		volobj->has_blue = 0;
	}
	else
	{
		volobj->is_greyscale = 0;
		volobj->has_red = red;
		volobj->has_green = green;
		volobj->has_blue = blue;
	}
*/

	/*if(volobj->is16bit)
	{
		for(int i=0; i<volobj->voldatasize; i++)
			delete[] volobj->voldata[i];
		
		if(volobj->voldata) delete volobj->voldata;
		volobj->voldata = NULL;		
	}*/

	QString dirname = fn;
	//remove the filename of first file to get only dirname
	int pos = dirname.findRev(QString("/").latin1(), -1, false);
	dirname.replace(pos+1, dirname.length()-pos+1, "");

	red=green=blue=false;
	volobj->is16bit=false;
	
	load_xyzspacing(dirname+"voxelspacing.txt");
	load_xyzscale(dirname+"voxelscale.txt");
	load_xyzscale_fromlogfile(dirname);
	
	//set our opt data directory
	QDir d;
	d.setSorting(QDir::Name);
	d.setFilter( QDir::Files | QDir::Hidden | QDir::NoSymLinks );
	d.setNameFilter("*.png *.bmp *.jpg *.tif");
	d.cd(dirname);

	//string list of our files in the directory
	QStringList strList;
	strList = d.entryList();

	QString tempfn;
	for(int i=0; i<d.count(); i++)
	{
		tempfn = d[i].ascii();

		if(tempfn.contains("_spr", false))
		{
			break;
		}

		tempfn = "";
	}

	if(tempfn!="") strList.remove(tempfn);

	volobj->file_name = dirname;

	if(d.count()==0)
	{
		QMessageBox* mb = new QMessageBox( "WARNING",
				"No files found in directory in [VOLIO.cpp load_PNG()] \n",QMessageBox::Warning,
				QMessageBox::Ok | QMessageBox::Default,0,0 );

		mb->exec();
		//exit(1);
		return;
	}

	//workout our 1st filename
	//QString fn = dirname;
	//fn += strList[0].ascii();

	int filenamemode=0;

	printf("fn: %s\n", fn.latin1());

	if(fn.contains(".bmp", false)) filenamemode=1;
	else if(fn.contains(".png", false)) filenamemode=2;
	else if(fn.contains(".jpg", false)) filenamemode=3;
	else if(fn.contains(".tif", false)) filenamemode=4;
	else filenamemode = -1;

	//load in our first frame
	QImage img;
	if(filenamemode==1) img.load(fn, "BMP");
	else if(filenamemode==2) img.load(fn, "PNG");
	else if(filenamemode==3) img.load(fn, "JPG");
	else if(filenamemode==4)
	{
		//img.load(fn, "TIFF");
		load_TIFF(dirname, mode);
		return;
	}
	
	printf("fn: %s\n", fn.latin1());
	printf("filenamemode: %d\n", (int)filenamemode);
	
	int imgw = img.width();
	int imgh = img.height();

	printf("drop img: %d x %d\n", imgw, imgh);
 
	if(img.width()==0 && img.height()==0)
	{
		//error opening file
//		printf("ERROR: Loading volume slices...  [VOLIO.cpp\load_PNG()]\n");
//		system("pause");
//		exit(1);
		QMessageBox* mb = new QMessageBox( "WARNING",
				"Could not open a file in [VOLIO.cppload_PNG()] \n",QMessageBox::Warning,
				QMessageBox::Ok | QMessageBox::Default,0,0 );

		mb->exec();
		//exit(1);
		return;
	}

	//set up our texture info
	volobj->width = volobj->texwidth = img.width();
	volobj->height =volobj->texheight = img.height();
	volobj->depth =volobj->texdepth = strList.count(); 

	img.reset();

	//==============================================================
	eval_resize_dimensions();
	int size = res_x*res_y*res_z*3;

	//lets have some memory
	//lets be clean
	if(volobj->texture3d==0 || mode==4 || mode==1) 
	{
		if(volobj->texture3d) delete[] volobj->texture3d;
		volobj->texture3d = NULL;

		//lets have some memory for our texture data
		volobj->texture3d = (GLubyte *) malloc(size * sizeof(GLubyte));

		//check if we managed to allocate some memory
 		if(volobj->texture3d == NULL)
		{
			QMessageBox* mb = new QMessageBox( "ERROR",
					"Failed to allocate memory in [VOLIO.cpp load_PNG()] \n",QMessageBox::Warning,
					QMessageBox::Ok | QMessageBox::Default,0,0 );

			mb->exec();
			//exit(1);
			return;
		}

		//initialise everything to zero
		for(int ii=0; ii<size; ii++) volobj->texture3d[ii] = 0;
	}

	progressbar = new Q3ProgressDialog("Loading PNG/BMP/JPG/TIFF Stack...", "Cancel", volobj->depth, 0, "progress", TRUE);		
	progressbar->setCaption("Please Wait");
	progressbar->raise();

	int index_3D, index_small = 3*(offset_z*res_y*res_x + offset_y*res_x + offset_x);
	int line_shift = 2*offset_x;
	int image_shift = 2*offset_y*res_x + offset_x;

	//float x2, y2, z2;
	int r,g,b,a;
	/*x2 = offset_x;
	y2 = offset_y;
	z2 = offset_z;*/

	int helper=0;
	int greyscale=0;

	if(mode==4 || mode==5) for(int i=0; i<3*256; i++) volobj->histogram[i]=0.0;
	
	//printf("resize iter: %f, %f, %f\n", volobj->x_resize, volobj->y_resize, volobj->z_resize);

	QString ext;	
	if(filenamemode==1) ext = "BMP";
	else if(filenamemode==2) ext = "PNG";
	else if(filenamemode==3) ext = "JPG";
	else if(filenamemode==4) ext = "TIFF";
	//else return;

	for(float z=0; z<volobj->depth; z+=volobj->z_resize, index_small += image_shift)
	{
		//update our progress bar
		progressbar->setProgress(z);
		if (progressbar->wasCancelled())
		    break;

		//workout our filename
		fn = dirname;
		fn += strList[(strList.count()-1)-z].ascii();

		//read_texture reads as RGBA		
		img.load(fn, ext);
		
		/*if(img.format()!=QImage::Format_RGB32 || img.format()!=QImage::Format_ARGB32)
		{
			img = img.convertToFormat(QImage::Format_RGB32);
		}*/

	 	if(img.width()==imgw && img.height()==imgh)
		{
			//printf("fn: %s\n", fn.latin1());
			//printf("w: %d, h: %d \n", img.width(), img.height());
			for(float y=0; y<volobj->height-0.5; y+=volobj->y_resize, index_small += line_shift)
			{
				for(float x=0; x<volobj->width-0.5; x+=volobj->x_resize, index_small+=3) // -0.5 to stay within image bounds
				{
					//printf("%d, %d\n", int(x+0.5), int(y+0.5));

					//make sure we round up to nearest int for x,y
					QRgb pixel = img.pixel(int((x+0.5)), int((y+0.5))); //roundf
			
					r = qRed(pixel);
					g = qGreen(pixel);
					b = qBlue(pixel);
					a = qGray(pixel);

					if(r==g && r==b && b==g) greyscale++;

					helper++;

					if(r!=0) red = true;
					if(g!=0) green = true;
					if(b!=0) blue = true;

					if(mode==1)
					{
						volobj->texture3d[index_small+0] = GLubyte(r);
						volobj->histogram[(3*int(r))+0]++;
					}
					if(mode==2)
					{
						volobj->texture3d[index_small+1] = GLubyte(g); 
						volobj->histogram[(3*int(g))+1]++;
					}
					if(mode==3)
					{
						volobj->texture3d[index_small+2] = GLubyte(b); 
						volobj->histogram[(3*int(b))+2]++;
					}				
					if(mode==4)
					{
						volobj->texture3d[index_small+0] = GLubyte(r);
						volobj->texture3d[index_small+1] = GLubyte(g); 
						volobj->texture3d[index_small+2] = GLubyte(b); 
						volobj->histogram[(3*int(r))+0]++;
						volobj->histogram[(3*int(g))+1]++;
						volobj->histogram[(3*int(b))+2]++;
					}
					if(mode==5)
					{
						volobj->texture3d[index_small+0] =
						volobj->texture3d[index_small+1] =
						volobj->texture3d[index_small+2] = GLubyte(a);
						volobj->histogram[(3*int(a))+0]++;
						volobj->histogram[(3*int(a))+1]++;
						volobj->histogram[(3*int(a))+2]++;
					}
				}
			}
		}
	}
	delete progressbar;
	progressbar=NULL;

	//set up our texture info
	volobj->width = volobj->texwidth = res_x;
	volobj->height =volobj->texheight = res_y;
	volobj->depth =volobj->texdepth = res_z;

	pad(1);

	if(greyscale==helper) greyscale=1;
	else greyscale=0;

	cout<<"(r,g,b) "<< red<<" "<<green<<" "<<blue<<endl;
	cout<<"greyscale "<<greyscale<<endl;

	if(greyscale && mode==4)
	{
		volobj->is_greyscale = 1;
		volobj->has_red = 1;
		volobj->has_green = 0;
		volobj->has_blue = 0;
	}
	else if(mode==1)
	{
		volobj->is_greyscale = 0;
		volobj->has_red = red;
		volobj->has_green = 0;
		volobj->has_blue = 0;
	}
	else if(mode==2)
	{
		volobj->is_greyscale = 0;
		volobj->has_green = green;
	}
	else if(mode==3)
	{
		volobj->is_greyscale = 0;
		volobj->has_blue = blue;
	}
	else
	{
		volobj->is_greyscale = 0;
		volobj->has_red = red;
		volobj->has_green = green;
		volobj->has_blue = blue;
	}

	printf("(r,b,g): %d, %d, %d\n", (int)volobj->has_red, (int)volobj->has_green, (int)volobj->has_blue);
	printf("greyscale: %d\n", (int) volobj->is_greyscale);

/*	if(greyscale && mode==4)
	{
		volobj->is_greyscale = 1;
		volobj->has_red = 1;
		volobj->has_green = 0;
		volobj->has_blue = 0;
	}
	else
	{
		volobj->is_greyscale = 0;
		volobj->has_red = red;
		volobj->has_green = green;
		volobj->has_blue = blue;
	}
*/
}
void VolIO::pad(int pad_size)
{
	int x, y, z, index_3D;

	//ZX PLANE
	for (z =0; z<volobj->texdepth; z++)
	{	
		for(x=0; x<volobj->texwidth; x++)
		{
			for(y=0; y<pad_size; y++)
			{
				index_3D = ((((((volobj->texdepth-1)-z)*volobj->texheight)+y)*volobj->texwidth)+x);
			
				volobj->texture3d[3*index_3D+0] = 0;
				volobj->texture3d[3*index_3D+1] = 0;
				volobj->texture3d[3*index_3D+2] = 0;
			}
			for(y=volobj->texheight-pad_size; y<volobj->texheight; y++)
			{
				index_3D = ((((((volobj->texdepth-1)-z)*volobj->texheight)+y)*volobj->texwidth)+x);
			
				volobj->texture3d[3*index_3D+0] = 0;
				volobj->texture3d[3*index_3D+1] = 0;
				volobj->texture3d[3*index_3D+2] = 0;
			}
		}
	}
	//XY PLANE
	for (x =0; x<volobj->texwidth; x++)
	{	
		for(y=0; y<volobj->texheight; y++)
		{
			for(z=0; z<pad_size; z++)
			{
				index_3D = ((((((volobj->texdepth-1)-z)*volobj->texheight)+y)*volobj->texwidth)+x);
			
				volobj->texture3d[3*index_3D+0] = 0;
				volobj->texture3d[3*index_3D+1] = 0;
				volobj->texture3d[3*index_3D+2] = 0;
			}
			for(z=volobj->texdepth-pad_size; z<volobj->texdepth; z++)
			{
				index_3D = ((((((volobj->texdepth-1)-z)*volobj->texheight)+y)*volobj->texwidth)+x);
			
				volobj->texture3d[3*index_3D+0] = 0;
				volobj->texture3d[3*index_3D+1] = 0;
				volobj->texture3d[3*index_3D+2] = 0;
			}
		}
	}
	//ZY PLANE
	for (z =0; z<volobj->texdepth; z++)
	{	
		for(y=0; y<volobj->texheight; y++)
		{
			for(x=0; x<pad_size; x++)
			{
				index_3D = ((((((volobj->texdepth-1)-z)*volobj->texheight)+y)*volobj->texwidth)+x);
			
				volobj->texture3d[3*index_3D+0] = 0;
				volobj->texture3d[3*index_3D+1] = 0;
				volobj->texture3d[3*index_3D+2] = 0;
			}
			for(x=volobj->texwidth-pad_size; x<volobj->texwidth; x++)
			{
				index_3D = ((((((volobj->texdepth-1)-z)*volobj->texheight)+y)*volobj->texwidth)+x);
			
				volobj->texture3d[3*index_3D+0] = 0;
				volobj->texture3d[3*index_3D+1] = 0;
				volobj->texture3d[3*index_3D+2] = 0;
			}
		}
	}
}
int VolIO::makepower2(int val)
{
   int newval=val;

	if(val<=8) 
		newval = 8;
	else if(val<=16) 
		newval = 16;
	else if(val<=32) 
		newval = 32;
	else if(val<=64) 
		newval = 64;
	/*else if(val<=96) 
		newval = 96;*/
	else if(val<=128)
		newval = 128;
	else if(val<=256) 
		newval = 256;
	else if(val<=384) 
		newval = 384;
	else if(val<=512)
		newval = 512;
	/*else if(val<=768)
		newval = 768;*/
	else if(val<=1024)
		newval = 1024;

	return newval;

/*    int power = 0;
    if(!val)
		return 0;
	
    while(val >>= 1)
		power++;
	
    return(1 << power);*/
}
void VolIO::resize(void)
{
	printf("RESIZING\n");

	//if data dimensions are already under maxsize, do nothing
	if(volobj->width<=volobj->maxsizeX && volobj->height<=volobj->maxsizeY && volobj->depth<=volobj->maxsizeZ ) return;

	//float x_resize, y_resize, z_resize;
	volobj->x_resize = volobj->width/(float) volobj->maxsizeX;
	volobj->y_resize = volobj->height/(float) volobj->maxsizeY;
	volobj->z_resize = volobj->depth/(float) volobj->maxsizeZ;

	if(volobj->x_resize<1.0) volobj->x_resize = 1;
	if(volobj->y_resize<1.0) volobj->y_resize = 1;
	if(volobj->z_resize<1.0) volobj->z_resize = 1;

	float maxresize = 0;
	maxresize = max((float)maxresize, (float)volobj->x_resize);
	maxresize = max((float)maxresize, (float)volobj->y_resize);
	maxresize = max((float)maxresize, (float)volobj->z_resize);
	volobj->x_resize = volobj->y_resize = volobj->z_resize = maxresize;

	res_x = ((float)volobj->width/volobj->x_resize)+0.5; 
	res_y = ((float)volobj->height/volobj->y_resize)+0.5;
	res_z = ((float)volobj->depth/volobj->z_resize)+0.5; 

	float maxres1 = 0.0;
	maxres1 = max((float)maxres1, (float)res_x);
	maxres1 = max((float)maxres1, (float)res_y);
	maxres1 = max((float)maxres1, (float)res_z);
	volobj->maxres = maxres1;

	offset_x = ((makepower2(maxres1)-res_x)/2.0);
	offset_y = ((makepower2(maxres1)-res_y)/2.0); 
	offset_z = ((makepower2(maxres1)-res_z)/2.0); 

	res_x = makepower2(maxres1);
	res_y = makepower2(maxres1);
	res_z = makepower2(maxres1);

	printf("Original Dimensions: %d, %d, %d\n", volobj->width, volobj->height, volobj->depth);
	printf("Resized Dimensions: %d, %d, %d\n", res_x, res_y, res_z);
	printf("Resize Factor: %f, %f, %f\n", volobj->x_resize, volobj->y_resize, volobj->z_resize);
	printf("Offsets: %d, %d, %d\n", offset_x, offset_y, offset_z);

	int size = res_x*res_y*res_z*3;

	//lets have some memory
	unsigned char* temp_storage = NULL;
	temp_storage = (GLubyte *)malloc(size*sizeof(GLubyte));
	
	//initialise everything to zero
	for(int ii=0; ii<size; ii++) temp_storage[ii] = 0;

	progressbar = new Q3ProgressDialog("Resizing Volume...", "Cancel", volobj->depth, 0, "progress", TRUE);		
	progressbar->setCaption("Please Wait");

	int index_big, index_small;
	float x2, y2, z2;
	x2 = offset_x;
	y2 = offset_y;
	z2 = offset_z;
	for(float z=0; z<volobj->depth; z+=volobj->z_resize)
	{
        progressbar->setProgress(z);
        if (progressbar->wasCancelled())
            break;

		for(float y=0; y<volobj->height; y+=volobj->y_resize)
		{
			for(float x=0; x<volobj->width; x+=volobj->x_resize)
			{
				if(x2>=res_x) x2=res_x-1;
				if(y2>=res_y) y2=res_y-1;
				if(z2>=res_z) z2=res_z-1;

				index_big =   ((( ((int)(z+0.5)*volobj->height) + (int)(y+0.5)) * volobj->width) + (int)(x+0.5));
				index_small = ((( (z2*res_y) + y2) * res_x) + x2);

				temp_storage[3*index_small+0] = volobj->texture3d[3*index_big+0];
				temp_storage[3*index_small+1] = volobj->texture3d[3*index_big+1];
				temp_storage[3*index_small+2] = volobj->texture3d[3*index_big+2];
				
				y2++;
			}
			x2++;
			y2=0;
		}
		z2++;
		x2=0;
	}

	delete progressbar;
	progressbar=NULL;

	delete[] volobj->texture3d;

	//lets have some memory
	volobj->texture3d = (GLubyte *)malloc(size*sizeof(GLubyte));

	for(int i=0; i<size; i++) volobj->texture3d[i] = temp_storage[i];

	delete[] temp_storage;

	//set up our texture info
	volobj->width = volobj->texwidth = res_x;
	volobj->height =volobj->texheight = res_y;
	volobj->depth =volobj->texdepth = res_z; 
}

void VolIO::set_metadata(float x, float y, QString descp)
{
	istringstream  input(descp.toStdString());
	Tokenizer token(input);
	string label;
	float z_val = -1;

	//until oef is reached step through each token
	while(!input.eof())
	{
		//get the first string lable
		label = token.sval();

		if(token.ttype()==TT_WORD)
		{
			if(label=="spacing")
			{
				token.nextToken();
				token.nextToken();
				if(token.ttype()==TT_NUMBER)
				{
					z_val = token.nval();
					printf("val: %f\n", z_val);
				}
			}
			else
			{
				//cout<<"WARNING: Unrecognized Label..."<<endl;
				token.nextToken();
			}
		}
		else token.nextToken();
	}

	if(z_val==-1) z_val = 1.0;
	if(x==0.0) x=1.0;
	if(y==0.0) y=1.0;

	//while(input.
	volobj->xscale = 1.0/x;
	volobj->yscale = 1.0/y;
	volobj->zscale = z_val;
	
	volobj->xsize = 1.0/x;
	volobj->ysize = 1.0/y;
	volobj->zsize = z_val;
}
