#include "VolumeObject.h"

VolumeObject::VolumeObject()
{
	maxres=0;
	maxsizeX=0;
	maxsizeY=0;
	maxsizeZ=0;
	file_type = -1;
	file_name = "";
	texture3d = 0;

	x_resize = y_resize = z_resize = 0.0;
	
	is16bit = false;
	//voldata=NULL;
	voldatasize=1;

	width = height = depth = 
	texwidth = texheight = texdepth = 1;

	for(int i=0; i<256*3; i++)
		histogram[i] = 0;

	is_greyscale = has_red = has_green = has_blue = 0;

	maxres = 1.0;
	xsize = ysize = zsize = 1.0;
	maxsize = 1.0;
}
VolumeObject::~VolumeObject()
{
	if(texture3d) delete[] texture3d;
}
void VolumeObject::compute_boundingbox(void)
{
	//printf("BOUNDINGBOX:\n");
	int maxX, minX, maxY, minY, maxZ, minZ;
	
	maxX = maxY = maxZ = -8192;
	minX = minY = minZ = 8192;
	int  r,g,b, index;
	for(int z = 0; z <texdepth; z++)
	{
		for(int x = 0; x <texwidth; x++)
		{
			for(int y = 0; y <texheight; y++)
			{
				index = ((((z*texheight)+y)*texwidth)+x);

				r=g=b=0;
				if(has_red) r = texture3d[3*index+0];
				if(has_green) g = texture3d[3*index+1];
				if(has_blue) b = texture3d[3*index+2];
				
				//printf("has: %d, %d, %d\n",(int)has_red,(int)has_green,(int)has_blue);
				//printf("vox: %d, %d, %d\n", r,g,b);

				if(r+g+b>0)
				{
					if(x<minX) minX = x;
					if(y<minY) minY = y;
					if(z<minZ) minZ = z;

					if(x>maxX) maxX = x;
					if(y>maxY) maxY = y;
					if(z>maxZ) maxZ = z;
				}
			}
		}
	}

	maxX += 2;
	maxY += 2;
	maxZ += 2;

	minX -= 2;
	minY -= 2;
	minZ -= 2;

	boundingboxSize.x = (maxX-minX);
	boundingboxSize.y = (maxY-minY);
	boundingboxSize.z = (maxZ-minZ);
	boundingboxCentre.x = (((float)minX+(float)maxX)/2.0)-((float)texwidth/2.0);
	boundingboxCentre.y = (((float)minY+(float)maxY)/2.0)-((float)texheight/2.0);
	boundingboxCentre.z = (((float)minZ+(float)maxZ)/2.0)-((float)texdepth/2.0);
	boundingboxMin = Vector(minX, minY, minZ);
	boundingboxMax = Vector(maxX, maxY, maxZ);

	/*printf("\tmin: %f %f %f\n", boundingboxMin.x, boundingboxMin.y, boundingboxMin.z);	
	printf("\tmax: %f %f %f\n", boundingboxMax.x, boundingboxMax.y, boundingboxMax.z);
	printf("\tbb: %f %f %f\n", boundingboxSize.x, boundingboxSize.y, boundingboxSize.z);
	printf("\tbb centre: %f %f %f\n", boundingboxCentre.x, boundingboxCentre.y, boundingboxCentre.z);*/
}
int VolumeObject::get_index1D(int x, int y, int z)
{
	int index1d = ((((z*texheight)+y)*texwidth)+x);
	return index1d;
}
void VolumeObject::resize(float factor)
{
	printf("RESIZING\n");

	float x_resize, y_resize, z_resize;
	x_resize = (float) factor; //volobj->width/(float) volobj->maxsizeX;
	y_resize = (float) factor; //volobj->height/(float) volobj->maxsizeY;
	z_resize = (float) factor; //volobj->depth/(float) volobj->maxsizeZ;

	float maxresize = 0;
	if(x_resize>maxresize) maxresize = x_resize;
	if(y_resize>maxresize) maxresize = y_resize;
	if(z_resize>maxresize) maxresize = z_resize;
	x_resize = y_resize = z_resize = maxresize;

	int res_x = ((float)width/x_resize)+0.5; 
	int res_y = ((float)height/y_resize)+0.5;
	int res_z = ((float)depth/z_resize)+0.5; 

	float maxres1 = 0.0;
	if(res_x>maxres1) maxres1 = res_x;
	if(res_y>maxres1) maxres1 = res_y;
	if(res_z>maxres1) maxres1 = res_z;
	maxres = maxres1;

	int offset_x = ((makepower2(maxres1)-res_x)/2.0);
	int offset_y = ((makepower2(maxres1)-res_y)/2.0); 
	int offset_z = ((makepower2(maxres1)-res_z)/2.0); 

	res_x = makepower2(maxres1);
	res_y = makepower2(maxres1);
	res_z = makepower2(maxres1);

	printf("\tOriginal Dimensions: %d, %d, %d\n", width, height, depth);
	printf("\tResized Dimensions: %d, %d, %d\n", res_x, res_y, res_z);
	printf("\tResize Factor: %f, %f, %f\n", x_resize, y_resize, z_resize);
	printf("\tOffsets: %d, %d, %d\n", offset_x, offset_y, offset_z);

	int size = res_x*res_y*res_z*3;

	//lets have some memory
	unsigned char* temp_storage = NULL;
	temp_storage = (unsigned char *)malloc(size*sizeof(unsigned char));
	
	//initialise everything to zero
	for(int ii=0; ii<size; ii++) temp_storage[ii] = 0;

	progressbar = new Q3ProgressDialog("Resizing Volume...", "Cancel", depth, 0, "progress", TRUE);		
	progressbar->setCaption("Please Wait");

	int index_big, index_small;
	float x2, y2, z2;
	x2 = offset_x;
	y2 = offset_y;
	z2 = offset_z;
	for(float z=0; z<depth; z+=z_resize)
	{
        progressbar->setProgress(z);
        if (progressbar->wasCancelled())
            break;

		for(float y=0; y<height; y+=y_resize)
		{
			for(float x=0; x<width; x+=x_resize)
			{
				if(x2>=res_x) x2=res_x-1;
				if(y2>=res_y) y2=res_y-1;
				if(z2>=res_z) z2=res_z-1;

				index_big =   ((( ((int)(z+0.5)*height) + (int)(y+0.5)) * width) + (int)(x+0.5));
				index_small = ((( (z2*res_y) + y2) * res_x) + x2);

				temp_storage[3*index_small+0] = texture3d[3*index_big+0];
				temp_storage[3*index_small+1] = texture3d[3*index_big+1];
				temp_storage[3*index_small+2] = texture3d[3*index_big+2];
				
				y2++;
			}
			x2++;
			y2=0;
		}
		z2++;
		x2=0;
	}

    progressbar->setProgress(depth);
	delete progressbar;
	progressbar=NULL;

	delete[] texture3d;

	//lets have some memory
	texture3d = (unsigned char *)malloc(size*sizeof(unsigned char));

	for(int i=0; i<size; i++) texture3d[i] = temp_storage[i];

	delete[] temp_storage;

	//set up our texture info
	width =  texwidth = res_x;
	height = texheight = res_y;
	depth = texdepth = res_z; 
}
int VolumeObject::makepower2(int val)
{
   int newval=val;

	if(val<=8) 
		newval = 8;
	else if(val<=16) 
		newval = 16;
	else if(val<=32) 
		newval = 32;
	else if(val<=64) 
		newval = 64;
	else if(val<=96) 
		newval = 96;
	else if(val<=128)
		newval = 128;
	else if(val<=256) 
		newval = 256;
	else if(val<=384) 
		newval = 384;
	else if(val<=512)
		newval = 512;
	else if(val<=768)
		newval = 768;
	else if(val<=1024)
		newval = 1024;

	return newval;
}
const VolumeObject& VolumeObject::operator= (const VolumeObject& right)
{
	maxres=right.maxres;
	maxsizeX=right.maxsizeX;
	maxsizeY=right.maxsizeY;
	maxsizeZ=right.maxsizeZ;
	
	is_greyscale = right.is_greyscale;
	has_red = right.has_red;
	has_green = right.has_green;
	has_blue = right.has_blue;

	xsize = right.xsize;
	ysize = right.ysize;
	zsize = right.zsize;

	file_type = right.file_type;
	file_name = right.file_name;

	width = right.width;
	height = right.height;
	depth = right.depth;

	texwidth = right.texwidth;
	texheight = right.texheight;
	texdepth = right.texdepth;

	//nb 4 channels taken as default
	int size = texwidth*texheight*texdepth*3;

	//delete old, and allocate new memory
	if(texture3d) delete[] texture3d;
	texture3d = new unsigned char[size];

	for(int i=0; i<size; i++)
		texture3d[i] = right.texture3d[i];

	for(int ii=0; ii<256*3; ii++)
		histogram[ii] = right.histogram[ii];

	return *this;
}
