/***********************************************************************
* Project:      VolViewer
* Title:        VolumeObject.h
* Author:       Jerome Avondo
* 
* Purpose:      This represents a volume object, array of data
*
************************************************************************/

#ifndef VOLOBJ_H
#define VOLOBJ_H

#include <qstring.h>
#include <iostream>
#include <q3progressdialog.h>
//#include "libtiff/tiffio.h"
//#include "libtiff/tiff.h"
#include "Vector.h"

class VolumeObject
{

public:
	
	Q3ProgressDialog*		progressbar;

	int is_greyscale;
	int has_red, has_green, has_blue;

	float maxsize;
	float xsize, ysize, zsize;
	float xscale, yscale, zscale;

	float x_resize, y_resize, z_resize;

	int maxres;
	int maxsizeX;
	int maxsizeY;
	int maxsizeZ;

	int resized_texwidth, resized_texheight, resized_texdepth;

	Vector boundingboxCentre;
	Vector boundingboxSize;
	Vector boundingboxMin;
	Vector boundingboxMax;
	//int boundingboxX, boundingboxY, boundingboxZ;
	
	//filename of our data and type
	QString file_name;
	int file_type;

	//original dimensions of volume & volume array
	float maxdimension;
	int width, height, depth;
//	unsigned char* volume3d;

	//dimensions of texture array & texture array
	int texwidth, texheight, texdepth;
	unsigned char* texture3d;

	unsigned char* texture3d_brick;

	bool	is16bit;
	int voldatasize;
	//uint16** voldata;

	double histogram16bit[65536];
		
	//histogram of our object
	double histogram[256*3];

	VolumeObject();
	~VolumeObject();

	int get_index1D(int x, int y, int z);
	void resize(float factor);
	int makepower2(int val);
	void compute_boundingbox(void);
	
	const VolumeObject& operator= (const VolumeObject& right);
};

#endif	//VOLOBJ
