#include "VolumeRender.h"

VolumeRender::VolumeRender()
{
	cursor3D_screenspace = Vector(-128,-128,-128); 
	cursor3D_texturespace = Vector(0,0,0);
	res = 1.0;
	editor = NULL;
	volshader_id=0;
	fbo_depth=0;
}
VolumeRender::~VolumeRender()
{
	editor = NULL;
	if(texNames1) glDeleteTextures(volobj->texdepth,texNames1);
	if(texNames2) glDeleteTextures(volobj->texheight,texNames2);
	if(texNames3) glDeleteTextures(volobj->texwidth,texNames3);
	if(texNames1!=NULL) delete[] texNames1;
	if(texNames2!=NULL) delete[] texNames2;
	if(texNames3!=NULL) delete[] texNames3;

	QThreadPool* threadpool = new QThreadPool(NULL);
	threadpool->globalInstance()->waitForDone();
}
//=================================================================================================================================
void VolumeRender::initializeGL()
{
	//initialise our variavles
	initvariables();	

	//now lets initialise opengl states
	//===================================
	//glHint(GL_PERSPECTIVE_CORRECTION_HINT,GL_NICEST);  // we prefer good perspective correction
	glShadeModel(GL_SMOOTH);                           // and we prefer goraud-shading
//	glEnable (GL_LINE_SMOOTH);							// Enable Antialiased lines
//	glEnable (GL_POINT_SMOOTH);							// Enable Antialiased lines

	glGenTextures( 1, &SLICEX ); 
	glGenTextures( 1, &SLICEY ); 
	glGenTextures( 1, &SLICEZ ); 

	glGenTextures( 1, &TEXTURE3D_RED ); 
	glGenTextures( 1, &TEXTURE3D_GREEN ); 
	glGenTextures( 1, &TEXTURE3D_BLUE ); 
	glGenTextures( 1, &TEXTURE2D_RGB ); 
	glGenTextures( 1, &TEXTURE2D_RAGABA ); 

	glGenTextures( 1, &TEXTURE2D_FBO_FB ); 
	glGenTextures( 1, &TEXTURE2D_FBO_DP ); 
	glGenTextures( 1, &TEXTURE2D_LODFBO_FB ); 
	glGenTextures( 1, &TEXTURE2D_LODFBO_DP ); 

	//check those nasty opengl extensions...
	//and setup extensions for shader stuff
	glextensions.load_GLextension();
	vol_shadersinglepassobj.glext = vol_rgbsectionshaderobj.glext = vol_sectionshaderobj.glext = vol2dmulti_shaderobj.glext = vol2d_shaderobj.glext = lodfbo_object.glext = meshlist.glextensions = fbo_object.glext = postrendering_shaderobj.glext = mesh_shaderobj.glext = vol_shaderobj.glext = &glextensions;

	if(glextensions.fbo_support)
	{
		init_FBO();
	}

	//Turn on z-bruffer test
	glEnable(GL_DEPTH_TEST);
	glDepthFunc(GL_LEQUAL);

	//turn on some blending
	glEnable(GL_BLEND);
	blend_mode(bldmode);

//	glEnable(GL_POLYGON_OFFSET_FILL);
//	glPolygonOffset(2.0, 0.00001f);

	// Set up lighting & shading,
	// ---------------------------------------
	// OpenGL Settings

	// Light model parameters:
	// -------------------------------------------
	// ---------------------------------------
	// OpenGL Settings
  
/*	GLfloat light0_pos[] = {0.0, 128.0, 0.0, 1.0};
	GLfloat light1_pos[] = {0.0, -128.0, 0.0, 1.0};*/
	GLfloat ambientLight[] = { 0.0, 0.0, 0.0, 1.0f };
	GLfloat diffuseLight[] = { 0.5, 0.5, 0.5, 1.0f };
	GLfloat specularLight[] = { 0.25, 0.25, 0.25, 1.0f };
	
/*	GLfloat light0_dir[] = {0.0, -1.0, 0.0, 0.0};
	GLfloat light1_dir[] = {0.0, 1.0, 0.0, 0.0};

	// Assign created components to GL_LIGHT0
	glEnable(GL_LIGHT0);
	glLightfv(GL_LIGHT0, GL_POSITION, light0_pos);
*/

/*
	glEnable(GL_LIGHT1);
	glLightfv(GL_LIGHT1, GL_POSITION, light1_pos);
	glLightfv(GL_LIGHT1, GL_AMBIENT, ambientLight);
	glLightfv(GL_LIGHT1, GL_DIFFUSE, diffuseLight);
	glLightfv(GL_LIGHT1, GL_SPECULAR, specularLight);

    glLightf(GL_LIGHT1, GL_SPOT_EXPONENT, 20.0);
    glLightf(GL_LIGHT1, GL_SPOT_CUTOFF, 20.0);
    glLightf(GL_LIGHT1, GL_CONSTANT_ATTENUATION, 0.0);
    glLightf(GL_LIGHT1, GL_LINEAR_ATTENUATION, 0.5);
    glLightf(GL_LIGHT1, GL_QUADRATIC_ATTENUATION, 0.0);
    glLightfv(GL_LIGHT1, GL_SPOT_DIRECTION, light1_dir);
//	aim_light();*/

	//float fullamb[4] = {0.25, 0.25, 0.25, 1.0};

	//light_pos0 = Vector(0,256,0,0);
	//light_dir0 = -light_pos0;

	light_pos0 = Vector(0, 256, 256,0);	
	light_dir0 = -light_pos0;
	light_dir0.normalize();

	glDisable(GL_LIGHT0);
	glDisable(GL_LIGHT1);
	glDisable(GL_LIGHT2);
	glDisable(GL_LIGHT3);
	glDisable(GL_LIGHT4);
	glDisable(GL_LIGHT5);
	glDisable(GL_LIGHT6);
	glDisable(GL_LIGHT7);

    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();

	glLightModelf(GL_LIGHT_MODEL_TWO_SIDE, 1.0);

	glEnable(GL_LIGHT0);
	glLightfv(GL_LIGHT0, GL_AMBIENT, ambientLight);
	glLightfv(GL_LIGHT0, GL_DIFFUSE, diffuseLight);
	glLightfv(GL_LIGHT0, GL_SPECULAR, specularLight);
	glLightfv(GL_LIGHT0, GL_POSITION, &light_pos0.x);
	glLightfv(GL_LIGHT0, GL_SPOT_DIRECTION, &light_dir0.x);
    
	Vector light_pos1 = Vector(0, 256, -256, 0);	
	Vector light_dir1 = -light_pos1;
	light_dir1.normalize();

	glEnable(GL_LIGHT1);
	glLightfv(GL_LIGHT1, GL_AMBIENT, ambientLight);
	glLightfv(GL_LIGHT1, GL_DIFFUSE, diffuseLight);
	glLightfv(GL_LIGHT1, GL_SPECULAR, specularLight);
	glLightfv(GL_LIGHT1, GL_POSITION, &light_pos1.x);
	glLightfv(GL_LIGHT1, GL_SPOT_DIRECTION, &light_dir1.x);

    glLightf(GL_LIGHT0, GL_SPOT_CUTOFF, 15.0);
	glLightf(GL_LIGHT0, GL_SPOT_EXPONENT, 2.0);
    glLightf(GL_LIGHT0, GL_CONSTANT_ATTENUATION, 1.0);
    glLightf(GL_LIGHT0, GL_LINEAR_ATTENUATION, 0.5);
    glLightf(GL_LIGHT0, GL_QUADRATIC_ATTENUATION, 0.5);
	
    glLightf(GL_LIGHT1, GL_SPOT_CUTOFF, 15.0);
	glLightf(GL_LIGHT1, GL_SPOT_EXPONENT, 2.0);
    glLightf(GL_LIGHT1, GL_CONSTANT_ATTENUATION, 1.0);
    glLightf(GL_LIGHT1, GL_LINEAR_ATTENUATION, 0.5);
    glLightf(GL_LIGHT1, GL_QUADRATIC_ATTENUATION, 0.5);

	glEnable(GL_COLOR_MATERIAL);
	glEnable(GL_NORMALIZE);
	glEnable(GL_LIGHTING);

    glDisable(GL_LIGHTING);

	//glEnable(GL_CULL_FACE);
	//glFrontFace(GL_CW);
	//glCullFace(GL_BACK);

	//set line and point sizes
	glLineWidth(2.0);
	glPointSize(10.0);

//	glPolygonOffset(1, 0.0001f);
//	glEnable(GL_POLYGON_OFFSET_FILL);

	if(glextensions.shader_support)
	{
		//Volume shader
		GLcharARB *VertexShaderSource, *FragmentShaderSource;

		//Mesh shader
		Vector white = Vector(1,1,1);
		mesh_shaderobj.read_shaderSRC("Shaders/perfragment", &VertexShaderSource, &FragmentShaderSource);
		mesh_shaderobj.install_shader(VertexShaderSource, FragmentShaderSource);
		mesh_shaderobj.enable();
		mesh_shaderobj.sendUniform3fv("surfcol",1, &white.x);
		mesh_shaderobj.disable();

/*		
		Vector camerarange = Vector(1,5,1);
		Vector screensize = Vector(512, 512,0);
		
		postrendering_shaderobj.read_shaderSRC("Shaders/ssao", &VertexShaderSource, &FragmentShaderSource);
		postrendering_shaderobj.install_shader(VertexShaderSource, FragmentShaderSource);
		
		postrendering_shaderobj.enable();
		postrendering_shaderobj.sendUniform1i("depth_texture", 0);
		postrendering_shaderobj.sendUniform1i("scene_texture", 1);
		postrendering_shaderobj.sendUniform2fv("camerarange",1, &camerarange.x);
		postrendering_shaderobj.sendUniform2fv("screensize",1, &screensize.x);
		postrendering_shaderobj.disable();
*/
		//Post-process framebuffer shader
		postrendering_shaderobj.read_shaderSRC("Shaders/unsharp", &VertexShaderSource, &FragmentShaderSource);
		postrendering_shaderobj.install_shader(VertexShaderSource, FragmentShaderSource);

		float kernel[9];
		kernel[0] = 1.0;		kernel[1] = 	2.0;	kernel[2] = 1.0; 
		kernel[3] = 2.0;		kernel[4] = 	4.0;	kernel[5] = 2.0; 
		kernel[6] = 1.0;		kernel[7] = 	2.0;	kernel[8] = 1.0; 
//		kernel[0] = -1.0;		kernel[1] = 	-2.0;	kernel[2] = -1.0; 
//		kernel[3] = 0.0;		kernel[4] = 	0.0;	kernel[5] = 0.0; 
//		kernel[6] = 1.0;		kernel[7] = 	2.0;	kernel[8] = 1.0; 
		postprocess2d_amount = 1.0;
		 
		Vector camerarange = Vector(1,5,1);

		postrendering_shaderobj.enable();
		//postrendering_shaderobj.sendUniform1i("depth_texture", 0);
		postrendering_shaderobj.sendUniform1i("scene_texture", 0);
		if(fbo_lod==1) postrendering_shaderobj.sendUniform1f("texwidth", render_size);
		else postrendering_shaderobj.sendUniform1f("texwidth", FBO_SIZE);
		postrendering_shaderobj.sendUniform1f("postprocess2d_amount", postprocess2d_amount);
		postrendering_shaderobj.sendUniform1f("kernel_norm", 16.0);
		postrendering_shaderobj.sendUniform1fv("kernel", 9, kernel);
		//postrendering_shaderobj.sendUniform2fv("camerarange",1, &camerarange.x);
		postrendering_shaderobj.disable();

		vol2d_shaderobj.read_shaderSRC("Shaders/vol2d", &VertexShaderSource, &FragmentShaderSource);
		vol2d_shaderobj.install_shader(VertexShaderSource, FragmentShaderSource);
		vol2d_shaderobj.enable();
		vol2d_shaderobj.sendUniform1i("Texmap0", 0);
		vol2d_shaderobj.sendUniform1i("RGBlookupTexture", 2);
		vol2d_shaderobj.sendUniform1i("RAGABAlookupTexture", 3);
		vol2d_shaderobj.disable();

		vol2dmulti_shaderobj.read_shaderSRC("Shaders/vol2dtrilin", &VertexShaderSource, &FragmentShaderSource);
		vol2dmulti_shaderobj.install_shader(VertexShaderSource, FragmentShaderSource);
		vol2dmulti_shaderobj.enable();
		vol2dmulti_shaderobj.sendUniform1i("Texmap0", 0);
		vol2dmulti_shaderobj.sendUniform1i("Texmap1", 1);
		vol2dmulti_shaderobj.sendUniform1i("RGBlookupTexture", 2);
		vol2dmulti_shaderobj.sendUniform1i("RAGABAlookupTexture", 3);
		vol2dmulti_shaderobj.disable();

		vol_sectionshaderobj.read_shaderSRC("Shaders/volume_sections", &VertexShaderSource, &FragmentShaderSource);
		vol_sectionshaderobj.install_shader(VertexShaderSource, FragmentShaderSource);
		vol_sectionshaderobj.enable();
		vol_sectionshaderobj.sendUniform1i("volumeTextureR", 0);
		vol_sectionshaderobj.sendUniform1i("volumeTextureG", 1);
		vol_sectionshaderobj.sendUniform1i("volumeTextureB", 2);
		vol_sectionshaderobj.sendUniform1i("RGBlookupTexture", 3);
		vol_sectionshaderobj.disable();

		vol_rgbsectionshaderobj.read_shaderSRC("Shaders/volume_allchannelsNOLIGHT", &VertexShaderSource, &FragmentShaderSource);
		vol_rgbsectionshaderobj.install_shader(VertexShaderSource, FragmentShaderSource);		
		vol_rgbsectionshaderobj.enable();
		vol_rgbsectionshaderobj.sendUniform1i("volumeTexture", 0);
		vol_rgbsectionshaderobj.sendUniform1i("RGBlookupTexture", 3);
		vol_rgbsectionshaderobj.sendUniform1i("RAGABAlookupTexture", 4);
		vol_rgbsectionshaderobj.disable();

		vol_shadersinglepassobj.read_shaderSRC("Shaders/volume_allchannelsSINGPASS_NOLIGHT", &VertexShaderSource, &FragmentShaderSource);
		vol_shadersinglepassobj.install_shader(VertexShaderSource, FragmentShaderSource);
		vol_shadersinglepassobj.enable();
		vol_shadersinglepassobj.sendUniform1i("volumeTextureR", 0);
		vol_shadersinglepassobj.sendUniform1i("volumeTextureG", 1);
		vol_shadersinglepassobj.sendUniform1i("volumeTextureB", 2);
		vol_shadersinglepassobj.sendUniform1i("RGBlookupTexture", 3);
		vol_shadersinglepassobj.disable();

		volshader_event(volshader_id);
	}


}
void VolumeRender::resizeGL( int w, int h )
{
    glViewport( 0, 0, (GLint)w, (GLint)h );
  	glMatrixMode( GL_PROJECTION );
    glLoadIdentity();     

	if(h==0) h=1;

	camera.width = w;
	camera.height = h;

	if(projection_toggle==0)
		gluPerspective(camera.fov, (float)1.0, camera.znear, camera.zfar);	
	else
		glOrtho(-volobj->maxres+zoom, volobj->maxres+zoom, -volobj->maxres+zoom, volobj->maxres+zoom, -1024, 1024);

    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();

 	//update bounds for arcball transform
	arcball.setBounds((GLfloat)w, (GLfloat)h);
	winWidth = w;
    winHeight = h;

	for(int i=0; i<6; i++)	cutting_planes.planes[i].arcball.setBounds((GLfloat)w, (GLfloat)h);
//	if(winWidth>winHeight) winMaxDim = winWidth;
//	else winMaxDim = winHeight;
}
void VolumeRender::displayGL(int render)
{
	/*ofstream fout;												
	if(benchmark)
	{
		printf("Benchmarking\n");
		fout.open("benchmark.txt", ios_base::app);
		timer.startQTime();
		//timer.set_time_start();
	}
	else */
	if(fps_toggle) timer.set_time_start();

	/*if(offscreen_toggle==0)
	{
  		glClearColor( background_colour.red()/255.0, background_colour.green()/255.0, background_colour.blue()/255.0, 1.0f );
		glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);	
	}*/

	if(stereo_toggle)
	{
		render_stereo(render);
	}
	else
	{
		glDrawBuffer(GL_BACK);

		if(!volobj->texture3d)
		{
			LOD_FBO_SIZE = 256;
			FBO_SIZE = 256;
			init_FBO();
			postprocess2d_shader();
		}

		render_scene(render);
	}

	//glFinish();

	/*if(benchmark)
	{
		timer.set_time_end();
		timer.set_time_difference();
		float sec = timer.time_diff;
		float sec = timer.endQTime();
		fout<<sec<<endl;
		fout.close();
	}
	else*/
	if(fps_toggle) timer.get_fps();

}
//=================================================================================================================================
void VolumeRender::initvariables()
{
	timer.init();

	depthdata = 0;

	benchmark=0;

    splane[0] = 1.f/255.f;
    splane[1] = 0.f;
    splane[2] = 0.f;
    splane[3] = .5f;

    rplane[0] = 0.f;
    rplane[1] = 1.f/255.f;
    rplane[2] = 0.f;
    rplane[3] = .5f;

	tplane[0] = 0.f;
    tplane[1] = 0.f;
    tplane[2] = 1.f/255.f;
    tplane[3] = .5f;

	max_slices = 1;
	fillSlices = 1;

	winWidth = 512;
	winHeight = 512;
	FBO_SIZE = 256;

	fbo_lod = 0;

	PostProcess_toggle = 1;

	//define a cube by 8 vertices
	bb_v1 = Vector(-1.0,  1.0,  1.0);
	bb_v2 = Vector( 1.0,  1.0,  1.0);	
	bb_v3 = Vector(-1.0, -1.0,  1.0);
	bb_v4 = Vector( 1.0, -1.0,  1.0);
	bb_v5 = Vector(-1.0,  1.0, -1.0);
	bb_v6 = Vector( 1.0,  1.0, -1.0);
	bb_v7 = Vector(-1.0, -1.0, -1.0);
	bb_v8 = Vector( 1.0, -1.0, -1.0);

	Vector bb_size = Vector (256.0,256.0,256.0);
	bb_size /= 2.0;

	bb_v1=bb_v1*bb_size;
	bb_v2=bb_v2*bb_size;
	bb_v3=bb_v3*bb_size;
	bb_v4=bb_v4*bb_size;
	bb_v5=bb_v5*bb_size;
	bb_v6=bb_v6*bb_size;
	bb_v7=bb_v7*bb_size;
	bb_v8=bb_v8*bb_size;

	tx = ty = 0.0;

	//0 for perspective, 1 for ortho
	projection_toggle = 1;

	zoom=0; 

	lights_toggle = 0;
	measure_toggle = 1;
	offscreen_toggle = 0;

	redclip_toggle = blueclip_toggle = greenclip_toggle = isoclip_toggle = 1;

    camera.set(Vector(0, 0, -400), Vector(0,0,0), Vector(0,1,0));
	camera.width = winWidth;
	camera.height = winHeight;

	cutting_planes.init(256.0);

	arcball = ArcBall(winWidth, winHeight);

	cursor3D = "(0,0,0)";

	bldmode = 1;

	fpsTime_.start();
	fpsCounter_		= 0;
	f_p_s_		= 0.0;
	fpsString_		= "?fps";

	loaded = 0;
	
	for(int i=0; i<256; i++)
	{
		rgb_tfunc[3*i+0] = i;
		rgb_tfunc[3*i+1] = i;
		rgb_tfunc[3*i+2] = i;
		ragaba_tfunc[3*i+0] = i;
		ragaba_tfunc[3*i+1] = i;
		ragaba_tfunc[3*i+2] = i;

		backup_rgb_tfunc[3*i+0] = i;
		backup_rgb_tfunc[3*i+1] = i;
		backup_rgb_tfunc[3*i+2] = i;
		backup_ragaba_tfunc[3*i+0] = i;
		backup_ragaba_tfunc[3*i+1] = i;
		backup_ragaba_tfunc[3*i+2] = i;
	}

	//thresholding
	l_tmin = la_tmin = r_tmin = g_tmin  = b_tmin = ra_tmin = ga_tmin = ba_tmin = 0;
	l_tmax = la_tmax = r_tmax = g_tmax  = b_tmax = ra_tmax = ga_tmax = ba_tmax =255;

	//contrast & brightness
	l_bright = l_cont = la_bright = la_cont = r_bright = r_cont = g_bright = g_cont = 
	b_bright = b_cont = ba_cont = ga_cont = ba_bright = ga_bright = ra_bright = ra_cont = 100;;
	
	//invert
	inv_l = inv_la = inv_r = inv_g = inv_b = inv_ra = inv_ga = inv_ba = false;

	volshader_id = 0;

	lighting_enable = 0;
	light_radius = 512.0;
	light_altitude = 0.0;
	light_azimuth  = 0.0;

	silhouette_enable = 1;
	silhouette_amount = 0.5;

	gooch_enable = 0;
	gooch_toneCont = 0.5;
	gooch_warmCol[0] = 0.6;
	gooch_warmCol[1] = 0.6;
	gooch_warmCol[2] = 0.0;
	gooch_coolCol[0] = 0.0;
	gooch_coolCol[1] = 0.0;
	gooch_coolCol[2] = 0.6;

	goochalpha = 1.0;
	goochdegen = 0.0;

	r_channel = 1.0;
	g_channel = 1.0;
	b_channel= 1.0;
	isosurface = 1.0;

	numbslices =512;
	slices = 512;
	sliceslod = 128;
	SlicesmoveLOD_toggle = 1;

	texNames1 = texNames2 = texNames3 = 0;
	for(int i=0; i<6; i++) plane_rendermode[i] = 3;

	updatehisto=0;

	goochwarm = Vector(1.0,1.0,0.0);
	goochcool = Vector(0.0,0.0,1.0);
	goochcontrib = 1.0;
	goochexp = 4.0;

	current_measure_index = -1;
	current_measure_vertindex = -1;
	
	measure_magnetline_vert = -1;
	measure_magnetline_vert_old = -1;
	measure_magnetline_edge = -1;

	measure_editmode = 0;
	measure_modify=0;
	measure_mode = 0;
	measure_dragmode = 0;

	measure_vertlabel = 0;
	measure_lengthlabel = 0;
	measure_anglelabel = 0;

	measure_magnetline_destvert = -1;
	measure_magnetline_helper = -1;

	crop_inv=false;
	crop_shape_selected=-1;
}
void VolumeRender::init_FBO(void)
{
		glBindTexture (GL_TEXTURE_2D, TEXTURE2D_FBO_FB); 
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
		glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
		glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
		glTexImage2D (GL_TEXTURE_2D, 0, GL_RGBA, FBO_SIZE, FBO_SIZE, 0, GL_RGBA, GL_UNSIGNED_BYTE, 0);
		glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);

		glBindTexture (GL_TEXTURE_2D, TEXTURE2D_FBO_DP); 
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
		glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
		glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
		glTexImage2D (GL_TEXTURE_2D, 0, GL_DEPTH_COMPONENT, FBO_SIZE, FBO_SIZE, 0, GL_DEPTH_COMPONENT, GL_UNSIGNED_BYTE, 0);
		glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);

		fbo_object.initialize(FBO_SIZE, FBO_SIZE, GL_RGBA, TEXTURE2D_FBO_FB, TEXTURE2D_FBO_DP);
		fbo_object.stop();

		glBindTexture (GL_TEXTURE_2D, TEXTURE2D_LODFBO_FB); 
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
		glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
		glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
		glTexImage2D (GL_TEXTURE_2D, 0, GL_RGBA, LOD_FBO_SIZE, LOD_FBO_SIZE, 0, GL_RGBA, GL_UNSIGNED_BYTE, 0);
		glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);

		glBindTexture (GL_TEXTURE_2D, TEXTURE2D_LODFBO_DP); 
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
		glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
		glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
		glTexImage2D (GL_TEXTURE_2D, 0, GL_DEPTH_COMPONENT, LOD_FBO_SIZE, LOD_FBO_SIZE, 0, GL_DEPTH_COMPONENT, GL_UNSIGNED_BYTE, 0);
		glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);

		lodfbo_object.initialize(LOD_FBO_SIZE, LOD_FBO_SIZE, GL_RGBA, TEXTURE2D_LODFBO_FB, TEXTURE2D_LODFBO_DP);
		lodfbo_object.stop();

		if(depthdata) delete[] depthdata;
		depthdata = new unsigned int[FBO_SIZE*FBO_SIZE];
}

void VolumeRender::init_3dTexture_bricks(int subdivs)
{
	printf("init_3dTexture_bricks()\n");

	int brick_subdivs=BRICKS_SUBDIV;
	int number_of_bricks = (int)pow((float)BRICKS_SUBDIV,3);
	PlaneWidgetInCube plane;

	//work out x,y,z chunks we can divide data into
	float brick_xres = volobj->texwidth/(float)brick_subdivs;
	float brick_yres = volobj->texheight/(float)brick_subdivs;
	float brick_zres = volobj->texdepth/(float)brick_subdivs;

	if(glextensions.pbo_support)
	{
		printf("Initialising Pixel Buffer Object...\n");

		int datasize = brick_xres*brick_yres*brick_zres;

		glBindTexture(GL_TEXTURE_3D, TEXTURE3D_RED);
		glTexParameteri(GL_TEXTURE_3D,GL_TEXTURE_WRAP_S, GL_CLAMP_TO_EDGE);
		glTexParameteri(GL_TEXTURE_3D,GL_TEXTURE_WRAP_T, GL_CLAMP_TO_EDGE);
		glTexParameteri(GL_TEXTURE_3D,GL_TEXTURE_WRAP_R, GL_CLAMP_TO_EDGE);
		glTexParameteri(GL_TEXTURE_3D,GL_TEXTURE_MIN_FILTER, GL_LINEAR);	// Linear Filtering
		glTexParameteri(GL_TEXTURE_3D,GL_TEXTURE_MAG_FILTER, GL_LINEAR);	// Linear Filtering
		glextensions.glTexImage3D(GL_TEXTURE_3D, 0,  GL_LUMINANCE,
			brick_xres, brick_yres, brick_zres,
			0,
			GL_LUMINANCE, GL_UNSIGNED_BYTE, 0);

		glextensions.glGenBuffersARB(1, &TEXTURE3D_PBO);
        glextensions.glBindBufferARB(GL_PIXEL_UNPACK_BUFFER_ARB, TEXTURE3D_PBO);
        glextensions.glBufferDataARB(GL_PIXEL_UNPACK_BUFFER_ARB, datasize, 0, GL_STREAM_DRAW_ARB);
        glextensions.glBindBufferARB(GL_PIXEL_UNPACK_BUFFER_ARB, 0);
	}

	printf("Number of bricks: %d\n", number_of_bricks);
	printf("Brick Resolutions: %d x %d x %d\n", (int)brick_xres, (int)brick_yres, (int)brick_zres);

	//allocate some memory for our brick data
	brick_textures.resize(number_of_bricks);
	brick_centres.resize(number_of_bricks);
	empty_brick.resize(number_of_bricks);

	float vert_res = (volobj->maxres/BRICKS_SUBDIV);

	for(int n=0; n<number_of_bricks; n++)
	{
		empty_brick[n] = 0;	
	}

	//now build up the brick textures
	float x_iter, y_iter, z_iter;
	int helper=0;
	int index_3D=0;
	int brick_index_3D=0;
	float r,g,b,a;
	int isempty=0;
	int empty_bricks;
	empty_bricks=0;
	float maxsize;

	printf("Building Bricks \n");

	QStringList strlst = volio->load_subimage_strngList();
	QThreadPool* threadpool = new QThreadPool(NULL);
	threadpool->setMaxThreadCount(2);
	for(int i=0; i<brick_subdivs; i++)
	{
		x_iter = brick_xres*i;

		for(int j=0; j<brick_subdivs; j++)
		{
			y_iter = brick_yres*j;
	
			for(int k=0; k<brick_subdivs; k++)
			{
				z_iter = brick_zres*k;

				brick_textures[helper].resize((brick_xres)*(brick_yres)*(brick_zres)*1);
		
				isempty = 1;

				//empty_brick[helper] = 
				//volio->load_subimage(strlst, x_iter, y_iter, z_iter, brick_xres, brick_yres, brick_zres, &brick_textures[helper][0]);

				QtThreadedBrickLoader* threadloader = new QtThreadedBrickLoader(helper, volio, strlst, x_iter, y_iter, z_iter, brick_xres, brick_yres, brick_zres, &brick_textures[helper], &empty_brick);
				threadpool->globalInstance()->start(threadloader); //QThread::TimeCriticalPriority
				//empty_brick[helper] = false;

				brick_centres[helper] = Vector((x_iter+x_iter+brick_xres)/2.0, (y_iter+y_iter+brick_yres)/2.0, (z_iter+z_iter+brick_zres)/2.0, helper);
				
				brick_centres[helper].x /= (float)volobj->texwidth;
				brick_centres[helper].y /= (float)volobj->texheight;
				brick_centres[helper].z /= (float)volobj->texdepth;

				brick_centres[helper].x -= 0.5;
				brick_centres[helper].y -= 0.5;
				brick_centres[helper].z -= 0.5;

				brick_centres[helper].x *= (float)volobj->texwidth;
				brick_centres[helper].y *= (float)volobj->texheight;
				brick_centres[helper].z *= (float)volobj->texdepth;

				maxsize =  max((float)volobj->xsize, (float)volobj->ysize);
				maxsize =  max((float)maxsize, (float)volobj->zsize);

				brick_centres[helper].x *= (volobj->xsize/maxsize);
				brick_centres[helper].y *= (volobj->ysize/maxsize);
				brick_centres[helper].z *= (volobj->zsize/maxsize);
				
				helper++;
			}
		}
	}

	printf("Bricks: %d / %d\n", number_of_bricks-empty_bricks, number_of_bricks);
	//sort(brick_centres.begin(), brick_centres.end());
	loaded=1;
}
//=================================================================================================================================
void VolumeRender::silhouettes_shader(void)
{
	if(glextensions.shader_support==1 && volshader_id!=0)
	{
	/*	vol_shaderobj.enable();
		vol_shaderobj.sendUniform1i("silhouette_amount", silhouette_amount);
		vol_shaderobj.disable();*/
	}
}
void VolumeRender::postprocess2d_shader(void)
{
	if(glextensions.shader_support==1)
	{
		postrendering_shaderobj.enable();
		postrendering_shaderobj.sendUniform1f("postprocess2d_amount", postprocess2d_amount);
		if(fbo_lod==1) postrendering_shaderobj.sendUniform1f("texwidth", LOD_FBO_SIZE);
		else postrendering_shaderobj.sendUniform1f("texwidth", FBO_SIZE);
		postrendering_shaderobj.disable();
	}
}
void VolumeRender::silhouette_shader(void)
{
	if(glextensions.shader_support==1 && volshader_id!=0)
	{
	/*	vol_shaderobj.enable();
		vol_shaderobj.sendUniform1f("silhouette_amount", silhouette_amount);
		vol_shaderobj.disable();*/
	}
}
void VolumeRender::volshader_event(int id)
{
	volshader_id = id;

//	printf("ID: %d\n", id);

	GLcharARB *VertexShaderSource, *FragmentShaderSource;


	//"Multi Channel NOLIGHT", 
	//"Multi Channel LAMBERTIAN", 
	//"Multi Channel BLING-PHONG", 
	//"Multi Channel GOOCH", 


	//"Single Channel NOLIGHT", 
	//"Single Channel FULL", 
	//"Multi Channel NOLIGHT", 
	//"Multi Channel LAMBERTIAN", 
	//"Multi Channel BLING-PHONG", 
	//"Multi Channel COOK-TORRANCE", 
	//"Multi Channel GOOCH", 
	//"Multi Channel BLING-PHONG 2SP", 


	if(id==0)
	{
		vol_shaderobj.read_shaderSRC("Shaders/volume_allchannelsNOLIGHT", &VertexShaderSource, &FragmentShaderSource);
		vol_shaderobj.install_shader(VertexShaderSource, FragmentShaderSource);
		
		vol_shaderobj.enable();
		vol_shaderobj.sendUniform1i("volumeTexture", 0);
		vol_shaderobj.sendUniform1i("RGBlookupTexture", 3);
		vol_shaderobj.sendUniform1i("RAGABAlookupTexture", 4);
		vol_shaderobj.disable();

		volshader_id =2;
	}
	else if(id==1)
	{
		vol_shaderobj.read_shaderSRC("Shaders/volume_allchannelsLAMBERTIAN", &VertexShaderSource, &FragmentShaderSource);
		vol_shaderobj.install_shader(VertexShaderSource, FragmentShaderSource);
		
		vol_shaderobj.enable();
		vol_shaderobj.sendUniform1i("volumeTexture", 0);
		vol_shaderobj.sendUniform1i("RGBlookupTexture", 3);
		vol_shaderobj.sendUniform1i("RAGABAlookupTexture", 4);
		vol_shaderobj.disable();
		volshader_id =3;
	}
	else if(id==2)
	{
		vol_shaderobj.read_shaderSRC("Shaders/volume_allchannelsBLING-PHONG", &VertexShaderSource, &FragmentShaderSource);
		vol_shaderobj.install_shader(VertexShaderSource, FragmentShaderSource);
		
		vol_shaderobj.enable();
		vol_shaderobj.sendUniform1i("volumeTexture", 0);
		vol_shaderobj.sendUniform1i("RGBlookupTexture", 3);
		vol_shaderobj.sendUniform1i("RAGABAlookupTexture", 4);
		vol_shaderobj.sendUniform1f("maxdimension", volobj->maxres*2.0); 
		vol_shaderobj.disable();
		volshader_id = 4;
	}
	else if(id==3)
	{		
		//
		vol_shaderobj.read_shaderSRC("Shaders/volume_allchannelsGOOCH", &VertexShaderSource, &FragmentShaderSource);
		vol_shaderobj.install_shader(VertexShaderSource, FragmentShaderSource);

		vol_shaderobj.enable();
		vol_shaderobj.sendUniform1i("volumeTexture", 0);
		vol_shaderobj.sendUniform1i("RGBlookupTexture", 3);
		vol_shaderobj.sendUniform1i("RAGABAlookupTexture", 4);
		vol_shaderobj.sendUniform1f("silhCont", goochcontrib);
		vol_shaderobj.sendUniform1f("silhExp", goochexp);
		vol_shaderobj.sendUniform3fv("gooch_warmCol",1, &goochwarm.x);
		vol_shaderobj.sendUniform3fv("gooch_coolCol",1, &goochcool.x);
		vol_shaderobj.sendUniform1f("alphathresh", goochalpha);
		vol_shaderobj.sendUniform1f("degenthresh", goochdegen);
		vol_shaderobj.sendUniform1f("maxdimension", volobj->maxres*2.0); 
		vol_shaderobj.disable();
		volshader_id = 6;
	}
	else if(id==4)
	{
		vol_shaderobj.read_shaderSRC("Shaders/volume_allchannelsSEM", &VertexShaderSource, &FragmentShaderSource);
		vol_shaderobj.install_shader(VertexShaderSource, FragmentShaderSource);

		vol_shaderobj.enable();
		vol_shaderobj.sendUniform1i("volumeTexture", 0);
		vol_shaderobj.sendUniform1i("RGBlookupTexture", 3);
		vol_shaderobj.sendUniform1i("RAGABAlookupTexture", 4);
		vol_shaderobj.sendUniform1f("silhCont", goochcontrib);
		vol_shaderobj.sendUniform1f("silhExp", goochexp);
		vol_shaderobj.sendUniform1f("maxdimension", volobj->maxres*2.0); 
		vol_shaderobj.disable();
		volshader_id = 7;
	}
	else if(id==5)
	{
		vol_shaderobj.read_shaderSRC("Shaders/volume_allchannelsTOON", &VertexShaderSource, &FragmentShaderSource);
		vol_shaderobj.install_shader(VertexShaderSource, FragmentShaderSource);

		vol_shaderobj.enable();
		vol_shaderobj.sendUniform1i("volumeTexture", 0);
		vol_shaderobj.sendUniform1i("RGBlookupTexture", 3);
		vol_shaderobj.sendUniform1i("RAGABAlookupTexture", 4);
		vol_shaderobj.disable();
		volshader_id = 8;
	}
	
	/*	//"Single Channel NOLIGHT", 
	//"Single Channel FULL", 
	//"Multi Channel NOLIGHT", 
	//"Multi Channel LAMBERTIAN", 
	//"Multi Channel BLING-PHONG", 
	//"Multi Channel COOK-TORRANCE", 
	//"Multi Channel GOOCH", 
	//"Multi Channel BLING-PHONG 2SP", 

	if(id==0)
	{
		vol_shaderobj.read_shaderSRC("Shaders/volume_singlechannelNOLIGHT", &VertexShaderSource, &FragmentShaderSource);
		vol_shaderobj.install_shader(VertexShaderSource, FragmentShaderSource);
		
		vol_shaderobj.enable();
		vol_shaderobj.enable();
		vol_shaderobj.sendUniform1i("volumeTexture", 0);
		vol_shaderobj.sendUniform1i("RGBlookupTexture", 3);
		vol_shaderobj.sendUniform1i("RAGABAlookupTexture", 4);
		vol_shaderobj.disable();
	}
	else if(id==1)
	{
		vol_shaderobj.read_shaderSRC("Shaders/volume_singlechannelFULL", &VertexShaderSource, &FragmentShaderSource);
		vol_shaderobj.install_shader(VertexShaderSource, FragmentShaderSource);
		
		vol_shaderobj.enable();
		vol_shaderobj.sendUniform1i("volumeTexture", 0);
		vol_shaderobj.sendUniform1i("RGBlookupTexture", 3);
		vol_shaderobj.sendUniform1i("RAGABAlookupTexture", 4);
		vol_shaderobj.disable();
	}
	else if(id==2)
	{
		vol_shaderobj.read_shaderSRC("Shaders/volume_allchannelsNOLIGHT", &VertexShaderSource, &FragmentShaderSource);
		vol_shaderobj.install_shader(VertexShaderSource, FragmentShaderSource);
		
		vol_shaderobj.enable();
		vol_shaderobj.sendUniform1i("volumeTexture", 0);
		vol_shaderobj.sendUniform1i("RGBlookupTexture", 3);
		vol_shaderobj.sendUniform1i("RAGABAlookupTexture", 4);
		vol_shaderobj.disable();

		load_clipplanes();	
	}
	else if(id==3)
	{
		vol_shaderobj.read_shaderSRC("Shaders/volume_allchannelsLAMBERTIAN", &VertexShaderSource, &FragmentShaderSource);
		vol_shaderobj.install_shader(VertexShaderSource, FragmentShaderSource);
		
		vol_shaderobj.enable();
		vol_shaderobj.sendUniform1i("volumeTexture", 0);
		vol_shaderobj.sendUniform1i("RGBlookupTexture", 3);
		vol_shaderobj.sendUniform1i("RAGABAlookupTexture", 4);
		vol_shaderobj.disable();
	}
	else if(id==4)
	{
		vol_shaderobj.read_shaderSRC("Shaders/volume_allchannelsBLING-PHONG", &VertexShaderSource, &FragmentShaderSource);
		vol_shaderobj.install_shader(VertexShaderSource, FragmentShaderSource);
		
		vol_shaderobj.enable();
		vol_shaderobj.sendUniform1i("volumeTexture", 0);
		vol_shaderobj.sendUniform1i("RGBlookupTexture", 3);
		vol_shaderobj.sendUniform1i("RAGABAlookupTexture", 4);
		vol_shaderobj.disable();
	}
	else if(id==5)
	{
		vol_shaderobj.read_shaderSRC("Shaders/volume_allchannelsCOOK-TORRANCE", &VertexShaderSource, &FragmentShaderSource);
		vol_shaderobj.install_shader(VertexShaderSource, FragmentShaderSource);
		
		vol_shaderobj.enable();
		vol_shaderobj.sendUniform1i("volumeTexture", 0);
		vol_shaderobj.sendUniform1i("RGBlookupTexture", 3);
		vol_shaderobj.sendUniform1i("RAGABAlookupTexture", 4);
		vol_shaderobj.disable();
	}
	else if(id==6)
	{
		vol_shaderobj.read_shaderSRC("Shaders/volume_allchannelsGOOCH", &VertexShaderSource, &FragmentShaderSource);
		vol_shaderobj.install_shader(VertexShaderSource, FragmentShaderSource);
		
		vol_shaderobj.enable();
		vol_shaderobj.sendUniform1i("volumeTexture", 0);
		vol_shaderobj.sendUniform1i("RGBlookupTexture", 3);
		vol_shaderobj.sendUniform1i("RAGABAlookupTexture", 4);
		vol_shaderobj.disable();
	}
	else if(id==7)
	{
		vol_shaderobj.read_shaderSRC("Shaders/volume_allchannelsBLING-PHONG2SP", &VertexShaderSource, &FragmentShaderSource);
		vol_shaderobj.install_shader(VertexShaderSource, FragmentShaderSource);
		
		vol_shaderobj.enable();
		vol_shaderobj.sendUniform1i("volumeTexture", 0);
		vol_shaderobj.sendUniform1i("RGBlookupTexture", 3);
		vol_shaderobj.sendUniform1i("RAGABAlookupTexture", 4);
		vol_shaderobj.disable();
	}

*/
/*
		vol_shaderobj.sendUniform1i("red_clip", redclip_toggle);
		vol_shaderobj.sendUniform1i("green_clip", greenclip_toggle);
		vol_shaderobj.sendUniform1i("blue_clip", blueclip_toggle);
		vol_shaderobj.sendUniform1i("silhouette_enable", silhouette_enable);
		vol_shaderobj.sendUniform1f("silhouette_amount", silhouette_amount);
		vol_shaderobj.sendUniform1i("gooch_enable", gooch_enable);
		vol_shaderobj.sendUniform1i("lighting_enable", lighting_enable);
		vol_shaderobj.sendUniform1f("gooch_toneCont", gooch_toneCont);
		vol_shaderobj.sendUniform1fv("gooch_warmCol", 3, gooch_warmCol);
		vol_shaderobj.sendUniform1fv("gooch_coolCol", 3, gooch_coolCol);
*/
}
void VolumeRender::shaderGoochEvent(Vector warm, Vector cool, int contrib, int expon, int alpha, int degen)
{
//	printf("%d\n",volshader_id);

	if(volshader_id==6)
	{
		goochwarm = warm;
		goochcool = cool;
		goochcontrib = contrib;
		goochexp = expon;
		goochalpha = (float)alpha/10.0;
		goochdegen = 0.01;(float)degen/10.0;
		
		vol_shaderobj.enable();
		vol_shaderobj.sendUniform1i("volumeTexture", 0);
		vol_shaderobj.sendUniform1i("RGBlookupTexture", 3);
		vol_shaderobj.sendUniform1i("RAGABAlookupTexture", 4);
		vol_shaderobj.sendUniform1f("silhCont", goochcontrib);
		vol_shaderobj.sendUniform1f("silhExp", goochexp);
		vol_shaderobj.sendUniform1f("alphathresh", goochalpha);
		vol_shaderobj.sendUniform1f("degenthresh", goochdegen);
		vol_shaderobj.sendUniform3fv("gooch_warmCol",1, &goochwarm.x);
		vol_shaderobj.sendUniform3fv("gooch_coolCol",1, &goochcool.x);
		vol_shaderobj.disable();
	}
	else if(volshader_id==7)
	{
		goochcontrib = contrib;
		goochexp = expon;

		vol_shaderobj.enable();
		vol_shaderobj.sendUniform1i("volumeTexture", 0);
		vol_shaderobj.sendUniform1i("RGBlookupTexture", 3);
		vol_shaderobj.sendUniform1i("RAGABAlookupTexture", 4);
		vol_shaderobj.sendUniform1f("silhCont", goochcontrib);
		vol_shaderobj.sendUniform1f("silhExp", goochexp);
		vol_shaderobj.disable();
	}

}
//=================================================================================================================================
void VolumeRender::aim_light(void)
{
	glPushMatrix();

//	glTranslatef(tx, ty, -zoom);
//	glMultMatrixf(arcball.Transform.M);		

//	glLightfv(GL_LIGHT1, GL_POSITION, &light_pos0.x);
//	glLightfv(GL_LIGHT1, GL_SPOT_DIRECTION, &light_dir0.x);

	light_pos0 = Vector(0,0,light_radius);
	light_pos0.rotate3D(Vector(1,0,0),(3.14159265358979323846/180.0)*light_altitude);
	light_pos0.rotate3D(Vector(0,1,0),(3.14159265358979323846/180.0)*light_azimuth);
	
//	light_pos0.x=cosf((3.14159265358979323846/180.0)*light_azimuth)*sinf((3.14159265358979323846/180.0)*light_altitude);
//	light_pos0.y=sinf((3.14159265358979323846/180.0)*light_azimuth)*sinf((3.14159265358979323846/180.0)*light_altitude);
//	light_pos0.z=cosf((3.14159265358979323846/180.0)*light_altitude);
//	light_pos0.w = 1.0;

/*	light_pos0.x+=cosf((3.14159265358979323846/180.0)*light_azimuth)*sinf((3.14159265358979323846/180.0)*light_altitude);
	light_pos0.y+=sinf((3.14159265358979323846/180.0)*light_azimuth)*sinf((3.14159265358979323846/180.0)*light_altitude);
	light_pos0.z+=cosf((3.14159265358979323846/180.0)*light_altitude);
	light_pos0.w = 1.0;
*/
	//printf("light_pos0: %f, %f, %f\n", light_pos0.x, light_pos0.y, light_pos0.z);
	//light_pos0+=0.01;
	//light_pos0.round(2);
	//printf("rounded light_pos: %f, %f, %f\n", light_pos0.x, light_pos0.y, light_pos0.z);

//	light_pos0 *= light_radius;

	light_dir0 = Vector(0,0,0)-light_pos0;
	light_dir0.normalize();

	//printf("light_dir0: %f, %f, %f\n", light_dir0.x, light_dir0.y, light_dir0.z);

	glLightfv(GL_LIGHT0, GL_POSITION, &light_pos0.x);
	glLightfv(GL_LIGHT0, GL_SPOT_DIRECTION, &light_dir0.x);

	/*light_pos1.x=  light_radius*cos((3.141592654/180.0)*(180.0-light_azimuth))*cos((3.141592654/180.0)*(180.0-light_altitude));
	light_pos1.y=  -light_radius*sin((3.141592654/180.0)*(180.0-light_azimuth))*cos((3.141592654/180.0)*(180.0-light_altitude));
	light_pos1.z=  (light_radius*sin((3.141592654/180.0)*(180.0-light_altitude)));
	light_pos1.w = 1.0;

	light_dir1 = -light_pos1;
	light_dir1.normalize();
	
	glLightfv(GL_LIGHT1, GL_POSITION, &light_pos1.x);
	glLightfv(GL_LIGHT1, GL_SPOT_DIRECTION, &light_dir1.x);*/
/*	
	light_pos1.x=  light_radius*cos((3.141592654/180.0)*(180.0-light_azimuth))*cos((3.141592654/180.0)*(180.0-light_altitude));
	light_pos1.y=  -light_radius*sin((3.141592654/180.0)*(180.0-light_azimuth))*cos((3.141592654/180.0)*(180.0-light_altitude));
	light_pos1.z=  (light_radius*sin((3.141592654/180.0)*(180.0-light_altitude)));

	light_dir1 = -light_pos1;
	light_dir1.normalize();

	glLightfv(GL_LIGHT1, GL_POSITION, &light_pos1.x);
	glLightfv(GL_LIGHT1, GL_SPOT_DIRECTION, &light_dir1.x);
*/
	glPopMatrix();
}
void VolumeRender::light_colours(Vector amb, Vector diff, Vector spec)
{
	glLightfv(GL_LIGHT0, GL_AMBIENT, &amb.x);
	glLightfv(GL_LIGHT0, GL_DIFFUSE, &diff.x);
	glLightfv(GL_LIGHT0, GL_SPECULAR, &spec.x);
}
void VolumeRender::update_FBOsize(int size)
{
	fbo_lod=size;
	if(fbo_lod==1) render_size = LOD_FBO_SIZE;
		else render_size = FBO_SIZE;

	if(depthdata) delete[] depthdata;
	depthdata = new unsigned int[FBO_SIZE*FBO_SIZE];

	postrendering_shaderobj.enable();
	postrendering_shaderobj.sendUniform1f("texwidth", render_size);
	postrendering_shaderobj.disable();

//	fbo_object.stop();
//	lodfbo_object.stop();
}
void VolumeRender::check_extensions(void)
{
/*
    #ifdef WIN32

	glTexImage3D = NULL;
	glBlendColorEXT = NULL;
	//glCompressedTexImage3DARB =NULL;
	//glCompressedTexImageARB =NULL;
	glBlendEquationEXT =NULL;
  
	// 3D TEXTURING EXTENSION
	// --------------------------------------------
	// OpenGL 1.3+ GL_TEXTURE_3D became standard.
	// OpenGL 1.2 used GL_TEXTURE_3D_EXT.
	// --------------------------------------------
	if(glTexImage3D==NULL)
	{
		glTexImage3D = (PFNGLTEXIMAGE3DPROC)wglGetProcAddress("glTexImage3D");
		if (NULL == glTexImage3D)
		{
//			QMessageBox::warning(this, "GL Extensions", "No glTexImage3D/glTexImage3DEXT!");
			system("pause");
			exit(1);
		} 
	}

	if(glBlendColorEXT==NULL)
	{
		// --------------------------------------------
		// BLEND COLOR EXTENSION
		// --------------------------------------------
		glBlendColorEXT = (PFNGLBLENDCOLORPROC)wglGetProcAddress("glBlendColor");
	
		if(glBlendColorEXT==NULL)
		{
			glBlendColorEXT = (PFNGLBLENDCOLOREXTPROC)wglGetProcAddress("glBlendColorEXT");
			if(glBlendColorEXT==NULL)
			{
//				QMessageBox::warning(this, "GL Extensions", "No glBlendColor/glBlendColorEXT!");
				system("pause");
				exit(1);
			}
		}  
	}

	glBlendEquationEXT = (PFNGLBLENDEQUATIONEXTPROC)wglGetProcAddress("glBlendEquationEXT");
	if ( glBlendEquationEXT == NULL)
	{
//		QMessageBox::warning(this, "GL Extensions", "No glBlendEquationEXT!");
		system("pause");
		exit(1);
	} 
	
	#else
  
	if(glBlendColorEXT==NULL)
	{
		// --------------------------------------------
		// BLEND COLOR EXTENSION
		// --------------------------------------------
		//glBlendColorEXT = (PFNGLBLENDCOLORPROC)glXGetProcAddress("glBlendColor");
		if (NULL == glBlendColorEXT)
		{
		  	glBlendColorEXT = (PFNGLBLENDCOLOREXTPROC)glXGetProcAddress("glBlendColorEXT");
			if (NULL == glBlendColorEXT)
			{
//				QMessageBox::warning(this, "GL Extensions", "No glBlendColor/glBlendColorEXT!");
				system("pause");
				exit(1);
			}
		}  
	}

	if (!strstr((char*)glGetString(GL_EXTENSIONS), "GL_EXT_texture_filter_anisotropic"))
	{
//				QMessageBox::warning(this, "GL Extensions", "GL_EXT_texture_filter_anisotropic");
				system("pause");
				exit(1);
	}       
    #endif*/
}
void VolumeRender::blend_mode(int blendmode)
{	
	bldmode = blendmode;

//	printf("blendmode: %d\n", blendmode);

//	glEnable(GL_BLEND);
	
	switch (blendmode) 
	{
		case 1:	//BLEND
    	//#ifdef WIN32

			//enable front to back...
			//glBlendFunc(GL_ONE_MINUS_DST_ALPHA, GL_DST_ALPHA);
	
			// enable back-to-front compositing GL_SRC_ALPHA
			glextensions.glBlendEquationEXT(GL_FUNC_ADD_EXT);
			glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

			//glextensions.glBlendEquationEXT(GL_FUNC_SUBTRACT_EXT);
			//glextensions.glBlendEquationEXT(GL_FUNC_ADD_EXT);
			//glBlendFunc(GL_SRC_ALPHA_SATURATE, GL_ONE);

			background_colour=old_background_colour;

			//old_background_colour=background_colour;
      	//#endif

			break;
		case 2: //MAXIMUMINTENSITY:
    	//#ifdef WIN32

			// enable maximum intensity projection
			glextensions.glBlendEquationEXT(GL_MAX_EXT);
			glBlendFunc(GL_SRC_COLOR,GL_DST_COLOR);  
			background_colour=Qt::black;
	//	#endif
			break;
		case 3: //MINIMUMINTENSITY:
    	//#ifdef WIN32
			// enable minimum intensity projection
			glextensions.glBlendEquationEXT(GL_MIN_EXT);
			glBlendFunc(GL_SRC_COLOR,GL_DST_COLOR); 
	//    #endif
		case 4: //MINIMUMINTENSITY:
    	//#ifdef WIN32
			//attenuate...
			printf("%d\n", (int)numbslices);
			float attenuation =  0.01;
			glextensions.glBlendEquationEXT(GL_FUNC_ADD_EXT);
			glBlendFunc(GL_CONSTANT_ALPHA_EXT, GL_ONE);
			glextensions.glBlendColorEXT(1.0f, 1.0f, 1.0f, attenuation);
			background_colour=Qt::black;
	//#endif
			break;
	}

	Vector rgb, hsv;
	rgb.x = background_colour.red()/255.0;
	rgb.y = background_colour.green()/255.0;
	rgb.z = background_colour.blue()/255.0;
	RGBtoHSV(rgb, &hsv);

	if(hsv.z>0.5)
	{
		background_fontcolour = QColor(0.0,0.0,0.0);
	}
	else
	{
		background_fontcolour = QColor(255.0,255.0,255.0);
	}
}


void VolumeRender::build_histogram(void)
{
	int r0,g0,b0;
	r0=g0=b0=0 ;
	int r,g,b,ra,ba,ga, hist_r, hist_g, hist_b;
	r=g=b=ra=ba=ga=hist_r=hist_g=hist_b=0;

	int* newhist =  new int[256*3];
	for (int iii=0; iii<256*3; iii++) 	newhist[iii]=0.0;

	if(updatehisto==1)
	{
		for(int ii=0; ii<256; ii++)
		{
			if(editor->tranfer_function_tab->hist->fe_seleted==1)
			{
				hist_r = rgb_tfunc[3*ii];	
				hist_g = rgb_tfunc[3*ii+1];
				hist_b = rgb_tfunc[3*ii+2];
			}
			if(editor->tranfer_function_tab->hist->fe_seleted==3)
			{
				hist_r = rgb_tfunc[3*ii];
			}
			else if(editor->tranfer_function_tab->hist->fe_seleted==4)
			{
				hist_g = rgb_tfunc[3*ii+1];
			}
			else if(editor->tranfer_function_tab->hist->fe_seleted==5)
			{
				hist_b = rgb_tfunc[3*ii+2];
			}
			else if(editor->tranfer_function_tab->hist->fe_seleted==2)
			{
				hist_r = ragaba_tfunc[3*ii];
				hist_g = ragaba_tfunc[3*ii+1];
				hist_b = ragaba_tfunc[3*ii+2];
			}
			else if(editor->tranfer_function_tab->hist->fe_seleted==6)
			{
				hist_r = ragaba_tfunc[3*ii];
			}
			else if(editor->tranfer_function_tab->hist->fe_seleted==7)
			{
				hist_g = ragaba_tfunc[3*ii+1];
			}
			else if(editor->tranfer_function_tab->hist->fe_seleted==8)
			{
				hist_b = ragaba_tfunc[3*ii+2];
			}

			newhist[3*hist_r] += volobj->histogram[3*ii];
			newhist[3*hist_g+1] += volobj->histogram[3*ii+1];
			newhist[3*hist_b+2] += volobj->histogram[3*ii+2];
		}
	}
	else
	{
		for(int ii=0; ii<256*3; ii++) newhist[ii] = volobj->histogram[ii];
	}

	for(int i=0; i<256; i++)
	{
		hist_r = 3*i;
		hist_g = 3*i+1;
		hist_b = 3*i+2;

		r = g =	b = ra = ga = ba = i;

		if(editor->tranfer_function_tab->hist->fe_seleted==1)
		{
			editor->tranfer_function_tab->hist->data[r] = newhist[hist_r]+newhist[hist_g]+newhist[hist_b];
		}
		else if(editor->tranfer_function_tab->hist->fe_seleted==2)
		{
			editor->tranfer_function_tab->hist->data[ra] = newhist[hist_r]+newhist[hist_g]+newhist[hist_b];
		}
		else if(editor->tranfer_function_tab->hist->fe_seleted==3)
		{
			editor->tranfer_function_tab->hist->data[r] = newhist[hist_r];
		}
		else if(editor->tranfer_function_tab->hist->fe_seleted==4)
		{
			editor->tranfer_function_tab->hist->data[g] = newhist[hist_g];
		}
		else if(editor->tranfer_function_tab->hist->fe_seleted==5)
		{
			editor->tranfer_function_tab->hist->data[b] = newhist[hist_b];
		}
		else if(editor->tranfer_function_tab->hist->fe_seleted==6)
		{
			editor->tranfer_function_tab->hist->data[ra] = newhist[hist_r];
		}
		else if(editor->tranfer_function_tab->hist->fe_seleted==7)
		{
			editor->tranfer_function_tab->hist->data[ga] = newhist[hist_g];
		}
		else if(editor->tranfer_function_tab->hist->fe_seleted==8)
		{
			editor->tranfer_function_tab->hist->data[ba] = newhist[hist_b];
		}
	}

	delete[] newhist;

	editor->rebuild_tabs();
}
//=================================================================================================================================
void VolumeRender::select_channel(int channel)
{

	for(int i=0; i<256; i++)
	{
		if(channel==0)
		{
			backup_rgb_tfunc[3*i+0] = rgb_tfunc[3*i+0];
			backup_rgb_tfunc[3*i+1] = rgb_tfunc[3*i+1];
			backup_rgb_tfunc[3*i+2] = rgb_tfunc[3*i+2];

			backup_ragaba_tfunc[3*i+0] = ragaba_tfunc[3*i+0];
			backup_ragaba_tfunc[3*i+1] = ragaba_tfunc[3*i+1];
			backup_ragaba_tfunc[3*i+2] = ragaba_tfunc[3*i+2];
		}
		if(channel==1)
		{
			rgb_tfunc[3*i+0] = backup_rgb_tfunc[3*i+0];
			rgb_tfunc[3*i+1] = 0;
			rgb_tfunc[3*i+2] = 0;

			ragaba_tfunc[3*i+0] = backup_ragaba_tfunc[3*i+0];
			ragaba_tfunc[3*i+1] = 0;
			ragaba_tfunc[3*i+2] = 0;
		}
		else if(channel==2)
		{
			rgb_tfunc[3*i+1] = backup_rgb_tfunc[3*i+1];
			rgb_tfunc[3*i+0] = 0;
			rgb_tfunc[3*i+2] = 0;

			ragaba_tfunc[3*i+1] = backup_ragaba_tfunc[3*i+1];
			ragaba_tfunc[3*i+0] = 0;
			ragaba_tfunc[3*i+2] = 0;
		}
		else if(channel==3)
		{
			rgb_tfunc[3*i+2] = backup_rgb_tfunc[3*i+2];
			rgb_tfunc[3*i+1] = 0;
			rgb_tfunc[3*i+0] = 0;

			ragaba_tfunc[3*i+2] = backup_ragaba_tfunc[3*i+2];
			ragaba_tfunc[3*i+1] = 0;
			ragaba_tfunc[3*i+0] = 0;
		}
		else if(channel==4)
		{
			rgb_tfunc[3*i+0] = backup_rgb_tfunc[3*i+0];
			rgb_tfunc[3*i+1] = backup_rgb_tfunc[3*i+1];
			rgb_tfunc[3*i+2] = backup_rgb_tfunc[3*i+2];

			ragaba_tfunc[3*i+0] = backup_ragaba_tfunc[3*i+0];
			ragaba_tfunc[3*i+1] = backup_ragaba_tfunc[3*i+1];
			ragaba_tfunc[3*i+2] = backup_ragaba_tfunc[3*i+2];
		}

	}

	if(channel!=0) load_1DLookupTables();
}
void VolumeRender::sort_bricks(void)
{
	vector< Vector > lengths;
	lengths.resize(brick_centresrot.size());

	Vector eye = Vector(0,0,-zoom);
	eye = eye.mult_matrix(arcball.Transform.M);
	
	//apply our camera rotation to our brick centres
	for(int n=0; n<brick_centres.size(); n++)
	{
		brick_centresrot[n] = brick_centres[n].mult_matrix(arcball.Transform.M);
		brick_centresrot[n].w = brick_centres[n].w;
	}
	int i;
	for(i=0; i<brick_centresrot.size(); i++)
	{	
		lengths[i].x = 0.0;
		lengths[i].y = 0.0;
		lengths[i].z = -brick_centresrot[i].z;//-(brick_centresrot[i]-eye).length(); //-brick_centresrot[i].z; // -(brick_centres[i]-eye).length(); //
		lengths[i].w = i;
	}

	sort(lengths.begin(), lengths.end());

	for(i=0; i<brick_centresrot.size(); i++)
	{
		sorted_brick_indices[i] = lengths[i].w;
	}
}
void VolumeRender::setViewfromEuler(float angleX, float angleY, float angleZ)
{
	//tx=ty=0;

	Matrix4x4 rot;
	int i;

	rot.find_rotation_from_euler(angleX, angleY, angleZ);
	for(i=0; i<16; i++) arcball.Transform.M[i] = rot.m[i];
	
	arcball.ThisRot.M[0] = rot.m[0];
	arcball.ThisRot.M[1] = rot.m[1];
	arcball.ThisRot.M[2] = rot.m[2];
	arcball.ThisRot.M[3] = rot.m[4];
	arcball.ThisRot.M[4] = rot.m[5];
	arcball.ThisRot.M[5] = rot.m[6];
	arcball.ThisRot.M[6] = rot.m[8];
	arcball.ThisRot.M[7] = rot.m[9];
	arcball.ThisRot.M[8] = rot.m[10];
}


void VolumeRender::setViewfromEuler2(float angleX, float angleY, float angleZ)
{
	//tx=ty=0;

	Matrix4x4 rot;
	rot.find_rotation_from_euler(angleX, angleY, angleZ);

    Matrix3fT Rot3x; //safe not to initialize
	Rot3x.M[0] = rot.m[0];
	Rot3x.M[1] = rot.m[1];
	Rot3x.M[2] = rot.m[2];
	Rot3x.M[3] = rot.m[4];
	Rot3x.M[4] = rot.m[5];
	Rot3x.M[5] = rot.m[6];
	Rot3x.M[6] = rot.m[8];
	Rot3x.M[7] = rot.m[9];
	Rot3x.M[8] = rot.m[10];

	Matrix3fMulMatrix3f(&Rot3x, &arcball.ThisRot);					// Accumulate Last Rotation Into This One
	Matrix4fSetRotationFromMatrix3f(&arcball.Transform, &Rot3x);	// Set Our Final Transform's Rotation From This One
}
//=================================================================================================================================
void VolumeRender::load_TextureMap(void)
{
	if(volobj->texture3d==NULL) return;

	if(volume_render_mode!=4)
	{
		if (volume_render_mode==1 || volume_render_mode==5)
		{
			//printf("Loading 2D Textures\n");
			load_2DTextureMaps();
		}
		else if(volume_render_mode==2 || volume_render_mode==3) 
		{
			//printf("Loading 3D Texture\n");
			load_3DTextureMap();		
		}
	}
	else if(volume_render_mode==4)
	{	
		//printf("timelapsefolder: %d\n",timelapsefolder);
		BRICKS_SUBDIV=2;
		init_3dTexture_bricks(0);
	}

	//compute our bounding box and clipping plane dimensions
	volobj->compute_boundingbox();

	//cutting_planes.init(volobj->maxres*volobj->xsize/volobj->maxsize, volobj->maxres*volobj->ysize/volobj->maxsize, volobj->maxres*volobj->zsize/volobj->maxsize);

	Vector size = Vector(volobj->boundingboxSize.x*(volobj->xsize/volobj->maxsize), volobj->boundingboxSize.y*(volobj->ysize/volobj->maxsize), volobj->boundingboxSize.z*(volobj->zsize/volobj->maxsize));
	Vector c = Vector(volobj->boundingboxCentre.x*(volobj->xsize/volobj->maxsize), volobj->boundingboxCentre.y*(volobj->ysize/volobj->maxsize), volobj->boundingboxCentre.z*(volobj->zsize/volobj->maxsize));

	cutting_planes.init(c, size);

/*	cutting_planes.v1 -= c;
	cutting_planes.v2 -= c;
	cutting_planes.v3 -= c;
	cutting_planes.v4 -= c;
	cutting_planes.v5 -= c;
	cutting_planes.v6 -= c;
	cutting_planes.v7 -= c;
	cutting_planes.v8 -= c;
*/
	bb_v1 = Vector(-1.0,  1.0,  1.0);
	bb_v2 = Vector( 1.0,  1.0,  1.0);	
	bb_v3 = Vector(-1.0, -1.0,  1.0);
	bb_v4 = Vector( 1.0, -1.0,  1.0);
	bb_v5 = Vector(-1.0,  1.0, -1.0);
	bb_v6 = Vector( 1.0,  1.0, -1.0);
	bb_v7 = Vector(-1.0, -1.0, -1.0);
	bb_v8 = Vector( 1.0, -1.0, -1.0);

	Vector bb_size = Vector(volobj->boundingboxSize.x*volobj->xsize/volobj->maxsize, volobj->boundingboxSize.y*volobj->ysize/volobj->maxsize, volobj->boundingboxSize.z*volobj->zsize/volobj->maxsize);
	bb_size /= 2.0;

	bb_v1=bb_v1*bb_size;
	bb_v2=bb_v2*bb_size;
	bb_v3=bb_v3*bb_size;
	bb_v4=bb_v4*bb_size;
	bb_v5=bb_v5*bb_size;
	bb_v6=bb_v6*bb_size;
	bb_v7=bb_v7*bb_size;
	bb_v8=bb_v8*bb_size;

	bb_v1 += c;
	bb_v2 += c;
	bb_v3 += c;
	bb_v4 += c;
	bb_v5 += c;
	bb_v6 += c;
	bb_v7 += c;
	bb_v8 += c;

	build_histogram();
	load_1DLookupTables();
}
void VolumeRender::load_2DTextureMaps(void)
{
//	if(volobj->width>256) return;
//	if(volobj->height>256) return;
//	if(volobj->depth>256) return;
	
	//ofstream fout;	
	//timer.startQTime();

	fillSlices = volobj->texdepth;//1 << (int)ceil(log(volobj->texdepth)/log(2));

	if(texNames1)
	{
		glDeleteTextures(volobj->texdepth,texNames1);
		delete[] texNames1;

	}
	texNames1 = new GLuint[fillSlices];

	if(texNames2)
	{
		glDeleteTextures(volobj->texheight,texNames2);
		delete[] texNames2;
	}

	texNames2 = new GLuint[volobj->texheight];
	
	if(texNames3)
	{
		glDeleteTextures(volobj->texwidth,texNames3);
		delete[] texNames3;
	}
	texNames3 = new GLuint[volobj->texwidth];

	init_FBO();

	GLubyte *volume1 = new GLubyte[volobj->texdepth*volobj->texheight*volobj->texwidth];
	GLubyte *volume2 = new GLubyte[volobj->texheight*fillSlices*volobj->texwidth];
	GLubyte *volume3 = new GLubyte[volobj->texwidth*volobj->texheight*fillSlices];

	int index_3D = 0;
	GLubyte rpixel = 0;
	GLubyte gpixel = 0;
	GLubyte bpixel = 0;
	GLubyte apixel = 0;

	maxX = (volobj->texwidth)/2.0;
	minX = -1*maxX;
	maxY = (volobj->texheight)/2.0;
	minY = -1*maxY;
	maxZ = (volobj->texdepth)/2.0;
	minZ = -1*maxZ;

	int progress_iter_steps = volobj->texdepth/20;
	int progress_iter=0;
	int prog;
	printf("Creating 2D Texture maps... \n");
		
	for (int z=0;z<volobj->texdepth;z++)
	{
/*		if(progress_iter==z)
		{
			prog = ( (float)(z+1)/(float)(volobj->texdepth) )*100.0f;
			printf("\r\r Progress = %.2f", prog);
			fflush(stdout);

			progress_iter += progress_iter_steps;
		}
*/
		for (int y=0;y<volobj->texheight;y++)
		{
			for (int x=0;x<volobj->texwidth;x++)
			{
				index_3D = 3*(((((z)*volobj->texheight)+(y))*volobj->texwidth)+(x));
				
				rpixel = gpixel = bpixel = (GLubyte) volobj->texture3d[index_3D+0];
				//apixel = (GLubyte) volobj->texture3d[3*index_3D+3];
				
				int index1 = z*(volobj->texheight*volobj->texwidth)+(y*volobj->texwidth)+x;
				int index2 = y*(fillSlices*volobj->texwidth)+(z*volobj->texwidth)+x;
				int index3 = x*(fillSlices*volobj->texheight)+(y*fillSlices)+z;

				volume1[index1] = rpixel;
				/*volume1[3*index1+1] = gpixel;
				volume1[3*index1+2] = bpixel;*/

				volume2[index2] = gpixel;
				/*volume2[3*index2+1] = gpixel;
				volume2[3*index2+2] = bpixel;*/

				volume3[index3] = bpixel;
				/*volume3[3*index3+1] = gpixel;
				volume3[3*index3+2] = bpixel;*/
			}
		}
	}
	printf("\n");
              
	glGenTextures(volobj->texdepth,texNames1);
	glGenTextures(volobj->texheight,texNames2);
	glGenTextures(volobj->texwidth,texNames3);
	
	/*float sec = timer.endQTime();
	fout.open("decomp.txt");
	fout<<sec<<endl;
	fout.close();*/

/*	ofstream fout;												

	benchmark=1;
	if(benchmark)
	{
		fout.open("loadtime.txt");
		timer.set_time_start();
	}*/

	//reset texture matrix
	glMatrixMode(GL_TEXTURE);
	glLoadIdentity();

	//disable auto texture coords
	glDisable(GL_TEXTURE_GEN_S);
	glDisable(GL_TEXTURE_GEN_T);
	glDisable(GL_TEXTURE_GEN_R);

	glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
    glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);

	int i;
	progress_iter_steps = volobj->texwidth/20;
	progress_iter=0;

	timer.startQTime();
	
	printf("Loading XY 2D Texture maps... \n");
	for (i=0;i<volobj->texwidth;i++)
	{
/*		if(progress_iter==i)
		{
			prog = ( (float)(i+1)/(float)(volobj->texwidth) )*100.0f;
			printf("\r\r Progress = %.2f", prog);
			fflush(stdout);

			progress_iter += progress_iter_steps;
		}
*/
		// Create MipMapped Texture
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR); // ( NEW )
		gluBuild2DMipmaps(GL_TEXTURE_2D, 1, fillSlices, volobj->texheight, GL_LUMINANCE, GL_UNSIGNED_BYTE, volume3+(i*(fillSlices*volobj->texheight))); // ( NEW )
		//if (maximumAnisotropy != 0.0f) glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAX_ANISOTROPY_EXT, maximumAnisotropy);

		//setup textur env 0 
		glBindTexture(GL_TEXTURE_2D,texNames3[i]);
		glTexImage2D(
				   GL_TEXTURE_2D,    // target
				   0,                // level
				   GL_LUMINANCE, // internal
				   fillSlices,             // width
				   volobj->texheight,             // height
				   0,                // border
				   GL_LUMINANCE, // format
				   GL_UNSIGNED_BYTE, // type
				   volume3+(i*(fillSlices*volobj->texheight)));
	}
	printf("\n");

	delete[] volume3;
	volume3=NULL;

	progress_iter_steps = volobj->texheight/20;
	progress_iter=0;

	printf("Loading XZ 2D Texture maps... \n");
	for (i=0;i<volobj->texheight;i++)
	{
/*		if(progress_iter==i)
		{
			prog = ( (float)(i+1)/(float)(volobj->texheight) )*100.0f;
			printf("\r\r Progress = %.2f", prog);
			fflush(stdout);
			progress_iter += progress_iter_steps;
		}
*/
		// Create MipMapped Texture
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER, GL_LINEAR);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR); // ( NEW )
		//if (maximumAnisotropy != 0.0f) glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAX_ANISOTROPY_EXT, maximumAnisotropy);
		gluBuild2DMipmaps(GL_TEXTURE_2D, 1, volobj->texwidth, volobj->texdepth, GL_LUMINANCE, GL_UNSIGNED_BYTE, volume2+(i*(volobj->texwidth*volobj->texdepth))); // ( NEW )
		
		//setup textur env 0 
		glBindTexture(GL_TEXTURE_2D,texNames2[i]);
		glTexImage2D(
				   GL_TEXTURE_2D,    // target
				   0,                // level
				   GL_LUMINANCE, // internal
				   volobj->texwidth,             // width
				   volobj->texdepth,             // height
				   0,                // border
				   GL_LUMINANCE, // format
				   GL_UNSIGNED_BYTE, // type
				   volume2+(i*(volobj->texwidth*volobj->texdepth)));

	}
	printf("\n");

	delete[] volume2;
	volume2=NULL;

	progress_iter_steps = volobj->texdepth/20;
	progress_iter=0;

	printf("Loading YZ 2D Texture maps... \n");
	for (i=0;i<volobj->texdepth;i++)
	{
/*		if(progress_iter==i)
		{
			prog = ( (float)(i+1)/(float)(volobj->texdepth) )*100.0f;
			printf("\r\r Progress = %.2f", prog);
			fflush(stdout);

			progress_iter += progress_iter_steps;
		}*/
		// Create MipMapped Texture
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR); // ( NEW )
		//if (maximumAnisotropy != 0.0f) glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAX_ANISOTROPY_EXT, maximumAnisotropy);
		gluBuild2DMipmaps(GL_TEXTURE_2D, 1, volobj->texwidth, volobj->texheight, GL_LUMINANCE, GL_UNSIGNED_BYTE, volume1+(i*volobj->texwidth*volobj->texheight)); // ( NEW )

		//setup textur env 0 
		glBindTexture(GL_TEXTURE_2D,texNames1[i]);
		glTexImage2D(
				   GL_TEXTURE_2D,		 // target
				   0,					// level
				   GL_LUMINANCE,					// internal
				   volobj->texwidth,         // width
				   volobj->texheight,             // height
				   0,                // border
				   GL_LUMINANCE, // format
				   GL_UNSIGNED_BYTE, // type
				   volume1+(i*volobj->texwidth*volobj->texheight));

	}

/*	if(benchmark)
	{
		timer.set_time_end();
		timer.set_time_difference();
		float msec = timer.time_diff;
		fout<<msec<<endl;
		fout.close();
	}
*/

	/*sec = timer.endQTime();
	fout.open("2dload.txt");
	fout<<sec<<endl;
	fout.close();*/
	
	int resX = volobj->width;
	int resY = volobj->height;
	int resZ = volobj->depth;
//	maxres = 256;
	cutting_planes.init(volobj->maxres*1.1,volobj->maxres*1.1,volobj->maxres*1.1);

	bb_v1 = Vector(-1.0,  1.0,  1.0);
	bb_v2 = Vector( 1.0,  1.0,  1.0);	
	bb_v3 = Vector(-1.0, -1.0,  1.0);
	bb_v4 = Vector( 1.0, -1.0,  1.0);
	bb_v5 = Vector(-1.0,  1.0, -1.0);
	bb_v6 = Vector( 1.0,  1.0, -1.0);
	bb_v7 = Vector(-1.0, -1.0, -1.0);
	bb_v8 = Vector( 1.0, -1.0, -1.0);

	Vector bb_size = Vector (volobj->maxres,volobj->maxres,volobj->maxres);
	bb_size /= 2.0;

	bb_v1=bb_v1*bb_size;
	bb_v2=bb_v2*bb_size;
	bb_v3=bb_v3*bb_size;
	bb_v4=bb_v4*bb_size;
	bb_v5=bb_v5*bb_size;
	bb_v6=bb_v6*bb_size;
	bb_v7=bb_v7*bb_size;
	bb_v8=bb_v8*bb_size;

	build_histogram();

	printf("\n");
	delete[] volume1;
	volume1=NULL;
}
void VolumeRender::load_3DTextureMap(void)
{
	/*
	if(texNames1) glDeleteTextures(volobj->texdepth,texNames1);
	if(texNames2) glDeleteTextures(volobj->texheight,texNames2);
	if(texNames3) glDeleteTextures(volobj->texwidth,texNames3);
	*/

    GLfloat borderColor[4] =  {0.0, 0.0, 0.0, 0.0};
	//printf("Loading 3D Texture maps... \n");

/*	glextensions.glTexImage3D(GL_TEXTURE_3D, 0, GL_LUMINANCE8, volobj->texwidth, volobj->texheight, volobj->texdepth, 0, GL_RGB, GL_UNSIGNED_BYTE, &volobj->texture3d[0]);

	if(glGetError() == GLU_OUT_OF_MEMORY)
	{
		printf("GL out of memory");
		return;
	}

	GLint width, height, depth;
	glGetTexLevelParameteriv(GL_PROXY_TEXTURE_3D, 0, GL_TEXTURE_WIDTH, &width);
	glGetTexLevelParameteriv(GL_PROXY_TEXTURE_3D, 0, GL_TEXTURE_HEIGHT, &height);
	glGetTexLevelParameteriv(GL_PROXY_TEXTURE_3D, 0, GL_TEXTURE_DEPTH, &depth);

	if (width == 0 || height == 0 || depth == 0)
	{
		printf("%d x %d x % d is too large!\n", volobj->texwidth, volobj->texheight, volobj->texdepth);
		return;
	}
	else
	{
		printf("%d x %d x % d is OK!\n", volobj->texwidth, volobj->texheight, volobj->texdepth);
	} 
*/

	//t.start();
	
	//----------------------------------------
	//NON-PBO TRANSFER
	//----------------------------------------

	//================
	//get red channel
	//================
	//upload red channel
	glBindTexture(GL_TEXTURE_3D, TEXTURE3D_RED);

	//avoid boundary problems 
	glTexParameteri(GL_TEXTURE_3D, GL_TEXTURE_WRAP_S, GL_CLAMP); //GL_MIRRORED_REPEAT_ARB GL_MIRRORED_REPEAT_IBM GL_CLAMP GL_REPEAT
	glTexParameteri(GL_TEXTURE_3D, GL_TEXTURE_WRAP_T, GL_CLAMP); 
	glTexParameteri(GL_TEXTURE_3D, GL_TEXTURE_WRAP_R, GL_CLAMP); 

	//set up some mipmaping
	glTexParameteri(GL_TEXTURE_3D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);	//GL_LINEAR GL_NEAREST
	glTexParameteri(GL_TEXTURE_3D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	//glPixelStorei(GL_UNPACK_SKIP_PIXELS, 3);

	//upload the data
	glextensions.glTexImage3D(GL_TEXTURE_3D, 0, GL_LUMINANCE, //numbslices  GL_LUMINANCE16 GL_LUMINANCE GL_COMPRESSED_LUMINANCE GL_COMPRESSED_LUMINANCE_ARB 
			volobj->texwidth, volobj->texheight, volobj->texdepth,
			0,
			GL_RGB, GL_UNSIGNED_BYTE, &volobj->texture3d[0]);
	
	//================
	//get green channel
	//================
	//upload green channel
	glBindTexture(GL_TEXTURE_3D, TEXTURE3D_GREEN);

	//avoid boundary problems 
	glTexParameteri(GL_TEXTURE_3D, GL_TEXTURE_WRAP_S, GL_CLAMP); //GL_MIRRORED_REPEAT_ARB GL_MIRRORED_REPEAT_IBM GL_CLAMP GL_REPEAT
	glTexParameteri(GL_TEXTURE_3D, GL_TEXTURE_WRAP_T, GL_CLAMP); 
	glTexParameteri(GL_TEXTURE_3D, GL_TEXTURE_WRAP_R, GL_CLAMP); 

	//set up some mipmaping
	glTexParameteri(GL_TEXTURE_3D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);	//GL_LINEAR GL_NEAREST
	glTexParameteri(GL_TEXTURE_3D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	//glPixelStorei(GL_UNPACK_SKIP_PIXELS, 3);

	//upload the data
	glextensions.glTexImage3D(GL_TEXTURE_3D, 0,  GL_LUMINANCE, //GL_COMPRESSED_LUMINANCE
			volobj->texwidth, volobj->texheight, volobj->texdepth,
			0,
			GL_RGB, GL_UNSIGNED_BYTE, &volobj->texture3d[1]);

	//================
	//get blue channel
	//================
	//upload blue channel
	glBindTexture(GL_TEXTURE_3D, TEXTURE3D_BLUE);

	//avoid boundary problems 
	glTexParameteri(GL_TEXTURE_3D, GL_TEXTURE_WRAP_S, GL_CLAMP); //GL_MIRRORED_REPEAT_ARB GL_MIRRORED_REPEAT_IBM GL_CLAMP GL_REPEAT
	glTexParameteri(GL_TEXTURE_3D, GL_TEXTURE_WRAP_T, GL_CLAMP); 
	glTexParameteri(GL_TEXTURE_3D, GL_TEXTURE_WRAP_R, GL_CLAMP); 

	//set up some mipmaping
	glTexParameteri(GL_TEXTURE_3D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);	//GL_LINEAR GL_NEAREST
	glTexParameteri(GL_TEXTURE_3D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	//glPixelStorei(GL_UNPACK_SKIP_PIXELS, 3);

	//upload the data
	glextensions.glTexImage3D(GL_TEXTURE_3D, 0,  GL_LUMINANCE, //GL_COMPRESSED_LUMINANCE
			volobj->texwidth, volobj->texheight, volobj->texdepth,
			0,
			GL_RGB, GL_UNSIGNED_BYTE, &volobj->texture3d[2]);


/*
	//----------------------------------------
	//PBO TRANSFER
	//----------------------------------------
	
	int datasize = volobj->texwidth*volobj->texheight*volobj->texdepth;

	glBindTexture(GL_TEXTURE_3D, TEXTURE3D_RED);
	glTexParameteri(GL_TEXTURE_3D,GL_TEXTURE_WRAP_S, GL_CLAMP_TO_EDGE);
	glTexParameteri(GL_TEXTURE_3D,GL_TEXTURE_WRAP_T, GL_CLAMP_TO_EDGE);
	glTexParameteri(GL_TEXTURE_3D,GL_TEXTURE_WRAP_R, GL_CLAMP_TO_EDGE);
	glTexParameteri(GL_TEXTURE_3D,GL_TEXTURE_MIN_FILTER, GL_LINEAR);	// Linear Filtering
	glTexParameteri(GL_TEXTURE_3D,GL_TEXTURE_MAG_FILTER, GL_LINEAR);	// Linear Filtering
	glextensions.glTexImage3D(GL_TEXTURE_3D, 0,  GL_LUMINANCE,
		volobj->texwidth, volobj->texheight, volobj->texdepth,
		0,
		GL_LUMINANCE, GL_UNSIGNED_BYTE, 0);

	glBindTexture(GL_TEXTURE_3D, TEXTURE3D_GREEN);
	glTexParameteri(GL_TEXTURE_3D,GL_TEXTURE_WRAP_S, GL_CLAMP_TO_EDGE);
	glTexParameteri(GL_TEXTURE_3D,GL_TEXTURE_WRAP_T, GL_CLAMP_TO_EDGE);
	glTexParameteri(GL_TEXTURE_3D,GL_TEXTURE_WRAP_R, GL_CLAMP_TO_EDGE);
	glTexParameteri(GL_TEXTURE_3D,GL_TEXTURE_MIN_FILTER, GL_LINEAR);	// Linear Filtering
	glTexParameteri(GL_TEXTURE_3D,GL_TEXTURE_MAG_FILTER, GL_LINEAR);	// Linear Filtering
	glextensions.glTexImage3D(GL_TEXTURE_3D, 0,  GL_LUMINANCE,
		volobj->texwidth, volobj->texheight, volobj->texdepth,
		0,
		GL_LUMINANCE, GL_UNSIGNED_BYTE, 0);

	glBindTexture(GL_TEXTURE_3D, TEXTURE3D_BLUE);
	glTexParameteri(GL_TEXTURE_3D,GL_TEXTURE_WRAP_S, GL_CLAMP_TO_EDGE);
	glTexParameteri(GL_TEXTURE_3D,GL_TEXTURE_WRAP_T, GL_CLAMP_TO_EDGE);
	glTexParameteri(GL_TEXTURE_3D,GL_TEXTURE_WRAP_R, GL_CLAMP_TO_EDGE);
	glTexParameteri(GL_TEXTURE_3D,GL_TEXTURE_MIN_FILTER, GL_LINEAR);	// Linear Filtering
	glTexParameteri(GL_TEXTURE_3D,GL_TEXTURE_MAG_FILTER, GL_LINEAR);	// Linear Filtering
	glextensions.glTexImage3D(GL_TEXTURE_3D, 0,  GL_LUMINANCE,
		volobj->texwidth, volobj->texheight, volobj->texdepth,
		0,
		GL_LUMINANCE, GL_UNSIGNED_BYTE, 0);

	glextensions.glGenBuffersARB(1, &TEXTURE3D_PBO);
    glextensions.glBindBufferARB(GL_PIXEL_UNPACK_BUFFER_ARB, TEXTURE3D_PBO);
    glextensions.glBufferDataARB(GL_PIXEL_UNPACK_BUFFER_ARB, datasize, 0, GL_STREAM_DRAW_ARB);
    glextensions.glBindBufferARB(GL_PIXEL_UNPACK_BUFFER_ARB, 0);

	GLubyte* ptr;

	//================
	//get red channel
	//================
    // start to modify pixel values ///////////////////
    // bind PBO to update pixel values
    glextensions.glBindBufferARB(GL_PIXEL_UNPACK_BUFFER_ARB, TEXTURE3D_PBO);

    // map the buffer object into client's memory
    // Note that glMapBufferARB() causes sync issue.
    // If GPU is working with this buffer, glMapBufferARB() will wait(stall)
    // for GPU to finish its job. To avoid waiting (stall), you can call
    // first glBufferDataARB() with NULL pointer before glMapBufferARB().
    // If you do that, the previous data in PBO will be discarded and
    // glMapBufferARB() returns a new allocated pointer immediately
    // even if GPU is still working with the previous data.
    glextensions.glBufferDataARB(GL_PIXEL_UNPACK_BUFFER_ARB, datasize, 0, GL_STREAM_DRAW_ARB);
    ptr = (GLubyte*)glextensions.glMapBufferARB(GL_PIXEL_UNPACK_BUFFER_ARB, GL_WRITE_ONLY_ARB);
	
	if(ptr)
    {
        // update data directly on the mapped buffer
        //updatePixels(ptr, DATA_SIZE);
        for(int i=0; i<datasize; i++) ptr[i] = volobj->texture3d[3*i+0];
		glextensions.glUnmapBufferARB(GL_PIXEL_UNPACK_BUFFER_ARB); // release pointer to mapping buffer
    }

    // bind the texture and PBO
    glBindTexture(GL_TEXTURE_3D, TEXTURE3D_RED);
    glextensions.glBindBufferARB(GL_PIXEL_UNPACK_BUFFER_ARB, TEXTURE3D_PBO);

    // copy pixels from PBO to texture object
    // Use offset instead of pointer.
    glextensions.glTexImage3D(GL_TEXTURE_3D, 0, GL_LUMINANCE, volobj->texwidth, volobj->texheight, volobj->texdepth, 0, GL_LUMINANCE, GL_UNSIGNED_BYTE, 0);
    //glextensions.glTexSubImage3D(GL_TEXTURE_3D, 0, 0,0,0, volobj->texwidth, volobj->texheight, volobj->texdepth, GL_LUMINANCE, GL_UNSIGNED_BYTE, 0);

	//print_glError();

    // it is good idea to release PBOs with ID 0 after use.
    // Once bound with 0, all pixel operations behave normal ways.
    glextensions.glBindBufferARB(GL_PIXEL_UNPACK_BUFFER_ARB, 0);

	//================
	//get green channel
	//================`

    // start to modify pixel values ///////////////////
    // bind PBO to update pixel values
    glextensions.glBindBufferARB(GL_PIXEL_UNPACK_BUFFER_ARB, TEXTURE3D_PBO);

    // map the buffer object into client's memory
    // Note that glMapBufferARB() causes sync issue.
    // If GPU is working with this buffer, glMapBufferARB() will wait(stall)
    // for GPU to finish its job. To avoid waiting (stall), you can call
    // first glBufferDataARB() with NULL pointer before glMapBufferARB().
    // If you do that, the previous data in PBO will be discarded and
    // glMapBufferARB() returns a new allocated pointer immediately
    // even if GPU is still working with the previous data.
    glextensions.glBufferDataARB(GL_PIXEL_UNPACK_BUFFER_ARB, datasize, 0, GL_STREAM_DRAW_ARB);
    ptr = (GLubyte*)glextensions.glMapBufferARB(GL_PIXEL_UNPACK_BUFFER_ARB, GL_WRITE_ONLY_ARB);
	
	if(ptr)
    {
        // update data directly on the mapped buffer
        //updatePixels(ptr, DATA_SIZE);
        for(int i=0; i<datasize; i++) ptr[i] = volobj->texture3d[3*i+1];
		glextensions.glUnmapBufferARB(GL_PIXEL_UNPACK_BUFFER_ARB); // release pointer to mapping buffer
    }

    // bind the texture and PBO
    glBindTexture(GL_TEXTURE_3D, TEXTURE3D_RED);
    glextensions.glBindBufferARB(GL_PIXEL_UNPACK_BUFFER_ARB, TEXTURE3D_GREEN);

    // copy pixels from PBO to texture object
    // Use offset instead of pointer.
    glextensions.glTexImage3D(GL_TEXTURE_3D, 0, GL_LUMINANCE, volobj->texwidth, volobj->texheight, volobj->texdepth, 0, GL_LUMINANCE, GL_UNSIGNED_BYTE, 0);
    //glextensions.glTexSubImage3D(GL_TEXTURE_3D, 0, 0,0,0, volobj->texwidth, volobj->texheight, volobj->texdepth, GL_LUMINANCE, GL_UNSIGNED_BYTE, 0);

	//print_glError();

    // it is good idea to release PBOs with ID 0 after use.
    // Once bound with 0, all pixel operations behave normal ways.
    glextensions.glBindBufferARB(GL_PIXEL_UNPACK_BUFFER_ARB, 0);


	//================
	//get blue channel
	//================

    // start to modify pixel values ///////////////////
    // bind PBO to update pixel values
    glextensions.glBindBufferARB(GL_PIXEL_UNPACK_BUFFER_ARB, TEXTURE3D_PBO);

    // map the buffer object into client's memory
    // Note that glMapBufferARB() causes sync issue.
    // If GPU is working with this buffer, glMapBufferARB() will wait(stall)
    // for GPU to finish its job. To avoid waiting (stall), you can call
    // first glBufferDataARB() with NULL pointer before glMapBufferARB().
    // If you do that, the previous data in PBO will be discarded and
    // glMapBufferARB() returns a new allocated pointer immediately
    // even if GPU is still working with the previous data.
    glextensions.glBufferDataARB(GL_PIXEL_UNPACK_BUFFER_ARB, datasize, 0, GL_STREAM_DRAW_ARB);
    ptr = (GLubyte*)glextensions.glMapBufferARB(GL_PIXEL_UNPACK_BUFFER_ARB, GL_WRITE_ONLY_ARB);
	
	if(ptr)
    {
        // update data directly on the mapped buffer
        //updatePixels(ptr, DATA_SIZE);
        for(int i=0; i<datasize; i++) ptr[i] = volobj->texture3d[3*i+2];
		glextensions.glUnmapBufferARB(GL_PIXEL_UNPACK_BUFFER_ARB); // release pointer to mapping buffer
    }

    // bind the texture and PBO
    glBindTexture(GL_TEXTURE_3D, TEXTURE3D_BLUE);
    glextensions.glBindBufferARB(GL_PIXEL_UNPACK_BUFFER_ARB, TEXTURE3D_PBO);

    // copy pixels from PBO to texture object
    // Use offset instead of pointer.
    glextensions.glTexImage3D(GL_TEXTURE_3D, 0, GL_LUMINANCE, volobj->texwidth, volobj->texheight, volobj->texdepth, 0, GL_LUMINANCE, GL_UNSIGNED_BYTE, 0);
    //glextensions.glTexSubImage3D(GL_TEXTURE_3D, 0, 0,0,0, volobj->texwidth, volobj->texheight, volobj->texdepth, GL_LUMINANCE, GL_UNSIGNED_BYTE, 0);

	//print_glError();

    // it is good idea to release PBOs with ID 0 after use.
    // Once bound with 0, all pixel operations behave normal ways.
    glextensions.glBindBufferARB(GL_PIXEL_UNPACK_BUFFER_ARB, 0);
*/
	//printf("LOADING: RAM to GPU: %d msec.\n", t.elapsed());
}
void VolumeRender::load_1DLookupTables(void)
{
	//if no 3d texture return
	if(volobj->texture3d==NULL) return;

	unsigned char alpha_func[256*3];
	float contrib = 1.0/((float)numbslices/(float)volobj->texwidth);
	
//	printf("contrib: %f\n", contrib);
//	printf("Loading 1D Lookup Tables\n");
	
	float r,g,b;
	float r0,g0,b0;

	for(int i=0; i<256; i++)
	{
		r0 = ragaba_tfunc[3*i+0];
		g0 = ragaba_tfunc[3*i+1];
		b0 = ragaba_tfunc[3*i+2];

		r = 1.0-(pow((float)(1.0-r0/256.0), contrib));
		g = 1.0-(pow((float)(1.0-g0/256.0), contrib));
		b = 1.0-(pow((float)(1.0-b0/256.0), contrib));
		
		r*=256;
		g*=256;
		b*=256;

		if(r>256) r=256;
		if(g>256) g=256;
		if(b>256) b=256;
		if(r<0) r=0;
		if(g<0) g=0;
		if(b<0) b=0;

		alpha_func[3*i+0] = r;
		alpha_func[3*i+1] = g;
		alpha_func[3*i+2] = b;
	}

	glBindTexture(GL_TEXTURE_2D, TEXTURE2D_RGB);
	glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
    glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
	glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
	glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
	glTexImage2D(GL_TEXTURE_2D, 0, GL_RGB, 256, 1, 0, GL_RGB, GL_UNSIGNED_BYTE, &rgb_tfunc[0]);	
	glBindTexture(GL_TEXTURE_2D, TEXTURE2D_RAGABA);
	glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
    glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
	glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
	glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
	glTexImage2D(GL_TEXTURE_2D, 0, GL_RGB, 256, 1, 0, GL_RGB, GL_UNSIGNED_BYTE, &alpha_func[0]);	
}
void VolumeRender::load_1DLookupTablesBricks(int brickres, int brickslices)
{
	//if no 3d texture return
	if(volobj->texture3d==NULL) return;

	unsigned char alpha_func[256*3];
	float contrib = 1.0/((float)brickslices/(float)brickres);
	
//	printf("contrib: %f\n", contrib);
//	printf("Loading 1D Lookup Tables\n");
	
	float r,g,b;
	float r0,g0,b0;

	for(int i=0; i<256; i++)
	{
		r0 = ragaba_tfunc[3*i+0];
		g0 = ragaba_tfunc[3*i+1];
		b0 = ragaba_tfunc[3*i+2];

		r = 1.0-(pow((float)(1.0-r0/255.0), contrib));
		g = 1.0-(pow((float)(1.0-g0/255.0), contrib));
		b = 1.0-(pow((float)(1.0-b0/255.0), contrib));
		
		r*=255;
		g*=255;
		b*=255;

		if(r>255) r=255;
		if(g>255) g=255;
		if(b>255) b=255;
		if(r<0) r=0;
		if(g<0) g=0;
		if(b<0) b=0;

		alpha_func[3*i+0] = r;
		alpha_func[3*i+1] = g;
		alpha_func[3*i+2] = b;
	}

	glBindTexture(GL_TEXTURE_2D, TEXTURE2D_RGB);
	glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
    glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
	glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
	glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
	glTexImage2D(GL_TEXTURE_2D, 0, GL_RGB, 256, 1, 0, GL_RGB, GL_UNSIGNED_BYTE, &rgb_tfunc[0]);	
	glBindTexture(GL_TEXTURE_2D, TEXTURE2D_RAGABA);
	glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
    glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
	glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
	glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
	glTexImage2D(GL_TEXTURE_2D, 0, GL_RGB, 256, 1, 0, GL_RGB, GL_UNSIGNED_BYTE, &alpha_func[0]);	
}
void VolumeRender::load_3dTexture_brick(int brickindex)
{
	if(loaded==0) return;
	if(brick_textures[brickindex].empty()) return;

//	printf("load_3dTexture_brick()\n");
	
	int brick_subdivs=BRICKS_SUBDIV;

	float i_offset = volobj->texwidth/(float)brick_subdivs;
	float j_offset = volobj->texheight/(float)brick_subdivs;
	float k_offset = volobj->texdepth/(float)brick_subdivs;

	int datasize = i_offset*j_offset*k_offset;

	GLubyte* ptr;

    // start to modify pixel values ///////////////////
    // bind PBO to update pixel values
    glextensions.glBindBufferARB(GL_PIXEL_UNPACK_BUFFER_ARB, TEXTURE3D_PBO);

    // map the buffer object into client's memory
    // Note that glMapBufferARB() causes sync issue.
    // If GPU is working with this buffer, glMapBufferARB() will wait(stall)
    // for GPU to finish its job. To avoid waiting (stall), you can call
    // first glBufferDataARB() with NULL pointer before glMapBufferARB().
    // If you do that, the previous data in PBO will be discarded and
    // glMapBufferARB() returns a new allocated pointer immediately
    // even if GPU is still working with the previous data.
    glextensions.glBufferDataARB(GL_PIXEL_UNPACK_BUFFER_ARB, datasize, 0, GL_STREAM_DRAW_ARB);
    ptr = (GLubyte*)glextensions.glMapBufferARB(GL_PIXEL_UNPACK_BUFFER_ARB, GL_WRITE_ONLY_ARB);
	
	if(ptr)
    {
        // update data directly on the mapped buffer
        //updatePixels(ptr, DATA_SIZE);
        for(int i=0; i<datasize; i++) ptr[i] = brick_textures[brickindex][i];
		glextensions.glUnmapBufferARB(GL_PIXEL_UNPACK_BUFFER_ARB); // release pointer to mapping buffer
    }

    // bind the texture and PBO
    glBindTexture(GL_TEXTURE_3D, TEXTURE3D_RED);
    glextensions.glBindBufferARB(GL_PIXEL_UNPACK_BUFFER_ARB, TEXTURE3D_PBO);

    // copy pixels from PBO to texture object
    // Use offset instead of pointer.
    glextensions.glTexImage3D(GL_TEXTURE_3D, 0, GL_LUMINANCE, i_offset, j_offset, k_offset, 0, GL_LUMINANCE, GL_UNSIGNED_BYTE, 0);
    //glextensions.glTexSubImage3D(GL_TEXTURE_3D, 0, 0,0,0, i_offset,j_offset,k_offset, GL_LUMINANCE, GL_UNSIGNED_BYTE, 0);

	//print_glError();

    // it is good idea to release PBOs with ID 0 after use.
    // Once bound with 0, all pixel operations behave normal ways.
    glextensions.glBindBufferARB(GL_PIXEL_UNPACK_BUFFER_ARB, 0);

	/*int datasize = i_offset*j_offset*k_offset;

	//before upload
	glextensions.glBindBufferARB(GL_PIXEL_UNPACK_BUFFER_ARB, TEXTURE3D_RED);
	glextensions.glBufferSubDataARB(GL_PIXEL_UNPACK_BUFFER_ARB, 0, datasize, &brick_textures[brickindex][0]);

	//perform upload
	glextensions.glBindBufferARB(GL_PIXEL_UNPACK_BUFFER_ARB, TEXTURE3D_RED);
	glextensions.glTexImage3D(GL_TEXTURE_3D, 0, GL_LUMINANCE, i_offset, j_offset, k_offset, 0, GL_LUMINANCE, GL_UNSIGNED_BYTE, 0);

    glextensions.glBindBufferARB(GL_PIXEL_UNPACK_BUFFER_ARB, 0);*/

/*
	glBindTexture(GL_TEXTURE_3D, TEXTURE3D_RED);

	//avoid boundary problems 
//	glTexParameteri(GL_TEXTURE_3D, GL_TEXTURE_WRAP_S, GL_MIRRORED_REPEAT_ARB);
//	glTexParameteri(GL_TEXTURE_3D, GL_TEXTURE_WRAP_T, GL_MIRRORED_REPEAT_ARB);
//	glTexParameteri(GL_TEXTURE_3D, GL_TEXTURE_WRAP_R, GL_MIRRORED_REPEAT_ARB);

	glTexParameteri(GL_TEXTURE_3D,GL_TEXTURE_WRAP_S, GL_CLAMP_TO_EDGE);
	glTexParameteri(GL_TEXTURE_3D,GL_TEXTURE_WRAP_T, GL_CLAMP_TO_EDGE);
	glTexParameteri(GL_TEXTURE_3D,GL_TEXTURE_WRAP_R, GL_CLAMP_TO_EDGE);

	//set up some mipmaping
	glTexParameteri(GL_TEXTURE_3D,GL_TEXTURE_MIN_FILTER, GL_LINEAR);	// Linear Filtering
	glTexParameteri(GL_TEXTURE_3D,GL_TEXTURE_MAG_FILTER, GL_LINEAR);	// Linear Filtering

	glextensions.glTexImage3D(GL_TEXTURE_3D, 0,  GL_LUMINANCE,
		i_offset, j_offset, k_offset,
		0,
		GL_LUMINANCE, GL_UNSIGNED_BYTE, &brick_textures[brickindex][0]);
*/
}

//=================================================================================================================================
void VolumeRender::render_scene(int render)
{
	//if(render)
	{
		//------------------------------------------------
		//Setup our FBO object
		//------------------------------------------------
		if(glextensions.fbo_support)
		{
			if(fbo_lod==1)
			{
				render_size = LOD_FBO_SIZE;
				lodfbo_object.bind(lodfbo_object.frameBufferIndex);

//				lodfbo_object.bind();
//				lodfbo_object.switchTarget(TEXTURE2D_LODFBO_FB);
			}
			else
			{
				render_size = FBO_SIZE;
				fbo_object.bind(fbo_object.frameBufferIndex);
//				fbo_object.bind();
//				fbo_object.switchTarget(TEXTURE2D_FBO_FB);
			}

			glClear( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT );
			glMatrixMode(GL_TEXTURE);
			glLoadIdentity();
		
			glViewport( 0, 0, (GLint)winWidth, (GLint)winWidth);
			glGetIntegerv(GL_VIEWPORT, viewport);	

			glViewport( 0, 0, (GLint)render_size, (GLint)render_size );
		
			if(stereo_toggle==0)
			{
				glMatrixMode( GL_PROJECTION );
				glLoadIdentity();     
				
				if(projection_toggle==0)
					gluPerspective(camera.fov, (float)camera.width/(float)camera.height, camera.znear, camera.zfar);	
				else if(projection_toggle==1)
						glOrtho(-volobj->maxres-zoom, volobj->maxres+zoom, -volobj->maxres-zoom, volobj->maxres+zoom, -1024, 1024);

				glGetDoublev (GL_PROJECTION_MATRIX, projmatrix);
			}
		}

		//------------------------------------------------
		//Render the non-volume objects
		//------------------------------------------------

		glMatrixMode(GL_MODELVIEW);
		glLoadIdentity();
		glTranslatef(tx, ty, -zoom);
				
		glPushMatrix();

			aim_light();
			if(lights_toggle) render_light(Vector(light_pos0.x, light_pos0.y, light_pos0.z), Vector(light_dir0.x, light_dir0.y, light_dir0.z));

			// Apply our arcball transformation matrix		
			glMultMatrixf(arcball.Transform.M);
			glGetDoublev (GL_MODELVIEW_MATRIX, mvmatrix);

			glDisable(GL_BLEND);
			glDisable(GL_LIGHTING);

			float scene_size = (float)LOD_FBO_SIZE;
			if(fbo_lod) scene_size = (float)LOD_FBO_SIZE/4.0f;
			float linesize = scene_size*(1.0/64.0);
			float pointsize = scene_size*(1.0/64.0);
			float bg_oversize = 2.0;
			Vector col = Vector(background_fontcolour.red()/255.0, background_fontcolour.blue()/255.0, background_fontcolour.green()/255.0);

			Vector eye = Vector(0,0,-1);		
			eye = eye.mult_matrix((float*)&texrot_mat.m[0]);
			
			glPushMatrix();

			cutting_planes.disable();
			//glTranslatef(volobj->boundingboxCentre.x*(volobj->xsize/volobj->maxsize), volobj->boundingboxCentre.y*(volobj->ysize/volobj->maxsize), volobj->boundingboxCentre.z*(volobj->zsize/volobj->maxsize));
			cutting_planes.display(linesize, pointsize, bg_oversize, col, eye);
			cutting_planes.enable();
		

			glPopMatrix();

			//tell gl about our clipping planes
			cutting_planes.setup();			
			cutting_planes.disable();

			//draw our slices planes
			if(slice_draw_mode) render_slices(slice_draw_mode);

			//draw our bounding box
			if(BB_toggle) render_boundingbox();

			render_3dTextureSlice1();

			if(measure_toggle) render_measurements();
		
			//draw our cursor
			if(cursor_toggle) render_3DCursor();

			//draw our isosurfaces
			if(isosurface_toggle)
			{
				render_celleigenvectors();
				render_meshes();
			}
		
		glPopMatrix();

		//------------------------------------------------
		//Render the Volume
		//------------------------------------------------
		
		cutting_planes.enable();

		glMatrixMode(GL_MODELVIEW);
		glLoadIdentity();

		//render our volume, 2d or 3d textures
		if(volume_toggle)
		{
			glEnable(GL_LIGHTING);
			glEnable(GL_BLEND);

			blend_mode(bldmode);

			if(volume_render_mode==1) render_2dTexture();
			else if(volume_render_mode==2) render_3dTextureMultiPass();	
			else if(volume_render_mode==3) render_3dTexture();
			else if(volume_render_mode==4) render_3dTexture_bricks(0);
			else if(volume_render_mode==5) render_2dMultiTextureMultiPass();
			
			glDisable(GL_BLEND);
			glDisable(GL_LIGHTING);
		}

		cutting_planes.disable();
		
		//------------------------------------------------
		//Render our clipping plane texture mapped slices
		//------------------------------------------------
		//printf("Rending volume\n");
		glPushMatrix();
			glMatrixMode(GL_MODELVIEW);
			glLoadIdentity();
			glTranslatef(tx, ty, -zoom);
			glMultMatrixf(arcball.Transform.M);
			glMatrixMode(GL_TEXTURE);
			glLoadIdentity();
			render_3dTextureSlice();
			glMatrixMode(GL_TEXTURE);
			glLoadIdentity();
		glPopMatrix();
	}

	if(offscreen_toggle==0)
	{
		if(glextensions.fbo_support)
		{
			//------------------------------------------------
			//Close the FBO
			//------------------------------------------------
			int quad_size = render_size/2.0;
			if(fbo_lod==1) lodfbo_object.stop();		
			else fbo_object.stop();	
			
			//------------------------------------------------
			//Render the texture mapped quad of our scene
			//------------------------------------------------
			glViewport( 0, 0, (GLint)winWidth, (GLint)winHeight );
			glClear( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT );
			glClearColor( background_colour.red()/255.0, background_colour.green()/255.0, background_colour.blue()/255.0, 1.0f );

			glMatrixMode( GL_PROJECTION );
			glLoadIdentity();     
			glOrtho(-winWidth, winWidth, -winHeight, winHeight, -1024, 1024);
			//glOrtho(-volobj->maxres-zoom, volobj->maxres+zoom, -volobj->maxres-zoom, volobj->maxres+zoom, -1024, 1024);
			glMatrixMode(GL_TEXTURE);
			glLoadIdentity();
			glMatrixMode(GL_MODELVIEW);
			glLoadIdentity();
			
			if(glextensions.shader_support && PostProcess_toggle) postrendering_shaderobj.enable();
			
			glextensions.glActiveTexture(GL_TEXTURE0);
			if(fbo_lod==1) glBindTexture(GL_TEXTURE_2D, TEXTURE2D_LODFBO_FB);
			else  glBindTexture(GL_TEXTURE_2D, TEXTURE2D_FBO_FB);
			glEnable(GL_TEXTURE_2D);

			//if(fbo_depth==1) glBindTexture(GL_TEXTURE_2D, TEXTURE2D_FBO_DP);

			//glextensions.glActiveTexture(GL_TEXTURE0);
			//glBindTexture(GL_TEXTURE_2D, TEXTURE2D_FBO_DP);
			//glEnable(GL_TEXTURE_2D);
			//glextensions.glActiveTexture(GL_TEXTURE1);
			//glBindTexture(GL_TEXTURE_2D, TEXTURE2D_FBO_FB);
			//glEnable(GL_TEXTURE_2D);
	
  			glColor3f(1.0, 1.0, 1.0);
			glBegin(GL_QUADS);
					glTexCoord2f(0, 0); glVertex3f(-winWidth, -winWidth, 0.0f);
					glTexCoord2f(1, 0); glVertex3f( winWidth, -winWidth, 0.0f);
					glTexCoord2f(1, 1); glVertex3f( winWidth,  winWidth, 0.0f);
					glTexCoord2f(0, 1); glVertex3f(-winWidth,  winWidth, 0.0f);

			glEnd();

			glDisable(GL_TEXTURE_2D);

			if(glextensions.shader_support && PostProcess_toggle) postrendering_shaderobj.disable();

			glextensions.glActiveTexture(GL_TEXTURE0);
			glDisable(GL_TEXTURE_2D);
			//glextensions.glActiveTexture(GL_TEXTURE1);
			//glDisable(GL_TEXTURE_2D);
			glextensions.glActiveTexture(GL_TEXTURE0);
		}
	}

	if(axis_toggle) render_axis();

//	printf("time: %d\n", msec);
}
//=================================================================================================================================
void VolumeRender::render_celleigenvectors(void)
{
	glPushMatrix();

	float maxsize =  max((float)volobj->xsize, (float)volobj->ysize);
	maxsize =  max((float)maxsize, (float)volobj->zsize);
		
//	glTranslatef(-(volobj->texwidth-1)/2.0, -(volobj->texheight-1)/2.0, -(volobj->texdepth-1)/2.0);
//	glScalef(volobj->maxres/volobj->texwidth, volobj->maxres/volobj->texheight, volobj->maxres/volobj->texdepth);		
//	glScalef((volobj->xsize/maxsize), (volobj->ysize/maxsize), (volobj->zsize/maxsize));

	Vector eigenmean;	
	Vector eigenvec0;
	Vector eigenvec1;
	Vector eigenvec2;
	Vector eigenlengths;
	Vector axis;
	
	Vector x_axis = Vector(1,0,0);
	Vector y_axis = Vector(0,1,0);
	Vector z_axis = Vector(0,0,1);
	Matrix4x4 rot;

	Vector rgb, hsv;
	
	//display our PCs
	//================
	glDisable(GL_LIGHTING);
	glDisable(GL_TEXTURE_2D);
	glDisable(GL_TEXTURE_3D);

	
	for(int i=0; i<time_celledges.size(); i++)
		for(int j=0; j<time_celledges[i].size()/3; j++)
			for(int k=0; k<time_celledges[i][j].size()/3; k++)
			{
				if(time_celledges[i][3*j][3*k]==true)
				{
					eigenvec0  = time_cellmeans[i][3*j];
					eigenvec1 = time_cellmeans[i][3*k];
					glColor3f(1.0, 1.0, 0.0); 
					glLineWidth(4.0);
					glBegin(GL_LINES);
					glVertex3fv( &eigenvec0.x );
					glVertex3fv( &eigenvec1.x );
					glEnd();
				}
			}
	
	for(int i=0; i<time_celleigenvectors.size(); i++)
	{	
		//printf("eigsize: %d\n", time_celleigenvectors[i].size());

		for(int j=0; j<time_celleigenvectors[i].size()/3; j++)
		{
			eigenmean = time_cellmeans[i][3*j+0];
			eigenvec0 = time_celleigenvectors[i][3*j+0];
			eigenvec1 = time_celleigenvectors[i][3*j+1];
			eigenvec2 = time_celleigenvectors[i][3*j+2];
			//eigenlengths = Vector(eigenvec0.length(), eigenvec1.length(), eigenvec2.length());

			glLineWidth(1.0);
			glColor3f(1.0, 1.0, 1.0); 
			rot.find_rotationfromaxis(eigenvec0, eigenvec1, eigenvec2, x_axis, y_axis, z_axis);
			render_ellipsoid(eigenmean, Vector(1,1,1), &rot, 16, GL_LINE_LOOP);

			/*glLineWidth(4.0);
			glBegin(GL_LINES);
				glColor3f(1.0, 0.0, 0.0);
				glVertex3fv( &(eigenmean+eigenvec0).x );
				glVertex3fv( &(eigenmean-eigenvec0).x );
				
				glColor3f(0.0, 1.0, 0.0); 
				glVertex3fv( &(eigenmean+eigenvec1).x );
				glVertex3fv( &(eigenmean-eigenvec1).x );
				
				glColor3f(0.0, 0.0, 1.0); 
				glVertex3fv( &(eigenmean+eigenvec2).x );
				glVertex3fv( &(eigenmean-eigenvec2).x );			
			glEnd();*/
		}
	}

	glLineWidth(1.0);		
	glEnable(GL_LIGHTING);
	
	glPopMatrix();
}
//=================================================================================================================================
void VolumeRender::rebuild_texcoords(void)
{
	texrot_mat.m[0] = cutting_planes.planes[0].arcball.Transform.M[0];
	texrot_mat.m[1] = cutting_planes.planes[0].arcball.Transform.M[4];
	texrot_mat.m[2] = cutting_planes.planes[0].arcball.Transform.M[8];
	texrot_mat.m[3] = cutting_planes.planes[0].arcball.Transform.M[12];
	texrot_mat.m[4] = cutting_planes.planes[0].arcball.Transform.M[1];
	texrot_mat.m[5] = cutting_planes.planes[0].arcball.Transform.M[5];
	texrot_mat.m[6] = cutting_planes.planes[0].arcball.Transform.M[9];
	texrot_mat.m[7] = cutting_planes.planes[0].arcball.Transform.M[13];
	texrot_mat.m[8] = cutting_planes.planes[0].arcball.Transform.M[2];
	texrot_mat.m[9] = cutting_planes.planes[0].arcball.Transform.M[6];
	texrot_mat.m[10] = cutting_planes.planes[0].arcball.Transform.M[10];
	texrot_mat.m[11] = cutting_planes.planes[0].arcball.Transform.M[14];
	texrot_mat.m[12] = cutting_planes.planes[0].arcball.Transform.M[3];
	texrot_mat.m[13] = cutting_planes.planes[0].arcball.Transform.M[7];
	texrot_mat.m[14] = cutting_planes.planes[0].arcball.Transform.M[11];
	texrot_mat.m[15] = cutting_planes.planes[0].arcball.Transform.M[15];

	//enable texture matrix 
	glMatrixMode(GL_TEXTURE);
	glLoadIdentity();

	//apply our camera rotation to 3d texture
	//we could do this on each texcoord,
	//but this is more efficient
	glTranslatef((float)volobj->texwidth/(float)volobj->maxres*volobj->xsize,(float)volobj->texheight/(float)volobj->maxres*volobj->ysize,(float)volobj->texdepth/(float)volobj->maxres*volobj->zsize);
	glMultMatrixf(texrot_mat.m);		
	glTranslatef(-(float)volobj->texwidth/(float)volobj->maxres*volobj->xsize,-(float)volobj->texheight/(float)volobj->maxres*volobj->ysize,-(float)volobj->texdepth/(float)volobj->maxres*volobj->zsize);

	//switch back to modelview matrix
	glMatrixMode(GL_MODELVIEW);
}
void VolumeRender::rebuildwithscaling_texcoords(void)
{
	texrot_mat.m[0] = arcball.Transform.M[0];
	texrot_mat.m[1] = arcball.Transform.M[4];
	texrot_mat.m[2] = arcball.Transform.M[8];
	texrot_mat.m[3] = arcball.Transform.M[12];
	texrot_mat.m[4] = arcball.Transform.M[1];
	texrot_mat.m[5] = arcball.Transform.M[5];
	texrot_mat.m[6] = arcball.Transform.M[9];
	texrot_mat.m[7] = arcball.Transform.M[13];
	texrot_mat.m[8] = arcball.Transform.M[2];
	texrot_mat.m[9] = arcball.Transform.M[6];
	texrot_mat.m[10] = arcball.Transform.M[10];
	texrot_mat.m[11] = arcball.Transform.M[14];
	texrot_mat.m[12] = arcball.Transform.M[3];
	texrot_mat.m[13] = arcball.Transform.M[7];
	texrot_mat.m[14] = arcball.Transform.M[11];
	texrot_mat.m[15] = arcball.Transform.M[15];

	//enable texture matrix 
	glMatrixMode(GL_TEXTURE);
	glLoadIdentity();

	tex_translate.x = tx/(volobj->texwidth);
	tex_translate.y = ty/(volobj->texheight);

//	printf("volobj->maxsize: %f\n", volobj->maxsize);

	glTranslatef(0.5,0.5,0.5);
	glScalef(volobj->maxres/volobj->texwidth, volobj->maxres/volobj->texheight, volobj->maxres/volobj->texdepth);		
	glScalef(1.0/(volobj->xsize/volobj->maxsize), 1.0/(volobj->ysize/volobj->maxsize), 1.0/(volobj->zsize/volobj->maxsize));
	glMultMatrixf(texrot_mat.m);
	glTranslatef(-0.5,-0.5,-0.5);

	//switch back to modelview matrix
	glMatrixMode(GL_MODELVIEW);
}
void VolumeRender::render_3dTexture_bricks(int subdivs)
{
	//if we dont have any 3d texture return
	if(volobj->texture3d==NULL) return;

	//if we dont have any brick centres or cutting planes, ie: no bricks created return
	if(brick_centres.size()==0) return;

	//some variable helpers for our rendering routine
	Vector brick_centre;
	Vector v1, v2, v3, v4;
	Vector t1, t2, t3, t4;
	float s, offset;
	int brick_index = 0;

	//number of brick subdivisions
	int brick_subdivs=BRICKS_SUBDIV;

	//allocate some storage for our transformed 
	//brick centres
	brick_centresrot.clear();
	brick_centresrot.resize(brick_centres.size());

	//allocate some storage for our sorted brick indices
	sorted_brick_indices.clear();
	sorted_brick_indices.resize(brick_centres.size());

	float vert_res = (volobj->maxres/BRICKS_SUBDIV);
	float vert_resX = (volobj->texwidth/BRICKS_SUBDIV);
	float vert_resY = (volobj->texheight/BRICKS_SUBDIV);
	float vert_resZ = (volobj->texdepth/BRICKS_SUBDIV);

	float maxsize =  max((float)volobj->xsize, (float)volobj->ysize);
	maxsize =  max((float)maxsize, (float)volobj->zsize);

	//geometry for our view-aligned slices
	CVector m_pVertices[8];
	m_pVertices[0] = CVector(-1.0,-1.0,-1.0, 1.0,  0.0, 0.0, 0.0);
	m_pVertices[1] = CVector( 1.0,-1.0,-1.0, 1.0,  1.0, 0.0, 0.0);
	m_pVertices[2] = CVector( 1.0, 1.0,-1.0, 1.0,  1.0, 1.0, 0.0);
	m_pVertices[3] = CVector(-1.0, 1.0,-1.0, 1.0,  0.0, 1.0, 0.0);															
	m_pVertices[4] = CVector(-1.0,-1.0, 1.0, 1.0,  0.0, 0.0, 1.0);
	m_pVertices[5] = CVector( 1.0,-1.0, 1.0, 1.0,  1.0, 0.0, 1.0);
	m_pVertices[6] = CVector( 1.0, 1.0, 1.0, 1.0,  1.0, 1.0, 1.0);
	m_pVertices[7] = CVector(-1.0, 1.0, 1.0, 1.0,  0.0, 1.0, 1.0);
		
	Vector m_pEdges[12];
	m_pEdges[0]  = Vector(0,1);
	m_pEdges[1]  = Vector(1,2);
	m_pEdges[2]  = Vector(2,3);
	m_pEdges[3]  = Vector(3,0);
	m_pEdges[4]  = Vector(0,4);
	m_pEdges[5]  = Vector(1,5);
	m_pEdges[6]  = Vector(2,6);
	m_pEdges[7]  = Vector(3,7);
	m_pEdges[8]  = Vector(4,5);
	m_pEdges[9]  = Vector(5,6);
	m_pEdges[10] = Vector(6,7);
	m_pEdges[11] = Vector(7,4);

	const int m_pEdgeList[8][12] = {
		{ 0,1,5,6,   4,8,11,9,  3,7,2,10 }, // v0 is front
		{ 0,4,3,11,  1,2,6,7,   5,9,8,10 }, // v1 is front
		{ 1,5,0,8,   2,3,7,4,   6,10,9,11}, // v2 is front
		{ 7,11,10,8, 2,6,1,9,   3,0,4,5  }, // v3 is front
		{ 8,5,9,1,   11,10,7,6, 4,3,0,2  }, // v4 is front
		{ 9,6,10,2,  8,11,4,7,  5,0,1,3  }, // v5 is front
		{ 9,8,5,4,   6,1,2,0,   10,7,11,3}, // v6 is front
		{ 10,9,6,5,  7,2,3,1,   11,4,8,0 }  // v7 is front
	}; 


	//sort brick centres by distance to viewer
	sort_bricks();

	glPointSize(4.0);
	glLineWidth(2.0);	
	glDisable(GL_LIGHTING);

	//tranverse each brick
	for(int i=0; i<brick_centres.size(); i++)
	{
		//get our sorted brick index
		brick_index =  sorted_brick_indices[i];

		//get our current brick centre
		brick_centre = brick_centresrot[brick_index];

		//if(empty_brick[brick_centre.w]==0)
		{
			//glPushMatrix();

				//reset our modelview matrix
				glMatrixMode(GL_MODELVIEW);
				glLoadIdentity();

				//apply camera and zoom transformations
				glTranslatef(tx, ty, -zoom);
				glTranslatef(brick_centre.x, brick_centre.y, brick_centre.z);
				glMultMatrixf(arcball.Transform.M);
				
				glScalef(vert_resX/2.0, vert_resY/2.0, vert_resZ/2.0);
				glScalef((volobj->xsize/maxsize), (volobj->ysize/maxsize), (volobj->zsize/maxsize));

				float pMatrix[16];
				glGetFloatv(GL_MODELVIEW_MATRIX,pMatrix);
				CVector viewVec(-pMatrix[2],-pMatrix[6],-pMatrix[10],0.0);

				double dMaxDist = viewVec * m_pVertices[0];
				double dMinDist = dMaxDist;
				int nMaxIdx = 0;
				for(int i = 1; i < 8; ++i) 
				{
					double dist = viewVec * m_pVertices[i];
					if ( dist > dMaxDist) 
					{
						dMaxDist = dist;
						nMaxIdx = i;
					}
					if ( dist < dMinDist) 
					{
						dMinDist = dist;
					}
				}

				//printf("dMinDist %f, dMaxDist %f \n", dMinDist, dMaxDist);
				CVector vecStart[12];
				CVector vecDir[12];
				CVector texStart[12];
				CVector texDir[12];

				float lambda[12];
				float lambda_inc[12];
				double denom;

				int m_nNumSlices = (float)vert_res/2.0;

				float EPSILON = 0.000001;
				dMinDist += EPSILON;
				dMaxDist -= EPSILON;
				double dPlaneDist    =  dMinDist;   
				double dPlaneDistInc =  (dMaxDist-dMinDist)/double(m_nNumSlices);

				for(int ii = 0; ii < 12; ii++) 
				{
					vecStart[ii] = m_pVertices[(int)m_pEdges[m_pEdgeList[nMaxIdx][ii]].x];
					vecDir[ii]   = m_pVertices[(int)m_pEdges[m_pEdgeList[nMaxIdx][ii]].y] - m_pVertices[(int)m_pEdges[m_pEdgeList[nMaxIdx][ii]].x];

					denom = vecDir[ii] *viewVec;

					if (1.0 + denom != 1.0) 
					{
						lambda_inc[ii] =  dPlaneDistInc/denom;
						lambda[ii]     = (dPlaneDist - vecStart[ii] * viewVec)/denom;
					} 
					else
					{
						lambda[ii]     = -1.0;
						lambda_inc[ii] =  0.0;	
					}
				}
				
				cutting_planes.disable();

				/*glColor3f(1.0, 1.0, 1.0);
				glBegin(GL_LINES);
				for(int ii = 0; ii < 12; ii++) 
				{
					glVertex3dv(&m_pVertices[(int)m_pEdges[m_pEdgeList[nMaxIdx][ii]].x][0]);
					glVertex3dv(&m_pVertices[(int)m_pEdges[m_pEdgeList[nMaxIdx][ii]].y][0]);
				}
				glEnd();*/

				cutting_planes.enable();
				
			//glPopMatrix();

			glPushMatrix();
				glMatrixMode(GL_TEXTURE);
				glLoadIdentity();

				glMatrixMode(GL_MODELVIEW);
				//glLoadIdentity();
				
				//upload to gfx current 3d texture brick
				load_3dTexture_brick(brick_centresrot[brick_index].w);
				
				//load_1DLookupTablesBricks(brick_index, m_nNumSlices);

				//enable and attach texture units
				glextensions.glActiveTexture(GL_TEXTURE0);
				glBindTexture(GL_TEXTURE_3D, TEXTURE3D_RED);
				glEnable(GL_TEXTURE_3D);
				glextensions.glActiveTexture(GL_TEXTURE1);
				glBindTexture(GL_TEXTURE_3D, TEXTURE3D_GREEN);
				glEnable(GL_TEXTURE_3D);
				glextensions.glActiveTexture(GL_TEXTURE2);
				glBindTexture(GL_TEXTURE_3D, TEXTURE3D_BLUE);
				glEnable(GL_TEXTURE_3D);
				glextensions.glActiveTexture(GL_TEXTURE3);
				glBindTexture(GL_TEXTURE_2D, TEXTURE2D_RGB);
				glEnable(GL_TEXTURE_2D);
				glextensions.glActiveTexture(GL_TEXTURE4);
				glBindTexture(GL_TEXTURE_2D, TEXTURE2D_RAGABA);
				glEnable(GL_TEXTURE_2D);
				glextensions.glActiveTexture(GL_TEXTURE5);
				glBindTexture(GL_TEXTURE_2D, TEXTURE2D_JITTER);
				glEnable(GL_TEXTURE_2D);

				//enable our GLSL shaders if we support them
				if(volume_render_mode!=1 && glextensions.shader_support==1) 
						vol_shaderobj.enable();

				//glEnable(GL_LIGHTING);
				glEnable(GL_TEXTURE_3D);
				glEnable(GL_BLEND);
				blend_mode(bldmode);

				vol_shaderobj.sendUniform1i("channel", 3);
				vol_shaderobj.sendUniform1i("volumeTexture", 0);
					
				CVector intersection[6];
				float lmb[12];

				for(int n = m_nNumSlices-1; n >= 0; --n) 
				{
					for(int e = 0; e < 12; e++) 
					{
						lmb[e] = lambda[e] + n*lambda_inc[e];
					}

					if      ((lmb[0] >= 0.0) && (lmb[0] < 1.0)) intersection[0] = vecStart[0] + lmb[0] * vecDir[0];
					else if ((lmb[1] >= 0.0) && (lmb[1] < 1.0)) intersection[0] = vecStart[1] + lmb[1] * vecDir[1];
					else if ((lmb[3] >= 0.0) && (lmb[3] < 1.0)) intersection[0] = vecStart[3] + lmb[3] * vecDir[3];
					else continue;
					
					if	    ((lmb[2] >= 0.0) && (lmb[2] < 1.0)) intersection[1] = vecStart[2] + lmb[2] * vecDir[2];
					else if ((lmb[0] >= 0.0) && (lmb[0] < 1.0)) intersection[1] = vecStart[0] + lmb[0] * vecDir[0];
					else if ((lmb[1] >= 0.0) && (lmb[1] < 1.0)) intersection[1] = vecStart[1] + lmb[1] * vecDir[1];
					else intersection[1] = vecStart[3] + lmb[3] * vecDir[3];

					if      ((lmb[4] >= 0.0) && (lmb[4] < 1.0)) intersection[2] = vecStart[4] + lmb[4] * vecDir[4];
					else if ((lmb[5] >= 0.0) && (lmb[5] < 1.0)) intersection[2] = vecStart[5] + lmb[5] * vecDir[5];
					else intersection[2] = vecStart[7] + lmb[7] * vecDir[7];
					
					if	    ((lmb[6] >= 0.0) && (lmb[6] < 1.0)) intersection[3] = vecStart[6] + lmb[6] * vecDir[6];
					else if ((lmb[4] >= 0.0) && (lmb[4] < 1.0)) intersection[3] = vecStart[4] + lmb[4] * vecDir[4];
					else if ((lmb[5] >= 0.0) && (lmb[5] < 1.0)) intersection[3] = vecStart[5] + lmb[5] * vecDir[5];
					else intersection[3] = vecStart[7] + lmb[7] * vecDir[7];

					if	    ((lmb[8] >= 0.0) && (lmb[8] < 1.0)) intersection[4] = vecStart[8] + lmb[8] * vecDir[8] ;
					else if ((lmb[9] >= 0.0) && (lmb[9] < 1.0)) intersection[4] = vecStart[9] + lmb[9] * vecDir[9] ;
					else intersection[4] = vecStart[11]+ lmb[11]* vecDir[11];
					
					if	    ((lmb[10]>= 0.0) && (lmb[10]< 1.0)) intersection[5] = vecStart[10]+ lmb[10]* vecDir[10];
					else if ((lmb[8] >= 0.0) && (lmb[8] < 1.0)) intersection[5] = vecStart[8] + lmb[8] * vecDir[8] ;
					else if ((lmb[9] >= 0.0) && (lmb[9] < 1.0)) intersection[5] = vecStart[9] + lmb[9] * vecDir[9] ;
					else intersection[5] = vecStart[11]+ lmb[11]* vecDir[11];
				
					//float c = 1.0f-float(n)/float(m_nNumSlices);
					//glColor3f(c,c,c);
					glColor3f(1.0,1.0,1.0);
					glBegin(GL_TRIANGLE_FAN);
					for(int ii = 0; ii < 6; ++ii)
					{
						intersection[ii].glVertex(false,true);
					}
					glEnd();
				}				

				glextensions.glActiveTexture(GL_TEXTURE0);
				glDisable(GL_TEXTURE_3D);
				glextensions.glActiveTexture(GL_TEXTURE1);
				glDisable(GL_TEXTURE_3D);
				glextensions.glActiveTexture(GL_TEXTURE2);
				glDisable(GL_TEXTURE_3D);
				glextensions.glActiveTexture(GL_TEXTURE3);
				glDisable(GL_TEXTURE_2D);
				glextensions.glActiveTexture(GL_TEXTURE4);
				glDisable(GL_TEXTURE_2D);
				glextensions.glActiveTexture(GL_TEXTURE5);
				glDisable(GL_TEXTURE_2D);

				//reset default to texture unit 0
				glextensions.glActiveTexture(GL_TEXTURE0);

				glDisable(GL_TEXTURE_3D);
				glDisable(GL_BLEND);
				glDisable(GL_LIGHTING);

				//disable our GLSL shaders if we support them
				if(volume_render_mode!=1 && glextensions.shader_support==1) 
						vol_shaderobj.disable();

			glPopMatrix();
		}
	}
}
void VolumeRender::render_3dTexture(void)
{
	if(volobj->texture3d==NULL) return;
	int i;

	rebuildwithscaling_texcoords();

	int resX = volobj->texwidth;
	int resY = volobj->texheight;
	int resZ = volobj->texdepth;

	float maxres = 0.0;
	maxres = max((float)maxres, (float)resX);
	maxres = max((float)maxres, (float)resY);
	maxres = max((float)maxres, (float)resZ);

	resX = resY = resZ = maxres;

	if(glextensions.multitexture_support && glextensions.shader_support)
	{
		vol_shadersinglepassobj.enable();

		//enable 3 texture units and bind our 3D volume, and the 2 lookup tables
		glextensions.glActiveTexture(GL_TEXTURE0);
		glBindTexture(GL_TEXTURE_3D, TEXTURE3D_RED);
		glEnable(GL_TEXTURE_3D);
		glextensions.glActiveTexture(GL_TEXTURE1);
		glBindTexture(GL_TEXTURE_3D, TEXTURE3D_GREEN);
		glEnable(GL_TEXTURE_3D);
		glextensions.glActiveTexture(GL_TEXTURE2);
		glBindTexture(GL_TEXTURE_3D, TEXTURE3D_BLUE);
		glEnable(GL_TEXTURE_3D);
		glextensions.glActiveTexture(GL_TEXTURE3);
		glBindTexture(GL_TEXTURE_2D, TEXTURE2D_RGB);
		glEnable(GL_TEXTURE_2D);
	}
	
	v1 = Vector(-resX, -resY, 0);
	v2 = Vector( resX, -resY, 0);	
	v3 = Vector( resX,  resY, 0);
	v4 = Vector(-resX,  resY, 0);
	t1 = Vector(-0.5,-0.5, 0);
	t2 = Vector(1.5,-0.5, 0);
	t3 = Vector(1.5,1.5, 0);
	t4 = Vector(-0.5,1.5, 0);

	glColor3f(1.0,1.0,1.0);
	for(i = -numbslices/2; i <numbslices+numbslices/2; i++)
	{
		t1.z = t2.z = t3.z = t4.z = (float)i/(float)numbslices;
		v1.z = v2.z = v3.z = v4.z = -(resZ/2.0) + ((float)i/(float)numbslices)*resZ;

		glBegin(GL_QUADS);
			glTexCoord3fv(&t1.x);
			glVertex3fv(&v1.x);
			glTexCoord3fv(&t2.x);
			glVertex3fv(&v2.x);
			glTexCoord3fv(&t3.x);
			glVertex3fv(&v3.x);
			glTexCoord3fv(&t4.x);
			glVertex3fv(&v4.x);
		glEnd();
	}

	/*Vector v1, v2, v3, v4;
	Vector t1, t2, t3, t4;
	float s, offset;

	int temp;
	temp = slices;
	slices *= 2;
	slices = maxres;

	glColor3f(1.0,1.0,1.0);
	//glBindTexture(GL_TEXTURE_3D, 0);
	glEnable(GL_TEXTURE_3D);
	glBegin(GL_QUADS);
	for(i = -slices/2; i <slices+slices/2; i++)
	{
		s = (float)i/(float)slices;
		offset = -128.0 + ((float)i/(float)slices)*256.0;

		v1 = Vector(-256.f+tx, -256.f+ty, offset);
		v2 = Vector( 256.f+tx, -256.f+ty, offset);	
		v3 = Vector( 256.f+tx,  256.f+ty, offset);
		v4 = Vector(-256.f+tx,  256.f+ty, offset);
		
		t1 = Vector(-0.5,-0.5, s);
		t2 = Vector(1.5,-0.5, s);
		t3 = Vector(1.5,1.5, s);
		t4 = Vector(-0.5,1.5, s);

		glTexCoord3fv(&t1.x);
		glVertex3fv(&v1.x);
		glTexCoord3fv(&t2.x);
		glVertex3fv(&v2.x);
		glTexCoord3fv(&t3.x);
		glVertex3fv(&v3.x);
		glTexCoord3fv(&t4.x);
		glVertex3fv(&v4.x);
	}
	glEnd();
	glDisable(GL_TEXTURE_3D);
	
	slices = temp;*/
	
	if(glextensions.multitexture_support && glextensions.shader_support)
	{
		//disable shader object
		vol_shadersinglepassobj.disable();

		//disable 3 texture units
		glextensions.glActiveTexture(GL_TEXTURE0);
		glDisable(GL_TEXTURE_3D);
		glextensions.glActiveTexture(GL_TEXTURE1);
		glDisable(GL_TEXTURE_3D);
		glextensions.glActiveTexture(GL_TEXTURE2);
		glDisable(GL_TEXTURE_3D);
		glextensions.glActiveTexture(GL_TEXTURE3);
		glDisable(GL_TEXTURE_2D);
		
		//reset default to texture unit 0
		glextensions.glActiveTexture(GL_TEXTURE0);
	}
}
void VolumeRender::render_3dTextureMultiPass(void)
{
	glPushMatrix();
	glMatrixMode(GL_TEXTURE);
	glLoadIdentity();

	glMatrixMode(GL_MODELVIEW);
	glTranslatef(tx, ty, -zoom);

	if(volobj->texture3d==NULL)
	{
		return;
	}

	int i;

	rebuildwithscaling_texcoords();

	if(volobj->is_greyscale)
	{
				//printf("singlechannel\n");
				if(redclip_toggle==0 || greenclip_toggle==0 || blueclip_toggle==0) cutting_planes.disable();
				else cutting_planes.enable();

			//if(glextensions.multitexture_support && glextensions.shader_support)
			{
				vol_shaderobj.enable();
				if(volobj->is16bit==true)
				{
					vol_shaderobj.sendUniform1i("channel", 4);
					vol_shaderobj.sendUniform1i("volumeTexture", 0);
					vol_shaderobj.sendUniform1i("volumeTexture2", 1);
				}
				else
				{
					vol_shaderobj.sendUniform1i("channel", 3);
					vol_shaderobj.sendUniform1i("volumeTexture", 0);
				}
				
				//enable 3 texture units and bind our 3D volume, and the 2 lookup tables
				glextensions.glActiveTexture(GL_TEXTURE0);
				glBindTexture(GL_TEXTURE_3D, TEXTURE3D_RED);
				glEnable(GL_TEXTURE_3D);
				glextensions.glActiveTexture(GL_TEXTURE1);
				glBindTexture(GL_TEXTURE_3D, TEXTURE3D_GREEN);
				glEnable(GL_TEXTURE_3D);
				glextensions.glActiveTexture(GL_TEXTURE2);
				glBindTexture(GL_TEXTURE_3D, TEXTURE3D_BLUE);
				glEnable(GL_TEXTURE_3D);
				glextensions.glActiveTexture(GL_TEXTURE3);
				glBindTexture(GL_TEXTURE_2D, TEXTURE2D_RGB);
				glEnable(GL_TEXTURE_2D);
				glextensions.glActiveTexture(GL_TEXTURE4);
				glBindTexture(GL_TEXTURE_2D, TEXTURE2D_RAGABA);
				glEnable(GL_TEXTURE_2D);
				glextensions.glActiveTexture(GL_TEXTURE5);
				glBindTexture(GL_TEXTURE_2D, TEXTURE2D_JITTER);
				glEnable(GL_TEXTURE_2D);
			}
			
			v1 = Vector(-volobj->maxres, -volobj->maxres, 0);
			v2 = Vector( volobj->maxres, -volobj->maxres, 0);	
			v3 = Vector( volobj->maxres,  volobj->maxres, 0);
			v4 = Vector(-volobj->maxres,  volobj->maxres, 0);
			t1 = Vector(-0.5,-0.5, 0);
			t2 = Vector(1.5,-0.5, 0);
			t3 = Vector(1.5,1.5, 0);
			t4 = Vector(-0.5,1.5, 0);

			glColor3f(1.0,1.0,1.0);
			for(i = -numbslices/2; i <numbslices+numbslices/2; i++)
			//for(i = numbslices+numbslices/2; i >=-numbslices/2; i--)
			{
				t1.z = t2.z = t3.z = t4.z = (float)i/(float)numbslices;
				v1.z = v2.z = v3.z = v4.z = -((float)volobj->maxres/2.0) + ((float)i/(float)numbslices)*(float)volobj->maxres;

				glBegin(GL_QUADS);
					glTexCoord3fv(&t1.x);
					glVertex3fv(&v1.x);
					glTexCoord3fv(&t2.x);
					glVertex3fv(&v2.x);
					glTexCoord3fv(&t3.x);
					glVertex3fv(&v3.x);
					glTexCoord3fv(&t4.x);
					glVertex3fv(&v4.x);
				glEnd();
			}

			//if(glextensions.multitexture_support && glextensions.shader_support)
			{
				//disable shader object
				vol_shaderobj.disable();

				glextensions.glActiveTexture(GL_TEXTURE0);
				glDisable(GL_TEXTURE_3D);
				glextensions.glActiveTexture(GL_TEXTURE1);
				glDisable(GL_TEXTURE_3D);
				glextensions.glActiveTexture(GL_TEXTURE2);
				glDisable(GL_TEXTURE_3D);
				glextensions.glActiveTexture(GL_TEXTURE3);
				glDisable(GL_TEXTURE_2D);
				glextensions.glActiveTexture(GL_TEXTURE4);
				glDisable(GL_TEXTURE_2D);
				glextensions.glActiveTexture(GL_TEXTURE5);
				glDisable(GL_TEXTURE_2D);

				//reset default to texture unit 0
				glextensions.glActiveTexture(GL_TEXTURE0);
			}

	}
	else
	{
			//if(glextensions.multitexture_support && glextensions.shader_support)
			{
				vol_shaderobj.enable();

				//enable 3 texture units and bind our 3D volume, and the 2 lookup tables
				glextensions.glActiveTexture(GL_TEXTURE0);
				glBindTexture(GL_TEXTURE_3D, TEXTURE3D_RED);
				glEnable(GL_TEXTURE_3D);
				glextensions.glActiveTexture(GL_TEXTURE1);
				glBindTexture(GL_TEXTURE_3D, TEXTURE3D_GREEN);
				glEnable(GL_TEXTURE_3D);
				glextensions.glActiveTexture(GL_TEXTURE2);
				glBindTexture(GL_TEXTURE_3D, TEXTURE3D_BLUE);
				glEnable(GL_TEXTURE_3D);
				glextensions.glActiveTexture(GL_TEXTURE3);
				glBindTexture(GL_TEXTURE_2D, TEXTURE2D_RGB);
				glEnable(GL_TEXTURE_2D);
				glextensions.glActiveTexture(GL_TEXTURE4);
				glBindTexture(GL_TEXTURE_2D, TEXTURE2D_RAGABA);
				glEnable(GL_TEXTURE_2D);
				glextensions.glActiveTexture(GL_TEXTURE5);
				glBindTexture(GL_TEXTURE_2D, TEXTURE2D_JITTER);
				glEnable(GL_TEXTURE_2D);
			}

			Vector v1, v2, v3, v4;
			Vector t1, t2, t3, t4;

			v1 = Vector(-volobj->maxres, -volobj->maxres, 0);
			v2 = Vector( volobj->maxres, -volobj->maxres, 0);	
			v3 = Vector( volobj->maxres,  volobj->maxres, 0);
			v4 = Vector(-volobj->maxres,  volobj->maxres, 0);
			
			t1 = Vector(-0.5,-0.5, 0);
			t2 = Vector(1.5,-0.5, 0);
			t3 = Vector(1.5,1.5, 0);
			t4 = Vector(-0.5,1.5, 0);

			glColor3f(1.0,1.0,1.0);

			for(i = -numbslices/2; i <numbslices+numbslices/2; i++)
//			for(i = numbslices+numbslices/2; i >=-numbslices/2; i--)
			{
				t1.z = t2.z = t3.z = t4.z = (float)i/(float)numbslices;
				v1.z = v2.z = v3.z = v4.z = -((float)volobj->maxres/2.0) + ((float)i/(float)numbslices)*(float)volobj->maxres;

				if(r_channel)
				{
					if(redclip_toggle==0) cutting_planes.disable();
					else cutting_planes.enable();

					vol_shaderobj.sendUniform1i("channel", 0);				
					vol_shaderobj.sendUniform1i("volumeTexture", 0);

					glBegin(GL_QUADS);
						glTexCoord3fv(&t1.x);
						glVertex3fv(&v1.x);
						glTexCoord3fv(&t2.x);
						glVertex3fv(&v2.x);
						glTexCoord3fv(&t3.x);
						glVertex3fv(&v3.x);
						glTexCoord3fv(&t4.x);
						glVertex3fv(&v4.x);
					glEnd();
				}
				if(g_channel)
				{
					if(greenclip_toggle==0) cutting_planes.disable();
					else cutting_planes.enable();

					vol_shaderobj.sendUniform1i("channel", 1);			
					vol_shaderobj.sendUniform1i("volumeTexture", 1);

					glBegin(GL_QUADS);
						glTexCoord3fv(&t1.x);
						glVertex3fv(&v1.x);
						glTexCoord3fv(&t2.x);
						glVertex3fv(&v2.x);
						glTexCoord3fv(&t3.x);
						glVertex3fv(&v3.x);
						glTexCoord3fv(&t4.x);
						glVertex3fv(&v4.x);
					glEnd();
				}
				if(b_channel)
				{
					if(blueclip_toggle==0) cutting_planes.disable();
					else cutting_planes.enable();

					vol_shaderobj.sendUniform1i("channel", 2);				
					vol_shaderobj.sendUniform1i("volumeTexture", 2);

					glBegin(GL_QUADS);
						glTexCoord3fv(&t1.x);
						glVertex3fv(&v1.x);
						glTexCoord3fv(&t2.x);
						glVertex3fv(&v2.x);
						glTexCoord3fv(&t3.x);
						glVertex3fv(&v3.x);
						glTexCoord3fv(&t4.x);
						glVertex3fv(&v4.x);
					glEnd();
				}
			}

//			if(glextensions.multitexture_support && glextensions.shader_support)
			{
				//disable shader object
				vol_shaderobj.disable();

				glextensions.glActiveTexture(GL_TEXTURE0);
				glDisable(GL_TEXTURE_3D);
				glextensions.glActiveTexture(GL_TEXTURE1);
				glDisable(GL_TEXTURE_3D);
				glextensions.glActiveTexture(GL_TEXTURE2);
				glDisable(GL_TEXTURE_3D);
				glextensions.glActiveTexture(GL_TEXTURE3);
				glDisable(GL_TEXTURE_2D);
				glextensions.glActiveTexture(GL_TEXTURE4);
				glDisable(GL_TEXTURE_2D);
				glextensions.glActiveTexture(GL_TEXTURE5);
				glDisable(GL_TEXTURE_2D);

				//reset default to texture unit 0
				glextensions.glActiveTexture(GL_TEXTURE0);
			}

	}

//	cutting_planes.disable();
	glPopMatrix();
	
}
void VolumeRender::render_3dTextureSlicePlane_i_bricks(int i, GLenum surface,int mode, int text)
{
	if(cutting_planes.plane_clippoints[i].empty()) return;
/*
	vol_rgbsectionshaderobj.enable();	
	vol_rgbsectionshaderobj.sendUniform1i("channel", mode);	
	vol_rgbsectionshaderobj.sendUniform1i("volumeTexture", text);

	for(int j=0; j<6; j++)
	{
		if(j!=i) cutting_planes.enable(j);
	}

	float maxsize =  max((float)volobj->xsize, (float)volobj->ysize);
	maxsize =  max((float)maxsize, (float)volobj->zsize);
	Vector res = Vector(volobj->texwidth*(volobj->xsize/maxsize), volobj->texheight*(volobj->ysize/maxsize), volobj->texdepth*(volobj->zsize/maxsize));

	float vert_res = (volobj->maxres/BRICKS_SUBDIV);
	float vert_resX = (volobj->texwidth/BRICKS_SUBDIV);
	float vert_resY = (volobj->texheight/BRICKS_SUBDIV);
	float vert_resZ = (volobj->texdepth/BRICKS_SUBDIV);
	
	Vector brickres = Vector(vert_resX, vert_resY, vert_resZ);
	Vector brickreshalf = brickres/2.0f;
	int brick_index;
	Vector brick_centre;
	Vector brick_start;

	for(int ii=0; ii<brick_centres.size(); ii++)
	{
		//get our sorted brick index
		brick_index =  sorted_brick_indices[ii];
		
		if(brick_index==4)
		{

		//get our current brick centre
		brick_centre = brick_centresrot[brick_index];

		brick_start = brick_centres[brick_index]-(brickres/2.0f);
		//printf("brick_start: %f, %f, %f\n", brick_start.x, brick_start.y, brick_start.z);

		//glScalef(vert_resX/2.0, vert_resY/2.0, vert_resZ/2.0);
		//glScalef((volobj->xsize/maxsize), (volobj->ysize/maxsize), (volobj->zsize/maxsize));

		load_3dTexture_brick(brick_centresrot[brick_index].w);

		//enable and attach texture units
		glextensions.glActiveTexture(GL_TEXTURE0);
		glBindTexture(GL_TEXTURE_3D, TEXTURE3D_RED);
		glEnable(GL_TEXTURE_3D);
		glextensions.glActiveTexture(GL_TEXTURE1);
		glBindTexture(GL_TEXTURE_3D, TEXTURE3D_GREEN);
		glEnable(GL_TEXTURE_3D);
		glextensions.glActiveTexture(GL_TEXTURE2);
		glBindTexture(GL_TEXTURE_3D, TEXTURE3D_BLUE);
		glEnable(GL_TEXTURE_3D);
		glextensions.glActiveTexture(GL_TEXTURE3);
		glBindTexture(GL_TEXTURE_2D, TEXTURE2D_RGB);
		glEnable(GL_TEXTURE_2D);
		glextensions.glActiveTexture(GL_TEXTURE4);
		glBindTexture(GL_TEXTURE_2D, TEXTURE2D_RAGABA);
		glEnable(GL_TEXTURE_2D);
		glextensions.glActiveTexture(GL_TEXTURE5);
		glBindTexture(GL_TEXTURE_2D, TEXTURE2D_JITTER);
		glEnable(GL_TEXTURE_2D);
		
		glColor3f(1,1,1);
		glBegin(surface);
		for(int j=0; j<cutting_planes.plane_clippoints[i].size(); j++)
		{
			v1 = cutting_planes.plane_clippoints[i][j]-(0.2f*cutting_planes.planes[i].normal);
			//t1 = (v1-brick_centre)/brickres;
			//t1 = v1/res;
			t1 =  (v1 - brick_start)/brickres;
			glTexCoord3fv(&t1.x);
			glVertex3fv(&v1.x);
		}
		glEnd();
		glBegin(surface);
		for(int j=0; j<cutting_planes.plane_clippoints[i].size(); j++)
		{
			v1 = cutting_planes.plane_clippoints[i][j]+(0.2f*cutting_planes.planes[i].normal);
			//t1 = (v1-brick_centre)/brickres;
			//t1 = v1/res;
			t1 =  (v1 - brick_start)/brickres;
			//printf("t1: %f, %f, %f\n", t1.x, t1.y, t1.z);

			glTexCoord3fv(&t1.x);
			glVertex3fv(&v1.x);
		}
		glEnd();

		//disable texture units
		glextensions.glActiveTexture(GL_TEXTURE0);
		glDisable(GL_TEXTURE_3D);
		glextensions.glActiveTexture(GL_TEXTURE1);
		glDisable(GL_TEXTURE_3D);
		glextensions.glActiveTexture(GL_TEXTURE2);
		glDisable(GL_TEXTURE_3D);
		glextensions.glActiveTexture(GL_TEXTURE3);
		glDisable(GL_TEXTURE_2D);
		glextensions.glActiveTexture(GL_TEXTURE4);
		glDisable(GL_TEXTURE_2D);
		glextensions.glActiveTexture(GL_TEXTURE5);
		glDisable(GL_TEXTURE_2D);

		//reset default to texture unit 0
		glextensions.glActiveTexture(GL_TEXTURE0);

		}
	}

	cutting_planes.disable();
	vol_rgbsectionshaderobj.disable();*/	
/*
	//if we dont have any 3d texture return
	if(volobj->texture3d==NULL) return;

	//if we dont have any brick centres or cutting planes, ie: no bricks created return
	if(brick_centres.size()==0) return;

	//some variable helpers for our rendering routine
	Vector brick_centre;
	Vector v1, v2, v3, v4;
	Vector t1, t2, t3, t4;
	float s, offset;
	int brick_index = 0;

	//number of brick subdivisions
	int brick_subdivs=BRICKS_SUBDIV;

	//allocate some storage for our transformed 
	//brick centres
	brick_centresrot.clear();
	brick_centresrot.resize(brick_centres.size());

	//allocate some storage for our sorted brick indices
	sorted_brick_indices.clear();
	sorted_brick_indices.resize(brick_centres.size());

	float vert_res = (volobj->maxres/BRICKS_SUBDIV);
	float vert_resX = (volobj->texwidth/BRICKS_SUBDIV);
	float vert_resY = (volobj->texheight/BRICKS_SUBDIV);
	float vert_resZ = (volobj->texdepth/BRICKS_SUBDIV);

	float maxsize =  max((float)volobj->xsize, (float)volobj->ysize);
	maxsize =  max((float)maxsize, (float)volobj->zsize);

	//geometry for our view-aligned slices
	CVector m_pVertices[8];
	m_pVertices[0] = CVector(-1.0,-1.0,-1.0, 1.0,  0.0, 0.0, 0.0);
	m_pVertices[1] = CVector( 1.0,-1.0,-1.0, 1.0,  1.0, 0.0, 0.0);
	m_pVertices[2] = CVector( 1.0, 1.0,-1.0, 1.0,  1.0, 1.0, 0.0);
	m_pVertices[3] = CVector(-1.0, 1.0,-1.0, 1.0,  0.0, 1.0, 0.0);															
	m_pVertices[4] = CVector(-1.0,-1.0, 1.0, 1.0,  0.0, 0.0, 1.0);
	m_pVertices[5] = CVector( 1.0,-1.0, 1.0, 1.0,  1.0, 0.0, 1.0);
	m_pVertices[6] = CVector( 1.0, 1.0, 1.0, 1.0,  1.0, 1.0, 1.0);
	m_pVertices[7] = CVector(-1.0, 1.0, 1.0, 1.0,  0.0, 1.0, 1.0);
		
	Vector m_pEdges[12];
	m_pEdges[0]  = Vector(0,1);
	m_pEdges[1]  = Vector(1,2);
	m_pEdges[2]  = Vector(2,3);
	m_pEdges[3]  = Vector(3,0);
	m_pEdges[4]  = Vector(0,4);
	m_pEdges[5]  = Vector(1,5);
	m_pEdges[6]  = Vector(2,6);
	m_pEdges[7]  = Vector(3,7);
	m_pEdges[8]  = Vector(4,5);
	m_pEdges[9]  = Vector(5,6);
	m_pEdges[10] = Vector(6,7);
	m_pEdges[11] = Vector(7,4);

	const int m_pEdgeList[8][12] = {
		{ 0,1,5,6,   4,8,11,9,  3,7,2,10 }, // v0 is front
		{ 0,4,3,11,  1,2,6,7,   5,9,8,10 }, // v1 is front
		{ 1,5,0,8,   2,3,7,4,   6,10,9,11}, // v2 is front
		{ 7,11,10,8, 2,6,1,9,   3,0,4,5  }, // v3 is front
		{ 8,5,9,1,   11,10,7,6, 4,3,0,2  }, // v4 is front
		{ 9,6,10,2,  8,11,4,7,  5,0,1,3  }, // v5 is front
		{ 9,8,5,4,   6,1,2,0,   10,7,11,3}, // v6 is front
		{ 10,9,6,5,  7,2,3,1,   11,4,8,0 }  // v7 is front
	}; 

	//sort brick centres by distance to viewer
	sort_bricks();

	glPointSize(4.0);
	glLineWidth(2.0);	
	glDisable(GL_LIGHTING);

	//printf("vert_res: %f\n", vert_res);

	//tranverse each brick
	for(int ij=0; ij<brick_centres.size(); ij++)
	{
		//get our sorted brick index
		brick_index =  sorted_brick_indices[ij];

		//get our current brick centre
		brick_centre = brick_centresrot[brick_index];

		CVector viewVec = CVector(cutting_planes.planes[i].normal.x, cutting_planes.planes[i].normal.y, cutting_planes.planes[i].normal.z);
		Vector c1 = cutting_planes.planes[i].v1 + cutting_planes.planes[i].v2 + cutting_planes.planes[i].v3 + cutting_planes.planes[i].v4;
		c1 /= 4.0;
		Vector c2 = cutting_planes.planes[i]._v1 + cutting_planes.planes[i]._v2 + cutting_planes.planes[i]._v3 + cutting_planes.planes[i]._v4;
		c2 /= 4.0;
		Vector c5 = brick_centres[brick_index];

		Vector c3 = c2 - c1;
		Vector c4 = c2 - c5;

		//float n =  cutting_planes.planes[i].normal.dot(c3);
		float n = c3.length();
		float n2 = c4.length();

		glBegin(GL_POINTS);
			glColor3f(1,0,0);
			glVertex3fv(&c2.x);
			glColor3f(0,1,0);
			glVertex3fv(&c5.x);
		glEnd();

		printf("brick: %d, dist: %f\n", ij, n2);
		//if(empty_brick[brick_centre.w]==0)
		if(n2>0.0 && n2<vert_res)
		{
			glBegin(GL_POINTS);
				glColor3f(1,1,0);
				glVertex3fv(&c5.x);
			glEnd();

			//n *= (float)brick_subdivs;
			glPushMatrix();

				//reset our modelview matrix
				glMatrixMode(GL_MODELVIEW);
				glLoadIdentity();

				//apply camera and zoom transformations
				glTranslatef(tx, ty, -zoom);
				glTranslatef(brick_centre.x, brick_centre.y, brick_centre.z);
				glMultMatrixf(arcball.Transform.M);
				
				glScalef(vert_resX/2.0, vert_resY/2.0, vert_resZ/2.0);
				glScalef((volobj->xsize/maxsize), (volobj->ysize/maxsize), (volobj->zsize/maxsize));

				double dMaxDist = viewVec * m_pVertices[0];
				double dMinDist = dMaxDist;
				int nMaxIdx = 0;
				for(int ij = 1; ij < 8; ++ij) 
				{
					double dist = viewVec * m_pVertices[ij];
					if ( dist > dMaxDist) 
					{
						dMaxDist = dist;
						nMaxIdx = i;
					}
					if ( dist < dMinDist) 
					{
						dMinDist = dist;
					}
				}

				CVector vecStart[12];
				CVector vecDir[12];
				CVector texStart[12];
				CVector texDir[12];

				float lambda[12];
				float lambda_inc[12];
				double denom;

				int m_nNumSlices = vert_res;

				float EPSILON = 0.001;
				dMinDist += EPSILON;
				dMaxDist -= EPSILON;
				double dPlaneDist    =  dMinDist;   
				double dPlaneDistInc =  (dMaxDist-dMinDist)/double(m_nNumSlices);

				for(int ii = 0; ii < 12; ii++) 
				{
					vecStart[ii] = m_pVertices[(int)m_pEdges[m_pEdgeList[nMaxIdx][ii]].x];
					vecDir[ii]   = m_pVertices[(int)m_pEdges[m_pEdgeList[nMaxIdx][ii]].y] - m_pVertices[(int)m_pEdges[m_pEdgeList[nMaxIdx][ii]].x];

					denom = vecDir[ii] *viewVec;

					if (1.0 + denom != 1.0) 
					{
						lambda_inc[ii] =  dPlaneDistInc/denom;
						lambda[ii]     = (dPlaneDist - vecStart[ii] * viewVec)/denom;
					} 
					else
					{
						lambda[ii]     = -1.0;
						lambda_inc[ii] =  0.0;	
					}
				}

			//glPopMatrix();

			//glPushMatrix();
				//glMatrixMode(GL_TEXTURE);
				//glLoadIdentity();

				//glMatrixMode(GL_MODELVIEW);
				//glLoadIdentity();
				
				//upload to gfx current 3d texture brick
				load_3dTexture_brick(brick_centresrot[brick_index].w);
				
				//load_1DLookupTablesBricks(brick_index, m_nNumSlices);
/*
				//enable and attach texture units
				glextensions.glActiveTexture(GL_TEXTURE0);
				glBindTexture(GL_TEXTURE_3D, TEXTURE3D_RED);
				glEnable(GL_TEXTURE_3D);
				glextensions.glActiveTexture(GL_TEXTURE1);
				glBindTexture(GL_TEXTURE_3D, TEXTURE3D_GREEN);
				glEnable(GL_TEXTURE_3D);
				glextensions.glActiveTexture(GL_TEXTURE2);
				glBindTexture(GL_TEXTURE_3D, TEXTURE3D_BLUE);
				glEnable(GL_TEXTURE_3D);
				glextensions.glActiveTexture(GL_TEXTURE3);
				glBindTexture(GL_TEXTURE_2D, TEXTURE2D_RGB);
				glEnable(GL_TEXTURE_2D);
				glextensions.glActiveTexture(GL_TEXTURE4);
				glBindTexture(GL_TEXTURE_2D, TEXTURE2D_RAGABA);
				glEnable(GL_TEXTURE_2D);
				glextensions.glActiveTexture(GL_TEXTURE5);
				glBindTexture(GL_TEXTURE_2D, TEXTURE2D_JITTER);
				glEnable(GL_TEXTURE_2D);

				//enable our GLSL shaders if we support them
				if(volume_render_mode!=1 && glextensions.shader_support==1) 
						vol_shaderobj.enable();

				//glEnable(GL_LIGHTING);
				glEnable(GL_TEXTURE_3D);
				glEnable(GL_BLEND);
				blend_mode(bldmode);

				vol_shaderobj.sendUniform1i("channel", 3);
				vol_shaderobj.sendUniform1i("volumeTexture", 0);
*/				/*	
					CVector intersection[6];
					float lmb[12];


					for(int e = 0; e < 12; e++) 
					{
						lmb[e] = lambda[e] + n*lambda_inc[e];
					}

					if      ((lmb[0] >= 0.0) && (lmb[0] < 1.0)) intersection[0] = vecStart[0] + lmb[0] * vecDir[0];
					else if ((lmb[1] >= 0.0) && (lmb[1] < 1.0)) intersection[0] = vecStart[1] + lmb[1] * vecDir[1];
					else if ((lmb[3] >= 0.0) && (lmb[3] < 1.0)) intersection[0] = vecStart[3] + lmb[3] * vecDir[3];
					else continue;

					if	    ((lmb[2] >= 0.0) && (lmb[2] < 1.0)) intersection[1] = vecStart[2] + lmb[2] * vecDir[2];
					else if ((lmb[0] >= 0.0) && (lmb[0] < 1.0)) intersection[1] = vecStart[0] + lmb[0] * vecDir[0];
					else if ((lmb[1] >= 0.0) && (lmb[1] < 1.0)) intersection[1] = vecStart[1] + lmb[1] * vecDir[1];
					else intersection[1] = vecStart[3] + lmb[3] * vecDir[3];

					if      ((lmb[4] >= 0.0) && (lmb[4] < 1.0)) intersection[2] = vecStart[4] + lmb[4] * vecDir[4];
					else if ((lmb[5] >= 0.0) && (lmb[5] < 1.0)) intersection[2] = vecStart[5] + lmb[5] * vecDir[5];
					else intersection[2] = vecStart[7] + lmb[7] * vecDir[7];
					
					if	    ((lmb[6] >= 0.0) && (lmb[6] < 1.0)) intersection[3] = vecStart[6] + lmb[6] * vecDir[6];
					else if ((lmb[4] >= 0.0) && (lmb[4] < 1.0)) intersection[3] = vecStart[4] + lmb[4] * vecDir[4];
					else if ((lmb[5] >= 0.0) && (lmb[5] < 1.0)) intersection[3] = vecStart[5] + lmb[5] * vecDir[5];
					else intersection[3] = vecStart[7] + lmb[7] * vecDir[7];

					if	    ((lmb[8] >= 0.0) && (lmb[8] < 1.0)) intersection[4] = vecStart[8] + lmb[8] * vecDir[8] ;
					else if ((lmb[9] >= 0.0) && (lmb[9] < 1.0)) intersection[4] = vecStart[9] + lmb[9] * vecDir[9] ;
					else intersection[4] = vecStart[11]+ lmb[11]* vecDir[11];
					
					if	    ((lmb[10]>= 0.0) && (lmb[10]< 1.0)) intersection[5] = vecStart[10]+ lmb[10]* vecDir[10];
					else if ((lmb[8] >= 0.0) && (lmb[8] < 1.0)) intersection[5] = vecStart[8] + lmb[8] * vecDir[8] ;
					else if ((lmb[9] >= 0.0) && (lmb[9] < 1.0)) intersection[5] = vecStart[9] + lmb[9] * vecDir[9] ;
					else intersection[5] = vecStart[11]+ lmb[11]* vecDir[11];
				
					//float c = 1.0f-float(n)/float(m_nNumSlices);
					//glColor3f(c,c,c);
					/*glColor3f(1.0,1.0,1.0);
					glBegin(GL_TRIANGLE_FAN);
					for(int ii = 0; ii < 6; ++ii)
					{
						intersection[ii].glVertex(false,true);
					}
					glEnd();*/
/*
					glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
					glColor3f(0.0,1.0,0.0);
					glBegin(GL_TRIANGLE_FAN);
					for(int ii = 0; ii < 6; ++ii)
					{
						intersection[ii].glVertex(false,true);
					}
					glEnd();							
					glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
/*
					glextensions.glActiveTexture(GL_TEXTURE0);
					glDisable(GL_TEXTURE_3D);
					glextensions.glActiveTexture(GL_TEXTURE1);
					glDisable(GL_TEXTURE_3D);
					glextensions.glActiveTexture(GL_TEXTURE2);
					glDisable(GL_TEXTURE_3D);
					glextensions.glActiveTexture(GL_TEXTURE3);
					glDisable(GL_TEXTURE_2D);
					glextensions.glActiveTexture(GL_TEXTURE4);
					glDisable(GL_TEXTURE_2D);
					glextensions.glActiveTexture(GL_TEXTURE5);
					glDisable(GL_TEXTURE_2D);

					//reset default to texture unit 0
					glextensions.glActiveTexture(GL_TEXTURE0);

					glDisable(GL_TEXTURE_3D);
					glDisable(GL_BLEND);
					glDisable(GL_LIGHTING);

					//disable our GLSL shaders if we support them
					if(volume_render_mode!=1 && glextensions.shader_support==1) 
							vol_shaderobj.disable();
	*/									

			//glPopMatrix();
/*		glPopMatrix();
		}
	}*/
}
void VolumeRender::render_3dTextureSlicePlane_i(int i, GLenum surface,int mode, int text)
{
	if(cutting_planes.plane_clippoints[i].empty()) return;

	//enable and attach texture units
	glextensions.glActiveTexture(GL_TEXTURE0);
	glBindTexture(GL_TEXTURE_3D, TEXTURE3D_RED);
	glEnable(GL_TEXTURE_3D);
	glextensions.glActiveTexture(GL_TEXTURE1);
	glBindTexture(GL_TEXTURE_3D, TEXTURE3D_GREEN);
	glEnable(GL_TEXTURE_3D);
	glextensions.glActiveTexture(GL_TEXTURE2);
	glBindTexture(GL_TEXTURE_3D, TEXTURE3D_BLUE);
	glEnable(GL_TEXTURE_3D);
	glextensions.glActiveTexture(GL_TEXTURE3);
	glBindTexture(GL_TEXTURE_2D, TEXTURE2D_RGB);
	glEnable(GL_TEXTURE_2D);
	glextensions.glActiveTexture(GL_TEXTURE4);
	glBindTexture(GL_TEXTURE_2D, TEXTURE2D_RAGABA);
	glEnable(GL_TEXTURE_2D);
	glextensions.glActiveTexture(GL_TEXTURE5);
	glBindTexture(GL_TEXTURE_2D, TEXTURE2D_JITTER);
	glEnable(GL_TEXTURE_2D);

	//Turn blending off
	//glDisable(GL_BLEND);

	//ENABLE SHADER PROGRAM
	//if(volobj->is_greyscale)
	{
		vol_rgbsectionshaderobj.enable();	
		vol_rgbsectionshaderobj.sendUniform1i("channel", mode);	
		vol_rgbsectionshaderobj.sendUniform1i("volumeTexture", text);
	}
	/*else
	{
		vol_sectionshaderobj.enable();
	}*/

	for(int j=0; j<6; j++)
	{
		if(j!=i) cutting_planes.enable(j);
	}
	float maxsize =  max((float)volobj->xsize, (float)volobj->ysize);
	maxsize =  max((float)maxsize, (float)volobj->zsize);
	Vector res = Vector(volobj->texwidth*(volobj->xsize/maxsize), volobj->texheight*(volobj->ysize/maxsize), volobj->texdepth*(volobj->zsize/maxsize));
	
	glColor3f(1,1,1);
	glBegin(surface);
	for(int j=0; j<cutting_planes.plane_clippoints[i].size(); j++)
	{
		v1 = cutting_planes.plane_clippoints[i][j]-(0.2f*cutting_planes.planes[i].normal);
		t1 = v1/res;
		glTexCoord3fv(&t1.x);
		glVertex3fv(&v1.x);
	}
	glEnd();
	glBegin(surface);
	for(int j=0; j<cutting_planes.plane_clippoints[i].size(); j++)
	{
		v1 = cutting_planes.plane_clippoints[i][j]+(0.2f*cutting_planes.planes[i].normal);
		t1 = v1/res;
		glTexCoord3fv(&t1.x);
		glVertex3fv(&v1.x);
	}
	glEnd();

	cutting_planes.disable();

	//DISABLE SHADER PROGRAM
	//if(volobj->is_greyscale)
	{
		vol_rgbsectionshaderobj.disable();	
	}
	/*else
	{
		vol_sectionshaderobj.disable();
	}*/

	//Turn blending back on
	//glEnable(GL_BLEND);

	//disable texture units
	glextensions.glActiveTexture(GL_TEXTURE0);
	glDisable(GL_TEXTURE_3D);
	glextensions.glActiveTexture(GL_TEXTURE1);
	glDisable(GL_TEXTURE_3D);
	glextensions.glActiveTexture(GL_TEXTURE2);
	glDisable(GL_TEXTURE_3D);
	glextensions.glActiveTexture(GL_TEXTURE3);
	glDisable(GL_TEXTURE_2D);
	glextensions.glActiveTexture(GL_TEXTURE4);
	glDisable(GL_TEXTURE_2D);
	glextensions.glActiveTexture(GL_TEXTURE5);
	glDisable(GL_TEXTURE_2D);

	//reset default to texture unit 0
	glextensions.glActiveTexture(GL_TEXTURE0);

	cutting_planes.disable();
}
void VolumeRender::render_3dTextureSlice1(void)
{
	//if we have no data return
	if(volobj->texture3d==NULL) return;

	Vector eye = Vector(0,0,-1);		
	eye = eye.mult_matrix((float*)&texrot_mat.m[0]);
	cutting_planes.viewsort(eye);
	int i;
	
	glPushMatrix();
	glEnable(GL_POLYGON_OFFSET_FILL);
	glPolygonOffset(1.0, 2.0f);
	for(int j=0; j<6; j++)
	{
		i = cutting_planes.viewsorted[j];

		if(plane_rendermode[i]==2)
		{
			glDisable(GL_BLEND);

			glColor3f(0,0,0);
			glBegin(GL_TRIANGLE_FAN);
			for(int j=0; j<cutting_planes.plane_clippoints[i].size(); j++)
			{
				v1 = cutting_planes.plane_clippoints[i][j];//-(0.1f*cutting_planes.planes[i].normal);
				glVertex3fv(&v1.x);
			}
			glEnd();
		}
	}
	glDisable(GL_POLYGON_OFFSET_LINE);		
	glPopMatrix();
}
void VolumeRender::render_3dTextureSlice(void)
{
	//if we have no data return
	if(volobj->texture3d==NULL) return;
	
	glPushMatrix();

	glEnable(GL_POLYGON_OFFSET_FILL);
	glPolygonOffset(1.0, 2.0f);

	//apply offset to centre texture matrix
	glMatrixMode(GL_TEXTURE);
	glTranslatef(0.5,0.5,0.5);

	//return to modelview mode
	glMatrixMode(GL_MODELVIEW);

	//cutting_planes.enable();
	Vector eye = Vector(0,0,-1);		
	eye = eye.mult_matrix((float*)&texrot_mat.m[0]);
	cutting_planes.viewsort(eye);

	//DRAW THE CLIPPING PLANES
	int i;
	for(int j=0; j<6; j++)
	{
		i = cutting_planes.viewsorted[j];
		
		if(plane_rendermode[i]==0)
		{
			//off
		}
		else if(plane_rendermode[i]==1)
		{
			//wireframe
			glColor3f(1,1,0);
			
			float scene_size = (float)LOD_FBO_SIZE;
			if(fbo_lod) scene_size = (float)LOD_FBO_SIZE/4.0f;
			float linesize = scene_size*(1.0/128.0);
			float pointsize = scene_size*(1.0/64.0);

			glLineWidth(linesize);
			glPointSize(pointsize);

			cutting_planes.display(i, GL_LINE_LOOP);
		}
		else if(plane_rendermode[i]==2)
		{
			glDisable(GL_BLEND);

			glColor3f(0,0,0);
			glBegin(GL_TRIANGLE_FAN);
			for(int j=0; j<cutting_planes.plane_clippoints[i].size(); j++)
			{
				v1 = cutting_planes.plane_clippoints[i][j]-(0.1f*cutting_planes.planes[i].normal);
				glVertex3fv(&v1.x);
			}
			glEnd();

			//glEnable(GL_BLEND);
			//blend_mode(bldmode);
			
			//glEnable(GL_ALPHA_TEST);

			if(volume_render_mode==4)
			{
				//texture solid
				if(volobj->is_greyscale) render_3dTextureSlicePlane_i_bricks(i, GL_TRIANGLE_FAN, 3, 0);
				else
				{
					if(r_channel) render_3dTextureSlicePlane_i_bricks(i, GL_TRIANGLE_FAN, 0, 0);
					if(g_channel) render_3dTextureSlicePlane_i_bricks(i, GL_TRIANGLE_FAN, 1, 1);
					if(b_channel) render_3dTextureSlicePlane_i_bricks(i, GL_TRIANGLE_FAN, 2, 2);
				}			
			}
			else
			{
				//texture solid
				if(volobj->is_greyscale) render_3dTextureSlicePlane_i(i, GL_TRIANGLE_FAN, 3, 0);
				else
				{
					if(r_channel) render_3dTextureSlicePlane_i(i, GL_TRIANGLE_FAN, 0, 0);
					if(g_channel) render_3dTextureSlicePlane_i(i, GL_TRIANGLE_FAN, 1, 1);
					if(b_channel) render_3dTextureSlicePlane_i(i, GL_TRIANGLE_FAN, 2, 2);
				}
			}

			//glDisable(GL_ALPHA_TEST);
			//glDisable(GL_BLEND);
		}
		else if(plane_rendermode[i]==3)
		{
			//texture alpha masked
			//glDisable(GL_ALPHA_TEST);
			//glDisable(GL_BLEND);
			glEnable(GL_BLEND);
			blend_mode(bldmode);

			if(volume_render_mode==4)
			{
				//texture solid
				if(volobj->is_greyscale) render_3dTextureSlicePlane_i_bricks(i, GL_TRIANGLE_FAN, 3, 0);
				else
				{
					if(r_channel) render_3dTextureSlicePlane_i_bricks(i, GL_TRIANGLE_FAN, 0, 0);
					if(g_channel) render_3dTextureSlicePlane_i_bricks(i, GL_TRIANGLE_FAN, 1, 1);
					if(b_channel) render_3dTextureSlicePlane_i_bricks(i, GL_TRIANGLE_FAN, 2, 2);
				}
			}
			else
			{

				//texture solid
				if(volobj->is_greyscale) render_3dTextureSlicePlane_i(i, GL_TRIANGLE_FAN, 3, 0);
				else
				{
					if(r_channel) render_3dTextureSlicePlane_i(i, GL_TRIANGLE_FAN, 0, 0);
					if(g_channel) render_3dTextureSlicePlane_i(i, GL_TRIANGLE_FAN, 1, 1);
					if(b_channel) render_3dTextureSlicePlane_i(i, GL_TRIANGLE_FAN, 2, 2);
				}
			}

			//render_3dTextureSlicePlane_i(i, GL_TRIANGLE_FAN);
			glDisable(GL_BLEND);
		}
	}
	
	glDisable(GL_POLYGON_OFFSET_LINE);		

	//cutting_planes.disable();
	glPopMatrix();
}

void VolumeRender::render_2dMultiTextureMultiPass(void)
{
	if(!texNames1) return;
	if(!texNames2) return;
	if(!texNames3) return;

	//Convert from euler angles to rotation matrix
 	glPushMatrix();

	//switch back to modelview matrix
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();

	//glTranslatef(tx, ty, -zoom);

	// Apply our arcball transformation matrix
	glMultMatrixf(arcball.Transform.M);

	//get the transformation matrix
	GLfloat m[4][4];
 	glGetFloatv(GL_MODELVIEW_MATRIX, &m[0][0]);

	//work out our view direction
	//ie: which stack we need to display
	a1 = (m[0][2]-m[0][3])/(m[3][2]-m[3][3]);
	a2 = (m[1][2]-m[1][3])/(m[3][2]-m[3][3]);
	a3 = (m[2][2]-m[2][3])/(m[3][2]-m[3][3]);

	glDisable(GL_LIGHTING);
	glEnable(GL_BLEND);
	glColor3f(1,1,1);

	vol2dmulti_shaderobj.enable();
	
	rebuild_texcoords();

	if ( (fabs(a1)>fabs(a2)) && (fabs(a1)>fabs(a3)) ) render_2dMultiTextureMultiPass_stack3(a1);
	else if ( (fabs(a2)>fabs(a1)) && (fabs(a2)>fabs(a3)) ) render_2dMultiTextureMultiPass_stack2(a2);
	else render_2dMultiTextureMultiPass_stack1(a3);

	glextensions.glActiveTexture(GL_TEXTURE0);

	glDisable(GL_LIGHTING);
	glDisable(GL_BLEND);

	glPopMatrix();
}
void VolumeRender::render_2dMultiTextureMultiPass_stack1(GLfloat dir)
{
	//printf("1\n");
  if (dir < 0)
  {
	double dZpos = -1.0;
	double dZstep = 2.0/double(numbslices);

	double dAlpha;
	double dTexPos;
	int texIndex;
	double dZpos2;

	for(int slices=0; slices<numbslices; ++slices)
	{
	    dTexPos = double(volobj->texdepth)*(dZpos+1.0)/2.0;
		texIndex = int(dTexPos);
		dAlpha = dTexPos/(double)volobj->texdepth;//-double(texIndex);
		dZpos2 = (dZpos/2.0)*volobj->texdepth;

		glextensions.glActiveTexture(GL_TEXTURE0);
		glBindTexture(GL_TEXTURE_2D,texNames1[texIndex]);
		glEnable(GL_TEXTURE_2D);
		glextensions.glActiveTexture(GL_TEXTURE1);
		glBindTexture(GL_TEXTURE_2D,texNames1[texIndex+1]);
		glEnable(GL_TEXTURE_2D);
		glextensions.glActiveTexture(GL_TEXTURE2);
		glBindTexture(GL_TEXTURE_2D, TEXTURE2D_RGB);
		glEnable(GL_TEXTURE_2D);
		glextensions.glActiveTexture(GL_TEXTURE3);
		glBindTexture(GL_TEXTURE_2D, TEXTURE2D_RAGABA);
		glEnable(GL_TEXTURE_2D);

		if(volobj->is_greyscale)
		{
			vol2dmulti_shaderobj.sendUniform1i("channel", 3);
			glBegin(GL_QUADS);
			glTexCoord3d(0.0, 0.0, dAlpha);
			glVertex3f(minX, minY, dZpos2);
			glTexCoord3d(0.0, 1.0, dAlpha);
			glVertex3f(minX, maxY, dZpos2);
			glTexCoord3d(1.0, 1.0, dAlpha);
			glVertex3f(maxX, maxY, dZpos2);
			glTexCoord3d(1.0, 0.0, dAlpha);
			glVertex3f(maxX, minY, dZpos2);
			glEnd();	 
		}
		else
		{
			if(r_channel)
			{
				if(redclip_toggle==0) cutting_planes.disable();
				else cutting_planes.enable();

				vol2dmulti_shaderobj.sendUniform1i("channel", 0);
				glBegin(GL_QUADS);
				glTexCoord3d(0.0, 0.0, dAlpha);
				glVertex3f(minX, minY, dZpos2);
				glTexCoord3d(0.0, 1.0, dAlpha);
				glVertex3f(minX, maxY, dZpos2);
				glTexCoord3d(1.0, 1.0, dAlpha);
				glVertex3f(maxX, maxY, dZpos2);
				glTexCoord3d(1.0, 0.0, dAlpha);
				glVertex3f(maxX, minY, dZpos2);
				glEnd();	 

			}
			if(g_channel)
			{
				if(greenclip_toggle==0) cutting_planes.disable();
				else cutting_planes.enable();

				vol2dmulti_shaderobj.sendUniform1i("channel", 1);
				glBegin(GL_QUADS);
				glTexCoord3d(0.0, 0.0, dAlpha);
				glVertex3f(minX, minY, dZpos2);
				glTexCoord3d(0.0, 1.0, dAlpha);
				glVertex3f(minX, maxY, dZpos2);
				glTexCoord3d(1.0, 1.0, dAlpha);
				glVertex3f(maxX, maxY, dZpos2);
				glTexCoord3d(1.0, 0.0, dAlpha);
				glVertex3f(maxX, minY, dZpos2);
				glEnd();	 

			}
			if(b_channel)
			{

				if(blueclip_toggle==0) cutting_planes.disable();
				else cutting_planes.enable();

				vol2dmulti_shaderobj.sendUniform1i("channel", 2);
				glBegin(GL_QUADS);
				glTexCoord3d(0.0, 0.0, dAlpha);
				glVertex3f(minX, minY, dZpos2);
				glTexCoord3d(0.0, 1.0, dAlpha);
				glVertex3f(minX, maxY, dZpos2);
				glTexCoord3d(1.0, 1.0, dAlpha);
				glVertex3f(maxX, maxY, dZpos2);
				glTexCoord3d(1.0, 0.0, dAlpha);
				glVertex3f(maxX, minY, dZpos2);
				glEnd();	 
			}
		}
		glextensions.glActiveTexture(GL_TEXTURE3);
		glDisable(GL_TEXTURE_2D);
		glextensions.glActiveTexture(GL_TEXTURE2);
		glDisable(GL_TEXTURE_2D);

		glextensions.glActiveTexture(GL_TEXTURE1);
		glDisable(GL_TEXTURE_2D);

		glextensions.glActiveTexture(GL_TEXTURE0);
		glDisable(GL_TEXTURE_2D);
	
		dZpos += dZstep;
	}
  }
  else
  {
//	int numbslices = volobj->texdepth;
	float dZpos = 1;
	float dZstep = 2.0/double(numbslices);

	float dAlpha;
	float dTexPos;
	int texIndex;
	float dZpos2;

	for(int slices=numbslices; slices>0; --slices)
	{
	    dTexPos = ((double)volobj->texdepth*(dZpos+1.0)/2.0);
		texIndex = int(dTexPos);
		dAlpha = ((double)volobj->texdepth-dTexPos)/(double)volobj->texdepth;//-double(texIndex);
		dZpos2 = (dZpos/2.0)*volobj->texdepth;

		glextensions.glActiveTexture(GL_TEXTURE0);
		glBindTexture(GL_TEXTURE_2D,texNames1[texIndex]);
		glEnable(GL_TEXTURE_2D);
		glextensions.glActiveTexture(GL_TEXTURE1);
		glBindTexture(GL_TEXTURE_2D,texNames1[texIndex-1]);
		glEnable(GL_TEXTURE_2D);
		glextensions.glActiveTexture(GL_TEXTURE2);
		glBindTexture(GL_TEXTURE_2D, TEXTURE2D_RGB);
		glEnable(GL_TEXTURE_2D);
		glextensions.glActiveTexture(GL_TEXTURE3);
		glBindTexture(GL_TEXTURE_2D, TEXTURE2D_RAGABA);
		glEnable(GL_TEXTURE_2D);

		if(volobj->is_greyscale)
		{
			vol2dmulti_shaderobj.sendUniform1i("channel", 3);
			glBegin(GL_QUADS);
			glTexCoord3d(0.0, 0.0, dAlpha);
			glVertex3f(minX, minY, dZpos2);

			glTexCoord3d(0.0, 1.0, dAlpha);
			glVertex3f(minX, maxY, dZpos2);

			glTexCoord3d(1.0, 1.0, dAlpha);
			glVertex3f(maxX, maxY, dZpos2);

			glTexCoord3d(1.0, 0.0, dAlpha);
			glVertex3f(maxX, minY, dZpos2);
			glEnd();	 
		}
		else
		{
			if(r_channel)
			{
				if(redclip_toggle==0) cutting_planes.disable();
				else cutting_planes.enable();

				vol2dmulti_shaderobj.sendUniform1i("channel", 0);
				glBegin(GL_QUADS);
				glTexCoord3d(0.0, 0.0, dAlpha);
				glVertex3f(minX, minY, dZpos2);
				glTexCoord3d(0.0, 1.0, dAlpha);
				glVertex3f(minX, maxY, dZpos2);
				glTexCoord3d(1.0, 1.0, dAlpha);
				glVertex3f(maxX, maxY, dZpos2);
				glTexCoord3d(1.0, 0.0, dAlpha);
				glVertex3f(maxX, minY, dZpos2);
				glEnd();	 

			}
			if(g_channel)
			{
				if(greenclip_toggle==0) cutting_planes.disable();
				else cutting_planes.enable();

				vol2dmulti_shaderobj.sendUniform1i("channel", 1);
				glBegin(GL_QUADS);
				glTexCoord3d(0.0, 0.0, dAlpha);
				glVertex3f(minX, minY, dZpos2);
				glTexCoord3d(0.0, 1.0, dAlpha);
				glVertex3f(minX, maxY, dZpos2);
				glTexCoord3d(1.0, 1.0, dAlpha);
				glVertex3f(maxX, maxY, dZpos2);
				glTexCoord3d(1.0, 0.0, dAlpha);
				glVertex3f(maxX, minY, dZpos2);
				glEnd();	 

			}
			if(b_channel)
			{

				if(blueclip_toggle==0) cutting_planes.disable();
				else cutting_planes.enable();

				vol2dmulti_shaderobj.sendUniform1i("channel", 2);
				glBegin(GL_QUADS);
				glTexCoord3d(0.0, 0.0, dAlpha);
				glVertex3f(minX, minY, dZpos2);
				glTexCoord3d(0.0, 1.0, dAlpha);
				glVertex3f(minX, maxY, dZpos2);
				glTexCoord3d(1.0, 1.0, dAlpha);
				glVertex3f(maxX, maxY, dZpos2);
				glTexCoord3d(1.0, 0.0, dAlpha);
				glVertex3f(maxX, minY, dZpos2);
				glEnd();	 
			}
		}
		glextensions.glActiveTexture(GL_TEXTURE3);
		glDisable(GL_TEXTURE_2D);
		glextensions.glActiveTexture(GL_TEXTURE2);
		glDisable(GL_TEXTURE_2D);
		glextensions.glActiveTexture(GL_TEXTURE1);
		glDisable(GL_TEXTURE_2D);
		glextensions.glActiveTexture(GL_TEXTURE0);
		glDisable(GL_TEXTURE_2D);
	
		dZpos -= dZstep;
	}
  }
}
void VolumeRender::render_2dMultiTextureMultiPass_stack2(GLfloat dir)
{
	//printf("2\n");
 if (dir < 0)
  {
//	int numbslices = volobj->texheight;
	float dYpos = -1;
	float dYstep = 2.0/double(numbslices);

	float dAlpha;
	float dTexPos;
	int texIndex;
	float dYpos2;

	for(int slices=0; slices<numbslices; ++slices)
	{
	    dTexPos = ((double)volobj->texheight*(dYpos+1.0)/2.0);
		texIndex = int(dTexPos);
		dAlpha = dTexPos/(double)volobj->texheight; //dTexPos-double(texIndex);
		dYpos2 = (dYpos/2.0)*volobj->texheight;

		glextensions.glActiveTexture(GL_TEXTURE0);
		glBindTexture(GL_TEXTURE_2D,texNames2[texIndex]);
		glEnable(GL_TEXTURE_2D);

		glextensions.glActiveTexture(GL_TEXTURE1);
		glBindTexture(GL_TEXTURE_2D,texNames2[texIndex-1]);
		glEnable(GL_TEXTURE_2D);

		glextensions.glActiveTexture(GL_TEXTURE2);
		glBindTexture(GL_TEXTURE_2D, TEXTURE2D_RGB);
		glEnable(GL_TEXTURE_2D);

		glextensions.glActiveTexture(GL_TEXTURE3);
		glBindTexture(GL_TEXTURE_2D, TEXTURE2D_RAGABA);
		glEnable(GL_TEXTURE_2D);

		if(volobj->is_greyscale)
		{
			vol2dmulti_shaderobj.sendUniform1i("channel", 3);

			glBegin(GL_QUADS);
			glTexCoord3d(0.0, 0.0, dAlpha);
			glVertex3f(minX,dYpos2, minZ);
			glTexCoord3d(0.0, 1.0, dAlpha);
			glVertex3f(minX, dYpos2,maxZ);
			glTexCoord3d(1.0, 1.0, dAlpha);
			glVertex3f(maxX, dYpos2,maxZ);
			glTexCoord3d(1.0, 0.0, dAlpha);
			glVertex3f(maxX, dYpos2,minZ);
			glEnd();	 
		}
		else
		{
			if(r_channel)
			{
				if(redclip_toggle==0) cutting_planes.disable();
				else cutting_planes.enable();

				vol2dmulti_shaderobj.sendUniform1i("channel", 0);
				glBegin(GL_QUADS);
				glTexCoord3d(0.0, 0.0, dAlpha);
				glVertex3f(minX,dYpos2, minZ);
				glTexCoord3d(0.0, 1.0, dAlpha);
				glVertex3f(minX, dYpos2,maxZ);
				glTexCoord3d(1.0, 1.0, dAlpha);
				glVertex3f(maxX, dYpos2,maxZ);
				glTexCoord3d(1.0, 0.0, dAlpha);
				glVertex3f(maxX, dYpos2,minZ);
				glEnd();	 

			}
			if(g_channel)
			{
				if(greenclip_toggle==0) cutting_planes.disable();
				else cutting_planes.enable();

				vol2dmulti_shaderobj.sendUniform1i("channel", 1);
				glBegin(GL_QUADS);
				glTexCoord3d(0.0, 0.0, dAlpha);
				glVertex3f(minX,dYpos2, minZ);
				glTexCoord3d(0.0, 1.0, dAlpha);
				glVertex3f(minX, dYpos2,maxZ);
				glTexCoord3d(1.0, 1.0, dAlpha);
				glVertex3f(maxX, dYpos2,maxZ);
				glTexCoord3d(1.0, 0.0, dAlpha);
				glVertex3f(maxX, dYpos2,minZ);
				glEnd();	 

			}
			if(b_channel)
			{

				if(blueclip_toggle==0) cutting_planes.disable();
				else cutting_planes.enable();

				vol2dmulti_shaderobj.sendUniform1i("channel", 2);
				glBegin(GL_QUADS);
				glTexCoord3d(0.0, 0.0, dAlpha);
				glVertex3f(minX,dYpos2, minZ);
				glTexCoord3d(0.0, 1.0, dAlpha);
				glVertex3f(minX, dYpos2,maxZ);
				glTexCoord3d(1.0, 1.0, dAlpha);
				glVertex3f(maxX, dYpos2,maxZ);
				glTexCoord3d(1.0, 0.0, dAlpha);
				glVertex3f(maxX, dYpos2,minZ);
				glEnd();	 
			}
		}
		glextensions.glActiveTexture(GL_TEXTURE3);
		glDisable(GL_TEXTURE_2D);
		glextensions.glActiveTexture(GL_TEXTURE2);
		glDisable(GL_TEXTURE_2D);
		glextensions.glActiveTexture(GL_TEXTURE1);
		glDisable(GL_TEXTURE_2D);
		glextensions.glActiveTexture(GL_TEXTURE0);
		glDisable(GL_TEXTURE_2D);
	
		dYpos += dYstep;
	}
  }
  else
  {
//	int numbslices = volobj->texheight;
	float dYpos = 1;
	float dYstep = 2.0/double(numbslices);

	float dAlpha;
	float dTexPos;
	int texIndex;
	float dYpos2;

	for(int slices=numbslices; slices>0; --slices)
	{
	    dTexPos = ((float)volobj->texheight*(dYpos+1.0)/2.0);
		texIndex = int(dTexPos);
		dAlpha = ((float)volobj->texheight-dTexPos)/(double)volobj->texheight; //dTexPos-double(texIndex);
		dYpos2 = (dYpos/2.0)*volobj->texheight;

		glextensions.glActiveTexture(GL_TEXTURE0);
		glBindTexture(GL_TEXTURE_2D,texNames2[texIndex]);
		glEnable(GL_TEXTURE_2D);

		glextensions.glActiveTexture(GL_TEXTURE1);
		glBindTexture(GL_TEXTURE_2D,texNames2[texIndex+1]);
		glEnable(GL_TEXTURE_2D);

		glextensions.glActiveTexture(GL_TEXTURE2);
		glBindTexture(GL_TEXTURE_2D, TEXTURE2D_RGB);
		glEnable(GL_TEXTURE_2D);

		glextensions.glActiveTexture(GL_TEXTURE3);
		glBindTexture(GL_TEXTURE_2D, TEXTURE2D_RAGABA);
		glEnable(GL_TEXTURE_2D);

		if(volobj->is_greyscale)
		{
			vol2dmulti_shaderobj.sendUniform1i("channel", 3);

			glBegin(GL_QUADS);
			glTexCoord3d(0.0, 0.0, dAlpha);
			glVertex3f(minX,dYpos2, minZ);
			glTexCoord3d(0.0, 1.0, dAlpha);
			glVertex3f(minX, dYpos2,maxZ);
			glTexCoord3d(1.0, 1.0, dAlpha);
			glVertex3f(maxX, dYpos2,maxZ);
			glTexCoord3d(1.0, 0.0, dAlpha);
			glVertex3f(maxX, dYpos2,minZ);
			glEnd();	 
		}
		else
		{
			if(r_channel)
			{
				if(redclip_toggle==0) cutting_planes.disable();
				else cutting_planes.enable();

				vol2dmulti_shaderobj.sendUniform1i("channel", 0);
				glBegin(GL_QUADS);
				glTexCoord3d(0.0, 0.0, dAlpha);
				glVertex3f(minX,dYpos2, minZ);
				glTexCoord3d(0.0, 1.0, dAlpha);
				glVertex3f(minX, dYpos2,maxZ);
				glTexCoord3d(1.0, 1.0, dAlpha);
				glVertex3f(maxX, dYpos2,maxZ);
				glTexCoord3d(1.0, 0.0, dAlpha);
				glVertex3f(maxX, dYpos2,minZ);
				glEnd();	 

			}
			if(g_channel)
			{
				if(greenclip_toggle==0) cutting_planes.disable();
				else cutting_planes.enable();

				vol2dmulti_shaderobj.sendUniform1i("channel", 1);
				glBegin(GL_QUADS);
				glTexCoord3d(0.0, 0.0, dAlpha);
				glVertex3f(minX,dYpos2, minZ);
				glTexCoord3d(0.0, 1.0, dAlpha);
				glVertex3f(minX, dYpos2,maxZ);
				glTexCoord3d(1.0, 1.0, dAlpha);
				glVertex3f(maxX, dYpos2,maxZ);
				glTexCoord3d(1.0, 0.0, dAlpha);
				glVertex3f(maxX, dYpos2,minZ);
				glEnd();	 

			}
			if(b_channel)
			{

				if(blueclip_toggle==0) cutting_planes.disable();
				else cutting_planes.enable();

				vol2dmulti_shaderobj.sendUniform1i("channel", 2);
				glBegin(GL_QUADS);
				glTexCoord3d(0.0, 0.0, dAlpha);
				glVertex3f(minX,dYpos2, minZ);
				glTexCoord3d(0.0, 1.0, dAlpha);
				glVertex3f(minX, dYpos2,maxZ);
				glTexCoord3d(1.0, 1.0, dAlpha);
				glVertex3f(maxX, dYpos2,maxZ);
				glTexCoord3d(1.0, 0.0, dAlpha);
				glVertex3f(maxX, dYpos2,minZ);
				glEnd();	 
			}
		}
		glextensions.glActiveTexture(GL_TEXTURE3);
		glDisable(GL_TEXTURE_2D);
		glextensions.glActiveTexture(GL_TEXTURE2);
		glDisable(GL_TEXTURE_2D);
		glextensions.glActiveTexture(GL_TEXTURE1);
		glDisable(GL_TEXTURE_2D);
		glextensions.glActiveTexture(GL_TEXTURE0);
		glDisable(GL_TEXTURE_2D);
	
		dYpos -= dYstep;
	}
  }
}
void VolumeRender::render_2dMultiTextureMultiPass_stack3(GLfloat dir)
{
	//printf("3\n");
	//printf("numbslices: %d\n", numbslices);
	if(dir>0)
	{

//		int numbslices = volobj->texwidth;
		float dXpos = 1;
		float dXstep = 2.0/double(numbslices);

		float dAlpha;
		float dTexPos;
		int texIndex;
		float dXpos2;

		for(int slices=numbslices; slices>0; --slices)
		{
			dTexPos = ((double)volobj->texwidth*(dXpos+1.0)/2.0);
			texIndex = int(dTexPos);
			dAlpha = ((double)volobj->texwidth-dTexPos)/(double)volobj->texwidth;//dTexPos-double(texIndex);
			dXpos2 = (dXpos/2.0)*volobj->texwidth;

			glextensions.glActiveTexture(GL_TEXTURE0);
			glBindTexture(GL_TEXTURE_2D,texNames3[texIndex]);
			glEnable(GL_TEXTURE_2D);

			glextensions.glActiveTexture(GL_TEXTURE1);
			glBindTexture(GL_TEXTURE_2D,texNames3[texIndex+1]);
			glEnable(GL_TEXTURE_2D);

			glextensions.glActiveTexture(GL_TEXTURE2);
			glBindTexture(GL_TEXTURE_2D, TEXTURE2D_RGB);
			glEnable(GL_TEXTURE_2D);

			glextensions.glActiveTexture(GL_TEXTURE3);
			glBindTexture(GL_TEXTURE_2D, TEXTURE2D_RAGABA);
			glEnable(GL_TEXTURE_2D);

			if(volobj->is_greyscale)
			{
				vol2dmulti_shaderobj.sendUniform1i("channel", 3);
				glBegin(GL_QUADS);
				glTexCoord3d(0.0, 0.0, dAlpha);
				glVertex3f(dXpos2,minY, minZ);
				glTexCoord3d(0.0, 1.0, dAlpha);
				glVertex3f(dXpos2,maxY, minZ);
				glTexCoord3d(1.0, 1.0, dAlpha);
				glVertex3f(dXpos2,maxY, maxZ);
				glTexCoord3d(1.0, 0.0, dAlpha);
				glVertex3f(dXpos2,minY, maxZ);
				glEnd();	 
			}
			else
			{
				if(r_channel)
				{
					if(redclip_toggle==0) cutting_planes.disable();
					else cutting_planes.enable();

					vol2dmulti_shaderobj.sendUniform1i("channel", 0);
					glBegin(GL_QUADS);
					glTexCoord3d(0.0, 0.0, dAlpha);
					glVertex3f(dXpos2,minY, minZ);
					glTexCoord3d(0.0, 1.0, dAlpha);
					glVertex3f(dXpos2,maxY, minZ);
					glTexCoord3d(1.0, 1.0, dAlpha);
					glVertex3f(dXpos2,maxY, maxZ);
					glTexCoord3d(1.0, 0.0, dAlpha);
					glVertex3f(dXpos2,minY, maxZ);
					glEnd();	 

				}
				if(g_channel)
				{
					if(greenclip_toggle==0) cutting_planes.disable();
					else cutting_planes.enable();

					vol2dmulti_shaderobj.sendUniform1i("channel", 1);
					glBegin(GL_QUADS);
					glTexCoord3d(0.0, 0.0, dAlpha);
					glVertex3f(dXpos2,minY, minZ);
					glTexCoord3d(0.0, 1.0, dAlpha);
					glVertex3f(dXpos2,maxY, minZ);
					glTexCoord3d(1.0, 1.0, dAlpha);
					glVertex3f(dXpos2,maxY, maxZ);
					glTexCoord3d(1.0, 0.0, dAlpha);
					glVertex3f(dXpos2,minY, maxZ);
					glEnd();	 
				}
				if(b_channel)
				{

					if(blueclip_toggle==0) cutting_planes.disable();
					else cutting_planes.enable();

					vol2dmulti_shaderobj.sendUniform1i("channel", 2);
					glBegin(GL_QUADS);
					glTexCoord3d(0.0, 0.0, dAlpha);
					glVertex3f(dXpos2,minY, minZ);
					glTexCoord3d(0.0, 1.0, dAlpha);
					glVertex3f(dXpos2,maxY, minZ);
					glTexCoord3d(1.0, 1.0, dAlpha);
					glVertex3f(dXpos2,maxY, maxZ);
					glTexCoord3d(1.0, 0.0, dAlpha);
					glVertex3f(dXpos2,minY, maxZ);
					glEnd();	 
				}
			}

		glextensions.glActiveTexture(GL_TEXTURE3);
		glDisable(GL_TEXTURE_2D);
		glextensions.glActiveTexture(GL_TEXTURE2);
		glDisable(GL_TEXTURE_2D);
			glextensions.glActiveTexture(GL_TEXTURE1);
			glDisable(GL_TEXTURE_2D);
			glextensions.glActiveTexture(GL_TEXTURE0);
			glDisable(GL_TEXTURE_2D);
		
			dXpos -= dXstep;
		}
	}
	else
	{
//		int numbslices = volobj->texwidth;
		float dXpos = -1;
		float dXstep = 2.0/double(numbslices);

		float dAlpha;
		float dTexPos;
		int texIndex;
		float dXpos2;

		for(int slices=0; slices<numbslices; ++slices)
		{
			dTexPos = ((float)volobj->texwidth*(dXpos+1.0)/2.0);
			texIndex = int(dTexPos);
			dAlpha = (dTexPos)/(double)volobj->texwidth;//dTexPos-double(texIndex);
			dXpos2 = (dXpos/2.0)*volobj->texwidth;

			glextensions.glActiveTexture(GL_TEXTURE0);
			glBindTexture(GL_TEXTURE_2D,texNames3[texIndex]);
			glEnable(GL_TEXTURE_2D);

			glextensions.glActiveTexture(GL_TEXTURE1);
			glBindTexture(GL_TEXTURE_2D,texNames3[texIndex-1]);
			glEnable(GL_TEXTURE_2D);

		glextensions.glActiveTexture(GL_TEXTURE2);
		glBindTexture(GL_TEXTURE_2D, TEXTURE2D_RGB);
		glEnable(GL_TEXTURE_2D);

		glextensions.glActiveTexture(GL_TEXTURE3);
		glBindTexture(GL_TEXTURE_2D, TEXTURE2D_RAGABA);
		glEnable(GL_TEXTURE_2D);

			if(volobj->is_greyscale)
			{
				vol2dmulti_shaderobj.sendUniform1i("channel", 3);
				glBegin(GL_QUADS);
				glTexCoord3d(0.0, 0.0, dAlpha);
				glVertex3f(dXpos2,minY, minZ);
				glTexCoord3d(0.0, 1.0, dAlpha);
				glVertex3f(dXpos2,maxY, minZ);
				glTexCoord3d(1.0, 1.0, dAlpha);
				glVertex3f(dXpos2,maxY, maxZ);
				glTexCoord3d(1.0, 0.0, dAlpha);
				glVertex3f(dXpos2,minY, maxZ);
				glEnd();	 
			}
			else
			{
				if(r_channel)
				{
					if(redclip_toggle==0) cutting_planes.disable();
					else cutting_planes.enable();

					vol2dmulti_shaderobj.sendUniform1i("channel", 0);
					glBegin(GL_QUADS);
					glTexCoord3d(0.0, 0.0, dAlpha);
					glVertex3f(dXpos2,minY, minZ);
					glTexCoord3d(0.0, 1.0, dAlpha);
					glVertex3f(dXpos2,maxY, minZ);
					glTexCoord3d(1.0, 1.0, dAlpha);
					glVertex3f(dXpos2,maxY, maxZ);
					glTexCoord3d(1.0, 0.0, dAlpha);
					glVertex3f(dXpos2,minY, maxZ);
					glEnd();	 

				}
				if(g_channel)
				{
					if(greenclip_toggle==0) cutting_planes.disable();
					else cutting_planes.enable();

					vol2dmulti_shaderobj.sendUniform1i("channel", 1);
					glBegin(GL_QUADS);
					glTexCoord3d(0.0, 0.0, dAlpha);
					glVertex3f(dXpos2,minY, minZ);
					glTexCoord3d(0.0, 1.0, dAlpha);
					glVertex3f(dXpos2,maxY, minZ);
					glTexCoord3d(1.0, 1.0, dAlpha);
					glVertex3f(dXpos2,maxY, maxZ);
					glTexCoord3d(1.0, 0.0, dAlpha);
					glVertex3f(dXpos2,minY, maxZ);
					glEnd();	 
				}
				if(b_channel)
				{

					if(blueclip_toggle==0) cutting_planes.disable();
					else cutting_planes.enable();

					vol2dmulti_shaderobj.sendUniform1i("channel", 2);
					glBegin(GL_QUADS);
					glTexCoord3d(0.0, 0.0, dAlpha);
					glVertex3f(dXpos2,minY, minZ);
					glTexCoord3d(0.0, 1.0, dAlpha);
					glVertex3f(dXpos2,maxY, minZ);
					glTexCoord3d(1.0, 1.0, dAlpha);
					glVertex3f(dXpos2,maxY, maxZ);
					glTexCoord3d(1.0, 0.0, dAlpha);
					glVertex3f(dXpos2,minY, maxZ);
					glEnd();	 
				}
			}

			glextensions.glActiveTexture(GL_TEXTURE3);
			glDisable(GL_TEXTURE_2D);
			glextensions.glActiveTexture(GL_TEXTURE2);
			glDisable(GL_TEXTURE_2D);
			glextensions.glActiveTexture(GL_TEXTURE1);
			glDisable(GL_TEXTURE_2D);
			glextensions.glActiveTexture(GL_TEXTURE0);
			glDisable(GL_TEXTURE_2D);
		
			dXpos += dXstep;
		}
	}
}
void VolumeRender::render_2dTexture(void)
{
	if(!texNames1) return;
	if(!texNames2) return;
	if(!texNames3) return;

	//Convert from euler angles to rotation matrix
 	glPushMatrix();

	glMultMatrixf(arcball.Transform.M);		

	//get the transformation matrix
	GLfloat m[4][4];
 	glGetFloatv(GL_MODELVIEW_MATRIX, &m[0][0]);

	//work out our view direction
	//ie: which stack we need to display
	a1 = (m[0][2]-m[0][3])/(m[3][2]-m[3][3]);
	a2 = (m[1][2]-m[1][3])/(m[3][2]-m[3][3]);
	a3 = (m[2][2]-m[2][3])/(m[3][2]-m[3][3]);

	glDisable(GL_LIGHTING);
	glEnable(GL_BLEND);
	glColor3f(1,1,1);

	vol2d_shaderobj.enable();

	rebuild_texcoords();

	if ( (fabs(a1)>fabs(a2)) && (fabs(a1)>fabs(a3)) ) render_2dTexture_stack3(a1);
	else if ( (fabs(a2)>fabs(a1)) && (fabs(a2)>fabs(a3)) ) render_2dTexture_stack2(a2);
	else render_2dTexture_stack1(a3);

	vol2d_shaderobj.disable();

	glDisable(GL_LIGHTING);
	glDisable(GL_BLEND);

	glPopMatrix();
}
void VolumeRender::render_2dTexture_stack1(GLfloat dir)
{
  if (dir < 0)
  {
	int numbslices = volobj->texdepth;
	float dZpos = -1;
	float dZstep = 2.0/double(numbslices);

	float dAlpha;
	float dTexPos;
	int texIndex;
	float dZpos2;

	for(int slices=0; slices<numbslices; ++slices)
	{
		dTexPos = ((volobj->texdepth)*(dZpos+1.0)/2.0);
		texIndex = int(dTexPos);
		dAlpha = dTexPos-double(texIndex);

		glextensions.glActiveTexture(GL_TEXTURE0);
		glBindTexture(GL_TEXTURE_2D,texNames1[texIndex]);
		glEnable(GL_TEXTURE_2D);
		glextensions.glActiveTexture(GL_TEXTURE2);
		glBindTexture(GL_TEXTURE_2D, TEXTURE2D_RGB);
		glEnable(GL_TEXTURE_2D);
		glextensions.glActiveTexture(GL_TEXTURE3);
		glBindTexture(GL_TEXTURE_2D, TEXTURE2D_RAGABA);
		glEnable(GL_TEXTURE_2D);

		dZpos2 = (dZpos/2.0)*volobj->texdepth;

		glBegin(GL_QUADS);
			glTexCoord3d(0.0, 0.0, dAlpha);
			glVertex3f(minX, minY, dZpos2);

			glTexCoord3d(0.0, 1.0, dAlpha);
			glVertex3f(minX, maxY, dZpos2);

			glTexCoord3d(1.0, 1.0, dAlpha);
			glVertex3f(maxX, maxY, dZpos2);

			glTexCoord3d(1.0, 0.0, dAlpha);
			glVertex3f(maxX, minY, dZpos2);
		glEnd();	 

		glextensions.glActiveTexture(GL_TEXTURE3);
		glDisable(GL_TEXTURE_2D);
		glextensions.glActiveTexture(GL_TEXTURE2);
		glDisable(GL_TEXTURE_2D);
		glextensions.glActiveTexture(GL_TEXTURE0);
		glDisable(GL_TEXTURE_2D);

		dZpos += dZstep;
	}
  }
  else
  {
	int numbslices = volobj->texdepth;
	float dZpos = 1;
	float dZstep = 2.0/double(numbslices);

	float dAlpha;
	float dTexPos;
	int texIndex;
	float dZpos2;

	for(int slices=numbslices; slices>0; --slices)
	{
		dTexPos = (volobj->texdepth*(dZpos+1.0)/2.0);
		texIndex = int(dTexPos);
		dAlpha = dTexPos-double(texIndex);

		glextensions.glActiveTexture(GL_TEXTURE0);
		glBindTexture(GL_TEXTURE_2D,texNames1[texIndex]);
		glEnable(GL_TEXTURE_2D);
		glextensions.glActiveTexture(GL_TEXTURE2);
		glBindTexture(GL_TEXTURE_2D, TEXTURE2D_RGB);
		glEnable(GL_TEXTURE_2D);
		glextensions.glActiveTexture(GL_TEXTURE3);
		glBindTexture(GL_TEXTURE_2D, TEXTURE2D_RAGABA);
		glEnable(GL_TEXTURE_2D);

		dZpos2 = (dZpos/2.0)*volobj->texdepth;

		glBegin(GL_QUADS);
			glTexCoord3d(0.0, 0.0, dAlpha);
			glVertex3f(minX, minY, dZpos2);

			glTexCoord3d(0.0, 1.0, dAlpha);
			glVertex3f(minX, maxY, dZpos2);

			glTexCoord3d(1.0, 1.0, dAlpha);
			glVertex3f(maxX, maxY, dZpos2);

			glTexCoord3d(1.0, 0.0, dAlpha);
			glVertex3f(maxX, minY, dZpos2);
		glEnd();	 

		glextensions.glActiveTexture(GL_TEXTURE3);
		glDisable(GL_TEXTURE_2D);
		glextensions.glActiveTexture(GL_TEXTURE2);
		glDisable(GL_TEXTURE_2D);
		glextensions.glActiveTexture(GL_TEXTURE0);
		glDisable(GL_TEXTURE_2D);

		dZpos -= dZstep;
	}
  }
}
void VolumeRender::render_2dTexture_stack2(GLfloat dir)
{
 if (dir < 0)
  {
	int numbslices = volobj->texheight;
	float dYpos = -1;
	float dYstep = 2.0/double(numbslices);

	float dAlpha;
	float dTexPos;
	int texIndex;
	float dYpos2;

	for(int slices=0; slices<numbslices; ++slices)
	{
		dTexPos = (volobj->texheight*(dYpos+1.0)/2.0);
		texIndex = int(dTexPos);
		dAlpha = dTexPos-double(texIndex);

		glextensions.glActiveTexture(GL_TEXTURE0);
		glBindTexture(GL_TEXTURE_2D,texNames2[texIndex]);
		glEnable(GL_TEXTURE_2D);
		glextensions.glActiveTexture(GL_TEXTURE2);
		glBindTexture(GL_TEXTURE_2D, TEXTURE2D_RGB);
		glEnable(GL_TEXTURE_2D);
		glextensions.glActiveTexture(GL_TEXTURE3);
		glBindTexture(GL_TEXTURE_2D, TEXTURE2D_RAGABA);
		glEnable(GL_TEXTURE_2D);

		dYpos2 = (dYpos/2.0)*volobj->texheight;
	
		glBegin(GL_QUADS);
			glTexCoord3d(0.0, 0.0, dAlpha);
			glVertex3f(minX,dYpos2, minZ);

			glTexCoord3d(0.0, 1.0, dAlpha);
			glVertex3f(minX, dYpos2,maxZ);

			glTexCoord3d(1.0, 1.0, dAlpha);
			glVertex3f(maxX, dYpos2,maxZ);

			glTexCoord3d(1.0, 0.0, dAlpha);
			glVertex3f(maxX, dYpos2,minZ);
		glEnd();	 

		glextensions.glActiveTexture(GL_TEXTURE3);
		glDisable(GL_TEXTURE_2D);
		glextensions.glActiveTexture(GL_TEXTURE2);
		glDisable(GL_TEXTURE_2D);
		glextensions.glActiveTexture(GL_TEXTURE0);
		glDisable(GL_TEXTURE_2D);

		dYpos += dYstep;
	}
  }
  else
  {
	int numbslices = volobj->texheight;
	float dYpos = 1;
	float dYstep = 2.0/double(numbslices);

	float dAlpha;
	float dTexPos;
	int texIndex;
	float dYpos2;

	for(int slices=numbslices; slices>0; --slices)
	{
		dTexPos = (volobj->texheight*(dYpos+1.0)/2.0);
		texIndex = int(dTexPos);
		dAlpha = dTexPos-double(texIndex);

		glextensions.glActiveTexture(GL_TEXTURE0);
		glBindTexture(GL_TEXTURE_2D,texNames2[texIndex]);
		glEnable(GL_TEXTURE_2D);
		glextensions.glActiveTexture(GL_TEXTURE2);
		glBindTexture(GL_TEXTURE_2D, TEXTURE2D_RGB);
		glEnable(GL_TEXTURE_2D);
		glextensions.glActiveTexture(GL_TEXTURE3);
		glBindTexture(GL_TEXTURE_2D, TEXTURE2D_RAGABA);
		glEnable(GL_TEXTURE_2D);

		dYpos2 = (dYpos/2.0)*volobj->texheight;

		glBegin(GL_QUADS);
			glTexCoord3d(0.0, 0.0, dAlpha);
			glVertex3f(minX,dYpos2, minZ);

			glTexCoord3d(0.0, 1.0, dAlpha);
			glVertex3f(minX, dYpos2,maxZ);

			glTexCoord3d(1.0, 1.0, dAlpha);
			glVertex3f(maxX, dYpos2,maxZ);

			glTexCoord3d(1.0, 0.0, dAlpha);
			glVertex3f(maxX, dYpos2,minZ);
		glEnd();	 

		glextensions.glActiveTexture(GL_TEXTURE3);
		glDisable(GL_TEXTURE_2D);
		glextensions.glActiveTexture(GL_TEXTURE2);
		glDisable(GL_TEXTURE_2D);
		glextensions.glActiveTexture(GL_TEXTURE0);
		glDisable(GL_TEXTURE_2D);

		dYpos -= dYstep;
	}
  }
}
void VolumeRender::render_2dTexture_stack3(GLfloat dir)
{
 	if(dir>0)
	{

		int numbslices = volobj->texwidth;
		float dXpos = 1;
		float dXstep = 2.0/double(numbslices);

		float dAlpha;
		float dTexPos;
		int texIndex;
		float dXpos2;

		for(int slices=numbslices; slices>0; --slices)
		{
			dTexPos = (volobj->texwidth*(dXpos+1.0)/2.0);
			texIndex = int(dTexPos);
			dAlpha = dTexPos-double(texIndex);

			glextensions.glActiveTexture(GL_TEXTURE0);
			glBindTexture(GL_TEXTURE_2D,texNames3[texIndex]);
			glEnable(GL_TEXTURE_2D);
			glextensions.glActiveTexture(GL_TEXTURE2);
			glBindTexture(GL_TEXTURE_2D, TEXTURE2D_RGB);
			glEnable(GL_TEXTURE_2D);
			glextensions.glActiveTexture(GL_TEXTURE3);
			glBindTexture(GL_TEXTURE_2D, TEXTURE2D_RAGABA);
			glEnable(GL_TEXTURE_2D);

			dXpos2 = (dXpos/2.0)*volobj->texwidth;

			glBegin(GL_QUADS);
				glTexCoord3d(0.0, 0.0, dAlpha);
				glVertex3f(dXpos2,minY, minZ);

				glTexCoord3d(0.0, 1.0, dAlpha);
				glVertex3f(dXpos2,maxY, minZ);

				glTexCoord3d(1.0, 1.0, dAlpha);
				glVertex3f(dXpos2,maxY, maxZ);

				glTexCoord3d(1.0, 0.0, dAlpha);
				glVertex3f(dXpos2,minY, maxZ);
			glEnd();	 

			glextensions.glActiveTexture(GL_TEXTURE3);
			glDisable(GL_TEXTURE_2D);
			glextensions.glActiveTexture(GL_TEXTURE2);
			glDisable(GL_TEXTURE_2D);
			glextensions.glActiveTexture(GL_TEXTURE0);
			glDisable(GL_TEXTURE_2D);

			dXpos -= dXstep;
		}
	}
	else
	{
		int numbslices = volobj->texwidth;
		float dXpos = -1;
		float dXstep = 2.0/double(numbslices);

		float dAlpha;
		float dTexPos;
		int texIndex;
		float dXpos2;

		for(int slices=0; slices<numbslices; ++slices)
		{
			dTexPos = (volobj->texwidth*(dXpos+1.0)/2.0);
			texIndex = int(dTexPos);
			dAlpha = dTexPos-double(texIndex);

			glextensions.glActiveTexture(GL_TEXTURE0);
			glBindTexture(GL_TEXTURE_2D,texNames3[texIndex]);
			glEnable(GL_TEXTURE_2D);
			glextensions.glActiveTexture(GL_TEXTURE2);
			glBindTexture(GL_TEXTURE_2D, TEXTURE2D_RGB);
			glEnable(GL_TEXTURE_2D);
			glextensions.glActiveTexture(GL_TEXTURE3);
			glBindTexture(GL_TEXTURE_2D, TEXTURE2D_RAGABA);
			glEnable(GL_TEXTURE_2D);

			dXpos2 = (dXpos/2.0)*volobj->texwidth;

			glBegin(GL_QUADS);
				glTexCoord3d(0.0, 0.0, dAlpha);
				glVertex3f(dXpos2,minY, minZ);

				glTexCoord3d(0.0, 1.0, dAlpha);
				glVertex3f(dXpos2,maxY, minZ);

				glTexCoord3d(1.0, 1.0, dAlpha);
				glVertex3f(dXpos2,maxY, maxZ);

				glTexCoord3d(1.0, 0.0, dAlpha);
				glVertex3f(dXpos2,minY, maxZ);
			glEnd();	 

			glextensions.glActiveTexture(GL_TEXTURE3);
			glDisable(GL_TEXTURE_2D);
			glextensions.glActiveTexture(GL_TEXTURE2);
			glDisable(GL_TEXTURE_2D);
			glextensions.glActiveTexture(GL_TEXTURE0);
			glDisable(GL_TEXTURE_2D);

			dXpos += dXstep;
		}
	}
}
//=================================================================================================================================
QImage VolumeRender::render_framebuffer( bool withAlpha ) // default is false
{
	QImage res;
	res = QImage( winWidth, winHeight, 32 );
	glReadPixels( 0, 0, winWidth, winHeight, GL_RGBA, GL_UNSIGNED_BYTE, res.bits() );

	if ( QImage::systemByteOrder() == QImage::BigEndian ) 
	{
		// OpenGL gives RGBA; Qt wants ARGB
		uint *p = (uint*)res.bits();
		uint *end = p + winWidth*winHeight;

		while ( p < end )
			*p++ >>= 8;
	}

	res = res.swapRGB();
	QSize size = QSize(volobj->maxres*2.0, volobj->maxres*2.0);
	res = res.scaled(size, Qt::KeepAspectRatio, Qt::SmoothTransformation);

	return res.mirror();
} 
//=================================================================================================================================
void VolumeRender::render_light(Vector lightpos, Vector lightdir)
{
	glPushMatrix();

	glDisable(GL_LIGHTING);
	
//		glMatrixMode(GL_MODELVIEW);
//		glLoadIdentity();
//		if(projection_toggle==0) gluLookAt(0, 0, zoom, 0, 0, 0, 0, 1, 0);	
//		printf("\nlightpos: %f, %f, %f\n", lightpos.x, lightpos.y, lightpos.z);
//		printf("lightdir: %f, %f, %f\n", 50.0*lightdir.x, 50.0*lightdir.y, 50.0*lightdir.z);

		glColor3f(1.0, 0.0, 0.0);
		glPointSize(5.0);
		glBegin(GL_POINTS);
			glVertex3f(lightpos.x, lightpos.y, lightpos.z);
		glEnd();
		glPointSize(1.0);

		glColor3f(1.0, 1.0, 0.0);
		glLineWidth(2.0);
		glBegin(GL_LINES);
			glVertex3f(lightpos.x, lightpos.y, lightpos.z);
			glVertex3f(lightpos.x+(100.0*lightdir.x), lightpos.y+(100.0*lightdir.y), lightpos.z+(100.0*lightdir.z));
		glEnd();
		glLineWidth(1.0);

		int i;
		int numSides=10;
		float angle = (PI*20.0)/180.0;
		float s = 100.0 * sinf(angle);
		float c = 100.0 * cosf(angle);

		Vector OriginalDir, NewDir, v;
		OriginalDir = Vector(0.0,0.0,1.0);
		NewDir = -lightdir;

	/*	int skip=0;

		Vector N;
		N.cross(OriginalDir, NewDir);
		float cosa = OriginalDir.dot(NewDir);

	//	if (cosa > 0.9999999f) // both vectors aligned
	//	return;

		if (cosa < -0.9999999f) // vectors are opposite
		{
		Vector M(0.0f, 1.0f, 1.0f);
		float fmax = max((float)fabs(OriginalDir.x), (float)0.0);

		if (fabs(OriginalDir.x) > fabs(OriginalDir.y))
		{
			fmax = fabs(OriginalDir.y);
			M = Vector(1.0f, 0.0f, 1.0f);
			}

			if (fabs(OriginalDir.z) > fmax)
			{
			M = Vector(1.0f, 1.0f, 0.0f);
			}

			N.cross(OriginalDir, M);
			N.normalize();
	//		glTranslatef(lightpos.x, lightpos.y, lightpos.z);
	//		glRotatef(180.0f, N.x, N.y, N.z); // rotate to opposite direction
	//		skip=1;
		}

	//	if(skip)
	//	{
			float sina = N.length();
			float a = (atan2f(sina, cosa)) / PI * 180.0f;
			N /= sina; // normalising the axis
			
			//if(skip) a +=180.0;

			glTranslatef(lightpos.x, lightpos.y, lightpos.z);
			glRotatef(a, N.x, N.y, N.z);
	//	}
*/
		/*//glEnable(GL_CULL_FACE);
		//glCullFace(GL_FRONT);
		glBegin(GL_TRIANGLE_FAN);				//GL_TRIANGLE_FAN
		glColor4f(1.0, 1.0, 0.5, 0.75);
		glVertex3f(0.0, 0.0, 0.0);
		glColor4f(1.0, 1.0, 1.0, 0.25);
		for (i = 0; i <= numSides; i++)
		{
			v = Vector(s * cos(2 * i * PI / numSides), s * sin(2 * i * PI / numSides), -c);
			glVertex3fv(&v.x);	
		}
		glEnd();
		//glCullFace(GL_BACK);
		glBegin(GL_TRIANGLE_FAN);
		glColor4f(1.0, 1.0, 0.5, 0.75);
		glVertex3f(0.0, 0.0, 0.0);
		glColor4f(1.0, 1.0, 1.0, 0.25);
		for (i = 0; i <= numSides; i++)
		{
			v = Vector(s * cos(2 * i * PI / numSides), s * sin(2 * i * PI / numSides), -c);
			glVertex3fv(&v.x);
		}
		glEnd();
		//glDisable(GL_CULL_FACE);*/

		glTranslatef(lightpos.x, lightpos.y, lightpos.z);

		glBegin(GL_LINE_LOOP);
		glColor4f(0.0, 0.0, 0.0, 1.0);
		for (i = 0; i <= numSides; i++)
		{
			v = Vector(s * cosf(2 * i * PI / numSides), s * sinf(2 * i * PI / numSides), -c);
			v.rotate3D(Vector(1,0,0),(3.14159265358979323846/180.0)*light_altitude);
			v.rotate3D(Vector(0,1,0),(3.14159265358979323846/180.0)*light_azimuth);
			glVertex3fv(&v.x);
		}
		glEnd();

		glBegin(GL_LINES);
		glColor4f(0.0, 0.0, 0.0, 1.0);
		for (i = 0; i <= numSides; i++)
		{
			v = Vector(s * cosf(2 * i * PI / numSides), s * sinf(2 * i * PI / numSides), -c);
			v.rotate3D(Vector(1,0,0),(3.14159265358979323846/180.0)*light_altitude);
			v.rotate3D(Vector(0,1,0),(3.14159265358979323846/180.0)*light_azimuth);			
			glVertex3f(0.0, 0.0, 0.0);
			glVertex3fv(&v.x);
		}
		glEnd();


	glEnable(GL_LIGHTING);

   glPopMatrix();

}
void VolumeRender::render_3DCursor(void)
{
	glDisable(GL_ALPHA_TEST);
	glDisable(GL_BLEND);
	glDisable(GL_LIGHTING);
	glLineWidth(2.0);

	float size = volobj->texdepth/50.0;

	glColor3f(1.0, 0.0, 0.0);
	glBegin(GL_LINES);
	glVertex3f(cursor3D_screenspace.x-size, cursor3D_screenspace.y,    cursor3D_screenspace.z);
	glVertex3f(cursor3D_screenspace.x+size, cursor3D_screenspace.y,    cursor3D_screenspace.z);
	glEnd();
	
	glColor3f(0.0, 1.0, 0.0);
	glBegin(GL_LINES);
	glVertex3f(cursor3D_screenspace.x,    cursor3D_screenspace.y-size, cursor3D_screenspace.z);
	glVertex3f(cursor3D_screenspace.x,    cursor3D_screenspace.y+size, cursor3D_screenspace.z);
	glEnd();

	glColor3f(0.0, 0.0, 1.0);
	glBegin(GL_LINES);
	glVertex3f(cursor3D_screenspace.x,    cursor3D_screenspace.y,    cursor3D_screenspace.z-size);
	glVertex3f(cursor3D_screenspace.x,    cursor3D_screenspace.y,    cursor3D_screenspace.z+size);
	glEnd();
	glLineWidth(1.0);
	glEnable(GL_LIGHTING);
	glEnable(GL_ALPHA_TEST);
	glEnable(GL_BLEND);

	render_slices(1);
}
void VolumeRender::render_scalebar(void)
{
	if(volobj->maxres==1) return;

	glPushMatrix();

/*	float origresX = volobj->width;
	float origresY = volobj->height;
	float origresZ = volobj->depth;

	printf("origres: %f, %f, %f\n",origresX, origresY, origresZ);
	*/
	
	float resX = volobj->texwidth;
	float resY = volobj->texheight;
	float resZ = volobj->texdepth;

//	printf("texres: %f, %f, %f\n\n",resX, resY, resZ);

	//float maxres = max((float)resX, (float)resY);
	//maxres = max((float)maxres, (float)resZ);

	/*float maxvolsize =  max((float)volobj->xsize, (float)volobj->ysize);
	maxvolsize =  max((float)maxvolsize, (float)volobj->zsize);

	float maxvolscale =  max((float)volobj->xscale, (float)volobj->yscale);
	maxvolscale =  max((float)maxvolscale, (float)volobj->zscale);*/

	//proportion autoscale helpers
	float minsize, maxsize, targetsize;
	minsize = 0.1;
	maxsize = 0.3;
	targetsize = 0.2;

	float offset = -volobj->maxres;
	float marginsize = volobj->maxres*0.05f;

	float scalefac = 10000.0/((volobj->xscale)/(volobj->xsize/volobj->maxsize));
	float mres0, mres1;

	if(resX>volobj->maxres*targetsize)
	{
		while(resX>volobj->maxres*targetsize)
		{
			resX = scalefac;
			scalefac /= 10.0;
		}
	}

	scalefac *= volobj->xscale;

	resY = resZ = volobj->maxres;
	mres0 = -volobj->maxres+((resX)*(volobj->maxres/((volobj->maxres)+zoom)))+(resX-((resX)*(volobj->maxres/((volobj->maxres)+zoom))));
	mres1 = -volobj->maxres+((resX*2.0)*(volobj->maxres/((volobj->maxres)+zoom))+(resX-((resX)*(volobj->maxres/((volobj->maxres)+zoom)))));

	float zoomfactor=1.0;
	if((mres1-mres0)>volobj->maxres*maxsize)
	{
		while((mres1-mres0)>volobj->maxres*maxsize)
		{
			resX /= 2.0;
			mres0 = -volobj->maxres+((resX)*(volobj->maxres/((volobj->maxres)+zoom)))+(resX-((resX)*(volobj->maxres/((volobj->maxres)+zoom))));
			mres1 = -volobj->maxres+((resX*2.0)*(volobj->maxres/((volobj->maxres)+zoom))+(resX-((resX)*(volobj->maxres/((volobj->maxres)+zoom)))));
		}
	}
	else if((mres1-mres0)<volobj->maxres*minsize)
	{
		while((mres1-mres0)<volobj->maxres*minsize)
		{
			resX *= 2.0;
			mres0 = -volobj->maxres+((resX)*(volobj->maxres/((volobj->maxres)+zoom)))+(resX-((resX)*(volobj->maxres/((volobj->maxres)+zoom))));
			mres1 = -volobj->maxres+((resX*2.0)*(volobj->maxres/((volobj->maxres)+zoom))+(resX-((resX)*(volobj->maxres/((volobj->maxres)+zoom)))));
		}
	}
	
	float length =  mres1-mres0;

	/*printf("maxres: %f\n",maxres);
	printf("maxsize: %f\n",maxsize);
	printf("volobj->xscale: %f\n",volobj->xscale);
	printf("volobj->xsize: %f\n",volobj->xsize);
	printf("length: %f\n",length);
	printf("resX: %f\n",resX);
	printf("(resX)/(volobj->xsize/maxsize): %f\n",(resX)/(volobj->xsize/maxsize));
	printf("maxvolsize: %f\n",maxvolsize);
	printf("maxvolscale: %f\n",maxvolscale);*/

	float scalebar_length = resX*(volobj->xscale)/(volobj->xsize/volobj->maxsize)*volobj->x_resize;

	//printf("scalebar_length: %f\n", scalebar_length);

	scalebarfontpos = Vector((float)winWidth*(marginsize/(volobj->maxres*2.0)), (float)winHeight*0.99f, resZ/2.0);
	scalebartext.setNum(scalebar_length);
	if(scalebar_length>999.0f)
	{
		scalebar_length /= 1000.0;
		scalebartext.setNum(scalebar_length);
		scalebartext += "m";
	}
	else
	{
		scalebartext += QString::fromStdWString (L" \u00B5");
	}
	scalebartext += "m";

	glColor3f(background_fontcolour.red()/255.0, background_fontcolour.blue()/255.0, background_fontcolour.green()/255.0);

	//printf("v1: %f, %f, %f\n", offset+marginsize,-resY+resY/10.0, resZ/2.0);
	//printf("v2: %f, %f, %f\n", offset+marginsize+length,-resY+resY/10.0, resZ/2.0);

	//printf("resize: %f, %f, %f\n", volobj->x_resize, volobj->y_resize, volobj->z_resize);
	
	//convert to hsv and if value is >0.5 black else white...
	glLineWidth(2.0);
	glBegin(GL_LINES);
	glVertex3f(offset+marginsize, -resY+resY/10.0, resZ/2.0);
	glVertex3f(offset+marginsize+length, -resY+resY/10.0, resZ/2.0);
	glEnd();
	glLineWidth(1.0);

	/*float i=0;
	float interp = ((length)/10.0);
	glLineWidth(1.0);

	glBegin(GL_LINES);
	for(i=marginsize; i<=marginsize+length; i+=interp)
	{
		glVertex3f(offset+i,-resY+resY/10.0,resZ/2.0);
		glVertex3f(offset+i,-resY+resY/10.0-3.5,resZ/2.0);
	}
	glVertex3f(offset+marginsize+length,-resY+resY/10.0,resZ/2.0);
	glVertex3f(offset+marginsize+length,-resY+resY/10.0-3.5,resZ/2.0);
	glEnd();*/
	
	glPopMatrix();
}
void VolumeRender::render_axis(void)
{
	glPushMatrix();
	glDisable(GL_LIGHTING);
	
	glTranslatef(winWidth/1.125, winHeight/1.125, 128.0);

	glMultMatrixf(arcball.Transform.M);		

	float size = winWidth/16.0;

	glLineWidth(2.0);
	glBegin(GL_LINES);

	glColor3f(1.0, 0.0, 0.0);
	glVertex3f(0.0, 0.0, 0.0);
	glVertex3f(size, 0.0, 0.0);

	glColor3f(0.0, 1.0, 0.0);
	glVertex3f(0.0, 0.0, 0.0);
	glVertex3f(0.0, size, 0.0);
	
	glColor3f(0.0, 0.0, 1.0);
	glVertex3f(0.0, 0.0, 0.0);
	glVertex3f(0.0, 0.0, size);

	glEnd();

	glEnable(GL_LIGHTING);
	glPopMatrix();
}
void VolumeRender::render_slices(GLenum draw_mode)
{		
	glDisable(GL_LIGHTING);
	glDisable(GL_ALPHA_TEST);
	glDisable(GL_BLEND);

	if(draw_mode==3)
	{
		glEnable(GL_ALPHA_TEST);
		glAlphaFunc(GL_GREATER,0.0f);
	}

	//----------------------------
	//OUR 3 Slice planes
	//----------------------------
	
	if(draw_mode==1)
	{
		//YZ (X SLICE)
		glColor4f(0.0, 0.0, 1.0, 1.0);
		glBegin(GL_LINE_LOOP);	
			glVertex3f(-volobj->maxres*(0.5-(x_slice/(float)volobj->texwidth)), -volobj->maxres/2.0, -volobj->maxres/2.0);
			glVertex3f(-volobj->maxres*(0.5-(x_slice/(float)volobj->texwidth)), volobj->maxres/2.0, -volobj->maxres/2.0);
			glVertex3f(-volobj->maxres*(0.5-(x_slice/(float)volobj->texwidth)), volobj->maxres/2.0, volobj->maxres/2.0);
			glVertex3f(-volobj->maxres*(0.5-(x_slice/(float)volobj->texwidth)), -volobj->maxres/2.0, volobj->maxres/2.0);
		glEnd();
	}
	if(draw_mode==2 || draw_mode==3) 
	{
		glColor3f(1.0, 1.0, 1.0);
		glEnable(GL_TEXTURE_2D);
		glBindTexture(GL_TEXTURE_2D, SLICEX);
		glBegin(GL_QUADS);	
			glTexCoord2d(0,0); glVertex3f(-volobj->maxres*(0.5-(x_slice/(float)volobj->texwidth)), -volobj->maxres/2.0, -volobj->maxres/2.0);
			glTexCoord2d(1,0); glVertex3f(-volobj->maxres*(0.5-(x_slice/(float)volobj->texwidth)), volobj->maxres/2.0, -volobj->maxres/2.0);
			glTexCoord2d(1,1); glVertex3f(-volobj->maxres*(0.5-(x_slice/(float)volobj->texwidth)), volobj->maxres/2.0, volobj->maxres/2.0);
			glTexCoord2d(0,1); glVertex3f(-volobj->maxres*(0.5-(x_slice/(float)volobj->texwidth)), -volobj->maxres/2.0, volobj->maxres/2.0);
		glEnd();
		glDisable(GL_TEXTURE_2D);
	}

	if(draw_mode==1)
	{
		//XZ (Y SLICE)
		glColor4f(1.0, 0.0, 0.0, 1.0);
		glBegin(GL_LINE_LOOP);	
			glVertex3f(-volobj->maxres/2.0, -volobj->maxres*(0.5-(y_slice/(float)volobj->texheight)), -volobj->maxres/2.0);
			glVertex3f(volobj->maxres/2.0, -volobj->maxres*(0.5-(y_slice/(float)volobj->texheight)), -volobj->maxres/2.0);
			glVertex3f(volobj->maxres/2.0, -volobj->maxres*(0.5-(y_slice/(float)volobj->texheight)), volobj->maxres/2.0);
			glVertex3f(-volobj->maxres/2.0, -volobj->maxres*(0.5-(y_slice/(float)volobj->texheight)), volobj->maxres/2.0);
		glEnd();
	}
	if(draw_mode==2 || draw_mode==3)
	{
		glColor3f(1.0, 1.0, 1.0);
		glEnable(GL_TEXTURE_2D);
		glBindTexture(GL_TEXTURE_2D, SLICEY);
		glBegin(GL_QUADS);	
			glTexCoord2d(0,0); glVertex3f(-volobj->maxres/2.0, -volobj->maxres*(0.5-(y_slice/(float)volobj->texheight)), -volobj->maxres/2.0);
			glTexCoord2d(1,0); glVertex3f(volobj->maxres/2.0, -volobj->maxres*(0.5-(y_slice/(float)volobj->texheight)), -volobj->maxres/2.0);
			glTexCoord2d(1,1); glVertex3f(volobj->maxres/2.0, -volobj->maxres*(0.5-(y_slice/(float)volobj->texheight)), volobj->maxres/2.0);
			glTexCoord2d(0,1); glVertex3f(-volobj->maxres/2.0, -volobj->maxres*(0.5-(y_slice/(float)volobj->texheight)), volobj->maxres/2.0);
		glEnd();
		glDisable(GL_TEXTURE_2D);
	}

	if(draw_mode==1)
	{
		//XY (Z SLICE)
		glColor4f(0.0, 1.0, 0.0, 1.0);
		glBegin(GL_LINE_LOOP);	
			glVertex3f(-volobj->maxres/2.0, -volobj->maxres/2.0, -volobj->maxres*(0.5-(z_slice/(float)volobj->texdepth)));
			glVertex3f(volobj->maxres/2.0, -volobj->maxres/2.0, -volobj->maxres*(0.5-(z_slice/(float)volobj->texdepth)));
			glVertex3f(volobj->maxres/2.0, volobj->maxres/2.0, -volobj->maxres*(0.5-(z_slice/(float)volobj->texdepth)));
			glVertex3f(-volobj->maxres/2.0, volobj->maxres/2.0, -volobj->maxres*(0.5-(z_slice/(float)volobj->texdepth)));
		glEnd();
	}
	if(draw_mode==2 || draw_mode==3) 
	{
		glColor3f(1.0, 1.0, 1.0);
		glEnable(GL_TEXTURE_2D);
		glBindTexture(GL_TEXTURE_2D, SLICEZ);
		glBegin(GL_QUADS);	
			glTexCoord2d(0,0); glVertex3f(-volobj->maxres/2.0, -volobj->maxres/2.0, -volobj->maxres*(0.5-(z_slice/(float)volobj->texdepth)));
			glTexCoord2d(1,0); glVertex3f(volobj->maxres/2.0, -volobj->maxres/2.0, -volobj->maxres*(0.5-(z_slice/(float)volobj->texdepth)));
			glTexCoord2d(1,1); glVertex3f(volobj->maxres/2.0, volobj->maxres/2.0, -volobj->maxres*(0.5-(z_slice/(float)volobj->texdepth)));
			glTexCoord2d(0,1); glVertex3f(-volobj->maxres/2.0, volobj->maxres/2.0, -volobj->maxres*(0.5-(z_slice/(float)volobj->texdepth)));
		glEnd();	
		glDisable(GL_TEXTURE_2D);
	}	

	if(draw_mode==3)
	{
		glDisable(GL_ALPHA_TEST);
	}
}
void VolumeRender::render_boundingbox(void)
{
	float scene_size = (float)LOD_FBO_SIZE;
	if(fbo_lod) scene_size = (float)LOD_FBO_SIZE/4.0f;
	float linesize = scene_size*(1.0/(volobj->maxres*0.5));
	float pointsize = scene_size*(1.0/volobj->maxres);

	Vector bb_scale = Vector(volobj->maxres,volobj->maxres,volobj->maxres);
	
	glDisable(GL_LIGHTING);
	glLineWidth(linesize);
	glPointSize(pointsize);
	glColor3ub(bb_colour.red(), bb_colour.green(), bb_colour.blue());

	glBegin(GL_LINE_LOOP);
		glVertex3fv(&bb_v2.x);
		glVertex3fv(&bb_v6.x);
		glVertex3fv(&bb_v8.x);
		glVertex3fv(&bb_v4.x);
	glEnd();
	glBegin(GL_LINE_LOOP);
		glVertex3fv(&bb_v3.x);
		glVertex3fv(&bb_v7.x);
		glVertex3fv(&bb_v5.x);
		glVertex3fv(&bb_v1.x);
	glEnd();
	glBegin(GL_LINE_LOOP);
		glVertex3fv(&bb_v5.x);
		glVertex3fv(&bb_v6.x);
		glVertex3fv(&bb_v2.x);
		glVertex3fv(&bb_v1.x);
	glEnd();
	glBegin(GL_LINE_LOOP);
		glVertex3fv(&bb_v4.x);
		glVertex3fv(&bb_v8.x);
		glVertex3fv(&bb_v7.x);
		glVertex3fv(&bb_v3.x);
	glEnd();
	glEnable(GL_LIGHTING);
}
void VolumeRender::render_stereo(int render)
{

/*    GLdouble leftfrustum;
    GLdouble rightfrustum;
    GLdouble bottomfrustum;
    GLdouble topfrustum;
    GLfloat modeltranslation;
	
	double DTR = 0.0174532925;
	double aspect = double(camera.width)/double(camera.height);  //screen aspect ratio
	double top = camera.znear*tan(DTR*camera.fov/2);                    //sets top of frustum based on fovy and near clipping plane
	double right = aspect*top;                             //sets right of frustum based on aspect ratio	
	double screenZ = 10.0;                                     //screen projection plane
	double IOD = 2.5;                                          //intraocular distance
	double frustumshift = (IOD/2)*camera.znear/screenZ;

	for(int i=0; i<2; i++)
	{
		if(i==0)
		{
			topfrustum = top;
			bottomfrustum = -top;
			leftfrustum = -right + frustumshift;
			rightfrustum = right + frustumshift;
			modeltranslation = IOD/2;
			
			glDrawBuffer(GL_BACK_LEFT);                              //draw into back left buffer
		}
		else
		{

			topfrustum = top;
			bottomfrustum = -top;
			leftfrustum = -right - frustumshift;
			rightfrustum = right - frustumshift;
			modeltranslation = -IOD/2;
			
			glDrawBuffer(GL_BACK_RIGHT);                              //draw into back left buffer
		}

		glClearColor( background_colour.red()/255.0, background_colour.green()/255.0, background_colour.blue()/255.0, 1.0f );
		glClear(GL_DEPTH_BUFFER_BIT);			

		glMatrixMode(GL_PROJECTION);
		glLoadIdentity();                                        //reset projection matrix

		glFrustum(leftfrustum, rightfrustum,     //set left view frustum
				bottomfrustum, topfrustum,
				camera.znear, camera.zfar);

		glTranslatef(modeltranslation, 0.0, 0.0);        //translate to cancel parallax
		
		glMatrixMode(GL_MODELVIEW);
		glLoadIdentity();
	
		render_scene();
	
	}

*/   
	//glextensions.fbo_support=0;

	if(!volobj->texture3d) return;

   //stereo_eye_seperation = 0.5;
   float PIXELS_PER_INCH = 60;

    double xfactor=1.0, yfactor=1.0;

	if(camera.width < camera.height)
	{
		xfactor = 1.0;
		yfactor = camera.height/camera.width;
	}
	else if(camera.height < camera.width)
	{
		xfactor = camera.width/camera.height;
		yfactor = 1.0;
	}

	glDrawBuffer(GL_BACK);                                   //draw into both back buffers

	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);      //clear color and depth buffers
 	
	for(int i=0;i<2;i++)
	{

			if(stereo_mode==0) 
			{
				glClearColor( background_colour.red()/255.0, background_colour.green()/255.0, background_colour.blue()/255.0, 1.0f );
			}

			glClear(GL_DEPTH_BUFFER_BIT);

			if(i==0) // left eye - RED 
			{
				stereo_eye_seperation = stereo_eye_seperation;
				
				if(stereo_mode==0) glDrawBuffer(GL_BACK_LEFT);                             //draw into back left buffer
				else glColorMask(GL_TRUE,GL_FALSE,GL_FALSE,GL_TRUE);
			}
			else	// right eye - BLUE  <--Change to GREEN for green lenses  
			{
				stereo_eye_seperation = -stereo_eye_seperation;
				
				if(stereo_mode==0) glDrawBuffer(GL_BACK_RIGHT);                             //draw into back right buffer
				else if(stereo_mode==1) glColorMask(GL_FALSE,GL_FALSE,GL_TRUE,GL_TRUE);
				else if(stereo_mode==2) glColorMask(GL_FALSE,GL_TRUE,GL_FALSE,GL_TRUE);
				else if(stereo_mode==3) glColorMask(GL_FALSE,GL_TRUE,GL_TRUE,GL_TRUE);
			}
				
			glMatrixMode(GL_PROJECTION);
			glLoadIdentity();
			glFrustum(
				(-(camera.width/(2.0*PIXELS_PER_INCH))+stereo_eye_seperation)*(camera.znear/camera.zscreen)*xfactor,
				(camera.width/(2.0*PIXELS_PER_INCH)+stereo_eye_seperation)*(camera.znear/camera.zscreen)*xfactor,
				-(camera.width/(2.0*PIXELS_PER_INCH))*(camera.znear/camera.zscreen)*yfactor,
				(camera.width/(2.0*PIXELS_PER_INCH))*(camera.znear/camera.zscreen)*yfactor,
				camera.znear, 
				camera.zfar);

			//glOrtho(-volobj->maxres-zoom, volobj->maxres+zoom, -volobj->maxres-zoom, volobj->maxres+zoom, -1024, 1024);

			glTranslatef(stereo_eye_seperation,0.0, 0.0);
			
			glMatrixMode(GL_TEXTURE);
			glLoadIdentity();
			
			glMatrixMode(GL_MODELVIEW);
			glLoadIdentity();
		
			cutting_planes.disable();
			render_scene(render);

	}

	if(stereo_mode!=0) glColorMask(GL_TRUE,GL_TRUE,GL_TRUE,GL_TRUE);
	
	stereo_eye_seperation = -stereo_eye_seperation;

 //  glextensions.fbo_support=1;

}
void VolumeRender::render_meshes(void)
{
	glPushMatrix();
	glEnable(GL_LIGHTING);
	
	if(glextensions.shader_support) mesh_shaderobj.enable();

	for(int i=0; i<meshlist.meshes.size(); i++)
	{
		if(!meshlist.clipstate.empty()) if(meshlist.clipstate[i]) cutting_planes.enable();

		//glColor3fv(&meshlist.colours[i].x);
		if(!meshlist.colours.empty()) if(glextensions.shader_support) mesh_shaderobj.sendUniform3fv("surfcol",1, &meshlist.colours[i].x);
		meshlist.meshes[i].r_vbo(GL_TRIANGLES);
		//meshlist.meshes[i].r_normal(GL_TRIANGLES, 0);

		if(!meshlist.clipstate.empty()) if(meshlist.clipstate[i]) cutting_planes.disable();

		//meshlist.meshes[i].r_normal(GL_TRIANGLES, 0);
		
		//glColor3f(1,1,0);
		//meshlist.meshes[i].display_normals();
	}

	if(glextensions.shader_support) mesh_shaderobj.disable();
	
	glDisable(GL_LIGHTING);
	glPopMatrix();
}
void VolumeRender::render_FPS(void)
{
	// FPS computation
	if (++fpsCounter_ == 5)
	{
	  f_p_s_ = (1000.0 * 5.0 / fpsTime_.restart());
	  fpsString_ = QString("%1fps").arg(f_p_s_, 0, 'f', ((f_p_s_ < 10.0)?1:0));
	  fpsCounter_ = 0;
	}
}
void VolumeRender::render_aabb(Vector cen, Vector dim)
{
	Vector bb[8];
	bb[0] = Vector(-1.0,  1.0,  1.0);
	bb[1] = Vector( 1.0,  1.0,  1.0);
	bb[2] = Vector(-1.0, -1.0,  1.0);
	bb[3] = Vector( 1.0, -1.0,  1.0);
	bb[4] = Vector(-1.0,  1.0, -1.0);
	bb[5] = Vector( 1.0,  1.0, -1.0);
	bb[6] = Vector(-1.0, -1.0, -1.0);
	bb[7] = Vector( 1.0, -1.0, -1.0);

	//scale it by size
	dim /= 2.0;
	bb[0] = bb[0]*dim; bb[1] = bb[1]*dim; bb[2] = bb[2]*dim; bb[3] = bb[3]*dim;
	bb[4] = bb[4]*dim; bb[5] = bb[5]*dim; bb[6] = bb[6]*dim; bb[7] = bb[7]*dim;

	bb[0] += cen;
	bb[1] += cen;
	bb[2] += cen;
	bb[3] += cen;
	bb[4] += cen;
	bb[5] += cen;
	bb[6] += cen;
	bb[7] += cen;

	glPushMatrix();
	glDisable(GL_LIGHTING);

//	glScalef(scale, scale, scale);
//	glTranslatef(-centre.x, -centre.y, -centre.z);
/*
	PlaneWidget p1(v1,v2,v4,v3,1);
	PlaneWidget p2(v7,v8,v6,v5,2);
	PlaneWidget p3(v2,v6,v8,v4,3);
	PlaneWidget p4(v3,v7,v5,v1,4);
	PlaneWidget p5(v5,v6,v2,v1,5);
	PlaneWidget p6(v4,v8,v7,v3,6);
*/
//FRONT
	glBegin(GL_LINE_LOOP);
		glVertex3fv(&bb[0].x);
		glVertex3fv(&bb[1].x);
		glVertex3fv(&bb[3].x);
		glVertex3fv(&bb[2].x);
	glEnd();

	//LEFT
	glBegin(GL_LINE_LOOP);
		glVertex3fv(&bb[6].x);
		glVertex3fv(&bb[7].x);
		glVertex3fv(&bb[5].x);
		glVertex3fv(&bb[4].x);
	glEnd();

	//BACK
	glBegin(GL_LINE_LOOP);
		glVertex3fv(&bb[1].x);
		glVertex3fv(&bb[5].x);
		glVertex3fv(&bb[7].x);
		glVertex3fv(&bb[3].x);
	glEnd();

	//RIGHT
	glBegin(GL_LINE_LOOP);
		glVertex3fv(&bb[2].x);
		glVertex3fv(&bb[6].x);
		glVertex3fv(&bb[4].x);
		glVertex3fv(&bb[0].x);
	glEnd();

	//TOP
	glBegin(GL_LINE_LOOP);
		glVertex3fv(&bb[4].x);
		glVertex3fv(&bb[5].x);
		glVertex3fv(&bb[1].x);
		glVertex3fv(&bb[0].x);
	glEnd();

	//BOTTOM
	glBegin(GL_LINE_LOOP);
		glVertex3fv(&bb[3].x);
		glVertex3fv(&bb[7].x);
		glVertex3fv(&bb[6].x);
		glVertex3fv(&bb[2].x);
	glEnd();

	glEnable(GL_LIGHTING);
	glPopMatrix();
}
void VolumeRender::render_sphere(Vector c, float r,int n, GLenum drawmode)
{
	glEnable(GL_CULL_FACE);
	glCullFace(GL_FRONT);
	double i,j;
	double theta1,theta2,theta3;
	Vector rr = Vector(1.0, 1.0, 1.0);
	Vector e,p, p1;

	//glBegin(drawmode);
	for (j=0;j<n;j++) 
	{
		theta1 = j * TWOPI / n - (PI/2.0);
		theta2 = (j + 1) * TWOPI / n - (PI/2.0);

		glBegin(drawmode);
		//glBegin(GL_QUADS);
		//glBegin(GL_POINTS);
		for (i=0;i<=n;i++) 
		{
			theta3 = i * TWOPI / n;

			e.x = cos(theta2) * cos(theta3);
			e.y = sin(theta2);
			e.z = cos(theta2) * sin(theta3);

			//generate point on unit sphere
			p = r*e;
			
			//transform it to our ellipsoid space
			//p1 = rot*p;

			//apply the centre translation
			p = c + p;

			glNormal3f(e.x,e.y,e.z);
			//glTexCoord2f(i/(double)n,2*(j+1)/(double)n);
			glVertex3fv(&p.x);

			e.x = cos(theta1) * cos(theta3);
			e.y = sin(theta1);
			e.z = cos(theta1) * sin(theta3);

			//generate point on unit sphere
			p = r*e;

			//transform it to our ellipsoid
//			p1 = rot*p;

			//apply the centre translation
			p = c + p;

			glNormal3f(e.x,e.y,e.z);
			//glTexCoord2f(i/(double)n,2*j/(double)n);
			glVertex3fv(&p.x);		
		}
		glEnd();
	}
	//glEnd();
	glDisable(GL_CULL_FACE);
}
void VolumeRender::render_measurements(void)
{
	Vector v;
	Vector v2;
	float offset = 0.2f;

	glPushMatrix();
	glDisable(GL_LIGHTING);

	//glEnable(GL_POLYGON_OFFSET_FILL);
	//glPolygonOffset(2.0, 0.001f);

	//glEnable(GL_LINE_STIPPLE);
	//glLineStipple(1, 0x00FF);

	float screenzoom = (float)(volobj->maxres+zoom)/(float)volobj->maxres;
	float linesize;// = ((float)maxres/100.0)/screenzoom;
	float pointsize = ((float)volobj->maxres/100.0)/screenzoom;

	Vector bb_size = Vector(volobj->texwidth*volobj->xsize/volobj->maxsize, volobj->texheight*volobj->ysize/volobj->maxsize, volobj->texdepth*volobj->zsize/volobj->maxsize);
	bb_size /= 2.0;

	float maxl = bb_size.x;
	maxl = max (maxl, bb_size.y);
	maxl = max (maxl, bb_size.z);
	
	pointsize = (float)((2*maxl)/20.0)*screenzoom;
	//linesize = (float)((2*maxl)/20.0)*screenzoom;

	if(pointsize>1.0) pointsize = 1.0;
	if(pointsize<0.25) pointsize = 0.25;
	linesize = pointsize*2.0;
	//if(linesize>2.0) linesize = 2.0;
	//if(linesize<1.0) linesize = 1.0;

	//printf("screenzoom: %f\n", screenzoom);
	//printf("pointsize: %f\n", pointsize);
	//printf("pointsize: %f\n", pointsize);


	//=================================================================================================
	//CROP SHAPE
	//=================================================================================================
	glLineWidth(linesize);

	glEnable(GL_LIGHTING);
	for(int iii=0; iii<crop_shape.size(); iii++)
	{	
			glColor4f(1,1,0,1);
			render_sphere(crop_shape[iii], pointsize*2.0, 12, GL_QUAD_STRIP);

			if(crop_shape_selected==iii)
			{
				glColor3f(1,1,0);
				render_aabb(crop_shape[iii], Vector(pointsize*4.0));
			}
	}
	glDisable(GL_LIGHTING);

	if(crop_shape.size()>2)
	{

	/*if(crop_inv==true) glColor4f(1,0,0,0.5);
	else glColor4f(0,1,0,0.5);

	glLineWidth(linesize/4.0);
	glBegin(GL_TRIANGLES);
	for(int iii=0; iii<crop_triangles.size()/3; iii++)
	{
		int index0 = crop_triangles[3*iii].w;
		int index1 = crop_triangles[3*iii+1].w;
		int index2 = crop_triangles[3*iii+2].w;

		//glColor4f(0,1,0,1);
		glVertex3fv(&crop_shape[index0].x);
		glVertex3fv(&crop_shape[index1].x);

		//glVertex3fv(&crop_shape[index1].x);
		glVertex3fv(&crop_shape[index2].x);

		//glVertex3fv(&crop_shape[index2].x);
		//glVertex3fv(&crop_shape[index0].x);
	}
	glEnd();
*/
	glLineWidth(linesize);
	glBegin(GL_LINES);
	for(int iii=1; iii<crop_shape.size(); iii++)
	{
		glColor4f(1,0,0,1);
		glVertex3fv(&crop_shape[iii].x);
		glVertex3fv(&crop_shape[iii-1].x);

	//	Vector t = 0.5f*(crop_shape[iii]+crop_shape[iii-1]);
	//	Vector n = t+8.0f*crop_normals[iii-1];

	//	glColor4f(0,1,0,1);
	//	glVertex3fv(&t.x);
	//	glVertex3fv(&n.x);	
	}
	if(crop_shape.size()>1)
	{
		glColor4f(1,0,0,1);
		glVertex3fv(&crop_shape[0].x);
		glVertex3fv(&crop_shape[crop_shape.size()-1].x);

	//	Vector t = 0.5f*(crop_shape[0]+crop_shape[crop_shape.size()-1]);
	//	Vector n = t+8.0f*crop_normals[crop_shape.size()-1];

	//	glColor4f(0,1,0,1);
	//	glVertex3fv(&t.x);
	//	glVertex3fv(&n.x);	
	}
	glEnd();

	}

	//=================================================================================================
	// SELECTED / ACTIVE
	glColor4f(background_fontcolour.red()/255.0, background_fontcolour.blue()/255.0, background_fontcolour.green()/255.0,1.0);

	for(int i=0; i<current_edges.size(); i++)
	{
		if(measure_magnetline_edge==i)
		{
			glLineWidth(linesize);
			glColor4f(1,1,0,1);
		}
		else
		{
			glLineWidth(linesize);
			glColor4f(1,0,0,1);
		}

		glBegin(GL_LINES);
		glVertex3fv(&current_measure_points[current_edges[i].v0].x);
		glVertex3fv(&current_measure_points[current_edges[i].v1].x);
		glEnd();
	}


	//glColor3f(0,1,0);
	//render_sphere(current_measure_centre, pointsize, 12, GL_QUAD_STRIP);

	glEnable(GL_LIGHTING);
	for(int iii=0; iii<current_measure_points.size(); iii++)
	{	
		if(iii!=current_measure_vertindex)
		{
			v = current_measure_points[iii]-(offset*current_normals[iii]);
			glColor4f(1,1,0,1);
			render_sphere(v, pointsize, 12, GL_QUAD_STRIP);
			//render_aabb(v, pointsize);
		}
		else
		{
			v = current_measure_points[iii]-(offset*current_normals[iii]);
			//glColor3fv(&measure_current_point_colour.x);
			glColor3f(1,0,0);
			render_sphere(v, pointsize, 12, GL_QUAD_STRIP);
			//render_aabb(v, pointsize);

			glLineWidth(linesize);
			glColor3f(1,1,0);
			render_aabb(v, Vector(pointsize*3));
		}
	}
	glDisable(GL_LIGHTING);

	if(current_measure_drawmode==6)
	{
		if(measure_magnetline_vert>=0 && measure_magnetline_vert<current_measure_points.size())
		{
			v = current_measure_points[measure_magnetline_vert]-(offset*current_normals[measure_magnetline_vert]);
			
			glLineWidth(linesize);
			glColor3f(1,1,0);
			render_aabb(v, Vector(pointsize*3));
		}
		if(measure_magnetline_vert_old>=0 && measure_magnetline_vert_old<current_measure_points.size())
		{
			v = current_measure_points[measure_magnetline_vert_old]-(offset*current_normals[measure_magnetline_vert_old]);
			
			glLineWidth(linesize);
			glColor3f(1,1,0);
			render_aabb(v, Vector(pointsize*3));
		}
	}
	/*
	glPointSize(pointsize*bg_oversize);
	glBegin(GL_POINTS);
	for(int iii=0; iii<current_measure_points.size(); iii++)
	{
		v = current_measure_points[iii]-(offset*current_normals[iii]);
		glVertex3fv(&v.x);
	}
	glEnd();*/
/*
	if(current_measure_vertindex>=0 && current_measure_vertindex<current_measure_points.size())
	{
		v = current_measure_points[current_measure_vertindex]-(offset*current_normals[current_measure_vertindex]);

		//glPointSize(pointsize);
		glLineWidth(linesize*0.5);
		glColor4f(0.0,1.0,0,1.0);
		glBegin(GL_LINES);
			glVertex3f(v.x+0.5*cursorsize, v.y, v.z);
			glVertex3f(v.x-0.5*cursorsize, v.y, v.z);
			glVertex3f(v.x, v.y+0.5*cursorsize, v.z);
			glVertex3f(v.x, v.y-0.5*cursorsize, v.z);
			glVertex3f(v.x, v.y, v.z+0.5*cursorsize);
			glVertex3f(v.x, v.y, v.z-0.5*cursorsize);
		glEnd();
	}
*/

	//=================================================================================================
	// NOT SELECTED / NOT ACTIVE
	glPointSize(pointsize);
	glLineWidth(linesize);
	glColor3f(1,1,0);
	for(int i=0; i<measure_objects.size(); i++)
	{
		if(i!=current_measure_index && measure_objects_visible[i]==true)
		{
			glBegin(GL_LINES);
			for(int j=0; j<measure_edges[i].size(); j++)
			{
				glVertex3fv(&measure_objects[i][measure_edges[i][j].v0].x);
				glVertex3fv(&measure_objects[i][measure_edges[i][j].v1].x);
			}
			glEnd();

			//glBegin(GL_POINTS);
			glEnable(GL_LIGHTING);
			for(int j=0; j<measure_objects[i].size(); j++)
			{
				v = measure_objects[i][j]-(offset*measure_normals[i][j]);
				render_sphere(v, pointsize, 12, GL_QUAD_STRIP);
			}
			glDisable(GL_LIGHTING);
			//glEnd();
		}
	}

/*	//if(current_measure_drawmode!=-1)
	{
		//render polygon triangles
		glLineWidth(linesize);
		if(current_measure_drawmode==4 && !current_measure_points.empty() && !current_triangles.empty())
		{
			glColor4f(1.0,1.0,0.0,1.0);
			int numbtris = current_triangles.size()/3;
			for(int i=0; i<numbtris; i++)
			{
				glBegin(GL_LINE_LOOP);
					v = current_measure_points[(int)current_triangles[3*i+0]]-(offset*current_normals[(int)current_triangles[3*i+0]]);
					glVertex3fv(&v.x);
					v = current_measure_points[(int)current_triangles[3*i+1]]-(offset*current_normals[(int)current_triangles[3*i+1]]);
					glVertex3fv(&v.x);
					v = current_measure_points[(int)current_triangles[3*i+2]]-(offset*current_normals[(int)current_triangles[3*i+2]]);
					glVertex3fv(&v.x);
				glEnd();
			}
		}

		//render sphere objects
		if(current_measure_drawmode==5 && current_measure_points.size()==2)
		{
			Vector sp_cen = (current_measure_points[0]+current_measure_points[1])*0.5f-(offset*current_normals[0]);
			Vector sp_rad = current_measure_points[0]-current_measure_points[1];
			render_sphere(sp_cen, Vector(sp_rad.length()/2.0f), 16, GL_LINE_LOOP);
		}

		//render current object
		/*glLineWidth(linesize*bg_oversize);
		glPointSize(pointsize*bg_oversize);
		glColor4f(background_fontcolour.red()/255.0, background_fontcolour.blue()/255.0, background_fontcolour.green()/255.0,1.0);
		if(current_measure_drawmode==0) glBegin(GL_POINTS);
		else if(current_measure_drawmode==1) glBegin(GL_LINES);
		else if(current_measure_drawmode==2) glBegin(GL_LINE_STRIP);
		else if(current_measure_drawmode==3) glBegin(GL_LINE_LOOP);
		else if(current_measure_drawmode==4) glBegin(GL_LINE_LOOP);
		for(int iii=0; iii<current_measure_points.size(); iii++)
		{
			v = current_measure_points[iii]-(offset*current_normals[iii]);
			glVertex3fv(&v.x);
		}
		glEnd();*/
/*
		glLineWidth(linesize);
		glPointSize(pointsize);
		glColor4f(1.0,0,0,1);
		if(current_measure_drawmode==1) glBegin(GL_LINES);
		else if(current_measure_drawmode==2) glBegin(GL_LINE_STRIP);
		else if(current_measure_drawmode==3) glBegin(GL_LINE_LOOP);
		else if(current_measure_drawmode==4) glBegin(GL_LINE_LOOP);
		for(int iii=0; iii<current_measure_points.size(); iii++)
		{
			v = current_measure_points[iii]-(offset*current_normals[iii]);
			glVertex3fv(&v.x);
		}
		glEnd();
		for(int iii=0; iii<current_measure_points.size(); iii++)
		{
			if(iii==current_measure_vertindex) glColor4f(1,1,0,1);
			else glColor4f(background_fontcolour.red()/255.0, background_fontcolour.blue()/255.0, background_fontcolour.green()/255.0,1.0); //glColor4f(1.0,0,0,1);

			glBegin(GL_POINTS);
			v = current_measure_points[iii]-(offset*current_normals[iii]);
			glVertex3fv(&v.x);
			glEnd();
	}
	}

	//=================================================================================================
	// NOT SELECTED / NOT ACTIVE

	glColor4f(background_fontcolour.red()/255.0, background_fontcolour.green()/255.0, background_fontcolour.blue()/255.0,1);
	for(int i=0; i<measure_objects.size(); i++)
	{
		if(current_measure_index!=i)
		{
			//render triangles
			glLineWidth(linesize);
			if(measure_objects_drawmode[i]==4 && !measure_objects[i].empty() && !measure_triangles[i].empty())
			{
				glEnable(GL_BLEND);
				glColor4f(1,1,0,1);
				int numbtris = measure_triangles[i].size()/3;
				for(int ii=0; ii<numbtris; ii++)
				{
					glBegin(GL_LINE_LOOP); //GL_TRIANGLES
						v = measure_objects[i][(int)measure_triangles[i][3*ii+0]]-(offset*measure_normals[i][(int)measure_triangles[i][3*ii+0]]);
						glVertex3fv(&v.x);
						v = measure_objects[i][(int)measure_triangles[i][3*ii+1]]-(offset*measure_normals[i][(int)measure_triangles[i][3*ii+1]]);
						glVertex3fv(&v.x);
						v = measure_objects[i][(int)measure_triangles[i][3*ii+2]]-(offset*measure_normals[i][(int)measure_triangles[i][3*ii+2]]);
						glVertex3fv(&v.x);
					glEnd();
				}
				glDisable(GL_BLEND);
			}

			//render our spheres
			if(measure_objects_drawmode[i]==5 && measure_objects[i].size()==2)
			{
				Vector sp_cen = (measure_objects[i][0]+measure_objects[i][1])*0.5f-(offset*measure_normals[i][0]);
				Vector sp_rad = measure_objects[i][0]-measure_objects[i][1];
				render_sphere(sp_cen, Vector(sp_rad.length()/2.0f), 16, GL_LINE_LOOP);
			}

			//render objects
			/*glLineWidth(linesize*bg_oversize);
			glPointSize(pointsize*bg_oversize);
//			glColor4f(background_fontcolour.red()/255.0,  background_fontcolour.green()/255.0,background_fontcolour.blue()/255.0,1);
			glColor3f(1,1,0);
			if(measure_objects_drawmode[i]==1) glBegin(GL_LINES);
			else if(measure_objects_drawmode[i]==2) glBegin(GL_LINE_STRIP);
			else if(measure_objects_drawmode[i]==3) glBegin(GL_LINE_LOOP);
			else if(measure_objects_drawmode[i]==4) glBegin(GL_LINE_LOOP);
			for(int j=0; j<measure_objects[i].size(); j++)
			{
				v = measure_objects[i][j]-(offset*measure_normals[i][j]);
				glVertex3fv(&v.x);
			}
			glEnd();*/
/*
			glLineWidth(linesize);
			glPointSize(pointsize);
			//glColor4f(background_fontcolour.red()/255.0,  background_fontcolour.green()/255.0,background_fontcolour.blue()/255.0,1);
			glColor3f(1,1,0);
			if(measure_objects_drawmode[i]==0) glBegin(GL_POINTS);
			else if(measure_objects_drawmode[i]==1) glBegin(GL_LINES);
			else if(measure_objects_drawmode[i]==2) glBegin(GL_LINE_STRIP);
			else if(measure_objects_drawmode[i]==3) glBegin(GL_LINE_LOOP);
			else if(measure_objects_drawmode[i]==4) glBegin(GL_LINE_LOOP);
			for(int j=0; j<measure_objects[i].size(); j++)
			{
				v = measure_objects[i][j]-(offset*measure_normals[i][j]);
				glVertex3fv(&v.x);
			}
			glEnd();
			//glColor4f(background_colour.red()/255.0, background_colour.blue()/255.0, background_colour.green()/255.0,1);
			glBegin(GL_POINTS);
			for(int j=0; j<measure_objects[i].size(); j++)
			{
				v = measure_objects[i][j]-(offset*measure_normals[i][j]);
				glVertex3fv(&v.x);
			}
			glEnd();
		}
	}
*/
	//=================================================================================================

	glPointSize(1.0);
	glLineWidth(1.0);
	glEnable(GL_LIGHTING);
	//glEnable(GL_BLEND);

	//glDisable(GL_LINE_STIPPLE);
	//glDisable(GL_POLYGON_OFFSET_FILL);
	glPopMatrix();
}
void VolumeRender::render_ellipsoid(Vector c,Vector r,  Matrix4x4* rotmat, int n, GLenum drawmode)
{
	int i,j;
	double theta1,theta2,theta3;
	Vector rr = Vector(1.0, 1.0, 1.0);
	Vector e,p, p1;

	for (j=0;j<n;j++) 
	{
		theta1 = j * TWOPI / n - (PI/2.0);
		theta2 = (j + 1) * TWOPI / n - (PI/2.0);

		glBegin(drawmode);
		//glBegin(GL_QUADS);
		//glBegin(GL_POINTS);
		for (i=0;i<=n;i++) 
		{
			theta3 = i * TWOPI / n;

			e.x = cos(theta2) * cos(theta3);
			e.y = sin(theta2);
			e.z = cos(theta2) * sin(theta3);

			//generate point on unit sphere
			p = r*e;
			
			//transform it to our ellipsoid
			p1 = *rotmat*p;

			//apply the centre translation
			p1 = c + p1;

			glNormal3f(e.x,e.y,e.z);
			glTexCoord2f(i/(double)n,2*(j+1)/(double)n);
			glVertex3fv(&p1.x);

			e.x = cos(theta1) * cos(theta3);
			e.y = sin(theta1);
			e.z = cos(theta1) * sin(theta3);

			//generate point on unit sphere
			p = r*e;

			//transform it to our ellipsoid
			p1 = *rotmat*p;

			//apply the centre translation
			p1 = c + p1;

			glNormal3f(e.x,e.y,e.z);
			glTexCoord2f(i/(double)n,2*j/(double)n);
			glVertex3fv(&p1.x);
			
		}
		glEnd();
	}
}
//=================================================================================================================================
void VolumeRender::reset_transfer_function_parameters(int _r_tmin, int _r_tmax, int _g_tmin, int _g_tmax, int _b_tmin, int _b_tmax, int _ra_tmin, int _ra_tmax, int _ga_tmin, int _ga_tmax, int _ba_tmin, int _ba_tmax,
													  int _r_bright, int _r_cont, int _g_bright, int _g_cont, int _b_bright, int _b_cont, int _ra_bright, int _ra_cont, int _ga_bright, int _ga_cont, int _ba_bright, int _ba_cont,
													  bool _inv_r,	bool _inv_g, bool _inv_b, bool _inv_ra, bool _inv_ga, bool _inv_ba)
{
	r_tmax = _r_tmax;
	r_tmin = _r_tmin;
	g_tmax = _g_tmax;
	g_tmin = _g_tmin;
	b_tmax = _b_tmax;
	b_tmin = _b_tmin;
	ra_tmax = _ra_tmax;
	ra_tmin = _ra_tmin;
	ga_tmax = _ga_tmax;
	ga_tmin = _ga_tmin;
	ba_tmax = _ba_tmax;
	ba_tmin = _ba_tmin;
	r_bright = _r_bright;
	r_cont = _r_cont;
	g_bright = _g_bright;
	g_cont = _g_cont;
	b_bright = _b_bright;
	b_cont = _b_cont;
	ra_bright = _ra_bright;
	ra_cont = _ra_cont;
	ga_bright = _ga_bright;
	ga_cont = _ga_cont;
	ba_bright = _ba_bright;
	ba_cont = _ba_cont;
	inv_r = _inv_r;
	inv_g = _inv_g;
	inv_b = _inv_b;
	inv_ra = _inv_ra;
	inv_ga = _inv_ga;
	inv_ba = _inv_ba;

}
void VolumeRender::apply_transfer_function(const vector<Vector>& tfunc_curvepts, float graphsize, float border, int mode)
{		
	//transform our brightness & contranst
	//coefficents to a suitable range.
	float K_os;
	float K_oe;
	if(mode == 1)
	{
		K_os = (float)r_bright/100.0;
		K_oe = (float)r_cont/100.0;
	}
	else if(mode == 2)
	{
		K_os = (float)ra_bright/100.0;
		K_oe = (float)ra_cont/100.0;
	}
	else if(mode == 3)
	{
		K_os = (float)r_bright/100.0;
		K_oe = (float)r_cont/100.0;
	}
	else if( mode == 6)
	{
		K_os = (float)ra_bright/100.0;
		K_oe = (float)ra_cont/100.0;
	}
	else if(mode == 4)
	{
		K_os = (float)g_bright/100.0;
		K_oe = (float)g_cont/100.0;
	}
	else if(mode == 7)
	{
		K_os = (float)ga_bright/100.0;
		K_oe = (float)ga_cont/100.0;
	}
	else if(mode == 5)
	{		
		K_os = (float)b_bright/100.0;
		K_oe = (float)b_cont/100.0;
	}
	else if(mode == 8)
	{		
		K_os = (float)ba_bright/100.0;
		K_oe = (float)ba_cont/100.0;
	}

	int value;
	int index_r, index_g, index_b;
	for(int i =0; i<256; i++)
	{
		index_r = 3*i;
		index_g = 3*i+1;
		index_b = 3*i+2;

		//get the value from our bspline curve
		//transform value to 0 -> 255 range.
		//printf("%d %d\n", 255-(int)(tfunc_curvepts[i].y+0.5), i);
		value = 255-(int)(tfunc_curvepts[i].y+0.5);
		
		//apply brightness & contrast
		value = pow((K_os*value),K_oe);

		//clamp value to 0->255
		if(value<0) value = 0;
		if(value>255) value = 255;

		if(inv_r || inv_ra || inv_g || inv_ga || inv_b || inv_ba) 
			value = 255-value;

		//Intensity
		if(mode==1)
		{
			//invert
			//if(inv_l) value = 255-value;

			//keep a backup of the unthersholded table.
			backup_rgb_tfunc[index_r] = 
			backup_rgb_tfunc[index_g] = 
			backup_rgb_tfunc[index_b] = value;
			
			//threshold the value
			if(i<=r_tmin) value = 0;
			else if(i>r_tmax) value = 0;

			//printf("i: %d v: %d\n", i, value);

			rgb_tfunc[index_r] = 
			rgb_tfunc[index_g] = 
			rgb_tfunc[index_b] = value;
		}
		//Alpha
		else if(mode==2)
		{
			//invert
			//if(inv_la) value = 255-value;

			//keep a backup of the unthersholded table.
			backup_ragaba_tfunc[index_r] = 
			backup_ragaba_tfunc[index_g] = 
			backup_ragaba_tfunc[index_b] = value;

			//threshold the value
			if(i<=ra_tmin) value = 0;
			else if(i>ra_tmax) value = 0;
			 
			//printf("i: %d v: %d\n", i, value);

			ragaba_tfunc[index_r] = 
			ragaba_tfunc[index_g] = 
			ragaba_tfunc[index_b] = value;
		}
		//R
		else if(mode==3)
		{
			//invert
			//if(inv_r) value = 255-value;

			//keep a backup of the unthersholded table.
			backup_rgb_tfunc[index_r] = value;

			//threshold the value
			if(i<=r_tmin) value = 0;
			else if(i>r_tmax) value = 0;
			
			rgb_tfunc[index_r] = value;
		}
		//G
		else if(mode==4)
		{
			//invert
			//if(inv_g) value = 255-value;

			//keep a backup of the unthersholded table.
			backup_rgb_tfunc[index_g] = value;

			//threshold the value
			if(i<=g_tmin) value = 0;
			else if(i>g_tmax) value = 0;
			
			//invert
			if(inv_g) value = 255-value;

			rgb_tfunc[index_g] = value;
		}
		//B
		else if(mode==5)
		{
			//invert
			//if(inv_b) value = 255-value;

			//keep a backup of the unthersholded table.
			backup_rgb_tfunc[index_b] = value;

			//threshold the value
			if(i<=b_tmin) value = 0;
			else if(i>b_tmax) value = 0;
			
			rgb_tfunc[index_b] = value;
		}
		//RA
		else if(mode==6)
		{
			//invert
			//if(inv_ra) value = 255-value;

			//keep a backup of the unthersholded table.
			backup_ragaba_tfunc[index_r] = value;

			//threshold the value
			if(i<=ra_tmin) value = 0;
			else if(i>ra_tmax) value = 0;

			ragaba_tfunc[index_r] = value;
		}
		//GA
		else if(mode==7)
		{
			//invert
			//if(inv_ga) value = 255-value;

			//keep a backup of the unthersholded table.
			backup_ragaba_tfunc[index_g] = value;

			//threshold the value
			if(i<=ga_tmin) value = 0;
			else if(i>ga_tmax) value = 0;

			ragaba_tfunc[index_g] = value;
		}
		//BA
		else if(mode==8)
		{
			//invert
			//if(inv_ba) value = 255-value;

			//keep a backup of the unthersholded table.
			backup_ragaba_tfunc[index_b] = value;

			//threshold the value
			if(i<=ba_tmin) value = 0;
			else if(i>ba_tmax) value = 0;

			ragaba_tfunc[index_b] = value;
		}	
	}

	load_1DLookupTables();
	build_histogram();
}

void VolumeRender::apply_transfer_function_all(const vector<Vector>& r_tfunc_curvepts,  const vector<Vector>& g_tfunc_curvepts,  const vector<Vector>& b_tfunc_curvepts, 
											   const vector<Vector>& ra_tfunc_curvepts, const vector<Vector>& ga_tfunc_curvepts, const vector<Vector>& ba_tfunc_curvepts,
											   float graphsize, float border)
{		
	//transform our brightness & contranst
	//coefficents to a suitable range.
	float r_K_os, g_K_os, b_K_os, ra_K_os, ga_K_os, ba_K_os;
	float r_K_oe, g_K_oe, b_K_oe, ra_K_oe, ga_K_oe, ba_K_oe;
	r_K_os = (float)r_bright/100.0;
	r_K_oe = (float)r_cont/100.0;
	ra_K_os = (float)ra_bright/100.0;
	ra_K_oe = (float)ra_cont/100.0;
	g_K_os = (float)g_bright/100.0;
	g_K_oe = (float)g_cont/100.0;
	ga_K_os = (float)ga_bright/100.0;
	ga_K_oe = (float)ga_cont/100.0;
	b_K_os = (float)b_bright/100.0;
	b_K_oe = (float)b_cont/100.0;
	ba_K_os = (float)ba_bright/100.0;
	ba_K_oe = (float)ba_cont/100.0;

	//storage for our lookup values
	int r_value, g_value, b_value, ra_value, ga_value, ba_value;
	
	//storage for our indices
	int r_index, g_index, b_index;

	//now go through each element of our lookup
	for(int i =0; i<r_tfunc_curvepts.size(); i++)
	{
		//work out our indices
		r_index = 3*i;
		g_index = 3*i+1;
		b_index = 3*i+2;

		//get the value from our bspline curve
		//transform value to 0 -> 255 range.
		//printf("%f\n", r_tfunc_curvepts[i].y);

		r_value = 255-(int)(r_tfunc_curvepts[i].y+0.5);
		g_value = 255-(int)(g_tfunc_curvepts[i].y+0.5);
		b_value = 255-(int)(b_tfunc_curvepts[i].y+0.5);
		ra_value = 255-(int)(ra_tfunc_curvepts[i].y+0.5);
		ga_value = 255-(int)(ga_tfunc_curvepts[i].y+0.5);
		ba_value = 255-(int)(ba_tfunc_curvepts[i].y+0.5);
		
		//apply brightness & contrast
		r_value = pow((r_K_os*r_value),r_K_oe);
		ra_value = pow((ra_K_os*ra_value),ra_K_oe);
		g_value = pow((g_K_os*g_value),g_K_oe);
		ga_value = pow((ga_K_os*ga_value),ga_K_oe);
		b_value = pow((b_K_os*b_value),b_K_oe);
		ba_value = pow((ba_K_os*ba_value),ba_K_oe);

		//clamp of values to 0->255
		if(r_value<0) r_value = 0;
		if(r_value>255) r_value = 255;
		if(ra_value<0) ra_value = 0;
		if(ra_value>255) ra_value = 255;
		if(g_value<0) g_value = 0;
		if(g_value>255) g_value = 255;
		if(ga_value<0) ga_value = 0;
		if(ga_value>255) ga_value = 255;
		if(b_value<0) b_value = 0;
		if(b_value>255) b_value = 255;
		if(ba_value<0) ba_value = 0;
		if(ba_value>255) ba_value = 255;

		//invert
		if(inv_r || inv_ra || inv_g || inv_ga || inv_b || inv_ba)  
		{	  
			r_value = 255-r_value;
			ra_value = 255-ra_value;
			g_value = 255-g_value;
			ga_value = 255-ga_value;
			b_value = 255-b_value;
			ba_value = 255-ba_value;
		}

		//keep a backup of the unthersholded lookup table.
		backup_rgb_tfunc[r_index] = r_value;
		backup_rgb_tfunc[g_index] = g_value;
		backup_rgb_tfunc[b_index] = b_value;
		backup_ragaba_tfunc[r_index] = ra_value;
		backup_ragaba_tfunc[g_index] = ga_value;
		backup_ragaba_tfunc[b_index] = ba_value;

		//threshold the value
		if(i<=r_tmin) r_value = 0;
		else if(i>r_tmax) r_value = 0;
		if(i<=ra_tmin) ra_value = 0;
		else if(i>ra_tmax) ra_value = 0;
		if(i<=g_tmin) g_value = 0;
		else if(i>g_tmax) g_value = 0;
		if(i<=ga_tmin) ga_value = 0;
		else if(i>ga_tmax) ga_value = 0;
		if(i<=b_tmin) b_value = 0;
		else if(i>b_tmax) b_value = 0;
		if(i<=ba_tmin) ba_value = 0;
		else if(i>ba_tmax) ba_value = 0;

		//printf("i: %d v: %d\n", i, r_value);

		//store the value		
		rgb_tfunc[r_index] = r_value;
		rgb_tfunc[g_index] = g_value;
		rgb_tfunc[b_index] = b_value;
		ragaba_tfunc[r_index] = ra_value;
		ragaba_tfunc[g_index] = ga_value;
		ragaba_tfunc[b_index] = ba_value;	
	}

	load_1DLookupTables();
	build_histogram();
}
void VolumeRender::apply_brightcontrast(int mode, int b, int c)
{
	//transform our brightness & contranst
	//coefficents to a suitable range.
	float K_os;
	float K_oe;
	int index, value;
	if(mode == 1)
	{
		l_bright =b;
		l_cont =c;
		r_bright =b;
		r_cont =c;
		g_bright =b;
		g_cont =c;
		b_bright =b;
		b_cont =c;

		K_os = (float)l_bright/100.0;
		K_oe = (float)l_cont/100.0;

		for(int i=0; i<256; i++)
		{
			index = 3*i;

			//LUMINANCE
			value = backup_rgb_tfunc[index];
		
			//apply brightness & contrast
			value = pow((K_os*value),K_oe);

			//clamp of values to 0->255
			if(value<0) value = 0;
			if(value>255) value = 255;

			//threshold the value
			if(i<=l_tmin)
			{
				value = 0;
			}
			else if(i>l_tmax)
			{
				value = 0;
			}

			rgb_tfunc[index] = 
			rgb_tfunc[index+1] = 
			rgb_tfunc[index+2] = value;
		}
	}
	else if(mode == 2)
	{
		la_bright =b;
		la_cont =c;
		ra_bright =b;
		ra_cont =c;
		ga_bright =b;
		ga_cont =c;
		ba_bright =b;
		ba_cont =c;

		K_os = (float)la_bright/100.0;
		K_oe = (float)la_cont/100.0;

		for(int i=0; i<256; i++)
		{
			index = 3*i;

			//ALPHA
			value = backup_ragaba_tfunc[index];

			//apply brightness & contrast
			value = pow((K_os*value),K_oe);

			//clamp of values to 0->255
			if(value<0) value = 0;
			if(value>255) value = 255;

			//threshold the value
			if(i<=la_tmin)
			{
				value = 0;
			}
			else if(i>la_tmax)
			{
				value = 0;
			}

			ragaba_tfunc[index] = value;
			ragaba_tfunc[index+1] = value;
			ragaba_tfunc[index+2] = value;
		}	
	}
	else if(mode == 3)
	{
		r_bright =b;
		r_cont =c;

		K_os = (float)r_bright/100.0;
		K_oe = (float)r_cont/100.0;

		for(int i=0; i<256; i++)
		{
			index = 3*i;

			//RED
			value = backup_rgb_tfunc[index];

			//apply brightness & contrast
			value = pow((K_os*value),K_oe);

			//clamp of values to 0->255
			if(value<0) value = 0;
			if(value>255) value = 255;

			//threshold the value
			if(i<=r_tmin)
			{
				value = 0;
			}
			else if(i>r_tmax)
			{
				value = 0;
			}

			rgb_tfunc[index] = value;
		}
	}
	else if(mode == 6)
	{
		ra_bright =b;
		ra_cont =c;

		K_os = (float)ra_bright/100.0;
		K_oe = (float)ra_cont/100.0;

		for(int i=0; i<256; i++)
		{
			index = 3*i;

			//RED ALPHA
			value = backup_ragaba_tfunc[index];

			//apply brightness & contrast
			value = pow((K_os*value),K_oe);

			//clamp of values to 0->255
			if(value<0) value = 0;
			if(value>255) value = 255;

			//threshold the value
			if(i<=ra_tmin)
			{
				value = 0;
			}
			else if(i>ra_tmax)
			{
				value = 0;
			}

			ragaba_tfunc[index] = value;
		}
	}
	else if(mode == 4)
	{
		g_bright = b;
		g_cont = c;

		K_os = (float)g_bright/100.0;
		K_oe = (float)g_cont/100.0;

		for(int i=0; i<256; i++)
		{
			index = 3*i+1;

			//GREEN
			value = backup_rgb_tfunc[index];

			//apply brightness & contrast
			value = pow((K_os*value),K_oe);

			//clamp of values to 0->255
			if(value<0) value = 0;
			if(value>255) value = 255;

			//threshold the value
			if(i<=g_tmin)
			{
				value = 0;
			}
			else if(i>g_tmax)
			{
				value = 0;
			}

			rgb_tfunc[index] = value;
		}
	}
	else if(mode == 7)
	{
		ga_bright = b;
		ga_cont = c;

		K_os = (float)ga_bright/100.0;
		K_oe = (float)ga_cont/100.0;

		for(int i=0; i<256; i++)
		{
			index = 3*i+1;

			//GREEN ALPHA
			value = backup_ragaba_tfunc[index];

			//apply brightness & contrast
			value = pow((K_os*value),K_oe);

			//clamp of values to 0->255
			if(value<0) value = 0;
			if(value>255) value = 255;

			//threshold the value
			if(i<=ga_tmin)
			{
				value = 0;
			}
			else if(i>ga_tmax)
			{
				value = 0;
			}

			ragaba_tfunc[index] = value;
		}
	}
	else if(mode == 5)
	{		
		b_bright = b;
		b_cont = c;

		K_os = (float)b_bright/100.0;
		K_oe = (float)b_cont/100.0;

		for(int i=0; i<256; i++)
		{
			index = 3*i+2;

			//BLUE
			value = backup_rgb_tfunc[index];

			//apply brightness & contrast
			value = pow((K_os*value),K_oe);

			//clamp of values to 0->255
			if(value<0) value = 0;
			if(value>255) value = 255;

			//threshold the value
			if(i<=b_tmin)
			{
				value = 0;
			}
			else if(i>b_tmax)
			{
				value = 0;
			}

			rgb_tfunc[index] = value;
		}
	}
	else if(mode == 8)
	{		
		ba_bright = b;
		ba_cont = c;

		K_os = (float)ba_bright/100.0;
		K_oe = (float)ba_cont/100.0;

		for(int i=0; i<256; i++)
		{
			index = 3*i+2;

			//BLUE ALPHA
			value = backup_ragaba_tfunc[index];

			//apply brightness & contrast
			value = pow((K_os*value),K_oe);

			//clamp of values to 0->255
			if(value<0) value = 0;
			if(value>255) value = 255;

			//threshold the value
			if(i<=ba_tmin)
			{
				value = 0;
			}
			else if(i>ba_tmax)
			{
				value = 0;
			}

			ragaba_tfunc[index] = value;
		}
	}

	build_histogram();
	load_1DLookupTables();
}

void VolumeRender::apply_invert16(int mode, int togglestate)
{
		//storage for our indices
		int r_index, g_index, b_index;
		
		for(int i =0; i<256; i++)
		{
			r_index = 3*i;
			g_index = 3*i+1;
			b_index = 3*i+2;

			if(mode==1)
			{
				rgb_tfunc[r_index] = 255-rgb_tfunc[r_index];
				rgb_tfunc[g_index] = 255-rgb_tfunc[g_index];
				rgb_tfunc[b_index] = 255-rgb_tfunc[b_index];
			}
			else
			{
				ragaba_tfunc[r_index] = 255-ragaba_tfunc[r_index];
				ragaba_tfunc[g_index] = 255-ragaba_tfunc[g_index];
				ragaba_tfunc[b_index] = 255-ragaba_tfunc[b_index];	
			}
		}
		
		build_histogram();
		load_1DLookupTables();
}

void VolumeRender::apply_invert(int mode, int togglestate)
{
		inv_l = togglestate;
		inv_la = togglestate;
		inv_r = togglestate;
		inv_g = togglestate;
		inv_b = togglestate;
		inv_ra = togglestate;
		inv_ga = togglestate;
		inv_ba = togglestate;
}
void VolumeRender::apply_threshold(int mode, int tmin, int tmax)
{
	int value;
	int index;

	float K_os;
	float K_oe;
	if(mode == 1)
	{
		l_tmin =tmin;
		l_tmax =tmax;
		r_tmin =tmin;
		r_tmax =tmax;
		g_tmin =tmin;
		g_tmax =tmax;
		b_tmin =tmin;
		b_tmax =tmax;

		K_os = (float)r_bright/100.0;
		K_oe = (float)r_cont/100.0;

		for(int i=0; i<256; i++)
		{
			index = 3*i;

			//LUMINANCE
			value = backup_rgb_tfunc[index];

			//apply brightness & contrast
			value = pow((K_os*value),K_oe);

			//clamp of values to 0->255
			if(value<0) value = 0;
			if(value>255) value = 255;

			//threshold the value
			if(i<=r_tmin)
			{
				value = 0;
			}
			else if(i>r_tmax)
			{
				value = 0;
			}

			rgb_tfunc[index] = 
			rgb_tfunc[index+1] = 
			rgb_tfunc[index+2] = value;
		}
	}
	else if(mode == 2)
	{
		la_tmin =tmin;
		la_tmax =tmax;
		ra_tmin =tmin;
		ra_tmax =tmax;
		ga_tmin =tmin;
		ga_tmax =tmax;
		ba_tmin =tmin;
		ba_tmax =tmax;

		K_os = (float)ra_bright/100.0;
		K_oe = (float)ra_cont/100.0;

		for(int i=0; i<256; i++)
		{
			index = 3*i;

			//ALPHA
			value = backup_ragaba_tfunc[index];

			//apply brightness & contrast
			value = pow((K_os*value),K_oe);

			//clamp of values to 0->255
			if(value<0) value = 0;
			if(value>255) value = 255;

			//threshold the value
			if(i<=ra_tmin)
			{
				value = 0;
			}
			else if(i>ra_tmax)
			{
				value = 0;
			}

			ragaba_tfunc[index] = value;
			ragaba_tfunc[index+1] = value;
			ragaba_tfunc[index+2] = value;
		}
	}	
	else if(mode == 3)
	{
		r_tmin =tmin;
		r_tmax =tmax;

		K_os = (float)r_bright/100.0;
		K_oe = (float)r_cont/100.0;

		for(int i=0; i<256; i++)
		{
			index = 3*i;

			//RED
			value = backup_rgb_tfunc[index];

			//apply brightness & contrast
			value = pow((K_os*value),K_oe);

			//clamp of values to 0->255
			if(value<0) value = 0;
			if(value>255) value = 255;

			//threshold the value
			if(i<=r_tmin)
			{
				value = 0;
			}
			else if(i>r_tmax)
			{
				value = 0;
			}

			rgb_tfunc[index] = value;
		}
	}
	else if(mode == 6)
	{
		ra_tmin =tmin;
		ra_tmax =tmax;

		K_os = (float)ra_bright/100.0;
		K_oe = (float)ra_cont/100.0;

		for(int i=0; i<256; i++)
		{
			index = 3*i;

			//RED ALPHA
			value = backup_ragaba_tfunc[index];

			//apply brightness & contrast
			value = pow((K_os*value),K_oe);

			//clamp of values to 0->255
			if(value<0) value = 0;
			if(value>255) value = 255;

			//threshold the value
			if(i<=ra_tmin)
			{
				value = 0;
			}
			else if(i>ra_tmax)
			{
				value = 0;
			}

			ragaba_tfunc[index] = value;
		}
	}
	else if(mode == 4)
	{
		g_tmin =tmin;
		g_tmax =tmax;

		K_os = (float)g_bright/100.0;
		K_oe = (float)g_cont/100.0;

		for(int i=0; i<256; i++)
		{
			index = 3*i+1;

			//GREEN
			value = backup_rgb_tfunc[index];

			//apply brightness & contrast
			value = pow((K_os*value),K_oe);

			//clamp of values to 0->255
			if(value<0) value = 0;
			if(value>255) value = 255;

			//threshold the value
			if(i<=g_tmin)
			{
				value = 0;
			}
			else if(i>g_tmax)
			{
				value = 0;
			}

			rgb_tfunc[index] = value;
		}
	}
	else if(mode == 7)
	{
		ga_tmin =tmin;
		ga_tmax =tmax;

		K_os = (float)ga_bright/100.0;
		K_oe = (float)ga_cont/100.0;

		for(int i=0; i<256; i++)
		{
			index = 3*i+1;

			//GREEN ALPHA
			value = backup_ragaba_tfunc[index];

			//apply brightness & contrast
			value = pow((K_os*value),K_oe);

			//clamp of values to 0->255
			if(value<0) value = 0;
			if(value>255) value = 255;

			//threshold the value
			if(i<=ga_tmin)
			{
				value = 0;
			}
			else if(i>ga_tmax)
			{
				value = 0;
			}

			ragaba_tfunc[index] = value;
		}
	}
	else if(mode == 5)
	{
		b_tmin =tmin;
		b_tmax =tmax;

		K_os = (float)b_bright/100.0;
		K_oe = (float)b_cont/100.0;

		for(int i=0; i<256; i++)
		{
			index = 3*i+2;

			//BLUE
			value = backup_rgb_tfunc[index];

			//apply brightness & contrast
			value = pow((K_os*value),K_oe);

			//clamp of values to 0->255
			if(value<0) value = 0;
			if(value>255) value = 255;

			//threshold the value
			if(i<=b_tmin)
			{
				value = 0;
			}
			else if(i>b_tmax)
			{
				value = 0;
			}

			rgb_tfunc[index] = value;
		}
	}
	else if(mode == 8)
	{
		ba_tmin =tmin;
		ba_tmax =tmax;

		K_os = (float)ba_bright/100.0;
		K_oe = (float)ba_cont/100.0;

		for(int i=0; i<256; i++)
		{
			index = 3*i+2;

			//BLUE ALPHA
			value = backup_ragaba_tfunc[index];

			//apply brightness & contrast
			value = pow((K_os*value),K_oe);

			//clamp of values to 0->255
			if(value<0) value = 0;
			if(value>255) value = 255;

			//threshold the value
			if(i<=ba_tmin)
			{
				value = 0;
			}
			else if(i>ba_tmax)
			{
				value = 0;
			}

			ragaba_tfunc[index] = value;
		}
	}

	load_1DLookupTables();
	build_histogram();
}
