
uniform int channel;
uniform sampler3D volumeTexture;
uniform sampler2D RGBlookupTexture;
uniform sampler2D RAGABAlookupTexture;
varying vec3 dir;
varying vec3 V;
varying vec3 V1;

void main()
{	

	vec3 texcoord = gl_TexCoord[0].stp; //+ texture2D(noiseTexture, dir*V/32);

	//get the texture rgb data
	float texValue;
	texValue = texture3D(volumeTexture, texcoord).x;
/*	
	//get our coord in screen space (nb) screen space is always -128 -> 128
	vec3 voxelcoord = 128.0*(vec3(gl_TexCoord[0].s, gl_TexCoord[0].t, gl_TexCoord[0].p))-64.0;

	vec4 clip0 = gl_ClipPlane[0]*gl_TextureMatrixInverse[0];
	float side0 = clip0.x*voxelcoord.x + clip0.y*voxelcoord.y + clip0.z*voxelcoord.z + clip0.w;

	vec4 clip1 = gl_ClipPlane[1]*gl_TextureMatrixInverse[0];
	float side1 = clip1.x*voxelcoord.x + clip1.y*voxelcoord.y + clip1.z*voxelcoord.z + clip1.w;

	vec4 clip2 = gl_ClipPlane[2]*gl_TextureMatrixInverse[0];
	float side2 = clip2.x*voxelcoord.x + clip2.y*voxelcoord.y + clip2.z*voxelcoord.z + clip2.w;

	vec4 clip3 = gl_ClipPlane[3]*gl_TextureMatrixInverse[0];
	float side3 = clip3.x*voxelcoord.x + clip3.y*voxelcoord.y + clip3.z*voxelcoord.z + clip3.w;

	vec4 clip4 = gl_ClipPlane[4]*gl_TextureMatrixInverse[0];
	float side4 = clip4.x*voxelcoord.x + clip4.y*voxelcoord.y + clip4.z*voxelcoord.z + clip4.w;

	vec4 clip5 = gl_ClipPlane[5]*gl_TextureMatrixInverse[0];
	float side5 = clip5.x*voxelcoord.x + clip5.y*voxelcoord.y + clip5.z*voxelcoord.z + clip5.w;
*/
	//==============================
	//APLY OUR TRANSFER FUNCTION
	//==============================
	//make sure we sample from centre of lookup table
	//float lookup_offset = (1.0/256.0/2.0);
	//texValue += lookup_offset;

	//get lookup table values
	//r,g,b,ra,ga,ba
	vec3 RGBlookupValue, RAGABAlookupValue;
	RGBlookupValue = RAGABAlookupValue = vec3(0.0);
	vec4 finalColour = vec4(0.0);

	if(channel==0)
	{
		RGBlookupValue.x = texture2D(RGBlookupTexture, vec2(texValue, 0.0)).x;
		RAGABAlookupValue.x = texture2D(RAGABAlookupTexture, vec2(texValue, 0.0)).x;
		finalColour = vec4(RGBlookupValue.x, 0.0, 0.0, RAGABAlookupValue.x);
	}
	else if(channel==1)
	{
		RGBlookupValue.y = texture2D(RGBlookupTexture, vec2(texValue, 0.0)).y;
		RAGABAlookupValue.y = texture2D(RAGABAlookupTexture, vec2(texValue, 0.0)).y;
		finalColour = vec4(0.0,RGBlookupValue.y,0.0, RAGABAlookupValue.y);
	}
	else if(channel==2)
	{
		RGBlookupValue.z = texture2D(RGBlookupTexture, vec2(texValue, 0.0)).z;
		RAGABAlookupValue.z = texture2D(RAGABAlookupTexture, vec2(texValue, 0.0)).z;
		finalColour = vec4(0.0, 0.0, RGBlookupValue.z, RAGABAlookupValue.z);
	}
	else if(channel==3)
	{
		RGBlookupValue.x = texture2D(RGBlookupTexture, vec2(texValue, 0.0)).x;
		RAGABAlookupValue.x = texture2D(RAGABAlookupTexture, vec2(texValue, 0.0)).x;
		finalColour = vec4(RGBlookupValue.x,RGBlookupValue.x,RGBlookupValue.x, RAGABAlookupValue.x);
	}


/*int clipped=0;
	if(side0>0)	clipped++;
	if(side1>0)	clipped++;
	if(side2>0)	clipped++;
	if(side3>0)	clipped++;
	if(side4>0)	clipped++;
	if(side5>0)	clipped++;
	if(clipped==6) finalColour.xyzw = vec4(0,0,0,0);
	*/
/*	if(side0<0) finalColour.xyzw = vec4(0,0,0,0);
	if(side1<0) finalColour.xyzw = vec4(0,0,0,0);
	if(side2<0) finalColour.xyzw = vec4(0,0,0,0);
	if(side3<0) finalColour.xyzw = vec4(0,0,0,0);
	if(side4<0) finalColour.xyzw = vec4(0,0,0,0);
	if(side5<0) finalColour.xyzw = vec4(0,0,0,0);
*/
/*	if(side0!=0) finalColour.xyzw = vec4(0,0,0,0);
	if(side1!=0) finalColour.xyzw = vec4(0,0,0,0);
	if(side2!=0) finalColour.xyzw = vec4(0,0,0,0);
	if(side3!=0) finalColour.xyzw = vec4(0,0,0,0);
	if(side4!=0) finalColour.xyzw = vec4(0,0,0,0);
	if(side5!=0) finalColour.xyzw = vec4(0,0,0,0);
*/
	//assing the colour to our final colour
	gl_FragColor = finalColour;	
}