
uniform int channel;
uniform sampler3D volumeTexture;
uniform sampler2D RGBlookupTexture;
uniform sampler2D RAGABAlookupTexture;
//uniform sampler2D noiseTexture;
/*
uniform vec3 cutplane1_norm, cutplane1_centre;
uniform vec3 cutplane2_norm, cutplane2_centre;
uniform vec3 cutplane3_norm, cutplane3_centre;
uniform vec3 cutplane4_norm, cutplane4_centre;
uniform vec3 cutplane5_norm, cutplane5_centre;
uniform vec3 cutplane6_norm, cutplane6_centre;
uniform bool red_clip, green_clip, blue_clip;

uniform bool silhouette_enable;
uniform float silhouette_amount;

uniform bool gooch_enable;
uniform float gooch_toneCont;               //Contribution of tone color
uniform float gooch_warmCol[3], gooch_coolCol[3];        //Warm and cool tone colors
*/

//uniform bool lighting_enable;

varying vec3 dir;
varying vec3 V;
varying vec3 V1;

void main()
{	

	vec3 texcoord = gl_TexCoord[0].stp; //+ texture2D(noiseTexture, dir*V/32);

	//get the texture rgb data
	float texValue;
	texValue = texture3D(volumeTexture, texcoord).x;
	//========================================
	//GET OUR VOXEL COORDINATE AND RGB VALUE
	//========================================
	//get our coord in screen space (nb) screen space is always -128 -> 128
	//vec3 voxelcoord = 256.0*(vec3(gl_TexCoord[0].s, gl_TexCoord[0].t, gl_TexCoord[0].p))-128.0;

	//==============================================
	//EVALUATE OUR NORMAL BY CENTRAL DIFFERENCE
	//==============================================
 /* 	vec4 normal;
	bool degenerate;
//	if(silhouette_enable==true || gooch_enable==true || lighting_enable==true)
//	{
		float stepsize	= 1.0/256.0;
		normal.x = (texture3D(volumeTexture, vec3(gl_TexCoord[0].s-stepsize, gl_TexCoord[0].t, gl_TexCoord[0].p)) - texture3D(volumeTexture, vec3(gl_TexCoord[0].s+stepsize, gl_TexCoord[0].t, gl_TexCoord[0].p))).x;
		normal.y = (texture3D(volumeTexture, vec3(gl_TexCoord[0].s, gl_TexCoord[0].t-stepsize, gl_TexCoord[0].p)) - texture3D(volumeTexture, vec3(gl_TexCoord[0].s, gl_TexCoord[0].t+stepsize, gl_TexCoord[0].p))).x;
		normal.z = (texture3D(volumeTexture, vec3(gl_TexCoord[0].s, gl_TexCoord[0].t, gl_TexCoord[0].p-stepsize)) - texture3D(volumeTexture, vec3(gl_TexCoord[0].s, gl_TexCoord[0].t, gl_TexCoord[0].p+stepsize))).x;
		
		float gradMag = length(normal);

		//We have to scale the gradient between -1 and 1
		//normal.rgb = normal.rgb*2.0 - 1.0;
		degenerate = texValue < .1;
		if(!degenerate)
		{
			normal.rgb = normalize(gl_NormalMatrix * normalize(normal.rgb));
		}
//	}*/

	//==============================
	//APLY OUR TRANSFER FUNCTION
	//==============================
	//make sure we sample from centre of lookup table
	float lookup_offset = (1.0/256.0/2.0);
	texValue += lookup_offset;

	//get lookup table values
	//r,g,b,ra,ga,ba
	vec3 RGBlookupValue, RAGABAlookupValue;
	RGBlookupValue = RAGABAlookupValue = vec3(0.0);
	vec4 finalColour;

	if(channel==0)
	{
		RGBlookupValue.x = texture2D(RGBlookupTexture, vec2(texValue, 0.5)).x;
		RAGABAlookupValue.x = texture2D(RAGABAlookupTexture, vec2(texValue, 0.5)).x;
		finalColour = vec4(RGBlookupValue.x,0.0,0.0, RAGABAlookupValue.x);
	}
	else if(channel==1)
	{
		RGBlookupValue.y = texture2D(RGBlookupTexture, vec2(texValue, 0.5)).y;
		RAGABAlookupValue.y = texture2D(RAGABAlookupTexture, vec2(texValue, 0.5)).y;
		finalColour = vec4(0.0,RGBlookupValue.y,0.0, RAGABAlookupValue.y);
	}
	else if(channel==2)
	{
		RGBlookupValue.z = texture2D(RGBlookupTexture, vec2(texValue, 0.5)).z;
		RAGABAlookupValue.z = texture2D(RAGABAlookupTexture, vec2(texValue, 0.5)).z;
		finalColour = vec4(0.0,0.0,RGBlookupValue.z, RAGABAlookupValue.z);
	}
	else if(channel==3)
	{
		RGBlookupValue.x = texture2D(RGBlookupTexture, vec2(texValue, 0.5)).x;
		RAGABAlookupValue.x = texture2D(RAGABAlookupTexture, vec2(texValue, 0.5)).x;
		finalColour = vec4(RGBlookupValue.x,RGBlookupValue.x,RGBlookupValue.x, RAGABAlookupValue.x);
	}

	//=============================
	//APPLY OUR LIGHTING
	//=============================
/*	vec3 L = normalize(gl_LightSource[0].position.xyz - V); 
	vec3 E = normalize(-V); // we are in Eye Coordinates, so EyePos is (0,0,0)
	vec3 R = normalize(-reflect(L, normal)); 

	vec3 E1 = normalize(-V1); // we are in Eye Coordinates, so EyePos is (0,0,0)
	float dotView = dot(E1, normal.xyz);

	//calculate Ambient Term:
	vec4 Iamb = gl_FrontLightProduct[0].ambient;

	//calculate Diffuse Term:
	vec4 Idiff = gl_FrontLightProduct[0].diffuse * max(dot(vec3(normal),L), 0.0);

	// calculate Specular Term:
	vec4 Ispec = max(dot(R,E),0.0);

	finalColour.rgb *=  (Iamb + Idiff + Ispec);
*/

	vec3 L = normalize(gl_LightSource[0].position.xyz - V);
	
	vec3 sampleL = texture3D(volumeTexture, vec3(texcoord+0.01*L)).x;
	vec3 n_l = (sampleL-texValue);

	vec3 diffuse = vec3(gl_FrontLightProduct[0].diffuse) * n_l;
	vec3 ambient = 

	finalColour.xyz += diffuse;
/*	//=============================
	//APPLY SILHOUTTE ENHANCEMENTS
	//=============================
	if(silhouette_enable==true)
	{
		vec3 E1 = normalize(-V1); // we are in Eye Coordinates, so EyePos is (0,0,0)
		float dotView = dot(E1, normal.xyz);

		if(!degenerate) finalColour.a += silhouette_amount*pow(1.0-abs(dotView),2.0);
	}

	//=============================
	//APPLY GOOCH LIGHTING
	//=============================
	if(gooch_enable==true)
	{
		//Calculate the diffuse contribution of the light
		float dotLight = dot(normalize(vec3(-gl_LightSource[0].position)), normal.rgb);

		//Calculate the correct color according to the Gooch shading model.
		//toneLight ranges from -1 to 1
		dotLight = dot(vec3(normal),L);
		
		vec3 warm = vec3(gooch_warmCol[0], gooch_warmCol[1], gooch_warmCol[2]);
		vec3 cool = vec3(gooch_coolCol[0], gooch_coolCol[1], gooch_coolCol[2]);

		finalColour.rgb += gooch_toneCont*(((1.0+dotLight)*.5)*warm + (1.0-((1.0+dotLight)*.5))*cool);
	}
	
	//float boundCont = 0.5;
//	float boundExp = silhouette_amount;
//	finalColour.a += silhouette_amount*pow(gradMag,boundExp);

//	float edgeExp = silhouette_amount;
//	float edgeThresh = 0.1 ;
//	float edgeVal = pow(1.0-abs(dotView),edgeExp);
//	if(edgeVal >= edgeThresh && !degenerate) finalColour.rgb = mix(finalColour.rgb, vec3(0.0,0.0,0.0), pow((edgeVal-edgeThresh)/(1.0-edgeThresh),4.0));
*/
	//=============================
	//APPLY LIGHTING
	//=============================
//	if(lighting_enable==true) 

	//finalColour.xyz = vec3(gl_FrontLightProduct[0].specular);

	//assing the colour to our final colour
	gl_FragColor = finalColour;	
}